/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import com.google.common.collect.ImmutableSet;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.solr.common.util.CommandOperation;
import org.apache.solr.common.util.Utils;
import org.apache.solr.common.util.ValidatingJsonMap;
import org.apache.solr.handler.admin.SecurityConfHandler;
import org.apache.solr.security.BasicAuthPlugin;
import org.apache.solr.security.ConfigEditablePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sha256AuthenticationProvider
implements ConfigEditablePlugin,
BasicAuthPlugin.AuthenticationProvider {
    private Map<String, String> credentials;
    private String realm;
    private Map<String, String> promptHeader;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final Set<String> supported_ops = ImmutableSet.of((Object)"set-user", (Object)"delete-user");

    static void putUser(String user, String pwd, Map credentials) {
        if (user == null || pwd == null) {
            return;
        }
        String val = Sha256AuthenticationProvider.getSaltedHashedValue(pwd);
        credentials.put(user, val);
    }

    public static String getSaltedHashedValue(String pwd) {
        SecureRandom r = new SecureRandom();
        byte[] salt = new byte[32];
        ((Random)r).nextBytes(salt);
        String saltBase64 = Base64.encodeBase64String((byte[])salt);
        String val = Sha256AuthenticationProvider.sha256(pwd, saltBase64) + " " + saltBase64;
        return val;
    }

    @Override
    public void init(Map<String, Object> pluginConfig) {
        this.realm = pluginConfig.containsKey("realm") ? (String)pluginConfig.get("realm") : "solr";
        this.promptHeader = Collections.unmodifiableMap(Collections.singletonMap("WWW-Authenticate", "Basic realm=\"" + this.realm + "\""));
        this.credentials = new LinkedHashMap<String, String>();
        Map users = (Map)pluginConfig.get("credentials");
        if (users == null) {
            log.debug("No users configured yet");
            return;
        }
        for (Map.Entry e : users.entrySet()) {
            String v = (String)e.getValue();
            if (v == null) {
                log.warn("user has no password {}", e.getKey());
                continue;
            }
            this.credentials.put((String)e.getKey(), v);
        }
    }

    @Override
    public boolean authenticate(String username, String password) {
        String[] ss;
        String cred = this.credentials.get(username);
        if (cred == null || cred.isEmpty()) {
            return false;
        }
        cred = cred.trim();
        String salt = null;
        if (cred.contains(" ") && (ss = cred.split(" ")).length > 1 && !ss[1].isEmpty()) {
            salt = ss[1];
            cred = ss[0];
        }
        return cred.equals(Sha256AuthenticationProvider.sha256(password, salt));
    }

    @Override
    public Map<String, String> getPromptHeaders() {
        return this.promptHeader;
    }

    public static String sha256(String password, String saltKey) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        if (saltKey != null) {
            digest.reset();
            digest.update(Base64.decodeBase64((String)saltKey));
        }
        byte[] btPass = digest.digest(password.getBytes(StandardCharsets.UTF_8));
        digest.reset();
        btPass = digest.digest(btPass);
        return Base64.encodeBase64String((byte[])btPass);
    }

    @Override
    public Map<String, Object> edit(Map<String, Object> latestConf, List<CommandOperation> commands) {
        for (CommandOperation cmd : commands) {
            if (!supported_ops.contains(cmd.name)) {
                cmd.unknownOperation();
                return null;
            }
            if (cmd.hasError()) {
                return null;
            }
            if ("delete-user".equals(cmd.name)) {
                List names = cmd.getStrs("");
                Map map = (Map)latestConf.get("credentials");
                if (map == null || !map.keySet().containsAll(names)) {
                    cmd.addError("No such user(s) " + names);
                    return null;
                }
                for (String name : names) {
                    map.remove(name);
                }
                return latestConf;
            }
            if (!"set-user".equals(cmd.name)) continue;
            Map<String, Object> map = SecurityConfHandler.getMapValue(latestConf, "credentials");
            Map kv = cmd.getDataMap();
            for (Map.Entry o : kv.entrySet()) {
                Map.Entry e = o;
                if (e.getKey() == null || e.getValue() == null) {
                    cmd.addError("name and password must be non-null");
                    return null;
                }
                Sha256AuthenticationProvider.putUser(String.valueOf(e.getKey()), String.valueOf(e.getValue()), map);
            }
        }
        return latestConf;
    }

    public ValidatingJsonMap getSpec() {
        return Utils.getSpec((String)"cluster.security.BasicAuth.Commands").getSpec();
    }
}

