(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/os/fdio#fdread__%
    (lambda (_raw143697_ _bytes143698_ _start143699_ _end143700_)
      (let _lp143702_ ()
        (let ((_r143706_
               (std/os/fdio#_read
                (std/os/fd#fd-e _raw143697_)
                _bytes143698_
                _start143699_
                _end143700_)))
          (if (not (##fxnegative? _r143706_))
              _r143706_
              (let ((_errno143709_ (##fx- _r143706_)))
                (if (or (eq? _errno143709_ std/os/error#EAGAIN)
                        (eq? _errno143709_ std/os/error#EWOULDBLOCK))
                    '#f
                    (if (eq? _errno143709_ std/os/error#EINTR)
                        (_lp143702_)
                        (std/os/error#raise-os-error
                         _errno143709_
                         std/os/fdio#fdread
                         _raw143697_
                         _bytes143698_
                         _start143699_
                         _end143700_)))))))))
  (define std/os/fdio#fdread__0
    (lambda (_raw143718_ _bytes143719_)
      (let* ((_start143721_ '0) (_end143723_ (u8vector-length _bytes143719_)))
        (std/os/fdio#fdread__%
         _raw143718_
         _bytes143719_
         _start143721_
         _end143723_))))
  (define std/os/fdio#fdread__1
    (lambda (_raw143725_ _bytes143726_ _start143727_)
      (let ((_end143729_ (u8vector-length _bytes143726_)))
        (std/os/fdio#fdread__%
         _raw143725_
         _bytes143726_
         _start143727_
         _end143729_))))
  (define std/os/fdio#fdread
    (lambda _g143736_
      (let ((_g143735_ (length _g143736_)))
        (cond ((##fx= _g143735_ 2) (apply std/os/fdio#fdread__0 _g143736_))
              ((##fx= _g143735_ 3) (apply std/os/fdio#fdread__1 _g143736_))
              ((##fx= _g143735_ 4) (apply std/os/fdio#fdread__% _g143736_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/fdio#fdread
                _g143736_))))))
  (define std/os/fdio#fdwrite__%
    (lambda (_raw143657_ _bytes143658_ _start143659_ _end143660_)
      (let _lp143662_ ()
        (let ((_r143666_
               (std/os/fdio#_write
                (std/os/fd#fd-e _raw143657_)
                _bytes143658_
                _start143659_
                _end143660_)))
          (if (not (##fxnegative? _r143666_))
              _r143666_
              (let ((_errno143669_ (##fx- _r143666_)))
                (if (or (eq? _errno143669_ std/os/error#EAGAIN)
                        (eq? _errno143669_ std/os/error#EWOULDBLOCK))
                    '#f
                    (if (eq? _errno143669_ std/os/error#EINTR)
                        (_lp143662_)
                        (std/os/error#raise-os-error
                         _errno143669_
                         std/os/fdio#fdwrite
                         _raw143657_
                         _bytes143658_
                         _start143659_
                         _end143660_)))))))))
  (define std/os/fdio#fdwrite__0
    (lambda (_raw143678_ _bytes143679_)
      (let* ((_start143681_ '0) (_end143683_ (u8vector-length _bytes143679_)))
        (std/os/fdio#fdwrite__%
         _raw143678_
         _bytes143679_
         _start143681_
         _end143683_))))
  (define std/os/fdio#fdwrite__1
    (lambda (_raw143685_ _bytes143686_ _start143687_)
      (let ((_end143689_ (u8vector-length _bytes143686_)))
        (std/os/fdio#fdwrite__%
         _raw143685_
         _bytes143686_
         _start143687_
         _end143689_))))
  (define std/os/fdio#fdwrite
    (lambda _g143738_
      (let ((_g143737_ (length _g143738_)))
        (cond ((##fx= _g143737_ 2) (apply std/os/fdio#fdwrite__0 _g143738_))
              ((##fx= _g143737_ 3) (apply std/os/fdio#fdwrite__1 _g143738_))
              ((##fx= _g143737_ 4) (apply std/os/fdio#fdwrite__% _g143738_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/fdio#fdwrite
                _g143738_))))))
  (define std/os/fdio#open__%
    (lambda (_path143632_ _flags143633_ _mode143634_)
      (let* ((_fd143639_
              (let ((_r143636_
                     (std/os/fdio#_open
                      _path143632_
                      _flags143633_
                      _mode143634_)))
                (if (not (##fxnegative? _r143636_))
                    _r143636_
                    (std/os/error#raise-os-error
                     (##fx- _r143636_)
                     std/os/fdio#open
                     _path143632_
                     _flags143633_
                     _mode143634_))))
             (_raw143641_
              (std/os/fd#fdopen
               _fd143639_
               (std/os/fdio#file-direction _flags143633_)
               'file)))
        (std/os/fcntl#fd-set-nonblock/closeonexec _raw143641_)
        _raw143641_)))
  (define std/os/fdio#open__0
    (lambda (_path143647_ _flags143648_)
      (let ((_mode143650_ '0))
        (std/os/fdio#open__% _path143647_ _flags143648_ _mode143650_))))
  (define std/os/fdio#open
    (lambda _g143740_
      (let ((_g143739_ (length _g143740_)))
        (cond ((##fx= _g143739_ 2) (apply std/os/fdio#open__0 _g143740_))
              ((##fx= _g143739_ 3) (apply std/os/fdio#open__% _g143740_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/fdio#open
                _g143740_))))))
  (define std/os/fdio#file-direction
    (lambda (_flags143629_)
      (if (##fx= (##fxand _flags143629_ std/os/fcntl#O_RDWR)
                 std/os/fcntl#O_RDWR)
          'inout
          (if (##fx= (##fxand _flags143629_ std/os/fcntl#O_RDONLY)
                     std/os/fcntl#O_RDONLY)
              'in
              (if (##fx= (##fxand _flags143629_ std/os/fcntl#O_WRONLY)
                         std/os/fcntl#O_WRONLY)
                  'out
                  (error '"Unspecified file direction" _flags143629_))))))
  (define-macro (define-guard guard defn)
    (if (eval `(cond-expand (,guard #t) (else #f)))
        '(begin)
        (begin (eval `(define-cond-expand-feature ,guard)) defn)))
  (define-macro (define-c-lambda id args ret #!optional (name #f))
    (let ((name (or name (symbol->string id))))
      `(define ,id (c-lambda ,args ,ret ,name))))
  (define-macro (define-const symbol)
    (let* ((str (symbol->string symbol))
           (ref (string-append "___return (" str ");")))
      `(define ,symbol ((c-lambda () int ,ref)))))
  (define-macro (define-const* symbol)
    (let* ((str (symbol->string symbol))
           (code (string-append
                  "#ifdef "
                  str
                  "\n"
                  "___return (___FIX ("
                  str
                  "));\n"
                  "#else \n"
                  "___return (___FAL);\n"
                  "#endif")))
      `(define ,symbol ((c-lambda () scheme-object ,code)))))
  (c-declare "#include <stdlib.h>")
  (c-declare "static ___SCMOBJ ffi_free (void *ptr);")
  (c-declare
   "#ifndef ___HAVE_FFI_U8VECTOR\n#define ___HAVE_FFI_U8VECTOR\n#define U8_DATA(obj) ___CAST (___U8*, ___BODY_AS (obj, ___tSUBTYPED))\n#define U8_LEN(obj) ___HD_BYTES (___HEADER (obj))\n#endif")
  (namespace ("std/os/fdio#" _read _write _open))
  (c-declare "#include <unistd.h>")
  (c-declare "#include <errno.h>")
  (c-declare "#include <sys/types.h>")
  (c-declare "#include <sys/stat.h>")
  (c-declare "#include <fcntl.h>")
  (define-macro (define-with-errno symbol ffi-symbol args)
    `(define (,symbol ,@args)
       (declare (not interrupts-enabled))
       (let ((r (,ffi-symbol ,@args))) (if (##fx< r 0) (##fx- (__errno)) r))))
  (namespace ("std/os/fdio#" __read __write __open __errno))
  (define-c-lambda __errno () int "___return (errno);")
  (c-declare
   "static int ffi_fdio_read (int fd, ___SCMOBJ bytes, int start, int end);")
  (c-declare
   "static int ffi_fdio_write (int fd, ___SCMOBJ bytes, int start, int end);")
  (define-c-lambda __read (int scheme-object int int) int "ffi_fdio_read")
  (define-c-lambda __write (int scheme-object int int) int "ffi_fdio_write")
  (define-c-lambda __open (UTF-8-string int int) int "open")
  (define-with-errno _read __read (fd bytes start end))
  (define-with-errno _write __write (fd bytes start end))
  (define-with-errno _open __open (path flags mode))
  (c-declare
   "int ffi_fdio_read (int fd, ___SCMOBJ bytes, int start, int end)\n{\n return read (fd, U8_DATA (bytes) + start, end - start);\n}\n\nint ffi_fdio_write (int fd, ___SCMOBJ bytes, int start, int end)\n{\n return write (fd, U8_DATA (bytes) + start, end - start);\n}\n")
  (c-declare
   "#ifndef ___HAVE_FFI_FREE\n#define ___HAVE_FFI_FREE\n___SCMOBJ ffi_free (void *ptr)\n{\n free (ptr);\n return ___FIX (___NO_ERR);\n}\n#endif"))
