(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/actor/message#actor-error::t
    (make-struct-type
     'std/actor/message#actor-error::t
     error::t
     '0
     'actor-error
     '()
     ':init!
     '()))
  (define std/actor/message#actor-error?
    (make-struct-predicate std/actor/message#actor-error::t))
  (define std/actor/message#make-actor-error
    (lambda _$args121966_
      (apply make-struct-instance
             std/actor/message#actor-error::t
             _$args121966_)))
  (define std/actor/message#actor-error:::init!
    (lambda (_self121961_ _where121962_ _what121963_ . _irritants121964_)
      (if (##fx< '3 (##vector-length _self121961_))
          (begin
            (##vector-set! _self121961_ '1 _what121963_)
            (##vector-set! _self121961_ '2 _irritants121964_)
            (##vector-set! _self121961_ '3 _where121962_))
          (error '"struct-instance-init!: too many arguments for struct"
                 _self121961_))))
  (bind-method!
   std/actor/message#actor-error::t
   ':init!
   std/actor/message#actor-error:::init!
   '#f)
  (define std/actor/message#message::t
    (make-struct-type
     'std/actor/message#message::t
     '#f
     '4
     'message
     '((final: . #t))
     '#f
     '(e source dest options)))
  (define std/actor/message#message?
    (make-struct-predicate std/actor/message#message::t))
  (define std/actor/message#make-message
    (lambda _$args121836_
      (apply make-struct-instance std/actor/message#message::t _$args121836_)))
  (define std/actor/message#message-e
    (make-struct-field-accessor std/actor/message#message::t '0))
  (define std/actor/message#message-source
    (make-struct-field-accessor std/actor/message#message::t '1))
  (define std/actor/message#message-dest
    (make-struct-field-accessor std/actor/message#message::t '2))
  (define std/actor/message#message-options
    (make-struct-field-accessor std/actor/message#message::t '3))
  (define std/actor/message#message-e-set!
    (make-struct-field-mutator std/actor/message#message::t '0))
  (define std/actor/message#message-source-set!
    (make-struct-field-mutator std/actor/message#message::t '1))
  (define std/actor/message#message-dest-set!
    (make-struct-field-mutator std/actor/message#message::t '2))
  (define std/actor/message#message-options-set!
    (make-struct-field-mutator std/actor/message#message::t '3))
  (define std/actor/message#proxy::t
    (make-struct-type
     'std/actor/message#proxy::t
     '#f
     '1
     'proxy
     '()
     '#f
     '(handler)))
  (define std/actor/message#proxy?
    (make-struct-predicate std/actor/message#proxy::t))
  (define std/actor/message#make-proxy
    (lambda _$args121833_
      (apply make-struct-instance std/actor/message#proxy::t _$args121833_)))
  (define std/actor/message#proxy-handler
    (make-struct-field-accessor std/actor/message#proxy::t '0))
  (define std/actor/message#proxy-handler-set!
    (make-struct-field-mutator std/actor/message#proxy::t '0))
  (define std/actor/message#send__%
    (lambda (_dest121810_ _msg121811_ _raise-dead?121812_)
      (let _lp121814_ ((_dest121816_ _dest121810_))
        (if (thread? _dest121816_)
            (let ((_$e121818_
                   (std/actor/message#thread-send/check
                    _dest121816_
                    _msg121811_)))
              (if _$e121818_
                  _$e121818_
                  (if (not _raise-dead?121812_)
                      '#f
                      (raise (make-struct-instance
                              std/actor/message#actor-error::t
                              'send
                              '"Cannot send message; dead thread"
                              _dest121816_
                              _msg121811_)))))
            (if (##structure-instance-of?
                 _dest121816_
                 'std/actor/message#proxy::t)
                (_lp121814_
                 (##structure-ref
                  _dest121816_
                  '1
                  std/actor/message#proxy::t
                  '#f))
                (_lp121814_ (call-method ':actor _dest121816_)))))))
  (define std/actor/message#send__0
    (lambda (_dest121824_ _msg121825_)
      (let ((_raise-dead?121827_ '#f))
        (std/actor/message#send__%
         _dest121824_
         _msg121825_
         _raise-dead?121827_))))
  (define std/actor/message#send
    (lambda _g122193_
      (let ((_g122192_ (length _g122193_)))
        (cond ((##fx= _g122192_ 2) (apply std/actor/message#send__0 _g122193_))
              ((##fx= _g122192_ 3) (apply std/actor/message#send__% _g122193_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/actor/message#send
                _g122193_))))))
  (define std/actor/message#send-message__%
    (lambda (_dest121783_ _value121784_ _options121785_ _check-dead?121786_)
      (std/actor/message#send__%
       _dest121783_
       (##structure
        std/actor/message#message::t
        _value121784_
        (current-thread)
        _dest121783_
        _options121785_)
       _check-dead?121786_)))
  (define std/actor/message#send-message__0
    (lambda (_dest121791_ _value121792_)
      (let* ((_options121794_ '#f)
             (_check-dead?121796_
              (##structure-instance-of?
               _dest121791_
               'std/actor/message#proxy::t)))
        (std/actor/message#send-message__%
         _dest121791_
         _value121792_
         _options121794_
         _check-dead?121796_))))
  (define std/actor/message#send-message__1
    (lambda (_dest121798_ _value121799_ _options121800_)
      (let ((_check-dead?121802_
             (##structure-instance-of?
              _dest121798_
              'std/actor/message#proxy::t)))
        (std/actor/message#send-message__%
         _dest121798_
         _value121799_
         _options121800_
         _check-dead?121802_))))
  (define std/actor/message#send-message
    (lambda _g122195_
      (let ((_g122194_ (length _g122195_)))
        (cond ((##fx= _g122194_ 2)
               (apply std/actor/message#send-message__0 _g122195_))
              ((##fx= _g122194_ 3)
               (apply std/actor/message#send-message__1 _g122195_))
              ((##fx= _g122194_ 4)
               (apply std/actor/message#send-message__% _g122195_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/actor/message#send-message
                _g122195_))))))
  (define std/actor/message#send-message/timeout__%
    (lambda (_dest121763_ _value121764_ _timeo121765_ _check-dead?121766_)
      (std/actor/message#send__%
       _dest121763_
       (##structure
        std/actor/message#message::t
        _value121764_
        (current-thread)
        _dest121763_
        (cons 'timeout: (cons _timeo121765_ '())))
       _check-dead?121766_)))
  (define std/actor/message#send-message/timeout__0
    (lambda (_dest121771_ _value121772_ _timeo121773_)
      (let ((_check-dead?121775_
             (##structure-instance-of?
              _dest121771_
              'std/actor/message#proxy::t)))
        (std/actor/message#send-message/timeout__%
         _dest121771_
         _value121772_
         _timeo121773_
         _check-dead?121775_))))
  (define std/actor/message#send-message/timeout
    (lambda _g122197_
      (let ((_g122196_ (length _g122197_)))
        (cond ((##fx= _g122196_ 3)
               (apply std/actor/message#send-message/timeout__0 _g122197_))
              ((##fx= _g122196_ 4)
               (apply std/actor/message#send-message/timeout__% _g122197_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/actor/message#send-message/timeout
                _g122197_))))))
  (namespace ("std/actor/message#" send thread-send/check))
  (define (thread-send/check thread msg)
    (declare (not interrupts-enabled))
    (macro-check-initialized-thread
     thread
     (send thread msg)
     (if (macro-thread-end-condvar thread) (##thread-send thread msg) #f)))
  (define std/actor/message#receive-timeout
    (lambda _args121698_
      (letrec* ((_now121700_ '#f))
        (let _lp121702_ ((_rest121704_ _args121698_)
                         (_timeo121705_ absent-obj)
                         (_deadline121706_ '#f)
                         (_K121707_ void))
          (let* ((_rest121708121718_ _rest121704_)
                 (_else121710121726_
                  (lambda () (values _timeo121705_ _K121707_)))
                 (_K121712121743_
                  (lambda (_rest121729_ _k121730_ _evt121731_)
                    (if (not _evt121731_)
                        (_lp121702_
                         _rest121729_
                         _timeo121705_
                         _deadline121706_
                         _K121707_)
                        (if (time? _evt121731_)
                            (let ((_evt-deadline121733_
                                   (time->seconds _evt121731_)))
                              (if (or (not _deadline121706_)
                                      (< _evt-deadline121733_
                                         _deadline121706_))
                                  (_lp121702_
                                   _rest121729_
                                   _evt121731_
                                   _evt-deadline121733_
                                   _k121730_)
                                  (_lp121702_
                                   _rest121729_
                                   _timeo121705_
                                   _deadline121706_
                                   _K121707_)))
                            (if (real? _evt121731_)
                                (begin
                                  (if _now121700_
                                      '#!void
                                      (set! _now121700_
                                            (##current-time-point)))
                                  (let ((_evt-deadline121738_
                                         (+ _now121700_ _evt121731_)))
                                    (if (or (not _deadline121706_)
                                            (< _evt-deadline121738_
                                               _deadline121706_))
                                        (_lp121702_
                                         _rest121729_
                                         (seconds->time _evt-deadline121738_)
                                         _evt-deadline121738_
                                         _k121730_)
                                        (_lp121702_
                                         _rest121729_
                                         _timeo121705_
                                         _deadline121706_
                                         _K121707_))))
                                (error '"Illegal event; expected time, real, or #f"
                                       _evt121731_)))))))
            (if (##pair? _rest121708121718_)
                (let ((_hd121713121746_ (##car _rest121708121718_))
                      (_tl121714121748_ (##cdr _rest121708121718_)))
                  (let ((_evt121751_ _hd121713121746_))
                    (if (##pair? _tl121714121748_)
                        (let ((_hd121715121753_ (##car _tl121714121748_))
                              (_tl121716121755_ (##cdr _tl121714121748_)))
                          (let* ((_k121758_ _hd121715121753_)
                                 (_rest121760_ _tl121716121755_))
                            (_K121712121743_
                             _rest121760_
                             _k121758_
                             _evt121751_)))
                        (_else121710121726_))))
                (_else121710121726_)))))))
  (define std/actor/message#mailbox-timeout '#(timeout))
  (namespace ("std/actor/message#" mailbox-empty mailbox-next))
  (define mailbox-empty '#(empty))
  (define (mailbox-next)
    (declare (not interrupts-enabled))
    (let* ((mb (##thread-mailbox-get! (macro-current-thread)))
           (cursor (macro-mailbox-cursor mb))
           (next (if cursor (macro-fifo-next cursor) (macro-mailbox-fifo mb)))
           (next2 (macro-fifo-next next)))
      (if (##pair? next2)
          (let ((result (macro-fifo-elem next2)))
            (macro-mailbox-cursor-set! mb next)
            result)
          mailbox-empty))))
