(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/crypto/hmac#hmac::t
    (make-struct-type 'std/crypto#hmac::t '#f '2 'hmac '() ':init! '(md ctx)))
  (define std/crypto/hmac#hmac?
    (make-struct-predicate std/crypto/hmac#hmac::t))
  (define std/crypto/hmac#make-hmac
    (lambda _$args155915_
      (apply make-struct-instance std/crypto/hmac#hmac::t _$args155915_)))
  (define std/crypto/hmac#hmac-md
    (make-struct-field-accessor std/crypto/hmac#hmac::t '0))
  (define std/crypto/hmac#hmac-ctx
    (make-struct-field-accessor std/crypto/hmac#hmac::t '1))
  (define std/crypto/hmac#hmac-md-set!
    (make-struct-field-mutator std/crypto/hmac#hmac::t '0))
  (define std/crypto/hmac#hmac-ctx-set!
    (make-struct-field-mutator std/crypto/hmac#hmac::t '1))
  (define std/crypto/hmac#hmac:::init!
    (lambda (_self155910_ _md155911_)
      (if (std/crypto/libcrypto#EVP_MD? _md155911_)
          '#!void
          (error '"Invalid digest type" _md155911_))
      (let ((_ctx155913_ (std/crypto/libcrypto#HMAC_CTX_create)))
        (if _ctx155913_ '#!void (error '"Failed to allocate hmac context"))
        (if (##fx< '2 (##vector-length _self155910_))
            (begin
              (##vector-set! _self155910_ '1 _md155911_)
              (##vector-set! _self155910_ '2 _ctx155913_))
            (error '"struct-instance-init!: too many arguments for struct"
                   _self155910_)))))
  (bind-method!
   std/crypto/hmac#hmac::t
   ':init!
   std/crypto/hmac#hmac:::init!
   '#f)
  (define std/crypto/hmac#hmac-init!
    (lambda (_hmac155782_ _key155783_)
      (let ((_res155785_
             (std/crypto/libcrypto#HMAC_Init
              (##structure-ref _hmac155782_ '2 std/crypto/hmac#hmac::t '#f)
              _key155783_
              (##structure-ref _hmac155782_ '1 std/crypto/hmac#hmac::t '#f))))
        (if (##fxzero? _res155785_)
            (apply std/crypto/etc#raise-libcrypto-error '())
            '#!void))))
  (define std/crypto/hmac#hmac-update!__%
    (lambda (_hmac155742_ _bytes155743_ _start155744_ _end155745_)
      (let* ((_start155750_
              (let ((_$e155747_ _start155744_)) (if _$e155747_ _$e155747_ '0)))
             (_end155755_
              (let ((_$e155752_ _end155745_))
                (if _$e155752_ _$e155752_ (u8vector-length _bytes155743_)))))
        (let ((_res155758_
               (std/crypto/libcrypto#HMAC_Update
                (##structure-ref _hmac155742_ '2 std/crypto/hmac#hmac::t '#f)
                _bytes155743_
                _start155750_
                _end155755_)))
          (if (##fxzero? _res155758_)
              (apply std/crypto/etc#raise-libcrypto-error '())
              '#!void)))))
  (define std/crypto/hmac#hmac-update!__0
    (lambda (_hmac155764_ _bytes155765_)
      (let* ((_start155767_ '#f) (_end155769_ '#f))
        (std/crypto/hmac#hmac-update!__%
         _hmac155764_
         _bytes155765_
         _start155767_
         _end155769_))))
  (define std/crypto/hmac#hmac-update!__1
    (lambda (_hmac155771_ _bytes155772_ _start155773_)
      (let ((_end155775_ '#f))
        (std/crypto/hmac#hmac-update!__%
         _hmac155771_
         _bytes155772_
         _start155773_
         _end155775_))))
  (define std/crypto/hmac#hmac-update!
    (lambda _g155918_
      (let ((_g155917_ (length _g155918_)))
        (cond ((##fx= _g155917_ 2)
               (apply std/crypto/hmac#hmac-update!__0 _g155918_))
              ((##fx= _g155917_ 3)
               (apply std/crypto/hmac#hmac-update!__1 _g155918_))
              ((##fx= _g155917_ 4)
               (apply std/crypto/hmac#hmac-update!__% _g155918_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/hmac#hmac-update!
                _g155918_))))))
  (define std/crypto/hmac#hmac-final!__%
    (lambda (_hmac155717_ _bytes155718_)
      (let* ((_size155720_
              (std/crypto/libcrypto#EVP_MD_size
               (##structure-ref _hmac155717_ '1 std/crypto/hmac#hmac::t '#f)))
             (_bytes155725_
              (let ((_$e155722_ _bytes155718_))
                (if _$e155722_ _$e155722_ (make-u8vector _size155720_)))))
        (let ((_res155728_
               (std/crypto/libcrypto#HMAC_Final
                (##structure-ref _hmac155717_ '2 std/crypto/hmac#hmac::t '#f)
                _bytes155725_)))
          (if (##fxzero? _res155728_)
              (apply std/crypto/etc#raise-libcrypto-error '())
              '#!void))
        _bytes155725_)))
  (define std/crypto/hmac#hmac-final!__0
    (lambda (_hmac155734_)
      (let ((_bytes155736_ '#f))
        (std/crypto/hmac#hmac-final!__% _hmac155734_ _bytes155736_))))
  (define std/crypto/hmac#hmac-final!
    (lambda _g155920_
      (let ((_g155919_ (length _g155920_)))
        (cond ((##fx= _g155919_ 1)
               (apply std/crypto/hmac#hmac-final!__0 _g155920_))
              ((##fx= _g155919_ 2)
               (apply std/crypto/hmac#hmac-final!__% _g155920_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/hmac#hmac-final!
                _g155920_))))))
  (define std/crypto/hmac#hmac-digest__%
    (lambda (_md155671_ _key155672_ _bytes155673_ _start155674_ _end155675_)
      (if (std/crypto/libcrypto#EVP_MD? _md155671_)
          '#!void
          (error '"Bad digest type" _md155671_))
      (let* ((_start155680_
              (let ((_$e155677_ _start155674_)) (if _$e155677_ _$e155677_ '0)))
             (_end155685_
              (let ((_$e155682_ _end155675_))
                (if _$e155682_ _$e155682_ (u8vector-length _bytes155673_))))
             (_size155687_ (std/crypto/libcrypto#EVP_MD_size _md155671_))
             (_digest155689_ (make-u8vector _size155687_)))
        (std/crypto/libcrypto#HMAC
         _md155671_
         _key155672_
         _bytes155673_
         _start155680_
         _end155685_
         _digest155689_)
        _digest155689_)))
  (define std/crypto/hmac#hmac-digest__0
    (lambda (_md155695_ _key155696_ _bytes155697_)
      (let* ((_start155699_ '#f) (_end155701_ '#f))
        (std/crypto/hmac#hmac-digest__%
         _md155695_
         _key155696_
         _bytes155697_
         _start155699_
         _end155701_))))
  (define std/crypto/hmac#hmac-digest__1
    (lambda (_md155703_ _key155704_ _bytes155705_ _start155706_)
      (let ((_end155708_ '#f))
        (std/crypto/hmac#hmac-digest__%
         _md155703_
         _key155704_
         _bytes155705_
         _start155706_
         _end155708_))))
  (define std/crypto/hmac#hmac-digest
    (lambda _g155922_
      (let ((_g155921_ (length _g155922_)))
        (cond ((##fx= _g155921_ 3)
               (apply std/crypto/hmac#hmac-digest__0 _g155922_))
              ((##fx= _g155921_ 4)
               (apply std/crypto/hmac#hmac-digest__1 _g155922_))
              ((##fx= _g155921_ 5)
               (apply std/crypto/hmac#hmac-digest__% _g155922_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/hmac#hmac-digest
                _g155922_))))))
  (define std/crypto/hmac#hmac-md5__%
    (lambda (_key155640_ _bytes155642_ _start155644_ _end155646_)
      (std/crypto/hmac#hmac-digest__%
       std/crypto/digest#digest::md5
       _key155640_
       _bytes155642_
       _start155644_
       _end155646_)))
  (define std/crypto/hmac#hmac-md5__0
    (lambda (_key155652_ _bytes155653_)
      (let* ((_start155655_ '#f) (_end155657_ '#f))
        (std/crypto/hmac#hmac-md5__%
         _key155652_
         _bytes155653_
         _start155655_
         _end155657_))))
  (define std/crypto/hmac#hmac-md5__1
    (lambda (_key155659_ _bytes155660_ _start155661_)
      (let ((_end155663_ '#f))
        (std/crypto/hmac#hmac-md5__%
         _key155659_
         _bytes155660_
         _start155661_
         _end155663_))))
  (define std/crypto/hmac#hmac-md5
    (lambda _g155924_
      (let ((_g155923_ (length _g155924_)))
        (cond ((##fx= _g155923_ 2)
               (apply std/crypto/hmac#hmac-md5__0 _g155924_))
              ((##fx= _g155923_ 3)
               (apply std/crypto/hmac#hmac-md5__1 _g155924_))
              ((##fx= _g155923_ 4)
               (apply std/crypto/hmac#hmac-md5__% _g155924_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/hmac#hmac-md5
                _g155924_))))))
  (define std/crypto/hmac#hmac-sha1__%
    (lambda (_key155609_ _bytes155611_ _start155613_ _end155615_)
      (std/crypto/hmac#hmac-digest__%
       std/crypto/digest#digest::sha1
       _key155609_
       _bytes155611_
       _start155613_
       _end155615_)))
  (define std/crypto/hmac#hmac-sha1__0
    (lambda (_key155621_ _bytes155622_)
      (let* ((_start155624_ '#f) (_end155626_ '#f))
        (std/crypto/hmac#hmac-sha1__%
         _key155621_
         _bytes155622_
         _start155624_
         _end155626_))))
  (define std/crypto/hmac#hmac-sha1__1
    (lambda (_key155628_ _bytes155629_ _start155630_)
      (let ((_end155632_ '#f))
        (std/crypto/hmac#hmac-sha1__%
         _key155628_
         _bytes155629_
         _start155630_
         _end155632_))))
  (define std/crypto/hmac#hmac-sha1
    (lambda _g155926_
      (let ((_g155925_ (length _g155926_)))
        (cond ((##fx= _g155925_ 2)
               (apply std/crypto/hmac#hmac-sha1__0 _g155926_))
              ((##fx= _g155925_ 3)
               (apply std/crypto/hmac#hmac-sha1__1 _g155926_))
              ((##fx= _g155925_ 4)
               (apply std/crypto/hmac#hmac-sha1__% _g155926_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/hmac#hmac-sha1
                _g155926_))))))
  (define std/crypto/hmac#hmac-sha256__%
    (lambda (_key155578_ _bytes155580_ _start155582_ _end155584_)
      (std/crypto/hmac#hmac-digest__%
       std/crypto/digest#digest::sha256
       _key155578_
       _bytes155580_
       _start155582_
       _end155584_)))
  (define std/crypto/hmac#hmac-sha256__0
    (lambda (_key155590_ _bytes155591_)
      (let* ((_start155593_ '#f) (_end155595_ '#f))
        (std/crypto/hmac#hmac-sha256__%
         _key155590_
         _bytes155591_
         _start155593_
         _end155595_))))
  (define std/crypto/hmac#hmac-sha256__1
    (lambda (_key155597_ _bytes155598_ _start155599_)
      (let ((_end155601_ '#f))
        (std/crypto/hmac#hmac-sha256__%
         _key155597_
         _bytes155598_
         _start155599_
         _end155601_))))
  (define std/crypto/hmac#hmac-sha256
    (lambda _g155928_
      (let ((_g155927_ (length _g155928_)))
        (cond ((##fx= _g155927_ 2)
               (apply std/crypto/hmac#hmac-sha256__0 _g155928_))
              ((##fx= _g155927_ 3)
               (apply std/crypto/hmac#hmac-sha256__1 _g155928_))
              ((##fx= _g155927_ 4)
               (apply std/crypto/hmac#hmac-sha256__% _g155928_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/hmac#hmac-sha256
                _g155928_))))))
  (define std/crypto/hmac#hmac-sha384__%
    (lambda (_key155547_ _bytes155549_ _start155551_ _end155553_)
      (std/crypto/hmac#hmac-digest__%
       std/crypto/digest#digest::sha384
       _key155547_
       _bytes155549_
       _start155551_
       _end155553_)))
  (define std/crypto/hmac#hmac-sha384__0
    (lambda (_key155559_ _bytes155560_)
      (let* ((_start155562_ '#f) (_end155564_ '#f))
        (std/crypto/hmac#hmac-sha384__%
         _key155559_
         _bytes155560_
         _start155562_
         _end155564_))))
  (define std/crypto/hmac#hmac-sha384__1
    (lambda (_key155566_ _bytes155567_ _start155568_)
      (let ((_end155570_ '#f))
        (std/crypto/hmac#hmac-sha384__%
         _key155566_
         _bytes155567_
         _start155568_
         _end155570_))))
  (define std/crypto/hmac#hmac-sha384
    (lambda _g155930_
      (let ((_g155929_ (length _g155930_)))
        (cond ((##fx= _g155929_ 2)
               (apply std/crypto/hmac#hmac-sha384__0 _g155930_))
              ((##fx= _g155929_ 3)
               (apply std/crypto/hmac#hmac-sha384__1 _g155930_))
              ((##fx= _g155929_ 4)
               (apply std/crypto/hmac#hmac-sha384__% _g155930_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/hmac#hmac-sha384
                _g155930_))))))
  (define std/crypto/hmac#hmac-sha512__%
    (lambda (_key155516_ _bytes155518_ _start155520_ _end155522_)
      (std/crypto/hmac#hmac-digest__%
       std/crypto/digest#digest::sha512
       _key155516_
       _bytes155518_
       _start155520_
       _end155522_)))
  (define std/crypto/hmac#hmac-sha512__0
    (lambda (_key155528_ _bytes155529_)
      (let* ((_start155531_ '#f) (_end155533_ '#f))
        (std/crypto/hmac#hmac-sha512__%
         _key155528_
         _bytes155529_
         _start155531_
         _end155533_))))
  (define std/crypto/hmac#hmac-sha512__1
    (lambda (_key155535_ _bytes155536_ _start155537_)
      (let ((_end155539_ '#f))
        (std/crypto/hmac#hmac-sha512__%
         _key155535_
         _bytes155536_
         _start155537_
         _end155539_))))
  (define std/crypto/hmac#hmac-sha512
    (lambda _g155932_
      (let ((_g155931_ (length _g155932_)))
        (cond ((##fx= _g155931_ 2)
               (apply std/crypto/hmac#hmac-sha512__0 _g155932_))
              ((##fx= _g155931_ 3)
               (apply std/crypto/hmac#hmac-sha512__1 _g155932_))
              ((##fx= _g155931_ 4)
               (apply std/crypto/hmac#hmac-sha512__% _g155932_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/hmac#hmac-sha512
                _g155932_)))))))
