(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/misc/uuid#uuid-length '16)
  (define std/misc/uuid#uuid::t
    (make-struct-type
     'std/misc/uuid#uuid::t
     '#f
     '2
     'uuid
     '((equal: bytes) (final: . #t))
     '#f
     '(bytes str)))
  (define std/misc/uuid#uuid? (make-struct-predicate std/misc/uuid#uuid::t))
  (define std/misc/uuid#make-uuid
    (lambda _$args119541_
      (apply make-struct-instance std/misc/uuid#uuid::t _$args119541_)))
  (define std/misc/uuid#uuid-bytes
    (make-struct-field-accessor std/misc/uuid#uuid::t '0))
  (define std/misc/uuid#uuid-str
    (make-struct-field-accessor std/misc/uuid#uuid::t '1))
  (define std/misc/uuid#uuid-bytes-set!
    (make-struct-field-mutator std/misc/uuid#uuid::t '0))
  (define std/misc/uuid#uuid-str-set!
    (make-struct-field-mutator std/misc/uuid#uuid::t '1))
  (define std/misc/uuid#uuid=?
    (lambda (_a119538_ _b119539_)
      (equal? (##direct-structure-ref _a119538_ '1 std/misc/uuid#uuid::t '#f)
              (##direct-structure-ref
               _b119539_
               '1
               std/misc/uuid#uuid::t
               '#f))))
  (define std/misc/uuid#uuid-hash
    (lambda (_uuid119536_)
      (equal?-hash
       (##direct-structure-ref _uuid119536_ '1 std/misc/uuid#uuid::t '#f))))
  (define std/misc/uuid#UUID
    (lambda (_obj119534_)
      (if (##structure-direct-instance-of? _obj119534_ 'std/misc/uuid#uuid::t)
          _obj119534_
          (if (string? _obj119534_)
              (std/misc/uuid#text->uuid _obj119534_)
              (if (symbol? _obj119534_)
                  (std/misc/uuid#text->uuid (symbol->string _obj119534_))
                  (if (u8vector? _obj119534_)
                      (std/misc/uuid#u8vector->uuid _obj119534_)
                      (error '"bad uuid identifier" _obj119534_)))))))
  (define std/misc/uuid#random-uuid
    (lambda ()
      (let ((_bytes119532_ (make-u8vector std/misc/uuid#uuid-length)))
        (std/crypto/etc#random-bytes!__0 _bytes119532_)
        (##structure std/misc/uuid#uuid::t _bytes119532_ '#f))))
  (define std/misc/uuid#content-uuid
    (lambda (_str119524_)
      (let* ((_bytes119526_ (std/text/utf8#string->utf8__0 _str119524_))
             (_hash119528_ (std/crypto/digest#md5 _bytes119526_)))
        (##structure std/misc/uuid#uuid::t _hash119528_ '#f))))
  (define std/misc/uuid#uuid-re
    (std/pregexp#pregexp
     '"[0-9a-z]{8}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{12}"))
  (define std/misc/uuid#uuid-re-capture
    (std/pregexp#pregexp
     '"([0-9a-z]{8})-([0-9a-z]){4}-([0-9a-z]{4})-([0-9a-z]{4})-([0-9a-z]{12})"))
  (define std/misc/uuid#text->uuid
    (lambda (_str119522_)
      (if (std/pregexp#pregexp-match std/misc/uuid#uuid-re _str119522_)
          (std/misc/uuid#string->uuid _str119522_)
          (std/misc/uuid#content-uuid _str119522_))))
  (define std/misc/uuid#u8vector->uuid
    (lambda (_u8v119520_)
      (if (##fx= (u8vector-length _u8v119520_) std/misc/uuid#uuid-length)
          (##structure std/misc/uuid#uuid::t _u8v119520_ '#f)
          (error '"Bad argument; invalid u8vector length" _u8v119520_))))
  (define std/misc/uuid#uuid->u8vector
    (lambda (_uuid119518_)
      (##direct-structure-ref _uuid119518_ '1 std/misc/uuid#uuid::t '#f)))
  (define std/misc/uuid#string->uuid
    (lambda (_str119441_)
      (let* ((_g119442119460_
              (std/pregexp#pregexp-match
               std/misc/uuid#uuid-re-capture
               _str119441_))
             (_else119444119468_
              (lambda () (error '"Bad argument; malformed uuid" _str119441_)))
             (_K119446119477_
              (lambda (_e119471_ _d119472_ _c119473_ _b119474_ _a119475_)
                (##structure
                 std/misc/uuid#uuid::t
                 (u8vector-append
                  (std/text/hex#hex-decode _a119475_)
                  (std/text/hex#hex-decode _b119474_)
                  (std/text/hex#hex-decode _c119473_)
                  (std/text/hex#hex-decode _d119472_)
                  (std/text/hex#hex-decode _e119471_))
                 _str119441_))))
        (if (##pair? _g119442119460_)
            (let ((_tl119448119480_ (##cdr _g119442119460_)))
              (if (##pair? _tl119448119480_)
                  (let ((_hd119449119483_ (##car _tl119448119480_))
                        (_tl119450119485_ (##cdr _tl119448119480_)))
                    (let ((_a119488_ _hd119449119483_))
                      (if (##pair? _tl119450119485_)
                          (let ((_hd119451119490_ (##car _tl119450119485_))
                                (_tl119452119492_ (##cdr _tl119450119485_)))
                            (let ((_b119495_ _hd119451119490_))
                              (if (##pair? _tl119452119492_)
                                  (let ((_hd119453119497_
                                         (##car _tl119452119492_))
                                        (_tl119454119499_
                                         (##cdr _tl119452119492_)))
                                    (let ((_c119502_ _hd119453119497_))
                                      (if (##pair? _tl119454119499_)
                                          (let ((_hd119455119504_
                                                 (##car _tl119454119499_))
                                                (_tl119456119506_
                                                 (##cdr _tl119454119499_)))
                                            (let ((_d119509_ _hd119455119504_))
                                              (if (##pair? _tl119456119506_)
                                                  (let ((_hd119457119511_
                                                         (##car _tl119456119506_))
                                                        (_tl119458119513_
                                                         (##cdr _tl119456119506_)))
                                                    (let ((_e119516_
                                                           _hd119457119511_))
                                                      (if (##null? _tl119458119513_)
                                                          (_K119446119477_
                                                           _e119516_
                                                           _d119509_
                                                           _c119502_
                                                           _b119495_
                                                           _a119488_)
                                                          (_else119444119468_))))
                                                  (_else119444119468_))))
                                          (_else119444119468_))))
                                  (_else119444119468_))))
                          (_else119444119468_))))
                  (_else119444119468_)))
            (_else119444119468_)))))
  (define std/misc/uuid#uuid->string
    (lambda (_uuid119421_)
      (let ((_$e119423_
             (##direct-structure-ref
              _uuid119421_
              '2
              std/misc/uuid#uuid::t
              '#f)))
        (if _$e119423_
            (values _$e119423_)
            (let* ((_bytes119426_
                    (##direct-structure-ref
                     _uuid119421_
                     '1
                     std/misc/uuid#uuid::t
                     '#f))
                   (_a119428_ (std/text/hex#hex-encode__% _bytes119426_ '0 '4))
                   (_b119430_ (std/text/hex#hex-encode__% _bytes119426_ '4 '6))
                   (_c119432_ (std/text/hex#hex-encode__% _bytes119426_ '6 '8))
                   (_d119434_
                    (std/text/hex#hex-encode__% _bytes119426_ '8 '10))
                   (_e119436_
                    (std/text/hex#hex-encode__% _bytes119426_ '10 '16))
                   (_str119438_
                    (string-append
                     _a119428_
                     '"-"
                     _b119430_
                     '"-"
                     _c119432_
                     '"-"
                     _d119434_
                     '"-"
                     _e119436_)))
              (##direct-structure-set!
               _uuid119421_
               _str119438_
               '2
               std/misc/uuid#uuid::t
               '#f)
              _str119438_))))))
