/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.panelsearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.log4j.Logger;
import org.zaproxy.zap.view.panelsearch.ComponentHighlighterProvider;
import org.zaproxy.zap.view.panelsearch.FoundComponent;
import org.zaproxy.zap.view.panelsearch.HighlightedComponent;
import org.zaproxy.zap.view.panelsearch.HighlighterResult;
import org.zaproxy.zap.view.panelsearch.items.ButtonSearch;
import org.zaproxy.zap.view.panelsearch.items.ComboBoxElementSearch;
import org.zaproxy.zap.view.panelsearch.items.ComboBoxSearch;
import org.zaproxy.zap.view.panelsearch.items.ComponentHighlighter;
import org.zaproxy.zap.view.panelsearch.items.JxLabelSearch;
import org.zaproxy.zap.view.panelsearch.items.LabelSearch;
import org.zaproxy.zap.view.panelsearch.items.SpinnerSearch;
import org.zaproxy.zap.view.panelsearch.items.TabbedPaneElementSearch;
import org.zaproxy.zap.view.panelsearch.items.TabbedPaneSearch;
import org.zaproxy.zap.view.panelsearch.items.TableCellElementSearch;
import org.zaproxy.zap.view.panelsearch.items.TableSearch;
import org.zaproxy.zap.view.panelsearch.items.TextFieldSearch;
import org.zaproxy.zap.view.panelsearch.items.TitledBorderSearch;
import org.zaproxy.zap.view.panelsearch.items.TreeNodeElementSearch;

public class Highlighter {
    private Logger LOGGER = Logger.getLogger(Highlighter.class);
    public static final List<ComponentHighlighter> DefaultComponentHighlighterItems = Arrays.asList(new ButtonSearch(), new TreeNodeElementSearch(), new JxLabelSearch(), new LabelSearch(), new SpinnerSearch(), new TextFieldSearch(), new ComboBoxSearch(), new ComboBoxElementSearch(), new TableSearch(), new TableCellElementSearch(), new TabbedPaneSearch(), new TabbedPaneElementSearch(), new TitledBorderSearch());
    private final List<ComponentHighlighter> componentHighlighterItems;

    public Highlighter(List<ComponentHighlighter> componentHighlighterItems) {
        if (componentHighlighterItems == null) {
            throw new IllegalArgumentException("componentHighlighterItems is null");
        }
        this.componentHighlighterItems = new ArrayList<ComponentHighlighter>(componentHighlighterItems);
    }

    public HighlighterResult highlight(ArrayList<FoundComponent> foundComponents) {
        ArrayList<HighlightedComponent> highlightedComponents = new ArrayList<HighlightedComponent>();
        ArrayList<HighlightedComponent> highlightedParentComponents = new ArrayList<HighlightedComponent>();
        for (FoundComponent foundComponent : foundComponents) {
            highlightedComponents.addAll(this.highlightComponents(Arrays.asList(foundComponent.getComponent()), (h, c) -> h.highlight(c)));
            highlightedParentComponents.addAll(this.highlightComponents(foundComponent.getParents(), (h, c) -> h.highlightAsParent(c)));
        }
        return new HighlighterResult(highlightedComponents, highlightedParentComponents);
    }

    private ArrayList<HighlightedComponent> highlightComponents(List<Object> components, BiFunction<ComponentHighlighter, Object, HighlightedComponent> highlightAction) {
        ArrayList<HighlightedComponent> highlightedComponents = new ArrayList<HighlightedComponent>();
        for (Object component : components) {
            HighlightedComponent highlightedComponent = this.highlightComponent(component, highlightAction);
            if (highlightedComponent == null) continue;
            highlightedComponents.add(highlightedComponent);
        }
        return highlightedComponents;
    }

    private HighlightedComponent highlightComponent(Object component, BiFunction<ComponentHighlighter, Object, HighlightedComponent> highlightAction) {
        for (ComponentHighlighter componentHighlighter : this.componentHighlighterItems) {
            HighlightedComponent highlightedComponent = highlightAction.apply(componentHighlighter, component);
            if (highlightedComponent == null) continue;
            return highlightedComponent;
        }
        this.LOGGER.debug((Object)"Nothing to highlight here!");
        return null;
    }

    public void undoHighlight(HighlighterResult highlighterResult) {
        ComponentHighlighter componentHighlighter;
        boolean hasUndoSomething;
        Iterator<ComponentHighlighter> iterator;
        for (HighlightedComponent highlightedComponent : highlighterResult.getHighlightedComponents()) {
            iterator = this.componentHighlighterItems.iterator();
            while (iterator.hasNext() && !(hasUndoSomething = (componentHighlighter = iterator.next()).undoHighlight(highlightedComponent))) {
            }
        }
        for (HighlightedComponent highlightedParentComponent : highlighterResult.getHighlightedParentComponents()) {
            iterator = this.componentHighlighterItems.iterator();
            while (iterator.hasNext() && !(hasUndoSomething = (componentHighlighter = iterator.next()).undoHighlightAsParent(highlightedParentComponent))) {
            }
        }
    }

    public void registerComponentHighlighter(ComponentHighlighter componentHighlighter) {
        this.componentHighlighterItems.add(0, componentHighlighter);
    }

    public void registerComponentHighlighter(ComponentHighlighterProvider componentHighlighterProvider) {
        List<ComponentHighlighter> componentHighlighters = componentHighlighterProvider.getComponentHighlighter();
        if (componentHighlighters != null) {
            for (ComponentHighlighter componentHighlighter : componentHighlighters) {
                this.registerComponentHighlighter(componentHighlighter);
            }
        }
    }

    public void removeComponentHighlighter(ComponentHighlighter componentHighlighter) {
        this.componentHighlighterItems.remove(componentHighlighter);
    }

    public void removeComponentHighlighter(ComponentHighlighterProvider componentHighlighterProvider) {
        List<ComponentHighlighter> componentHighlighters = componentHighlighterProvider.getComponentHighlighter();
        if (componentHighlighters != null) {
            for (ComponentHighlighter componentHighlighter : componentHighlighters) {
                this.removeComponentHighlighter(componentHighlighter);
            }
        }
    }
}

