/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.fileloader;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.UriOpenable;
import org.jd.gui.service.fileloader.AbstractFileLoaderProvider;
import org.jd.gui.util.exception.ExceptionUtil;

public abstract class AbstractTypeFileLoaderProvider
extends AbstractFileLoaderProvider {
    protected boolean load(API api, File file, String pathInFile) {
        String pathSuffix = pathInFile;
        String path = file.getPath();
        while (!path.endsWith(pathSuffix)) {
            int index = pathSuffix.indexOf(File.separator);
            if (index == -1) {
                pathSuffix = "";
                continue;
            }
            pathSuffix = pathSuffix.substring(index + 1);
        }
        if (!pathSuffix.isEmpty()) {
            File rootFile = file;
            int index = pathSuffix.indexOf(File.separator);
            while (index != -1) {
                rootFile = rootFile.getParentFile();
                pathSuffix = pathSuffix.substring(index + 1);
                index = pathSuffix.indexOf(File.separator);
            }
            Object mainPanel = this.load(api, rootFile = rootFile.getParentFile(), Paths.get(rootFile.toURI()));
            if (mainPanel instanceof UriOpenable) {
                try {
                    pathSuffix = file.getAbsolutePath().substring(rootFile.getAbsolutePath().length()).replace(File.separator, "/");
                    URI rootUri = rootFile.toURI();
                    URI uri = new URI(rootUri.getScheme(), rootUri.getHost(), rootUri.getPath() + '!' + pathSuffix, null);
                    ((UriOpenable)mainPanel).openUri(uri);
                    return true;
                }
                catch (URISyntaxException e) {
                    assert (ExceptionUtil.printStackTrace(e));
                }
            } else {
                return mainPanel != null;
            }
        }
        return false;
    }
}

