/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.Iterator;
import java.util.Map;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.DiamondTypeArgument;
import org.jd.core.v1.model.javasyntax.type.GenericType;
import org.jd.core.v1.model.javasyntax.type.InnerObjectType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgument;
import org.jd.core.v1.model.javasyntax.type.TypeArgumentVisitor;
import org.jd.core.v1.model.javasyntax.type.TypeArguments;
import org.jd.core.v1.model.javasyntax.type.WildcardExtendsTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardSuperTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardTypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.TypeArgumentToTypeVisitor;

public class PopulateBindingsWithTypeArgumentVisitor
implements TypeArgumentVisitor {
    protected TypeArgumentToTypeVisitor typeArgumentToTypeVisitor = new TypeArgumentToTypeVisitor();
    protected TypeMaker typeMaker;
    protected Map<String, BaseType> contextualTypeBounds;
    protected Map<String, TypeArgument> bindings;
    protected Map<String, BaseType> typeBounds;
    protected BaseTypeArgument current;

    public PopulateBindingsWithTypeArgumentVisitor(TypeMaker typeMaker) {
        this.typeMaker = typeMaker;
        this.current = null;
    }

    public void init(Map<String, BaseType> contextualTypeBounds, Map<String, TypeArgument> bindings, Map<String, BaseType> typeBounds, BaseTypeArgument typeArgument) {
        this.contextualTypeBounds = contextualTypeBounds;
        this.bindings = bindings;
        this.typeBounds = typeBounds;
        this.current = typeArgument;
    }

    @Override
    public void visit(TypeArguments arguments) {
        if (this.current != null && this.current.isTypeArgumentList()) {
            Iterator typeArgumentIterator = arguments.iterator();
            Iterator typeGenericArgumentIterator = this.current.getTypeArgumentList().iterator();
            while (typeArgumentIterator.hasNext()) {
                this.current = (BaseTypeArgument)typeGenericArgumentIterator.next();
                ((TypeArgument)typeArgumentIterator.next()).accept(this);
            }
        }
    }

    @Override
    public void visit(GenericType type) {
        String typeName = type.getName();
        if (this.bindings.containsKey(typeName)) {
            TypeArgument typeArgument = this.bindings.get(type.getName());
            if (this.current != null) {
                if (this.current.getClass() == GenericType.class && !PopulateBindingsWithTypeArgumentVisitor.equals(this.contextualTypeBounds.get(typeName), this.typeBounds.get(((GenericType)this.current).getName()))) {
                    return;
                }
                if (typeArgument == null) {
                    this.bindings.put(typeName, this.checkTypeClassCheckDimensionAndReturnCurrentAsTypeArgument(type));
                } else if (!this.current.equals(typeArgument)) {
                    ObjectType ot2;
                    ObjectType ot1;
                    this.typeArgumentToTypeVisitor.init();
                    typeArgument.accept(this.typeArgumentToTypeVisitor);
                    Type t1 = this.typeArgumentToTypeVisitor.getType();
                    this.typeArgumentToTypeVisitor.init();
                    this.current.accept(this.typeArgumentToTypeVisitor);
                    Type t2 = this.typeArgumentToTypeVisitor.getType();
                    if (!t1.createType(0).equals(t2.createType(0)) && t1.isObject() && t2.isObject() && !this.typeMaker.isAssignable(this.typeBounds, ot1 = (ObjectType)t1, ot2 = (ObjectType)t2.createType(t2.getDimension() - type.getDimension()))) {
                        if (this.typeMaker.isAssignable(this.typeBounds, ot2, ot1)) {
                            this.bindings.put(typeName, this.checkTypeClassCheckDimensionAndReturnCurrentAsTypeArgument(type));
                        } else {
                            this.bindings.put(typeName, WildcardTypeArgument.WILDCARD_TYPE_ARGUMENT);
                        }
                    }
                }
            }
        }
    }

    private static boolean equals(BaseType bt1, BaseType bt2) {
        return bt2 == null || bt2.equals(bt1);
    }

    protected TypeArgument checkTypeClassCheckDimensionAndReturnCurrentAsTypeArgument(GenericType type) {
        if (this.current != null) {
            Class<?> currentClass = this.current.getClass();
            if (currentClass == ObjectType.class) {
                ObjectType ot = (ObjectType)this.current;
                if (ot.getTypeArguments() == null && ot.getInternalName().equals(ObjectType.TYPE_CLASS.getInternalName())) {
                    return ObjectType.TYPE_CLASS_WILDCARD.createType(ot.getDimension());
                }
                return ot.createType(ot.getDimension() - type.getDimension());
            }
            if (currentClass == InnerObjectType.class || currentClass == GenericType.class || currentClass == PrimitiveType.class) {
                Type t = (Type)this.current;
                return t.createType(t.getDimension() - type.getDimension());
            }
        }
        return this.current.getTypeArgumentFirst();
    }

    @Override
    public void visit(WildcardExtendsTypeArgument type) {
        if (this.current != null) {
            if (this.current.getClass() == WildcardExtendsTypeArgument.class) {
                this.current = ((WildcardExtendsTypeArgument)this.current).getType();
                type.getType().accept(this);
            } else {
                type.getType().accept(this);
            }
        }
    }

    @Override
    public void visit(WildcardSuperTypeArgument type) {
        if (this.current != null) {
            if (this.current.getClass() == WildcardSuperTypeArgument.class) {
                this.current = ((WildcardSuperTypeArgument)this.current).getType();
                type.getType().accept(this);
            } else {
                type.getType().accept(this);
            }
        }
    }

    @Override
    public void visit(ObjectType type) {
        if (this.current != null && type.getTypeArguments() != null && (this.current.getClass() == ObjectType.class || this.current.getClass() == InnerObjectType.class)) {
            this.current = ((ObjectType)this.current).getTypeArguments();
            type.getTypeArguments().accept(this);
        }
    }

    @Override
    public void visit(InnerObjectType type) {
        if (this.current != null && type.getTypeArguments() != null && this.current.getClass() == InnerObjectType.class) {
            this.current = ((InnerObjectType)this.current).getTypeArguments();
            type.getTypeArguments().accept(this);
        }
    }

    @Override
    public void visit(DiamondTypeArgument argument) {
    }

    @Override
    public void visit(WildcardTypeArgument type) {
    }

    @Override
    public void visit(PrimitiveType type) {
    }
}

