/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import com.adobe.epubcheck.util.EPUBVersion;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidParameterException;

public class CheckUtil {
    public static boolean checkString(byte[] arr, int offset, String string) {
        try {
            byte[] bytes = string.getBytes("UTF-8");
            if (bytes.length + offset > arr.length) {
                return false;
            }
            for (int i = 0; i < bytes.length; ++i) {
                if (arr[offset + i] == bytes[i]) continue;
                return false;
            }
            return true;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean checkTrailingSpaces(InputStream input, EPUBVersion version, StringBuilder sb) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        for (int i = 0; i < 20; ++i) {
            int c = input.read();
            if (c == -1) {
                return true;
            }
            baos.write(c);
        }
        if (!baos.toString().equals("application/epub+zip")) {
            return true;
        }
        int ch = input.read();
        if (ch != -1) {
            return false;
        }
        byte[] buf = new byte[1024];
        while ((len = input.read(buf)) > 0) {
            for (int i = 0; i < len; ++i) {
                if (buf[i] != 32) {
                    return false;
                }
                baos.write(buf[i]);
            }
        }
        sb.append(baos.toString());
        baos.close();
        return true;
    }

    public static int readBytes(InputStream in, byte[] b, int off, int len) throws IOException {
        int total;
        int result;
        if (len < 1) {
            throw new InvalidParameterException(Integer.toString(len));
        }
        for (total = 0; total < len && (result = in.read(b, off + total, len - total)) != -1; total += result) {
        }
        return total;
    }
}

