/* GL dispatch code.
 * This is code-generated from the GL API XML files from Khronos.
 * 
 * Copyright (c) 2013-2017 The Khronos Group Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

#include "config.h"

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "dispatch_common.h"
#include "epoxy/gl.h"

#ifdef __GNUC__
#define EPOXY_NOINLINE __attribute__((noinline))
#elif defined (_MSC_VER)
#define EPOXY_NOINLINE __declspec(noinline)
#endif
struct dispatch_table {
    PFNGLACCUMPROC epoxy_glAccum;
    PFNGLACCUMXOESPROC epoxy_glAccumxOES;
    PFNGLACQUIREKEYEDMUTEXWIN32EXTPROC epoxy_glAcquireKeyedMutexWin32EXT;
    PFNGLACTIVEPROGRAMEXTPROC epoxy_glActiveProgramEXT;
    PFNGLACTIVESHADERPROGRAMPROC epoxy_glActiveShaderProgram;
    PFNGLACTIVESHADERPROGRAMEXTPROC epoxy_glActiveShaderProgramEXT;
    PFNGLACTIVESTENCILFACEEXTPROC epoxy_glActiveStencilFaceEXT;
    PFNGLACTIVETEXTUREPROC epoxy_glActiveTexture;
    PFNGLACTIVETEXTUREARBPROC epoxy_glActiveTextureARB;
    PFNGLACTIVEVARYINGNVPROC epoxy_glActiveVaryingNV;
    PFNGLALPHAFRAGMENTOP1ATIPROC epoxy_glAlphaFragmentOp1ATI;
    PFNGLALPHAFRAGMENTOP2ATIPROC epoxy_glAlphaFragmentOp2ATI;
    PFNGLALPHAFRAGMENTOP3ATIPROC epoxy_glAlphaFragmentOp3ATI;
    PFNGLALPHAFUNCPROC epoxy_glAlphaFunc;
    PFNGLALPHAFUNCQCOMPROC epoxy_glAlphaFuncQCOM;
    PFNGLALPHAFUNCXPROC epoxy_glAlphaFuncx;
    PFNGLALPHAFUNCXOESPROC epoxy_glAlphaFuncxOES;
    PFNGLALPHATOCOVERAGEDITHERCONTROLNVPROC epoxy_glAlphaToCoverageDitherControlNV;
    PFNGLAPPLYFRAMEBUFFERATTACHMENTCMAAINTELPROC epoxy_glApplyFramebufferAttachmentCMAAINTEL;
    PFNGLAPPLYTEXTUREEXTPROC epoxy_glApplyTextureEXT;
    PFNGLAREPROGRAMSRESIDENTNVPROC epoxy_glAreProgramsResidentNV;
    PFNGLARETEXTURESRESIDENTPROC epoxy_glAreTexturesResident;
    PFNGLARETEXTURESRESIDENTEXTPROC epoxy_glAreTexturesResidentEXT;
    PFNGLARRAYELEMENTPROC epoxy_glArrayElement;
    PFNGLARRAYELEMENTEXTPROC epoxy_glArrayElementEXT;
    PFNGLARRAYOBJECTATIPROC epoxy_glArrayObjectATI;
    PFNGLASYNCMARKERSGIXPROC epoxy_glAsyncMarkerSGIX;
    PFNGLATTACHOBJECTARBPROC epoxy_glAttachObjectARB;
    PFNGLATTACHSHADERPROC epoxy_glAttachShader;
    PFNGLBEGINPROC epoxy_glBegin_unwrapped;
    PFNGLBEGINCONDITIONALRENDERPROC epoxy_glBeginConditionalRender;
    PFNGLBEGINCONDITIONALRENDERNVPROC epoxy_glBeginConditionalRenderNV;
    PFNGLBEGINCONDITIONALRENDERNVXPROC epoxy_glBeginConditionalRenderNVX;
    PFNGLBEGINFRAGMENTSHADERATIPROC epoxy_glBeginFragmentShaderATI;
    PFNGLBEGINOCCLUSIONQUERYNVPROC epoxy_glBeginOcclusionQueryNV;
    PFNGLBEGINPERFMONITORAMDPROC epoxy_glBeginPerfMonitorAMD;
    PFNGLBEGINPERFQUERYINTELPROC epoxy_glBeginPerfQueryINTEL;
    PFNGLBEGINQUERYPROC epoxy_glBeginQuery;
    PFNGLBEGINQUERYARBPROC epoxy_glBeginQueryARB;
    PFNGLBEGINQUERYEXTPROC epoxy_glBeginQueryEXT;
    PFNGLBEGINQUERYINDEXEDPROC epoxy_glBeginQueryIndexed;
    PFNGLBEGINTRANSFORMFEEDBACKPROC epoxy_glBeginTransformFeedback;
    PFNGLBEGINTRANSFORMFEEDBACKEXTPROC epoxy_glBeginTransformFeedbackEXT;
    PFNGLBEGINTRANSFORMFEEDBACKNVPROC epoxy_glBeginTransformFeedbackNV;
    PFNGLBEGINVERTEXSHADEREXTPROC epoxy_glBeginVertexShaderEXT;
    PFNGLBEGINVIDEOCAPTURENVPROC epoxy_glBeginVideoCaptureNV;
    PFNGLBINDATTRIBLOCATIONPROC epoxy_glBindAttribLocation;
    PFNGLBINDATTRIBLOCATIONARBPROC epoxy_glBindAttribLocationARB;
    PFNGLBINDBUFFERPROC epoxy_glBindBuffer;
    PFNGLBINDBUFFERARBPROC epoxy_glBindBufferARB;
    PFNGLBINDBUFFERBASEPROC epoxy_glBindBufferBase;
    PFNGLBINDBUFFERBASEEXTPROC epoxy_glBindBufferBaseEXT;
    PFNGLBINDBUFFERBASENVPROC epoxy_glBindBufferBaseNV;
    PFNGLBINDBUFFEROFFSETEXTPROC epoxy_glBindBufferOffsetEXT;
    PFNGLBINDBUFFEROFFSETNVPROC epoxy_glBindBufferOffsetNV;
    PFNGLBINDBUFFERRANGEPROC epoxy_glBindBufferRange;
    PFNGLBINDBUFFERRANGEEXTPROC epoxy_glBindBufferRangeEXT;
    PFNGLBINDBUFFERRANGENVPROC epoxy_glBindBufferRangeNV;
    PFNGLBINDBUFFERSBASEPROC epoxy_glBindBuffersBase;
    PFNGLBINDBUFFERSRANGEPROC epoxy_glBindBuffersRange;
    PFNGLBINDFRAGDATALOCATIONPROC epoxy_glBindFragDataLocation;
    PFNGLBINDFRAGDATALOCATIONEXTPROC epoxy_glBindFragDataLocationEXT;
    PFNGLBINDFRAGDATALOCATIONINDEXEDPROC epoxy_glBindFragDataLocationIndexed;
    PFNGLBINDFRAGDATALOCATIONINDEXEDEXTPROC epoxy_glBindFragDataLocationIndexedEXT;
    PFNGLBINDFRAGMENTSHADERATIPROC epoxy_glBindFragmentShaderATI;
    PFNGLBINDFRAMEBUFFERPROC epoxy_glBindFramebuffer;
    PFNGLBINDFRAMEBUFFEREXTPROC epoxy_glBindFramebufferEXT;
    PFNGLBINDFRAMEBUFFEROESPROC epoxy_glBindFramebufferOES;
    PFNGLBINDIMAGETEXTUREPROC epoxy_glBindImageTexture;
    PFNGLBINDIMAGETEXTUREEXTPROC epoxy_glBindImageTextureEXT;
    PFNGLBINDIMAGETEXTURESPROC epoxy_glBindImageTextures;
    PFNGLBINDLIGHTPARAMETEREXTPROC epoxy_glBindLightParameterEXT;
    PFNGLBINDMATERIALPARAMETEREXTPROC epoxy_glBindMaterialParameterEXT;
    PFNGLBINDMULTITEXTUREEXTPROC epoxy_glBindMultiTextureEXT;
    PFNGLBINDPARAMETEREXTPROC epoxy_glBindParameterEXT;
    PFNGLBINDPROGRAMARBPROC epoxy_glBindProgramARB;
    PFNGLBINDPROGRAMNVPROC epoxy_glBindProgramNV;
    PFNGLBINDPROGRAMPIPELINEPROC epoxy_glBindProgramPipeline;
    PFNGLBINDPROGRAMPIPELINEEXTPROC epoxy_glBindProgramPipelineEXT;
    PFNGLBINDRENDERBUFFERPROC epoxy_glBindRenderbuffer;
    PFNGLBINDRENDERBUFFEREXTPROC epoxy_glBindRenderbufferEXT;
    PFNGLBINDRENDERBUFFEROESPROC epoxy_glBindRenderbufferOES;
    PFNGLBINDSAMPLERPROC epoxy_glBindSampler;
    PFNGLBINDSAMPLERSPROC epoxy_glBindSamplers;
    PFNGLBINDTEXGENPARAMETEREXTPROC epoxy_glBindTexGenParameterEXT;
    PFNGLBINDTEXTUREPROC epoxy_glBindTexture;
    PFNGLBINDTEXTUREEXTPROC epoxy_glBindTextureEXT;
    PFNGLBINDTEXTUREUNITPROC epoxy_glBindTextureUnit;
    PFNGLBINDTEXTUREUNITPARAMETEREXTPROC epoxy_glBindTextureUnitParameterEXT;
    PFNGLBINDTEXTURESPROC epoxy_glBindTextures;
    PFNGLBINDTRANSFORMFEEDBACKPROC epoxy_glBindTransformFeedback;
    PFNGLBINDTRANSFORMFEEDBACKNVPROC epoxy_glBindTransformFeedbackNV;
    PFNGLBINDVERTEXARRAYPROC epoxy_glBindVertexArray;
    PFNGLBINDVERTEXARRAYAPPLEPROC epoxy_glBindVertexArrayAPPLE;
    PFNGLBINDVERTEXARRAYOESPROC epoxy_glBindVertexArrayOES;
    PFNGLBINDVERTEXBUFFERPROC epoxy_glBindVertexBuffer;
    PFNGLBINDVERTEXBUFFERSPROC epoxy_glBindVertexBuffers;
    PFNGLBINDVERTEXSHADEREXTPROC epoxy_glBindVertexShaderEXT;
    PFNGLBINDVIDEOCAPTURESTREAMBUFFERNVPROC epoxy_glBindVideoCaptureStreamBufferNV;
    PFNGLBINDVIDEOCAPTURESTREAMTEXTURENVPROC epoxy_glBindVideoCaptureStreamTextureNV;
    PFNGLBINORMAL3BEXTPROC epoxy_glBinormal3bEXT;
    PFNGLBINORMAL3BVEXTPROC epoxy_glBinormal3bvEXT;
    PFNGLBINORMAL3DEXTPROC epoxy_glBinormal3dEXT;
    PFNGLBINORMAL3DVEXTPROC epoxy_glBinormal3dvEXT;
    PFNGLBINORMAL3FEXTPROC epoxy_glBinormal3fEXT;
    PFNGLBINORMAL3FVEXTPROC epoxy_glBinormal3fvEXT;
    PFNGLBINORMAL3IEXTPROC epoxy_glBinormal3iEXT;
    PFNGLBINORMAL3IVEXTPROC epoxy_glBinormal3ivEXT;
    PFNGLBINORMAL3SEXTPROC epoxy_glBinormal3sEXT;
    PFNGLBINORMAL3SVEXTPROC epoxy_glBinormal3svEXT;
    PFNGLBINORMALPOINTEREXTPROC epoxy_glBinormalPointerEXT;
    PFNGLBITMAPPROC epoxy_glBitmap;
    PFNGLBITMAPXOESPROC epoxy_glBitmapxOES;
    PFNGLBLENDBARRIERPROC epoxy_glBlendBarrier;
    PFNGLBLENDBARRIERKHRPROC epoxy_glBlendBarrierKHR;
    PFNGLBLENDBARRIERNVPROC epoxy_glBlendBarrierNV;
    PFNGLBLENDCOLORPROC epoxy_glBlendColor;
    PFNGLBLENDCOLOREXTPROC epoxy_glBlendColorEXT;
    PFNGLBLENDCOLORXOESPROC epoxy_glBlendColorxOES;
    PFNGLBLENDEQUATIONPROC epoxy_glBlendEquation;
    PFNGLBLENDEQUATIONEXTPROC epoxy_glBlendEquationEXT;
    PFNGLBLENDEQUATIONINDEXEDAMDPROC epoxy_glBlendEquationIndexedAMD;
    PFNGLBLENDEQUATIONOESPROC epoxy_glBlendEquationOES;
    PFNGLBLENDEQUATIONSEPARATEPROC epoxy_glBlendEquationSeparate;
    PFNGLBLENDEQUATIONSEPARATEEXTPROC epoxy_glBlendEquationSeparateEXT;
    PFNGLBLENDEQUATIONSEPARATEINDEXEDAMDPROC epoxy_glBlendEquationSeparateIndexedAMD;
    PFNGLBLENDEQUATIONSEPARATEOESPROC epoxy_glBlendEquationSeparateOES;
    PFNGLBLENDEQUATIONSEPARATEIPROC epoxy_glBlendEquationSeparatei;
    PFNGLBLENDEQUATIONSEPARATEIARBPROC epoxy_glBlendEquationSeparateiARB;
    PFNGLBLENDEQUATIONSEPARATEIEXTPROC epoxy_glBlendEquationSeparateiEXT;
    PFNGLBLENDEQUATIONSEPARATEIOESPROC epoxy_glBlendEquationSeparateiOES;
    PFNGLBLENDEQUATIONIPROC epoxy_glBlendEquationi;
    PFNGLBLENDEQUATIONIARBPROC epoxy_glBlendEquationiARB;
    PFNGLBLENDEQUATIONIEXTPROC epoxy_glBlendEquationiEXT;
    PFNGLBLENDEQUATIONIOESPROC epoxy_glBlendEquationiOES;
    PFNGLBLENDFUNCPROC epoxy_glBlendFunc;
    PFNGLBLENDFUNCINDEXEDAMDPROC epoxy_glBlendFuncIndexedAMD;
    PFNGLBLENDFUNCSEPARATEPROC epoxy_glBlendFuncSeparate;
    PFNGLBLENDFUNCSEPARATEEXTPROC epoxy_glBlendFuncSeparateEXT;
    PFNGLBLENDFUNCSEPARATEINGRPROC epoxy_glBlendFuncSeparateINGR;
    PFNGLBLENDFUNCSEPARATEINDEXEDAMDPROC epoxy_glBlendFuncSeparateIndexedAMD;
    PFNGLBLENDFUNCSEPARATEOESPROC epoxy_glBlendFuncSeparateOES;
    PFNGLBLENDFUNCSEPARATEIPROC epoxy_glBlendFuncSeparatei;
    PFNGLBLENDFUNCSEPARATEIARBPROC epoxy_glBlendFuncSeparateiARB;
    PFNGLBLENDFUNCSEPARATEIEXTPROC epoxy_glBlendFuncSeparateiEXT;
    PFNGLBLENDFUNCSEPARATEIOESPROC epoxy_glBlendFuncSeparateiOES;
    PFNGLBLENDFUNCIPROC epoxy_glBlendFunci;
    PFNGLBLENDFUNCIARBPROC epoxy_glBlendFunciARB;
    PFNGLBLENDFUNCIEXTPROC epoxy_glBlendFunciEXT;
    PFNGLBLENDFUNCIOESPROC epoxy_glBlendFunciOES;
    PFNGLBLENDPARAMETERINVPROC epoxy_glBlendParameteriNV;
    PFNGLBLITFRAMEBUFFERPROC epoxy_glBlitFramebuffer;
    PFNGLBLITFRAMEBUFFERANGLEPROC epoxy_glBlitFramebufferANGLE;
    PFNGLBLITFRAMEBUFFEREXTPROC epoxy_glBlitFramebufferEXT;
    PFNGLBLITFRAMEBUFFERNVPROC epoxy_glBlitFramebufferNV;
    PFNGLBLITNAMEDFRAMEBUFFERPROC epoxy_glBlitNamedFramebuffer;
    PFNGLBUFFERADDRESSRANGENVPROC epoxy_glBufferAddressRangeNV;
    PFNGLBUFFERDATAPROC epoxy_glBufferData;
    PFNGLBUFFERDATAARBPROC epoxy_glBufferDataARB;
    PFNGLBUFFERPAGECOMMITMENTARBPROC epoxy_glBufferPageCommitmentARB;
    PFNGLBUFFERPARAMETERIAPPLEPROC epoxy_glBufferParameteriAPPLE;
    PFNGLBUFFERSTORAGEPROC epoxy_glBufferStorage;
    PFNGLBUFFERSTORAGEEXTPROC epoxy_glBufferStorageEXT;
    PFNGLBUFFERSTORAGEEXTERNALEXTPROC epoxy_glBufferStorageExternalEXT;
    PFNGLBUFFERSTORAGEMEMEXTPROC epoxy_glBufferStorageMemEXT;
    PFNGLBUFFERSUBDATAPROC epoxy_glBufferSubData;
    PFNGLBUFFERSUBDATAARBPROC epoxy_glBufferSubDataARB;
    PFNGLCALLCOMMANDLISTNVPROC epoxy_glCallCommandListNV;
    PFNGLCALLLISTPROC epoxy_glCallList;
    PFNGLCALLLISTSPROC epoxy_glCallLists;
    PFNGLCHECKFRAMEBUFFERSTATUSPROC epoxy_glCheckFramebufferStatus;
    PFNGLCHECKFRAMEBUFFERSTATUSEXTPROC epoxy_glCheckFramebufferStatusEXT;
    PFNGLCHECKFRAMEBUFFERSTATUSOESPROC epoxy_glCheckFramebufferStatusOES;
    PFNGLCHECKNAMEDFRAMEBUFFERSTATUSPROC epoxy_glCheckNamedFramebufferStatus;
    PFNGLCHECKNAMEDFRAMEBUFFERSTATUSEXTPROC epoxy_glCheckNamedFramebufferStatusEXT;
    PFNGLCLAMPCOLORPROC epoxy_glClampColor;
    PFNGLCLAMPCOLORARBPROC epoxy_glClampColorARB;
    PFNGLCLEARPROC epoxy_glClear;
    PFNGLCLEARACCUMPROC epoxy_glClearAccum;
    PFNGLCLEARACCUMXOESPROC epoxy_glClearAccumxOES;
    PFNGLCLEARBUFFERDATAPROC epoxy_glClearBufferData;
    PFNGLCLEARBUFFERSUBDATAPROC epoxy_glClearBufferSubData;
    PFNGLCLEARBUFFERFIPROC epoxy_glClearBufferfi;
    PFNGLCLEARBUFFERFVPROC epoxy_glClearBufferfv;
    PFNGLCLEARBUFFERIVPROC epoxy_glClearBufferiv;
    PFNGLCLEARBUFFERUIVPROC epoxy_glClearBufferuiv;
    PFNGLCLEARCOLORPROC epoxy_glClearColor;
    PFNGLCLEARCOLORIIEXTPROC epoxy_glClearColorIiEXT;
    PFNGLCLEARCOLORIUIEXTPROC epoxy_glClearColorIuiEXT;
    PFNGLCLEARCOLORXPROC epoxy_glClearColorx;
    PFNGLCLEARCOLORXOESPROC epoxy_glClearColorxOES;
    PFNGLCLEARDEPTHPROC epoxy_glClearDepth;
    PFNGLCLEARDEPTHDNVPROC epoxy_glClearDepthdNV;
    PFNGLCLEARDEPTHFPROC epoxy_glClearDepthf;
    PFNGLCLEARDEPTHFOESPROC epoxy_glClearDepthfOES;
    PFNGLCLEARDEPTHXPROC epoxy_glClearDepthx;
    PFNGLCLEARDEPTHXOESPROC epoxy_glClearDepthxOES;
    PFNGLCLEARINDEXPROC epoxy_glClearIndex;
    PFNGLCLEARNAMEDBUFFERDATAPROC epoxy_glClearNamedBufferData;
    PFNGLCLEARNAMEDBUFFERDATAEXTPROC epoxy_glClearNamedBufferDataEXT;
    PFNGLCLEARNAMEDBUFFERSUBDATAPROC epoxy_glClearNamedBufferSubData;
    PFNGLCLEARNAMEDBUFFERSUBDATAEXTPROC epoxy_glClearNamedBufferSubDataEXT;
    PFNGLCLEARNAMEDFRAMEBUFFERFIPROC epoxy_glClearNamedFramebufferfi;
    PFNGLCLEARNAMEDFRAMEBUFFERFVPROC epoxy_glClearNamedFramebufferfv;
    PFNGLCLEARNAMEDFRAMEBUFFERIVPROC epoxy_glClearNamedFramebufferiv;
    PFNGLCLEARNAMEDFRAMEBUFFERUIVPROC epoxy_glClearNamedFramebufferuiv;
    PFNGLCLEARPIXELLOCALSTORAGEUIEXTPROC epoxy_glClearPixelLocalStorageuiEXT;
    PFNGLCLEARSTENCILPROC epoxy_glClearStencil;
    PFNGLCLEARTEXIMAGEPROC epoxy_glClearTexImage;
    PFNGLCLEARTEXIMAGEEXTPROC epoxy_glClearTexImageEXT;
    PFNGLCLEARTEXSUBIMAGEPROC epoxy_glClearTexSubImage;
    PFNGLCLEARTEXSUBIMAGEEXTPROC epoxy_glClearTexSubImageEXT;
    PFNGLCLIENTACTIVETEXTUREPROC epoxy_glClientActiveTexture;
    PFNGLCLIENTACTIVETEXTUREARBPROC epoxy_glClientActiveTextureARB;
    PFNGLCLIENTACTIVEVERTEXSTREAMATIPROC epoxy_glClientActiveVertexStreamATI;
    PFNGLCLIENTATTRIBDEFAULTEXTPROC epoxy_glClientAttribDefaultEXT;
    PFNGLCLIENTWAITSYNCPROC epoxy_glClientWaitSync;
    PFNGLCLIENTWAITSYNCAPPLEPROC epoxy_glClientWaitSyncAPPLE;
    PFNGLCLIPCONTROLPROC epoxy_glClipControl;
    PFNGLCLIPCONTROLEXTPROC epoxy_glClipControlEXT;
    PFNGLCLIPPLANEPROC epoxy_glClipPlane;
    PFNGLCLIPPLANEFPROC epoxy_glClipPlanef;
    PFNGLCLIPPLANEFIMGPROC epoxy_glClipPlanefIMG;
    PFNGLCLIPPLANEFOESPROC epoxy_glClipPlanefOES;
    PFNGLCLIPPLANEXPROC epoxy_glClipPlanex;
    PFNGLCLIPPLANEXIMGPROC epoxy_glClipPlanexIMG;
    PFNGLCLIPPLANEXOESPROC epoxy_glClipPlanexOES;
    PFNGLCOLOR3BPROC epoxy_glColor3b;
    PFNGLCOLOR3BVPROC epoxy_glColor3bv;
    PFNGLCOLOR3DPROC epoxy_glColor3d;
    PFNGLCOLOR3DVPROC epoxy_glColor3dv;
    PFNGLCOLOR3FPROC epoxy_glColor3f;
    PFNGLCOLOR3FVERTEX3FSUNPROC epoxy_glColor3fVertex3fSUN;
    PFNGLCOLOR3FVERTEX3FVSUNPROC epoxy_glColor3fVertex3fvSUN;
    PFNGLCOLOR3FVPROC epoxy_glColor3fv;
    PFNGLCOLOR3HNVPROC epoxy_glColor3hNV;
    PFNGLCOLOR3HVNVPROC epoxy_glColor3hvNV;
    PFNGLCOLOR3IPROC epoxy_glColor3i;
    PFNGLCOLOR3IVPROC epoxy_glColor3iv;
    PFNGLCOLOR3SPROC epoxy_glColor3s;
    PFNGLCOLOR3SVPROC epoxy_glColor3sv;
    PFNGLCOLOR3UBPROC epoxy_glColor3ub;
    PFNGLCOLOR3UBVPROC epoxy_glColor3ubv;
    PFNGLCOLOR3UIPROC epoxy_glColor3ui;
    PFNGLCOLOR3UIVPROC epoxy_glColor3uiv;
    PFNGLCOLOR3USPROC epoxy_glColor3us;
    PFNGLCOLOR3USVPROC epoxy_glColor3usv;
    PFNGLCOLOR3XOESPROC epoxy_glColor3xOES;
    PFNGLCOLOR3XVOESPROC epoxy_glColor3xvOES;
    PFNGLCOLOR4BPROC epoxy_glColor4b;
    PFNGLCOLOR4BVPROC epoxy_glColor4bv;
    PFNGLCOLOR4DPROC epoxy_glColor4d;
    PFNGLCOLOR4DVPROC epoxy_glColor4dv;
    PFNGLCOLOR4FPROC epoxy_glColor4f;
    PFNGLCOLOR4FNORMAL3FVERTEX3FSUNPROC epoxy_glColor4fNormal3fVertex3fSUN;
    PFNGLCOLOR4FNORMAL3FVERTEX3FVSUNPROC epoxy_glColor4fNormal3fVertex3fvSUN;
    PFNGLCOLOR4FVPROC epoxy_glColor4fv;
    PFNGLCOLOR4HNVPROC epoxy_glColor4hNV;
    PFNGLCOLOR4HVNVPROC epoxy_glColor4hvNV;
    PFNGLCOLOR4IPROC epoxy_glColor4i;
    PFNGLCOLOR4IVPROC epoxy_glColor4iv;
    PFNGLCOLOR4SPROC epoxy_glColor4s;
    PFNGLCOLOR4SVPROC epoxy_glColor4sv;
    PFNGLCOLOR4UBPROC epoxy_glColor4ub;
    PFNGLCOLOR4UBVERTEX2FSUNPROC epoxy_glColor4ubVertex2fSUN;
    PFNGLCOLOR4UBVERTEX2FVSUNPROC epoxy_glColor4ubVertex2fvSUN;
    PFNGLCOLOR4UBVERTEX3FSUNPROC epoxy_glColor4ubVertex3fSUN;
    PFNGLCOLOR4UBVERTEX3FVSUNPROC epoxy_glColor4ubVertex3fvSUN;
    PFNGLCOLOR4UBVPROC epoxy_glColor4ubv;
    PFNGLCOLOR4UIPROC epoxy_glColor4ui;
    PFNGLCOLOR4UIVPROC epoxy_glColor4uiv;
    PFNGLCOLOR4USPROC epoxy_glColor4us;
    PFNGLCOLOR4USVPROC epoxy_glColor4usv;
    PFNGLCOLOR4XPROC epoxy_glColor4x;
    PFNGLCOLOR4XOESPROC epoxy_glColor4xOES;
    PFNGLCOLOR4XVOESPROC epoxy_glColor4xvOES;
    PFNGLCOLORFORMATNVPROC epoxy_glColorFormatNV;
    PFNGLCOLORFRAGMENTOP1ATIPROC epoxy_glColorFragmentOp1ATI;
    PFNGLCOLORFRAGMENTOP2ATIPROC epoxy_glColorFragmentOp2ATI;
    PFNGLCOLORFRAGMENTOP3ATIPROC epoxy_glColorFragmentOp3ATI;
    PFNGLCOLORMASKPROC epoxy_glColorMask;
    PFNGLCOLORMASKINDEXEDEXTPROC epoxy_glColorMaskIndexedEXT;
    PFNGLCOLORMASKIPROC epoxy_glColorMaski;
    PFNGLCOLORMASKIEXTPROC epoxy_glColorMaskiEXT;
    PFNGLCOLORMASKIOESPROC epoxy_glColorMaskiOES;
    PFNGLCOLORMATERIALPROC epoxy_glColorMaterial;
    PFNGLCOLORP3UIPROC epoxy_glColorP3ui;
    PFNGLCOLORP3UIVPROC epoxy_glColorP3uiv;
    PFNGLCOLORP4UIPROC epoxy_glColorP4ui;
    PFNGLCOLORP4UIVPROC epoxy_glColorP4uiv;
    PFNGLCOLORPOINTERPROC epoxy_glColorPointer;
    PFNGLCOLORPOINTEREXTPROC epoxy_glColorPointerEXT;
    PFNGLCOLORPOINTERLISTIBMPROC epoxy_glColorPointerListIBM;
    PFNGLCOLORPOINTERVINTELPROC epoxy_glColorPointervINTEL;
    PFNGLCOLORSUBTABLEPROC epoxy_glColorSubTable;
    PFNGLCOLORSUBTABLEEXTPROC epoxy_glColorSubTableEXT;
    PFNGLCOLORTABLEPROC epoxy_glColorTable;
    PFNGLCOLORTABLEEXTPROC epoxy_glColorTableEXT;
    PFNGLCOLORTABLEPARAMETERFVPROC epoxy_glColorTableParameterfv;
    PFNGLCOLORTABLEPARAMETERFVSGIPROC epoxy_glColorTableParameterfvSGI;
    PFNGLCOLORTABLEPARAMETERIVPROC epoxy_glColorTableParameteriv;
    PFNGLCOLORTABLEPARAMETERIVSGIPROC epoxy_glColorTableParameterivSGI;
    PFNGLCOLORTABLESGIPROC epoxy_glColorTableSGI;
    PFNGLCOMBINERINPUTNVPROC epoxy_glCombinerInputNV;
    PFNGLCOMBINEROUTPUTNVPROC epoxy_glCombinerOutputNV;
    PFNGLCOMBINERPARAMETERFNVPROC epoxy_glCombinerParameterfNV;
    PFNGLCOMBINERPARAMETERFVNVPROC epoxy_glCombinerParameterfvNV;
    PFNGLCOMBINERPARAMETERINVPROC epoxy_glCombinerParameteriNV;
    PFNGLCOMBINERPARAMETERIVNVPROC epoxy_glCombinerParameterivNV;
    PFNGLCOMBINERSTAGEPARAMETERFVNVPROC epoxy_glCombinerStageParameterfvNV;
    PFNGLCOMMANDLISTSEGMENTSNVPROC epoxy_glCommandListSegmentsNV;
    PFNGLCOMPILECOMMANDLISTNVPROC epoxy_glCompileCommandListNV;
    PFNGLCOMPILESHADERPROC epoxy_glCompileShader;
    PFNGLCOMPILESHADERARBPROC epoxy_glCompileShaderARB;
    PFNGLCOMPILESHADERINCLUDEARBPROC epoxy_glCompileShaderIncludeARB;
    PFNGLCOMPRESSEDMULTITEXIMAGE1DEXTPROC epoxy_glCompressedMultiTexImage1DEXT;
    PFNGLCOMPRESSEDMULTITEXIMAGE2DEXTPROC epoxy_glCompressedMultiTexImage2DEXT;
    PFNGLCOMPRESSEDMULTITEXIMAGE3DEXTPROC epoxy_glCompressedMultiTexImage3DEXT;
    PFNGLCOMPRESSEDMULTITEXSUBIMAGE1DEXTPROC epoxy_glCompressedMultiTexSubImage1DEXT;
    PFNGLCOMPRESSEDMULTITEXSUBIMAGE2DEXTPROC epoxy_glCompressedMultiTexSubImage2DEXT;
    PFNGLCOMPRESSEDMULTITEXSUBIMAGE3DEXTPROC epoxy_glCompressedMultiTexSubImage3DEXT;
    PFNGLCOMPRESSEDTEXIMAGE1DPROC epoxy_glCompressedTexImage1D;
    PFNGLCOMPRESSEDTEXIMAGE1DARBPROC epoxy_glCompressedTexImage1DARB;
    PFNGLCOMPRESSEDTEXIMAGE2DPROC epoxy_glCompressedTexImage2D;
    PFNGLCOMPRESSEDTEXIMAGE2DARBPROC epoxy_glCompressedTexImage2DARB;
    PFNGLCOMPRESSEDTEXIMAGE3DPROC epoxy_glCompressedTexImage3D;
    PFNGLCOMPRESSEDTEXIMAGE3DARBPROC epoxy_glCompressedTexImage3DARB;
    PFNGLCOMPRESSEDTEXIMAGE3DOESPROC epoxy_glCompressedTexImage3DOES;
    PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC epoxy_glCompressedTexSubImage1D;
    PFNGLCOMPRESSEDTEXSUBIMAGE1DARBPROC epoxy_glCompressedTexSubImage1DARB;
    PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC epoxy_glCompressedTexSubImage2D;
    PFNGLCOMPRESSEDTEXSUBIMAGE2DARBPROC epoxy_glCompressedTexSubImage2DARB;
    PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC epoxy_glCompressedTexSubImage3D;
    PFNGLCOMPRESSEDTEXSUBIMAGE3DARBPROC epoxy_glCompressedTexSubImage3DARB;
    PFNGLCOMPRESSEDTEXSUBIMAGE3DOESPROC epoxy_glCompressedTexSubImage3DOES;
    PFNGLCOMPRESSEDTEXTUREIMAGE1DEXTPROC epoxy_glCompressedTextureImage1DEXT;
    PFNGLCOMPRESSEDTEXTUREIMAGE2DEXTPROC epoxy_glCompressedTextureImage2DEXT;
    PFNGLCOMPRESSEDTEXTUREIMAGE3DEXTPROC epoxy_glCompressedTextureImage3DEXT;
    PFNGLCOMPRESSEDTEXTURESUBIMAGE1DPROC epoxy_glCompressedTextureSubImage1D;
    PFNGLCOMPRESSEDTEXTURESUBIMAGE1DEXTPROC epoxy_glCompressedTextureSubImage1DEXT;
    PFNGLCOMPRESSEDTEXTURESUBIMAGE2DPROC epoxy_glCompressedTextureSubImage2D;
    PFNGLCOMPRESSEDTEXTURESUBIMAGE2DEXTPROC epoxy_glCompressedTextureSubImage2DEXT;
    PFNGLCOMPRESSEDTEXTURESUBIMAGE3DPROC epoxy_glCompressedTextureSubImage3D;
    PFNGLCOMPRESSEDTEXTURESUBIMAGE3DEXTPROC epoxy_glCompressedTextureSubImage3DEXT;
    PFNGLCONSERVATIVERASTERPARAMETERFNVPROC epoxy_glConservativeRasterParameterfNV;
    PFNGLCONSERVATIVERASTERPARAMETERINVPROC epoxy_glConservativeRasterParameteriNV;
    PFNGLCONVOLUTIONFILTER1DPROC epoxy_glConvolutionFilter1D;
    PFNGLCONVOLUTIONFILTER1DEXTPROC epoxy_glConvolutionFilter1DEXT;
    PFNGLCONVOLUTIONFILTER2DPROC epoxy_glConvolutionFilter2D;
    PFNGLCONVOLUTIONFILTER2DEXTPROC epoxy_glConvolutionFilter2DEXT;
    PFNGLCONVOLUTIONPARAMETERFPROC epoxy_glConvolutionParameterf;
    PFNGLCONVOLUTIONPARAMETERFEXTPROC epoxy_glConvolutionParameterfEXT;
    PFNGLCONVOLUTIONPARAMETERFVPROC epoxy_glConvolutionParameterfv;
    PFNGLCONVOLUTIONPARAMETERFVEXTPROC epoxy_glConvolutionParameterfvEXT;
    PFNGLCONVOLUTIONPARAMETERIPROC epoxy_glConvolutionParameteri;
    PFNGLCONVOLUTIONPARAMETERIEXTPROC epoxy_glConvolutionParameteriEXT;
    PFNGLCONVOLUTIONPARAMETERIVPROC epoxy_glConvolutionParameteriv;
    PFNGLCONVOLUTIONPARAMETERIVEXTPROC epoxy_glConvolutionParameterivEXT;
    PFNGLCONVOLUTIONPARAMETERXOESPROC epoxy_glConvolutionParameterxOES;
    PFNGLCONVOLUTIONPARAMETERXVOESPROC epoxy_glConvolutionParameterxvOES;
    PFNGLCOPYBUFFERSUBDATAPROC epoxy_glCopyBufferSubData;
    PFNGLCOPYBUFFERSUBDATANVPROC epoxy_glCopyBufferSubDataNV;
    PFNGLCOPYCOLORSUBTABLEPROC epoxy_glCopyColorSubTable;
    PFNGLCOPYCOLORSUBTABLEEXTPROC epoxy_glCopyColorSubTableEXT;
    PFNGLCOPYCOLORTABLEPROC epoxy_glCopyColorTable;
    PFNGLCOPYCOLORTABLESGIPROC epoxy_glCopyColorTableSGI;
    PFNGLCOPYCONVOLUTIONFILTER1DPROC epoxy_glCopyConvolutionFilter1D;
    PFNGLCOPYCONVOLUTIONFILTER1DEXTPROC epoxy_glCopyConvolutionFilter1DEXT;
    PFNGLCOPYCONVOLUTIONFILTER2DPROC epoxy_glCopyConvolutionFilter2D;
    PFNGLCOPYCONVOLUTIONFILTER2DEXTPROC epoxy_glCopyConvolutionFilter2DEXT;
    PFNGLCOPYIMAGESUBDATAPROC epoxy_glCopyImageSubData;
    PFNGLCOPYIMAGESUBDATAEXTPROC epoxy_glCopyImageSubDataEXT;
    PFNGLCOPYIMAGESUBDATANVPROC epoxy_glCopyImageSubDataNV;
    PFNGLCOPYIMAGESUBDATAOESPROC epoxy_glCopyImageSubDataOES;
    PFNGLCOPYMULTITEXIMAGE1DEXTPROC epoxy_glCopyMultiTexImage1DEXT;
    PFNGLCOPYMULTITEXIMAGE2DEXTPROC epoxy_glCopyMultiTexImage2DEXT;
    PFNGLCOPYMULTITEXSUBIMAGE1DEXTPROC epoxy_glCopyMultiTexSubImage1DEXT;
    PFNGLCOPYMULTITEXSUBIMAGE2DEXTPROC epoxy_glCopyMultiTexSubImage2DEXT;
    PFNGLCOPYMULTITEXSUBIMAGE3DEXTPROC epoxy_glCopyMultiTexSubImage3DEXT;
    PFNGLCOPYNAMEDBUFFERSUBDATAPROC epoxy_glCopyNamedBufferSubData;
    PFNGLCOPYPATHNVPROC epoxy_glCopyPathNV;
    PFNGLCOPYPIXELSPROC epoxy_glCopyPixels;
    PFNGLCOPYTEXIMAGE1DPROC epoxy_glCopyTexImage1D;
    PFNGLCOPYTEXIMAGE1DEXTPROC epoxy_glCopyTexImage1DEXT;
    PFNGLCOPYTEXIMAGE2DPROC epoxy_glCopyTexImage2D;
    PFNGLCOPYTEXIMAGE2DEXTPROC epoxy_glCopyTexImage2DEXT;
    PFNGLCOPYTEXSUBIMAGE1DPROC epoxy_glCopyTexSubImage1D;
    PFNGLCOPYTEXSUBIMAGE1DEXTPROC epoxy_glCopyTexSubImage1DEXT;
    PFNGLCOPYTEXSUBIMAGE2DPROC epoxy_glCopyTexSubImage2D;
    PFNGLCOPYTEXSUBIMAGE2DEXTPROC epoxy_glCopyTexSubImage2DEXT;
    PFNGLCOPYTEXSUBIMAGE3DPROC epoxy_glCopyTexSubImage3D;
    PFNGLCOPYTEXSUBIMAGE3DEXTPROC epoxy_glCopyTexSubImage3DEXT;
    PFNGLCOPYTEXSUBIMAGE3DOESPROC epoxy_glCopyTexSubImage3DOES;
    PFNGLCOPYTEXTUREIMAGE1DEXTPROC epoxy_glCopyTextureImage1DEXT;
    PFNGLCOPYTEXTUREIMAGE2DEXTPROC epoxy_glCopyTextureImage2DEXT;
    PFNGLCOPYTEXTURELEVELSAPPLEPROC epoxy_glCopyTextureLevelsAPPLE;
    PFNGLCOPYTEXTURESUBIMAGE1DPROC epoxy_glCopyTextureSubImage1D;
    PFNGLCOPYTEXTURESUBIMAGE1DEXTPROC epoxy_glCopyTextureSubImage1DEXT;
    PFNGLCOPYTEXTURESUBIMAGE2DPROC epoxy_glCopyTextureSubImage2D;
    PFNGLCOPYTEXTURESUBIMAGE2DEXTPROC epoxy_glCopyTextureSubImage2DEXT;
    PFNGLCOPYTEXTURESUBIMAGE3DPROC epoxy_glCopyTextureSubImage3D;
    PFNGLCOPYTEXTURESUBIMAGE3DEXTPROC epoxy_glCopyTextureSubImage3DEXT;
    PFNGLCOVERFILLPATHINSTANCEDNVPROC epoxy_glCoverFillPathInstancedNV;
    PFNGLCOVERFILLPATHNVPROC epoxy_glCoverFillPathNV;
    PFNGLCOVERSTROKEPATHINSTANCEDNVPROC epoxy_glCoverStrokePathInstancedNV;
    PFNGLCOVERSTROKEPATHNVPROC epoxy_glCoverStrokePathNV;
    PFNGLCOVERAGEMASKNVPROC epoxy_glCoverageMaskNV;
    PFNGLCOVERAGEMODULATIONNVPROC epoxy_glCoverageModulationNV;
    PFNGLCOVERAGEMODULATIONTABLENVPROC epoxy_glCoverageModulationTableNV;
    PFNGLCOVERAGEOPERATIONNVPROC epoxy_glCoverageOperationNV;
    PFNGLCREATEBUFFERSPROC epoxy_glCreateBuffers;
    PFNGLCREATECOMMANDLISTSNVPROC epoxy_glCreateCommandListsNV;
    PFNGLCREATEFRAMEBUFFERSPROC epoxy_glCreateFramebuffers;
    PFNGLCREATEMEMORYOBJECTSEXTPROC epoxy_glCreateMemoryObjectsEXT;
    PFNGLCREATEPERFQUERYINTELPROC epoxy_glCreatePerfQueryINTEL;
    PFNGLCREATEPROGRAMPROC epoxy_glCreateProgram;
    PFNGLCREATEPROGRAMOBJECTARBPROC epoxy_glCreateProgramObjectARB;
    PFNGLCREATEPROGRAMPIPELINESPROC epoxy_glCreateProgramPipelines;
    PFNGLCREATEQUERIESPROC epoxy_glCreateQueries;
    PFNGLCREATERENDERBUFFERSPROC epoxy_glCreateRenderbuffers;
    PFNGLCREATESAMPLERSPROC epoxy_glCreateSamplers;
    PFNGLCREATESHADERPROC epoxy_glCreateShader;
    PFNGLCREATESHADEROBJECTARBPROC epoxy_glCreateShaderObjectARB;
    PFNGLCREATESHADERPROGRAMEXTPROC epoxy_glCreateShaderProgramEXT;
    PFNGLCREATESHADERPROGRAMVPROC epoxy_glCreateShaderProgramv;
    PFNGLCREATESHADERPROGRAMVEXTPROC epoxy_glCreateShaderProgramvEXT;
    PFNGLCREATESTATESNVPROC epoxy_glCreateStatesNV;
    PFNGLCREATESYNCFROMCLEVENTARBPROC epoxy_glCreateSyncFromCLeventARB;
    PFNGLCREATETEXTURESPROC epoxy_glCreateTextures;
    PFNGLCREATETRANSFORMFEEDBACKSPROC epoxy_glCreateTransformFeedbacks;
    PFNGLCREATEVERTEXARRAYSPROC epoxy_glCreateVertexArrays;
    PFNGLCULLFACEPROC epoxy_glCullFace;
    PFNGLCULLPARAMETERDVEXTPROC epoxy_glCullParameterdvEXT;
    PFNGLCULLPARAMETERFVEXTPROC epoxy_glCullParameterfvEXT;
    PFNGLCURRENTPALETTEMATRIXARBPROC epoxy_glCurrentPaletteMatrixARB;
    PFNGLCURRENTPALETTEMATRIXOESPROC epoxy_glCurrentPaletteMatrixOES;
    PFNGLDEBUGMESSAGECALLBACKPROC epoxy_glDebugMessageCallback;
    PFNGLDEBUGMESSAGECALLBACKAMDPROC epoxy_glDebugMessageCallbackAMD;
    PFNGLDEBUGMESSAGECALLBACKARBPROC epoxy_glDebugMessageCallbackARB;
    PFNGLDEBUGMESSAGECALLBACKKHRPROC epoxy_glDebugMessageCallbackKHR;
    PFNGLDEBUGMESSAGECONTROLPROC epoxy_glDebugMessageControl;
    PFNGLDEBUGMESSAGECONTROLARBPROC epoxy_glDebugMessageControlARB;
    PFNGLDEBUGMESSAGECONTROLKHRPROC epoxy_glDebugMessageControlKHR;
    PFNGLDEBUGMESSAGEENABLEAMDPROC epoxy_glDebugMessageEnableAMD;
    PFNGLDEBUGMESSAGEINSERTPROC epoxy_glDebugMessageInsert;
    PFNGLDEBUGMESSAGEINSERTAMDPROC epoxy_glDebugMessageInsertAMD;
    PFNGLDEBUGMESSAGEINSERTARBPROC epoxy_glDebugMessageInsertARB;
    PFNGLDEBUGMESSAGEINSERTKHRPROC epoxy_glDebugMessageInsertKHR;
    PFNGLDEFORMSGIXPROC epoxy_glDeformSGIX;
    PFNGLDEFORMATIONMAP3DSGIXPROC epoxy_glDeformationMap3dSGIX;
    PFNGLDEFORMATIONMAP3FSGIXPROC epoxy_glDeformationMap3fSGIX;
    PFNGLDELETEASYNCMARKERSSGIXPROC epoxy_glDeleteAsyncMarkersSGIX;
    PFNGLDELETEBUFFERSPROC epoxy_glDeleteBuffers;
    PFNGLDELETEBUFFERSARBPROC epoxy_glDeleteBuffersARB;
    PFNGLDELETECOMMANDLISTSNVPROC epoxy_glDeleteCommandListsNV;
    PFNGLDELETEFENCESAPPLEPROC epoxy_glDeleteFencesAPPLE;
    PFNGLDELETEFENCESNVPROC epoxy_glDeleteFencesNV;
    PFNGLDELETEFRAGMENTSHADERATIPROC epoxy_glDeleteFragmentShaderATI;
    PFNGLDELETEFRAMEBUFFERSPROC epoxy_glDeleteFramebuffers;
    PFNGLDELETEFRAMEBUFFERSEXTPROC epoxy_glDeleteFramebuffersEXT;
    PFNGLDELETEFRAMEBUFFERSOESPROC epoxy_glDeleteFramebuffersOES;
    PFNGLDELETELISTSPROC epoxy_glDeleteLists;
    PFNGLDELETEMEMORYOBJECTSEXTPROC epoxy_glDeleteMemoryObjectsEXT;
    PFNGLDELETENAMEDSTRINGARBPROC epoxy_glDeleteNamedStringARB;
    PFNGLDELETENAMESAMDPROC epoxy_glDeleteNamesAMD;
    PFNGLDELETEOBJECTARBPROC epoxy_glDeleteObjectARB;
    PFNGLDELETEOCCLUSIONQUERIESNVPROC epoxy_glDeleteOcclusionQueriesNV;
    PFNGLDELETEPATHSNVPROC epoxy_glDeletePathsNV;
    PFNGLDELETEPERFMONITORSAMDPROC epoxy_glDeletePerfMonitorsAMD;
    PFNGLDELETEPERFQUERYINTELPROC epoxy_glDeletePerfQueryINTEL;
    PFNGLDELETEPROGRAMPROC epoxy_glDeleteProgram;
    PFNGLDELETEPROGRAMPIPELINESPROC epoxy_glDeleteProgramPipelines;
    PFNGLDELETEPROGRAMPIPELINESEXTPROC epoxy_glDeleteProgramPipelinesEXT;
    PFNGLDELETEPROGRAMSARBPROC epoxy_glDeleteProgramsARB;
    PFNGLDELETEPROGRAMSNVPROC epoxy_glDeleteProgramsNV;
    PFNGLDELETEQUERIESPROC epoxy_glDeleteQueries;
    PFNGLDELETEQUERIESARBPROC epoxy_glDeleteQueriesARB;
    PFNGLDELETEQUERIESEXTPROC epoxy_glDeleteQueriesEXT;
    PFNGLDELETEQUERYRESOURCETAGNVPROC epoxy_glDeleteQueryResourceTagNV;
    PFNGLDELETERENDERBUFFERSPROC epoxy_glDeleteRenderbuffers;
    PFNGLDELETERENDERBUFFERSEXTPROC epoxy_glDeleteRenderbuffersEXT;
    PFNGLDELETERENDERBUFFERSOESPROC epoxy_glDeleteRenderbuffersOES;
    PFNGLDELETESAMPLERSPROC epoxy_glDeleteSamplers;
    PFNGLDELETESEMAPHORESEXTPROC epoxy_glDeleteSemaphoresEXT;
    PFNGLDELETESHADERPROC epoxy_glDeleteShader;
    PFNGLDELETESTATESNVPROC epoxy_glDeleteStatesNV;
    PFNGLDELETESYNCPROC epoxy_glDeleteSync;
    PFNGLDELETESYNCAPPLEPROC epoxy_glDeleteSyncAPPLE;
    PFNGLDELETETEXTURESPROC epoxy_glDeleteTextures;
    PFNGLDELETETEXTURESEXTPROC epoxy_glDeleteTexturesEXT;
    PFNGLDELETETRANSFORMFEEDBACKSPROC epoxy_glDeleteTransformFeedbacks;
    PFNGLDELETETRANSFORMFEEDBACKSNVPROC epoxy_glDeleteTransformFeedbacksNV;
    PFNGLDELETEVERTEXARRAYSPROC epoxy_glDeleteVertexArrays;
    PFNGLDELETEVERTEXARRAYSAPPLEPROC epoxy_glDeleteVertexArraysAPPLE;
    PFNGLDELETEVERTEXARRAYSOESPROC epoxy_glDeleteVertexArraysOES;
    PFNGLDELETEVERTEXSHADEREXTPROC epoxy_glDeleteVertexShaderEXT;
    PFNGLDEPTHBOUNDSEXTPROC epoxy_glDepthBoundsEXT;
    PFNGLDEPTHBOUNDSDNVPROC epoxy_glDepthBoundsdNV;
    PFNGLDEPTHFUNCPROC epoxy_glDepthFunc;
    PFNGLDEPTHMASKPROC epoxy_glDepthMask;
    PFNGLDEPTHRANGEPROC epoxy_glDepthRange;
    PFNGLDEPTHRANGEARRAYFVNVPROC epoxy_glDepthRangeArrayfvNV;
    PFNGLDEPTHRANGEARRAYFVOESPROC epoxy_glDepthRangeArrayfvOES;
    PFNGLDEPTHRANGEARRAYVPROC epoxy_glDepthRangeArrayv;
    PFNGLDEPTHRANGEINDEXEDPROC epoxy_glDepthRangeIndexed;
    PFNGLDEPTHRANGEINDEXEDFNVPROC epoxy_glDepthRangeIndexedfNV;
    PFNGLDEPTHRANGEINDEXEDFOESPROC epoxy_glDepthRangeIndexedfOES;
    PFNGLDEPTHRANGEDNVPROC epoxy_glDepthRangedNV;
    PFNGLDEPTHRANGEFPROC epoxy_glDepthRangef;
    PFNGLDEPTHRANGEFOESPROC epoxy_glDepthRangefOES;
    PFNGLDEPTHRANGEXPROC epoxy_glDepthRangex;
    PFNGLDEPTHRANGEXOESPROC epoxy_glDepthRangexOES;
    PFNGLDETACHOBJECTARBPROC epoxy_glDetachObjectARB;
    PFNGLDETACHSHADERPROC epoxy_glDetachShader;
    PFNGLDETAILTEXFUNCSGISPROC epoxy_glDetailTexFuncSGIS;
    PFNGLDISABLEPROC epoxy_glDisable;
    PFNGLDISABLECLIENTSTATEPROC epoxy_glDisableClientState;
    PFNGLDISABLECLIENTSTATEINDEXEDEXTPROC epoxy_glDisableClientStateIndexedEXT;
    PFNGLDISABLECLIENTSTATEIEXTPROC epoxy_glDisableClientStateiEXT;
    PFNGLDISABLEDRIVERCONTROLQCOMPROC epoxy_glDisableDriverControlQCOM;
    PFNGLDISABLEINDEXEDEXTPROC epoxy_glDisableIndexedEXT;
    PFNGLDISABLEVARIANTCLIENTSTATEEXTPROC epoxy_glDisableVariantClientStateEXT;
    PFNGLDISABLEVERTEXARRAYATTRIBPROC epoxy_glDisableVertexArrayAttrib;
    PFNGLDISABLEVERTEXARRAYATTRIBEXTPROC epoxy_glDisableVertexArrayAttribEXT;
    PFNGLDISABLEVERTEXARRAYEXTPROC epoxy_glDisableVertexArrayEXT;
    PFNGLDISABLEVERTEXATTRIBAPPLEPROC epoxy_glDisableVertexAttribAPPLE;
    PFNGLDISABLEVERTEXATTRIBARRAYPROC epoxy_glDisableVertexAttribArray;
    PFNGLDISABLEVERTEXATTRIBARRAYARBPROC epoxy_glDisableVertexAttribArrayARB;
    PFNGLDISABLEIPROC epoxy_glDisablei;
    PFNGLDISABLEIEXTPROC epoxy_glDisableiEXT;
    PFNGLDISABLEINVPROC epoxy_glDisableiNV;
    PFNGLDISABLEIOESPROC epoxy_glDisableiOES;
    PFNGLDISCARDFRAMEBUFFEREXTPROC epoxy_glDiscardFramebufferEXT;
    PFNGLDISPATCHCOMPUTEPROC epoxy_glDispatchCompute;
    PFNGLDISPATCHCOMPUTEGROUPSIZEARBPROC epoxy_glDispatchComputeGroupSizeARB;
    PFNGLDISPATCHCOMPUTEINDIRECTPROC epoxy_glDispatchComputeIndirect;
    PFNGLDRAWARRAYSPROC epoxy_glDrawArrays;
    PFNGLDRAWARRAYSEXTPROC epoxy_glDrawArraysEXT;
    PFNGLDRAWARRAYSINDIRECTPROC epoxy_glDrawArraysIndirect;
    PFNGLDRAWARRAYSINSTANCEDPROC epoxy_glDrawArraysInstanced;
    PFNGLDRAWARRAYSINSTANCEDANGLEPROC epoxy_glDrawArraysInstancedANGLE;
    PFNGLDRAWARRAYSINSTANCEDARBPROC epoxy_glDrawArraysInstancedARB;
    PFNGLDRAWARRAYSINSTANCEDBASEINSTANCEPROC epoxy_glDrawArraysInstancedBaseInstance;
    PFNGLDRAWARRAYSINSTANCEDBASEINSTANCEEXTPROC epoxy_glDrawArraysInstancedBaseInstanceEXT;
    PFNGLDRAWARRAYSINSTANCEDEXTPROC epoxy_glDrawArraysInstancedEXT;
    PFNGLDRAWARRAYSINSTANCEDNVPROC epoxy_glDrawArraysInstancedNV;
    PFNGLDRAWBUFFERPROC epoxy_glDrawBuffer;
    PFNGLDRAWBUFFERSPROC epoxy_glDrawBuffers;
    PFNGLDRAWBUFFERSARBPROC epoxy_glDrawBuffersARB;
    PFNGLDRAWBUFFERSATIPROC epoxy_glDrawBuffersATI;
    PFNGLDRAWBUFFERSEXTPROC epoxy_glDrawBuffersEXT;
    PFNGLDRAWBUFFERSINDEXEDEXTPROC epoxy_glDrawBuffersIndexedEXT;
    PFNGLDRAWBUFFERSNVPROC epoxy_glDrawBuffersNV;
    PFNGLDRAWCOMMANDSADDRESSNVPROC epoxy_glDrawCommandsAddressNV;
    PFNGLDRAWCOMMANDSNVPROC epoxy_glDrawCommandsNV;
    PFNGLDRAWCOMMANDSSTATESADDRESSNVPROC epoxy_glDrawCommandsStatesAddressNV;
    PFNGLDRAWCOMMANDSSTATESNVPROC epoxy_glDrawCommandsStatesNV;
    PFNGLDRAWELEMENTARRAYAPPLEPROC epoxy_glDrawElementArrayAPPLE;
    PFNGLDRAWELEMENTARRAYATIPROC epoxy_glDrawElementArrayATI;
    PFNGLDRAWELEMENTSPROC epoxy_glDrawElements;
    PFNGLDRAWELEMENTSBASEVERTEXPROC epoxy_glDrawElementsBaseVertex;
    PFNGLDRAWELEMENTSBASEVERTEXEXTPROC epoxy_glDrawElementsBaseVertexEXT;
    PFNGLDRAWELEMENTSBASEVERTEXOESPROC epoxy_glDrawElementsBaseVertexOES;
    PFNGLDRAWELEMENTSINDIRECTPROC epoxy_glDrawElementsIndirect;
    PFNGLDRAWELEMENTSINSTANCEDPROC epoxy_glDrawElementsInstanced;
    PFNGLDRAWELEMENTSINSTANCEDANGLEPROC epoxy_glDrawElementsInstancedANGLE;
    PFNGLDRAWELEMENTSINSTANCEDARBPROC epoxy_glDrawElementsInstancedARB;
    PFNGLDRAWELEMENTSINSTANCEDBASEINSTANCEPROC epoxy_glDrawElementsInstancedBaseInstance;
    PFNGLDRAWELEMENTSINSTANCEDBASEINSTANCEEXTPROC epoxy_glDrawElementsInstancedBaseInstanceEXT;
    PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXPROC epoxy_glDrawElementsInstancedBaseVertex;
    PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCEPROC epoxy_glDrawElementsInstancedBaseVertexBaseInstance;
    PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCEEXTPROC epoxy_glDrawElementsInstancedBaseVertexBaseInstanceEXT;
    PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXEXTPROC epoxy_glDrawElementsInstancedBaseVertexEXT;
    PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXOESPROC epoxy_glDrawElementsInstancedBaseVertexOES;
    PFNGLDRAWELEMENTSINSTANCEDEXTPROC epoxy_glDrawElementsInstancedEXT;
    PFNGLDRAWELEMENTSINSTANCEDNVPROC epoxy_glDrawElementsInstancedNV;
    PFNGLDRAWMESHARRAYSSUNPROC epoxy_glDrawMeshArraysSUN;
    PFNGLDRAWPIXELSPROC epoxy_glDrawPixels;
    PFNGLDRAWRANGEELEMENTARRAYAPPLEPROC epoxy_glDrawRangeElementArrayAPPLE;
    PFNGLDRAWRANGEELEMENTARRAYATIPROC epoxy_glDrawRangeElementArrayATI;
    PFNGLDRAWRANGEELEMENTSPROC epoxy_glDrawRangeElements;
    PFNGLDRAWRANGEELEMENTSBASEVERTEXPROC epoxy_glDrawRangeElementsBaseVertex;
    PFNGLDRAWRANGEELEMENTSBASEVERTEXEXTPROC epoxy_glDrawRangeElementsBaseVertexEXT;
    PFNGLDRAWRANGEELEMENTSBASEVERTEXOESPROC epoxy_glDrawRangeElementsBaseVertexOES;
    PFNGLDRAWRANGEELEMENTSEXTPROC epoxy_glDrawRangeElementsEXT;
    PFNGLDRAWTEXFOESPROC epoxy_glDrawTexfOES;
    PFNGLDRAWTEXFVOESPROC epoxy_glDrawTexfvOES;
    PFNGLDRAWTEXIOESPROC epoxy_glDrawTexiOES;
    PFNGLDRAWTEXIVOESPROC epoxy_glDrawTexivOES;
    PFNGLDRAWTEXSOESPROC epoxy_glDrawTexsOES;
    PFNGLDRAWTEXSVOESPROC epoxy_glDrawTexsvOES;
    PFNGLDRAWTEXTURENVPROC epoxy_glDrawTextureNV;
    PFNGLDRAWTEXXOESPROC epoxy_glDrawTexxOES;
    PFNGLDRAWTEXXVOESPROC epoxy_glDrawTexxvOES;
    PFNGLDRAWTRANSFORMFEEDBACKPROC epoxy_glDrawTransformFeedback;
    PFNGLDRAWTRANSFORMFEEDBACKEXTPROC epoxy_glDrawTransformFeedbackEXT;
    PFNGLDRAWTRANSFORMFEEDBACKINSTANCEDPROC epoxy_glDrawTransformFeedbackInstanced;
    PFNGLDRAWTRANSFORMFEEDBACKINSTANCEDEXTPROC epoxy_glDrawTransformFeedbackInstancedEXT;
    PFNGLDRAWTRANSFORMFEEDBACKNVPROC epoxy_glDrawTransformFeedbackNV;
    PFNGLDRAWTRANSFORMFEEDBACKSTREAMPROC epoxy_glDrawTransformFeedbackStream;
    PFNGLDRAWTRANSFORMFEEDBACKSTREAMINSTANCEDPROC epoxy_glDrawTransformFeedbackStreamInstanced;
    PFNGLDRAWVKIMAGENVPROC epoxy_glDrawVkImageNV;
    PFNGLEGLIMAGETARGETRENDERBUFFERSTORAGEOESPROC epoxy_glEGLImageTargetRenderbufferStorageOES;
    PFNGLEGLIMAGETARGETTEXTURE2DOESPROC epoxy_glEGLImageTargetTexture2DOES;
    PFNGLEDGEFLAGPROC epoxy_glEdgeFlag;
    PFNGLEDGEFLAGFORMATNVPROC epoxy_glEdgeFlagFormatNV;
    PFNGLEDGEFLAGPOINTERPROC epoxy_glEdgeFlagPointer;
    PFNGLEDGEFLAGPOINTEREXTPROC epoxy_glEdgeFlagPointerEXT;
    PFNGLEDGEFLAGPOINTERLISTIBMPROC epoxy_glEdgeFlagPointerListIBM;
    PFNGLEDGEFLAGVPROC epoxy_glEdgeFlagv;
    PFNGLELEMENTPOINTERAPPLEPROC epoxy_glElementPointerAPPLE;
    PFNGLELEMENTPOINTERATIPROC epoxy_glElementPointerATI;
    PFNGLENABLEPROC epoxy_glEnable;
    PFNGLENABLECLIENTSTATEPROC epoxy_glEnableClientState;
    PFNGLENABLECLIENTSTATEINDEXEDEXTPROC epoxy_glEnableClientStateIndexedEXT;
    PFNGLENABLECLIENTSTATEIEXTPROC epoxy_glEnableClientStateiEXT;
    PFNGLENABLEDRIVERCONTROLQCOMPROC epoxy_glEnableDriverControlQCOM;
    PFNGLENABLEINDEXEDEXTPROC epoxy_glEnableIndexedEXT;
    PFNGLENABLEVARIANTCLIENTSTATEEXTPROC epoxy_glEnableVariantClientStateEXT;
    PFNGLENABLEVERTEXARRAYATTRIBPROC epoxy_glEnableVertexArrayAttrib;
    PFNGLENABLEVERTEXARRAYATTRIBEXTPROC epoxy_glEnableVertexArrayAttribEXT;
    PFNGLENABLEVERTEXARRAYEXTPROC epoxy_glEnableVertexArrayEXT;
    PFNGLENABLEVERTEXATTRIBAPPLEPROC epoxy_glEnableVertexAttribAPPLE;
    PFNGLENABLEVERTEXATTRIBARRAYPROC epoxy_glEnableVertexAttribArray;
    PFNGLENABLEVERTEXATTRIBARRAYARBPROC epoxy_glEnableVertexAttribArrayARB;
    PFNGLENABLEIPROC epoxy_glEnablei;
    PFNGLENABLEIEXTPROC epoxy_glEnableiEXT;
    PFNGLENABLEINVPROC epoxy_glEnableiNV;
    PFNGLENABLEIOESPROC epoxy_glEnableiOES;
    PFNGLENDPROC epoxy_glEnd_unwrapped;
    PFNGLENDCONDITIONALRENDERPROC epoxy_glEndConditionalRender;
    PFNGLENDCONDITIONALRENDERNVPROC epoxy_glEndConditionalRenderNV;
    PFNGLENDCONDITIONALRENDERNVXPROC epoxy_glEndConditionalRenderNVX;
    PFNGLENDFRAGMENTSHADERATIPROC epoxy_glEndFragmentShaderATI;
    PFNGLENDLISTPROC epoxy_glEndList;
    PFNGLENDOCCLUSIONQUERYNVPROC epoxy_glEndOcclusionQueryNV;
    PFNGLENDPERFMONITORAMDPROC epoxy_glEndPerfMonitorAMD;
    PFNGLENDPERFQUERYINTELPROC epoxy_glEndPerfQueryINTEL;
    PFNGLENDQUERYPROC epoxy_glEndQuery;
    PFNGLENDQUERYARBPROC epoxy_glEndQueryARB;
    PFNGLENDQUERYEXTPROC epoxy_glEndQueryEXT;
    PFNGLENDQUERYINDEXEDPROC epoxy_glEndQueryIndexed;
    PFNGLENDTILINGQCOMPROC epoxy_glEndTilingQCOM;
    PFNGLENDTRANSFORMFEEDBACKPROC epoxy_glEndTransformFeedback;
    PFNGLENDTRANSFORMFEEDBACKEXTPROC epoxy_glEndTransformFeedbackEXT;
    PFNGLENDTRANSFORMFEEDBACKNVPROC epoxy_glEndTransformFeedbackNV;
    PFNGLENDVERTEXSHADEREXTPROC epoxy_glEndVertexShaderEXT;
    PFNGLENDVIDEOCAPTURENVPROC epoxy_glEndVideoCaptureNV;
    PFNGLEVALCOORD1DPROC epoxy_glEvalCoord1d;
    PFNGLEVALCOORD1DVPROC epoxy_glEvalCoord1dv;
    PFNGLEVALCOORD1FPROC epoxy_glEvalCoord1f;
    PFNGLEVALCOORD1FVPROC epoxy_glEvalCoord1fv;
    PFNGLEVALCOORD1XOESPROC epoxy_glEvalCoord1xOES;
    PFNGLEVALCOORD1XVOESPROC epoxy_glEvalCoord1xvOES;
    PFNGLEVALCOORD2DPROC epoxy_glEvalCoord2d;
    PFNGLEVALCOORD2DVPROC epoxy_glEvalCoord2dv;
    PFNGLEVALCOORD2FPROC epoxy_glEvalCoord2f;
    PFNGLEVALCOORD2FVPROC epoxy_glEvalCoord2fv;
    PFNGLEVALCOORD2XOESPROC epoxy_glEvalCoord2xOES;
    PFNGLEVALCOORD2XVOESPROC epoxy_glEvalCoord2xvOES;
    PFNGLEVALMAPSNVPROC epoxy_glEvalMapsNV;
    PFNGLEVALMESH1PROC epoxy_glEvalMesh1;
    PFNGLEVALMESH2PROC epoxy_glEvalMesh2;
    PFNGLEVALPOINT1PROC epoxy_glEvalPoint1;
    PFNGLEVALPOINT2PROC epoxy_glEvalPoint2;
    PFNGLEVALUATEDEPTHVALUESARBPROC epoxy_glEvaluateDepthValuesARB;
    PFNGLEXECUTEPROGRAMNVPROC epoxy_glExecuteProgramNV;
    PFNGLEXTGETBUFFERPOINTERVQCOMPROC epoxy_glExtGetBufferPointervQCOM;
    PFNGLEXTGETBUFFERSQCOMPROC epoxy_glExtGetBuffersQCOM;
    PFNGLEXTGETFRAMEBUFFERSQCOMPROC epoxy_glExtGetFramebuffersQCOM;
    PFNGLEXTGETPROGRAMBINARYSOURCEQCOMPROC epoxy_glExtGetProgramBinarySourceQCOM;
    PFNGLEXTGETPROGRAMSQCOMPROC epoxy_glExtGetProgramsQCOM;
    PFNGLEXTGETRENDERBUFFERSQCOMPROC epoxy_glExtGetRenderbuffersQCOM;
    PFNGLEXTGETSHADERSQCOMPROC epoxy_glExtGetShadersQCOM;
    PFNGLEXTGETTEXLEVELPARAMETERIVQCOMPROC epoxy_glExtGetTexLevelParameterivQCOM;
    PFNGLEXTGETTEXSUBIMAGEQCOMPROC epoxy_glExtGetTexSubImageQCOM;
    PFNGLEXTGETTEXTURESQCOMPROC epoxy_glExtGetTexturesQCOM;
    PFNGLEXTISPROGRAMBINARYQCOMPROC epoxy_glExtIsProgramBinaryQCOM;
    PFNGLEXTTEXOBJECTSTATEOVERRIDEIQCOMPROC epoxy_glExtTexObjectStateOverrideiQCOM;
    PFNGLEXTRACTCOMPONENTEXTPROC epoxy_glExtractComponentEXT;
    PFNGLFEEDBACKBUFFERPROC epoxy_glFeedbackBuffer;
    PFNGLFEEDBACKBUFFERXOESPROC epoxy_glFeedbackBufferxOES;
    PFNGLFENCESYNCPROC epoxy_glFenceSync;
    PFNGLFENCESYNCAPPLEPROC epoxy_glFenceSyncAPPLE;
    PFNGLFINALCOMBINERINPUTNVPROC epoxy_glFinalCombinerInputNV;
    PFNGLFINISHPROC epoxy_glFinish;
    PFNGLFINISHASYNCSGIXPROC epoxy_glFinishAsyncSGIX;
    PFNGLFINISHFENCEAPPLEPROC epoxy_glFinishFenceAPPLE;
    PFNGLFINISHFENCENVPROC epoxy_glFinishFenceNV;
    PFNGLFINISHOBJECTAPPLEPROC epoxy_glFinishObjectAPPLE;
    PFNGLFINISHTEXTURESUNXPROC epoxy_glFinishTextureSUNX;
    PFNGLFLUSHPROC epoxy_glFlush;
    PFNGLFLUSHMAPPEDBUFFERRANGEPROC epoxy_glFlushMappedBufferRange;
    PFNGLFLUSHMAPPEDBUFFERRANGEAPPLEPROC epoxy_glFlushMappedBufferRangeAPPLE;
    PFNGLFLUSHMAPPEDBUFFERRANGEEXTPROC epoxy_glFlushMappedBufferRangeEXT;
    PFNGLFLUSHMAPPEDNAMEDBUFFERRANGEPROC epoxy_glFlushMappedNamedBufferRange;
    PFNGLFLUSHMAPPEDNAMEDBUFFERRANGEEXTPROC epoxy_glFlushMappedNamedBufferRangeEXT;
    PFNGLFLUSHPIXELDATARANGENVPROC epoxy_glFlushPixelDataRangeNV;
    PFNGLFLUSHRASTERSGIXPROC epoxy_glFlushRasterSGIX;
    PFNGLFLUSHSTATICDATAIBMPROC epoxy_glFlushStaticDataIBM;
    PFNGLFLUSHVERTEXARRAYRANGEAPPLEPROC epoxy_glFlushVertexArrayRangeAPPLE;
    PFNGLFLUSHVERTEXARRAYRANGENVPROC epoxy_glFlushVertexArrayRangeNV;
    PFNGLFOGCOORDFORMATNVPROC epoxy_glFogCoordFormatNV;
    PFNGLFOGCOORDPOINTERPROC epoxy_glFogCoordPointer;
    PFNGLFOGCOORDPOINTEREXTPROC epoxy_glFogCoordPointerEXT;
    PFNGLFOGCOORDPOINTERLISTIBMPROC epoxy_glFogCoordPointerListIBM;
    PFNGLFOGCOORDDPROC epoxy_glFogCoordd;
    PFNGLFOGCOORDDEXTPROC epoxy_glFogCoorddEXT;
    PFNGLFOGCOORDDVPROC epoxy_glFogCoorddv;
    PFNGLFOGCOORDDVEXTPROC epoxy_glFogCoorddvEXT;
    PFNGLFOGCOORDFPROC epoxy_glFogCoordf;
    PFNGLFOGCOORDFEXTPROC epoxy_glFogCoordfEXT;
    PFNGLFOGCOORDFVPROC epoxy_glFogCoordfv;
    PFNGLFOGCOORDFVEXTPROC epoxy_glFogCoordfvEXT;
    PFNGLFOGCOORDHNVPROC epoxy_glFogCoordhNV;
    PFNGLFOGCOORDHVNVPROC epoxy_glFogCoordhvNV;
    PFNGLFOGFUNCSGISPROC epoxy_glFogFuncSGIS;
    PFNGLFOGFPROC epoxy_glFogf;
    PFNGLFOGFVPROC epoxy_glFogfv;
    PFNGLFOGIPROC epoxy_glFogi;
    PFNGLFOGIVPROC epoxy_glFogiv;
    PFNGLFOGXPROC epoxy_glFogx;
    PFNGLFOGXOESPROC epoxy_glFogxOES;
    PFNGLFOGXVPROC epoxy_glFogxv;
    PFNGLFOGXVOESPROC epoxy_glFogxvOES;
    PFNGLFRAGMENTCOLORMATERIALSGIXPROC epoxy_glFragmentColorMaterialSGIX;
    PFNGLFRAGMENTCOVERAGECOLORNVPROC epoxy_glFragmentCoverageColorNV;
    PFNGLFRAGMENTLIGHTMODELFSGIXPROC epoxy_glFragmentLightModelfSGIX;
    PFNGLFRAGMENTLIGHTMODELFVSGIXPROC epoxy_glFragmentLightModelfvSGIX;
    PFNGLFRAGMENTLIGHTMODELISGIXPROC epoxy_glFragmentLightModeliSGIX;
    PFNGLFRAGMENTLIGHTMODELIVSGIXPROC epoxy_glFragmentLightModelivSGIX;
    PFNGLFRAGMENTLIGHTFSGIXPROC epoxy_glFragmentLightfSGIX;
    PFNGLFRAGMENTLIGHTFVSGIXPROC epoxy_glFragmentLightfvSGIX;
    PFNGLFRAGMENTLIGHTISGIXPROC epoxy_glFragmentLightiSGIX;
    PFNGLFRAGMENTLIGHTIVSGIXPROC epoxy_glFragmentLightivSGIX;
    PFNGLFRAGMENTMATERIALFSGIXPROC epoxy_glFragmentMaterialfSGIX;
    PFNGLFRAGMENTMATERIALFVSGIXPROC epoxy_glFragmentMaterialfvSGIX;
    PFNGLFRAGMENTMATERIALISGIXPROC epoxy_glFragmentMaterialiSGIX;
    PFNGLFRAGMENTMATERIALIVSGIXPROC epoxy_glFragmentMaterialivSGIX;
    PFNGLFRAMETERMINATORGREMEDYPROC epoxy_glFrameTerminatorGREMEDY;
    PFNGLFRAMEZOOMSGIXPROC epoxy_glFrameZoomSGIX;
    PFNGLFRAMEBUFFERDRAWBUFFEREXTPROC epoxy_glFramebufferDrawBufferEXT;
    PFNGLFRAMEBUFFERDRAWBUFFERSEXTPROC epoxy_glFramebufferDrawBuffersEXT;
    PFNGLFRAMEBUFFERFETCHBARRIERQCOMPROC epoxy_glFramebufferFetchBarrierQCOM;
    PFNGLFRAMEBUFFERFOVEATIONCONFIGQCOMPROC epoxy_glFramebufferFoveationConfigQCOM;
    PFNGLFRAMEBUFFERFOVEATIONPARAMETERSQCOMPROC epoxy_glFramebufferFoveationParametersQCOM;
    PFNGLFRAMEBUFFERPARAMETERIPROC epoxy_glFramebufferParameteri;
    PFNGLFRAMEBUFFERPIXELLOCALSTORAGESIZEEXTPROC epoxy_glFramebufferPixelLocalStorageSizeEXT;
    PFNGLFRAMEBUFFERREADBUFFEREXTPROC epoxy_glFramebufferReadBufferEXT;
    PFNGLFRAMEBUFFERRENDERBUFFERPROC epoxy_glFramebufferRenderbuffer;
    PFNGLFRAMEBUFFERRENDERBUFFEREXTPROC epoxy_glFramebufferRenderbufferEXT;
    PFNGLFRAMEBUFFERRENDERBUFFEROESPROC epoxy_glFramebufferRenderbufferOES;
    PFNGLFRAMEBUFFERSAMPLELOCATIONSFVARBPROC epoxy_glFramebufferSampleLocationsfvARB;
    PFNGLFRAMEBUFFERSAMPLELOCATIONSFVNVPROC epoxy_glFramebufferSampleLocationsfvNV;
    PFNGLFRAMEBUFFERSAMPLEPOSITIONSFVAMDPROC epoxy_glFramebufferSamplePositionsfvAMD;
    PFNGLFRAMEBUFFERTEXTUREPROC epoxy_glFramebufferTexture;
    PFNGLFRAMEBUFFERTEXTURE1DPROC epoxy_glFramebufferTexture1D;
    PFNGLFRAMEBUFFERTEXTURE1DEXTPROC epoxy_glFramebufferTexture1DEXT;
    PFNGLFRAMEBUFFERTEXTURE2DPROC epoxy_glFramebufferTexture2D;
    PFNGLFRAMEBUFFERTEXTURE2DDOWNSAMPLEIMGPROC epoxy_glFramebufferTexture2DDownsampleIMG;
    PFNGLFRAMEBUFFERTEXTURE2DEXTPROC epoxy_glFramebufferTexture2DEXT;
    PFNGLFRAMEBUFFERTEXTURE2DMULTISAMPLEEXTPROC epoxy_glFramebufferTexture2DMultisampleEXT;
    PFNGLFRAMEBUFFERTEXTURE2DMULTISAMPLEIMGPROC epoxy_glFramebufferTexture2DMultisampleIMG;
    PFNGLFRAMEBUFFERTEXTURE2DOESPROC epoxy_glFramebufferTexture2DOES;
    PFNGLFRAMEBUFFERTEXTURE3DPROC epoxy_glFramebufferTexture3D;
    PFNGLFRAMEBUFFERTEXTURE3DEXTPROC epoxy_glFramebufferTexture3DEXT;
    PFNGLFRAMEBUFFERTEXTURE3DOESPROC epoxy_glFramebufferTexture3DOES;
    PFNGLFRAMEBUFFERTEXTUREARBPROC epoxy_glFramebufferTextureARB;
    PFNGLFRAMEBUFFERTEXTUREEXTPROC epoxy_glFramebufferTextureEXT;
    PFNGLFRAMEBUFFERTEXTUREFACEARBPROC epoxy_glFramebufferTextureFaceARB;
    PFNGLFRAMEBUFFERTEXTUREFACEEXTPROC epoxy_glFramebufferTextureFaceEXT;
    PFNGLFRAMEBUFFERTEXTURELAYERPROC epoxy_glFramebufferTextureLayer;
    PFNGLFRAMEBUFFERTEXTURELAYERARBPROC epoxy_glFramebufferTextureLayerARB;
    PFNGLFRAMEBUFFERTEXTURELAYERDOWNSAMPLEIMGPROC epoxy_glFramebufferTextureLayerDownsampleIMG;
    PFNGLFRAMEBUFFERTEXTURELAYEREXTPROC epoxy_glFramebufferTextureLayerEXT;
    PFNGLFRAMEBUFFERTEXTUREMULTISAMPLEMULTIVIEWOVRPROC epoxy_glFramebufferTextureMultisampleMultiviewOVR;
    PFNGLFRAMEBUFFERTEXTUREMULTIVIEWOVRPROC epoxy_glFramebufferTextureMultiviewOVR;
    PFNGLFRAMEBUFFERTEXTUREOESPROC epoxy_glFramebufferTextureOES;
    PFNGLFREEOBJECTBUFFERATIPROC epoxy_glFreeObjectBufferATI;
    PFNGLFRONTFACEPROC epoxy_glFrontFace;
    PFNGLFRUSTUMPROC epoxy_glFrustum;
    PFNGLFRUSTUMFPROC epoxy_glFrustumf;
    PFNGLFRUSTUMFOESPROC epoxy_glFrustumfOES;
    PFNGLFRUSTUMXPROC epoxy_glFrustumx;
    PFNGLFRUSTUMXOESPROC epoxy_glFrustumxOES;
    PFNGLGENASYNCMARKERSSGIXPROC epoxy_glGenAsyncMarkersSGIX;
    PFNGLGENBUFFERSPROC epoxy_glGenBuffers;
    PFNGLGENBUFFERSARBPROC epoxy_glGenBuffersARB;
    PFNGLGENFENCESAPPLEPROC epoxy_glGenFencesAPPLE;
    PFNGLGENFENCESNVPROC epoxy_glGenFencesNV;
    PFNGLGENFRAGMENTSHADERSATIPROC epoxy_glGenFragmentShadersATI;
    PFNGLGENFRAMEBUFFERSPROC epoxy_glGenFramebuffers;
    PFNGLGENFRAMEBUFFERSEXTPROC epoxy_glGenFramebuffersEXT;
    PFNGLGENFRAMEBUFFERSOESPROC epoxy_glGenFramebuffersOES;
    PFNGLGENLISTSPROC epoxy_glGenLists;
    PFNGLGENNAMESAMDPROC epoxy_glGenNamesAMD;
    PFNGLGENOCCLUSIONQUERIESNVPROC epoxy_glGenOcclusionQueriesNV;
    PFNGLGENPATHSNVPROC epoxy_glGenPathsNV;
    PFNGLGENPERFMONITORSAMDPROC epoxy_glGenPerfMonitorsAMD;
    PFNGLGENPROGRAMPIPELINESPROC epoxy_glGenProgramPipelines;
    PFNGLGENPROGRAMPIPELINESEXTPROC epoxy_glGenProgramPipelinesEXT;
    PFNGLGENPROGRAMSARBPROC epoxy_glGenProgramsARB;
    PFNGLGENPROGRAMSNVPROC epoxy_glGenProgramsNV;
    PFNGLGENQUERIESPROC epoxy_glGenQueries;
    PFNGLGENQUERIESARBPROC epoxy_glGenQueriesARB;
    PFNGLGENQUERIESEXTPROC epoxy_glGenQueriesEXT;
    PFNGLGENQUERYRESOURCETAGNVPROC epoxy_glGenQueryResourceTagNV;
    PFNGLGENRENDERBUFFERSPROC epoxy_glGenRenderbuffers;
    PFNGLGENRENDERBUFFERSEXTPROC epoxy_glGenRenderbuffersEXT;
    PFNGLGENRENDERBUFFERSOESPROC epoxy_glGenRenderbuffersOES;
    PFNGLGENSAMPLERSPROC epoxy_glGenSamplers;
    PFNGLGENSEMAPHORESEXTPROC epoxy_glGenSemaphoresEXT;
    PFNGLGENSYMBOLSEXTPROC epoxy_glGenSymbolsEXT;
    PFNGLGENTEXTURESPROC epoxy_glGenTextures;
    PFNGLGENTEXTURESEXTPROC epoxy_glGenTexturesEXT;
    PFNGLGENTRANSFORMFEEDBACKSPROC epoxy_glGenTransformFeedbacks;
    PFNGLGENTRANSFORMFEEDBACKSNVPROC epoxy_glGenTransformFeedbacksNV;
    PFNGLGENVERTEXARRAYSPROC epoxy_glGenVertexArrays;
    PFNGLGENVERTEXARRAYSAPPLEPROC epoxy_glGenVertexArraysAPPLE;
    PFNGLGENVERTEXARRAYSOESPROC epoxy_glGenVertexArraysOES;
    PFNGLGENVERTEXSHADERSEXTPROC epoxy_glGenVertexShadersEXT;
    PFNGLGENERATEMIPMAPPROC epoxy_glGenerateMipmap;
    PFNGLGENERATEMIPMAPEXTPROC epoxy_glGenerateMipmapEXT;
    PFNGLGENERATEMIPMAPOESPROC epoxy_glGenerateMipmapOES;
    PFNGLGENERATEMULTITEXMIPMAPEXTPROC epoxy_glGenerateMultiTexMipmapEXT;
    PFNGLGENERATETEXTUREMIPMAPPROC epoxy_glGenerateTextureMipmap;
    PFNGLGENERATETEXTUREMIPMAPEXTPROC epoxy_glGenerateTextureMipmapEXT;
    PFNGLGETACTIVEATOMICCOUNTERBUFFERIVPROC epoxy_glGetActiveAtomicCounterBufferiv;
    PFNGLGETACTIVEATTRIBPROC epoxy_glGetActiveAttrib;
    PFNGLGETACTIVEATTRIBARBPROC epoxy_glGetActiveAttribARB;
    PFNGLGETACTIVESUBROUTINENAMEPROC epoxy_glGetActiveSubroutineName;
    PFNGLGETACTIVESUBROUTINEUNIFORMNAMEPROC epoxy_glGetActiveSubroutineUniformName;
    PFNGLGETACTIVESUBROUTINEUNIFORMIVPROC epoxy_glGetActiveSubroutineUniformiv;
    PFNGLGETACTIVEUNIFORMPROC epoxy_glGetActiveUniform;
    PFNGLGETACTIVEUNIFORMARBPROC epoxy_glGetActiveUniformARB;
    PFNGLGETACTIVEUNIFORMBLOCKNAMEPROC epoxy_glGetActiveUniformBlockName;
    PFNGLGETACTIVEUNIFORMBLOCKIVPROC epoxy_glGetActiveUniformBlockiv;
    PFNGLGETACTIVEUNIFORMNAMEPROC epoxy_glGetActiveUniformName;
    PFNGLGETACTIVEUNIFORMSIVPROC epoxy_glGetActiveUniformsiv;
    PFNGLGETACTIVEVARYINGNVPROC epoxy_glGetActiveVaryingNV;
    PFNGLGETARRAYOBJECTFVATIPROC epoxy_glGetArrayObjectfvATI;
    PFNGLGETARRAYOBJECTIVATIPROC epoxy_glGetArrayObjectivATI;
    PFNGLGETATTACHEDOBJECTSARBPROC epoxy_glGetAttachedObjectsARB;
    PFNGLGETATTACHEDSHADERSPROC epoxy_glGetAttachedShaders;
    PFNGLGETATTRIBLOCATIONPROC epoxy_glGetAttribLocation;
    PFNGLGETATTRIBLOCATIONARBPROC epoxy_glGetAttribLocationARB;
    PFNGLGETBOOLEANINDEXEDVEXTPROC epoxy_glGetBooleanIndexedvEXT;
    PFNGLGETBOOLEANI_VPROC epoxy_glGetBooleani_v;
    PFNGLGETBOOLEANVPROC epoxy_glGetBooleanv;
    PFNGLGETBUFFERPARAMETERI64VPROC epoxy_glGetBufferParameteri64v;
    PFNGLGETBUFFERPARAMETERIVPROC epoxy_glGetBufferParameteriv;
    PFNGLGETBUFFERPARAMETERIVARBPROC epoxy_glGetBufferParameterivARB;
    PFNGLGETBUFFERPARAMETERUI64VNVPROC epoxy_glGetBufferParameterui64vNV;
    PFNGLGETBUFFERPOINTERVPROC epoxy_glGetBufferPointerv;
    PFNGLGETBUFFERPOINTERVARBPROC epoxy_glGetBufferPointervARB;
    PFNGLGETBUFFERPOINTERVOESPROC epoxy_glGetBufferPointervOES;
    PFNGLGETBUFFERSUBDATAPROC epoxy_glGetBufferSubData;
    PFNGLGETBUFFERSUBDATAARBPROC epoxy_glGetBufferSubDataARB;
    PFNGLGETCLIPPLANEPROC epoxy_glGetClipPlane;
    PFNGLGETCLIPPLANEFPROC epoxy_glGetClipPlanef;
    PFNGLGETCLIPPLANEFOESPROC epoxy_glGetClipPlanefOES;
    PFNGLGETCLIPPLANEXPROC epoxy_glGetClipPlanex;
    PFNGLGETCLIPPLANEXOESPROC epoxy_glGetClipPlanexOES;
    PFNGLGETCOLORTABLEPROC epoxy_glGetColorTable;
    PFNGLGETCOLORTABLEEXTPROC epoxy_glGetColorTableEXT;
    PFNGLGETCOLORTABLEPARAMETERFVPROC epoxy_glGetColorTableParameterfv;
    PFNGLGETCOLORTABLEPARAMETERFVEXTPROC epoxy_glGetColorTableParameterfvEXT;
    PFNGLGETCOLORTABLEPARAMETERFVSGIPROC epoxy_glGetColorTableParameterfvSGI;
    PFNGLGETCOLORTABLEPARAMETERIVPROC epoxy_glGetColorTableParameteriv;
    PFNGLGETCOLORTABLEPARAMETERIVEXTPROC epoxy_glGetColorTableParameterivEXT;
    PFNGLGETCOLORTABLEPARAMETERIVSGIPROC epoxy_glGetColorTableParameterivSGI;
    PFNGLGETCOLORTABLESGIPROC epoxy_glGetColorTableSGI;
    PFNGLGETCOMBINERINPUTPARAMETERFVNVPROC epoxy_glGetCombinerInputParameterfvNV;
    PFNGLGETCOMBINERINPUTPARAMETERIVNVPROC epoxy_glGetCombinerInputParameterivNV;
    PFNGLGETCOMBINEROUTPUTPARAMETERFVNVPROC epoxy_glGetCombinerOutputParameterfvNV;
    PFNGLGETCOMBINEROUTPUTPARAMETERIVNVPROC epoxy_glGetCombinerOutputParameterivNV;
    PFNGLGETCOMBINERSTAGEPARAMETERFVNVPROC epoxy_glGetCombinerStageParameterfvNV;
    PFNGLGETCOMMANDHEADERNVPROC epoxy_glGetCommandHeaderNV;
    PFNGLGETCOMPRESSEDMULTITEXIMAGEEXTPROC epoxy_glGetCompressedMultiTexImageEXT;
    PFNGLGETCOMPRESSEDTEXIMAGEPROC epoxy_glGetCompressedTexImage;
    PFNGLGETCOMPRESSEDTEXIMAGEARBPROC epoxy_glGetCompressedTexImageARB;
    PFNGLGETCOMPRESSEDTEXTUREIMAGEPROC epoxy_glGetCompressedTextureImage;
    PFNGLGETCOMPRESSEDTEXTUREIMAGEEXTPROC epoxy_glGetCompressedTextureImageEXT;
    PFNGLGETCOMPRESSEDTEXTURESUBIMAGEPROC epoxy_glGetCompressedTextureSubImage;
    PFNGLGETCONVOLUTIONFILTERPROC epoxy_glGetConvolutionFilter;
    PFNGLGETCONVOLUTIONFILTEREXTPROC epoxy_glGetConvolutionFilterEXT;
    PFNGLGETCONVOLUTIONPARAMETERFVPROC epoxy_glGetConvolutionParameterfv;
    PFNGLGETCONVOLUTIONPARAMETERFVEXTPROC epoxy_glGetConvolutionParameterfvEXT;
    PFNGLGETCONVOLUTIONPARAMETERIVPROC epoxy_glGetConvolutionParameteriv;
    PFNGLGETCONVOLUTIONPARAMETERIVEXTPROC epoxy_glGetConvolutionParameterivEXT;
    PFNGLGETCONVOLUTIONPARAMETERXVOESPROC epoxy_glGetConvolutionParameterxvOES;
    PFNGLGETCOVERAGEMODULATIONTABLENVPROC epoxy_glGetCoverageModulationTableNV;
    PFNGLGETDEBUGMESSAGELOGPROC epoxy_glGetDebugMessageLog;
    PFNGLGETDEBUGMESSAGELOGAMDPROC epoxy_glGetDebugMessageLogAMD;
    PFNGLGETDEBUGMESSAGELOGARBPROC epoxy_glGetDebugMessageLogARB;
    PFNGLGETDEBUGMESSAGELOGKHRPROC epoxy_glGetDebugMessageLogKHR;
    PFNGLGETDETAILTEXFUNCSGISPROC epoxy_glGetDetailTexFuncSGIS;
    PFNGLGETDOUBLEINDEXEDVEXTPROC epoxy_glGetDoubleIndexedvEXT;
    PFNGLGETDOUBLEI_VPROC epoxy_glGetDoublei_v;
    PFNGLGETDOUBLEI_VEXTPROC epoxy_glGetDoublei_vEXT;
    PFNGLGETDOUBLEVPROC epoxy_glGetDoublev;
    PFNGLGETDRIVERCONTROLSTRINGQCOMPROC epoxy_glGetDriverControlStringQCOM;
    PFNGLGETDRIVERCONTROLSQCOMPROC epoxy_glGetDriverControlsQCOM;
    PFNGLGETERRORPROC epoxy_glGetError;
    PFNGLGETFENCEIVNVPROC epoxy_glGetFenceivNV;
    PFNGLGETFINALCOMBINERINPUTPARAMETERFVNVPROC epoxy_glGetFinalCombinerInputParameterfvNV;
    PFNGLGETFINALCOMBINERINPUTPARAMETERIVNVPROC epoxy_glGetFinalCombinerInputParameterivNV;
    PFNGLGETFIRSTPERFQUERYIDINTELPROC epoxy_glGetFirstPerfQueryIdINTEL;
    PFNGLGETFIXEDVPROC epoxy_glGetFixedv;
    PFNGLGETFIXEDVOESPROC epoxy_glGetFixedvOES;
    PFNGLGETFLOATINDEXEDVEXTPROC epoxy_glGetFloatIndexedvEXT;
    PFNGLGETFLOATI_VPROC epoxy_glGetFloati_v;
    PFNGLGETFLOATI_VEXTPROC epoxy_glGetFloati_vEXT;
    PFNGLGETFLOATI_VNVPROC epoxy_glGetFloati_vNV;
    PFNGLGETFLOATI_VOESPROC epoxy_glGetFloati_vOES;
    PFNGLGETFLOATVPROC epoxy_glGetFloatv;
    PFNGLGETFOGFUNCSGISPROC epoxy_glGetFogFuncSGIS;
    PFNGLGETFRAGDATAINDEXPROC epoxy_glGetFragDataIndex;
    PFNGLGETFRAGDATAINDEXEXTPROC epoxy_glGetFragDataIndexEXT;
    PFNGLGETFRAGDATALOCATIONPROC epoxy_glGetFragDataLocation;
    PFNGLGETFRAGDATALOCATIONEXTPROC epoxy_glGetFragDataLocationEXT;
    PFNGLGETFRAGMENTLIGHTFVSGIXPROC epoxy_glGetFragmentLightfvSGIX;
    PFNGLGETFRAGMENTLIGHTIVSGIXPROC epoxy_glGetFragmentLightivSGIX;
    PFNGLGETFRAGMENTMATERIALFVSGIXPROC epoxy_glGetFragmentMaterialfvSGIX;
    PFNGLGETFRAGMENTMATERIALIVSGIXPROC epoxy_glGetFragmentMaterialivSGIX;
    PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC epoxy_glGetFramebufferAttachmentParameteriv;
    PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC epoxy_glGetFramebufferAttachmentParameterivEXT;
    PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVOESPROC epoxy_glGetFramebufferAttachmentParameterivOES;
    PFNGLGETFRAMEBUFFERPARAMETERFVAMDPROC epoxy_glGetFramebufferParameterfvAMD;
    PFNGLGETFRAMEBUFFERPARAMETERIVPROC epoxy_glGetFramebufferParameteriv;
    PFNGLGETFRAMEBUFFERPARAMETERIVEXTPROC epoxy_glGetFramebufferParameterivEXT;
    PFNGLGETFRAMEBUFFERPIXELLOCALSTORAGESIZEEXTPROC epoxy_glGetFramebufferPixelLocalStorageSizeEXT;
    PFNGLGETGRAPHICSRESETSTATUSPROC epoxy_glGetGraphicsResetStatus;
    PFNGLGETGRAPHICSRESETSTATUSARBPROC epoxy_glGetGraphicsResetStatusARB;
    PFNGLGETGRAPHICSRESETSTATUSEXTPROC epoxy_glGetGraphicsResetStatusEXT;
    PFNGLGETGRAPHICSRESETSTATUSKHRPROC epoxy_glGetGraphicsResetStatusKHR;
    PFNGLGETHANDLEARBPROC epoxy_glGetHandleARB;
    PFNGLGETHISTOGRAMPROC epoxy_glGetHistogram;
    PFNGLGETHISTOGRAMEXTPROC epoxy_glGetHistogramEXT;
    PFNGLGETHISTOGRAMPARAMETERFVPROC epoxy_glGetHistogramParameterfv;
    PFNGLGETHISTOGRAMPARAMETERFVEXTPROC epoxy_glGetHistogramParameterfvEXT;
    PFNGLGETHISTOGRAMPARAMETERIVPROC epoxy_glGetHistogramParameteriv;
    PFNGLGETHISTOGRAMPARAMETERIVEXTPROC epoxy_glGetHistogramParameterivEXT;
    PFNGLGETHISTOGRAMPARAMETERXVOESPROC epoxy_glGetHistogramParameterxvOES;
    PFNGLGETIMAGEHANDLEARBPROC epoxy_glGetImageHandleARB;
    PFNGLGETIMAGEHANDLENVPROC epoxy_glGetImageHandleNV;
    PFNGLGETIMAGETRANSFORMPARAMETERFVHPPROC epoxy_glGetImageTransformParameterfvHP;
    PFNGLGETIMAGETRANSFORMPARAMETERIVHPPROC epoxy_glGetImageTransformParameterivHP;
    PFNGLGETINFOLOGARBPROC epoxy_glGetInfoLogARB;
    PFNGLGETINSTRUMENTSSGIXPROC epoxy_glGetInstrumentsSGIX;
    PFNGLGETINTEGER64I_VPROC epoxy_glGetInteger64i_v;
    PFNGLGETINTEGER64VPROC epoxy_glGetInteger64v;
    PFNGLGETINTEGER64VAPPLEPROC epoxy_glGetInteger64vAPPLE;
    PFNGLGETINTEGERINDEXEDVEXTPROC epoxy_glGetIntegerIndexedvEXT;
    PFNGLGETINTEGERI_VPROC epoxy_glGetIntegeri_v;
    PFNGLGETINTEGERI_VEXTPROC epoxy_glGetIntegeri_vEXT;
    PFNGLGETINTEGERUI64I_VNVPROC epoxy_glGetIntegerui64i_vNV;
    PFNGLGETINTEGERUI64VNVPROC epoxy_glGetIntegerui64vNV;
    PFNGLGETINTEGERVPROC epoxy_glGetIntegerv;
    PFNGLGETINTERNALFORMATSAMPLEIVNVPROC epoxy_glGetInternalformatSampleivNV;
    PFNGLGETINTERNALFORMATI64VPROC epoxy_glGetInternalformati64v;
    PFNGLGETINTERNALFORMATIVPROC epoxy_glGetInternalformativ;
    PFNGLGETINVARIANTBOOLEANVEXTPROC epoxy_glGetInvariantBooleanvEXT;
    PFNGLGETINVARIANTFLOATVEXTPROC epoxy_glGetInvariantFloatvEXT;
    PFNGLGETINVARIANTINTEGERVEXTPROC epoxy_glGetInvariantIntegervEXT;
    PFNGLGETLIGHTFVPROC epoxy_glGetLightfv;
    PFNGLGETLIGHTIVPROC epoxy_glGetLightiv;
    PFNGLGETLIGHTXOESPROC epoxy_glGetLightxOES;
    PFNGLGETLIGHTXVPROC epoxy_glGetLightxv;
    PFNGLGETLIGHTXVOESPROC epoxy_glGetLightxvOES;
    PFNGLGETLISTPARAMETERFVSGIXPROC epoxy_glGetListParameterfvSGIX;
    PFNGLGETLISTPARAMETERIVSGIXPROC epoxy_glGetListParameterivSGIX;
    PFNGLGETLOCALCONSTANTBOOLEANVEXTPROC epoxy_glGetLocalConstantBooleanvEXT;
    PFNGLGETLOCALCONSTANTFLOATVEXTPROC epoxy_glGetLocalConstantFloatvEXT;
    PFNGLGETLOCALCONSTANTINTEGERVEXTPROC epoxy_glGetLocalConstantIntegervEXT;
    PFNGLGETMAPATTRIBPARAMETERFVNVPROC epoxy_glGetMapAttribParameterfvNV;
    PFNGLGETMAPATTRIBPARAMETERIVNVPROC epoxy_glGetMapAttribParameterivNV;
    PFNGLGETMAPCONTROLPOINTSNVPROC epoxy_glGetMapControlPointsNV;
    PFNGLGETMAPPARAMETERFVNVPROC epoxy_glGetMapParameterfvNV;
    PFNGLGETMAPPARAMETERIVNVPROC epoxy_glGetMapParameterivNV;
    PFNGLGETMAPDVPROC epoxy_glGetMapdv;
    PFNGLGETMAPFVPROC epoxy_glGetMapfv;
    PFNGLGETMAPIVPROC epoxy_glGetMapiv;
    PFNGLGETMAPXVOESPROC epoxy_glGetMapxvOES;
    PFNGLGETMATERIALFVPROC epoxy_glGetMaterialfv;
    PFNGLGETMATERIALIVPROC epoxy_glGetMaterialiv;
    PFNGLGETMATERIALXOESPROC epoxy_glGetMaterialxOES;
    PFNGLGETMATERIALXVPROC epoxy_glGetMaterialxv;
    PFNGLGETMATERIALXVOESPROC epoxy_glGetMaterialxvOES;
    PFNGLGETMEMORYOBJECTPARAMETERIVEXTPROC epoxy_glGetMemoryObjectParameterivEXT;
    PFNGLGETMINMAXPROC epoxy_glGetMinmax;
    PFNGLGETMINMAXEXTPROC epoxy_glGetMinmaxEXT;
    PFNGLGETMINMAXPARAMETERFVPROC epoxy_glGetMinmaxParameterfv;
    PFNGLGETMINMAXPARAMETERFVEXTPROC epoxy_glGetMinmaxParameterfvEXT;
    PFNGLGETMINMAXPARAMETERIVPROC epoxy_glGetMinmaxParameteriv;
    PFNGLGETMINMAXPARAMETERIVEXTPROC epoxy_glGetMinmaxParameterivEXT;
    PFNGLGETMULTITEXENVFVEXTPROC epoxy_glGetMultiTexEnvfvEXT;
    PFNGLGETMULTITEXENVIVEXTPROC epoxy_glGetMultiTexEnvivEXT;
    PFNGLGETMULTITEXGENDVEXTPROC epoxy_glGetMultiTexGendvEXT;
    PFNGLGETMULTITEXGENFVEXTPROC epoxy_glGetMultiTexGenfvEXT;
    PFNGLGETMULTITEXGENIVEXTPROC epoxy_glGetMultiTexGenivEXT;
    PFNGLGETMULTITEXIMAGEEXTPROC epoxy_glGetMultiTexImageEXT;
    PFNGLGETMULTITEXLEVELPARAMETERFVEXTPROC epoxy_glGetMultiTexLevelParameterfvEXT;
    PFNGLGETMULTITEXLEVELPARAMETERIVEXTPROC epoxy_glGetMultiTexLevelParameterivEXT;
    PFNGLGETMULTITEXPARAMETERIIVEXTPROC epoxy_glGetMultiTexParameterIivEXT;
    PFNGLGETMULTITEXPARAMETERIUIVEXTPROC epoxy_glGetMultiTexParameterIuivEXT;
    PFNGLGETMULTITEXPARAMETERFVEXTPROC epoxy_glGetMultiTexParameterfvEXT;
    PFNGLGETMULTITEXPARAMETERIVEXTPROC epoxy_glGetMultiTexParameterivEXT;
    PFNGLGETMULTISAMPLEFVPROC epoxy_glGetMultisamplefv;
    PFNGLGETMULTISAMPLEFVNVPROC epoxy_glGetMultisamplefvNV;
    PFNGLGETNAMEDBUFFERPARAMETERI64VPROC epoxy_glGetNamedBufferParameteri64v;
    PFNGLGETNAMEDBUFFERPARAMETERIVPROC epoxy_glGetNamedBufferParameteriv;
    PFNGLGETNAMEDBUFFERPARAMETERIVEXTPROC epoxy_glGetNamedBufferParameterivEXT;
    PFNGLGETNAMEDBUFFERPARAMETERUI64VNVPROC epoxy_glGetNamedBufferParameterui64vNV;
    PFNGLGETNAMEDBUFFERPOINTERVPROC epoxy_glGetNamedBufferPointerv;
    PFNGLGETNAMEDBUFFERPOINTERVEXTPROC epoxy_glGetNamedBufferPointervEXT;
    PFNGLGETNAMEDBUFFERSUBDATAPROC epoxy_glGetNamedBufferSubData;
    PFNGLGETNAMEDBUFFERSUBDATAEXTPROC epoxy_glGetNamedBufferSubDataEXT;
    PFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVPROC epoxy_glGetNamedFramebufferAttachmentParameteriv;
    PFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC epoxy_glGetNamedFramebufferAttachmentParameterivEXT;
    PFNGLGETNAMEDFRAMEBUFFERPARAMETERFVAMDPROC epoxy_glGetNamedFramebufferParameterfvAMD;
    PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVPROC epoxy_glGetNamedFramebufferParameteriv;
    PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVEXTPROC epoxy_glGetNamedFramebufferParameterivEXT;
    PFNGLGETNAMEDPROGRAMLOCALPARAMETERIIVEXTPROC epoxy_glGetNamedProgramLocalParameterIivEXT;
    PFNGLGETNAMEDPROGRAMLOCALPARAMETERIUIVEXTPROC epoxy_glGetNamedProgramLocalParameterIuivEXT;
    PFNGLGETNAMEDPROGRAMLOCALPARAMETERDVEXTPROC epoxy_glGetNamedProgramLocalParameterdvEXT;
    PFNGLGETNAMEDPROGRAMLOCALPARAMETERFVEXTPROC epoxy_glGetNamedProgramLocalParameterfvEXT;
    PFNGLGETNAMEDPROGRAMSTRINGEXTPROC epoxy_glGetNamedProgramStringEXT;
    PFNGLGETNAMEDPROGRAMIVEXTPROC epoxy_glGetNamedProgramivEXT;
    PFNGLGETNAMEDRENDERBUFFERPARAMETERIVPROC epoxy_glGetNamedRenderbufferParameteriv;
    PFNGLGETNAMEDRENDERBUFFERPARAMETERIVEXTPROC epoxy_glGetNamedRenderbufferParameterivEXT;
    PFNGLGETNAMEDSTRINGARBPROC epoxy_glGetNamedStringARB;
    PFNGLGETNAMEDSTRINGIVARBPROC epoxy_glGetNamedStringivARB;
    PFNGLGETNEXTPERFQUERYIDINTELPROC epoxy_glGetNextPerfQueryIdINTEL;
    PFNGLGETOBJECTBUFFERFVATIPROC epoxy_glGetObjectBufferfvATI;
    PFNGLGETOBJECTBUFFERIVATIPROC epoxy_glGetObjectBufferivATI;
    PFNGLGETOBJECTLABELPROC epoxy_glGetObjectLabel;
    PFNGLGETOBJECTLABELEXTPROC epoxy_glGetObjectLabelEXT;
    PFNGLGETOBJECTLABELKHRPROC epoxy_glGetObjectLabelKHR;
    PFNGLGETOBJECTPARAMETERFVARBPROC epoxy_glGetObjectParameterfvARB;
    PFNGLGETOBJECTPARAMETERIVAPPLEPROC epoxy_glGetObjectParameterivAPPLE;
    PFNGLGETOBJECTPARAMETERIVARBPROC epoxy_glGetObjectParameterivARB;
    PFNGLGETOBJECTPTRLABELPROC epoxy_glGetObjectPtrLabel;
    PFNGLGETOBJECTPTRLABELKHRPROC epoxy_glGetObjectPtrLabelKHR;
    PFNGLGETOCCLUSIONQUERYIVNVPROC epoxy_glGetOcclusionQueryivNV;
    PFNGLGETOCCLUSIONQUERYUIVNVPROC epoxy_glGetOcclusionQueryuivNV;
    PFNGLGETPATHCOLORGENFVNVPROC epoxy_glGetPathColorGenfvNV;
    PFNGLGETPATHCOLORGENIVNVPROC epoxy_glGetPathColorGenivNV;
    PFNGLGETPATHCOMMANDSNVPROC epoxy_glGetPathCommandsNV;
    PFNGLGETPATHCOORDSNVPROC epoxy_glGetPathCoordsNV;
    PFNGLGETPATHDASHARRAYNVPROC epoxy_glGetPathDashArrayNV;
    PFNGLGETPATHLENGTHNVPROC epoxy_glGetPathLengthNV;
    PFNGLGETPATHMETRICRANGENVPROC epoxy_glGetPathMetricRangeNV;
    PFNGLGETPATHMETRICSNVPROC epoxy_glGetPathMetricsNV;
    PFNGLGETPATHPARAMETERFVNVPROC epoxy_glGetPathParameterfvNV;
    PFNGLGETPATHPARAMETERIVNVPROC epoxy_glGetPathParameterivNV;
    PFNGLGETPATHSPACINGNVPROC epoxy_glGetPathSpacingNV;
    PFNGLGETPATHTEXGENFVNVPROC epoxy_glGetPathTexGenfvNV;
    PFNGLGETPATHTEXGENIVNVPROC epoxy_glGetPathTexGenivNV;
    PFNGLGETPERFCOUNTERINFOINTELPROC epoxy_glGetPerfCounterInfoINTEL;
    PFNGLGETPERFMONITORCOUNTERDATAAMDPROC epoxy_glGetPerfMonitorCounterDataAMD;
    PFNGLGETPERFMONITORCOUNTERINFOAMDPROC epoxy_glGetPerfMonitorCounterInfoAMD;
    PFNGLGETPERFMONITORCOUNTERSTRINGAMDPROC epoxy_glGetPerfMonitorCounterStringAMD;
    PFNGLGETPERFMONITORCOUNTERSAMDPROC epoxy_glGetPerfMonitorCountersAMD;
    PFNGLGETPERFMONITORGROUPSTRINGAMDPROC epoxy_glGetPerfMonitorGroupStringAMD;
    PFNGLGETPERFMONITORGROUPSAMDPROC epoxy_glGetPerfMonitorGroupsAMD;
    PFNGLGETPERFQUERYDATAINTELPROC epoxy_glGetPerfQueryDataINTEL;
    PFNGLGETPERFQUERYIDBYNAMEINTELPROC epoxy_glGetPerfQueryIdByNameINTEL;
    PFNGLGETPERFQUERYINFOINTELPROC epoxy_glGetPerfQueryInfoINTEL;
    PFNGLGETPIXELMAPFVPROC epoxy_glGetPixelMapfv;
    PFNGLGETPIXELMAPUIVPROC epoxy_glGetPixelMapuiv;
    PFNGLGETPIXELMAPUSVPROC epoxy_glGetPixelMapusv;
    PFNGLGETPIXELMAPXVPROC epoxy_glGetPixelMapxv;
    PFNGLGETPIXELTEXGENPARAMETERFVSGISPROC epoxy_glGetPixelTexGenParameterfvSGIS;
    PFNGLGETPIXELTEXGENPARAMETERIVSGISPROC epoxy_glGetPixelTexGenParameterivSGIS;
    PFNGLGETPIXELTRANSFORMPARAMETERFVEXTPROC epoxy_glGetPixelTransformParameterfvEXT;
    PFNGLGETPIXELTRANSFORMPARAMETERIVEXTPROC epoxy_glGetPixelTransformParameterivEXT;
    PFNGLGETPOINTERINDEXEDVEXTPROC epoxy_glGetPointerIndexedvEXT;
    PFNGLGETPOINTERI_VEXTPROC epoxy_glGetPointeri_vEXT;
    PFNGLGETPOINTERVPROC epoxy_glGetPointerv;
    PFNGLGETPOINTERVEXTPROC epoxy_glGetPointervEXT;
    PFNGLGETPOINTERVKHRPROC epoxy_glGetPointervKHR;
    PFNGLGETPOLYGONSTIPPLEPROC epoxy_glGetPolygonStipple;
    PFNGLGETPROGRAMBINARYPROC epoxy_glGetProgramBinary;
    PFNGLGETPROGRAMBINARYOESPROC epoxy_glGetProgramBinaryOES;
    PFNGLGETPROGRAMENVPARAMETERIIVNVPROC epoxy_glGetProgramEnvParameterIivNV;
    PFNGLGETPROGRAMENVPARAMETERIUIVNVPROC epoxy_glGetProgramEnvParameterIuivNV;
    PFNGLGETPROGRAMENVPARAMETERDVARBPROC epoxy_glGetProgramEnvParameterdvARB;
    PFNGLGETPROGRAMENVPARAMETERFVARBPROC epoxy_glGetProgramEnvParameterfvARB;
    PFNGLGETPROGRAMINFOLOGPROC epoxy_glGetProgramInfoLog;
    PFNGLGETPROGRAMINTERFACEIVPROC epoxy_glGetProgramInterfaceiv;
    PFNGLGETPROGRAMLOCALPARAMETERIIVNVPROC epoxy_glGetProgramLocalParameterIivNV;
    PFNGLGETPROGRAMLOCALPARAMETERIUIVNVPROC epoxy_glGetProgramLocalParameterIuivNV;
    PFNGLGETPROGRAMLOCALPARAMETERDVARBPROC epoxy_glGetProgramLocalParameterdvARB;
    PFNGLGETPROGRAMLOCALPARAMETERFVARBPROC epoxy_glGetProgramLocalParameterfvARB;
    PFNGLGETPROGRAMNAMEDPARAMETERDVNVPROC epoxy_glGetProgramNamedParameterdvNV;
    PFNGLGETPROGRAMNAMEDPARAMETERFVNVPROC epoxy_glGetProgramNamedParameterfvNV;
    PFNGLGETPROGRAMPARAMETERDVNVPROC epoxy_glGetProgramParameterdvNV;
    PFNGLGETPROGRAMPARAMETERFVNVPROC epoxy_glGetProgramParameterfvNV;
    PFNGLGETPROGRAMPIPELINEINFOLOGPROC epoxy_glGetProgramPipelineInfoLog;
    PFNGLGETPROGRAMPIPELINEINFOLOGEXTPROC epoxy_glGetProgramPipelineInfoLogEXT;
    PFNGLGETPROGRAMPIPELINEIVPROC epoxy_glGetProgramPipelineiv;
    PFNGLGETPROGRAMPIPELINEIVEXTPROC epoxy_glGetProgramPipelineivEXT;
    PFNGLGETPROGRAMRESOURCEINDEXPROC epoxy_glGetProgramResourceIndex;
    PFNGLGETPROGRAMRESOURCELOCATIONPROC epoxy_glGetProgramResourceLocation;
    PFNGLGETPROGRAMRESOURCELOCATIONINDEXPROC epoxy_glGetProgramResourceLocationIndex;
    PFNGLGETPROGRAMRESOURCELOCATIONINDEXEXTPROC epoxy_glGetProgramResourceLocationIndexEXT;
    PFNGLGETPROGRAMRESOURCENAMEPROC epoxy_glGetProgramResourceName;
    PFNGLGETPROGRAMRESOURCEFVNVPROC epoxy_glGetProgramResourcefvNV;
    PFNGLGETPROGRAMRESOURCEIVPROC epoxy_glGetProgramResourceiv;
    PFNGLGETPROGRAMSTAGEIVPROC epoxy_glGetProgramStageiv;
    PFNGLGETPROGRAMSTRINGARBPROC epoxy_glGetProgramStringARB;
    PFNGLGETPROGRAMSTRINGNVPROC epoxy_glGetProgramStringNV;
    PFNGLGETPROGRAMSUBROUTINEPARAMETERUIVNVPROC epoxy_glGetProgramSubroutineParameteruivNV;
    PFNGLGETPROGRAMIVPROC epoxy_glGetProgramiv;
    PFNGLGETPROGRAMIVARBPROC epoxy_glGetProgramivARB;
    PFNGLGETPROGRAMIVNVPROC epoxy_glGetProgramivNV;
    PFNGLGETQUERYBUFFEROBJECTI64VPROC epoxy_glGetQueryBufferObjecti64v;
    PFNGLGETQUERYBUFFEROBJECTIVPROC epoxy_glGetQueryBufferObjectiv;
    PFNGLGETQUERYBUFFEROBJECTUI64VPROC epoxy_glGetQueryBufferObjectui64v;
    PFNGLGETQUERYBUFFEROBJECTUIVPROC epoxy_glGetQueryBufferObjectuiv;
    PFNGLGETQUERYINDEXEDIVPROC epoxy_glGetQueryIndexediv;
    PFNGLGETQUERYOBJECTI64VPROC epoxy_glGetQueryObjecti64v;
    PFNGLGETQUERYOBJECTI64VEXTPROC epoxy_glGetQueryObjecti64vEXT;
    PFNGLGETQUERYOBJECTIVPROC epoxy_glGetQueryObjectiv;
    PFNGLGETQUERYOBJECTIVARBPROC epoxy_glGetQueryObjectivARB;
    PFNGLGETQUERYOBJECTIVEXTPROC epoxy_glGetQueryObjectivEXT;
    PFNGLGETQUERYOBJECTUI64VPROC epoxy_glGetQueryObjectui64v;
    PFNGLGETQUERYOBJECTUI64VEXTPROC epoxy_glGetQueryObjectui64vEXT;
    PFNGLGETQUERYOBJECTUIVPROC epoxy_glGetQueryObjectuiv;
    PFNGLGETQUERYOBJECTUIVARBPROC epoxy_glGetQueryObjectuivARB;
    PFNGLGETQUERYOBJECTUIVEXTPROC epoxy_glGetQueryObjectuivEXT;
    PFNGLGETQUERYIVPROC epoxy_glGetQueryiv;
    PFNGLGETQUERYIVARBPROC epoxy_glGetQueryivARB;
    PFNGLGETQUERYIVEXTPROC epoxy_glGetQueryivEXT;
    PFNGLGETRENDERBUFFERPARAMETERIVPROC epoxy_glGetRenderbufferParameteriv;
    PFNGLGETRENDERBUFFERPARAMETERIVEXTPROC epoxy_glGetRenderbufferParameterivEXT;
    PFNGLGETRENDERBUFFERPARAMETERIVOESPROC epoxy_glGetRenderbufferParameterivOES;
    PFNGLGETSAMPLERPARAMETERIIVPROC epoxy_glGetSamplerParameterIiv;
    PFNGLGETSAMPLERPARAMETERIIVEXTPROC epoxy_glGetSamplerParameterIivEXT;
    PFNGLGETSAMPLERPARAMETERIIVOESPROC epoxy_glGetSamplerParameterIivOES;
    PFNGLGETSAMPLERPARAMETERIUIVPROC epoxy_glGetSamplerParameterIuiv;
    PFNGLGETSAMPLERPARAMETERIUIVEXTPROC epoxy_glGetSamplerParameterIuivEXT;
    PFNGLGETSAMPLERPARAMETERIUIVOESPROC epoxy_glGetSamplerParameterIuivOES;
    PFNGLGETSAMPLERPARAMETERFVPROC epoxy_glGetSamplerParameterfv;
    PFNGLGETSAMPLERPARAMETERIVPROC epoxy_glGetSamplerParameteriv;
    PFNGLGETSEMAPHOREPARAMETERUI64VEXTPROC epoxy_glGetSemaphoreParameterui64vEXT;
    PFNGLGETSEPARABLEFILTERPROC epoxy_glGetSeparableFilter;
    PFNGLGETSEPARABLEFILTEREXTPROC epoxy_glGetSeparableFilterEXT;
    PFNGLGETSHADERINFOLOGPROC epoxy_glGetShaderInfoLog;
    PFNGLGETSHADERPRECISIONFORMATPROC epoxy_glGetShaderPrecisionFormat;
    PFNGLGETSHADERSOURCEPROC epoxy_glGetShaderSource;
    PFNGLGETSHADERSOURCEARBPROC epoxy_glGetShaderSourceARB;
    PFNGLGETSHADERIVPROC epoxy_glGetShaderiv;
    PFNGLGETSHARPENTEXFUNCSGISPROC epoxy_glGetSharpenTexFuncSGIS;
    PFNGLGETSTAGEINDEXNVPROC epoxy_glGetStageIndexNV;
    PFNGLGETSTRINGPROC epoxy_glGetString;
    PFNGLGETSTRINGIPROC epoxy_glGetStringi;
    PFNGLGETSUBROUTINEINDEXPROC epoxy_glGetSubroutineIndex;
    PFNGLGETSUBROUTINEUNIFORMLOCATIONPROC epoxy_glGetSubroutineUniformLocation;
    PFNGLGETSYNCIVPROC epoxy_glGetSynciv;
    PFNGLGETSYNCIVAPPLEPROC epoxy_glGetSyncivAPPLE;
    PFNGLGETTEXBUMPPARAMETERFVATIPROC epoxy_glGetTexBumpParameterfvATI;
    PFNGLGETTEXBUMPPARAMETERIVATIPROC epoxy_glGetTexBumpParameterivATI;
    PFNGLGETTEXENVFVPROC epoxy_glGetTexEnvfv;
    PFNGLGETTEXENVIVPROC epoxy_glGetTexEnviv;
    PFNGLGETTEXENVXVPROC epoxy_glGetTexEnvxv;
    PFNGLGETTEXENVXVOESPROC epoxy_glGetTexEnvxvOES;
    PFNGLGETTEXFILTERFUNCSGISPROC epoxy_glGetTexFilterFuncSGIS;
    PFNGLGETTEXGENDVPROC epoxy_glGetTexGendv;
    PFNGLGETTEXGENFVPROC epoxy_glGetTexGenfv;
    PFNGLGETTEXGENFVOESPROC epoxy_glGetTexGenfvOES;
    PFNGLGETTEXGENIVPROC epoxy_glGetTexGeniv;
    PFNGLGETTEXGENIVOESPROC epoxy_glGetTexGenivOES;
    PFNGLGETTEXGENXVOESPROC epoxy_glGetTexGenxvOES;
    PFNGLGETTEXIMAGEPROC epoxy_glGetTexImage;
    PFNGLGETTEXLEVELPARAMETERFVPROC epoxy_glGetTexLevelParameterfv;
    PFNGLGETTEXLEVELPARAMETERIVPROC epoxy_glGetTexLevelParameteriv;
    PFNGLGETTEXLEVELPARAMETERXVOESPROC epoxy_glGetTexLevelParameterxvOES;
    PFNGLGETTEXPARAMETERIIVPROC epoxy_glGetTexParameterIiv;
    PFNGLGETTEXPARAMETERIIVEXTPROC epoxy_glGetTexParameterIivEXT;
    PFNGLGETTEXPARAMETERIIVOESPROC epoxy_glGetTexParameterIivOES;
    PFNGLGETTEXPARAMETERIUIVPROC epoxy_glGetTexParameterIuiv;
    PFNGLGETTEXPARAMETERIUIVEXTPROC epoxy_glGetTexParameterIuivEXT;
    PFNGLGETTEXPARAMETERIUIVOESPROC epoxy_glGetTexParameterIuivOES;
    PFNGLGETTEXPARAMETERPOINTERVAPPLEPROC epoxy_glGetTexParameterPointervAPPLE;
    PFNGLGETTEXPARAMETERFVPROC epoxy_glGetTexParameterfv;
    PFNGLGETTEXPARAMETERIVPROC epoxy_glGetTexParameteriv;
    PFNGLGETTEXPARAMETERXVPROC epoxy_glGetTexParameterxv;
    PFNGLGETTEXPARAMETERXVOESPROC epoxy_glGetTexParameterxvOES;
    PFNGLGETTEXTUREHANDLEARBPROC epoxy_glGetTextureHandleARB;
    PFNGLGETTEXTUREHANDLEIMGPROC epoxy_glGetTextureHandleIMG;
    PFNGLGETTEXTUREHANDLENVPROC epoxy_glGetTextureHandleNV;
    PFNGLGETTEXTUREIMAGEPROC epoxy_glGetTextureImage;
    PFNGLGETTEXTUREIMAGEEXTPROC epoxy_glGetTextureImageEXT;
    PFNGLGETTEXTURELEVELPARAMETERFVPROC epoxy_glGetTextureLevelParameterfv;
    PFNGLGETTEXTURELEVELPARAMETERFVEXTPROC epoxy_glGetTextureLevelParameterfvEXT;
    PFNGLGETTEXTURELEVELPARAMETERIVPROC epoxy_glGetTextureLevelParameteriv;
    PFNGLGETTEXTURELEVELPARAMETERIVEXTPROC epoxy_glGetTextureLevelParameterivEXT;
    PFNGLGETTEXTUREPARAMETERIIVPROC epoxy_glGetTextureParameterIiv;
    PFNGLGETTEXTUREPARAMETERIIVEXTPROC epoxy_glGetTextureParameterIivEXT;
    PFNGLGETTEXTUREPARAMETERIUIVPROC epoxy_glGetTextureParameterIuiv;
    PFNGLGETTEXTUREPARAMETERIUIVEXTPROC epoxy_glGetTextureParameterIuivEXT;
    PFNGLGETTEXTUREPARAMETERFVPROC epoxy_glGetTextureParameterfv;
    PFNGLGETTEXTUREPARAMETERFVEXTPROC epoxy_glGetTextureParameterfvEXT;
    PFNGLGETTEXTUREPARAMETERIVPROC epoxy_glGetTextureParameteriv;
    PFNGLGETTEXTUREPARAMETERIVEXTPROC epoxy_glGetTextureParameterivEXT;
    PFNGLGETTEXTURESAMPLERHANDLEARBPROC epoxy_glGetTextureSamplerHandleARB;
    PFNGLGETTEXTURESAMPLERHANDLEIMGPROC epoxy_glGetTextureSamplerHandleIMG;
    PFNGLGETTEXTURESAMPLERHANDLENVPROC epoxy_glGetTextureSamplerHandleNV;
    PFNGLGETTEXTURESUBIMAGEPROC epoxy_glGetTextureSubImage;
    PFNGLGETTRACKMATRIXIVNVPROC epoxy_glGetTrackMatrixivNV;
    PFNGLGETTRANSFORMFEEDBACKVARYINGPROC epoxy_glGetTransformFeedbackVarying;
    PFNGLGETTRANSFORMFEEDBACKVARYINGEXTPROC epoxy_glGetTransformFeedbackVaryingEXT;
    PFNGLGETTRANSFORMFEEDBACKVARYINGNVPROC epoxy_glGetTransformFeedbackVaryingNV;
    PFNGLGETTRANSFORMFEEDBACKI64_VPROC epoxy_glGetTransformFeedbacki64_v;
    PFNGLGETTRANSFORMFEEDBACKI_VPROC epoxy_glGetTransformFeedbacki_v;
    PFNGLGETTRANSFORMFEEDBACKIVPROC epoxy_glGetTransformFeedbackiv;
    PFNGLGETTRANSLATEDSHADERSOURCEANGLEPROC epoxy_glGetTranslatedShaderSourceANGLE;
    PFNGLGETUNIFORMBLOCKINDEXPROC epoxy_glGetUniformBlockIndex;
    PFNGLGETUNIFORMBUFFERSIZEEXTPROC epoxy_glGetUniformBufferSizeEXT;
    PFNGLGETUNIFORMINDICESPROC epoxy_glGetUniformIndices;
    PFNGLGETUNIFORMLOCATIONPROC epoxy_glGetUniformLocation;
    PFNGLGETUNIFORMLOCATIONARBPROC epoxy_glGetUniformLocationARB;
    PFNGLGETUNIFORMOFFSETEXTPROC epoxy_glGetUniformOffsetEXT;
    PFNGLGETUNIFORMSUBROUTINEUIVPROC epoxy_glGetUniformSubroutineuiv;
    PFNGLGETUNIFORMDVPROC epoxy_glGetUniformdv;
    PFNGLGETUNIFORMFVPROC epoxy_glGetUniformfv;
    PFNGLGETUNIFORMFVARBPROC epoxy_glGetUniformfvARB;
    PFNGLGETUNIFORMI64VARBPROC epoxy_glGetUniformi64vARB;
    PFNGLGETUNIFORMI64VNVPROC epoxy_glGetUniformi64vNV;
    PFNGLGETUNIFORMIVPROC epoxy_glGetUniformiv;
    PFNGLGETUNIFORMIVARBPROC epoxy_glGetUniformivARB;
    PFNGLGETUNIFORMUI64VARBPROC epoxy_glGetUniformui64vARB;
    PFNGLGETUNIFORMUI64VNVPROC epoxy_glGetUniformui64vNV;
    PFNGLGETUNIFORMUIVPROC epoxy_glGetUniformuiv;
    PFNGLGETUNIFORMUIVEXTPROC epoxy_glGetUniformuivEXT;
    PFNGLGETUNSIGNEDBYTEI_VEXTPROC epoxy_glGetUnsignedBytei_vEXT;
    PFNGLGETUNSIGNEDBYTEVEXTPROC epoxy_glGetUnsignedBytevEXT;
    PFNGLGETVARIANTARRAYOBJECTFVATIPROC epoxy_glGetVariantArrayObjectfvATI;
    PFNGLGETVARIANTARRAYOBJECTIVATIPROC epoxy_glGetVariantArrayObjectivATI;
    PFNGLGETVARIANTBOOLEANVEXTPROC epoxy_glGetVariantBooleanvEXT;
    PFNGLGETVARIANTFLOATVEXTPROC epoxy_glGetVariantFloatvEXT;
    PFNGLGETVARIANTINTEGERVEXTPROC epoxy_glGetVariantIntegervEXT;
    PFNGLGETVARIANTPOINTERVEXTPROC epoxy_glGetVariantPointervEXT;
    PFNGLGETVARYINGLOCATIONNVPROC epoxy_glGetVaryingLocationNV;
    PFNGLGETVERTEXARRAYINDEXED64IVPROC epoxy_glGetVertexArrayIndexed64iv;
    PFNGLGETVERTEXARRAYINDEXEDIVPROC epoxy_glGetVertexArrayIndexediv;
    PFNGLGETVERTEXARRAYINTEGERI_VEXTPROC epoxy_glGetVertexArrayIntegeri_vEXT;
    PFNGLGETVERTEXARRAYINTEGERVEXTPROC epoxy_glGetVertexArrayIntegervEXT;
    PFNGLGETVERTEXARRAYPOINTERI_VEXTPROC epoxy_glGetVertexArrayPointeri_vEXT;
    PFNGLGETVERTEXARRAYPOINTERVEXTPROC epoxy_glGetVertexArrayPointervEXT;
    PFNGLGETVERTEXARRAYIVPROC epoxy_glGetVertexArrayiv;
    PFNGLGETVERTEXATTRIBARRAYOBJECTFVATIPROC epoxy_glGetVertexAttribArrayObjectfvATI;
    PFNGLGETVERTEXATTRIBARRAYOBJECTIVATIPROC epoxy_glGetVertexAttribArrayObjectivATI;
    PFNGLGETVERTEXATTRIBIIVPROC epoxy_glGetVertexAttribIiv;
    PFNGLGETVERTEXATTRIBIIVEXTPROC epoxy_glGetVertexAttribIivEXT;
    PFNGLGETVERTEXATTRIBIUIVPROC epoxy_glGetVertexAttribIuiv;
    PFNGLGETVERTEXATTRIBIUIVEXTPROC epoxy_glGetVertexAttribIuivEXT;
    PFNGLGETVERTEXATTRIBLDVPROC epoxy_glGetVertexAttribLdv;
    PFNGLGETVERTEXATTRIBLDVEXTPROC epoxy_glGetVertexAttribLdvEXT;
    PFNGLGETVERTEXATTRIBLI64VNVPROC epoxy_glGetVertexAttribLi64vNV;
    PFNGLGETVERTEXATTRIBLUI64VARBPROC epoxy_glGetVertexAttribLui64vARB;
    PFNGLGETVERTEXATTRIBLUI64VNVPROC epoxy_glGetVertexAttribLui64vNV;
    PFNGLGETVERTEXATTRIBPOINTERVPROC epoxy_glGetVertexAttribPointerv;
    PFNGLGETVERTEXATTRIBPOINTERVARBPROC epoxy_glGetVertexAttribPointervARB;
    PFNGLGETVERTEXATTRIBPOINTERVNVPROC epoxy_glGetVertexAttribPointervNV;
    PFNGLGETVERTEXATTRIBDVPROC epoxy_glGetVertexAttribdv;
    PFNGLGETVERTEXATTRIBDVARBPROC epoxy_glGetVertexAttribdvARB;
    PFNGLGETVERTEXATTRIBDVNVPROC epoxy_glGetVertexAttribdvNV;
    PFNGLGETVERTEXATTRIBFVPROC epoxy_glGetVertexAttribfv;
    PFNGLGETVERTEXATTRIBFVARBPROC epoxy_glGetVertexAttribfvARB;
    PFNGLGETVERTEXATTRIBFVNVPROC epoxy_glGetVertexAttribfvNV;
    PFNGLGETVERTEXATTRIBIVPROC epoxy_glGetVertexAttribiv;
    PFNGLGETVERTEXATTRIBIVARBPROC epoxy_glGetVertexAttribivARB;
    PFNGLGETVERTEXATTRIBIVNVPROC epoxy_glGetVertexAttribivNV;
    PFNGLGETVIDEOCAPTURESTREAMDVNVPROC epoxy_glGetVideoCaptureStreamdvNV;
    PFNGLGETVIDEOCAPTURESTREAMFVNVPROC epoxy_glGetVideoCaptureStreamfvNV;
    PFNGLGETVIDEOCAPTURESTREAMIVNVPROC epoxy_glGetVideoCaptureStreamivNV;
    PFNGLGETVIDEOCAPTUREIVNVPROC epoxy_glGetVideoCaptureivNV;
    PFNGLGETVIDEOI64VNVPROC epoxy_glGetVideoi64vNV;
    PFNGLGETVIDEOIVNVPROC epoxy_glGetVideoivNV;
    PFNGLGETVIDEOUI64VNVPROC epoxy_glGetVideoui64vNV;
    PFNGLGETVIDEOUIVNVPROC epoxy_glGetVideouivNV;
    PFNGLGETVKPROCADDRNVPROC epoxy_glGetVkProcAddrNV;
    PFNGLGETNCOLORTABLEPROC epoxy_glGetnColorTable;
    PFNGLGETNCOLORTABLEARBPROC epoxy_glGetnColorTableARB;
    PFNGLGETNCOMPRESSEDTEXIMAGEPROC epoxy_glGetnCompressedTexImage;
    PFNGLGETNCOMPRESSEDTEXIMAGEARBPROC epoxy_glGetnCompressedTexImageARB;
    PFNGLGETNCONVOLUTIONFILTERPROC epoxy_glGetnConvolutionFilter;
    PFNGLGETNCONVOLUTIONFILTERARBPROC epoxy_glGetnConvolutionFilterARB;
    PFNGLGETNHISTOGRAMPROC epoxy_glGetnHistogram;
    PFNGLGETNHISTOGRAMARBPROC epoxy_glGetnHistogramARB;
    PFNGLGETNMAPDVPROC epoxy_glGetnMapdv;
    PFNGLGETNMAPDVARBPROC epoxy_glGetnMapdvARB;
    PFNGLGETNMAPFVPROC epoxy_glGetnMapfv;
    PFNGLGETNMAPFVARBPROC epoxy_glGetnMapfvARB;
    PFNGLGETNMAPIVPROC epoxy_glGetnMapiv;
    PFNGLGETNMAPIVARBPROC epoxy_glGetnMapivARB;
    PFNGLGETNMINMAXPROC epoxy_glGetnMinmax;
    PFNGLGETNMINMAXARBPROC epoxy_glGetnMinmaxARB;
    PFNGLGETNPIXELMAPFVPROC epoxy_glGetnPixelMapfv;
    PFNGLGETNPIXELMAPFVARBPROC epoxy_glGetnPixelMapfvARB;
    PFNGLGETNPIXELMAPUIVPROC epoxy_glGetnPixelMapuiv;
    PFNGLGETNPIXELMAPUIVARBPROC epoxy_glGetnPixelMapuivARB;
    PFNGLGETNPIXELMAPUSVPROC epoxy_glGetnPixelMapusv;
    PFNGLGETNPIXELMAPUSVARBPROC epoxy_glGetnPixelMapusvARB;
    PFNGLGETNPOLYGONSTIPPLEPROC epoxy_glGetnPolygonStipple;
    PFNGLGETNPOLYGONSTIPPLEARBPROC epoxy_glGetnPolygonStippleARB;
    PFNGLGETNSEPARABLEFILTERPROC epoxy_glGetnSeparableFilter;
    PFNGLGETNSEPARABLEFILTERARBPROC epoxy_glGetnSeparableFilterARB;
    PFNGLGETNTEXIMAGEPROC epoxy_glGetnTexImage;
    PFNGLGETNTEXIMAGEARBPROC epoxy_glGetnTexImageARB;
    PFNGLGETNUNIFORMDVPROC epoxy_glGetnUniformdv;
    PFNGLGETNUNIFORMDVARBPROC epoxy_glGetnUniformdvARB;
    PFNGLGETNUNIFORMFVPROC epoxy_glGetnUniformfv;
    PFNGLGETNUNIFORMFVARBPROC epoxy_glGetnUniformfvARB;
    PFNGLGETNUNIFORMFVEXTPROC epoxy_glGetnUniformfvEXT;
    PFNGLGETNUNIFORMFVKHRPROC epoxy_glGetnUniformfvKHR;
    PFNGLGETNUNIFORMI64VARBPROC epoxy_glGetnUniformi64vARB;
    PFNGLGETNUNIFORMIVPROC epoxy_glGetnUniformiv;
    PFNGLGETNUNIFORMIVARBPROC epoxy_glGetnUniformivARB;
    PFNGLGETNUNIFORMIVEXTPROC epoxy_glGetnUniformivEXT;
    PFNGLGETNUNIFORMIVKHRPROC epoxy_glGetnUniformivKHR;
    PFNGLGETNUNIFORMUI64VARBPROC epoxy_glGetnUniformui64vARB;
    PFNGLGETNUNIFORMUIVPROC epoxy_glGetnUniformuiv;
    PFNGLGETNUNIFORMUIVARBPROC epoxy_glGetnUniformuivARB;
    PFNGLGETNUNIFORMUIVKHRPROC epoxy_glGetnUniformuivKHR;
    PFNGLGLOBALALPHAFACTORBSUNPROC epoxy_glGlobalAlphaFactorbSUN;
    PFNGLGLOBALALPHAFACTORDSUNPROC epoxy_glGlobalAlphaFactordSUN;
    PFNGLGLOBALALPHAFACTORFSUNPROC epoxy_glGlobalAlphaFactorfSUN;
    PFNGLGLOBALALPHAFACTORISUNPROC epoxy_glGlobalAlphaFactoriSUN;
    PFNGLGLOBALALPHAFACTORSSUNPROC epoxy_glGlobalAlphaFactorsSUN;
    PFNGLGLOBALALPHAFACTORUBSUNPROC epoxy_glGlobalAlphaFactorubSUN;
    PFNGLGLOBALALPHAFACTORUISUNPROC epoxy_glGlobalAlphaFactoruiSUN;
    PFNGLGLOBALALPHAFACTORUSSUNPROC epoxy_glGlobalAlphaFactorusSUN;
    PFNGLHINTPROC epoxy_glHint;
    PFNGLHINTPGIPROC epoxy_glHintPGI;
    PFNGLHISTOGRAMPROC epoxy_glHistogram;
    PFNGLHISTOGRAMEXTPROC epoxy_glHistogramEXT;
    PFNGLIGLOOINTERFACESGIXPROC epoxy_glIglooInterfaceSGIX;
    PFNGLIMAGETRANSFORMPARAMETERFHPPROC epoxy_glImageTransformParameterfHP;
    PFNGLIMAGETRANSFORMPARAMETERFVHPPROC epoxy_glImageTransformParameterfvHP;
    PFNGLIMAGETRANSFORMPARAMETERIHPPROC epoxy_glImageTransformParameteriHP;
    PFNGLIMAGETRANSFORMPARAMETERIVHPPROC epoxy_glImageTransformParameterivHP;
    PFNGLIMPORTMEMORYFDEXTPROC epoxy_glImportMemoryFdEXT;
    PFNGLIMPORTMEMORYWIN32HANDLEEXTPROC epoxy_glImportMemoryWin32HandleEXT;
    PFNGLIMPORTMEMORYWIN32NAMEEXTPROC epoxy_glImportMemoryWin32NameEXT;
    PFNGLIMPORTSEMAPHOREFDEXTPROC epoxy_glImportSemaphoreFdEXT;
    PFNGLIMPORTSEMAPHOREWIN32HANDLEEXTPROC epoxy_glImportSemaphoreWin32HandleEXT;
    PFNGLIMPORTSEMAPHOREWIN32NAMEEXTPROC epoxy_glImportSemaphoreWin32NameEXT;
    PFNGLIMPORTSYNCEXTPROC epoxy_glImportSyncEXT;
    PFNGLINDEXFORMATNVPROC epoxy_glIndexFormatNV;
    PFNGLINDEXFUNCEXTPROC epoxy_glIndexFuncEXT;
    PFNGLINDEXMASKPROC epoxy_glIndexMask;
    PFNGLINDEXMATERIALEXTPROC epoxy_glIndexMaterialEXT;
    PFNGLINDEXPOINTERPROC epoxy_glIndexPointer;
    PFNGLINDEXPOINTEREXTPROC epoxy_glIndexPointerEXT;
    PFNGLINDEXPOINTERLISTIBMPROC epoxy_glIndexPointerListIBM;
    PFNGLINDEXDPROC epoxy_glIndexd;
    PFNGLINDEXDVPROC epoxy_glIndexdv;
    PFNGLINDEXFPROC epoxy_glIndexf;
    PFNGLINDEXFVPROC epoxy_glIndexfv;
    PFNGLINDEXIPROC epoxy_glIndexi;
    PFNGLINDEXIVPROC epoxy_glIndexiv;
    PFNGLINDEXSPROC epoxy_glIndexs;
    PFNGLINDEXSVPROC epoxy_glIndexsv;
    PFNGLINDEXUBPROC epoxy_glIndexub;
    PFNGLINDEXUBVPROC epoxy_glIndexubv;
    PFNGLINDEXXOESPROC epoxy_glIndexxOES;
    PFNGLINDEXXVOESPROC epoxy_glIndexxvOES;
    PFNGLINITNAMESPROC epoxy_glInitNames;
    PFNGLINSERTCOMPONENTEXTPROC epoxy_glInsertComponentEXT;
    PFNGLINSERTEVENTMARKEREXTPROC epoxy_glInsertEventMarkerEXT;
    PFNGLINSTRUMENTSBUFFERSGIXPROC epoxy_glInstrumentsBufferSGIX;
    PFNGLINTERLEAVEDARRAYSPROC epoxy_glInterleavedArrays;
    PFNGLINTERPOLATEPATHSNVPROC epoxy_glInterpolatePathsNV;
    PFNGLINVALIDATEBUFFERDATAPROC epoxy_glInvalidateBufferData;
    PFNGLINVALIDATEBUFFERSUBDATAPROC epoxy_glInvalidateBufferSubData;
    PFNGLINVALIDATEFRAMEBUFFERPROC epoxy_glInvalidateFramebuffer;
    PFNGLINVALIDATENAMEDFRAMEBUFFERDATAPROC epoxy_glInvalidateNamedFramebufferData;
    PFNGLINVALIDATENAMEDFRAMEBUFFERSUBDATAPROC epoxy_glInvalidateNamedFramebufferSubData;
    PFNGLINVALIDATESUBFRAMEBUFFERPROC epoxy_glInvalidateSubFramebuffer;
    PFNGLINVALIDATETEXIMAGEPROC epoxy_glInvalidateTexImage;
    PFNGLINVALIDATETEXSUBIMAGEPROC epoxy_glInvalidateTexSubImage;
    PFNGLISASYNCMARKERSGIXPROC epoxy_glIsAsyncMarkerSGIX;
    PFNGLISBUFFERPROC epoxy_glIsBuffer;
    PFNGLISBUFFERARBPROC epoxy_glIsBufferARB;
    PFNGLISBUFFERRESIDENTNVPROC epoxy_glIsBufferResidentNV;
    PFNGLISCOMMANDLISTNVPROC epoxy_glIsCommandListNV;
    PFNGLISENABLEDPROC epoxy_glIsEnabled;
    PFNGLISENABLEDINDEXEDEXTPROC epoxy_glIsEnabledIndexedEXT;
    PFNGLISENABLEDIPROC epoxy_glIsEnabledi;
    PFNGLISENABLEDIEXTPROC epoxy_glIsEnablediEXT;
    PFNGLISENABLEDINVPROC epoxy_glIsEnablediNV;
    PFNGLISENABLEDIOESPROC epoxy_glIsEnablediOES;
    PFNGLISFENCEAPPLEPROC epoxy_glIsFenceAPPLE;
    PFNGLISFENCENVPROC epoxy_glIsFenceNV;
    PFNGLISFRAMEBUFFERPROC epoxy_glIsFramebuffer;
    PFNGLISFRAMEBUFFEREXTPROC epoxy_glIsFramebufferEXT;
    PFNGLISFRAMEBUFFEROESPROC epoxy_glIsFramebufferOES;
    PFNGLISIMAGEHANDLERESIDENTARBPROC epoxy_glIsImageHandleResidentARB;
    PFNGLISIMAGEHANDLERESIDENTNVPROC epoxy_glIsImageHandleResidentNV;
    PFNGLISLISTPROC epoxy_glIsList;
    PFNGLISMEMORYOBJECTEXTPROC epoxy_glIsMemoryObjectEXT;
    PFNGLISNAMEAMDPROC epoxy_glIsNameAMD;
    PFNGLISNAMEDBUFFERRESIDENTNVPROC epoxy_glIsNamedBufferResidentNV;
    PFNGLISNAMEDSTRINGARBPROC epoxy_glIsNamedStringARB;
    PFNGLISOBJECTBUFFERATIPROC epoxy_glIsObjectBufferATI;
    PFNGLISOCCLUSIONQUERYNVPROC epoxy_glIsOcclusionQueryNV;
    PFNGLISPATHNVPROC epoxy_glIsPathNV;
    PFNGLISPOINTINFILLPATHNVPROC epoxy_glIsPointInFillPathNV;
    PFNGLISPOINTINSTROKEPATHNVPROC epoxy_glIsPointInStrokePathNV;
    PFNGLISPROGRAMPROC epoxy_glIsProgram;
    PFNGLISPROGRAMARBPROC epoxy_glIsProgramARB;
    PFNGLISPROGRAMNVPROC epoxy_glIsProgramNV;
    PFNGLISPROGRAMPIPELINEPROC epoxy_glIsProgramPipeline;
    PFNGLISPROGRAMPIPELINEEXTPROC epoxy_glIsProgramPipelineEXT;
    PFNGLISQUERYPROC epoxy_glIsQuery;
    PFNGLISQUERYARBPROC epoxy_glIsQueryARB;
    PFNGLISQUERYEXTPROC epoxy_glIsQueryEXT;
    PFNGLISRENDERBUFFERPROC epoxy_glIsRenderbuffer;
    PFNGLISRENDERBUFFEREXTPROC epoxy_glIsRenderbufferEXT;
    PFNGLISRENDERBUFFEROESPROC epoxy_glIsRenderbufferOES;
    PFNGLISSAMPLERPROC epoxy_glIsSampler;
    PFNGLISSEMAPHOREEXTPROC epoxy_glIsSemaphoreEXT;
    PFNGLISSHADERPROC epoxy_glIsShader;
    PFNGLISSTATENVPROC epoxy_glIsStateNV;
    PFNGLISSYNCPROC epoxy_glIsSync;
    PFNGLISSYNCAPPLEPROC epoxy_glIsSyncAPPLE;
    PFNGLISTEXTUREPROC epoxy_glIsTexture;
    PFNGLISTEXTUREEXTPROC epoxy_glIsTextureEXT;
    PFNGLISTEXTUREHANDLERESIDENTARBPROC epoxy_glIsTextureHandleResidentARB;
    PFNGLISTEXTUREHANDLERESIDENTNVPROC epoxy_glIsTextureHandleResidentNV;
    PFNGLISTRANSFORMFEEDBACKPROC epoxy_glIsTransformFeedback;
    PFNGLISTRANSFORMFEEDBACKNVPROC epoxy_glIsTransformFeedbackNV;
    PFNGLISVARIANTENABLEDEXTPROC epoxy_glIsVariantEnabledEXT;
    PFNGLISVERTEXARRAYPROC epoxy_glIsVertexArray;
    PFNGLISVERTEXARRAYAPPLEPROC epoxy_glIsVertexArrayAPPLE;
    PFNGLISVERTEXARRAYOESPROC epoxy_glIsVertexArrayOES;
    PFNGLISVERTEXATTRIBENABLEDAPPLEPROC epoxy_glIsVertexAttribEnabledAPPLE;
    PFNGLLGPUCOPYIMAGESUBDATANVXPROC epoxy_glLGPUCopyImageSubDataNVX;
    PFNGLLGPUINTERLOCKNVXPROC epoxy_glLGPUInterlockNVX;
    PFNGLLGPUNAMEDBUFFERSUBDATANVXPROC epoxy_glLGPUNamedBufferSubDataNVX;
    PFNGLLABELOBJECTEXTPROC epoxy_glLabelObjectEXT;
    PFNGLLIGHTENVISGIXPROC epoxy_glLightEnviSGIX;
    PFNGLLIGHTMODELFPROC epoxy_glLightModelf;
    PFNGLLIGHTMODELFVPROC epoxy_glLightModelfv;
    PFNGLLIGHTMODELIPROC epoxy_glLightModeli;
    PFNGLLIGHTMODELIVPROC epoxy_glLightModeliv;
    PFNGLLIGHTMODELXPROC epoxy_glLightModelx;
    PFNGLLIGHTMODELXOESPROC epoxy_glLightModelxOES;
    PFNGLLIGHTMODELXVPROC epoxy_glLightModelxv;
    PFNGLLIGHTMODELXVOESPROC epoxy_glLightModelxvOES;
    PFNGLLIGHTFPROC epoxy_glLightf;
    PFNGLLIGHTFVPROC epoxy_glLightfv;
    PFNGLLIGHTIPROC epoxy_glLighti;
    PFNGLLIGHTIVPROC epoxy_glLightiv;
    PFNGLLIGHTXPROC epoxy_glLightx;
    PFNGLLIGHTXOESPROC epoxy_glLightxOES;
    PFNGLLIGHTXVPROC epoxy_glLightxv;
    PFNGLLIGHTXVOESPROC epoxy_glLightxvOES;
    PFNGLLINESTIPPLEPROC epoxy_glLineStipple;
    PFNGLLINEWIDTHPROC epoxy_glLineWidth;
    PFNGLLINEWIDTHXPROC epoxy_glLineWidthx;
    PFNGLLINEWIDTHXOESPROC epoxy_glLineWidthxOES;
    PFNGLLINKPROGRAMPROC epoxy_glLinkProgram;
    PFNGLLINKPROGRAMARBPROC epoxy_glLinkProgramARB;
    PFNGLLISTBASEPROC epoxy_glListBase;
    PFNGLLISTDRAWCOMMANDSSTATESCLIENTNVPROC epoxy_glListDrawCommandsStatesClientNV;
    PFNGLLISTPARAMETERFSGIXPROC epoxy_glListParameterfSGIX;
    PFNGLLISTPARAMETERFVSGIXPROC epoxy_glListParameterfvSGIX;
    PFNGLLISTPARAMETERISGIXPROC epoxy_glListParameteriSGIX;
    PFNGLLISTPARAMETERIVSGIXPROC epoxy_glListParameterivSGIX;
    PFNGLLOADIDENTITYPROC epoxy_glLoadIdentity;
    PFNGLLOADIDENTITYDEFORMATIONMAPSGIXPROC epoxy_glLoadIdentityDeformationMapSGIX;
    PFNGLLOADMATRIXDPROC epoxy_glLoadMatrixd;
    PFNGLLOADMATRIXFPROC epoxy_glLoadMatrixf;
    PFNGLLOADMATRIXXPROC epoxy_glLoadMatrixx;
    PFNGLLOADMATRIXXOESPROC epoxy_glLoadMatrixxOES;
    PFNGLLOADNAMEPROC epoxy_glLoadName;
    PFNGLLOADPALETTEFROMMODELVIEWMATRIXOESPROC epoxy_glLoadPaletteFromModelViewMatrixOES;
    PFNGLLOADPROGRAMNVPROC epoxy_glLoadProgramNV;
    PFNGLLOADTRANSPOSEMATRIXDPROC epoxy_glLoadTransposeMatrixd;
    PFNGLLOADTRANSPOSEMATRIXDARBPROC epoxy_glLoadTransposeMatrixdARB;
    PFNGLLOADTRANSPOSEMATRIXFPROC epoxy_glLoadTransposeMatrixf;
    PFNGLLOADTRANSPOSEMATRIXFARBPROC epoxy_glLoadTransposeMatrixfARB;
    PFNGLLOADTRANSPOSEMATRIXXOESPROC epoxy_glLoadTransposeMatrixxOES;
    PFNGLLOCKARRAYSEXTPROC epoxy_glLockArraysEXT;
    PFNGLLOGICOPPROC epoxy_glLogicOp;
    PFNGLMAKEBUFFERNONRESIDENTNVPROC epoxy_glMakeBufferNonResidentNV;
    PFNGLMAKEBUFFERRESIDENTNVPROC epoxy_glMakeBufferResidentNV;
    PFNGLMAKEIMAGEHANDLENONRESIDENTARBPROC epoxy_glMakeImageHandleNonResidentARB;
    PFNGLMAKEIMAGEHANDLENONRESIDENTNVPROC epoxy_glMakeImageHandleNonResidentNV;
    PFNGLMAKEIMAGEHANDLERESIDENTARBPROC epoxy_glMakeImageHandleResidentARB;
    PFNGLMAKEIMAGEHANDLERESIDENTNVPROC epoxy_glMakeImageHandleResidentNV;
    PFNGLMAKENAMEDBUFFERNONRESIDENTNVPROC epoxy_glMakeNamedBufferNonResidentNV;
    PFNGLMAKENAMEDBUFFERRESIDENTNVPROC epoxy_glMakeNamedBufferResidentNV;
    PFNGLMAKETEXTUREHANDLENONRESIDENTARBPROC epoxy_glMakeTextureHandleNonResidentARB;
    PFNGLMAKETEXTUREHANDLENONRESIDENTNVPROC epoxy_glMakeTextureHandleNonResidentNV;
    PFNGLMAKETEXTUREHANDLERESIDENTARBPROC epoxy_glMakeTextureHandleResidentARB;
    PFNGLMAKETEXTUREHANDLERESIDENTNVPROC epoxy_glMakeTextureHandleResidentNV;
    PFNGLMAP1DPROC epoxy_glMap1d;
    PFNGLMAP1FPROC epoxy_glMap1f;
    PFNGLMAP1XOESPROC epoxy_glMap1xOES;
    PFNGLMAP2DPROC epoxy_glMap2d;
    PFNGLMAP2FPROC epoxy_glMap2f;
    PFNGLMAP2XOESPROC epoxy_glMap2xOES;
    PFNGLMAPBUFFERPROC epoxy_glMapBuffer;
    PFNGLMAPBUFFERARBPROC epoxy_glMapBufferARB;
    PFNGLMAPBUFFEROESPROC epoxy_glMapBufferOES;
    PFNGLMAPBUFFERRANGEPROC epoxy_glMapBufferRange;
    PFNGLMAPBUFFERRANGEEXTPROC epoxy_glMapBufferRangeEXT;
    PFNGLMAPCONTROLPOINTSNVPROC epoxy_glMapControlPointsNV;
    PFNGLMAPGRID1DPROC epoxy_glMapGrid1d;
    PFNGLMAPGRID1FPROC epoxy_glMapGrid1f;
    PFNGLMAPGRID1XOESPROC epoxy_glMapGrid1xOES;
    PFNGLMAPGRID2DPROC epoxy_glMapGrid2d;
    PFNGLMAPGRID2FPROC epoxy_glMapGrid2f;
    PFNGLMAPGRID2XOESPROC epoxy_glMapGrid2xOES;
    PFNGLMAPNAMEDBUFFERPROC epoxy_glMapNamedBuffer;
    PFNGLMAPNAMEDBUFFEREXTPROC epoxy_glMapNamedBufferEXT;
    PFNGLMAPNAMEDBUFFERRANGEPROC epoxy_glMapNamedBufferRange;
    PFNGLMAPNAMEDBUFFERRANGEEXTPROC epoxy_glMapNamedBufferRangeEXT;
    PFNGLMAPOBJECTBUFFERATIPROC epoxy_glMapObjectBufferATI;
    PFNGLMAPPARAMETERFVNVPROC epoxy_glMapParameterfvNV;
    PFNGLMAPPARAMETERIVNVPROC epoxy_glMapParameterivNV;
    PFNGLMAPTEXTURE2DINTELPROC epoxy_glMapTexture2DINTEL;
    PFNGLMAPVERTEXATTRIB1DAPPLEPROC epoxy_glMapVertexAttrib1dAPPLE;
    PFNGLMAPVERTEXATTRIB1FAPPLEPROC epoxy_glMapVertexAttrib1fAPPLE;
    PFNGLMAPVERTEXATTRIB2DAPPLEPROC epoxy_glMapVertexAttrib2dAPPLE;
    PFNGLMAPVERTEXATTRIB2FAPPLEPROC epoxy_glMapVertexAttrib2fAPPLE;
    PFNGLMATERIALFPROC epoxy_glMaterialf;
    PFNGLMATERIALFVPROC epoxy_glMaterialfv;
    PFNGLMATERIALIPROC epoxy_glMateriali;
    PFNGLMATERIALIVPROC epoxy_glMaterialiv;
    PFNGLMATERIALXPROC epoxy_glMaterialx;
    PFNGLMATERIALXOESPROC epoxy_glMaterialxOES;
    PFNGLMATERIALXVPROC epoxy_glMaterialxv;
    PFNGLMATERIALXVOESPROC epoxy_glMaterialxvOES;
    PFNGLMATRIXFRUSTUMEXTPROC epoxy_glMatrixFrustumEXT;
    PFNGLMATRIXINDEXPOINTERARBPROC epoxy_glMatrixIndexPointerARB;
    PFNGLMATRIXINDEXPOINTEROESPROC epoxy_glMatrixIndexPointerOES;
    PFNGLMATRIXINDEXUBVARBPROC epoxy_glMatrixIndexubvARB;
    PFNGLMATRIXINDEXUIVARBPROC epoxy_glMatrixIndexuivARB;
    PFNGLMATRIXINDEXUSVARBPROC epoxy_glMatrixIndexusvARB;
    PFNGLMATRIXLOAD3X2FNVPROC epoxy_glMatrixLoad3x2fNV;
    PFNGLMATRIXLOAD3X3FNVPROC epoxy_glMatrixLoad3x3fNV;
    PFNGLMATRIXLOADIDENTITYEXTPROC epoxy_glMatrixLoadIdentityEXT;
    PFNGLMATRIXLOADTRANSPOSE3X3FNVPROC epoxy_glMatrixLoadTranspose3x3fNV;
    PFNGLMATRIXLOADTRANSPOSEDEXTPROC epoxy_glMatrixLoadTransposedEXT;
    PFNGLMATRIXLOADTRANSPOSEFEXTPROC epoxy_glMatrixLoadTransposefEXT;
    PFNGLMATRIXLOADDEXTPROC epoxy_glMatrixLoaddEXT;
    PFNGLMATRIXLOADFEXTPROC epoxy_glMatrixLoadfEXT;
    PFNGLMATRIXMODEPROC epoxy_glMatrixMode;
    PFNGLMATRIXMULT3X2FNVPROC epoxy_glMatrixMult3x2fNV;
    PFNGLMATRIXMULT3X3FNVPROC epoxy_glMatrixMult3x3fNV;
    PFNGLMATRIXMULTTRANSPOSE3X3FNVPROC epoxy_glMatrixMultTranspose3x3fNV;
    PFNGLMATRIXMULTTRANSPOSEDEXTPROC epoxy_glMatrixMultTransposedEXT;
    PFNGLMATRIXMULTTRANSPOSEFEXTPROC epoxy_glMatrixMultTransposefEXT;
    PFNGLMATRIXMULTDEXTPROC epoxy_glMatrixMultdEXT;
    PFNGLMATRIXMULTFEXTPROC epoxy_glMatrixMultfEXT;
    PFNGLMATRIXORTHOEXTPROC epoxy_glMatrixOrthoEXT;
    PFNGLMATRIXPOPEXTPROC epoxy_glMatrixPopEXT;
    PFNGLMATRIXPUSHEXTPROC epoxy_glMatrixPushEXT;
    PFNGLMATRIXROTATEDEXTPROC epoxy_glMatrixRotatedEXT;
    PFNGLMATRIXROTATEFEXTPROC epoxy_glMatrixRotatefEXT;
    PFNGLMATRIXSCALEDEXTPROC epoxy_glMatrixScaledEXT;
    PFNGLMATRIXSCALEFEXTPROC epoxy_glMatrixScalefEXT;
    PFNGLMATRIXTRANSLATEDEXTPROC epoxy_glMatrixTranslatedEXT;
    PFNGLMATRIXTRANSLATEFEXTPROC epoxy_glMatrixTranslatefEXT;
    PFNGLMAXSHADERCOMPILERTHREADSARBPROC epoxy_glMaxShaderCompilerThreadsARB;
    PFNGLMAXSHADERCOMPILERTHREADSKHRPROC epoxy_glMaxShaderCompilerThreadsKHR;
    PFNGLMEMORYBARRIERPROC epoxy_glMemoryBarrier;
    PFNGLMEMORYBARRIERBYREGIONPROC epoxy_glMemoryBarrierByRegion;
    PFNGLMEMORYBARRIEREXTPROC epoxy_glMemoryBarrierEXT;
    PFNGLMEMORYOBJECTPARAMETERIVEXTPROC epoxy_glMemoryObjectParameterivEXT;
    PFNGLMINSAMPLESHADINGPROC epoxy_glMinSampleShading;
    PFNGLMINSAMPLESHADINGARBPROC epoxy_glMinSampleShadingARB;
    PFNGLMINSAMPLESHADINGOESPROC epoxy_glMinSampleShadingOES;
    PFNGLMINMAXPROC epoxy_glMinmax;
    PFNGLMINMAXEXTPROC epoxy_glMinmaxEXT;
    PFNGLMULTMATRIXDPROC epoxy_glMultMatrixd;
    PFNGLMULTMATRIXFPROC epoxy_glMultMatrixf;
    PFNGLMULTMATRIXXPROC epoxy_glMultMatrixx;
    PFNGLMULTMATRIXXOESPROC epoxy_glMultMatrixxOES;
    PFNGLMULTTRANSPOSEMATRIXDPROC epoxy_glMultTransposeMatrixd;
    PFNGLMULTTRANSPOSEMATRIXDARBPROC epoxy_glMultTransposeMatrixdARB;
    PFNGLMULTTRANSPOSEMATRIXFPROC epoxy_glMultTransposeMatrixf;
    PFNGLMULTTRANSPOSEMATRIXFARBPROC epoxy_glMultTransposeMatrixfARB;
    PFNGLMULTTRANSPOSEMATRIXXOESPROC epoxy_glMultTransposeMatrixxOES;
    PFNGLMULTIDRAWARRAYSPROC epoxy_glMultiDrawArrays;
    PFNGLMULTIDRAWARRAYSEXTPROC epoxy_glMultiDrawArraysEXT;
    PFNGLMULTIDRAWARRAYSINDIRECTPROC epoxy_glMultiDrawArraysIndirect;
    PFNGLMULTIDRAWARRAYSINDIRECTAMDPROC epoxy_glMultiDrawArraysIndirectAMD;
    PFNGLMULTIDRAWARRAYSINDIRECTBINDLESSCOUNTNVPROC epoxy_glMultiDrawArraysIndirectBindlessCountNV;
    PFNGLMULTIDRAWARRAYSINDIRECTBINDLESSNVPROC epoxy_glMultiDrawArraysIndirectBindlessNV;
    PFNGLMULTIDRAWARRAYSINDIRECTCOUNTPROC epoxy_glMultiDrawArraysIndirectCount;
    PFNGLMULTIDRAWARRAYSINDIRECTCOUNTARBPROC epoxy_glMultiDrawArraysIndirectCountARB;
    PFNGLMULTIDRAWARRAYSINDIRECTEXTPROC epoxy_glMultiDrawArraysIndirectEXT;
    PFNGLMULTIDRAWELEMENTARRAYAPPLEPROC epoxy_glMultiDrawElementArrayAPPLE;
    PFNGLMULTIDRAWELEMENTSPROC epoxy_glMultiDrawElements;
    PFNGLMULTIDRAWELEMENTSBASEVERTEXPROC epoxy_glMultiDrawElementsBaseVertex;
    PFNGLMULTIDRAWELEMENTSBASEVERTEXEXTPROC epoxy_glMultiDrawElementsBaseVertexEXT;
    PFNGLMULTIDRAWELEMENTSEXTPROC epoxy_glMultiDrawElementsEXT;
    PFNGLMULTIDRAWELEMENTSINDIRECTPROC epoxy_glMultiDrawElementsIndirect;
    PFNGLMULTIDRAWELEMENTSINDIRECTAMDPROC epoxy_glMultiDrawElementsIndirectAMD;
    PFNGLMULTIDRAWELEMENTSINDIRECTBINDLESSCOUNTNVPROC epoxy_glMultiDrawElementsIndirectBindlessCountNV;
    PFNGLMULTIDRAWELEMENTSINDIRECTBINDLESSNVPROC epoxy_glMultiDrawElementsIndirectBindlessNV;
    PFNGLMULTIDRAWELEMENTSINDIRECTCOUNTPROC epoxy_glMultiDrawElementsIndirectCount;
    PFNGLMULTIDRAWELEMENTSINDIRECTCOUNTARBPROC epoxy_glMultiDrawElementsIndirectCountARB;
    PFNGLMULTIDRAWELEMENTSINDIRECTEXTPROC epoxy_glMultiDrawElementsIndirectEXT;
    PFNGLMULTIDRAWRANGEELEMENTARRAYAPPLEPROC epoxy_glMultiDrawRangeElementArrayAPPLE;
    PFNGLMULTIMODEDRAWARRAYSIBMPROC epoxy_glMultiModeDrawArraysIBM;
    PFNGLMULTIMODEDRAWELEMENTSIBMPROC epoxy_glMultiModeDrawElementsIBM;
    PFNGLMULTITEXBUFFEREXTPROC epoxy_glMultiTexBufferEXT;
    PFNGLMULTITEXCOORD1BOESPROC epoxy_glMultiTexCoord1bOES;
    PFNGLMULTITEXCOORD1BVOESPROC epoxy_glMultiTexCoord1bvOES;
    PFNGLMULTITEXCOORD1DPROC epoxy_glMultiTexCoord1d;
    PFNGLMULTITEXCOORD1DARBPROC epoxy_glMultiTexCoord1dARB;
    PFNGLMULTITEXCOORD1DVPROC epoxy_glMultiTexCoord1dv;
    PFNGLMULTITEXCOORD1DVARBPROC epoxy_glMultiTexCoord1dvARB;
    PFNGLMULTITEXCOORD1FPROC epoxy_glMultiTexCoord1f;
    PFNGLMULTITEXCOORD1FARBPROC epoxy_glMultiTexCoord1fARB;
    PFNGLMULTITEXCOORD1FVPROC epoxy_glMultiTexCoord1fv;
    PFNGLMULTITEXCOORD1FVARBPROC epoxy_glMultiTexCoord1fvARB;
    PFNGLMULTITEXCOORD1HNVPROC epoxy_glMultiTexCoord1hNV;
    PFNGLMULTITEXCOORD1HVNVPROC epoxy_glMultiTexCoord1hvNV;
    PFNGLMULTITEXCOORD1IPROC epoxy_glMultiTexCoord1i;
    PFNGLMULTITEXCOORD1IARBPROC epoxy_glMultiTexCoord1iARB;
    PFNGLMULTITEXCOORD1IVPROC epoxy_glMultiTexCoord1iv;
    PFNGLMULTITEXCOORD1IVARBPROC epoxy_glMultiTexCoord1ivARB;
    PFNGLMULTITEXCOORD1SPROC epoxy_glMultiTexCoord1s;
    PFNGLMULTITEXCOORD1SARBPROC epoxy_glMultiTexCoord1sARB;
    PFNGLMULTITEXCOORD1SVPROC epoxy_glMultiTexCoord1sv;
    PFNGLMULTITEXCOORD1SVARBPROC epoxy_glMultiTexCoord1svARB;
    PFNGLMULTITEXCOORD1XOESPROC epoxy_glMultiTexCoord1xOES;
    PFNGLMULTITEXCOORD1XVOESPROC epoxy_glMultiTexCoord1xvOES;
    PFNGLMULTITEXCOORD2BOESPROC epoxy_glMultiTexCoord2bOES;
    PFNGLMULTITEXCOORD2BVOESPROC epoxy_glMultiTexCoord2bvOES;
    PFNGLMULTITEXCOORD2DPROC epoxy_glMultiTexCoord2d;
    PFNGLMULTITEXCOORD2DARBPROC epoxy_glMultiTexCoord2dARB;
    PFNGLMULTITEXCOORD2DVPROC epoxy_glMultiTexCoord2dv;
    PFNGLMULTITEXCOORD2DVARBPROC epoxy_glMultiTexCoord2dvARB;
    PFNGLMULTITEXCOORD2FPROC epoxy_glMultiTexCoord2f;
    PFNGLMULTITEXCOORD2FARBPROC epoxy_glMultiTexCoord2fARB;
    PFNGLMULTITEXCOORD2FVPROC epoxy_glMultiTexCoord2fv;
    PFNGLMULTITEXCOORD2FVARBPROC epoxy_glMultiTexCoord2fvARB;
    PFNGLMULTITEXCOORD2HNVPROC epoxy_glMultiTexCoord2hNV;
    PFNGLMULTITEXCOORD2HVNVPROC epoxy_glMultiTexCoord2hvNV;
    PFNGLMULTITEXCOORD2IPROC epoxy_glMultiTexCoord2i;
    PFNGLMULTITEXCOORD2IARBPROC epoxy_glMultiTexCoord2iARB;
    PFNGLMULTITEXCOORD2IVPROC epoxy_glMultiTexCoord2iv;
    PFNGLMULTITEXCOORD2IVARBPROC epoxy_glMultiTexCoord2ivARB;
    PFNGLMULTITEXCOORD2SPROC epoxy_glMultiTexCoord2s;
    PFNGLMULTITEXCOORD2SARBPROC epoxy_glMultiTexCoord2sARB;
    PFNGLMULTITEXCOORD2SVPROC epoxy_glMultiTexCoord2sv;
    PFNGLMULTITEXCOORD2SVARBPROC epoxy_glMultiTexCoord2svARB;
    PFNGLMULTITEXCOORD2XOESPROC epoxy_glMultiTexCoord2xOES;
    PFNGLMULTITEXCOORD2XVOESPROC epoxy_glMultiTexCoord2xvOES;
    PFNGLMULTITEXCOORD3BOESPROC epoxy_glMultiTexCoord3bOES;
    PFNGLMULTITEXCOORD3BVOESPROC epoxy_glMultiTexCoord3bvOES;
    PFNGLMULTITEXCOORD3DPROC epoxy_glMultiTexCoord3d;
    PFNGLMULTITEXCOORD3DARBPROC epoxy_glMultiTexCoord3dARB;
    PFNGLMULTITEXCOORD3DVPROC epoxy_glMultiTexCoord3dv;
    PFNGLMULTITEXCOORD3DVARBPROC epoxy_glMultiTexCoord3dvARB;
    PFNGLMULTITEXCOORD3FPROC epoxy_glMultiTexCoord3f;
    PFNGLMULTITEXCOORD3FARBPROC epoxy_glMultiTexCoord3fARB;
    PFNGLMULTITEXCOORD3FVPROC epoxy_glMultiTexCoord3fv;
    PFNGLMULTITEXCOORD3FVARBPROC epoxy_glMultiTexCoord3fvARB;
    PFNGLMULTITEXCOORD3HNVPROC epoxy_glMultiTexCoord3hNV;
    PFNGLMULTITEXCOORD3HVNVPROC epoxy_glMultiTexCoord3hvNV;
    PFNGLMULTITEXCOORD3IPROC epoxy_glMultiTexCoord3i;
    PFNGLMULTITEXCOORD3IARBPROC epoxy_glMultiTexCoord3iARB;
    PFNGLMULTITEXCOORD3IVPROC epoxy_glMultiTexCoord3iv;
    PFNGLMULTITEXCOORD3IVARBPROC epoxy_glMultiTexCoord3ivARB;
    PFNGLMULTITEXCOORD3SPROC epoxy_glMultiTexCoord3s;
    PFNGLMULTITEXCOORD3SARBPROC epoxy_glMultiTexCoord3sARB;
    PFNGLMULTITEXCOORD3SVPROC epoxy_glMultiTexCoord3sv;
    PFNGLMULTITEXCOORD3SVARBPROC epoxy_glMultiTexCoord3svARB;
    PFNGLMULTITEXCOORD3XOESPROC epoxy_glMultiTexCoord3xOES;
    PFNGLMULTITEXCOORD3XVOESPROC epoxy_glMultiTexCoord3xvOES;
    PFNGLMULTITEXCOORD4BOESPROC epoxy_glMultiTexCoord4bOES;
    PFNGLMULTITEXCOORD4BVOESPROC epoxy_glMultiTexCoord4bvOES;
    PFNGLMULTITEXCOORD4DPROC epoxy_glMultiTexCoord4d;
    PFNGLMULTITEXCOORD4DARBPROC epoxy_glMultiTexCoord4dARB;
    PFNGLMULTITEXCOORD4DVPROC epoxy_glMultiTexCoord4dv;
    PFNGLMULTITEXCOORD4DVARBPROC epoxy_glMultiTexCoord4dvARB;
    PFNGLMULTITEXCOORD4FPROC epoxy_glMultiTexCoord4f;
    PFNGLMULTITEXCOORD4FARBPROC epoxy_glMultiTexCoord4fARB;
    PFNGLMULTITEXCOORD4FVPROC epoxy_glMultiTexCoord4fv;
    PFNGLMULTITEXCOORD4FVARBPROC epoxy_glMultiTexCoord4fvARB;
    PFNGLMULTITEXCOORD4HNVPROC epoxy_glMultiTexCoord4hNV;
    PFNGLMULTITEXCOORD4HVNVPROC epoxy_glMultiTexCoord4hvNV;
    PFNGLMULTITEXCOORD4IPROC epoxy_glMultiTexCoord4i;
    PFNGLMULTITEXCOORD4IARBPROC epoxy_glMultiTexCoord4iARB;
    PFNGLMULTITEXCOORD4IVPROC epoxy_glMultiTexCoord4iv;
    PFNGLMULTITEXCOORD4IVARBPROC epoxy_glMultiTexCoord4ivARB;
    PFNGLMULTITEXCOORD4SPROC epoxy_glMultiTexCoord4s;
    PFNGLMULTITEXCOORD4SARBPROC epoxy_glMultiTexCoord4sARB;
    PFNGLMULTITEXCOORD4SVPROC epoxy_glMultiTexCoord4sv;
    PFNGLMULTITEXCOORD4SVARBPROC epoxy_glMultiTexCoord4svARB;
    PFNGLMULTITEXCOORD4XPROC epoxy_glMultiTexCoord4x;
    PFNGLMULTITEXCOORD4XOESPROC epoxy_glMultiTexCoord4xOES;
    PFNGLMULTITEXCOORD4XVOESPROC epoxy_glMultiTexCoord4xvOES;
    PFNGLMULTITEXCOORDP1UIPROC epoxy_glMultiTexCoordP1ui;
    PFNGLMULTITEXCOORDP1UIVPROC epoxy_glMultiTexCoordP1uiv;
    PFNGLMULTITEXCOORDP2UIPROC epoxy_glMultiTexCoordP2ui;
    PFNGLMULTITEXCOORDP2UIVPROC epoxy_glMultiTexCoordP2uiv;
    PFNGLMULTITEXCOORDP3UIPROC epoxy_glMultiTexCoordP3ui;
    PFNGLMULTITEXCOORDP3UIVPROC epoxy_glMultiTexCoordP3uiv;
    PFNGLMULTITEXCOORDP4UIPROC epoxy_glMultiTexCoordP4ui;
    PFNGLMULTITEXCOORDP4UIVPROC epoxy_glMultiTexCoordP4uiv;
    PFNGLMULTITEXCOORDPOINTEREXTPROC epoxy_glMultiTexCoordPointerEXT;
    PFNGLMULTITEXENVFEXTPROC epoxy_glMultiTexEnvfEXT;
    PFNGLMULTITEXENVFVEXTPROC epoxy_glMultiTexEnvfvEXT;
    PFNGLMULTITEXENVIEXTPROC epoxy_glMultiTexEnviEXT;
    PFNGLMULTITEXENVIVEXTPROC epoxy_glMultiTexEnvivEXT;
    PFNGLMULTITEXGENDEXTPROC epoxy_glMultiTexGendEXT;
    PFNGLMULTITEXGENDVEXTPROC epoxy_glMultiTexGendvEXT;
    PFNGLMULTITEXGENFEXTPROC epoxy_glMultiTexGenfEXT;
    PFNGLMULTITEXGENFVEXTPROC epoxy_glMultiTexGenfvEXT;
    PFNGLMULTITEXGENIEXTPROC epoxy_glMultiTexGeniEXT;
    PFNGLMULTITEXGENIVEXTPROC epoxy_glMultiTexGenivEXT;
    PFNGLMULTITEXIMAGE1DEXTPROC epoxy_glMultiTexImage1DEXT;
    PFNGLMULTITEXIMAGE2DEXTPROC epoxy_glMultiTexImage2DEXT;
    PFNGLMULTITEXIMAGE3DEXTPROC epoxy_glMultiTexImage3DEXT;
    PFNGLMULTITEXPARAMETERIIVEXTPROC epoxy_glMultiTexParameterIivEXT;
    PFNGLMULTITEXPARAMETERIUIVEXTPROC epoxy_glMultiTexParameterIuivEXT;
    PFNGLMULTITEXPARAMETERFEXTPROC epoxy_glMultiTexParameterfEXT;
    PFNGLMULTITEXPARAMETERFVEXTPROC epoxy_glMultiTexParameterfvEXT;
    PFNGLMULTITEXPARAMETERIEXTPROC epoxy_glMultiTexParameteriEXT;
    PFNGLMULTITEXPARAMETERIVEXTPROC epoxy_glMultiTexParameterivEXT;
    PFNGLMULTITEXRENDERBUFFEREXTPROC epoxy_glMultiTexRenderbufferEXT;
    PFNGLMULTITEXSUBIMAGE1DEXTPROC epoxy_glMultiTexSubImage1DEXT;
    PFNGLMULTITEXSUBIMAGE2DEXTPROC epoxy_glMultiTexSubImage2DEXT;
    PFNGLMULTITEXSUBIMAGE3DEXTPROC epoxy_glMultiTexSubImage3DEXT;
    PFNGLMULTICASTBARRIERNVPROC epoxy_glMulticastBarrierNV;
    PFNGLMULTICASTBLITFRAMEBUFFERNVPROC epoxy_glMulticastBlitFramebufferNV;
    PFNGLMULTICASTBUFFERSUBDATANVPROC epoxy_glMulticastBufferSubDataNV;
    PFNGLMULTICASTCOPYBUFFERSUBDATANVPROC epoxy_glMulticastCopyBufferSubDataNV;
    PFNGLMULTICASTCOPYIMAGESUBDATANVPROC epoxy_glMulticastCopyImageSubDataNV;
    PFNGLMULTICASTFRAMEBUFFERSAMPLELOCATIONSFVNVPROC epoxy_glMulticastFramebufferSampleLocationsfvNV;
    PFNGLMULTICASTGETQUERYOBJECTI64VNVPROC epoxy_glMulticastGetQueryObjecti64vNV;
    PFNGLMULTICASTGETQUERYOBJECTIVNVPROC epoxy_glMulticastGetQueryObjectivNV;
    PFNGLMULTICASTGETQUERYOBJECTUI64VNVPROC epoxy_glMulticastGetQueryObjectui64vNV;
    PFNGLMULTICASTGETQUERYOBJECTUIVNVPROC epoxy_glMulticastGetQueryObjectuivNV;
    PFNGLMULTICASTWAITSYNCNVPROC epoxy_glMulticastWaitSyncNV;
    PFNGLNAMEDBUFFERDATAPROC epoxy_glNamedBufferData;
    PFNGLNAMEDBUFFERDATAEXTPROC epoxy_glNamedBufferDataEXT;
    PFNGLNAMEDBUFFERPAGECOMMITMENTARBPROC epoxy_glNamedBufferPageCommitmentARB;
    PFNGLNAMEDBUFFERPAGECOMMITMENTEXTPROC epoxy_glNamedBufferPageCommitmentEXT;
    PFNGLNAMEDBUFFERSTORAGEPROC epoxy_glNamedBufferStorage;
    PFNGLNAMEDBUFFERSTORAGEEXTPROC epoxy_glNamedBufferStorageEXT;
    PFNGLNAMEDBUFFERSTORAGEEXTERNALEXTPROC epoxy_glNamedBufferStorageExternalEXT;
    PFNGLNAMEDBUFFERSTORAGEMEMEXTPROC epoxy_glNamedBufferStorageMemEXT;
    PFNGLNAMEDBUFFERSUBDATAPROC epoxy_glNamedBufferSubData;
    PFNGLNAMEDBUFFERSUBDATAEXTPROC epoxy_glNamedBufferSubDataEXT;
    PFNGLNAMEDCOPYBUFFERSUBDATAEXTPROC epoxy_glNamedCopyBufferSubDataEXT;
    PFNGLNAMEDFRAMEBUFFERDRAWBUFFERPROC epoxy_glNamedFramebufferDrawBuffer;
    PFNGLNAMEDFRAMEBUFFERDRAWBUFFERSPROC epoxy_glNamedFramebufferDrawBuffers;
    PFNGLNAMEDFRAMEBUFFERPARAMETERIPROC epoxy_glNamedFramebufferParameteri;
    PFNGLNAMEDFRAMEBUFFERPARAMETERIEXTPROC epoxy_glNamedFramebufferParameteriEXT;
    PFNGLNAMEDFRAMEBUFFERREADBUFFERPROC epoxy_glNamedFramebufferReadBuffer;
    PFNGLNAMEDFRAMEBUFFERRENDERBUFFERPROC epoxy_glNamedFramebufferRenderbuffer;
    PFNGLNAMEDFRAMEBUFFERRENDERBUFFEREXTPROC epoxy_glNamedFramebufferRenderbufferEXT;
    PFNGLNAMEDFRAMEBUFFERSAMPLELOCATIONSFVARBPROC epoxy_glNamedFramebufferSampleLocationsfvARB;
    PFNGLNAMEDFRAMEBUFFERSAMPLELOCATIONSFVNVPROC epoxy_glNamedFramebufferSampleLocationsfvNV;
    PFNGLNAMEDFRAMEBUFFERSAMPLEPOSITIONSFVAMDPROC epoxy_glNamedFramebufferSamplePositionsfvAMD;
    PFNGLNAMEDFRAMEBUFFERTEXTUREPROC epoxy_glNamedFramebufferTexture;
    PFNGLNAMEDFRAMEBUFFERTEXTURE1DEXTPROC epoxy_glNamedFramebufferTexture1DEXT;
    PFNGLNAMEDFRAMEBUFFERTEXTURE2DEXTPROC epoxy_glNamedFramebufferTexture2DEXT;
    PFNGLNAMEDFRAMEBUFFERTEXTURE3DEXTPROC epoxy_glNamedFramebufferTexture3DEXT;
    PFNGLNAMEDFRAMEBUFFERTEXTUREEXTPROC epoxy_glNamedFramebufferTextureEXT;
    PFNGLNAMEDFRAMEBUFFERTEXTUREFACEEXTPROC epoxy_glNamedFramebufferTextureFaceEXT;
    PFNGLNAMEDFRAMEBUFFERTEXTURELAYERPROC epoxy_glNamedFramebufferTextureLayer;
    PFNGLNAMEDFRAMEBUFFERTEXTURELAYEREXTPROC epoxy_glNamedFramebufferTextureLayerEXT;
    PFNGLNAMEDPROGRAMLOCALPARAMETER4DEXTPROC epoxy_glNamedProgramLocalParameter4dEXT;
    PFNGLNAMEDPROGRAMLOCALPARAMETER4DVEXTPROC epoxy_glNamedProgramLocalParameter4dvEXT;
    PFNGLNAMEDPROGRAMLOCALPARAMETER4FEXTPROC epoxy_glNamedProgramLocalParameter4fEXT;
    PFNGLNAMEDPROGRAMLOCALPARAMETER4FVEXTPROC epoxy_glNamedProgramLocalParameter4fvEXT;
    PFNGLNAMEDPROGRAMLOCALPARAMETERI4IEXTPROC epoxy_glNamedProgramLocalParameterI4iEXT;
    PFNGLNAMEDPROGRAMLOCALPARAMETERI4IVEXTPROC epoxy_glNamedProgramLocalParameterI4ivEXT;
    PFNGLNAMEDPROGRAMLOCALPARAMETERI4UIEXTPROC epoxy_glNamedProgramLocalParameterI4uiEXT;
    PFNGLNAMEDPROGRAMLOCALPARAMETERI4UIVEXTPROC epoxy_glNamedProgramLocalParameterI4uivEXT;
    PFNGLNAMEDPROGRAMLOCALPARAMETERS4FVEXTPROC epoxy_glNamedProgramLocalParameters4fvEXT;
    PFNGLNAMEDPROGRAMLOCALPARAMETERSI4IVEXTPROC epoxy_glNamedProgramLocalParametersI4ivEXT;
    PFNGLNAMEDPROGRAMLOCALPARAMETERSI4UIVEXTPROC epoxy_glNamedProgramLocalParametersI4uivEXT;
    PFNGLNAMEDPROGRAMSTRINGEXTPROC epoxy_glNamedProgramStringEXT;
    PFNGLNAMEDRENDERBUFFERSTORAGEPROC epoxy_glNamedRenderbufferStorage;
    PFNGLNAMEDRENDERBUFFERSTORAGEEXTPROC epoxy_glNamedRenderbufferStorageEXT;
    PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEPROC epoxy_glNamedRenderbufferStorageMultisample;
    PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLECOVERAGEEXTPROC epoxy_glNamedRenderbufferStorageMultisampleCoverageEXT;
    PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEEXTPROC epoxy_glNamedRenderbufferStorageMultisampleEXT;
    PFNGLNAMEDSTRINGARBPROC epoxy_glNamedStringARB;
    PFNGLNEWLISTPROC epoxy_glNewList;
    PFNGLNEWOBJECTBUFFERATIPROC epoxy_glNewObjectBufferATI;
    PFNGLNORMAL3BPROC epoxy_glNormal3b;
    PFNGLNORMAL3BVPROC epoxy_glNormal3bv;
    PFNGLNORMAL3DPROC epoxy_glNormal3d;
    PFNGLNORMAL3DVPROC epoxy_glNormal3dv;
    PFNGLNORMAL3FPROC epoxy_glNormal3f;
    PFNGLNORMAL3FVERTEX3FSUNPROC epoxy_glNormal3fVertex3fSUN;
    PFNGLNORMAL3FVERTEX3FVSUNPROC epoxy_glNormal3fVertex3fvSUN;
    PFNGLNORMAL3FVPROC epoxy_glNormal3fv;
    PFNGLNORMAL3HNVPROC epoxy_glNormal3hNV;
    PFNGLNORMAL3HVNVPROC epoxy_glNormal3hvNV;
    PFNGLNORMAL3IPROC epoxy_glNormal3i;
    PFNGLNORMAL3IVPROC epoxy_glNormal3iv;
    PFNGLNORMAL3SPROC epoxy_glNormal3s;
    PFNGLNORMAL3SVPROC epoxy_glNormal3sv;
    PFNGLNORMAL3XPROC epoxy_glNormal3x;
    PFNGLNORMAL3XOESPROC epoxy_glNormal3xOES;
    PFNGLNORMAL3XVOESPROC epoxy_glNormal3xvOES;
    PFNGLNORMALFORMATNVPROC epoxy_glNormalFormatNV;
    PFNGLNORMALP3UIPROC epoxy_glNormalP3ui;
    PFNGLNORMALP3UIVPROC epoxy_glNormalP3uiv;
    PFNGLNORMALPOINTERPROC epoxy_glNormalPointer;
    PFNGLNORMALPOINTEREXTPROC epoxy_glNormalPointerEXT;
    PFNGLNORMALPOINTERLISTIBMPROC epoxy_glNormalPointerListIBM;
    PFNGLNORMALPOINTERVINTELPROC epoxy_glNormalPointervINTEL;
    PFNGLNORMALSTREAM3BATIPROC epoxy_glNormalStream3bATI;
    PFNGLNORMALSTREAM3BVATIPROC epoxy_glNormalStream3bvATI;
    PFNGLNORMALSTREAM3DATIPROC epoxy_glNormalStream3dATI;
    PFNGLNORMALSTREAM3DVATIPROC epoxy_glNormalStream3dvATI;
    PFNGLNORMALSTREAM3FATIPROC epoxy_glNormalStream3fATI;
    PFNGLNORMALSTREAM3FVATIPROC epoxy_glNormalStream3fvATI;
    PFNGLNORMALSTREAM3IATIPROC epoxy_glNormalStream3iATI;
    PFNGLNORMALSTREAM3IVATIPROC epoxy_glNormalStream3ivATI;
    PFNGLNORMALSTREAM3SATIPROC epoxy_glNormalStream3sATI;
    PFNGLNORMALSTREAM3SVATIPROC epoxy_glNormalStream3svATI;
    PFNGLOBJECTLABELPROC epoxy_glObjectLabel;
    PFNGLOBJECTLABELKHRPROC epoxy_glObjectLabelKHR;
    PFNGLOBJECTPTRLABELPROC epoxy_glObjectPtrLabel;
    PFNGLOBJECTPTRLABELKHRPROC epoxy_glObjectPtrLabelKHR;
    PFNGLOBJECTPURGEABLEAPPLEPROC epoxy_glObjectPurgeableAPPLE;
    PFNGLOBJECTUNPURGEABLEAPPLEPROC epoxy_glObjectUnpurgeableAPPLE;
    PFNGLORTHOPROC epoxy_glOrtho;
    PFNGLORTHOFPROC epoxy_glOrthof;
    PFNGLORTHOFOESPROC epoxy_glOrthofOES;
    PFNGLORTHOXPROC epoxy_glOrthox;
    PFNGLORTHOXOESPROC epoxy_glOrthoxOES;
    PFNGLPNTRIANGLESFATIPROC epoxy_glPNTrianglesfATI;
    PFNGLPNTRIANGLESIATIPROC epoxy_glPNTrianglesiATI;
    PFNGLPASSTEXCOORDATIPROC epoxy_glPassTexCoordATI;
    PFNGLPASSTHROUGHPROC epoxy_glPassThrough;
    PFNGLPASSTHROUGHXOESPROC epoxy_glPassThroughxOES;
    PFNGLPATCHPARAMETERFVPROC epoxy_glPatchParameterfv;
    PFNGLPATCHPARAMETERIPROC epoxy_glPatchParameteri;
    PFNGLPATCHPARAMETERIEXTPROC epoxy_glPatchParameteriEXT;
    PFNGLPATCHPARAMETERIOESPROC epoxy_glPatchParameteriOES;
    PFNGLPATHCOLORGENNVPROC epoxy_glPathColorGenNV;
    PFNGLPATHCOMMANDSNVPROC epoxy_glPathCommandsNV;
    PFNGLPATHCOORDSNVPROC epoxy_glPathCoordsNV;
    PFNGLPATHCOVERDEPTHFUNCNVPROC epoxy_glPathCoverDepthFuncNV;
    PFNGLPATHDASHARRAYNVPROC epoxy_glPathDashArrayNV;
    PFNGLPATHFOGGENNVPROC epoxy_glPathFogGenNV;
    PFNGLPATHGLYPHINDEXARRAYNVPROC epoxy_glPathGlyphIndexArrayNV;
    PFNGLPATHGLYPHINDEXRANGENVPROC epoxy_glPathGlyphIndexRangeNV;
    PFNGLPATHGLYPHRANGENVPROC epoxy_glPathGlyphRangeNV;
    PFNGLPATHGLYPHSNVPROC epoxy_glPathGlyphsNV;
    PFNGLPATHMEMORYGLYPHINDEXARRAYNVPROC epoxy_glPathMemoryGlyphIndexArrayNV;
    PFNGLPATHPARAMETERFNVPROC epoxy_glPathParameterfNV;
    PFNGLPATHPARAMETERFVNVPROC epoxy_glPathParameterfvNV;
    PFNGLPATHPARAMETERINVPROC epoxy_glPathParameteriNV;
    PFNGLPATHPARAMETERIVNVPROC epoxy_glPathParameterivNV;
    PFNGLPATHSTENCILDEPTHOFFSETNVPROC epoxy_glPathStencilDepthOffsetNV;
    PFNGLPATHSTENCILFUNCNVPROC epoxy_glPathStencilFuncNV;
    PFNGLPATHSTRINGNVPROC epoxy_glPathStringNV;
    PFNGLPATHSUBCOMMANDSNVPROC epoxy_glPathSubCommandsNV;
    PFNGLPATHSUBCOORDSNVPROC epoxy_glPathSubCoordsNV;
    PFNGLPATHTEXGENNVPROC epoxy_glPathTexGenNV;
    PFNGLPAUSETRANSFORMFEEDBACKPROC epoxy_glPauseTransformFeedback;
    PFNGLPAUSETRANSFORMFEEDBACKNVPROC epoxy_glPauseTransformFeedbackNV;
    PFNGLPIXELDATARANGENVPROC epoxy_glPixelDataRangeNV;
    PFNGLPIXELMAPFVPROC epoxy_glPixelMapfv;
    PFNGLPIXELMAPUIVPROC epoxy_glPixelMapuiv;
    PFNGLPIXELMAPUSVPROC epoxy_glPixelMapusv;
    PFNGLPIXELMAPXPROC epoxy_glPixelMapx;
    PFNGLPIXELSTOREFPROC epoxy_glPixelStoref;
    PFNGLPIXELSTOREIPROC epoxy_glPixelStorei;
    PFNGLPIXELSTOREXPROC epoxy_glPixelStorex;
    PFNGLPIXELTEXGENPARAMETERFSGISPROC epoxy_glPixelTexGenParameterfSGIS;
    PFNGLPIXELTEXGENPARAMETERFVSGISPROC epoxy_glPixelTexGenParameterfvSGIS;
    PFNGLPIXELTEXGENPARAMETERISGISPROC epoxy_glPixelTexGenParameteriSGIS;
    PFNGLPIXELTEXGENPARAMETERIVSGISPROC epoxy_glPixelTexGenParameterivSGIS;
    PFNGLPIXELTEXGENSGIXPROC epoxy_glPixelTexGenSGIX;
    PFNGLPIXELTRANSFERFPROC epoxy_glPixelTransferf;
    PFNGLPIXELTRANSFERIPROC epoxy_glPixelTransferi;
    PFNGLPIXELTRANSFERXOESPROC epoxy_glPixelTransferxOES;
    PFNGLPIXELTRANSFORMPARAMETERFEXTPROC epoxy_glPixelTransformParameterfEXT;
    PFNGLPIXELTRANSFORMPARAMETERFVEXTPROC epoxy_glPixelTransformParameterfvEXT;
    PFNGLPIXELTRANSFORMPARAMETERIEXTPROC epoxy_glPixelTransformParameteriEXT;
    PFNGLPIXELTRANSFORMPARAMETERIVEXTPROC epoxy_glPixelTransformParameterivEXT;
    PFNGLPIXELZOOMPROC epoxy_glPixelZoom;
    PFNGLPIXELZOOMXOESPROC epoxy_glPixelZoomxOES;
    PFNGLPOINTALONGPATHNVPROC epoxy_glPointAlongPathNV;
    PFNGLPOINTPARAMETERFPROC epoxy_glPointParameterf;
    PFNGLPOINTPARAMETERFARBPROC epoxy_glPointParameterfARB;
    PFNGLPOINTPARAMETERFEXTPROC epoxy_glPointParameterfEXT;
    PFNGLPOINTPARAMETERFSGISPROC epoxy_glPointParameterfSGIS;
    PFNGLPOINTPARAMETERFVPROC epoxy_glPointParameterfv;
    PFNGLPOINTPARAMETERFVARBPROC epoxy_glPointParameterfvARB;
    PFNGLPOINTPARAMETERFVEXTPROC epoxy_glPointParameterfvEXT;
    PFNGLPOINTPARAMETERFVSGISPROC epoxy_glPointParameterfvSGIS;
    PFNGLPOINTPARAMETERIPROC epoxy_glPointParameteri;
    PFNGLPOINTPARAMETERINVPROC epoxy_glPointParameteriNV;
    PFNGLPOINTPARAMETERIVPROC epoxy_glPointParameteriv;
    PFNGLPOINTPARAMETERIVNVPROC epoxy_glPointParameterivNV;
    PFNGLPOINTPARAMETERXPROC epoxy_glPointParameterx;
    PFNGLPOINTPARAMETERXOESPROC epoxy_glPointParameterxOES;
    PFNGLPOINTPARAMETERXVPROC epoxy_glPointParameterxv;
    PFNGLPOINTPARAMETERXVOESPROC epoxy_glPointParameterxvOES;
    PFNGLPOINTSIZEPROC epoxy_glPointSize;
    PFNGLPOINTSIZEPOINTEROESPROC epoxy_glPointSizePointerOES;
    PFNGLPOINTSIZEXPROC epoxy_glPointSizex;
    PFNGLPOINTSIZEXOESPROC epoxy_glPointSizexOES;
    PFNGLPOLLASYNCSGIXPROC epoxy_glPollAsyncSGIX;
    PFNGLPOLLINSTRUMENTSSGIXPROC epoxy_glPollInstrumentsSGIX;
    PFNGLPOLYGONMODEPROC epoxy_glPolygonMode;
    PFNGLPOLYGONMODENVPROC epoxy_glPolygonModeNV;
    PFNGLPOLYGONOFFSETPROC epoxy_glPolygonOffset;
    PFNGLPOLYGONOFFSETCLAMPPROC epoxy_glPolygonOffsetClamp;
    PFNGLPOLYGONOFFSETCLAMPEXTPROC epoxy_glPolygonOffsetClampEXT;
    PFNGLPOLYGONOFFSETEXTPROC epoxy_glPolygonOffsetEXT;
    PFNGLPOLYGONOFFSETXPROC epoxy_glPolygonOffsetx;
    PFNGLPOLYGONOFFSETXOESPROC epoxy_glPolygonOffsetxOES;
    PFNGLPOLYGONSTIPPLEPROC epoxy_glPolygonStipple;
    PFNGLPOPATTRIBPROC epoxy_glPopAttrib;
    PFNGLPOPCLIENTATTRIBPROC epoxy_glPopClientAttrib;
    PFNGLPOPDEBUGGROUPPROC epoxy_glPopDebugGroup;
    PFNGLPOPDEBUGGROUPKHRPROC epoxy_glPopDebugGroupKHR;
    PFNGLPOPGROUPMARKEREXTPROC epoxy_glPopGroupMarkerEXT;
    PFNGLPOPMATRIXPROC epoxy_glPopMatrix;
    PFNGLPOPNAMEPROC epoxy_glPopName;
    PFNGLPRESENTFRAMEDUALFILLNVPROC epoxy_glPresentFrameDualFillNV;
    PFNGLPRESENTFRAMEKEYEDNVPROC epoxy_glPresentFrameKeyedNV;
    PFNGLPRIMITIVEBOUNDINGBOXPROC epoxy_glPrimitiveBoundingBox;
    PFNGLPRIMITIVEBOUNDINGBOXARBPROC epoxy_glPrimitiveBoundingBoxARB;
    PFNGLPRIMITIVEBOUNDINGBOXEXTPROC epoxy_glPrimitiveBoundingBoxEXT;
    PFNGLPRIMITIVEBOUNDINGBOXOESPROC epoxy_glPrimitiveBoundingBoxOES;
    PFNGLPRIMITIVERESTARTINDEXPROC epoxy_glPrimitiveRestartIndex;
    PFNGLPRIMITIVERESTARTINDEXNVPROC epoxy_glPrimitiveRestartIndexNV;
    PFNGLPRIMITIVERESTARTNVPROC epoxy_glPrimitiveRestartNV;
    PFNGLPRIORITIZETEXTURESPROC epoxy_glPrioritizeTextures;
    PFNGLPRIORITIZETEXTURESEXTPROC epoxy_glPrioritizeTexturesEXT;
    PFNGLPRIORITIZETEXTURESXOESPROC epoxy_glPrioritizeTexturesxOES;
    PFNGLPROGRAMBINARYPROC epoxy_glProgramBinary;
    PFNGLPROGRAMBINARYOESPROC epoxy_glProgramBinaryOES;
    PFNGLPROGRAMBUFFERPARAMETERSIIVNVPROC epoxy_glProgramBufferParametersIivNV;
    PFNGLPROGRAMBUFFERPARAMETERSIUIVNVPROC epoxy_glProgramBufferParametersIuivNV;
    PFNGLPROGRAMBUFFERPARAMETERSFVNVPROC epoxy_glProgramBufferParametersfvNV;
    PFNGLPROGRAMENVPARAMETER4DARBPROC epoxy_glProgramEnvParameter4dARB;
    PFNGLPROGRAMENVPARAMETER4DVARBPROC epoxy_glProgramEnvParameter4dvARB;
    PFNGLPROGRAMENVPARAMETER4FARBPROC epoxy_glProgramEnvParameter4fARB;
    PFNGLPROGRAMENVPARAMETER4FVARBPROC epoxy_glProgramEnvParameter4fvARB;
    PFNGLPROGRAMENVPARAMETERI4INVPROC epoxy_glProgramEnvParameterI4iNV;
    PFNGLPROGRAMENVPARAMETERI4IVNVPROC epoxy_glProgramEnvParameterI4ivNV;
    PFNGLPROGRAMENVPARAMETERI4UINVPROC epoxy_glProgramEnvParameterI4uiNV;
    PFNGLPROGRAMENVPARAMETERI4UIVNVPROC epoxy_glProgramEnvParameterI4uivNV;
    PFNGLPROGRAMENVPARAMETERS4FVEXTPROC epoxy_glProgramEnvParameters4fvEXT;
    PFNGLPROGRAMENVPARAMETERSI4IVNVPROC epoxy_glProgramEnvParametersI4ivNV;
    PFNGLPROGRAMENVPARAMETERSI4UIVNVPROC epoxy_glProgramEnvParametersI4uivNV;
    PFNGLPROGRAMLOCALPARAMETER4DARBPROC epoxy_glProgramLocalParameter4dARB;
    PFNGLPROGRAMLOCALPARAMETER4DVARBPROC epoxy_glProgramLocalParameter4dvARB;
    PFNGLPROGRAMLOCALPARAMETER4FARBPROC epoxy_glProgramLocalParameter4fARB;
    PFNGLPROGRAMLOCALPARAMETER4FVARBPROC epoxy_glProgramLocalParameter4fvARB;
    PFNGLPROGRAMLOCALPARAMETERI4INVPROC epoxy_glProgramLocalParameterI4iNV;
    PFNGLPROGRAMLOCALPARAMETERI4IVNVPROC epoxy_glProgramLocalParameterI4ivNV;
    PFNGLPROGRAMLOCALPARAMETERI4UINVPROC epoxy_glProgramLocalParameterI4uiNV;
    PFNGLPROGRAMLOCALPARAMETERI4UIVNVPROC epoxy_glProgramLocalParameterI4uivNV;
    PFNGLPROGRAMLOCALPARAMETERS4FVEXTPROC epoxy_glProgramLocalParameters4fvEXT;
    PFNGLPROGRAMLOCALPARAMETERSI4IVNVPROC epoxy_glProgramLocalParametersI4ivNV;
    PFNGLPROGRAMLOCALPARAMETERSI4UIVNVPROC epoxy_glProgramLocalParametersI4uivNV;
    PFNGLPROGRAMNAMEDPARAMETER4DNVPROC epoxy_glProgramNamedParameter4dNV;
    PFNGLPROGRAMNAMEDPARAMETER4DVNVPROC epoxy_glProgramNamedParameter4dvNV;
    PFNGLPROGRAMNAMEDPARAMETER4FNVPROC epoxy_glProgramNamedParameter4fNV;
    PFNGLPROGRAMNAMEDPARAMETER4FVNVPROC epoxy_glProgramNamedParameter4fvNV;
    PFNGLPROGRAMPARAMETER4DNVPROC epoxy_glProgramParameter4dNV;
    PFNGLPROGRAMPARAMETER4DVNVPROC epoxy_glProgramParameter4dvNV;
    PFNGLPROGRAMPARAMETER4FNVPROC epoxy_glProgramParameter4fNV;
    PFNGLPROGRAMPARAMETER4FVNVPROC epoxy_glProgramParameter4fvNV;
    PFNGLPROGRAMPARAMETERIPROC epoxy_glProgramParameteri;
    PFNGLPROGRAMPARAMETERIARBPROC epoxy_glProgramParameteriARB;
    PFNGLPROGRAMPARAMETERIEXTPROC epoxy_glProgramParameteriEXT;
    PFNGLPROGRAMPARAMETERS4DVNVPROC epoxy_glProgramParameters4dvNV;
    PFNGLPROGRAMPARAMETERS4FVNVPROC epoxy_glProgramParameters4fvNV;
    PFNGLPROGRAMPATHFRAGMENTINPUTGENNVPROC epoxy_glProgramPathFragmentInputGenNV;
    PFNGLPROGRAMSTRINGARBPROC epoxy_glProgramStringARB;
    PFNGLPROGRAMSUBROUTINEPARAMETERSUIVNVPROC epoxy_glProgramSubroutineParametersuivNV;
    PFNGLPROGRAMUNIFORM1DPROC epoxy_glProgramUniform1d;
    PFNGLPROGRAMUNIFORM1DEXTPROC epoxy_glProgramUniform1dEXT;
    PFNGLPROGRAMUNIFORM1DVPROC epoxy_glProgramUniform1dv;
    PFNGLPROGRAMUNIFORM1DVEXTPROC epoxy_glProgramUniform1dvEXT;
    PFNGLPROGRAMUNIFORM1FPROC epoxy_glProgramUniform1f;
    PFNGLPROGRAMUNIFORM1FEXTPROC epoxy_glProgramUniform1fEXT;
    PFNGLPROGRAMUNIFORM1FVPROC epoxy_glProgramUniform1fv;
    PFNGLPROGRAMUNIFORM1FVEXTPROC epoxy_glProgramUniform1fvEXT;
    PFNGLPROGRAMUNIFORM1IPROC epoxy_glProgramUniform1i;
    PFNGLPROGRAMUNIFORM1I64ARBPROC epoxy_glProgramUniform1i64ARB;
    PFNGLPROGRAMUNIFORM1I64NVPROC epoxy_glProgramUniform1i64NV;
    PFNGLPROGRAMUNIFORM1I64VARBPROC epoxy_glProgramUniform1i64vARB;
    PFNGLPROGRAMUNIFORM1I64VNVPROC epoxy_glProgramUniform1i64vNV;
    PFNGLPROGRAMUNIFORM1IEXTPROC epoxy_glProgramUniform1iEXT;
    PFNGLPROGRAMUNIFORM1IVPROC epoxy_glProgramUniform1iv;
    PFNGLPROGRAMUNIFORM1IVEXTPROC epoxy_glProgramUniform1ivEXT;
    PFNGLPROGRAMUNIFORM1UIPROC epoxy_glProgramUniform1ui;
    PFNGLPROGRAMUNIFORM1UI64ARBPROC epoxy_glProgramUniform1ui64ARB;
    PFNGLPROGRAMUNIFORM1UI64NVPROC epoxy_glProgramUniform1ui64NV;
    PFNGLPROGRAMUNIFORM1UI64VARBPROC epoxy_glProgramUniform1ui64vARB;
    PFNGLPROGRAMUNIFORM1UI64VNVPROC epoxy_glProgramUniform1ui64vNV;
    PFNGLPROGRAMUNIFORM1UIEXTPROC epoxy_glProgramUniform1uiEXT;
    PFNGLPROGRAMUNIFORM1UIVPROC epoxy_glProgramUniform1uiv;
    PFNGLPROGRAMUNIFORM1UIVEXTPROC epoxy_glProgramUniform1uivEXT;
    PFNGLPROGRAMUNIFORM2DPROC epoxy_glProgramUniform2d;
    PFNGLPROGRAMUNIFORM2DEXTPROC epoxy_glProgramUniform2dEXT;
    PFNGLPROGRAMUNIFORM2DVPROC epoxy_glProgramUniform2dv;
    PFNGLPROGRAMUNIFORM2DVEXTPROC epoxy_glProgramUniform2dvEXT;
    PFNGLPROGRAMUNIFORM2FPROC epoxy_glProgramUniform2f;
    PFNGLPROGRAMUNIFORM2FEXTPROC epoxy_glProgramUniform2fEXT;
    PFNGLPROGRAMUNIFORM2FVPROC epoxy_glProgramUniform2fv;
    PFNGLPROGRAMUNIFORM2FVEXTPROC epoxy_glProgramUniform2fvEXT;
    PFNGLPROGRAMUNIFORM2IPROC epoxy_glProgramUniform2i;
    PFNGLPROGRAMUNIFORM2I64ARBPROC epoxy_glProgramUniform2i64ARB;
    PFNGLPROGRAMUNIFORM2I64NVPROC epoxy_glProgramUniform2i64NV;
    PFNGLPROGRAMUNIFORM2I64VARBPROC epoxy_glProgramUniform2i64vARB;
    PFNGLPROGRAMUNIFORM2I64VNVPROC epoxy_glProgramUniform2i64vNV;
    PFNGLPROGRAMUNIFORM2IEXTPROC epoxy_glProgramUniform2iEXT;
    PFNGLPROGRAMUNIFORM2IVPROC epoxy_glProgramUniform2iv;
    PFNGLPROGRAMUNIFORM2IVEXTPROC epoxy_glProgramUniform2ivEXT;
    PFNGLPROGRAMUNIFORM2UIPROC epoxy_glProgramUniform2ui;
    PFNGLPROGRAMUNIFORM2UI64ARBPROC epoxy_glProgramUniform2ui64ARB;
    PFNGLPROGRAMUNIFORM2UI64NVPROC epoxy_glProgramUniform2ui64NV;
    PFNGLPROGRAMUNIFORM2UI64VARBPROC epoxy_glProgramUniform2ui64vARB;
    PFNGLPROGRAMUNIFORM2UI64VNVPROC epoxy_glProgramUniform2ui64vNV;
    PFNGLPROGRAMUNIFORM2UIEXTPROC epoxy_glProgramUniform2uiEXT;
    PFNGLPROGRAMUNIFORM2UIVPROC epoxy_glProgramUniform2uiv;
    PFNGLPROGRAMUNIFORM2UIVEXTPROC epoxy_glProgramUniform2uivEXT;
    PFNGLPROGRAMUNIFORM3DPROC epoxy_glProgramUniform3d;
    PFNGLPROGRAMUNIFORM3DEXTPROC epoxy_glProgramUniform3dEXT;
    PFNGLPROGRAMUNIFORM3DVPROC epoxy_glProgramUniform3dv;
    PFNGLPROGRAMUNIFORM3DVEXTPROC epoxy_glProgramUniform3dvEXT;
    PFNGLPROGRAMUNIFORM3FPROC epoxy_glProgramUniform3f;
    PFNGLPROGRAMUNIFORM3FEXTPROC epoxy_glProgramUniform3fEXT;
    PFNGLPROGRAMUNIFORM3FVPROC epoxy_glProgramUniform3fv;
    PFNGLPROGRAMUNIFORM3FVEXTPROC epoxy_glProgramUniform3fvEXT;
    PFNGLPROGRAMUNIFORM3IPROC epoxy_glProgramUniform3i;
    PFNGLPROGRAMUNIFORM3I64ARBPROC epoxy_glProgramUniform3i64ARB;
    PFNGLPROGRAMUNIFORM3I64NVPROC epoxy_glProgramUniform3i64NV;
    PFNGLPROGRAMUNIFORM3I64VARBPROC epoxy_glProgramUniform3i64vARB;
    PFNGLPROGRAMUNIFORM3I64VNVPROC epoxy_glProgramUniform3i64vNV;
    PFNGLPROGRAMUNIFORM3IEXTPROC epoxy_glProgramUniform3iEXT;
    PFNGLPROGRAMUNIFORM3IVPROC epoxy_glProgramUniform3iv;
    PFNGLPROGRAMUNIFORM3IVEXTPROC epoxy_glProgramUniform3ivEXT;
    PFNGLPROGRAMUNIFORM3UIPROC epoxy_glProgramUniform3ui;
    PFNGLPROGRAMUNIFORM3UI64ARBPROC epoxy_glProgramUniform3ui64ARB;
    PFNGLPROGRAMUNIFORM3UI64NVPROC epoxy_glProgramUniform3ui64NV;
    PFNGLPROGRAMUNIFORM3UI64VARBPROC epoxy_glProgramUniform3ui64vARB;
    PFNGLPROGRAMUNIFORM3UI64VNVPROC epoxy_glProgramUniform3ui64vNV;
    PFNGLPROGRAMUNIFORM3UIEXTPROC epoxy_glProgramUniform3uiEXT;
    PFNGLPROGRAMUNIFORM3UIVPROC epoxy_glProgramUniform3uiv;
    PFNGLPROGRAMUNIFORM3UIVEXTPROC epoxy_glProgramUniform3uivEXT;
    PFNGLPROGRAMUNIFORM4DPROC epoxy_glProgramUniform4d;
    PFNGLPROGRAMUNIFORM4DEXTPROC epoxy_glProgramUniform4dEXT;
    PFNGLPROGRAMUNIFORM4DVPROC epoxy_glProgramUniform4dv;
    PFNGLPROGRAMUNIFORM4DVEXTPROC epoxy_glProgramUniform4dvEXT;
    PFNGLPROGRAMUNIFORM4FPROC epoxy_glProgramUniform4f;
    PFNGLPROGRAMUNIFORM4FEXTPROC epoxy_glProgramUniform4fEXT;
    PFNGLPROGRAMUNIFORM4FVPROC epoxy_glProgramUniform4fv;
    PFNGLPROGRAMUNIFORM4FVEXTPROC epoxy_glProgramUniform4fvEXT;
    PFNGLPROGRAMUNIFORM4IPROC epoxy_glProgramUniform4i;
    PFNGLPROGRAMUNIFORM4I64ARBPROC epoxy_glProgramUniform4i64ARB;
    PFNGLPROGRAMUNIFORM4I64NVPROC epoxy_glProgramUniform4i64NV;
    PFNGLPROGRAMUNIFORM4I64VARBPROC epoxy_glProgramUniform4i64vARB;
    PFNGLPROGRAMUNIFORM4I64VNVPROC epoxy_glProgramUniform4i64vNV;
    PFNGLPROGRAMUNIFORM4IEXTPROC epoxy_glProgramUniform4iEXT;
    PFNGLPROGRAMUNIFORM4IVPROC epoxy_glProgramUniform4iv;
    PFNGLPROGRAMUNIFORM4IVEXTPROC epoxy_glProgramUniform4ivEXT;
    PFNGLPROGRAMUNIFORM4UIPROC epoxy_glProgramUniform4ui;
    PFNGLPROGRAMUNIFORM4UI64ARBPROC epoxy_glProgramUniform4ui64ARB;
    PFNGLPROGRAMUNIFORM4UI64NVPROC epoxy_glProgramUniform4ui64NV;
    PFNGLPROGRAMUNIFORM4UI64VARBPROC epoxy_glProgramUniform4ui64vARB;
    PFNGLPROGRAMUNIFORM4UI64VNVPROC epoxy_glProgramUniform4ui64vNV;
    PFNGLPROGRAMUNIFORM4UIEXTPROC epoxy_glProgramUniform4uiEXT;
    PFNGLPROGRAMUNIFORM4UIVPROC epoxy_glProgramUniform4uiv;
    PFNGLPROGRAMUNIFORM4UIVEXTPROC epoxy_glProgramUniform4uivEXT;
    PFNGLPROGRAMUNIFORMHANDLEUI64ARBPROC epoxy_glProgramUniformHandleui64ARB;
    PFNGLPROGRAMUNIFORMHANDLEUI64IMGPROC epoxy_glProgramUniformHandleui64IMG;
    PFNGLPROGRAMUNIFORMHANDLEUI64NVPROC epoxy_glProgramUniformHandleui64NV;
    PFNGLPROGRAMUNIFORMHANDLEUI64VARBPROC epoxy_glProgramUniformHandleui64vARB;
    PFNGLPROGRAMUNIFORMHANDLEUI64VIMGPROC epoxy_glProgramUniformHandleui64vIMG;
    PFNGLPROGRAMUNIFORMHANDLEUI64VNVPROC epoxy_glProgramUniformHandleui64vNV;
    PFNGLPROGRAMUNIFORMMATRIX2DVPROC epoxy_glProgramUniformMatrix2dv;
    PFNGLPROGRAMUNIFORMMATRIX2DVEXTPROC epoxy_glProgramUniformMatrix2dvEXT;
    PFNGLPROGRAMUNIFORMMATRIX2FVPROC epoxy_glProgramUniformMatrix2fv;
    PFNGLPROGRAMUNIFORMMATRIX2FVEXTPROC epoxy_glProgramUniformMatrix2fvEXT;
    PFNGLPROGRAMUNIFORMMATRIX2X3DVPROC epoxy_glProgramUniformMatrix2x3dv;
    PFNGLPROGRAMUNIFORMMATRIX2X3DVEXTPROC epoxy_glProgramUniformMatrix2x3dvEXT;
    PFNGLPROGRAMUNIFORMMATRIX2X3FVPROC epoxy_glProgramUniformMatrix2x3fv;
    PFNGLPROGRAMUNIFORMMATRIX2X3FVEXTPROC epoxy_glProgramUniformMatrix2x3fvEXT;
    PFNGLPROGRAMUNIFORMMATRIX2X4DVPROC epoxy_glProgramUniformMatrix2x4dv;
    PFNGLPROGRAMUNIFORMMATRIX2X4DVEXTPROC epoxy_glProgramUniformMatrix2x4dvEXT;
    PFNGLPROGRAMUNIFORMMATRIX2X4FVPROC epoxy_glProgramUniformMatrix2x4fv;
    PFNGLPROGRAMUNIFORMMATRIX2X4FVEXTPROC epoxy_glProgramUniformMatrix2x4fvEXT;
    PFNGLPROGRAMUNIFORMMATRIX3DVPROC epoxy_glProgramUniformMatrix3dv;
    PFNGLPROGRAMUNIFORMMATRIX3DVEXTPROC epoxy_glProgramUniformMatrix3dvEXT;
    PFNGLPROGRAMUNIFORMMATRIX3FVPROC epoxy_glProgramUniformMatrix3fv;
    PFNGLPROGRAMUNIFORMMATRIX3FVEXTPROC epoxy_glProgramUniformMatrix3fvEXT;
    PFNGLPROGRAMUNIFORMMATRIX3X2DVPROC epoxy_glProgramUniformMatrix3x2dv;
    PFNGLPROGRAMUNIFORMMATRIX3X2DVEXTPROC epoxy_glProgramUniformMatrix3x2dvEXT;
    PFNGLPROGRAMUNIFORMMATRIX3X2FVPROC epoxy_glProgramUniformMatrix3x2fv;
    PFNGLPROGRAMUNIFORMMATRIX3X2FVEXTPROC epoxy_glProgramUniformMatrix3x2fvEXT;
    PFNGLPROGRAMUNIFORMMATRIX3X4DVPROC epoxy_glProgramUniformMatrix3x4dv;
    PFNGLPROGRAMUNIFORMMATRIX3X4DVEXTPROC epoxy_glProgramUniformMatrix3x4dvEXT;
    PFNGLPROGRAMUNIFORMMATRIX3X4FVPROC epoxy_glProgramUniformMatrix3x4fv;
    PFNGLPROGRAMUNIFORMMATRIX3X4FVEXTPROC epoxy_glProgramUniformMatrix3x4fvEXT;
    PFNGLPROGRAMUNIFORMMATRIX4DVPROC epoxy_glProgramUniformMatrix4dv;
    PFNGLPROGRAMUNIFORMMATRIX4DVEXTPROC epoxy_glProgramUniformMatrix4dvEXT;
    PFNGLPROGRAMUNIFORMMATRIX4FVPROC epoxy_glProgramUniformMatrix4fv;
    PFNGLPROGRAMUNIFORMMATRIX4FVEXTPROC epoxy_glProgramUniformMatrix4fvEXT;
    PFNGLPROGRAMUNIFORMMATRIX4X2DVPROC epoxy_glProgramUniformMatrix4x2dv;
    PFNGLPROGRAMUNIFORMMATRIX4X2DVEXTPROC epoxy_glProgramUniformMatrix4x2dvEXT;
    PFNGLPROGRAMUNIFORMMATRIX4X2FVPROC epoxy_glProgramUniformMatrix4x2fv;
    PFNGLPROGRAMUNIFORMMATRIX4X2FVEXTPROC epoxy_glProgramUniformMatrix4x2fvEXT;
    PFNGLPROGRAMUNIFORMMATRIX4X3DVPROC epoxy_glProgramUniformMatrix4x3dv;
    PFNGLPROGRAMUNIFORMMATRIX4X3DVEXTPROC epoxy_glProgramUniformMatrix4x3dvEXT;
    PFNGLPROGRAMUNIFORMMATRIX4X3FVPROC epoxy_glProgramUniformMatrix4x3fv;
    PFNGLPROGRAMUNIFORMMATRIX4X3FVEXTPROC epoxy_glProgramUniformMatrix4x3fvEXT;
    PFNGLPROGRAMUNIFORMUI64NVPROC epoxy_glProgramUniformui64NV;
    PFNGLPROGRAMUNIFORMUI64VNVPROC epoxy_glProgramUniformui64vNV;
    PFNGLPROGRAMVERTEXLIMITNVPROC epoxy_glProgramVertexLimitNV;
    PFNGLPROVOKINGVERTEXPROC epoxy_glProvokingVertex;
    PFNGLPROVOKINGVERTEXEXTPROC epoxy_glProvokingVertexEXT;
    PFNGLPUSHATTRIBPROC epoxy_glPushAttrib;
    PFNGLPUSHCLIENTATTRIBPROC epoxy_glPushClientAttrib;
    PFNGLPUSHCLIENTATTRIBDEFAULTEXTPROC epoxy_glPushClientAttribDefaultEXT;
    PFNGLPUSHDEBUGGROUPPROC epoxy_glPushDebugGroup;
    PFNGLPUSHDEBUGGROUPKHRPROC epoxy_glPushDebugGroupKHR;
    PFNGLPUSHGROUPMARKEREXTPROC epoxy_glPushGroupMarkerEXT;
    PFNGLPUSHMATRIXPROC epoxy_glPushMatrix;
    PFNGLPUSHNAMEPROC epoxy_glPushName;
    PFNGLQUERYCOUNTERPROC epoxy_glQueryCounter;
    PFNGLQUERYCOUNTEREXTPROC epoxy_glQueryCounterEXT;
    PFNGLQUERYMATRIXXOESPROC epoxy_glQueryMatrixxOES;
    PFNGLQUERYOBJECTPARAMETERUIAMDPROC epoxy_glQueryObjectParameteruiAMD;
    PFNGLQUERYRESOURCENVPROC epoxy_glQueryResourceNV;
    PFNGLQUERYRESOURCETAGNVPROC epoxy_glQueryResourceTagNV;
    PFNGLRASTERPOS2DPROC epoxy_glRasterPos2d;
    PFNGLRASTERPOS2DVPROC epoxy_glRasterPos2dv;
    PFNGLRASTERPOS2FPROC epoxy_glRasterPos2f;
    PFNGLRASTERPOS2FVPROC epoxy_glRasterPos2fv;
    PFNGLRASTERPOS2IPROC epoxy_glRasterPos2i;
    PFNGLRASTERPOS2IVPROC epoxy_glRasterPos2iv;
    PFNGLRASTERPOS2SPROC epoxy_glRasterPos2s;
    PFNGLRASTERPOS2SVPROC epoxy_glRasterPos2sv;
    PFNGLRASTERPOS2XOESPROC epoxy_glRasterPos2xOES;
    PFNGLRASTERPOS2XVOESPROC epoxy_glRasterPos2xvOES;
    PFNGLRASTERPOS3DPROC epoxy_glRasterPos3d;
    PFNGLRASTERPOS3DVPROC epoxy_glRasterPos3dv;
    PFNGLRASTERPOS3FPROC epoxy_glRasterPos3f;
    PFNGLRASTERPOS3FVPROC epoxy_glRasterPos3fv;
    PFNGLRASTERPOS3IPROC epoxy_glRasterPos3i;
    PFNGLRASTERPOS3IVPROC epoxy_glRasterPos3iv;
    PFNGLRASTERPOS3SPROC epoxy_glRasterPos3s;
    PFNGLRASTERPOS3SVPROC epoxy_glRasterPos3sv;
    PFNGLRASTERPOS3XOESPROC epoxy_glRasterPos3xOES;
    PFNGLRASTERPOS3XVOESPROC epoxy_glRasterPos3xvOES;
    PFNGLRASTERPOS4DPROC epoxy_glRasterPos4d;
    PFNGLRASTERPOS4DVPROC epoxy_glRasterPos4dv;
    PFNGLRASTERPOS4FPROC epoxy_glRasterPos4f;
    PFNGLRASTERPOS4FVPROC epoxy_glRasterPos4fv;
    PFNGLRASTERPOS4IPROC epoxy_glRasterPos4i;
    PFNGLRASTERPOS4IVPROC epoxy_glRasterPos4iv;
    PFNGLRASTERPOS4SPROC epoxy_glRasterPos4s;
    PFNGLRASTERPOS4SVPROC epoxy_glRasterPos4sv;
    PFNGLRASTERPOS4XOESPROC epoxy_glRasterPos4xOES;
    PFNGLRASTERPOS4XVOESPROC epoxy_glRasterPos4xvOES;
    PFNGLRASTERSAMPLESEXTPROC epoxy_glRasterSamplesEXT;
    PFNGLREADBUFFERPROC epoxy_glReadBuffer;
    PFNGLREADBUFFERINDEXEDEXTPROC epoxy_glReadBufferIndexedEXT;
    PFNGLREADBUFFERNVPROC epoxy_glReadBufferNV;
    PFNGLREADINSTRUMENTSSGIXPROC epoxy_glReadInstrumentsSGIX;
    PFNGLREADPIXELSPROC epoxy_glReadPixels;
    PFNGLREADNPIXELSPROC epoxy_glReadnPixels;
    PFNGLREADNPIXELSARBPROC epoxy_glReadnPixelsARB;
    PFNGLREADNPIXELSEXTPROC epoxy_glReadnPixelsEXT;
    PFNGLREADNPIXELSKHRPROC epoxy_glReadnPixelsKHR;
    PFNGLRECTDPROC epoxy_glRectd;
    PFNGLRECTDVPROC epoxy_glRectdv;
    PFNGLRECTFPROC epoxy_glRectf;
    PFNGLRECTFVPROC epoxy_glRectfv;
    PFNGLRECTIPROC epoxy_glRecti;
    PFNGLRECTIVPROC epoxy_glRectiv;
    PFNGLRECTSPROC epoxy_glRects;
    PFNGLRECTSVPROC epoxy_glRectsv;
    PFNGLRECTXOESPROC epoxy_glRectxOES;
    PFNGLRECTXVOESPROC epoxy_glRectxvOES;
    PFNGLREFERENCEPLANESGIXPROC epoxy_glReferencePlaneSGIX;
    PFNGLRELEASEKEYEDMUTEXWIN32EXTPROC epoxy_glReleaseKeyedMutexWin32EXT;
    PFNGLRELEASESHADERCOMPILERPROC epoxy_glReleaseShaderCompiler;
    PFNGLRENDERGPUMASKNVPROC epoxy_glRenderGpuMaskNV;
    PFNGLRENDERMODEPROC epoxy_glRenderMode;
    PFNGLRENDERBUFFERSTORAGEPROC epoxy_glRenderbufferStorage;
    PFNGLRENDERBUFFERSTORAGEEXTPROC epoxy_glRenderbufferStorageEXT;
    PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC epoxy_glRenderbufferStorageMultisample;
    PFNGLRENDERBUFFERSTORAGEMULTISAMPLEANGLEPROC epoxy_glRenderbufferStorageMultisampleANGLE;
    PFNGLRENDERBUFFERSTORAGEMULTISAMPLEAPPLEPROC epoxy_glRenderbufferStorageMultisampleAPPLE;
    PFNGLRENDERBUFFERSTORAGEMULTISAMPLECOVERAGENVPROC epoxy_glRenderbufferStorageMultisampleCoverageNV;
    PFNGLRENDERBUFFERSTORAGEMULTISAMPLEEXTPROC epoxy_glRenderbufferStorageMultisampleEXT;
    PFNGLRENDERBUFFERSTORAGEMULTISAMPLEIMGPROC epoxy_glRenderbufferStorageMultisampleIMG;
    PFNGLRENDERBUFFERSTORAGEMULTISAMPLENVPROC epoxy_glRenderbufferStorageMultisampleNV;
    PFNGLRENDERBUFFERSTORAGEOESPROC epoxy_glRenderbufferStorageOES;
    PFNGLREPLACEMENTCODEPOINTERSUNPROC epoxy_glReplacementCodePointerSUN;
    PFNGLREPLACEMENTCODEUBSUNPROC epoxy_glReplacementCodeubSUN;
    PFNGLREPLACEMENTCODEUBVSUNPROC epoxy_glReplacementCodeubvSUN;
    PFNGLREPLACEMENTCODEUICOLOR3FVERTEX3FSUNPROC epoxy_glReplacementCodeuiColor3fVertex3fSUN;
    PFNGLREPLACEMENTCODEUICOLOR3FVERTEX3FVSUNPROC epoxy_glReplacementCodeuiColor3fVertex3fvSUN;
    PFNGLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FSUNPROC epoxy_glReplacementCodeuiColor4fNormal3fVertex3fSUN;
    PFNGLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FVSUNPROC epoxy_glReplacementCodeuiColor4fNormal3fVertex3fvSUN;
    PFNGLREPLACEMENTCODEUICOLOR4UBVERTEX3FSUNPROC epoxy_glReplacementCodeuiColor4ubVertex3fSUN;
    PFNGLREPLACEMENTCODEUICOLOR4UBVERTEX3FVSUNPROC epoxy_glReplacementCodeuiColor4ubVertex3fvSUN;
    PFNGLREPLACEMENTCODEUINORMAL3FVERTEX3FSUNPROC epoxy_glReplacementCodeuiNormal3fVertex3fSUN;
    PFNGLREPLACEMENTCODEUINORMAL3FVERTEX3FVSUNPROC epoxy_glReplacementCodeuiNormal3fVertex3fvSUN;
    PFNGLREPLACEMENTCODEUISUNPROC epoxy_glReplacementCodeuiSUN;
    PFNGLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUNPROC epoxy_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN;
    PFNGLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUNPROC epoxy_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN;
    PFNGLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FSUNPROC epoxy_glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN;
    PFNGLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FVSUNPROC epoxy_glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN;
    PFNGLREPLACEMENTCODEUITEXCOORD2FVERTEX3FSUNPROC epoxy_glReplacementCodeuiTexCoord2fVertex3fSUN;
    PFNGLREPLACEMENTCODEUITEXCOORD2FVERTEX3FVSUNPROC epoxy_glReplacementCodeuiTexCoord2fVertex3fvSUN;
    PFNGLREPLACEMENTCODEUIVERTEX3FSUNPROC epoxy_glReplacementCodeuiVertex3fSUN;
    PFNGLREPLACEMENTCODEUIVERTEX3FVSUNPROC epoxy_glReplacementCodeuiVertex3fvSUN;
    PFNGLREPLACEMENTCODEUIVSUNPROC epoxy_glReplacementCodeuivSUN;
    PFNGLREPLACEMENTCODEUSSUNPROC epoxy_glReplacementCodeusSUN;
    PFNGLREPLACEMENTCODEUSVSUNPROC epoxy_glReplacementCodeusvSUN;
    PFNGLREQUESTRESIDENTPROGRAMSNVPROC epoxy_glRequestResidentProgramsNV;
    PFNGLRESETHISTOGRAMPROC epoxy_glResetHistogram;
    PFNGLRESETHISTOGRAMEXTPROC epoxy_glResetHistogramEXT;
    PFNGLRESETMINMAXPROC epoxy_glResetMinmax;
    PFNGLRESETMINMAXEXTPROC epoxy_glResetMinmaxEXT;
    PFNGLRESIZEBUFFERSMESAPROC epoxy_glResizeBuffersMESA;
    PFNGLRESOLVEDEPTHVALUESNVPROC epoxy_glResolveDepthValuesNV;
    PFNGLRESOLVEMULTISAMPLEFRAMEBUFFERAPPLEPROC epoxy_glResolveMultisampleFramebufferAPPLE;
    PFNGLRESUMETRANSFORMFEEDBACKPROC epoxy_glResumeTransformFeedback;
    PFNGLRESUMETRANSFORMFEEDBACKNVPROC epoxy_glResumeTransformFeedbackNV;
    PFNGLROTATEDPROC epoxy_glRotated;
    PFNGLROTATEFPROC epoxy_glRotatef;
    PFNGLROTATEXPROC epoxy_glRotatex;
    PFNGLROTATEXOESPROC epoxy_glRotatexOES;
    PFNGLSAMPLECOVERAGEPROC epoxy_glSampleCoverage;
    PFNGLSAMPLECOVERAGEARBPROC epoxy_glSampleCoverageARB;
    PFNGLSAMPLECOVERAGEXPROC epoxy_glSampleCoveragex;
    PFNGLSAMPLECOVERAGEXOESPROC epoxy_glSampleCoveragexOES;
    PFNGLSAMPLEMAPATIPROC epoxy_glSampleMapATI;
    PFNGLSAMPLEMASKEXTPROC epoxy_glSampleMaskEXT;
    PFNGLSAMPLEMASKINDEXEDNVPROC epoxy_glSampleMaskIndexedNV;
    PFNGLSAMPLEMASKSGISPROC epoxy_glSampleMaskSGIS;
    PFNGLSAMPLEMASKIPROC epoxy_glSampleMaski;
    PFNGLSAMPLEPATTERNEXTPROC epoxy_glSamplePatternEXT;
    PFNGLSAMPLEPATTERNSGISPROC epoxy_glSamplePatternSGIS;
    PFNGLSAMPLERPARAMETERIIVPROC epoxy_glSamplerParameterIiv;
    PFNGLSAMPLERPARAMETERIIVEXTPROC epoxy_glSamplerParameterIivEXT;
    PFNGLSAMPLERPARAMETERIIVOESPROC epoxy_glSamplerParameterIivOES;
    PFNGLSAMPLERPARAMETERIUIVPROC epoxy_glSamplerParameterIuiv;
    PFNGLSAMPLERPARAMETERIUIVEXTPROC epoxy_glSamplerParameterIuivEXT;
    PFNGLSAMPLERPARAMETERIUIVOESPROC epoxy_glSamplerParameterIuivOES;
    PFNGLSAMPLERPARAMETERFPROC epoxy_glSamplerParameterf;
    PFNGLSAMPLERPARAMETERFVPROC epoxy_glSamplerParameterfv;
    PFNGLSAMPLERPARAMETERIPROC epoxy_glSamplerParameteri;
    PFNGLSAMPLERPARAMETERIVPROC epoxy_glSamplerParameteriv;
    PFNGLSCALEDPROC epoxy_glScaled;
    PFNGLSCALEFPROC epoxy_glScalef;
    PFNGLSCALEXPROC epoxy_glScalex;
    PFNGLSCALEXOESPROC epoxy_glScalexOES;
    PFNGLSCISSORPROC epoxy_glScissor;
    PFNGLSCISSORARRAYVPROC epoxy_glScissorArrayv;
    PFNGLSCISSORARRAYVNVPROC epoxy_glScissorArrayvNV;
    PFNGLSCISSORARRAYVOESPROC epoxy_glScissorArrayvOES;
    PFNGLSCISSORINDEXEDPROC epoxy_glScissorIndexed;
    PFNGLSCISSORINDEXEDNVPROC epoxy_glScissorIndexedNV;
    PFNGLSCISSORINDEXEDOESPROC epoxy_glScissorIndexedOES;
    PFNGLSCISSORINDEXEDVPROC epoxy_glScissorIndexedv;
    PFNGLSCISSORINDEXEDVNVPROC epoxy_glScissorIndexedvNV;
    PFNGLSCISSORINDEXEDVOESPROC epoxy_glScissorIndexedvOES;
    PFNGLSECONDARYCOLOR3BPROC epoxy_glSecondaryColor3b;
    PFNGLSECONDARYCOLOR3BEXTPROC epoxy_glSecondaryColor3bEXT;
    PFNGLSECONDARYCOLOR3BVPROC epoxy_glSecondaryColor3bv;
    PFNGLSECONDARYCOLOR3BVEXTPROC epoxy_glSecondaryColor3bvEXT;
    PFNGLSECONDARYCOLOR3DPROC epoxy_glSecondaryColor3d;
    PFNGLSECONDARYCOLOR3DEXTPROC epoxy_glSecondaryColor3dEXT;
    PFNGLSECONDARYCOLOR3DVPROC epoxy_glSecondaryColor3dv;
    PFNGLSECONDARYCOLOR3DVEXTPROC epoxy_glSecondaryColor3dvEXT;
    PFNGLSECONDARYCOLOR3FPROC epoxy_glSecondaryColor3f;
    PFNGLSECONDARYCOLOR3FEXTPROC epoxy_glSecondaryColor3fEXT;
    PFNGLSECONDARYCOLOR3FVPROC epoxy_glSecondaryColor3fv;
    PFNGLSECONDARYCOLOR3FVEXTPROC epoxy_glSecondaryColor3fvEXT;
    PFNGLSECONDARYCOLOR3HNVPROC epoxy_glSecondaryColor3hNV;
    PFNGLSECONDARYCOLOR3HVNVPROC epoxy_glSecondaryColor3hvNV;
    PFNGLSECONDARYCOLOR3IPROC epoxy_glSecondaryColor3i;
    PFNGLSECONDARYCOLOR3IEXTPROC epoxy_glSecondaryColor3iEXT;
    PFNGLSECONDARYCOLOR3IVPROC epoxy_glSecondaryColor3iv;
    PFNGLSECONDARYCOLOR3IVEXTPROC epoxy_glSecondaryColor3ivEXT;
    PFNGLSECONDARYCOLOR3SPROC epoxy_glSecondaryColor3s;
    PFNGLSECONDARYCOLOR3SEXTPROC epoxy_glSecondaryColor3sEXT;
    PFNGLSECONDARYCOLOR3SVPROC epoxy_glSecondaryColor3sv;
    PFNGLSECONDARYCOLOR3SVEXTPROC epoxy_glSecondaryColor3svEXT;
    PFNGLSECONDARYCOLOR3UBPROC epoxy_glSecondaryColor3ub;
    PFNGLSECONDARYCOLOR3UBEXTPROC epoxy_glSecondaryColor3ubEXT;
    PFNGLSECONDARYCOLOR3UBVPROC epoxy_glSecondaryColor3ubv;
    PFNGLSECONDARYCOLOR3UBVEXTPROC epoxy_glSecondaryColor3ubvEXT;
    PFNGLSECONDARYCOLOR3UIPROC epoxy_glSecondaryColor3ui;
    PFNGLSECONDARYCOLOR3UIEXTPROC epoxy_glSecondaryColor3uiEXT;
    PFNGLSECONDARYCOLOR3UIVPROC epoxy_glSecondaryColor3uiv;
    PFNGLSECONDARYCOLOR3UIVEXTPROC epoxy_glSecondaryColor3uivEXT;
    PFNGLSECONDARYCOLOR3USPROC epoxy_glSecondaryColor3us;
    PFNGLSECONDARYCOLOR3USEXTPROC epoxy_glSecondaryColor3usEXT;
    PFNGLSECONDARYCOLOR3USVPROC epoxy_glSecondaryColor3usv;
    PFNGLSECONDARYCOLOR3USVEXTPROC epoxy_glSecondaryColor3usvEXT;
    PFNGLSECONDARYCOLORFORMATNVPROC epoxy_glSecondaryColorFormatNV;
    PFNGLSECONDARYCOLORP3UIPROC epoxy_glSecondaryColorP3ui;
    PFNGLSECONDARYCOLORP3UIVPROC epoxy_glSecondaryColorP3uiv;
    PFNGLSECONDARYCOLORPOINTERPROC epoxy_glSecondaryColorPointer;
    PFNGLSECONDARYCOLORPOINTEREXTPROC epoxy_glSecondaryColorPointerEXT;
    PFNGLSECONDARYCOLORPOINTERLISTIBMPROC epoxy_glSecondaryColorPointerListIBM;
    PFNGLSELECTBUFFERPROC epoxy_glSelectBuffer;
    PFNGLSELECTPERFMONITORCOUNTERSAMDPROC epoxy_glSelectPerfMonitorCountersAMD;
    PFNGLSEMAPHOREPARAMETERUI64VEXTPROC epoxy_glSemaphoreParameterui64vEXT;
    PFNGLSEPARABLEFILTER2DPROC epoxy_glSeparableFilter2D;
    PFNGLSEPARABLEFILTER2DEXTPROC epoxy_glSeparableFilter2DEXT;
    PFNGLSETFENCEAPPLEPROC epoxy_glSetFenceAPPLE;
    PFNGLSETFENCENVPROC epoxy_glSetFenceNV;
    PFNGLSETFRAGMENTSHADERCONSTANTATIPROC epoxy_glSetFragmentShaderConstantATI;
    PFNGLSETINVARIANTEXTPROC epoxy_glSetInvariantEXT;
    PFNGLSETLOCALCONSTANTEXTPROC epoxy_glSetLocalConstantEXT;
    PFNGLSETMULTISAMPLEFVAMDPROC epoxy_glSetMultisamplefvAMD;
    PFNGLSHADEMODELPROC epoxy_glShadeModel;
    PFNGLSHADERBINARYPROC epoxy_glShaderBinary;
    PFNGLSHADEROP1EXTPROC epoxy_glShaderOp1EXT;
    PFNGLSHADEROP2EXTPROC epoxy_glShaderOp2EXT;
    PFNGLSHADEROP3EXTPROC epoxy_glShaderOp3EXT;
    PFNGLSHADERSOURCEPROC epoxy_glShaderSource;
    PFNGLSHADERSOURCEARBPROC epoxy_glShaderSourceARB;
    PFNGLSHADERSTORAGEBLOCKBINDINGPROC epoxy_glShaderStorageBlockBinding;
    PFNGLSHARPENTEXFUNCSGISPROC epoxy_glSharpenTexFuncSGIS;
    PFNGLSIGNALSEMAPHOREEXTPROC epoxy_glSignalSemaphoreEXT;
    PFNGLSIGNALVKFENCENVPROC epoxy_glSignalVkFenceNV;
    PFNGLSIGNALVKSEMAPHORENVPROC epoxy_glSignalVkSemaphoreNV;
    PFNGLSPECIALIZESHADERPROC epoxy_glSpecializeShader;
    PFNGLSPECIALIZESHADERARBPROC epoxy_glSpecializeShaderARB;
    PFNGLSPRITEPARAMETERFSGIXPROC epoxy_glSpriteParameterfSGIX;
    PFNGLSPRITEPARAMETERFVSGIXPROC epoxy_glSpriteParameterfvSGIX;
    PFNGLSPRITEPARAMETERISGIXPROC epoxy_glSpriteParameteriSGIX;
    PFNGLSPRITEPARAMETERIVSGIXPROC epoxy_glSpriteParameterivSGIX;
    PFNGLSTARTINSTRUMENTSSGIXPROC epoxy_glStartInstrumentsSGIX;
    PFNGLSTARTTILINGQCOMPROC epoxy_glStartTilingQCOM;
    PFNGLSTATECAPTURENVPROC epoxy_glStateCaptureNV;
    PFNGLSTENCILCLEARTAGEXTPROC epoxy_glStencilClearTagEXT;
    PFNGLSTENCILFILLPATHINSTANCEDNVPROC epoxy_glStencilFillPathInstancedNV;
    PFNGLSTENCILFILLPATHNVPROC epoxy_glStencilFillPathNV;
    PFNGLSTENCILFUNCPROC epoxy_glStencilFunc;
    PFNGLSTENCILFUNCSEPARATEPROC epoxy_glStencilFuncSeparate;
    PFNGLSTENCILFUNCSEPARATEATIPROC epoxy_glStencilFuncSeparateATI;
    PFNGLSTENCILMASKPROC epoxy_glStencilMask;
    PFNGLSTENCILMASKSEPARATEPROC epoxy_glStencilMaskSeparate;
    PFNGLSTENCILOPPROC epoxy_glStencilOp;
    PFNGLSTENCILOPSEPARATEPROC epoxy_glStencilOpSeparate;
    PFNGLSTENCILOPSEPARATEATIPROC epoxy_glStencilOpSeparateATI;
    PFNGLSTENCILOPVALUEAMDPROC epoxy_glStencilOpValueAMD;
    PFNGLSTENCILSTROKEPATHINSTANCEDNVPROC epoxy_glStencilStrokePathInstancedNV;
    PFNGLSTENCILSTROKEPATHNVPROC epoxy_glStencilStrokePathNV;
    PFNGLSTENCILTHENCOVERFILLPATHINSTANCEDNVPROC epoxy_glStencilThenCoverFillPathInstancedNV;
    PFNGLSTENCILTHENCOVERFILLPATHNVPROC epoxy_glStencilThenCoverFillPathNV;
    PFNGLSTENCILTHENCOVERSTROKEPATHINSTANCEDNVPROC epoxy_glStencilThenCoverStrokePathInstancedNV;
    PFNGLSTENCILTHENCOVERSTROKEPATHNVPROC epoxy_glStencilThenCoverStrokePathNV;
    PFNGLSTOPINSTRUMENTSSGIXPROC epoxy_glStopInstrumentsSGIX;
    PFNGLSTRINGMARKERGREMEDYPROC epoxy_glStringMarkerGREMEDY;
    PFNGLSUBPIXELPRECISIONBIASNVPROC epoxy_glSubpixelPrecisionBiasNV;
    PFNGLSWIZZLEEXTPROC epoxy_glSwizzleEXT;
    PFNGLSYNCTEXTUREINTELPROC epoxy_glSyncTextureINTEL;
    PFNGLTAGSAMPLEBUFFERSGIXPROC epoxy_glTagSampleBufferSGIX;
    PFNGLTANGENT3BEXTPROC epoxy_glTangent3bEXT;
    PFNGLTANGENT3BVEXTPROC epoxy_glTangent3bvEXT;
    PFNGLTANGENT3DEXTPROC epoxy_glTangent3dEXT;
    PFNGLTANGENT3DVEXTPROC epoxy_glTangent3dvEXT;
    PFNGLTANGENT3FEXTPROC epoxy_glTangent3fEXT;
    PFNGLTANGENT3FVEXTPROC epoxy_glTangent3fvEXT;
    PFNGLTANGENT3IEXTPROC epoxy_glTangent3iEXT;
    PFNGLTANGENT3IVEXTPROC epoxy_glTangent3ivEXT;
    PFNGLTANGENT3SEXTPROC epoxy_glTangent3sEXT;
    PFNGLTANGENT3SVEXTPROC epoxy_glTangent3svEXT;
    PFNGLTANGENTPOINTEREXTPROC epoxy_glTangentPointerEXT;
    PFNGLTBUFFERMASK3DFXPROC epoxy_glTbufferMask3DFX;
    PFNGLTESSELLATIONFACTORAMDPROC epoxy_glTessellationFactorAMD;
    PFNGLTESSELLATIONMODEAMDPROC epoxy_glTessellationModeAMD;
    PFNGLTESTFENCEAPPLEPROC epoxy_glTestFenceAPPLE;
    PFNGLTESTFENCENVPROC epoxy_glTestFenceNV;
    PFNGLTESTOBJECTAPPLEPROC epoxy_glTestObjectAPPLE;
    PFNGLTEXBUFFERPROC epoxy_glTexBuffer;
    PFNGLTEXBUFFERARBPROC epoxy_glTexBufferARB;
    PFNGLTEXBUFFEREXTPROC epoxy_glTexBufferEXT;
    PFNGLTEXBUFFEROESPROC epoxy_glTexBufferOES;
    PFNGLTEXBUFFERRANGEPROC epoxy_glTexBufferRange;
    PFNGLTEXBUFFERRANGEEXTPROC epoxy_glTexBufferRangeEXT;
    PFNGLTEXBUFFERRANGEOESPROC epoxy_glTexBufferRangeOES;
    PFNGLTEXBUMPPARAMETERFVATIPROC epoxy_glTexBumpParameterfvATI;
    PFNGLTEXBUMPPARAMETERIVATIPROC epoxy_glTexBumpParameterivATI;
    PFNGLTEXCOORD1BOESPROC epoxy_glTexCoord1bOES;
    PFNGLTEXCOORD1BVOESPROC epoxy_glTexCoord1bvOES;
    PFNGLTEXCOORD1DPROC epoxy_glTexCoord1d;
    PFNGLTEXCOORD1DVPROC epoxy_glTexCoord1dv;
    PFNGLTEXCOORD1FPROC epoxy_glTexCoord1f;
    PFNGLTEXCOORD1FVPROC epoxy_glTexCoord1fv;
    PFNGLTEXCOORD1HNVPROC epoxy_glTexCoord1hNV;
    PFNGLTEXCOORD1HVNVPROC epoxy_glTexCoord1hvNV;
    PFNGLTEXCOORD1IPROC epoxy_glTexCoord1i;
    PFNGLTEXCOORD1IVPROC epoxy_glTexCoord1iv;
    PFNGLTEXCOORD1SPROC epoxy_glTexCoord1s;
    PFNGLTEXCOORD1SVPROC epoxy_glTexCoord1sv;
    PFNGLTEXCOORD1XOESPROC epoxy_glTexCoord1xOES;
    PFNGLTEXCOORD1XVOESPROC epoxy_glTexCoord1xvOES;
    PFNGLTEXCOORD2BOESPROC epoxy_glTexCoord2bOES;
    PFNGLTEXCOORD2BVOESPROC epoxy_glTexCoord2bvOES;
    PFNGLTEXCOORD2DPROC epoxy_glTexCoord2d;
    PFNGLTEXCOORD2DVPROC epoxy_glTexCoord2dv;
    PFNGLTEXCOORD2FPROC epoxy_glTexCoord2f;
    PFNGLTEXCOORD2FCOLOR3FVERTEX3FSUNPROC epoxy_glTexCoord2fColor3fVertex3fSUN;
    PFNGLTEXCOORD2FCOLOR3FVERTEX3FVSUNPROC epoxy_glTexCoord2fColor3fVertex3fvSUN;
    PFNGLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUNPROC epoxy_glTexCoord2fColor4fNormal3fVertex3fSUN;
    PFNGLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUNPROC epoxy_glTexCoord2fColor4fNormal3fVertex3fvSUN;
    PFNGLTEXCOORD2FCOLOR4UBVERTEX3FSUNPROC epoxy_glTexCoord2fColor4ubVertex3fSUN;
    PFNGLTEXCOORD2FCOLOR4UBVERTEX3FVSUNPROC epoxy_glTexCoord2fColor4ubVertex3fvSUN;
    PFNGLTEXCOORD2FNORMAL3FVERTEX3FSUNPROC epoxy_glTexCoord2fNormal3fVertex3fSUN;
    PFNGLTEXCOORD2FNORMAL3FVERTEX3FVSUNPROC epoxy_glTexCoord2fNormal3fVertex3fvSUN;
    PFNGLTEXCOORD2FVERTEX3FSUNPROC epoxy_glTexCoord2fVertex3fSUN;
    PFNGLTEXCOORD2FVERTEX3FVSUNPROC epoxy_glTexCoord2fVertex3fvSUN;
    PFNGLTEXCOORD2FVPROC epoxy_glTexCoord2fv;
    PFNGLTEXCOORD2HNVPROC epoxy_glTexCoord2hNV;
    PFNGLTEXCOORD2HVNVPROC epoxy_glTexCoord2hvNV;
    PFNGLTEXCOORD2IPROC epoxy_glTexCoord2i;
    PFNGLTEXCOORD2IVPROC epoxy_glTexCoord2iv;
    PFNGLTEXCOORD2SPROC epoxy_glTexCoord2s;
    PFNGLTEXCOORD2SVPROC epoxy_glTexCoord2sv;
    PFNGLTEXCOORD2XOESPROC epoxy_glTexCoord2xOES;
    PFNGLTEXCOORD2XVOESPROC epoxy_glTexCoord2xvOES;
    PFNGLTEXCOORD3BOESPROC epoxy_glTexCoord3bOES;
    PFNGLTEXCOORD3BVOESPROC epoxy_glTexCoord3bvOES;
    PFNGLTEXCOORD3DPROC epoxy_glTexCoord3d;
    PFNGLTEXCOORD3DVPROC epoxy_glTexCoord3dv;
    PFNGLTEXCOORD3FPROC epoxy_glTexCoord3f;
    PFNGLTEXCOORD3FVPROC epoxy_glTexCoord3fv;
    PFNGLTEXCOORD3HNVPROC epoxy_glTexCoord3hNV;
    PFNGLTEXCOORD3HVNVPROC epoxy_glTexCoord3hvNV;
    PFNGLTEXCOORD3IPROC epoxy_glTexCoord3i;
    PFNGLTEXCOORD3IVPROC epoxy_glTexCoord3iv;
    PFNGLTEXCOORD3SPROC epoxy_glTexCoord3s;
    PFNGLTEXCOORD3SVPROC epoxy_glTexCoord3sv;
    PFNGLTEXCOORD3XOESPROC epoxy_glTexCoord3xOES;
    PFNGLTEXCOORD3XVOESPROC epoxy_glTexCoord3xvOES;
    PFNGLTEXCOORD4BOESPROC epoxy_glTexCoord4bOES;
    PFNGLTEXCOORD4BVOESPROC epoxy_glTexCoord4bvOES;
    PFNGLTEXCOORD4DPROC epoxy_glTexCoord4d;
    PFNGLTEXCOORD4DVPROC epoxy_glTexCoord4dv;
    PFNGLTEXCOORD4FPROC epoxy_glTexCoord4f;
    PFNGLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FSUNPROC epoxy_glTexCoord4fColor4fNormal3fVertex4fSUN;
    PFNGLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FVSUNPROC epoxy_glTexCoord4fColor4fNormal3fVertex4fvSUN;
    PFNGLTEXCOORD4FVERTEX4FSUNPROC epoxy_glTexCoord4fVertex4fSUN;
    PFNGLTEXCOORD4FVERTEX4FVSUNPROC epoxy_glTexCoord4fVertex4fvSUN;
    PFNGLTEXCOORD4FVPROC epoxy_glTexCoord4fv;
    PFNGLTEXCOORD4HNVPROC epoxy_glTexCoord4hNV;
    PFNGLTEXCOORD4HVNVPROC epoxy_glTexCoord4hvNV;
    PFNGLTEXCOORD4IPROC epoxy_glTexCoord4i;
    PFNGLTEXCOORD4IVPROC epoxy_glTexCoord4iv;
    PFNGLTEXCOORD4SPROC epoxy_glTexCoord4s;
    PFNGLTEXCOORD4SVPROC epoxy_glTexCoord4sv;
    PFNGLTEXCOORD4XOESPROC epoxy_glTexCoord4xOES;
    PFNGLTEXCOORD4XVOESPROC epoxy_glTexCoord4xvOES;
    PFNGLTEXCOORDFORMATNVPROC epoxy_glTexCoordFormatNV;
    PFNGLTEXCOORDP1UIPROC epoxy_glTexCoordP1ui;
    PFNGLTEXCOORDP1UIVPROC epoxy_glTexCoordP1uiv;
    PFNGLTEXCOORDP2UIPROC epoxy_glTexCoordP2ui;
    PFNGLTEXCOORDP2UIVPROC epoxy_glTexCoordP2uiv;
    PFNGLTEXCOORDP3UIPROC epoxy_glTexCoordP3ui;
    PFNGLTEXCOORDP3UIVPROC epoxy_glTexCoordP3uiv;
    PFNGLTEXCOORDP4UIPROC epoxy_glTexCoordP4ui;
    PFNGLTEXCOORDP4UIVPROC epoxy_glTexCoordP4uiv;
    PFNGLTEXCOORDPOINTERPROC epoxy_glTexCoordPointer;
    PFNGLTEXCOORDPOINTEREXTPROC epoxy_glTexCoordPointerEXT;
    PFNGLTEXCOORDPOINTERLISTIBMPROC epoxy_glTexCoordPointerListIBM;
    PFNGLTEXCOORDPOINTERVINTELPROC epoxy_glTexCoordPointervINTEL;
    PFNGLTEXENVFPROC epoxy_glTexEnvf;
    PFNGLTEXENVFVPROC epoxy_glTexEnvfv;
    PFNGLTEXENVIPROC epoxy_glTexEnvi;
    PFNGLTEXENVIVPROC epoxy_glTexEnviv;
    PFNGLTEXENVXPROC epoxy_glTexEnvx;
    PFNGLTEXENVXOESPROC epoxy_glTexEnvxOES;
    PFNGLTEXENVXVPROC epoxy_glTexEnvxv;
    PFNGLTEXENVXVOESPROC epoxy_glTexEnvxvOES;
    PFNGLTEXFILTERFUNCSGISPROC epoxy_glTexFilterFuncSGIS;
    PFNGLTEXGENDPROC epoxy_glTexGend;
    PFNGLTEXGENDVPROC epoxy_glTexGendv;
    PFNGLTEXGENFPROC epoxy_glTexGenf;
    PFNGLTEXGENFOESPROC epoxy_glTexGenfOES;
    PFNGLTEXGENFVPROC epoxy_glTexGenfv;
    PFNGLTEXGENFVOESPROC epoxy_glTexGenfvOES;
    PFNGLTEXGENIPROC epoxy_glTexGeni;
    PFNGLTEXGENIOESPROC epoxy_glTexGeniOES;
    PFNGLTEXGENIVPROC epoxy_glTexGeniv;
    PFNGLTEXGENIVOESPROC epoxy_glTexGenivOES;
    PFNGLTEXGENXOESPROC epoxy_glTexGenxOES;
    PFNGLTEXGENXVOESPROC epoxy_glTexGenxvOES;
    PFNGLTEXIMAGE1DPROC epoxy_glTexImage1D;
    PFNGLTEXIMAGE2DPROC epoxy_glTexImage2D;
    PFNGLTEXIMAGE2DMULTISAMPLEPROC epoxy_glTexImage2DMultisample;
    PFNGLTEXIMAGE2DMULTISAMPLECOVERAGENVPROC epoxy_glTexImage2DMultisampleCoverageNV;
    PFNGLTEXIMAGE3DPROC epoxy_glTexImage3D;
    PFNGLTEXIMAGE3DEXTPROC epoxy_glTexImage3DEXT;
    PFNGLTEXIMAGE3DMULTISAMPLEPROC epoxy_glTexImage3DMultisample;
    PFNGLTEXIMAGE3DMULTISAMPLECOVERAGENVPROC epoxy_glTexImage3DMultisampleCoverageNV;
    PFNGLTEXIMAGE3DOESPROC epoxy_glTexImage3DOES;
    PFNGLTEXIMAGE4DSGISPROC epoxy_glTexImage4DSGIS;
    PFNGLTEXPAGECOMMITMENTARBPROC epoxy_glTexPageCommitmentARB;
    PFNGLTEXPAGECOMMITMENTEXTPROC epoxy_glTexPageCommitmentEXT;
    PFNGLTEXPARAMETERIIVPROC epoxy_glTexParameterIiv;
    PFNGLTEXPARAMETERIIVEXTPROC epoxy_glTexParameterIivEXT;
    PFNGLTEXPARAMETERIIVOESPROC epoxy_glTexParameterIivOES;
    PFNGLTEXPARAMETERIUIVPROC epoxy_glTexParameterIuiv;
    PFNGLTEXPARAMETERIUIVEXTPROC epoxy_glTexParameterIuivEXT;
    PFNGLTEXPARAMETERIUIVOESPROC epoxy_glTexParameterIuivOES;
    PFNGLTEXPARAMETERFPROC epoxy_glTexParameterf;
    PFNGLTEXPARAMETERFVPROC epoxy_glTexParameterfv;
    PFNGLTEXPARAMETERIPROC epoxy_glTexParameteri;
    PFNGLTEXPARAMETERIVPROC epoxy_glTexParameteriv;
    PFNGLTEXPARAMETERXPROC epoxy_glTexParameterx;
    PFNGLTEXPARAMETERXOESPROC epoxy_glTexParameterxOES;
    PFNGLTEXPARAMETERXVPROC epoxy_glTexParameterxv;
    PFNGLTEXPARAMETERXVOESPROC epoxy_glTexParameterxvOES;
    PFNGLTEXRENDERBUFFERNVPROC epoxy_glTexRenderbufferNV;
    PFNGLTEXSTORAGE1DPROC epoxy_glTexStorage1D;
    PFNGLTEXSTORAGE1DEXTPROC epoxy_glTexStorage1DEXT;
    PFNGLTEXSTORAGE2DPROC epoxy_glTexStorage2D;
    PFNGLTEXSTORAGE2DEXTPROC epoxy_glTexStorage2DEXT;
    PFNGLTEXSTORAGE2DMULTISAMPLEPROC epoxy_glTexStorage2DMultisample;
    PFNGLTEXSTORAGE3DPROC epoxy_glTexStorage3D;
    PFNGLTEXSTORAGE3DEXTPROC epoxy_glTexStorage3DEXT;
    PFNGLTEXSTORAGE3DMULTISAMPLEPROC epoxy_glTexStorage3DMultisample;
    PFNGLTEXSTORAGE3DMULTISAMPLEOESPROC epoxy_glTexStorage3DMultisampleOES;
    PFNGLTEXSTORAGEMEM1DEXTPROC epoxy_glTexStorageMem1DEXT;
    PFNGLTEXSTORAGEMEM2DEXTPROC epoxy_glTexStorageMem2DEXT;
    PFNGLTEXSTORAGEMEM2DMULTISAMPLEEXTPROC epoxy_glTexStorageMem2DMultisampleEXT;
    PFNGLTEXSTORAGEMEM3DEXTPROC epoxy_glTexStorageMem3DEXT;
    PFNGLTEXSTORAGEMEM3DMULTISAMPLEEXTPROC epoxy_glTexStorageMem3DMultisampleEXT;
    PFNGLTEXSTORAGESPARSEAMDPROC epoxy_glTexStorageSparseAMD;
    PFNGLTEXSUBIMAGE1DPROC epoxy_glTexSubImage1D;
    PFNGLTEXSUBIMAGE1DEXTPROC epoxy_glTexSubImage1DEXT;
    PFNGLTEXSUBIMAGE2DPROC epoxy_glTexSubImage2D;
    PFNGLTEXSUBIMAGE2DEXTPROC epoxy_glTexSubImage2DEXT;
    PFNGLTEXSUBIMAGE3DPROC epoxy_glTexSubImage3D;
    PFNGLTEXSUBIMAGE3DEXTPROC epoxy_glTexSubImage3DEXT;
    PFNGLTEXSUBIMAGE3DOESPROC epoxy_glTexSubImage3DOES;
    PFNGLTEXSUBIMAGE4DSGISPROC epoxy_glTexSubImage4DSGIS;
    PFNGLTEXTUREBARRIERPROC epoxy_glTextureBarrier;
    PFNGLTEXTUREBARRIERNVPROC epoxy_glTextureBarrierNV;
    PFNGLTEXTUREBUFFERPROC epoxy_glTextureBuffer;
    PFNGLTEXTUREBUFFEREXTPROC epoxy_glTextureBufferEXT;
    PFNGLTEXTUREBUFFERRANGEPROC epoxy_glTextureBufferRange;
    PFNGLTEXTUREBUFFERRANGEEXTPROC epoxy_glTextureBufferRangeEXT;
    PFNGLTEXTURECOLORMASKSGISPROC epoxy_glTextureColorMaskSGIS;
    PFNGLTEXTUREFOVEATIONPARAMETERSQCOMPROC epoxy_glTextureFoveationParametersQCOM;
    PFNGLTEXTUREIMAGE1DEXTPROC epoxy_glTextureImage1DEXT;
    PFNGLTEXTUREIMAGE2DEXTPROC epoxy_glTextureImage2DEXT;
    PFNGLTEXTUREIMAGE2DMULTISAMPLECOVERAGENVPROC epoxy_glTextureImage2DMultisampleCoverageNV;
    PFNGLTEXTUREIMAGE2DMULTISAMPLENVPROC epoxy_glTextureImage2DMultisampleNV;
    PFNGLTEXTUREIMAGE3DEXTPROC epoxy_glTextureImage3DEXT;
    PFNGLTEXTUREIMAGE3DMULTISAMPLECOVERAGENVPROC epoxy_glTextureImage3DMultisampleCoverageNV;
    PFNGLTEXTUREIMAGE3DMULTISAMPLENVPROC epoxy_glTextureImage3DMultisampleNV;
    PFNGLTEXTURELIGHTEXTPROC epoxy_glTextureLightEXT;
    PFNGLTEXTUREMATERIALEXTPROC epoxy_glTextureMaterialEXT;
    PFNGLTEXTURENORMALEXTPROC epoxy_glTextureNormalEXT;
    PFNGLTEXTUREPAGECOMMITMENTEXTPROC epoxy_glTexturePageCommitmentEXT;
    PFNGLTEXTUREPARAMETERIIVPROC epoxy_glTextureParameterIiv;
    PFNGLTEXTUREPARAMETERIIVEXTPROC epoxy_glTextureParameterIivEXT;
    PFNGLTEXTUREPARAMETERIUIVPROC epoxy_glTextureParameterIuiv;
    PFNGLTEXTUREPARAMETERIUIVEXTPROC epoxy_glTextureParameterIuivEXT;
    PFNGLTEXTUREPARAMETERFPROC epoxy_glTextureParameterf;
    PFNGLTEXTUREPARAMETERFEXTPROC epoxy_glTextureParameterfEXT;
    PFNGLTEXTUREPARAMETERFVPROC epoxy_glTextureParameterfv;
    PFNGLTEXTUREPARAMETERFVEXTPROC epoxy_glTextureParameterfvEXT;
    PFNGLTEXTUREPARAMETERIPROC epoxy_glTextureParameteri;
    PFNGLTEXTUREPARAMETERIEXTPROC epoxy_glTextureParameteriEXT;
    PFNGLTEXTUREPARAMETERIVPROC epoxy_glTextureParameteriv;
    PFNGLTEXTUREPARAMETERIVEXTPROC epoxy_glTextureParameterivEXT;
    PFNGLTEXTURERANGEAPPLEPROC epoxy_glTextureRangeAPPLE;
    PFNGLTEXTURERENDERBUFFEREXTPROC epoxy_glTextureRenderbufferEXT;
    PFNGLTEXTURESTORAGE1DPROC epoxy_glTextureStorage1D;
    PFNGLTEXTURESTORAGE1DEXTPROC epoxy_glTextureStorage1DEXT;
    PFNGLTEXTURESTORAGE2DPROC epoxy_glTextureStorage2D;
    PFNGLTEXTURESTORAGE2DEXTPROC epoxy_glTextureStorage2DEXT;
    PFNGLTEXTURESTORAGE2DMULTISAMPLEPROC epoxy_glTextureStorage2DMultisample;
    PFNGLTEXTURESTORAGE2DMULTISAMPLEEXTPROC epoxy_glTextureStorage2DMultisampleEXT;
    PFNGLTEXTURESTORAGE3DPROC epoxy_glTextureStorage3D;
    PFNGLTEXTURESTORAGE3DEXTPROC epoxy_glTextureStorage3DEXT;
    PFNGLTEXTURESTORAGE3DMULTISAMPLEPROC epoxy_glTextureStorage3DMultisample;
    PFNGLTEXTURESTORAGE3DMULTISAMPLEEXTPROC epoxy_glTextureStorage3DMultisampleEXT;
    PFNGLTEXTURESTORAGEMEM1DEXTPROC epoxy_glTextureStorageMem1DEXT;
    PFNGLTEXTURESTORAGEMEM2DEXTPROC epoxy_glTextureStorageMem2DEXT;
    PFNGLTEXTURESTORAGEMEM2DMULTISAMPLEEXTPROC epoxy_glTextureStorageMem2DMultisampleEXT;
    PFNGLTEXTURESTORAGEMEM3DEXTPROC epoxy_glTextureStorageMem3DEXT;
    PFNGLTEXTURESTORAGEMEM3DMULTISAMPLEEXTPROC epoxy_glTextureStorageMem3DMultisampleEXT;
    PFNGLTEXTURESTORAGESPARSEAMDPROC epoxy_glTextureStorageSparseAMD;
    PFNGLTEXTURESUBIMAGE1DPROC epoxy_glTextureSubImage1D;
    PFNGLTEXTURESUBIMAGE1DEXTPROC epoxy_glTextureSubImage1DEXT;
    PFNGLTEXTURESUBIMAGE2DPROC epoxy_glTextureSubImage2D;
    PFNGLTEXTURESUBIMAGE2DEXTPROC epoxy_glTextureSubImage2DEXT;
    PFNGLTEXTURESUBIMAGE3DPROC epoxy_glTextureSubImage3D;
    PFNGLTEXTURESUBIMAGE3DEXTPROC epoxy_glTextureSubImage3DEXT;
    PFNGLTEXTUREVIEWPROC epoxy_glTextureView;
    PFNGLTEXTUREVIEWEXTPROC epoxy_glTextureViewEXT;
    PFNGLTEXTUREVIEWOESPROC epoxy_glTextureViewOES;
    PFNGLTRACKMATRIXNVPROC epoxy_glTrackMatrixNV;
    PFNGLTRANSFORMFEEDBACKATTRIBSNVPROC epoxy_glTransformFeedbackAttribsNV;
    PFNGLTRANSFORMFEEDBACKBUFFERBASEPROC epoxy_glTransformFeedbackBufferBase;
    PFNGLTRANSFORMFEEDBACKBUFFERRANGEPROC epoxy_glTransformFeedbackBufferRange;
    PFNGLTRANSFORMFEEDBACKSTREAMATTRIBSNVPROC epoxy_glTransformFeedbackStreamAttribsNV;
    PFNGLTRANSFORMFEEDBACKVARYINGSPROC epoxy_glTransformFeedbackVaryings;
    PFNGLTRANSFORMFEEDBACKVARYINGSEXTPROC epoxy_glTransformFeedbackVaryingsEXT;
    PFNGLTRANSFORMFEEDBACKVARYINGSNVPROC epoxy_glTransformFeedbackVaryingsNV;
    PFNGLTRANSFORMPATHNVPROC epoxy_glTransformPathNV;
    PFNGLTRANSLATEDPROC epoxy_glTranslated;
    PFNGLTRANSLATEFPROC epoxy_glTranslatef;
    PFNGLTRANSLATEXPROC epoxy_glTranslatex;
    PFNGLTRANSLATEXOESPROC epoxy_glTranslatexOES;
    PFNGLUNIFORM1DPROC epoxy_glUniform1d;
    PFNGLUNIFORM1DVPROC epoxy_glUniform1dv;
    PFNGLUNIFORM1FPROC epoxy_glUniform1f;
    PFNGLUNIFORM1FARBPROC epoxy_glUniform1fARB;
    PFNGLUNIFORM1FVPROC epoxy_glUniform1fv;
    PFNGLUNIFORM1FVARBPROC epoxy_glUniform1fvARB;
    PFNGLUNIFORM1IPROC epoxy_glUniform1i;
    PFNGLUNIFORM1I64ARBPROC epoxy_glUniform1i64ARB;
    PFNGLUNIFORM1I64NVPROC epoxy_glUniform1i64NV;
    PFNGLUNIFORM1I64VARBPROC epoxy_glUniform1i64vARB;
    PFNGLUNIFORM1I64VNVPROC epoxy_glUniform1i64vNV;
    PFNGLUNIFORM1IARBPROC epoxy_glUniform1iARB;
    PFNGLUNIFORM1IVPROC epoxy_glUniform1iv;
    PFNGLUNIFORM1IVARBPROC epoxy_glUniform1ivARB;
    PFNGLUNIFORM1UIPROC epoxy_glUniform1ui;
    PFNGLUNIFORM1UI64ARBPROC epoxy_glUniform1ui64ARB;
    PFNGLUNIFORM1UI64NVPROC epoxy_glUniform1ui64NV;
    PFNGLUNIFORM1UI64VARBPROC epoxy_glUniform1ui64vARB;
    PFNGLUNIFORM1UI64VNVPROC epoxy_glUniform1ui64vNV;
    PFNGLUNIFORM1UIEXTPROC epoxy_glUniform1uiEXT;
    PFNGLUNIFORM1UIVPROC epoxy_glUniform1uiv;
    PFNGLUNIFORM1UIVEXTPROC epoxy_glUniform1uivEXT;
    PFNGLUNIFORM2DPROC epoxy_glUniform2d;
    PFNGLUNIFORM2DVPROC epoxy_glUniform2dv;
    PFNGLUNIFORM2FPROC epoxy_glUniform2f;
    PFNGLUNIFORM2FARBPROC epoxy_glUniform2fARB;
    PFNGLUNIFORM2FVPROC epoxy_glUniform2fv;
    PFNGLUNIFORM2FVARBPROC epoxy_glUniform2fvARB;
    PFNGLUNIFORM2IPROC epoxy_glUniform2i;
    PFNGLUNIFORM2I64ARBPROC epoxy_glUniform2i64ARB;
    PFNGLUNIFORM2I64NVPROC epoxy_glUniform2i64NV;
    PFNGLUNIFORM2I64VARBPROC epoxy_glUniform2i64vARB;
    PFNGLUNIFORM2I64VNVPROC epoxy_glUniform2i64vNV;
    PFNGLUNIFORM2IARBPROC epoxy_glUniform2iARB;
    PFNGLUNIFORM2IVPROC epoxy_glUniform2iv;
    PFNGLUNIFORM2IVARBPROC epoxy_glUniform2ivARB;
    PFNGLUNIFORM2UIPROC epoxy_glUniform2ui;
    PFNGLUNIFORM2UI64ARBPROC epoxy_glUniform2ui64ARB;
    PFNGLUNIFORM2UI64NVPROC epoxy_glUniform2ui64NV;
    PFNGLUNIFORM2UI64VARBPROC epoxy_glUniform2ui64vARB;
    PFNGLUNIFORM2UI64VNVPROC epoxy_glUniform2ui64vNV;
    PFNGLUNIFORM2UIEXTPROC epoxy_glUniform2uiEXT;
    PFNGLUNIFORM2UIVPROC epoxy_glUniform2uiv;
    PFNGLUNIFORM2UIVEXTPROC epoxy_glUniform2uivEXT;
    PFNGLUNIFORM3DPROC epoxy_glUniform3d;
    PFNGLUNIFORM3DVPROC epoxy_glUniform3dv;
    PFNGLUNIFORM3FPROC epoxy_glUniform3f;
    PFNGLUNIFORM3FARBPROC epoxy_glUniform3fARB;
    PFNGLUNIFORM3FVPROC epoxy_glUniform3fv;
    PFNGLUNIFORM3FVARBPROC epoxy_glUniform3fvARB;
    PFNGLUNIFORM3IPROC epoxy_glUniform3i;
    PFNGLUNIFORM3I64ARBPROC epoxy_glUniform3i64ARB;
    PFNGLUNIFORM3I64NVPROC epoxy_glUniform3i64NV;
    PFNGLUNIFORM3I64VARBPROC epoxy_glUniform3i64vARB;
    PFNGLUNIFORM3I64VNVPROC epoxy_glUniform3i64vNV;
    PFNGLUNIFORM3IARBPROC epoxy_glUniform3iARB;
    PFNGLUNIFORM3IVPROC epoxy_glUniform3iv;
    PFNGLUNIFORM3IVARBPROC epoxy_glUniform3ivARB;
    PFNGLUNIFORM3UIPROC epoxy_glUniform3ui;
    PFNGLUNIFORM3UI64ARBPROC epoxy_glUniform3ui64ARB;
    PFNGLUNIFORM3UI64NVPROC epoxy_glUniform3ui64NV;
    PFNGLUNIFORM3UI64VARBPROC epoxy_glUniform3ui64vARB;
    PFNGLUNIFORM3UI64VNVPROC epoxy_glUniform3ui64vNV;
    PFNGLUNIFORM3UIEXTPROC epoxy_glUniform3uiEXT;
    PFNGLUNIFORM3UIVPROC epoxy_glUniform3uiv;
    PFNGLUNIFORM3UIVEXTPROC epoxy_glUniform3uivEXT;
    PFNGLUNIFORM4DPROC epoxy_glUniform4d;
    PFNGLUNIFORM4DVPROC epoxy_glUniform4dv;
    PFNGLUNIFORM4FPROC epoxy_glUniform4f;
    PFNGLUNIFORM4FARBPROC epoxy_glUniform4fARB;
    PFNGLUNIFORM4FVPROC epoxy_glUniform4fv;
    PFNGLUNIFORM4FVARBPROC epoxy_glUniform4fvARB;
    PFNGLUNIFORM4IPROC epoxy_glUniform4i;
    PFNGLUNIFORM4I64ARBPROC epoxy_glUniform4i64ARB;
    PFNGLUNIFORM4I64NVPROC epoxy_glUniform4i64NV;
    PFNGLUNIFORM4I64VARBPROC epoxy_glUniform4i64vARB;
    PFNGLUNIFORM4I64VNVPROC epoxy_glUniform4i64vNV;
    PFNGLUNIFORM4IARBPROC epoxy_glUniform4iARB;
    PFNGLUNIFORM4IVPROC epoxy_glUniform4iv;
    PFNGLUNIFORM4IVARBPROC epoxy_glUniform4ivARB;
    PFNGLUNIFORM4UIPROC epoxy_glUniform4ui;
    PFNGLUNIFORM4UI64ARBPROC epoxy_glUniform4ui64ARB;
    PFNGLUNIFORM4UI64NVPROC epoxy_glUniform4ui64NV;
    PFNGLUNIFORM4UI64VARBPROC epoxy_glUniform4ui64vARB;
    PFNGLUNIFORM4UI64VNVPROC epoxy_glUniform4ui64vNV;
    PFNGLUNIFORM4UIEXTPROC epoxy_glUniform4uiEXT;
    PFNGLUNIFORM4UIVPROC epoxy_glUniform4uiv;
    PFNGLUNIFORM4UIVEXTPROC epoxy_glUniform4uivEXT;
    PFNGLUNIFORMBLOCKBINDINGPROC epoxy_glUniformBlockBinding;
    PFNGLUNIFORMBUFFEREXTPROC epoxy_glUniformBufferEXT;
    PFNGLUNIFORMHANDLEUI64ARBPROC epoxy_glUniformHandleui64ARB;
    PFNGLUNIFORMHANDLEUI64IMGPROC epoxy_glUniformHandleui64IMG;
    PFNGLUNIFORMHANDLEUI64NVPROC epoxy_glUniformHandleui64NV;
    PFNGLUNIFORMHANDLEUI64VARBPROC epoxy_glUniformHandleui64vARB;
    PFNGLUNIFORMHANDLEUI64VIMGPROC epoxy_glUniformHandleui64vIMG;
    PFNGLUNIFORMHANDLEUI64VNVPROC epoxy_glUniformHandleui64vNV;
    PFNGLUNIFORMMATRIX2DVPROC epoxy_glUniformMatrix2dv;
    PFNGLUNIFORMMATRIX2FVPROC epoxy_glUniformMatrix2fv;
    PFNGLUNIFORMMATRIX2FVARBPROC epoxy_glUniformMatrix2fvARB;
    PFNGLUNIFORMMATRIX2X3DVPROC epoxy_glUniformMatrix2x3dv;
    PFNGLUNIFORMMATRIX2X3FVPROC epoxy_glUniformMatrix2x3fv;
    PFNGLUNIFORMMATRIX2X3FVNVPROC epoxy_glUniformMatrix2x3fvNV;
    PFNGLUNIFORMMATRIX2X4DVPROC epoxy_glUniformMatrix2x4dv;
    PFNGLUNIFORMMATRIX2X4FVPROC epoxy_glUniformMatrix2x4fv;
    PFNGLUNIFORMMATRIX2X4FVNVPROC epoxy_glUniformMatrix2x4fvNV;
    PFNGLUNIFORMMATRIX3DVPROC epoxy_glUniformMatrix3dv;
    PFNGLUNIFORMMATRIX3FVPROC epoxy_glUniformMatrix3fv;
    PFNGLUNIFORMMATRIX3FVARBPROC epoxy_glUniformMatrix3fvARB;
    PFNGLUNIFORMMATRIX3X2DVPROC epoxy_glUniformMatrix3x2dv;
    PFNGLUNIFORMMATRIX3X2FVPROC epoxy_glUniformMatrix3x2fv;
    PFNGLUNIFORMMATRIX3X2FVNVPROC epoxy_glUniformMatrix3x2fvNV;
    PFNGLUNIFORMMATRIX3X4DVPROC epoxy_glUniformMatrix3x4dv;
    PFNGLUNIFORMMATRIX3X4FVPROC epoxy_glUniformMatrix3x4fv;
    PFNGLUNIFORMMATRIX3X4FVNVPROC epoxy_glUniformMatrix3x4fvNV;
    PFNGLUNIFORMMATRIX4DVPROC epoxy_glUniformMatrix4dv;
    PFNGLUNIFORMMATRIX4FVPROC epoxy_glUniformMatrix4fv;
    PFNGLUNIFORMMATRIX4FVARBPROC epoxy_glUniformMatrix4fvARB;
    PFNGLUNIFORMMATRIX4X2DVPROC epoxy_glUniformMatrix4x2dv;
    PFNGLUNIFORMMATRIX4X2FVPROC epoxy_glUniformMatrix4x2fv;
    PFNGLUNIFORMMATRIX4X2FVNVPROC epoxy_glUniformMatrix4x2fvNV;
    PFNGLUNIFORMMATRIX4X3DVPROC epoxy_glUniformMatrix4x3dv;
    PFNGLUNIFORMMATRIX4X3FVPROC epoxy_glUniformMatrix4x3fv;
    PFNGLUNIFORMMATRIX4X3FVNVPROC epoxy_glUniformMatrix4x3fvNV;
    PFNGLUNIFORMSUBROUTINESUIVPROC epoxy_glUniformSubroutinesuiv;
    PFNGLUNIFORMUI64NVPROC epoxy_glUniformui64NV;
    PFNGLUNIFORMUI64VNVPROC epoxy_glUniformui64vNV;
    PFNGLUNLOCKARRAYSEXTPROC epoxy_glUnlockArraysEXT;
    PFNGLUNMAPBUFFERPROC epoxy_glUnmapBuffer;
    PFNGLUNMAPBUFFERARBPROC epoxy_glUnmapBufferARB;
    PFNGLUNMAPBUFFEROESPROC epoxy_glUnmapBufferOES;
    PFNGLUNMAPNAMEDBUFFERPROC epoxy_glUnmapNamedBuffer;
    PFNGLUNMAPNAMEDBUFFEREXTPROC epoxy_glUnmapNamedBufferEXT;
    PFNGLUNMAPOBJECTBUFFERATIPROC epoxy_glUnmapObjectBufferATI;
    PFNGLUNMAPTEXTURE2DINTELPROC epoxy_glUnmapTexture2DINTEL;
    PFNGLUPDATEOBJECTBUFFERATIPROC epoxy_glUpdateObjectBufferATI;
    PFNGLUSEPROGRAMPROC epoxy_glUseProgram;
    PFNGLUSEPROGRAMOBJECTARBPROC epoxy_glUseProgramObjectARB;
    PFNGLUSEPROGRAMSTAGESPROC epoxy_glUseProgramStages;
    PFNGLUSEPROGRAMSTAGESEXTPROC epoxy_glUseProgramStagesEXT;
    PFNGLUSESHADERPROGRAMEXTPROC epoxy_glUseShaderProgramEXT;
    PFNGLVDPAUFININVPROC epoxy_glVDPAUFiniNV;
    PFNGLVDPAUGETSURFACEIVNVPROC epoxy_glVDPAUGetSurfaceivNV;
    PFNGLVDPAUINITNVPROC epoxy_glVDPAUInitNV;
    PFNGLVDPAUISSURFACENVPROC epoxy_glVDPAUIsSurfaceNV;
    PFNGLVDPAUMAPSURFACESNVPROC epoxy_glVDPAUMapSurfacesNV;
    PFNGLVDPAUREGISTEROUTPUTSURFACENVPROC epoxy_glVDPAURegisterOutputSurfaceNV;
    PFNGLVDPAUREGISTERVIDEOSURFACENVPROC epoxy_glVDPAURegisterVideoSurfaceNV;
    PFNGLVDPAUSURFACEACCESSNVPROC epoxy_glVDPAUSurfaceAccessNV;
    PFNGLVDPAUUNMAPSURFACESNVPROC epoxy_glVDPAUUnmapSurfacesNV;
    PFNGLVDPAUUNREGISTERSURFACENVPROC epoxy_glVDPAUUnregisterSurfaceNV;
    PFNGLVALIDATEPROGRAMPROC epoxy_glValidateProgram;
    PFNGLVALIDATEPROGRAMARBPROC epoxy_glValidateProgramARB;
    PFNGLVALIDATEPROGRAMPIPELINEPROC epoxy_glValidateProgramPipeline;
    PFNGLVALIDATEPROGRAMPIPELINEEXTPROC epoxy_glValidateProgramPipelineEXT;
    PFNGLVARIANTARRAYOBJECTATIPROC epoxy_glVariantArrayObjectATI;
    PFNGLVARIANTPOINTEREXTPROC epoxy_glVariantPointerEXT;
    PFNGLVARIANTBVEXTPROC epoxy_glVariantbvEXT;
    PFNGLVARIANTDVEXTPROC epoxy_glVariantdvEXT;
    PFNGLVARIANTFVEXTPROC epoxy_glVariantfvEXT;
    PFNGLVARIANTIVEXTPROC epoxy_glVariantivEXT;
    PFNGLVARIANTSVEXTPROC epoxy_glVariantsvEXT;
    PFNGLVARIANTUBVEXTPROC epoxy_glVariantubvEXT;
    PFNGLVARIANTUIVEXTPROC epoxy_glVariantuivEXT;
    PFNGLVARIANTUSVEXTPROC epoxy_glVariantusvEXT;
    PFNGLVERTEX2BOESPROC epoxy_glVertex2bOES;
    PFNGLVERTEX2BVOESPROC epoxy_glVertex2bvOES;
    PFNGLVERTEX2DPROC epoxy_glVertex2d;
    PFNGLVERTEX2DVPROC epoxy_glVertex2dv;
    PFNGLVERTEX2FPROC epoxy_glVertex2f;
    PFNGLVERTEX2FVPROC epoxy_glVertex2fv;
    PFNGLVERTEX2HNVPROC epoxy_glVertex2hNV;
    PFNGLVERTEX2HVNVPROC epoxy_glVertex2hvNV;
    PFNGLVERTEX2IPROC epoxy_glVertex2i;
    PFNGLVERTEX2IVPROC epoxy_glVertex2iv;
    PFNGLVERTEX2SPROC epoxy_glVertex2s;
    PFNGLVERTEX2SVPROC epoxy_glVertex2sv;
    PFNGLVERTEX2XOESPROC epoxy_glVertex2xOES;
    PFNGLVERTEX2XVOESPROC epoxy_glVertex2xvOES;
    PFNGLVERTEX3BOESPROC epoxy_glVertex3bOES;
    PFNGLVERTEX3BVOESPROC epoxy_glVertex3bvOES;
    PFNGLVERTEX3DPROC epoxy_glVertex3d;
    PFNGLVERTEX3DVPROC epoxy_glVertex3dv;
    PFNGLVERTEX3FPROC epoxy_glVertex3f;
    PFNGLVERTEX3FVPROC epoxy_glVertex3fv;
    PFNGLVERTEX3HNVPROC epoxy_glVertex3hNV;
    PFNGLVERTEX3HVNVPROC epoxy_glVertex3hvNV;
    PFNGLVERTEX3IPROC epoxy_glVertex3i;
    PFNGLVERTEX3IVPROC epoxy_glVertex3iv;
    PFNGLVERTEX3SPROC epoxy_glVertex3s;
    PFNGLVERTEX3SVPROC epoxy_glVertex3sv;
    PFNGLVERTEX3XOESPROC epoxy_glVertex3xOES;
    PFNGLVERTEX3XVOESPROC epoxy_glVertex3xvOES;
    PFNGLVERTEX4BOESPROC epoxy_glVertex4bOES;
    PFNGLVERTEX4BVOESPROC epoxy_glVertex4bvOES;
    PFNGLVERTEX4DPROC epoxy_glVertex4d;
    PFNGLVERTEX4DVPROC epoxy_glVertex4dv;
    PFNGLVERTEX4FPROC epoxy_glVertex4f;
    PFNGLVERTEX4FVPROC epoxy_glVertex4fv;
    PFNGLVERTEX4HNVPROC epoxy_glVertex4hNV;
    PFNGLVERTEX4HVNVPROC epoxy_glVertex4hvNV;
    PFNGLVERTEX4IPROC epoxy_glVertex4i;
    PFNGLVERTEX4IVPROC epoxy_glVertex4iv;
    PFNGLVERTEX4SPROC epoxy_glVertex4s;
    PFNGLVERTEX4SVPROC epoxy_glVertex4sv;
    PFNGLVERTEX4XOESPROC epoxy_glVertex4xOES;
    PFNGLVERTEX4XVOESPROC epoxy_glVertex4xvOES;
    PFNGLVERTEXARRAYATTRIBBINDINGPROC epoxy_glVertexArrayAttribBinding;
    PFNGLVERTEXARRAYATTRIBFORMATPROC epoxy_glVertexArrayAttribFormat;
    PFNGLVERTEXARRAYATTRIBIFORMATPROC epoxy_glVertexArrayAttribIFormat;
    PFNGLVERTEXARRAYATTRIBLFORMATPROC epoxy_glVertexArrayAttribLFormat;
    PFNGLVERTEXARRAYBINDVERTEXBUFFEREXTPROC epoxy_glVertexArrayBindVertexBufferEXT;
    PFNGLVERTEXARRAYBINDINGDIVISORPROC epoxy_glVertexArrayBindingDivisor;
    PFNGLVERTEXARRAYCOLOROFFSETEXTPROC epoxy_glVertexArrayColorOffsetEXT;
    PFNGLVERTEXARRAYEDGEFLAGOFFSETEXTPROC epoxy_glVertexArrayEdgeFlagOffsetEXT;
    PFNGLVERTEXARRAYELEMENTBUFFERPROC epoxy_glVertexArrayElementBuffer;
    PFNGLVERTEXARRAYFOGCOORDOFFSETEXTPROC epoxy_glVertexArrayFogCoordOffsetEXT;
    PFNGLVERTEXARRAYINDEXOFFSETEXTPROC epoxy_glVertexArrayIndexOffsetEXT;
    PFNGLVERTEXARRAYMULTITEXCOORDOFFSETEXTPROC epoxy_glVertexArrayMultiTexCoordOffsetEXT;
    PFNGLVERTEXARRAYNORMALOFFSETEXTPROC epoxy_glVertexArrayNormalOffsetEXT;
    PFNGLVERTEXARRAYPARAMETERIAPPLEPROC epoxy_glVertexArrayParameteriAPPLE;
    PFNGLVERTEXARRAYRANGEAPPLEPROC epoxy_glVertexArrayRangeAPPLE;
    PFNGLVERTEXARRAYRANGENVPROC epoxy_glVertexArrayRangeNV;
    PFNGLVERTEXARRAYSECONDARYCOLOROFFSETEXTPROC epoxy_glVertexArraySecondaryColorOffsetEXT;
    PFNGLVERTEXARRAYTEXCOORDOFFSETEXTPROC epoxy_glVertexArrayTexCoordOffsetEXT;
    PFNGLVERTEXARRAYVERTEXATTRIBBINDINGEXTPROC epoxy_glVertexArrayVertexAttribBindingEXT;
    PFNGLVERTEXARRAYVERTEXATTRIBDIVISOREXTPROC epoxy_glVertexArrayVertexAttribDivisorEXT;
    PFNGLVERTEXARRAYVERTEXATTRIBFORMATEXTPROC epoxy_glVertexArrayVertexAttribFormatEXT;
    PFNGLVERTEXARRAYVERTEXATTRIBIFORMATEXTPROC epoxy_glVertexArrayVertexAttribIFormatEXT;
    PFNGLVERTEXARRAYVERTEXATTRIBIOFFSETEXTPROC epoxy_glVertexArrayVertexAttribIOffsetEXT;
    PFNGLVERTEXARRAYVERTEXATTRIBLFORMATEXTPROC epoxy_glVertexArrayVertexAttribLFormatEXT;
    PFNGLVERTEXARRAYVERTEXATTRIBLOFFSETEXTPROC epoxy_glVertexArrayVertexAttribLOffsetEXT;
    PFNGLVERTEXARRAYVERTEXATTRIBOFFSETEXTPROC epoxy_glVertexArrayVertexAttribOffsetEXT;
    PFNGLVERTEXARRAYVERTEXBINDINGDIVISOREXTPROC epoxy_glVertexArrayVertexBindingDivisorEXT;
    PFNGLVERTEXARRAYVERTEXBUFFERPROC epoxy_glVertexArrayVertexBuffer;
    PFNGLVERTEXARRAYVERTEXBUFFERSPROC epoxy_glVertexArrayVertexBuffers;
    PFNGLVERTEXARRAYVERTEXOFFSETEXTPROC epoxy_glVertexArrayVertexOffsetEXT;
    PFNGLVERTEXATTRIB1DPROC epoxy_glVertexAttrib1d;
    PFNGLVERTEXATTRIB1DARBPROC epoxy_glVertexAttrib1dARB;
    PFNGLVERTEXATTRIB1DNVPROC epoxy_glVertexAttrib1dNV;
    PFNGLVERTEXATTRIB1DVPROC epoxy_glVertexAttrib1dv;
    PFNGLVERTEXATTRIB1DVARBPROC epoxy_glVertexAttrib1dvARB;
    PFNGLVERTEXATTRIB1DVNVPROC epoxy_glVertexAttrib1dvNV;
    PFNGLVERTEXATTRIB1FPROC epoxy_glVertexAttrib1f;
    PFNGLVERTEXATTRIB1FARBPROC epoxy_glVertexAttrib1fARB;
    PFNGLVERTEXATTRIB1FNVPROC epoxy_glVertexAttrib1fNV;
    PFNGLVERTEXATTRIB1FVPROC epoxy_glVertexAttrib1fv;
    PFNGLVERTEXATTRIB1FVARBPROC epoxy_glVertexAttrib1fvARB;
    PFNGLVERTEXATTRIB1FVNVPROC epoxy_glVertexAttrib1fvNV;
    PFNGLVERTEXATTRIB1HNVPROC epoxy_glVertexAttrib1hNV;
    PFNGLVERTEXATTRIB1HVNVPROC epoxy_glVertexAttrib1hvNV;
    PFNGLVERTEXATTRIB1SPROC epoxy_glVertexAttrib1s;
    PFNGLVERTEXATTRIB1SARBPROC epoxy_glVertexAttrib1sARB;
    PFNGLVERTEXATTRIB1SNVPROC epoxy_glVertexAttrib1sNV;
    PFNGLVERTEXATTRIB1SVPROC epoxy_glVertexAttrib1sv;
    PFNGLVERTEXATTRIB1SVARBPROC epoxy_glVertexAttrib1svARB;
    PFNGLVERTEXATTRIB1SVNVPROC epoxy_glVertexAttrib1svNV;
    PFNGLVERTEXATTRIB2DPROC epoxy_glVertexAttrib2d;
    PFNGLVERTEXATTRIB2DARBPROC epoxy_glVertexAttrib2dARB;
    PFNGLVERTEXATTRIB2DNVPROC epoxy_glVertexAttrib2dNV;
    PFNGLVERTEXATTRIB2DVPROC epoxy_glVertexAttrib2dv;
    PFNGLVERTEXATTRIB2DVARBPROC epoxy_glVertexAttrib2dvARB;
    PFNGLVERTEXATTRIB2DVNVPROC epoxy_glVertexAttrib2dvNV;
    PFNGLVERTEXATTRIB2FPROC epoxy_glVertexAttrib2f;
    PFNGLVERTEXATTRIB2FARBPROC epoxy_glVertexAttrib2fARB;
    PFNGLVERTEXATTRIB2FNVPROC epoxy_glVertexAttrib2fNV;
    PFNGLVERTEXATTRIB2FVPROC epoxy_glVertexAttrib2fv;
    PFNGLVERTEXATTRIB2FVARBPROC epoxy_glVertexAttrib2fvARB;
    PFNGLVERTEXATTRIB2FVNVPROC epoxy_glVertexAttrib2fvNV;
    PFNGLVERTEXATTRIB2HNVPROC epoxy_glVertexAttrib2hNV;
    PFNGLVERTEXATTRIB2HVNVPROC epoxy_glVertexAttrib2hvNV;
    PFNGLVERTEXATTRIB2SPROC epoxy_glVertexAttrib2s;
    PFNGLVERTEXATTRIB2SARBPROC epoxy_glVertexAttrib2sARB;
    PFNGLVERTEXATTRIB2SNVPROC epoxy_glVertexAttrib2sNV;
    PFNGLVERTEXATTRIB2SVPROC epoxy_glVertexAttrib2sv;
    PFNGLVERTEXATTRIB2SVARBPROC epoxy_glVertexAttrib2svARB;
    PFNGLVERTEXATTRIB2SVNVPROC epoxy_glVertexAttrib2svNV;
    PFNGLVERTEXATTRIB3DPROC epoxy_glVertexAttrib3d;
    PFNGLVERTEXATTRIB3DARBPROC epoxy_glVertexAttrib3dARB;
    PFNGLVERTEXATTRIB3DNVPROC epoxy_glVertexAttrib3dNV;
    PFNGLVERTEXATTRIB3DVPROC epoxy_glVertexAttrib3dv;
    PFNGLVERTEXATTRIB3DVARBPROC epoxy_glVertexAttrib3dvARB;
    PFNGLVERTEXATTRIB3DVNVPROC epoxy_glVertexAttrib3dvNV;
    PFNGLVERTEXATTRIB3FPROC epoxy_glVertexAttrib3f;
    PFNGLVERTEXATTRIB3FARBPROC epoxy_glVertexAttrib3fARB;
    PFNGLVERTEXATTRIB3FNVPROC epoxy_glVertexAttrib3fNV;
    PFNGLVERTEXATTRIB3FVPROC epoxy_glVertexAttrib3fv;
    PFNGLVERTEXATTRIB3FVARBPROC epoxy_glVertexAttrib3fvARB;
    PFNGLVERTEXATTRIB3FVNVPROC epoxy_glVertexAttrib3fvNV;
    PFNGLVERTEXATTRIB3HNVPROC epoxy_glVertexAttrib3hNV;
    PFNGLVERTEXATTRIB3HVNVPROC epoxy_glVertexAttrib3hvNV;
    PFNGLVERTEXATTRIB3SPROC epoxy_glVertexAttrib3s;
    PFNGLVERTEXATTRIB3SARBPROC epoxy_glVertexAttrib3sARB;
    PFNGLVERTEXATTRIB3SNVPROC epoxy_glVertexAttrib3sNV;
    PFNGLVERTEXATTRIB3SVPROC epoxy_glVertexAttrib3sv;
    PFNGLVERTEXATTRIB3SVARBPROC epoxy_glVertexAttrib3svARB;
    PFNGLVERTEXATTRIB3SVNVPROC epoxy_glVertexAttrib3svNV;
    PFNGLVERTEXATTRIB4NBVPROC epoxy_glVertexAttrib4Nbv;
    PFNGLVERTEXATTRIB4NBVARBPROC epoxy_glVertexAttrib4NbvARB;
    PFNGLVERTEXATTRIB4NIVPROC epoxy_glVertexAttrib4Niv;
    PFNGLVERTEXATTRIB4NIVARBPROC epoxy_glVertexAttrib4NivARB;
    PFNGLVERTEXATTRIB4NSVPROC epoxy_glVertexAttrib4Nsv;
    PFNGLVERTEXATTRIB4NSVARBPROC epoxy_glVertexAttrib4NsvARB;
    PFNGLVERTEXATTRIB4NUBPROC epoxy_glVertexAttrib4Nub;
    PFNGLVERTEXATTRIB4NUBARBPROC epoxy_glVertexAttrib4NubARB;
    PFNGLVERTEXATTRIB4NUBVPROC epoxy_glVertexAttrib4Nubv;
    PFNGLVERTEXATTRIB4NUBVARBPROC epoxy_glVertexAttrib4NubvARB;
    PFNGLVERTEXATTRIB4NUIVPROC epoxy_glVertexAttrib4Nuiv;
    PFNGLVERTEXATTRIB4NUIVARBPROC epoxy_glVertexAttrib4NuivARB;
    PFNGLVERTEXATTRIB4NUSVPROC epoxy_glVertexAttrib4Nusv;
    PFNGLVERTEXATTRIB4NUSVARBPROC epoxy_glVertexAttrib4NusvARB;
    PFNGLVERTEXATTRIB4BVPROC epoxy_glVertexAttrib4bv;
    PFNGLVERTEXATTRIB4BVARBPROC epoxy_glVertexAttrib4bvARB;
    PFNGLVERTEXATTRIB4DPROC epoxy_glVertexAttrib4d;
    PFNGLVERTEXATTRIB4DARBPROC epoxy_glVertexAttrib4dARB;
    PFNGLVERTEXATTRIB4DNVPROC epoxy_glVertexAttrib4dNV;
    PFNGLVERTEXATTRIB4DVPROC epoxy_glVertexAttrib4dv;
    PFNGLVERTEXATTRIB4DVARBPROC epoxy_glVertexAttrib4dvARB;
    PFNGLVERTEXATTRIB4DVNVPROC epoxy_glVertexAttrib4dvNV;
    PFNGLVERTEXATTRIB4FPROC epoxy_glVertexAttrib4f;
    PFNGLVERTEXATTRIB4FARBPROC epoxy_glVertexAttrib4fARB;
    PFNGLVERTEXATTRIB4FNVPROC epoxy_glVertexAttrib4fNV;
    PFNGLVERTEXATTRIB4FVPROC epoxy_glVertexAttrib4fv;
    PFNGLVERTEXATTRIB4FVARBPROC epoxy_glVertexAttrib4fvARB;
    PFNGLVERTEXATTRIB4FVNVPROC epoxy_glVertexAttrib4fvNV;
    PFNGLVERTEXATTRIB4HNVPROC epoxy_glVertexAttrib4hNV;
    PFNGLVERTEXATTRIB4HVNVPROC epoxy_glVertexAttrib4hvNV;
    PFNGLVERTEXATTRIB4IVPROC epoxy_glVertexAttrib4iv;
    PFNGLVERTEXATTRIB4IVARBPROC epoxy_glVertexAttrib4ivARB;
    PFNGLVERTEXATTRIB4SPROC epoxy_glVertexAttrib4s;
    PFNGLVERTEXATTRIB4SARBPROC epoxy_glVertexAttrib4sARB;
    PFNGLVERTEXATTRIB4SNVPROC epoxy_glVertexAttrib4sNV;
    PFNGLVERTEXATTRIB4SVPROC epoxy_glVertexAttrib4sv;
    PFNGLVERTEXATTRIB4SVARBPROC epoxy_glVertexAttrib4svARB;
    PFNGLVERTEXATTRIB4SVNVPROC epoxy_glVertexAttrib4svNV;
    PFNGLVERTEXATTRIB4UBNVPROC epoxy_glVertexAttrib4ubNV;
    PFNGLVERTEXATTRIB4UBVPROC epoxy_glVertexAttrib4ubv;
    PFNGLVERTEXATTRIB4UBVARBPROC epoxy_glVertexAttrib4ubvARB;
    PFNGLVERTEXATTRIB4UBVNVPROC epoxy_glVertexAttrib4ubvNV;
    PFNGLVERTEXATTRIB4UIVPROC epoxy_glVertexAttrib4uiv;
    PFNGLVERTEXATTRIB4UIVARBPROC epoxy_glVertexAttrib4uivARB;
    PFNGLVERTEXATTRIB4USVPROC epoxy_glVertexAttrib4usv;
    PFNGLVERTEXATTRIB4USVARBPROC epoxy_glVertexAttrib4usvARB;
    PFNGLVERTEXATTRIBARRAYOBJECTATIPROC epoxy_glVertexAttribArrayObjectATI;
    PFNGLVERTEXATTRIBBINDINGPROC epoxy_glVertexAttribBinding;
    PFNGLVERTEXATTRIBDIVISORPROC epoxy_glVertexAttribDivisor;
    PFNGLVERTEXATTRIBDIVISORANGLEPROC epoxy_glVertexAttribDivisorANGLE;
    PFNGLVERTEXATTRIBDIVISORARBPROC epoxy_glVertexAttribDivisorARB;
    PFNGLVERTEXATTRIBDIVISOREXTPROC epoxy_glVertexAttribDivisorEXT;
    PFNGLVERTEXATTRIBDIVISORNVPROC epoxy_glVertexAttribDivisorNV;
    PFNGLVERTEXATTRIBFORMATPROC epoxy_glVertexAttribFormat;
    PFNGLVERTEXATTRIBFORMATNVPROC epoxy_glVertexAttribFormatNV;
    PFNGLVERTEXATTRIBI1IPROC epoxy_glVertexAttribI1i;
    PFNGLVERTEXATTRIBI1IEXTPROC epoxy_glVertexAttribI1iEXT;
    PFNGLVERTEXATTRIBI1IVPROC epoxy_glVertexAttribI1iv;
    PFNGLVERTEXATTRIBI1IVEXTPROC epoxy_glVertexAttribI1ivEXT;
    PFNGLVERTEXATTRIBI1UIPROC epoxy_glVertexAttribI1ui;
    PFNGLVERTEXATTRIBI1UIEXTPROC epoxy_glVertexAttribI1uiEXT;
    PFNGLVERTEXATTRIBI1UIVPROC epoxy_glVertexAttribI1uiv;
    PFNGLVERTEXATTRIBI1UIVEXTPROC epoxy_glVertexAttribI1uivEXT;
    PFNGLVERTEXATTRIBI2IPROC epoxy_glVertexAttribI2i;
    PFNGLVERTEXATTRIBI2IEXTPROC epoxy_glVertexAttribI2iEXT;
    PFNGLVERTEXATTRIBI2IVPROC epoxy_glVertexAttribI2iv;
    PFNGLVERTEXATTRIBI2IVEXTPROC epoxy_glVertexAttribI2ivEXT;
    PFNGLVERTEXATTRIBI2UIPROC epoxy_glVertexAttribI2ui;
    PFNGLVERTEXATTRIBI2UIEXTPROC epoxy_glVertexAttribI2uiEXT;
    PFNGLVERTEXATTRIBI2UIVPROC epoxy_glVertexAttribI2uiv;
    PFNGLVERTEXATTRIBI2UIVEXTPROC epoxy_glVertexAttribI2uivEXT;
    PFNGLVERTEXATTRIBI3IPROC epoxy_glVertexAttribI3i;
    PFNGLVERTEXATTRIBI3IEXTPROC epoxy_glVertexAttribI3iEXT;
    PFNGLVERTEXATTRIBI3IVPROC epoxy_glVertexAttribI3iv;
    PFNGLVERTEXATTRIBI3IVEXTPROC epoxy_glVertexAttribI3ivEXT;
    PFNGLVERTEXATTRIBI3UIPROC epoxy_glVertexAttribI3ui;
    PFNGLVERTEXATTRIBI3UIEXTPROC epoxy_glVertexAttribI3uiEXT;
    PFNGLVERTEXATTRIBI3UIVPROC epoxy_glVertexAttribI3uiv;
    PFNGLVERTEXATTRIBI3UIVEXTPROC epoxy_glVertexAttribI3uivEXT;
    PFNGLVERTEXATTRIBI4BVPROC epoxy_glVertexAttribI4bv;
    PFNGLVERTEXATTRIBI4BVEXTPROC epoxy_glVertexAttribI4bvEXT;
    PFNGLVERTEXATTRIBI4IPROC epoxy_glVertexAttribI4i;
    PFNGLVERTEXATTRIBI4IEXTPROC epoxy_glVertexAttribI4iEXT;
    PFNGLVERTEXATTRIBI4IVPROC epoxy_glVertexAttribI4iv;
    PFNGLVERTEXATTRIBI4IVEXTPROC epoxy_glVertexAttribI4ivEXT;
    PFNGLVERTEXATTRIBI4SVPROC epoxy_glVertexAttribI4sv;
    PFNGLVERTEXATTRIBI4SVEXTPROC epoxy_glVertexAttribI4svEXT;
    PFNGLVERTEXATTRIBI4UBVPROC epoxy_glVertexAttribI4ubv;
    PFNGLVERTEXATTRIBI4UBVEXTPROC epoxy_glVertexAttribI4ubvEXT;
    PFNGLVERTEXATTRIBI4UIPROC epoxy_glVertexAttribI4ui;
    PFNGLVERTEXATTRIBI4UIEXTPROC epoxy_glVertexAttribI4uiEXT;
    PFNGLVERTEXATTRIBI4UIVPROC epoxy_glVertexAttribI4uiv;
    PFNGLVERTEXATTRIBI4UIVEXTPROC epoxy_glVertexAttribI4uivEXT;
    PFNGLVERTEXATTRIBI4USVPROC epoxy_glVertexAttribI4usv;
    PFNGLVERTEXATTRIBI4USVEXTPROC epoxy_glVertexAttribI4usvEXT;
    PFNGLVERTEXATTRIBIFORMATPROC epoxy_glVertexAttribIFormat;
    PFNGLVERTEXATTRIBIFORMATNVPROC epoxy_glVertexAttribIFormatNV;
    PFNGLVERTEXATTRIBIPOINTERPROC epoxy_glVertexAttribIPointer;
    PFNGLVERTEXATTRIBIPOINTEREXTPROC epoxy_glVertexAttribIPointerEXT;
    PFNGLVERTEXATTRIBL1DPROC epoxy_glVertexAttribL1d;
    PFNGLVERTEXATTRIBL1DEXTPROC epoxy_glVertexAttribL1dEXT;
    PFNGLVERTEXATTRIBL1DVPROC epoxy_glVertexAttribL1dv;
    PFNGLVERTEXATTRIBL1DVEXTPROC epoxy_glVertexAttribL1dvEXT;
    PFNGLVERTEXATTRIBL1I64NVPROC epoxy_glVertexAttribL1i64NV;
    PFNGLVERTEXATTRIBL1I64VNVPROC epoxy_glVertexAttribL1i64vNV;
    PFNGLVERTEXATTRIBL1UI64ARBPROC epoxy_glVertexAttribL1ui64ARB;
    PFNGLVERTEXATTRIBL1UI64NVPROC epoxy_glVertexAttribL1ui64NV;
    PFNGLVERTEXATTRIBL1UI64VARBPROC epoxy_glVertexAttribL1ui64vARB;
    PFNGLVERTEXATTRIBL1UI64VNVPROC epoxy_glVertexAttribL1ui64vNV;
    PFNGLVERTEXATTRIBL2DPROC epoxy_glVertexAttribL2d;
    PFNGLVERTEXATTRIBL2DEXTPROC epoxy_glVertexAttribL2dEXT;
    PFNGLVERTEXATTRIBL2DVPROC epoxy_glVertexAttribL2dv;
    PFNGLVERTEXATTRIBL2DVEXTPROC epoxy_glVertexAttribL2dvEXT;
    PFNGLVERTEXATTRIBL2I64NVPROC epoxy_glVertexAttribL2i64NV;
    PFNGLVERTEXATTRIBL2I64VNVPROC epoxy_glVertexAttribL2i64vNV;
    PFNGLVERTEXATTRIBL2UI64NVPROC epoxy_glVertexAttribL2ui64NV;
    PFNGLVERTEXATTRIBL2UI64VNVPROC epoxy_glVertexAttribL2ui64vNV;
    PFNGLVERTEXATTRIBL3DPROC epoxy_glVertexAttribL3d;
    PFNGLVERTEXATTRIBL3DEXTPROC epoxy_glVertexAttribL3dEXT;
    PFNGLVERTEXATTRIBL3DVPROC epoxy_glVertexAttribL3dv;
    PFNGLVERTEXATTRIBL3DVEXTPROC epoxy_glVertexAttribL3dvEXT;
    PFNGLVERTEXATTRIBL3I64NVPROC epoxy_glVertexAttribL3i64NV;
    PFNGLVERTEXATTRIBL3I64VNVPROC epoxy_glVertexAttribL3i64vNV;
    PFNGLVERTEXATTRIBL3UI64NVPROC epoxy_glVertexAttribL3ui64NV;
    PFNGLVERTEXATTRIBL3UI64VNVPROC epoxy_glVertexAttribL3ui64vNV;
    PFNGLVERTEXATTRIBL4DPROC epoxy_glVertexAttribL4d;
    PFNGLVERTEXATTRIBL4DEXTPROC epoxy_glVertexAttribL4dEXT;
    PFNGLVERTEXATTRIBL4DVPROC epoxy_glVertexAttribL4dv;
    PFNGLVERTEXATTRIBL4DVEXTPROC epoxy_glVertexAttribL4dvEXT;
    PFNGLVERTEXATTRIBL4I64NVPROC epoxy_glVertexAttribL4i64NV;
    PFNGLVERTEXATTRIBL4I64VNVPROC epoxy_glVertexAttribL4i64vNV;
    PFNGLVERTEXATTRIBL4UI64NVPROC epoxy_glVertexAttribL4ui64NV;
    PFNGLVERTEXATTRIBL4UI64VNVPROC epoxy_glVertexAttribL4ui64vNV;
    PFNGLVERTEXATTRIBLFORMATPROC epoxy_glVertexAttribLFormat;
    PFNGLVERTEXATTRIBLFORMATNVPROC epoxy_glVertexAttribLFormatNV;
    PFNGLVERTEXATTRIBLPOINTERPROC epoxy_glVertexAttribLPointer;
    PFNGLVERTEXATTRIBLPOINTEREXTPROC epoxy_glVertexAttribLPointerEXT;
    PFNGLVERTEXATTRIBP1UIPROC epoxy_glVertexAttribP1ui;
    PFNGLVERTEXATTRIBP1UIVPROC epoxy_glVertexAttribP1uiv;
    PFNGLVERTEXATTRIBP2UIPROC epoxy_glVertexAttribP2ui;
    PFNGLVERTEXATTRIBP2UIVPROC epoxy_glVertexAttribP2uiv;
    PFNGLVERTEXATTRIBP3UIPROC epoxy_glVertexAttribP3ui;
    PFNGLVERTEXATTRIBP3UIVPROC epoxy_glVertexAttribP3uiv;
    PFNGLVERTEXATTRIBP4UIPROC epoxy_glVertexAttribP4ui;
    PFNGLVERTEXATTRIBP4UIVPROC epoxy_glVertexAttribP4uiv;
    PFNGLVERTEXATTRIBPARAMETERIAMDPROC epoxy_glVertexAttribParameteriAMD;
    PFNGLVERTEXATTRIBPOINTERPROC epoxy_glVertexAttribPointer;
    PFNGLVERTEXATTRIBPOINTERARBPROC epoxy_glVertexAttribPointerARB;
    PFNGLVERTEXATTRIBPOINTERNVPROC epoxy_glVertexAttribPointerNV;
    PFNGLVERTEXATTRIBS1DVNVPROC epoxy_glVertexAttribs1dvNV;
    PFNGLVERTEXATTRIBS1FVNVPROC epoxy_glVertexAttribs1fvNV;
    PFNGLVERTEXATTRIBS1HVNVPROC epoxy_glVertexAttribs1hvNV;
    PFNGLVERTEXATTRIBS1SVNVPROC epoxy_glVertexAttribs1svNV;
    PFNGLVERTEXATTRIBS2DVNVPROC epoxy_glVertexAttribs2dvNV;
    PFNGLVERTEXATTRIBS2FVNVPROC epoxy_glVertexAttribs2fvNV;
    PFNGLVERTEXATTRIBS2HVNVPROC epoxy_glVertexAttribs2hvNV;
    PFNGLVERTEXATTRIBS2SVNVPROC epoxy_glVertexAttribs2svNV;
    PFNGLVERTEXATTRIBS3DVNVPROC epoxy_glVertexAttribs3dvNV;
    PFNGLVERTEXATTRIBS3FVNVPROC epoxy_glVertexAttribs3fvNV;
    PFNGLVERTEXATTRIBS3HVNVPROC epoxy_glVertexAttribs3hvNV;
    PFNGLVERTEXATTRIBS3SVNVPROC epoxy_glVertexAttribs3svNV;
    PFNGLVERTEXATTRIBS4DVNVPROC epoxy_glVertexAttribs4dvNV;
    PFNGLVERTEXATTRIBS4FVNVPROC epoxy_glVertexAttribs4fvNV;
    PFNGLVERTEXATTRIBS4HVNVPROC epoxy_glVertexAttribs4hvNV;
    PFNGLVERTEXATTRIBS4SVNVPROC epoxy_glVertexAttribs4svNV;
    PFNGLVERTEXATTRIBS4UBVNVPROC epoxy_glVertexAttribs4ubvNV;
    PFNGLVERTEXBINDINGDIVISORPROC epoxy_glVertexBindingDivisor;
    PFNGLVERTEXBLENDARBPROC epoxy_glVertexBlendARB;
    PFNGLVERTEXBLENDENVFATIPROC epoxy_glVertexBlendEnvfATI;
    PFNGLVERTEXBLENDENVIATIPROC epoxy_glVertexBlendEnviATI;
    PFNGLVERTEXFORMATNVPROC epoxy_glVertexFormatNV;
    PFNGLVERTEXP2UIPROC epoxy_glVertexP2ui;
    PFNGLVERTEXP2UIVPROC epoxy_glVertexP2uiv;
    PFNGLVERTEXP3UIPROC epoxy_glVertexP3ui;
    PFNGLVERTEXP3UIVPROC epoxy_glVertexP3uiv;
    PFNGLVERTEXP4UIPROC epoxy_glVertexP4ui;
    PFNGLVERTEXP4UIVPROC epoxy_glVertexP4uiv;
    PFNGLVERTEXPOINTERPROC epoxy_glVertexPointer;
    PFNGLVERTEXPOINTEREXTPROC epoxy_glVertexPointerEXT;
    PFNGLVERTEXPOINTERLISTIBMPROC epoxy_glVertexPointerListIBM;
    PFNGLVERTEXPOINTERVINTELPROC epoxy_glVertexPointervINTEL;
    PFNGLVERTEXSTREAM1DATIPROC epoxy_glVertexStream1dATI;
    PFNGLVERTEXSTREAM1DVATIPROC epoxy_glVertexStream1dvATI;
    PFNGLVERTEXSTREAM1FATIPROC epoxy_glVertexStream1fATI;
    PFNGLVERTEXSTREAM1FVATIPROC epoxy_glVertexStream1fvATI;
    PFNGLVERTEXSTREAM1IATIPROC epoxy_glVertexStream1iATI;
    PFNGLVERTEXSTREAM1IVATIPROC epoxy_glVertexStream1ivATI;
    PFNGLVERTEXSTREAM1SATIPROC epoxy_glVertexStream1sATI;
    PFNGLVERTEXSTREAM1SVATIPROC epoxy_glVertexStream1svATI;
    PFNGLVERTEXSTREAM2DATIPROC epoxy_glVertexStream2dATI;
    PFNGLVERTEXSTREAM2DVATIPROC epoxy_glVertexStream2dvATI;
    PFNGLVERTEXSTREAM2FATIPROC epoxy_glVertexStream2fATI;
    PFNGLVERTEXSTREAM2FVATIPROC epoxy_glVertexStream2fvATI;
    PFNGLVERTEXSTREAM2IATIPROC epoxy_glVertexStream2iATI;
    PFNGLVERTEXSTREAM2IVATIPROC epoxy_glVertexStream2ivATI;
    PFNGLVERTEXSTREAM2SATIPROC epoxy_glVertexStream2sATI;
    PFNGLVERTEXSTREAM2SVATIPROC epoxy_glVertexStream2svATI;
    PFNGLVERTEXSTREAM3DATIPROC epoxy_glVertexStream3dATI;
    PFNGLVERTEXSTREAM3DVATIPROC epoxy_glVertexStream3dvATI;
    PFNGLVERTEXSTREAM3FATIPROC epoxy_glVertexStream3fATI;
    PFNGLVERTEXSTREAM3FVATIPROC epoxy_glVertexStream3fvATI;
    PFNGLVERTEXSTREAM3IATIPROC epoxy_glVertexStream3iATI;
    PFNGLVERTEXSTREAM3IVATIPROC epoxy_glVertexStream3ivATI;
    PFNGLVERTEXSTREAM3SATIPROC epoxy_glVertexStream3sATI;
    PFNGLVERTEXSTREAM3SVATIPROC epoxy_glVertexStream3svATI;
    PFNGLVERTEXSTREAM4DATIPROC epoxy_glVertexStream4dATI;
    PFNGLVERTEXSTREAM4DVATIPROC epoxy_glVertexStream4dvATI;
    PFNGLVERTEXSTREAM4FATIPROC epoxy_glVertexStream4fATI;
    PFNGLVERTEXSTREAM4FVATIPROC epoxy_glVertexStream4fvATI;
    PFNGLVERTEXSTREAM4IATIPROC epoxy_glVertexStream4iATI;
    PFNGLVERTEXSTREAM4IVATIPROC epoxy_glVertexStream4ivATI;
    PFNGLVERTEXSTREAM4SATIPROC epoxy_glVertexStream4sATI;
    PFNGLVERTEXSTREAM4SVATIPROC epoxy_glVertexStream4svATI;
    PFNGLVERTEXWEIGHTPOINTEREXTPROC epoxy_glVertexWeightPointerEXT;
    PFNGLVERTEXWEIGHTFEXTPROC epoxy_glVertexWeightfEXT;
    PFNGLVERTEXWEIGHTFVEXTPROC epoxy_glVertexWeightfvEXT;
    PFNGLVERTEXWEIGHTHNVPROC epoxy_glVertexWeighthNV;
    PFNGLVERTEXWEIGHTHVNVPROC epoxy_glVertexWeighthvNV;
    PFNGLVIDEOCAPTURENVPROC epoxy_glVideoCaptureNV;
    PFNGLVIDEOCAPTURESTREAMPARAMETERDVNVPROC epoxy_glVideoCaptureStreamParameterdvNV;
    PFNGLVIDEOCAPTURESTREAMPARAMETERFVNVPROC epoxy_glVideoCaptureStreamParameterfvNV;
    PFNGLVIDEOCAPTURESTREAMPARAMETERIVNVPROC epoxy_glVideoCaptureStreamParameterivNV;
    PFNGLVIEWPORTPROC epoxy_glViewport;
    PFNGLVIEWPORTARRAYVPROC epoxy_glViewportArrayv;
    PFNGLVIEWPORTARRAYVNVPROC epoxy_glViewportArrayvNV;
    PFNGLVIEWPORTARRAYVOESPROC epoxy_glViewportArrayvOES;
    PFNGLVIEWPORTINDEXEDFPROC epoxy_glViewportIndexedf;
    PFNGLVIEWPORTINDEXEDFNVPROC epoxy_glViewportIndexedfNV;
    PFNGLVIEWPORTINDEXEDFOESPROC epoxy_glViewportIndexedfOES;
    PFNGLVIEWPORTINDEXEDFVPROC epoxy_glViewportIndexedfv;
    PFNGLVIEWPORTINDEXEDFVNVPROC epoxy_glViewportIndexedfvNV;
    PFNGLVIEWPORTINDEXEDFVOESPROC epoxy_glViewportIndexedfvOES;
    PFNGLVIEWPORTPOSITIONWSCALENVPROC epoxy_glViewportPositionWScaleNV;
    PFNGLVIEWPORTSWIZZLENVPROC epoxy_glViewportSwizzleNV;
    PFNGLWAITSEMAPHOREEXTPROC epoxy_glWaitSemaphoreEXT;
    PFNGLWAITSYNCPROC epoxy_glWaitSync;
    PFNGLWAITSYNCAPPLEPROC epoxy_glWaitSyncAPPLE;
    PFNGLWAITVKSEMAPHORENVPROC epoxy_glWaitVkSemaphoreNV;
    PFNGLWEIGHTPATHSNVPROC epoxy_glWeightPathsNV;
    PFNGLWEIGHTPOINTERARBPROC epoxy_glWeightPointerARB;
    PFNGLWEIGHTPOINTEROESPROC epoxy_glWeightPointerOES;
    PFNGLWEIGHTBVARBPROC epoxy_glWeightbvARB;
    PFNGLWEIGHTDVARBPROC epoxy_glWeightdvARB;
    PFNGLWEIGHTFVARBPROC epoxy_glWeightfvARB;
    PFNGLWEIGHTIVARBPROC epoxy_glWeightivARB;
    PFNGLWEIGHTSVARBPROC epoxy_glWeightsvARB;
    PFNGLWEIGHTUBVARBPROC epoxy_glWeightubvARB;
    PFNGLWEIGHTUIVARBPROC epoxy_glWeightuivARB;
    PFNGLWEIGHTUSVARBPROC epoxy_glWeightusvARB;
    PFNGLWINDOWPOS2DPROC epoxy_glWindowPos2d;
    PFNGLWINDOWPOS2DARBPROC epoxy_glWindowPos2dARB;
    PFNGLWINDOWPOS2DMESAPROC epoxy_glWindowPos2dMESA;
    PFNGLWINDOWPOS2DVPROC epoxy_glWindowPos2dv;
    PFNGLWINDOWPOS2DVARBPROC epoxy_glWindowPos2dvARB;
    PFNGLWINDOWPOS2DVMESAPROC epoxy_glWindowPos2dvMESA;
    PFNGLWINDOWPOS2FPROC epoxy_glWindowPos2f;
    PFNGLWINDOWPOS2FARBPROC epoxy_glWindowPos2fARB;
    PFNGLWINDOWPOS2FMESAPROC epoxy_glWindowPos2fMESA;
    PFNGLWINDOWPOS2FVPROC epoxy_glWindowPos2fv;
    PFNGLWINDOWPOS2FVARBPROC epoxy_glWindowPos2fvARB;
    PFNGLWINDOWPOS2FVMESAPROC epoxy_glWindowPos2fvMESA;
    PFNGLWINDOWPOS2IPROC epoxy_glWindowPos2i;
    PFNGLWINDOWPOS2IARBPROC epoxy_glWindowPos2iARB;
    PFNGLWINDOWPOS2IMESAPROC epoxy_glWindowPos2iMESA;
    PFNGLWINDOWPOS2IVPROC epoxy_glWindowPos2iv;
    PFNGLWINDOWPOS2IVARBPROC epoxy_glWindowPos2ivARB;
    PFNGLWINDOWPOS2IVMESAPROC epoxy_glWindowPos2ivMESA;
    PFNGLWINDOWPOS2SPROC epoxy_glWindowPos2s;
    PFNGLWINDOWPOS2SARBPROC epoxy_glWindowPos2sARB;
    PFNGLWINDOWPOS2SMESAPROC epoxy_glWindowPos2sMESA;
    PFNGLWINDOWPOS2SVPROC epoxy_glWindowPos2sv;
    PFNGLWINDOWPOS2SVARBPROC epoxy_glWindowPos2svARB;
    PFNGLWINDOWPOS2SVMESAPROC epoxy_glWindowPos2svMESA;
    PFNGLWINDOWPOS3DPROC epoxy_glWindowPos3d;
    PFNGLWINDOWPOS3DARBPROC epoxy_glWindowPos3dARB;
    PFNGLWINDOWPOS3DMESAPROC epoxy_glWindowPos3dMESA;
    PFNGLWINDOWPOS3DVPROC epoxy_glWindowPos3dv;
    PFNGLWINDOWPOS3DVARBPROC epoxy_glWindowPos3dvARB;
    PFNGLWINDOWPOS3DVMESAPROC epoxy_glWindowPos3dvMESA;
    PFNGLWINDOWPOS3FPROC epoxy_glWindowPos3f;
    PFNGLWINDOWPOS3FARBPROC epoxy_glWindowPos3fARB;
    PFNGLWINDOWPOS3FMESAPROC epoxy_glWindowPos3fMESA;
    PFNGLWINDOWPOS3FVPROC epoxy_glWindowPos3fv;
    PFNGLWINDOWPOS3FVARBPROC epoxy_glWindowPos3fvARB;
    PFNGLWINDOWPOS3FVMESAPROC epoxy_glWindowPos3fvMESA;
    PFNGLWINDOWPOS3IPROC epoxy_glWindowPos3i;
    PFNGLWINDOWPOS3IARBPROC epoxy_glWindowPos3iARB;
    PFNGLWINDOWPOS3IMESAPROC epoxy_glWindowPos3iMESA;
    PFNGLWINDOWPOS3IVPROC epoxy_glWindowPos3iv;
    PFNGLWINDOWPOS3IVARBPROC epoxy_glWindowPos3ivARB;
    PFNGLWINDOWPOS3IVMESAPROC epoxy_glWindowPos3ivMESA;
    PFNGLWINDOWPOS3SPROC epoxy_glWindowPos3s;
    PFNGLWINDOWPOS3SARBPROC epoxy_glWindowPos3sARB;
    PFNGLWINDOWPOS3SMESAPROC epoxy_glWindowPos3sMESA;
    PFNGLWINDOWPOS3SVPROC epoxy_glWindowPos3sv;
    PFNGLWINDOWPOS3SVARBPROC epoxy_glWindowPos3svARB;
    PFNGLWINDOWPOS3SVMESAPROC epoxy_glWindowPos3svMESA;
    PFNGLWINDOWPOS4DMESAPROC epoxy_glWindowPos4dMESA;
    PFNGLWINDOWPOS4DVMESAPROC epoxy_glWindowPos4dvMESA;
    PFNGLWINDOWPOS4FMESAPROC epoxy_glWindowPos4fMESA;
    PFNGLWINDOWPOS4FVMESAPROC epoxy_glWindowPos4fvMESA;
    PFNGLWINDOWPOS4IMESAPROC epoxy_glWindowPos4iMESA;
    PFNGLWINDOWPOS4IVMESAPROC epoxy_glWindowPos4ivMESA;
    PFNGLWINDOWPOS4SMESAPROC epoxy_glWindowPos4sMESA;
    PFNGLWINDOWPOS4SVMESAPROC epoxy_glWindowPos4svMESA;
    PFNGLWINDOWRECTANGLESEXTPROC epoxy_glWindowRectanglesEXT;
    PFNGLWRITEMASKEXTPROC epoxy_glWriteMaskEXT;
};

#if USING_DISPATCH_TABLE
static inline struct dispatch_table *
get_dispatch_table(void);

#endif

enum gl_provider {
    gl_provider_terminator = 0,
    Desktop_OpenGL_1_0,
    Desktop_OpenGL_1_1,
    Desktop_OpenGL_1_2,
    Desktop_OpenGL_1_3,
    Desktop_OpenGL_1_4,
    Desktop_OpenGL_1_5,
    Desktop_OpenGL_2_0,
    Desktop_OpenGL_2_1,
    Desktop_OpenGL_3_0,
    Desktop_OpenGL_3_1,
    Desktop_OpenGL_3_2,
    Desktop_OpenGL_3_3,
    Desktop_OpenGL_4_0,
    Desktop_OpenGL_4_1,
    Desktop_OpenGL_4_2,
    Desktop_OpenGL_4_3,
    Desktop_OpenGL_4_4,
    Desktop_OpenGL_4_5,
    Desktop_OpenGL_4_6,
    GL_extension_GL_3DFX_tbuffer,
    GL_extension_GL_AMD_debug_output,
    GL_extension_GL_AMD_draw_buffers_blend,
    GL_extension_GL_AMD_framebuffer_sample_positions,
    GL_extension_GL_AMD_gpu_shader_int64,
    GL_extension_GL_AMD_interleaved_elements,
    GL_extension_GL_AMD_multi_draw_indirect,
    GL_extension_GL_AMD_name_gen_delete,
    GL_extension_GL_AMD_occlusion_query_event,
    GL_extension_GL_AMD_performance_monitor,
    GL_extension_GL_AMD_sample_positions,
    GL_extension_GL_AMD_sparse_texture,
    GL_extension_GL_AMD_stencil_operation_extended,
    GL_extension_GL_AMD_vertex_shader_tessellator,
    GL_extension_GL_ANGLE_framebuffer_blit,
    GL_extension_GL_ANGLE_framebuffer_multisample,
    GL_extension_GL_ANGLE_instanced_arrays,
    GL_extension_GL_ANGLE_translated_shader_source,
    GL_extension_GL_APPLE_copy_texture_levels,
    GL_extension_GL_APPLE_element_array,
    GL_extension_GL_APPLE_fence,
    GL_extension_GL_APPLE_flush_buffer_range,
    GL_extension_GL_APPLE_framebuffer_multisample,
    GL_extension_GL_APPLE_object_purgeable,
    GL_extension_GL_APPLE_sync,
    GL_extension_GL_APPLE_texture_range,
    GL_extension_GL_APPLE_vertex_array_object,
    GL_extension_GL_APPLE_vertex_array_range,
    GL_extension_GL_APPLE_vertex_program_evaluators,
    GL_extension_GL_ARB_ES2_compatibility,
    GL_extension_GL_ARB_ES3_1_compatibility,
    GL_extension_GL_ARB_ES3_2_compatibility,
    GL_extension_GL_ARB_base_instance,
    GL_extension_GL_ARB_bindless_texture,
    GL_extension_GL_ARB_blend_func_extended,
    GL_extension_GL_ARB_buffer_storage,
    GL_extension_GL_ARB_cl_event,
    GL_extension_GL_ARB_clear_buffer_object,
    GL_extension_GL_ARB_clear_texture,
    GL_extension_GL_ARB_clip_control,
    GL_extension_GL_ARB_color_buffer_float,
    GL_extension_GL_ARB_compute_shader,
    GL_extension_GL_ARB_compute_variable_group_size,
    GL_extension_GL_ARB_copy_buffer,
    GL_extension_GL_ARB_copy_image,
    GL_extension_GL_ARB_debug_output,
    GL_extension_GL_ARB_direct_state_access,
    GL_extension_GL_ARB_draw_buffers,
    GL_extension_GL_ARB_draw_buffers_blend,
    GL_extension_GL_ARB_draw_elements_base_vertex,
    GL_extension_GL_ARB_draw_indirect,
    GL_extension_GL_ARB_draw_instanced,
    GL_extension_GL_ARB_fragment_program,
    GL_extension_GL_ARB_framebuffer_no_attachments,
    GL_extension_GL_ARB_framebuffer_object,
    GL_extension_GL_ARB_geometry_shader4,
    GL_extension_GL_ARB_get_program_binary,
    GL_extension_GL_ARB_get_texture_sub_image,
    GL_extension_GL_ARB_gl_spirv,
    GL_extension_GL_ARB_gpu_shader_fp64,
    GL_extension_GL_ARB_gpu_shader_int64,
    GL_extension_GL_ARB_imaging,
    GL_extension_GL_ARB_indirect_parameters,
    GL_extension_GL_ARB_instanced_arrays,
    GL_extension_GL_ARB_internalformat_query2,
    GL_extension_GL_ARB_internalformat_query,
    GL_extension_GL_ARB_invalidate_subdata,
    GL_extension_GL_ARB_map_buffer_range,
    GL_extension_GL_ARB_matrix_palette,
    GL_extension_GL_ARB_multi_bind,
    GL_extension_GL_ARB_multi_draw_indirect,
    GL_extension_GL_ARB_multisample,
    GL_extension_GL_ARB_multitexture,
    GL_extension_GL_ARB_occlusion_query,
    GL_extension_GL_ARB_parallel_shader_compile,
    GL_extension_GL_ARB_point_parameters,
    GL_extension_GL_ARB_polygon_offset_clamp,
    GL_extension_GL_ARB_program_interface_query,
    GL_extension_GL_ARB_provoking_vertex,
    GL_extension_GL_ARB_robustness,
    GL_extension_GL_ARB_sample_locations,
    GL_extension_GL_ARB_sample_shading,
    GL_extension_GL_ARB_sampler_objects,
    GL_extension_GL_ARB_separate_shader_objects,
    GL_extension_GL_ARB_shader_atomic_counters,
    GL_extension_GL_ARB_shader_image_load_store,
    GL_extension_GL_ARB_shader_objects,
    GL_extension_GL_ARB_shader_storage_buffer_object,
    GL_extension_GL_ARB_shader_subroutine,
    GL_extension_GL_ARB_shading_language_include,
    GL_extension_GL_ARB_sparse_buffer,
    GL_extension_GL_ARB_sparse_texture,
    GL_extension_GL_ARB_sync,
    GL_extension_GL_ARB_tessellation_shader,
    GL_extension_GL_ARB_texture_barrier,
    GL_extension_GL_ARB_texture_buffer_object,
    GL_extension_GL_ARB_texture_buffer_range,
    GL_extension_GL_ARB_texture_compression,
    GL_extension_GL_ARB_texture_multisample,
    GL_extension_GL_ARB_texture_storage,
    GL_extension_GL_ARB_texture_storage_multisample,
    GL_extension_GL_ARB_texture_view,
    GL_extension_GL_ARB_timer_query,
    GL_extension_GL_ARB_transform_feedback2,
    GL_extension_GL_ARB_transform_feedback3,
    GL_extension_GL_ARB_transform_feedback_instanced,
    GL_extension_GL_ARB_transpose_matrix,
    GL_extension_GL_ARB_uniform_buffer_object,
    GL_extension_GL_ARB_vertex_array_object,
    GL_extension_GL_ARB_vertex_attrib_64bit,
    GL_extension_GL_ARB_vertex_attrib_binding,
    GL_extension_GL_ARB_vertex_blend,
    GL_extension_GL_ARB_vertex_buffer_object,
    GL_extension_GL_ARB_vertex_program,
    GL_extension_GL_ARB_vertex_shader,
    GL_extension_GL_ARB_vertex_type_2_10_10_10_rev,
    GL_extension_GL_ARB_viewport_array,
    GL_extension_GL_ARB_window_pos,
    GL_extension_GL_ATI_draw_buffers,
    GL_extension_GL_ATI_element_array,
    GL_extension_GL_ATI_envmap_bumpmap,
    GL_extension_GL_ATI_fragment_shader,
    GL_extension_GL_ATI_map_object_buffer,
    GL_extension_GL_ATI_pn_triangles,
    GL_extension_GL_ATI_separate_stencil,
    GL_extension_GL_ATI_vertex_array_object,
    GL_extension_GL_ATI_vertex_attrib_array_object,
    GL_extension_GL_ATI_vertex_streams,
    GL_extension_GL_EXT_base_instance,
    GL_extension_GL_EXT_bindable_uniform,
    GL_extension_GL_EXT_blend_color,
    GL_extension_GL_EXT_blend_equation_separate,
    GL_extension_GL_EXT_blend_func_extended,
    GL_extension_GL_EXT_blend_func_separate,
    GL_extension_GL_EXT_blend_minmax,
    GL_extension_GL_EXT_buffer_storage,
    GL_extension_GL_EXT_clear_texture,
    GL_extension_GL_EXT_clip_control,
    GL_extension_GL_EXT_color_subtable,
    GL_extension_GL_EXT_compiled_vertex_array,
    GL_extension_GL_EXT_convolution,
    GL_extension_GL_EXT_coordinate_frame,
    GL_extension_GL_EXT_copy_image,
    GL_extension_GL_EXT_copy_texture,
    GL_extension_GL_EXT_cull_vertex,
    GL_extension_GL_EXT_debug_label,
    GL_extension_GL_EXT_debug_marker,
    GL_extension_GL_EXT_depth_bounds_test,
    GL_extension_GL_EXT_direct_state_access,
    GL_extension_GL_EXT_discard_framebuffer,
    GL_extension_GL_EXT_disjoint_timer_query,
    GL_extension_GL_EXT_draw_buffers2,
    GL_extension_GL_EXT_draw_buffers,
    GL_extension_GL_EXT_draw_buffers_indexed,
    GL_extension_GL_EXT_draw_elements_base_vertex,
    GL_extension_GL_EXT_draw_instanced,
    GL_extension_GL_EXT_draw_range_elements,
    GL_extension_GL_EXT_draw_transform_feedback,
    GL_extension_GL_EXT_external_buffer,
    GL_extension_GL_EXT_fog_coord,
    GL_extension_GL_EXT_framebuffer_blit,
    GL_extension_GL_EXT_framebuffer_multisample,
    GL_extension_GL_EXT_framebuffer_object,
    GL_extension_GL_EXT_geometry_shader4,
    GL_extension_GL_EXT_geometry_shader,
    GL_extension_GL_EXT_gpu_program_parameters,
    GL_extension_GL_EXT_gpu_shader4,
    GL_extension_GL_EXT_histogram,
    GL_extension_GL_EXT_index_func,
    GL_extension_GL_EXT_index_material,
    GL_extension_GL_EXT_instanced_arrays,
    GL_extension_GL_EXT_light_texture,
    GL_extension_GL_EXT_map_buffer_range,
    GL_extension_GL_EXT_memory_object,
    GL_extension_GL_EXT_memory_object_fd,
    GL_extension_GL_EXT_memory_object_win32,
    GL_extension_GL_EXT_multi_draw_arrays,
    GL_extension_GL_EXT_multi_draw_indirect,
    GL_extension_GL_EXT_multisample,
    GL_extension_GL_EXT_multisampled_render_to_texture,
    GL_extension_GL_EXT_multiview_draw_buffers,
    GL_extension_GL_EXT_occlusion_query_boolean,
    GL_extension_GL_EXT_paletted_texture,
    GL_extension_GL_EXT_pixel_transform,
    GL_extension_GL_EXT_point_parameters,
    GL_extension_GL_EXT_polygon_offset,
    GL_extension_GL_EXT_polygon_offset_clamp,
    GL_extension_GL_EXT_primitive_bounding_box,
    GL_extension_GL_EXT_provoking_vertex,
    GL_extension_GL_EXT_raster_multisample,
    GL_extension_GL_EXT_robustness,
    GL_extension_GL_EXT_secondary_color,
    GL_extension_GL_EXT_semaphore,
    GL_extension_GL_EXT_semaphore_fd,
    GL_extension_GL_EXT_semaphore_win32,
    GL_extension_GL_EXT_separate_shader_objects,
    GL_extension_GL_EXT_shader_image_load_store,
    GL_extension_GL_EXT_shader_pixel_local_storage2,
    GL_extension_GL_EXT_sparse_texture,
    GL_extension_GL_EXT_stencil_clear_tag,
    GL_extension_GL_EXT_stencil_two_side,
    GL_extension_GL_EXT_subtexture,
    GL_extension_GL_EXT_tessellation_shader,
    GL_extension_GL_EXT_texture3D,
    GL_extension_GL_EXT_texture_array,
    GL_extension_GL_EXT_texture_border_clamp,
    GL_extension_GL_EXT_texture_buffer,
    GL_extension_GL_EXT_texture_buffer_object,
    GL_extension_GL_EXT_texture_integer,
    GL_extension_GL_EXT_texture_object,
    GL_extension_GL_EXT_texture_perturb_normal,
    GL_extension_GL_EXT_texture_storage,
    GL_extension_GL_EXT_texture_view,
    GL_extension_GL_EXT_timer_query,
    GL_extension_GL_EXT_transform_feedback,
    GL_extension_GL_EXT_vertex_array,
    GL_extension_GL_EXT_vertex_attrib_64bit,
    GL_extension_GL_EXT_vertex_shader,
    GL_extension_GL_EXT_vertex_weighting,
    GL_extension_GL_EXT_win32_keyed_mutex,
    GL_extension_GL_EXT_window_rectangles,
    GL_extension_GL_EXT_x11_sync_object,
    GL_extension_GL_GREMEDY_frame_terminator,
    GL_extension_GL_GREMEDY_string_marker,
    GL_extension_GL_HP_image_transform,
    GL_extension_GL_IBM_multimode_draw_arrays,
    GL_extension_GL_IBM_static_data,
    GL_extension_GL_IBM_vertex_array_lists,
    GL_extension_GL_IMG_bindless_texture,
    GL_extension_GL_IMG_framebuffer_downsample,
    GL_extension_GL_IMG_multisampled_render_to_texture,
    GL_extension_GL_IMG_user_clip_plane,
    GL_extension_GL_INGR_blend_func_separate,
    GL_extension_GL_INTEL_framebuffer_CMAA,
    GL_extension_GL_INTEL_map_texture,
    GL_extension_GL_INTEL_parallel_arrays,
    GL_extension_GL_INTEL_performance_query,
    GL_extension_GL_KHR_blend_equation_advanced,
    GL_extension_GL_KHR_debug,
    GL_extension_GL_KHR_parallel_shader_compile,
    GL_extension_GL_KHR_robustness,
    GL_extension_GL_MESA_resize_buffers,
    GL_extension_GL_MESA_window_pos,
    GL_extension_GL_NVX_conditional_render,
    GL_extension_GL_NVX_linked_gpu_multicast,
    GL_extension_GL_NV_alpha_to_coverage_dither_control,
    GL_extension_GL_NV_bindless_multi_draw_indirect,
    GL_extension_GL_NV_bindless_multi_draw_indirect_count,
    GL_extension_GL_NV_bindless_texture,
    GL_extension_GL_NV_blend_equation_advanced,
    GL_extension_GL_NV_clip_space_w_scaling,
    GL_extension_GL_NV_command_list,
    GL_extension_GL_NV_conditional_render,
    GL_extension_GL_NV_conservative_raster,
    GL_extension_GL_NV_conservative_raster_dilate,
    GL_extension_GL_NV_conservative_raster_pre_snap_triangles,
    GL_extension_GL_NV_copy_buffer,
    GL_extension_GL_NV_copy_image,
    GL_extension_GL_NV_coverage_sample,
    GL_extension_GL_NV_depth_buffer_float,
    GL_extension_GL_NV_draw_buffers,
    GL_extension_GL_NV_draw_instanced,
    GL_extension_GL_NV_draw_texture,
    GL_extension_GL_NV_draw_vulkan_image,
    GL_extension_GL_NV_evaluators,
    GL_extension_GL_NV_explicit_multisample,
    GL_extension_GL_NV_fence,
    GL_extension_GL_NV_fragment_coverage_to_color,
    GL_extension_GL_NV_fragment_program,
    GL_extension_GL_NV_framebuffer_blit,
    GL_extension_GL_NV_framebuffer_mixed_samples,
    GL_extension_GL_NV_framebuffer_multisample,
    GL_extension_GL_NV_framebuffer_multisample_coverage,
    GL_extension_GL_NV_geometry_program4,
    GL_extension_GL_NV_gpu_multicast,
    GL_extension_GL_NV_gpu_program4,
    GL_extension_GL_NV_gpu_program5,
    GL_extension_GL_NV_gpu_shader5,
    GL_extension_GL_NV_half_float,
    GL_extension_GL_NV_instanced_arrays,
    GL_extension_GL_NV_internalformat_sample_query,
    GL_extension_GL_NV_non_square_matrices,
    GL_extension_GL_NV_occlusion_query,
    GL_extension_GL_NV_parameter_buffer_object,
    GL_extension_GL_NV_path_rendering,
    GL_extension_GL_NV_pixel_data_range,
    GL_extension_GL_NV_point_sprite,
    GL_extension_GL_NV_polygon_mode,
    GL_extension_GL_NV_present_video,
    GL_extension_GL_NV_primitive_restart,
    GL_extension_GL_NV_query_resource,
    GL_extension_GL_NV_query_resource_tag,
    GL_extension_GL_NV_read_buffer,
    GL_extension_GL_NV_register_combiners2,
    GL_extension_GL_NV_register_combiners,
    GL_extension_GL_NV_sample_locations,
    GL_extension_GL_NV_shader_buffer_load,
    GL_extension_GL_NV_texture_barrier,
    GL_extension_GL_NV_texture_multisample,
    GL_extension_GL_NV_transform_feedback2,
    GL_extension_GL_NV_transform_feedback,
    GL_extension_GL_NV_vdpau_interop,
    GL_extension_GL_NV_vertex_array_range,
    GL_extension_GL_NV_vertex_attrib_integer_64bit,
    GL_extension_GL_NV_vertex_buffer_unified_memory,
    GL_extension_GL_NV_vertex_program4,
    GL_extension_GL_NV_vertex_program,
    GL_extension_GL_NV_video_capture,
    GL_extension_GL_NV_viewport_array,
    GL_extension_GL_NV_viewport_swizzle,
    GL_extension_GL_OES_EGL_image,
    GL_extension_GL_OES_blend_equation_separate,
    GL_extension_GL_OES_blend_func_separate,
    GL_extension_GL_OES_blend_subtract,
    GL_extension_GL_OES_byte_coordinates,
    GL_extension_GL_OES_copy_image,
    GL_extension_GL_OES_draw_buffers_indexed,
    GL_extension_GL_OES_draw_elements_base_vertex,
    GL_extension_GL_OES_draw_texture,
    GL_extension_GL_OES_fixed_point,
    GL_extension_GL_OES_framebuffer_object,
    GL_extension_GL_OES_geometry_shader,
    GL_extension_GL_OES_get_program_binary,
    GL_extension_GL_OES_mapbuffer,
    GL_extension_GL_OES_matrix_palette,
    GL_extension_GL_OES_point_size_array,
    GL_extension_GL_OES_primitive_bounding_box,
    GL_extension_GL_OES_query_matrix,
    GL_extension_GL_OES_sample_shading,
    GL_extension_GL_OES_single_precision,
    GL_extension_GL_OES_tessellation_shader,
    GL_extension_GL_OES_texture_3D,
    GL_extension_GL_OES_texture_border_clamp,
    GL_extension_GL_OES_texture_buffer,
    GL_extension_GL_OES_texture_cube_map,
    GL_extension_GL_OES_texture_storage_multisample_2d_array,
    GL_extension_GL_OES_texture_view,
    GL_extension_GL_OES_vertex_array_object,
    GL_extension_GL_OES_viewport_array,
    GL_extension_GL_OVR_multiview,
    GL_extension_GL_OVR_multiview_multisampled_render_to_texture,
    GL_extension_GL_PGI_misc_hints,
    GL_extension_GL_QCOM_alpha_test,
    GL_extension_GL_QCOM_driver_control,
    GL_extension_GL_QCOM_extended_get2,
    GL_extension_GL_QCOM_extended_get,
    GL_extension_GL_QCOM_framebuffer_foveated,
    GL_extension_GL_QCOM_shader_framebuffer_fetch_noncoherent,
    GL_extension_GL_QCOM_texture_foveated,
    GL_extension_GL_QCOM_tiled_rendering,
    GL_extension_GL_SGIS_detail_texture,
    GL_extension_GL_SGIS_fog_function,
    GL_extension_GL_SGIS_multisample,
    GL_extension_GL_SGIS_pixel_texture,
    GL_extension_GL_SGIS_point_parameters,
    GL_extension_GL_SGIS_sharpen_texture,
    GL_extension_GL_SGIS_texture4D,
    GL_extension_GL_SGIS_texture_color_mask,
    GL_extension_GL_SGIS_texture_filter4,
    GL_extension_GL_SGIX_async,
    GL_extension_GL_SGIX_flush_raster,
    GL_extension_GL_SGIX_fragment_lighting,
    GL_extension_GL_SGIX_framezoom,
    GL_extension_GL_SGIX_igloo_interface,
    GL_extension_GL_SGIX_instruments,
    GL_extension_GL_SGIX_list_priority,
    GL_extension_GL_SGIX_pixel_texture,
    GL_extension_GL_SGIX_polynomial_ffd,
    GL_extension_GL_SGIX_reference_plane,
    GL_extension_GL_SGIX_sprite,
    GL_extension_GL_SGIX_tag_sample_buffer,
    GL_extension_GL_SGI_color_table,
    GL_extension_GL_SUNX_constant_data,
    GL_extension_GL_SUN_global_alpha,
    GL_extension_GL_SUN_mesh_array,
    GL_extension_GL_SUN_triangle_list,
    GL_extension_GL_SUN_vertex,
    OpenGL_ES_1_0,
    OpenGL_ES_2_0,
    OpenGL_ES_3_0,
    OpenGL_ES_3_1,
    OpenGL_ES_3_2,
    always_present,
} PACKED;
ENDPACKED

static const char *enum_string =
    "Desktop OpenGL 1.0\0"
    "Desktop OpenGL 1.1\0"
    "Desktop OpenGL 1.2\0"
    "Desktop OpenGL 1.3\0"
    "Desktop OpenGL 1.4\0"
    "Desktop OpenGL 1.5\0"
    "Desktop OpenGL 2.0\0"
    "Desktop OpenGL 2.1\0"
    "Desktop OpenGL 3.0\0"
    "Desktop OpenGL 3.1\0"
    "Desktop OpenGL 3.2\0"
    "Desktop OpenGL 3.3\0"
    "Desktop OpenGL 4.0\0"
    "Desktop OpenGL 4.1\0"
    "Desktop OpenGL 4.2\0"
    "Desktop OpenGL 4.3\0"
    "Desktop OpenGL 4.4\0"
    "Desktop OpenGL 4.5\0"
    "Desktop OpenGL 4.6\0"
    "GL extension \"GL_3DFX_tbuffer\"\0"
    "GL extension \"GL_AMD_debug_output\"\0"
    "GL extension \"GL_AMD_draw_buffers_blend\"\0"
    "GL extension \"GL_AMD_framebuffer_sample_positions\"\0"
    "GL extension \"GL_AMD_gpu_shader_int64\"\0"
    "GL extension \"GL_AMD_interleaved_elements\"\0"
    "GL extension \"GL_AMD_multi_draw_indirect\"\0"
    "GL extension \"GL_AMD_name_gen_delete\"\0"
    "GL extension \"GL_AMD_occlusion_query_event\"\0"
    "GL extension \"GL_AMD_performance_monitor\"\0"
    "GL extension \"GL_AMD_sample_positions\"\0"
    "GL extension \"GL_AMD_sparse_texture\"\0"
    "GL extension \"GL_AMD_stencil_operation_extended\"\0"
    "GL extension \"GL_AMD_vertex_shader_tessellator\"\0"
    "GL extension \"GL_ANGLE_framebuffer_blit\"\0"
    "GL extension \"GL_ANGLE_framebuffer_multisample\"\0"
    "GL extension \"GL_ANGLE_instanced_arrays\"\0"
    "GL extension \"GL_ANGLE_translated_shader_source\"\0"
    "GL extension \"GL_APPLE_copy_texture_levels\"\0"
    "GL extension \"GL_APPLE_element_array\"\0"
    "GL extension \"GL_APPLE_fence\"\0"
    "GL extension \"GL_APPLE_flush_buffer_range\"\0"
    "GL extension \"GL_APPLE_framebuffer_multisample\"\0"
    "GL extension \"GL_APPLE_object_purgeable\"\0"
    "GL extension \"GL_APPLE_sync\"\0"
    "GL extension \"GL_APPLE_texture_range\"\0"
    "GL extension \"GL_APPLE_vertex_array_object\"\0"
    "GL extension \"GL_APPLE_vertex_array_range\"\0"
    "GL extension \"GL_APPLE_vertex_program_evaluators\"\0"
    "GL extension \"GL_ARB_ES2_compatibility\"\0"
    "GL extension \"GL_ARB_ES3_1_compatibility\"\0"
    "GL extension \"GL_ARB_ES3_2_compatibility\"\0"
    "GL extension \"GL_ARB_base_instance\"\0"
    "GL extension \"GL_ARB_bindless_texture\"\0"
    "GL extension \"GL_ARB_blend_func_extended\"\0"
    "GL extension \"GL_ARB_buffer_storage\"\0"
    "GL extension \"GL_ARB_cl_event\"\0"
    "GL extension \"GL_ARB_clear_buffer_object\"\0"
    "GL extension \"GL_ARB_clear_texture\"\0"
    "GL extension \"GL_ARB_clip_control\"\0"
    "GL extension \"GL_ARB_color_buffer_float\"\0"
    "GL extension \"GL_ARB_compute_shader\"\0"
    "GL extension \"GL_ARB_compute_variable_group_size\"\0"
    "GL extension \"GL_ARB_copy_buffer\"\0"
    "GL extension \"GL_ARB_copy_image\"\0"
    "GL extension \"GL_ARB_debug_output\"\0"
    "GL extension \"GL_ARB_direct_state_access\"\0"
    "GL extension \"GL_ARB_draw_buffers\"\0"
    "GL extension \"GL_ARB_draw_buffers_blend\"\0"
    "GL extension \"GL_ARB_draw_elements_base_vertex\"\0"
    "GL extension \"GL_ARB_draw_indirect\"\0"
    "GL extension \"GL_ARB_draw_instanced\"\0"
    "GL extension \"GL_ARB_fragment_program\"\0"
    "GL extension \"GL_ARB_framebuffer_no_attachments\"\0"
    "GL extension \"GL_ARB_framebuffer_object\"\0"
    "GL extension \"GL_ARB_geometry_shader4\"\0"
    "GL extension \"GL_ARB_get_program_binary\"\0"
    "GL extension \"GL_ARB_get_texture_sub_image\"\0"
    "GL extension \"GL_ARB_gl_spirv\"\0"
    "GL extension \"GL_ARB_gpu_shader_fp64\"\0"
    "GL extension \"GL_ARB_gpu_shader_int64\"\0"
    "GL extension \"GL_ARB_imaging\"\0"
    "GL extension \"GL_ARB_indirect_parameters\"\0"
    "GL extension \"GL_ARB_instanced_arrays\"\0"
    "GL extension \"GL_ARB_internalformat_query2\"\0"
    "GL extension \"GL_ARB_internalformat_query\"\0"
    "GL extension \"GL_ARB_invalidate_subdata\"\0"
    "GL extension \"GL_ARB_map_buffer_range\"\0"
    "GL extension \"GL_ARB_matrix_palette\"\0"
    "GL extension \"GL_ARB_multi_bind\"\0"
    "GL extension \"GL_ARB_multi_draw_indirect\"\0"
    "GL extension \"GL_ARB_multisample\"\0"
    "GL extension \"GL_ARB_multitexture\"\0"
    "GL extension \"GL_ARB_occlusion_query\"\0"
    "GL extension \"GL_ARB_parallel_shader_compile\"\0"
    "GL extension \"GL_ARB_point_parameters\"\0"
    "GL extension \"GL_ARB_polygon_offset_clamp\"\0"
    "GL extension \"GL_ARB_program_interface_query\"\0"
    "GL extension \"GL_ARB_provoking_vertex\"\0"
    "GL extension \"GL_ARB_robustness\"\0"
    "GL extension \"GL_ARB_sample_locations\"\0"
    "GL extension \"GL_ARB_sample_shading\"\0"
    "GL extension \"GL_ARB_sampler_objects\"\0"
    "GL extension \"GL_ARB_separate_shader_objects\"\0"
    "GL extension \"GL_ARB_shader_atomic_counters\"\0"
    "GL extension \"GL_ARB_shader_image_load_store\"\0"
    "GL extension \"GL_ARB_shader_objects\"\0"
    "GL extension \"GL_ARB_shader_storage_buffer_object\"\0"
    "GL extension \"GL_ARB_shader_subroutine\"\0"
    "GL extension \"GL_ARB_shading_language_include\"\0"
    "GL extension \"GL_ARB_sparse_buffer\"\0"
    "GL extension \"GL_ARB_sparse_texture\"\0"
    "GL extension \"GL_ARB_sync\"\0"
    "GL extension \"GL_ARB_tessellation_shader\"\0"
    "GL extension \"GL_ARB_texture_barrier\"\0"
    "GL extension \"GL_ARB_texture_buffer_object\"\0"
    "GL extension \"GL_ARB_texture_buffer_range\"\0"
    "GL extension \"GL_ARB_texture_compression\"\0"
    "GL extension \"GL_ARB_texture_multisample\"\0"
    "GL extension \"GL_ARB_texture_storage\"\0"
    "GL extension \"GL_ARB_texture_storage_multisample\"\0"
    "GL extension \"GL_ARB_texture_view\"\0"
    "GL extension \"GL_ARB_timer_query\"\0"
    "GL extension \"GL_ARB_transform_feedback2\"\0"
    "GL extension \"GL_ARB_transform_feedback3\"\0"
    "GL extension \"GL_ARB_transform_feedback_instanced\"\0"
    "GL extension \"GL_ARB_transpose_matrix\"\0"
    "GL extension \"GL_ARB_uniform_buffer_object\"\0"
    "GL extension \"GL_ARB_vertex_array_object\"\0"
    "GL extension \"GL_ARB_vertex_attrib_64bit\"\0"
    "GL extension \"GL_ARB_vertex_attrib_binding\"\0"
    "GL extension \"GL_ARB_vertex_blend\"\0"
    "GL extension \"GL_ARB_vertex_buffer_object\"\0"
    "GL extension \"GL_ARB_vertex_program\"\0"
    "GL extension \"GL_ARB_vertex_shader\"\0"
    "GL extension \"GL_ARB_vertex_type_2_10_10_10_rev\"\0"
    "GL extension \"GL_ARB_viewport_array\"\0"
    "GL extension \"GL_ARB_window_pos\"\0"
    "GL extension \"GL_ATI_draw_buffers\"\0"
    "GL extension \"GL_ATI_element_array\"\0"
    "GL extension \"GL_ATI_envmap_bumpmap\"\0"
    "GL extension \"GL_ATI_fragment_shader\"\0"
    "GL extension \"GL_ATI_map_object_buffer\"\0"
    "GL extension \"GL_ATI_pn_triangles\"\0"
    "GL extension \"GL_ATI_separate_stencil\"\0"
    "GL extension \"GL_ATI_vertex_array_object\"\0"
    "GL extension \"GL_ATI_vertex_attrib_array_object\"\0"
    "GL extension \"GL_ATI_vertex_streams\"\0"
    "GL extension \"GL_EXT_base_instance\"\0"
    "GL extension \"GL_EXT_bindable_uniform\"\0"
    "GL extension \"GL_EXT_blend_color\"\0"
    "GL extension \"GL_EXT_blend_equation_separate\"\0"
    "GL extension \"GL_EXT_blend_func_extended\"\0"
    "GL extension \"GL_EXT_blend_func_separate\"\0"
    "GL extension \"GL_EXT_blend_minmax\"\0"
    "GL extension \"GL_EXT_buffer_storage\"\0"
    "GL extension \"GL_EXT_clear_texture\"\0"
    "GL extension \"GL_EXT_clip_control\"\0"
    "GL extension \"GL_EXT_color_subtable\"\0"
    "GL extension \"GL_EXT_compiled_vertex_array\"\0"
    "GL extension \"GL_EXT_convolution\"\0"
    "GL extension \"GL_EXT_coordinate_frame\"\0"
    "GL extension \"GL_EXT_copy_image\"\0"
    "GL extension \"GL_EXT_copy_texture\"\0"
    "GL extension \"GL_EXT_cull_vertex\"\0"
    "GL extension \"GL_EXT_debug_label\"\0"
    "GL extension \"GL_EXT_debug_marker\"\0"
    "GL extension \"GL_EXT_depth_bounds_test\"\0"
    "GL extension \"GL_EXT_direct_state_access\"\0"
    "GL extension \"GL_EXT_discard_framebuffer\"\0"
    "GL extension \"GL_EXT_disjoint_timer_query\"\0"
    "GL extension \"GL_EXT_draw_buffers2\"\0"
    "GL extension \"GL_EXT_draw_buffers\"\0"
    "GL extension \"GL_EXT_draw_buffers_indexed\"\0"
    "GL extension \"GL_EXT_draw_elements_base_vertex\"\0"
    "GL extension \"GL_EXT_draw_instanced\"\0"
    "GL extension \"GL_EXT_draw_range_elements\"\0"
    "GL extension \"GL_EXT_draw_transform_feedback\"\0"
    "GL extension \"GL_EXT_external_buffer\"\0"
    "GL extension \"GL_EXT_fog_coord\"\0"
    "GL extension \"GL_EXT_framebuffer_blit\"\0"
    "GL extension \"GL_EXT_framebuffer_multisample\"\0"
    "GL extension \"GL_EXT_framebuffer_object\"\0"
    "GL extension \"GL_EXT_geometry_shader4\"\0"
    "GL extension \"GL_EXT_geometry_shader\"\0"
    "GL extension \"GL_EXT_gpu_program_parameters\"\0"
    "GL extension \"GL_EXT_gpu_shader4\"\0"
    "GL extension \"GL_EXT_histogram\"\0"
    "GL extension \"GL_EXT_index_func\"\0"
    "GL extension \"GL_EXT_index_material\"\0"
    "GL extension \"GL_EXT_instanced_arrays\"\0"
    "GL extension \"GL_EXT_light_texture\"\0"
    "GL extension \"GL_EXT_map_buffer_range\"\0"
    "GL extension \"GL_EXT_memory_object\"\0"
    "GL extension \"GL_EXT_memory_object_fd\"\0"
    "GL extension \"GL_EXT_memory_object_win32\"\0"
    "GL extension \"GL_EXT_multi_draw_arrays\"\0"
    "GL extension \"GL_EXT_multi_draw_indirect\"\0"
    "GL extension \"GL_EXT_multisample\"\0"
    "GL extension \"GL_EXT_multisampled_render_to_texture\"\0"
    "GL extension \"GL_EXT_multiview_draw_buffers\"\0"
    "GL extension \"GL_EXT_occlusion_query_boolean\"\0"
    "GL extension \"GL_EXT_paletted_texture\"\0"
    "GL extension \"GL_EXT_pixel_transform\"\0"
    "GL extension \"GL_EXT_point_parameters\"\0"
    "GL extension \"GL_EXT_polygon_offset\"\0"
    "GL extension \"GL_EXT_polygon_offset_clamp\"\0"
    "GL extension \"GL_EXT_primitive_bounding_box\"\0"
    "GL extension \"GL_EXT_provoking_vertex\"\0"
    "GL extension \"GL_EXT_raster_multisample\"\0"
    "GL extension \"GL_EXT_robustness\"\0"
    "GL extension \"GL_EXT_secondary_color\"\0"
    "GL extension \"GL_EXT_semaphore\"\0"
    "GL extension \"GL_EXT_semaphore_fd\"\0"
    "GL extension \"GL_EXT_semaphore_win32\"\0"
    "GL extension \"GL_EXT_separate_shader_objects\"\0"
    "GL extension \"GL_EXT_shader_image_load_store\"\0"
    "GL extension \"GL_EXT_shader_pixel_local_storage2\"\0"
    "GL extension \"GL_EXT_sparse_texture\"\0"
    "GL extension \"GL_EXT_stencil_clear_tag\"\0"
    "GL extension \"GL_EXT_stencil_two_side\"\0"
    "GL extension \"GL_EXT_subtexture\"\0"
    "GL extension \"GL_EXT_tessellation_shader\"\0"
    "GL extension \"GL_EXT_texture3D\"\0"
    "GL extension \"GL_EXT_texture_array\"\0"
    "GL extension \"GL_EXT_texture_border_clamp\"\0"
    "GL extension \"GL_EXT_texture_buffer\"\0"
    "GL extension \"GL_EXT_texture_buffer_object\"\0"
    "GL extension \"GL_EXT_texture_integer\"\0"
    "GL extension \"GL_EXT_texture_object\"\0"
    "GL extension \"GL_EXT_texture_perturb_normal\"\0"
    "GL extension \"GL_EXT_texture_storage\"\0"
    "GL extension \"GL_EXT_texture_view\"\0"
    "GL extension \"GL_EXT_timer_query\"\0"
    "GL extension \"GL_EXT_transform_feedback\"\0"
    "GL extension \"GL_EXT_vertex_array\"\0"
    "GL extension \"GL_EXT_vertex_attrib_64bit\"\0"
    "GL extension \"GL_EXT_vertex_shader\"\0"
    "GL extension \"GL_EXT_vertex_weighting\"\0"
    "GL extension \"GL_EXT_win32_keyed_mutex\"\0"
    "GL extension \"GL_EXT_window_rectangles\"\0"
    "GL extension \"GL_EXT_x11_sync_object\"\0"
    "GL extension \"GL_GREMEDY_frame_terminator\"\0"
    "GL extension \"GL_GREMEDY_string_marker\"\0"
    "GL extension \"GL_HP_image_transform\"\0"
    "GL extension \"GL_IBM_multimode_draw_arrays\"\0"
    "GL extension \"GL_IBM_static_data\"\0"
    "GL extension \"GL_IBM_vertex_array_lists\"\0"
    "GL extension \"GL_IMG_bindless_texture\"\0"
    "GL extension \"GL_IMG_framebuffer_downsample\"\0"
    "GL extension \"GL_IMG_multisampled_render_to_texture\"\0"
    "GL extension \"GL_IMG_user_clip_plane\"\0"
    "GL extension \"GL_INGR_blend_func_separate\"\0"
    "GL extension \"GL_INTEL_framebuffer_CMAA\"\0"
    "GL extension \"GL_INTEL_map_texture\"\0"
    "GL extension \"GL_INTEL_parallel_arrays\"\0"
    "GL extension \"GL_INTEL_performance_query\"\0"
    "GL extension \"GL_KHR_blend_equation_advanced\"\0"
    "GL extension \"GL_KHR_debug\"\0"
    "GL extension \"GL_KHR_parallel_shader_compile\"\0"
    "GL extension \"GL_KHR_robustness\"\0"
    "GL extension \"GL_MESA_resize_buffers\"\0"
    "GL extension \"GL_MESA_window_pos\"\0"
    "GL extension \"GL_NVX_conditional_render\"\0"
    "GL extension \"GL_NVX_linked_gpu_multicast\"\0"
    "GL extension \"GL_NV_alpha_to_coverage_dither_control\"\0"
    "GL extension \"GL_NV_bindless_multi_draw_indirect\"\0"
    "GL extension \"GL_NV_bindless_multi_draw_indirect_count\"\0"
    "GL extension \"GL_NV_bindless_texture\"\0"
    "GL extension \"GL_NV_blend_equation_advanced\"\0"
    "GL extension \"GL_NV_clip_space_w_scaling\"\0"
    "GL extension \"GL_NV_command_list\"\0"
    "GL extension \"GL_NV_conditional_render\"\0"
    "GL extension \"GL_NV_conservative_raster\"\0"
    "GL extension \"GL_NV_conservative_raster_dilate\"\0"
    "GL extension \"GL_NV_conservative_raster_pre_snap_triangles\"\0"
    "GL extension \"GL_NV_copy_buffer\"\0"
    "GL extension \"GL_NV_copy_image\"\0"
    "GL extension \"GL_NV_coverage_sample\"\0"
    "GL extension \"GL_NV_depth_buffer_float\"\0"
    "GL extension \"GL_NV_draw_buffers\"\0"
    "GL extension \"GL_NV_draw_instanced\"\0"
    "GL extension \"GL_NV_draw_texture\"\0"
    "GL extension \"GL_NV_draw_vulkan_image\"\0"
    "GL extension \"GL_NV_evaluators\"\0"
    "GL extension \"GL_NV_explicit_multisample\"\0"
    "GL extension \"GL_NV_fence\"\0"
    "GL extension \"GL_NV_fragment_coverage_to_color\"\0"
    "GL extension \"GL_NV_fragment_program\"\0"
    "GL extension \"GL_NV_framebuffer_blit\"\0"
    "GL extension \"GL_NV_framebuffer_mixed_samples\"\0"
    "GL extension \"GL_NV_framebuffer_multisample\"\0"
    "GL extension \"GL_NV_framebuffer_multisample_coverage\"\0"
    "GL extension \"GL_NV_geometry_program4\"\0"
    "GL extension \"GL_NV_gpu_multicast\"\0"
    "GL extension \"GL_NV_gpu_program4\"\0"
    "GL extension \"GL_NV_gpu_program5\"\0"
    "GL extension \"GL_NV_gpu_shader5\"\0"
    "GL extension \"GL_NV_half_float\"\0"
    "GL extension \"GL_NV_instanced_arrays\"\0"
    "GL extension \"GL_NV_internalformat_sample_query\"\0"
    "GL extension \"GL_NV_non_square_matrices\"\0"
    "GL extension \"GL_NV_occlusion_query\"\0"
    "GL extension \"GL_NV_parameter_buffer_object\"\0"
    "GL extension \"GL_NV_path_rendering\"\0"
    "GL extension \"GL_NV_pixel_data_range\"\0"
    "GL extension \"GL_NV_point_sprite\"\0"
    "GL extension \"GL_NV_polygon_mode\"\0"
    "GL extension \"GL_NV_present_video\"\0"
    "GL extension \"GL_NV_primitive_restart\"\0"
    "GL extension \"GL_NV_query_resource\"\0"
    "GL extension \"GL_NV_query_resource_tag\"\0"
    "GL extension \"GL_NV_read_buffer\"\0"
    "GL extension \"GL_NV_register_combiners2\"\0"
    "GL extension \"GL_NV_register_combiners\"\0"
    "GL extension \"GL_NV_sample_locations\"\0"
    "GL extension \"GL_NV_shader_buffer_load\"\0"
    "GL extension \"GL_NV_texture_barrier\"\0"
    "GL extension \"GL_NV_texture_multisample\"\0"
    "GL extension \"GL_NV_transform_feedback2\"\0"
    "GL extension \"GL_NV_transform_feedback\"\0"
    "GL extension \"GL_NV_vdpau_interop\"\0"
    "GL extension \"GL_NV_vertex_array_range\"\0"
    "GL extension \"GL_NV_vertex_attrib_integer_64bit\"\0"
    "GL extension \"GL_NV_vertex_buffer_unified_memory\"\0"
    "GL extension \"GL_NV_vertex_program4\"\0"
    "GL extension \"GL_NV_vertex_program\"\0"
    "GL extension \"GL_NV_video_capture\"\0"
    "GL extension \"GL_NV_viewport_array\"\0"
    "GL extension \"GL_NV_viewport_swizzle\"\0"
    "GL extension \"GL_OES_EGL_image\"\0"
    "GL extension \"GL_OES_blend_equation_separate\"\0"
    "GL extension \"GL_OES_blend_func_separate\"\0"
    "GL extension \"GL_OES_blend_subtract\"\0"
    "GL extension \"GL_OES_byte_coordinates\"\0"
    "GL extension \"GL_OES_copy_image\"\0"
    "GL extension \"GL_OES_draw_buffers_indexed\"\0"
    "GL extension \"GL_OES_draw_elements_base_vertex\"\0"
    "GL extension \"GL_OES_draw_texture\"\0"
    "GL extension \"GL_OES_fixed_point\"\0"
    "GL extension \"GL_OES_framebuffer_object\"\0"
    "GL extension \"GL_OES_geometry_shader\"\0"
    "GL extension \"GL_OES_get_program_binary\"\0"
    "GL extension \"GL_OES_mapbuffer\"\0"
    "GL extension \"GL_OES_matrix_palette\"\0"
    "GL extension \"GL_OES_point_size_array\"\0"
    "GL extension \"GL_OES_primitive_bounding_box\"\0"
    "GL extension \"GL_OES_query_matrix\"\0"
    "GL extension \"GL_OES_sample_shading\"\0"
    "GL extension \"GL_OES_single_precision\"\0"
    "GL extension \"GL_OES_tessellation_shader\"\0"
    "GL extension \"GL_OES_texture_3D\"\0"
    "GL extension \"GL_OES_texture_border_clamp\"\0"
    "GL extension \"GL_OES_texture_buffer\"\0"
    "GL extension \"GL_OES_texture_cube_map\"\0"
    "GL extension \"GL_OES_texture_storage_multisample_2d_array\"\0"
    "GL extension \"GL_OES_texture_view\"\0"
    "GL extension \"GL_OES_vertex_array_object\"\0"
    "GL extension \"GL_OES_viewport_array\"\0"
    "GL extension \"GL_OVR_multiview\"\0"
    "GL extension \"GL_OVR_multiview_multisampled_render_to_texture\"\0"
    "GL extension \"GL_PGI_misc_hints\"\0"
    "GL extension \"GL_QCOM_alpha_test\"\0"
    "GL extension \"GL_QCOM_driver_control\"\0"
    "GL extension \"GL_QCOM_extended_get2\"\0"
    "GL extension \"GL_QCOM_extended_get\"\0"
    "GL extension \"GL_QCOM_framebuffer_foveated\"\0"
    "GL extension \"GL_QCOM_shader_framebuffer_fetch_noncoherent\"\0"
    "GL extension \"GL_QCOM_texture_foveated\"\0"
    "GL extension \"GL_QCOM_tiled_rendering\"\0"
    "GL extension \"GL_SGIS_detail_texture\"\0"
    "GL extension \"GL_SGIS_fog_function\"\0"
    "GL extension \"GL_SGIS_multisample\"\0"
    "GL extension \"GL_SGIS_pixel_texture\"\0"
    "GL extension \"GL_SGIS_point_parameters\"\0"
    "GL extension \"GL_SGIS_sharpen_texture\"\0"
    "GL extension \"GL_SGIS_texture4D\"\0"
    "GL extension \"GL_SGIS_texture_color_mask\"\0"
    "GL extension \"GL_SGIS_texture_filter4\"\0"
    "GL extension \"GL_SGIX_async\"\0"
    "GL extension \"GL_SGIX_flush_raster\"\0"
    "GL extension \"GL_SGIX_fragment_lighting\"\0"
    "GL extension \"GL_SGIX_framezoom\"\0"
    "GL extension \"GL_SGIX_igloo_interface\"\0"
    "GL extension \"GL_SGIX_instruments\"\0"
    "GL extension \"GL_SGIX_list_priority\"\0"
    "GL extension \"GL_SGIX_pixel_texture\"\0"
    "GL extension \"GL_SGIX_polynomial_ffd\"\0"
    "GL extension \"GL_SGIX_reference_plane\"\0"
    "GL extension \"GL_SGIX_sprite\"\0"
    "GL extension \"GL_SGIX_tag_sample_buffer\"\0"
    "GL extension \"GL_SGI_color_table\"\0"
    "GL extension \"GL_SUNX_constant_data\"\0"
    "GL extension \"GL_SUN_global_alpha\"\0"
    "GL extension \"GL_SUN_mesh_array\"\0"
    "GL extension \"GL_SUN_triangle_list\"\0"
    "GL extension \"GL_SUN_vertex\"\0"
    "OpenGL ES 1.0\0"
    "OpenGL ES 2.0\0"
    "OpenGL ES 3.0\0"
    "OpenGL ES 3.1\0"
    "OpenGL ES 3.2\0"
    "always present\0"
     ;

static const uint16_t enum_string_offsets[] = {
    -1, /* gl_provider_terminator, unused */
    0, /* Desktop_OpenGL_1_0 */
    19, /* Desktop_OpenGL_1_1 */
    38, /* Desktop_OpenGL_1_2 */
    57, /* Desktop_OpenGL_1_3 */
    76, /* Desktop_OpenGL_1_4 */
    95, /* Desktop_OpenGL_1_5 */
    114, /* Desktop_OpenGL_2_0 */
    133, /* Desktop_OpenGL_2_1 */
    152, /* Desktop_OpenGL_3_0 */
    171, /* Desktop_OpenGL_3_1 */
    190, /* Desktop_OpenGL_3_2 */
    209, /* Desktop_OpenGL_3_3 */
    228, /* Desktop_OpenGL_4_0 */
    247, /* Desktop_OpenGL_4_1 */
    266, /* Desktop_OpenGL_4_2 */
    285, /* Desktop_OpenGL_4_3 */
    304, /* Desktop_OpenGL_4_4 */
    323, /* Desktop_OpenGL_4_5 */
    342, /* Desktop_OpenGL_4_6 */
    361, /* GL_extension_GL_3DFX_tbuffer */
    392, /* GL_extension_GL_AMD_debug_output */
    427, /* GL_extension_GL_AMD_draw_buffers_blend */
    468, /* GL_extension_GL_AMD_framebuffer_sample_positions */
    519, /* GL_extension_GL_AMD_gpu_shader_int64 */
    558, /* GL_extension_GL_AMD_interleaved_elements */
    601, /* GL_extension_GL_AMD_multi_draw_indirect */
    643, /* GL_extension_GL_AMD_name_gen_delete */
    681, /* GL_extension_GL_AMD_occlusion_query_event */
    725, /* GL_extension_GL_AMD_performance_monitor */
    767, /* GL_extension_GL_AMD_sample_positions */
    806, /* GL_extension_GL_AMD_sparse_texture */
    843, /* GL_extension_GL_AMD_stencil_operation_extended */
    892, /* GL_extension_GL_AMD_vertex_shader_tessellator */
    940, /* GL_extension_GL_ANGLE_framebuffer_blit */
    981, /* GL_extension_GL_ANGLE_framebuffer_multisample */
    1029, /* GL_extension_GL_ANGLE_instanced_arrays */
    1070, /* GL_extension_GL_ANGLE_translated_shader_source */
    1119, /* GL_extension_GL_APPLE_copy_texture_levels */
    1163, /* GL_extension_GL_APPLE_element_array */
    1201, /* GL_extension_GL_APPLE_fence */
    1231, /* GL_extension_GL_APPLE_flush_buffer_range */
    1274, /* GL_extension_GL_APPLE_framebuffer_multisample */
    1322, /* GL_extension_GL_APPLE_object_purgeable */
    1363, /* GL_extension_GL_APPLE_sync */
    1392, /* GL_extension_GL_APPLE_texture_range */
    1430, /* GL_extension_GL_APPLE_vertex_array_object */
    1474, /* GL_extension_GL_APPLE_vertex_array_range */
    1517, /* GL_extension_GL_APPLE_vertex_program_evaluators */
    1567, /* GL_extension_GL_ARB_ES2_compatibility */
    1607, /* GL_extension_GL_ARB_ES3_1_compatibility */
    1649, /* GL_extension_GL_ARB_ES3_2_compatibility */
    1691, /* GL_extension_GL_ARB_base_instance */
    1727, /* GL_extension_GL_ARB_bindless_texture */
    1766, /* GL_extension_GL_ARB_blend_func_extended */
    1808, /* GL_extension_GL_ARB_buffer_storage */
    1845, /* GL_extension_GL_ARB_cl_event */
    1876, /* GL_extension_GL_ARB_clear_buffer_object */
    1918, /* GL_extension_GL_ARB_clear_texture */
    1954, /* GL_extension_GL_ARB_clip_control */
    1989, /* GL_extension_GL_ARB_color_buffer_float */
    2030, /* GL_extension_GL_ARB_compute_shader */
    2067, /* GL_extension_GL_ARB_compute_variable_group_size */
    2117, /* GL_extension_GL_ARB_copy_buffer */
    2151, /* GL_extension_GL_ARB_copy_image */
    2184, /* GL_extension_GL_ARB_debug_output */
    2219, /* GL_extension_GL_ARB_direct_state_access */
    2261, /* GL_extension_GL_ARB_draw_buffers */
    2296, /* GL_extension_GL_ARB_draw_buffers_blend */
    2337, /* GL_extension_GL_ARB_draw_elements_base_vertex */
    2385, /* GL_extension_GL_ARB_draw_indirect */
    2421, /* GL_extension_GL_ARB_draw_instanced */
    2458, /* GL_extension_GL_ARB_fragment_program */
    2497, /* GL_extension_GL_ARB_framebuffer_no_attachments */
    2546, /* GL_extension_GL_ARB_framebuffer_object */
    2587, /* GL_extension_GL_ARB_geometry_shader4 */
    2626, /* GL_extension_GL_ARB_get_program_binary */
    2667, /* GL_extension_GL_ARB_get_texture_sub_image */
    2711, /* GL_extension_GL_ARB_gl_spirv */
    2742, /* GL_extension_GL_ARB_gpu_shader_fp64 */
    2780, /* GL_extension_GL_ARB_gpu_shader_int64 */
    2819, /* GL_extension_GL_ARB_imaging */
    2849, /* GL_extension_GL_ARB_indirect_parameters */
    2891, /* GL_extension_GL_ARB_instanced_arrays */
    2930, /* GL_extension_GL_ARB_internalformat_query2 */
    2974, /* GL_extension_GL_ARB_internalformat_query */
    3017, /* GL_extension_GL_ARB_invalidate_subdata */
    3058, /* GL_extension_GL_ARB_map_buffer_range */
    3097, /* GL_extension_GL_ARB_matrix_palette */
    3134, /* GL_extension_GL_ARB_multi_bind */
    3167, /* GL_extension_GL_ARB_multi_draw_indirect */
    3209, /* GL_extension_GL_ARB_multisample */
    3243, /* GL_extension_GL_ARB_multitexture */
    3278, /* GL_extension_GL_ARB_occlusion_query */
    3316, /* GL_extension_GL_ARB_parallel_shader_compile */
    3362, /* GL_extension_GL_ARB_point_parameters */
    3401, /* GL_extension_GL_ARB_polygon_offset_clamp */
    3444, /* GL_extension_GL_ARB_program_interface_query */
    3490, /* GL_extension_GL_ARB_provoking_vertex */
    3529, /* GL_extension_GL_ARB_robustness */
    3562, /* GL_extension_GL_ARB_sample_locations */
    3601, /* GL_extension_GL_ARB_sample_shading */
    3638, /* GL_extension_GL_ARB_sampler_objects */
    3676, /* GL_extension_GL_ARB_separate_shader_objects */
    3722, /* GL_extension_GL_ARB_shader_atomic_counters */
    3767, /* GL_extension_GL_ARB_shader_image_load_store */
    3813, /* GL_extension_GL_ARB_shader_objects */
    3850, /* GL_extension_GL_ARB_shader_storage_buffer_object */
    3901, /* GL_extension_GL_ARB_shader_subroutine */
    3941, /* GL_extension_GL_ARB_shading_language_include */
    3988, /* GL_extension_GL_ARB_sparse_buffer */
    4024, /* GL_extension_GL_ARB_sparse_texture */
    4061, /* GL_extension_GL_ARB_sync */
    4088, /* GL_extension_GL_ARB_tessellation_shader */
    4130, /* GL_extension_GL_ARB_texture_barrier */
    4168, /* GL_extension_GL_ARB_texture_buffer_object */
    4212, /* GL_extension_GL_ARB_texture_buffer_range */
    4255, /* GL_extension_GL_ARB_texture_compression */
    4297, /* GL_extension_GL_ARB_texture_multisample */
    4339, /* GL_extension_GL_ARB_texture_storage */
    4377, /* GL_extension_GL_ARB_texture_storage_multisample */
    4427, /* GL_extension_GL_ARB_texture_view */
    4462, /* GL_extension_GL_ARB_timer_query */
    4496, /* GL_extension_GL_ARB_transform_feedback2 */
    4538, /* GL_extension_GL_ARB_transform_feedback3 */
    4580, /* GL_extension_GL_ARB_transform_feedback_instanced */
    4631, /* GL_extension_GL_ARB_transpose_matrix */
    4670, /* GL_extension_GL_ARB_uniform_buffer_object */
    4714, /* GL_extension_GL_ARB_vertex_array_object */
    4756, /* GL_extension_GL_ARB_vertex_attrib_64bit */
    4798, /* GL_extension_GL_ARB_vertex_attrib_binding */
    4842, /* GL_extension_GL_ARB_vertex_blend */
    4877, /* GL_extension_GL_ARB_vertex_buffer_object */
    4920, /* GL_extension_GL_ARB_vertex_program */
    4957, /* GL_extension_GL_ARB_vertex_shader */
    4993, /* GL_extension_GL_ARB_vertex_type_2_10_10_10_rev */
    5042, /* GL_extension_GL_ARB_viewport_array */
    5079, /* GL_extension_GL_ARB_window_pos */
    5112, /* GL_extension_GL_ATI_draw_buffers */
    5147, /* GL_extension_GL_ATI_element_array */
    5183, /* GL_extension_GL_ATI_envmap_bumpmap */
    5220, /* GL_extension_GL_ATI_fragment_shader */
    5258, /* GL_extension_GL_ATI_map_object_buffer */
    5298, /* GL_extension_GL_ATI_pn_triangles */
    5333, /* GL_extension_GL_ATI_separate_stencil */
    5372, /* GL_extension_GL_ATI_vertex_array_object */
    5414, /* GL_extension_GL_ATI_vertex_attrib_array_object */
    5463, /* GL_extension_GL_ATI_vertex_streams */
    5500, /* GL_extension_GL_EXT_base_instance */
    5536, /* GL_extension_GL_EXT_bindable_uniform */
    5575, /* GL_extension_GL_EXT_blend_color */
    5609, /* GL_extension_GL_EXT_blend_equation_separate */
    5655, /* GL_extension_GL_EXT_blend_func_extended */
    5697, /* GL_extension_GL_EXT_blend_func_separate */
    5739, /* GL_extension_GL_EXT_blend_minmax */
    5774, /* GL_extension_GL_EXT_buffer_storage */
    5811, /* GL_extension_GL_EXT_clear_texture */
    5847, /* GL_extension_GL_EXT_clip_control */
    5882, /* GL_extension_GL_EXT_color_subtable */
    5919, /* GL_extension_GL_EXT_compiled_vertex_array */
    5963, /* GL_extension_GL_EXT_convolution */
    5997, /* GL_extension_GL_EXT_coordinate_frame */
    6036, /* GL_extension_GL_EXT_copy_image */
    6069, /* GL_extension_GL_EXT_copy_texture */
    6104, /* GL_extension_GL_EXT_cull_vertex */
    6138, /* GL_extension_GL_EXT_debug_label */
    6172, /* GL_extension_GL_EXT_debug_marker */
    6207, /* GL_extension_GL_EXT_depth_bounds_test */
    6247, /* GL_extension_GL_EXT_direct_state_access */
    6289, /* GL_extension_GL_EXT_discard_framebuffer */
    6331, /* GL_extension_GL_EXT_disjoint_timer_query */
    6374, /* GL_extension_GL_EXT_draw_buffers2 */
    6410, /* GL_extension_GL_EXT_draw_buffers */
    6445, /* GL_extension_GL_EXT_draw_buffers_indexed */
    6488, /* GL_extension_GL_EXT_draw_elements_base_vertex */
    6536, /* GL_extension_GL_EXT_draw_instanced */
    6573, /* GL_extension_GL_EXT_draw_range_elements */
    6615, /* GL_extension_GL_EXT_draw_transform_feedback */
    6661, /* GL_extension_GL_EXT_external_buffer */
    6699, /* GL_extension_GL_EXT_fog_coord */
    6731, /* GL_extension_GL_EXT_framebuffer_blit */
    6770, /* GL_extension_GL_EXT_framebuffer_multisample */
    6816, /* GL_extension_GL_EXT_framebuffer_object */
    6857, /* GL_extension_GL_EXT_geometry_shader4 */
    6896, /* GL_extension_GL_EXT_geometry_shader */
    6934, /* GL_extension_GL_EXT_gpu_program_parameters */
    6979, /* GL_extension_GL_EXT_gpu_shader4 */
    7013, /* GL_extension_GL_EXT_histogram */
    7045, /* GL_extension_GL_EXT_index_func */
    7078, /* GL_extension_GL_EXT_index_material */
    7115, /* GL_extension_GL_EXT_instanced_arrays */
    7154, /* GL_extension_GL_EXT_light_texture */
    7190, /* GL_extension_GL_EXT_map_buffer_range */
    7229, /* GL_extension_GL_EXT_memory_object */
    7265, /* GL_extension_GL_EXT_memory_object_fd */
    7304, /* GL_extension_GL_EXT_memory_object_win32 */
    7346, /* GL_extension_GL_EXT_multi_draw_arrays */
    7386, /* GL_extension_GL_EXT_multi_draw_indirect */
    7428, /* GL_extension_GL_EXT_multisample */
    7462, /* GL_extension_GL_EXT_multisampled_render_to_texture */
    7515, /* GL_extension_GL_EXT_multiview_draw_buffers */
    7560, /* GL_extension_GL_EXT_occlusion_query_boolean */
    7606, /* GL_extension_GL_EXT_paletted_texture */
    7645, /* GL_extension_GL_EXT_pixel_transform */
    7683, /* GL_extension_GL_EXT_point_parameters */
    7722, /* GL_extension_GL_EXT_polygon_offset */
    7759, /* GL_extension_GL_EXT_polygon_offset_clamp */
    7802, /* GL_extension_GL_EXT_primitive_bounding_box */
    7847, /* GL_extension_GL_EXT_provoking_vertex */
    7886, /* GL_extension_GL_EXT_raster_multisample */
    7927, /* GL_extension_GL_EXT_robustness */
    7960, /* GL_extension_GL_EXT_secondary_color */
    7998, /* GL_extension_GL_EXT_semaphore */
    8030, /* GL_extension_GL_EXT_semaphore_fd */
    8065, /* GL_extension_GL_EXT_semaphore_win32 */
    8103, /* GL_extension_GL_EXT_separate_shader_objects */
    8149, /* GL_extension_GL_EXT_shader_image_load_store */
    8195, /* GL_extension_GL_EXT_shader_pixel_local_storage2 */
    8245, /* GL_extension_GL_EXT_sparse_texture */
    8282, /* GL_extension_GL_EXT_stencil_clear_tag */
    8322, /* GL_extension_GL_EXT_stencil_two_side */
    8361, /* GL_extension_GL_EXT_subtexture */
    8394, /* GL_extension_GL_EXT_tessellation_shader */
    8436, /* GL_extension_GL_EXT_texture3D */
    8468, /* GL_extension_GL_EXT_texture_array */
    8504, /* GL_extension_GL_EXT_texture_border_clamp */
    8547, /* GL_extension_GL_EXT_texture_buffer */
    8584, /* GL_extension_GL_EXT_texture_buffer_object */
    8628, /* GL_extension_GL_EXT_texture_integer */
    8666, /* GL_extension_GL_EXT_texture_object */
    8703, /* GL_extension_GL_EXT_texture_perturb_normal */
    8748, /* GL_extension_GL_EXT_texture_storage */
    8786, /* GL_extension_GL_EXT_texture_view */
    8821, /* GL_extension_GL_EXT_timer_query */
    8855, /* GL_extension_GL_EXT_transform_feedback */
    8896, /* GL_extension_GL_EXT_vertex_array */
    8931, /* GL_extension_GL_EXT_vertex_attrib_64bit */
    8973, /* GL_extension_GL_EXT_vertex_shader */
    9009, /* GL_extension_GL_EXT_vertex_weighting */
    9048, /* GL_extension_GL_EXT_win32_keyed_mutex */
    9088, /* GL_extension_GL_EXT_window_rectangles */
    9128, /* GL_extension_GL_EXT_x11_sync_object */
    9166, /* GL_extension_GL_GREMEDY_frame_terminator */
    9209, /* GL_extension_GL_GREMEDY_string_marker */
    9249, /* GL_extension_GL_HP_image_transform */
    9286, /* GL_extension_GL_IBM_multimode_draw_arrays */
    9330, /* GL_extension_GL_IBM_static_data */
    9364, /* GL_extension_GL_IBM_vertex_array_lists */
    9405, /* GL_extension_GL_IMG_bindless_texture */
    9444, /* GL_extension_GL_IMG_framebuffer_downsample */
    9489, /* GL_extension_GL_IMG_multisampled_render_to_texture */
    9542, /* GL_extension_GL_IMG_user_clip_plane */
    9580, /* GL_extension_GL_INGR_blend_func_separate */
    9623, /* GL_extension_GL_INTEL_framebuffer_CMAA */
    9664, /* GL_extension_GL_INTEL_map_texture */
    9700, /* GL_extension_GL_INTEL_parallel_arrays */
    9740, /* GL_extension_GL_INTEL_performance_query */
    9782, /* GL_extension_GL_KHR_blend_equation_advanced */
    9828, /* GL_extension_GL_KHR_debug */
    9856, /* GL_extension_GL_KHR_parallel_shader_compile */
    9902, /* GL_extension_GL_KHR_robustness */
    9935, /* GL_extension_GL_MESA_resize_buffers */
    9973, /* GL_extension_GL_MESA_window_pos */
    10007, /* GL_extension_GL_NVX_conditional_render */
    10048, /* GL_extension_GL_NVX_linked_gpu_multicast */
    10091, /* GL_extension_GL_NV_alpha_to_coverage_dither_control */
    10145, /* GL_extension_GL_NV_bindless_multi_draw_indirect */
    10195, /* GL_extension_GL_NV_bindless_multi_draw_indirect_count */
    10251, /* GL_extension_GL_NV_bindless_texture */
    10289, /* GL_extension_GL_NV_blend_equation_advanced */
    10334, /* GL_extension_GL_NV_clip_space_w_scaling */
    10376, /* GL_extension_GL_NV_command_list */
    10410, /* GL_extension_GL_NV_conditional_render */
    10450, /* GL_extension_GL_NV_conservative_raster */
    10491, /* GL_extension_GL_NV_conservative_raster_dilate */
    10539, /* GL_extension_GL_NV_conservative_raster_pre_snap_triangles */
    10599, /* GL_extension_GL_NV_copy_buffer */
    10632, /* GL_extension_GL_NV_copy_image */
    10664, /* GL_extension_GL_NV_coverage_sample */
    10701, /* GL_extension_GL_NV_depth_buffer_float */
    10741, /* GL_extension_GL_NV_draw_buffers */
    10775, /* GL_extension_GL_NV_draw_instanced */
    10811, /* GL_extension_GL_NV_draw_texture */
    10845, /* GL_extension_GL_NV_draw_vulkan_image */
    10884, /* GL_extension_GL_NV_evaluators */
    10916, /* GL_extension_GL_NV_explicit_multisample */
    10958, /* GL_extension_GL_NV_fence */
    10985, /* GL_extension_GL_NV_fragment_coverage_to_color */
    11033, /* GL_extension_GL_NV_fragment_program */
    11071, /* GL_extension_GL_NV_framebuffer_blit */
    11109, /* GL_extension_GL_NV_framebuffer_mixed_samples */
    11156, /* GL_extension_GL_NV_framebuffer_multisample */
    11201, /* GL_extension_GL_NV_framebuffer_multisample_coverage */
    11255, /* GL_extension_GL_NV_geometry_program4 */
    11294, /* GL_extension_GL_NV_gpu_multicast */
    11329, /* GL_extension_GL_NV_gpu_program4 */
    11363, /* GL_extension_GL_NV_gpu_program5 */
    11397, /* GL_extension_GL_NV_gpu_shader5 */
    11430, /* GL_extension_GL_NV_half_float */
    11462, /* GL_extension_GL_NV_instanced_arrays */
    11500, /* GL_extension_GL_NV_internalformat_sample_query */
    11549, /* GL_extension_GL_NV_non_square_matrices */
    11590, /* GL_extension_GL_NV_occlusion_query */
    11627, /* GL_extension_GL_NV_parameter_buffer_object */
    11672, /* GL_extension_GL_NV_path_rendering */
    11708, /* GL_extension_GL_NV_pixel_data_range */
    11746, /* GL_extension_GL_NV_point_sprite */
    11780, /* GL_extension_GL_NV_polygon_mode */
    11814, /* GL_extension_GL_NV_present_video */
    11849, /* GL_extension_GL_NV_primitive_restart */
    11888, /* GL_extension_GL_NV_query_resource */
    11924, /* GL_extension_GL_NV_query_resource_tag */
    11964, /* GL_extension_GL_NV_read_buffer */
    11997, /* GL_extension_GL_NV_register_combiners2 */
    12038, /* GL_extension_GL_NV_register_combiners */
    12078, /* GL_extension_GL_NV_sample_locations */
    12116, /* GL_extension_GL_NV_shader_buffer_load */
    12156, /* GL_extension_GL_NV_texture_barrier */
    12193, /* GL_extension_GL_NV_texture_multisample */
    12234, /* GL_extension_GL_NV_transform_feedback2 */
    12275, /* GL_extension_GL_NV_transform_feedback */
    12315, /* GL_extension_GL_NV_vdpau_interop */
    12350, /* GL_extension_GL_NV_vertex_array_range */
    12390, /* GL_extension_GL_NV_vertex_attrib_integer_64bit */
    12439, /* GL_extension_GL_NV_vertex_buffer_unified_memory */
    12489, /* GL_extension_GL_NV_vertex_program4 */
    12526, /* GL_extension_GL_NV_vertex_program */
    12562, /* GL_extension_GL_NV_video_capture */
    12597, /* GL_extension_GL_NV_viewport_array */
    12633, /* GL_extension_GL_NV_viewport_swizzle */
    12671, /* GL_extension_GL_OES_EGL_image */
    12703, /* GL_extension_GL_OES_blend_equation_separate */
    12749, /* GL_extension_GL_OES_blend_func_separate */
    12791, /* GL_extension_GL_OES_blend_subtract */
    12828, /* GL_extension_GL_OES_byte_coordinates */
    12867, /* GL_extension_GL_OES_copy_image */
    12900, /* GL_extension_GL_OES_draw_buffers_indexed */
    12943, /* GL_extension_GL_OES_draw_elements_base_vertex */
    12991, /* GL_extension_GL_OES_draw_texture */
    13026, /* GL_extension_GL_OES_fixed_point */
    13060, /* GL_extension_GL_OES_framebuffer_object */
    13101, /* GL_extension_GL_OES_geometry_shader */
    13139, /* GL_extension_GL_OES_get_program_binary */
    13180, /* GL_extension_GL_OES_mapbuffer */
    13212, /* GL_extension_GL_OES_matrix_palette */
    13249, /* GL_extension_GL_OES_point_size_array */
    13288, /* GL_extension_GL_OES_primitive_bounding_box */
    13333, /* GL_extension_GL_OES_query_matrix */
    13368, /* GL_extension_GL_OES_sample_shading */
    13405, /* GL_extension_GL_OES_single_precision */
    13444, /* GL_extension_GL_OES_tessellation_shader */
    13486, /* GL_extension_GL_OES_texture_3D */
    13519, /* GL_extension_GL_OES_texture_border_clamp */
    13562, /* GL_extension_GL_OES_texture_buffer */
    13599, /* GL_extension_GL_OES_texture_cube_map */
    13638, /* GL_extension_GL_OES_texture_storage_multisample_2d_array */
    13697, /* GL_extension_GL_OES_texture_view */
    13732, /* GL_extension_GL_OES_vertex_array_object */
    13774, /* GL_extension_GL_OES_viewport_array */
    13811, /* GL_extension_GL_OVR_multiview */
    13843, /* GL_extension_GL_OVR_multiview_multisampled_render_to_texture */
    13906, /* GL_extension_GL_PGI_misc_hints */
    13939, /* GL_extension_GL_QCOM_alpha_test */
    13973, /* GL_extension_GL_QCOM_driver_control */
    14011, /* GL_extension_GL_QCOM_extended_get2 */
    14048, /* GL_extension_GL_QCOM_extended_get */
    14084, /* GL_extension_GL_QCOM_framebuffer_foveated */
    14128, /* GL_extension_GL_QCOM_shader_framebuffer_fetch_noncoherent */
    14188, /* GL_extension_GL_QCOM_texture_foveated */
    14228, /* GL_extension_GL_QCOM_tiled_rendering */
    14267, /* GL_extension_GL_SGIS_detail_texture */
    14305, /* GL_extension_GL_SGIS_fog_function */
    14341, /* GL_extension_GL_SGIS_multisample */
    14376, /* GL_extension_GL_SGIS_pixel_texture */
    14413, /* GL_extension_GL_SGIS_point_parameters */
    14453, /* GL_extension_GL_SGIS_sharpen_texture */
    14492, /* GL_extension_GL_SGIS_texture4D */
    14525, /* GL_extension_GL_SGIS_texture_color_mask */
    14567, /* GL_extension_GL_SGIS_texture_filter4 */
    14606, /* GL_extension_GL_SGIX_async */
    14635, /* GL_extension_GL_SGIX_flush_raster */
    14671, /* GL_extension_GL_SGIX_fragment_lighting */
    14712, /* GL_extension_GL_SGIX_framezoom */
    14745, /* GL_extension_GL_SGIX_igloo_interface */
    14784, /* GL_extension_GL_SGIX_instruments */
    14819, /* GL_extension_GL_SGIX_list_priority */
    14856, /* GL_extension_GL_SGIX_pixel_texture */
    14893, /* GL_extension_GL_SGIX_polynomial_ffd */
    14931, /* GL_extension_GL_SGIX_reference_plane */
    14970, /* GL_extension_GL_SGIX_sprite */
    15000, /* GL_extension_GL_SGIX_tag_sample_buffer */
    15041, /* GL_extension_GL_SGI_color_table */
    15075, /* GL_extension_GL_SUNX_constant_data */
    15112, /* GL_extension_GL_SUN_global_alpha */
    15147, /* GL_extension_GL_SUN_mesh_array */
    15180, /* GL_extension_GL_SUN_triangle_list */
    15216, /* GL_extension_GL_SUN_vertex */
    15245, /* OpenGL_ES_1_0 */
    15259, /* OpenGL_ES_2_0 */
    15273, /* OpenGL_ES_3_0 */
    15287, /* OpenGL_ES_3_1 */
    15301, /* OpenGL_ES_3_2 */
    15315, /* always_present */
};

static const char entrypoint_strings[] = {
   'g',
   'l',
   'A',
   'c',
   'c',
   'u',
   'm',
   0, // glAccum
   'g',
   'l',
   'A',
   'c',
   'c',
   'u',
   'm',
   'x',
   'O',
   'E',
   'S',
   0, // glAccumxOES
   'g',
   'l',
   'A',
   'c',
   'q',
   'u',
   'i',
   'r',
   'e',
   'K',
   'e',
   'y',
   'e',
   'd',
   'M',
   'u',
   't',
   'e',
   'x',
   'W',
   'i',
   'n',
   '3',
   '2',
   'E',
   'X',
   'T',
   0, // glAcquireKeyedMutexWin32EXT
   'g',
   'l',
   'A',
   'c',
   't',
   'i',
   'v',
   'e',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'E',
   'X',
   'T',
   0, // glActiveProgramEXT
   'g',
   'l',
   'A',
   'c',
   't',
   'i',
   'v',
   'e',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   0, // glActiveShaderProgram
   'g',
   'l',
   'A',
   'c',
   't',
   'i',
   'v',
   'e',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'E',
   'X',
   'T',
   0, // glActiveShaderProgramEXT
   'g',
   'l',
   'A',
   'c',
   't',
   'i',
   'v',
   'e',
   'S',
   't',
   'e',
   'n',
   'c',
   'i',
   'l',
   'F',
   'a',
   'c',
   'e',
   'E',
   'X',
   'T',
   0, // glActiveStencilFaceEXT
   'g',
   'l',
   'A',
   'c',
   't',
   'i',
   'v',
   'e',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   0, // glActiveTexture
   'g',
   'l',
   'A',
   'c',
   't',
   'i',
   'v',
   'e',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'A',
   'R',
   'B',
   0, // glActiveTextureARB
   'g',
   'l',
   'A',
   'c',
   't',
   'i',
   'v',
   'e',
   'V',
   'a',
   'r',
   'y',
   'i',
   'n',
   'g',
   'N',
   'V',
   0, // glActiveVaryingNV
   'g',
   'l',
   'A',
   'l',
   'p',
   'h',
   'a',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'O',
   'p',
   '1',
   'A',
   'T',
   'I',
   0, // glAlphaFragmentOp1ATI
   'g',
   'l',
   'A',
   'l',
   'p',
   'h',
   'a',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'O',
   'p',
   '2',
   'A',
   'T',
   'I',
   0, // glAlphaFragmentOp2ATI
   'g',
   'l',
   'A',
   'l',
   'p',
   'h',
   'a',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'O',
   'p',
   '3',
   'A',
   'T',
   'I',
   0, // glAlphaFragmentOp3ATI
   'g',
   'l',
   'A',
   'l',
   'p',
   'h',
   'a',
   'F',
   'u',
   'n',
   'c',
   0, // glAlphaFunc
   'g',
   'l',
   'A',
   'l',
   'p',
   'h',
   'a',
   'F',
   'u',
   'n',
   'c',
   'Q',
   'C',
   'O',
   'M',
   0, // glAlphaFuncQCOM
   'g',
   'l',
   'A',
   'l',
   'p',
   'h',
   'a',
   'F',
   'u',
   'n',
   'c',
   'x',
   0, // glAlphaFuncx
   'g',
   'l',
   'A',
   'l',
   'p',
   'h',
   'a',
   'F',
   'u',
   'n',
   'c',
   'x',
   'O',
   'E',
   'S',
   0, // glAlphaFuncxOES
   'g',
   'l',
   'A',
   'l',
   'p',
   'h',
   'a',
   'T',
   'o',
   'C',
   'o',
   'v',
   'e',
   'r',
   'a',
   'g',
   'e',
   'D',
   'i',
   't',
   'h',
   'e',
   'r',
   'C',
   'o',
   'n',
   't',
   'r',
   'o',
   'l',
   'N',
   'V',
   0, // glAlphaToCoverageDitherControlNV
   'g',
   'l',
   'A',
   'p',
   'p',
   'l',
   'y',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'A',
   't',
   't',
   'a',
   'c',
   'h',
   'm',
   'e',
   'n',
   't',
   'C',
   'M',
   'A',
   'A',
   'I',
   'N',
   'T',
   'E',
   'L',
   0, // glApplyFramebufferAttachmentCMAAINTEL
   'g',
   'l',
   'A',
   'p',
   'p',
   'l',
   'y',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'E',
   'X',
   'T',
   0, // glApplyTextureEXT
   'g',
   'l',
   'A',
   'r',
   'e',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   's',
   'R',
   'e',
   's',
   'i',
   'd',
   'e',
   'n',
   't',
   'N',
   'V',
   0, // glAreProgramsResidentNV
   'g',
   'l',
   'A',
   'r',
   'e',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   's',
   'R',
   'e',
   's',
   'i',
   'd',
   'e',
   'n',
   't',
   0, // glAreTexturesResident
   'g',
   'l',
   'A',
   'r',
   'e',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   's',
   'R',
   'e',
   's',
   'i',
   'd',
   'e',
   'n',
   't',
   'E',
   'X',
   'T',
   0, // glAreTexturesResidentEXT
   'g',
   'l',
   'A',
   'r',
   'r',
   'a',
   'y',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   0, // glArrayElement
   'g',
   'l',
   'A',
   'r',
   'r',
   'a',
   'y',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   'E',
   'X',
   'T',
   0, // glArrayElementEXT
   'g',
   'l',
   'A',
   'r',
   'r',
   'a',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'A',
   'T',
   'I',
   0, // glArrayObjectATI
   'g',
   'l',
   'A',
   's',
   'y',
   'n',
   'c',
   'M',
   'a',
   'r',
   'k',
   'e',
   'r',
   'S',
   'G',
   'I',
   'X',
   0, // glAsyncMarkerSGIX
   'g',
   'l',
   'A',
   't',
   't',
   'a',
   'c',
   'h',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'A',
   'R',
   'B',
   0, // glAttachObjectARB
   'g',
   'l',
   'A',
   't',
   't',
   'a',
   'c',
   'h',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   0, // glAttachShader
   'g',
   'l',
   'B',
   'e',
   'g',
   'i',
   'n',
   0, // glBegin
   'g',
   'l',
   'B',
   'e',
   'g',
   'i',
   'n',
   'C',
   'o',
   'n',
   'd',
   'i',
   't',
   'i',
   'o',
   'n',
   'a',
   'l',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   0, // glBeginConditionalRender
   'g',
   'l',
   'B',
   'e',
   'g',
   'i',
   'n',
   'C',
   'o',
   'n',
   'd',
   'i',
   't',
   'i',
   'o',
   'n',
   'a',
   'l',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'N',
   'V',
   0, // glBeginConditionalRenderNV
   'g',
   'l',
   'B',
   'e',
   'g',
   'i',
   'n',
   'C',
   'o',
   'n',
   'd',
   'i',
   't',
   'i',
   'o',
   'n',
   'a',
   'l',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'N',
   'V',
   'X',
   0, // glBeginConditionalRenderNVX
   'g',
   'l',
   'B',
   'e',
   'g',
   'i',
   'n',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'A',
   'T',
   'I',
   0, // glBeginFragmentShaderATI
   'g',
   'l',
   'B',
   'e',
   'g',
   'i',
   'n',
   'O',
   'c',
   'c',
   'l',
   'u',
   's',
   'i',
   'o',
   'n',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'N',
   'V',
   0, // glBeginOcclusionQueryNV
   'g',
   'l',
   'B',
   'e',
   'g',
   'i',
   'n',
   'P',
   'e',
   'r',
   'f',
   'M',
   'o',
   'n',
   'i',
   't',
   'o',
   'r',
   'A',
   'M',
   'D',
   0, // glBeginPerfMonitorAMD
   'g',
   'l',
   'B',
   'e',
   'g',
   'i',
   'n',
   'P',
   'e',
   'r',
   'f',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'I',
   'N',
   'T',
   'E',
   'L',
   0, // glBeginPerfQueryINTEL
   'g',
   'l',
   'B',
   'e',
   'g',
   'i',
   'n',
   'Q',
   'u',
   'e',
   'r',
   'y',
   0, // glBeginQuery
   'g',
   'l',
   'B',
   'e',
   'g',
   'i',
   'n',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'A',
   'R',
   'B',
   0, // glBeginQueryARB
   'g',
   'l',
   'B',
   'e',
   'g',
   'i',
   'n',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'E',
   'X',
   'T',
   0, // glBeginQueryEXT
   'g',
   'l',
   'B',
   'e',
   'g',
   'i',
   'n',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   0, // glBeginQueryIndexed
   'g',
   'l',
   'B',
   'e',
   'g',
   'i',
   'n',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   0, // glBeginTransformFeedback
   'g',
   'l',
   'B',
   'e',
   'g',
   'i',
   'n',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'E',
   'X',
   'T',
   0, // glBeginTransformFeedbackEXT
   'g',
   'l',
   'B',
   'e',
   'g',
   'i',
   'n',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'N',
   'V',
   0, // glBeginTransformFeedbackNV
   'g',
   'l',
   'B',
   'e',
   'g',
   'i',
   'n',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glBeginVertexShaderEXT
   'g',
   'l',
   'B',
   'e',
   'g',
   'i',
   'n',
   'V',
   'i',
   'd',
   'e',
   'o',
   'C',
   'a',
   'p',
   't',
   'u',
   'r',
   'e',
   'N',
   'V',
   0, // glBeginVideoCaptureNV
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   'o',
   'c',
   'a',
   't',
   'i',
   'o',
   'n',
   0, // glBindAttribLocation
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   'o',
   'c',
   'a',
   't',
   'i',
   'o',
   'n',
   'A',
   'R',
   'B',
   0, // glBindAttribLocationARB
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glBindBuffer
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'A',
   'R',
   'B',
   0, // glBindBufferARB
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'B',
   'a',
   's',
   'e',
   0, // glBindBufferBase
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'B',
   'a',
   's',
   'e',
   'E',
   'X',
   'T',
   0, // glBindBufferBaseEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'B',
   'a',
   's',
   'e',
   'N',
   'V',
   0, // glBindBufferBaseNV
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'O',
   'f',
   'f',
   's',
   'e',
   't',
   'E',
   'X',
   'T',
   0, // glBindBufferOffsetEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'O',
   'f',
   'f',
   's',
   'e',
   't',
   'N',
   'V',
   0, // glBindBufferOffsetNV
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'a',
   'n',
   'g',
   'e',
   0, // glBindBufferRange
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'a',
   'n',
   'g',
   'e',
   'E',
   'X',
   'T',
   0, // glBindBufferRangeEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'a',
   'n',
   'g',
   'e',
   'N',
   'V',
   0, // glBindBufferRangeNV
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   'B',
   'a',
   's',
   'e',
   0, // glBindBuffersBase
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   'R',
   'a',
   'n',
   'g',
   'e',
   0, // glBindBuffersRange
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'F',
   'r',
   'a',
   'g',
   'D',
   'a',
   't',
   'a',
   'L',
   'o',
   'c',
   'a',
   't',
   'i',
   'o',
   'n',
   0, // glBindFragDataLocation
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'F',
   'r',
   'a',
   'g',
   'D',
   'a',
   't',
   'a',
   'L',
   'o',
   'c',
   'a',
   't',
   'i',
   'o',
   'n',
   'E',
   'X',
   'T',
   0, // glBindFragDataLocationEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'F',
   'r',
   'a',
   'g',
   'D',
   'a',
   't',
   'a',
   'L',
   'o',
   'c',
   'a',
   't',
   'i',
   'o',
   'n',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   0, // glBindFragDataLocationIndexed
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'F',
   'r',
   'a',
   'g',
   'D',
   'a',
   't',
   'a',
   'L',
   'o',
   'c',
   'a',
   't',
   'i',
   'o',
   'n',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'E',
   'X',
   'T',
   0, // glBindFragDataLocationIndexedEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'A',
   'T',
   'I',
   0, // glBindFragmentShaderATI
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glBindFramebuffer
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glBindFramebufferEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'O',
   'E',
   'S',
   0, // glBindFramebufferOES
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'I',
   'm',
   'a',
   'g',
   'e',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   0, // glBindImageTexture
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'I',
   'm',
   'a',
   'g',
   'e',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'E',
   'X',
   'T',
   0, // glBindImageTextureEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'I',
   'm',
   'a',
   'g',
   'e',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   's',
   0, // glBindImageTextures
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'L',
   'i',
   'g',
   'h',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glBindLightParameterEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'M',
   'a',
   't',
   'e',
   'r',
   'i',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glBindMaterialParameterEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'E',
   'X',
   'T',
   0, // glBindMultiTextureEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glBindParameterEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'A',
   'R',
   'B',
   0, // glBindProgramARB
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'N',
   'V',
   0, // glBindProgramNV
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'i',
   'p',
   'e',
   'l',
   'i',
   'n',
   'e',
   0, // glBindProgramPipeline
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'i',
   'p',
   'e',
   'l',
   'i',
   'n',
   'e',
   'E',
   'X',
   'T',
   0, // glBindProgramPipelineEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glBindRenderbuffer
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glBindRenderbufferEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'O',
   'E',
   'S',
   0, // glBindRenderbufferOES
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   0, // glBindSampler
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   's',
   0, // glBindSamplers
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glBindTexGenParameterEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   0, // glBindTexture
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'E',
   'X',
   'T',
   0, // glBindTextureEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'U',
   'n',
   'i',
   't',
   0, // glBindTextureUnit
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'U',
   'n',
   'i',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glBindTextureUnitParameterEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   's',
   0, // glBindTextures
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   0, // glBindTransformFeedback
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'N',
   'V',
   0, // glBindTransformFeedbackNV
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   0, // glBindVertexArray
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glBindVertexArrayAPPLE
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'O',
   'E',
   'S',
   0, // glBindVertexArrayOES
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glBindVertexBuffer
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   0, // glBindVertexBuffers
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glBindVertexShaderEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'V',
   'i',
   'd',
   'e',
   'o',
   'C',
   'a',
   'p',
   't',
   'u',
   'r',
   'e',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'N',
   'V',
   0, // glBindVideoCaptureStreamBufferNV
   'g',
   'l',
   'B',
   'i',
   'n',
   'd',
   'V',
   'i',
   'd',
   'e',
   'o',
   'C',
   'a',
   'p',
   't',
   'u',
   'r',
   'e',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'N',
   'V',
   0, // glBindVideoCaptureStreamTextureNV
   'g',
   'l',
   'B',
   'i',
   'n',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'b',
   'E',
   'X',
   'T',
   0, // glBinormal3bEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'b',
   'v',
   'E',
   'X',
   'T',
   0, // glBinormal3bvEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'd',
   'E',
   'X',
   'T',
   0, // glBinormal3dEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glBinormal3dvEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'f',
   'E',
   'X',
   'T',
   0, // glBinormal3fEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glBinormal3fvEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'i',
   'E',
   'X',
   'T',
   0, // glBinormal3iEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glBinormal3ivEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   's',
   'E',
   'X',
   'T',
   0, // glBinormal3sEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   's',
   'v',
   'E',
   'X',
   'T',
   0, // glBinormal3svEXT
   'g',
   'l',
   'B',
   'i',
   'n',
   'o',
   'r',
   'm',
   'a',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glBinormalPointerEXT
   'g',
   'l',
   'B',
   'i',
   't',
   'm',
   'a',
   'p',
   0, // glBitmap
   'g',
   'l',
   'B',
   'i',
   't',
   'm',
   'a',
   'p',
   'x',
   'O',
   'E',
   'S',
   0, // glBitmapxOES
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'B',
   'a',
   'r',
   'r',
   'i',
   'e',
   'r',
   0, // glBlendBarrier
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'B',
   'a',
   'r',
   'r',
   'i',
   'e',
   'r',
   'K',
   'H',
   'R',
   0, // glBlendBarrierKHR
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'B',
   'a',
   'r',
   'r',
   'i',
   'e',
   'r',
   'N',
   'V',
   0, // glBlendBarrierNV
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'C',
   'o',
   'l',
   'o',
   'r',
   0, // glBlendColor
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'C',
   'o',
   'l',
   'o',
   'r',
   'E',
   'X',
   'T',
   0, // glBlendColorEXT
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'C',
   'o',
   'l',
   'o',
   'r',
   'x',
   'O',
   'E',
   'S',
   0, // glBlendColorxOES
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'E',
   'q',
   'u',
   'a',
   't',
   'i',
   'o',
   'n',
   0, // glBlendEquation
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'E',
   'q',
   'u',
   'a',
   't',
   'i',
   'o',
   'n',
   'E',
   'X',
   'T',
   0, // glBlendEquationEXT
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'E',
   'q',
   'u',
   'a',
   't',
   'i',
   'o',
   'n',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'A',
   'M',
   'D',
   0, // glBlendEquationIndexedAMD
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'E',
   'q',
   'u',
   'a',
   't',
   'i',
   'o',
   'n',
   'O',
   'E',
   'S',
   0, // glBlendEquationOES
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'E',
   'q',
   'u',
   'a',
   't',
   'i',
   'o',
   'n',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   't',
   'e',
   0, // glBlendEquationSeparate
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'E',
   'q',
   'u',
   'a',
   't',
   'i',
   'o',
   'n',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   't',
   'e',
   'E',
   'X',
   'T',
   0, // glBlendEquationSeparateEXT
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'E',
   'q',
   'u',
   'a',
   't',
   'i',
   'o',
   'n',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   't',
   'e',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'A',
   'M',
   'D',
   0, // glBlendEquationSeparateIndexedAMD
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'E',
   'q',
   'u',
   'a',
   't',
   'i',
   'o',
   'n',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   't',
   'e',
   'O',
   'E',
   'S',
   0, // glBlendEquationSeparateOES
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'E',
   'q',
   'u',
   'a',
   't',
   'i',
   'o',
   'n',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   't',
   'e',
   'i',
   0, // glBlendEquationSeparatei
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'E',
   'q',
   'u',
   'a',
   't',
   'i',
   'o',
   'n',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   't',
   'e',
   'i',
   'A',
   'R',
   'B',
   0, // glBlendEquationSeparateiARB
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'E',
   'q',
   'u',
   'a',
   't',
   'i',
   'o',
   'n',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   't',
   'e',
   'i',
   'E',
   'X',
   'T',
   0, // glBlendEquationSeparateiEXT
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'E',
   'q',
   'u',
   'a',
   't',
   'i',
   'o',
   'n',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   't',
   'e',
   'i',
   'O',
   'E',
   'S',
   0, // glBlendEquationSeparateiOES
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'E',
   'q',
   'u',
   'a',
   't',
   'i',
   'o',
   'n',
   'i',
   0, // glBlendEquationi
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'E',
   'q',
   'u',
   'a',
   't',
   'i',
   'o',
   'n',
   'i',
   'A',
   'R',
   'B',
   0, // glBlendEquationiARB
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'E',
   'q',
   'u',
   'a',
   't',
   'i',
   'o',
   'n',
   'i',
   'E',
   'X',
   'T',
   0, // glBlendEquationiEXT
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'E',
   'q',
   'u',
   'a',
   't',
   'i',
   'o',
   'n',
   'i',
   'O',
   'E',
   'S',
   0, // glBlendEquationiOES
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'F',
   'u',
   'n',
   'c',
   0, // glBlendFunc
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'F',
   'u',
   'n',
   'c',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'A',
   'M',
   'D',
   0, // glBlendFuncIndexedAMD
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'F',
   'u',
   'n',
   'c',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   't',
   'e',
   0, // glBlendFuncSeparate
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'F',
   'u',
   'n',
   'c',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   't',
   'e',
   'E',
   'X',
   'T',
   0, // glBlendFuncSeparateEXT
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'F',
   'u',
   'n',
   'c',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   't',
   'e',
   'I',
   'N',
   'G',
   'R',
   0, // glBlendFuncSeparateINGR
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'F',
   'u',
   'n',
   'c',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   't',
   'e',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'A',
   'M',
   'D',
   0, // glBlendFuncSeparateIndexedAMD
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'F',
   'u',
   'n',
   'c',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   't',
   'e',
   'O',
   'E',
   'S',
   0, // glBlendFuncSeparateOES
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'F',
   'u',
   'n',
   'c',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   't',
   'e',
   'i',
   0, // glBlendFuncSeparatei
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'F',
   'u',
   'n',
   'c',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   't',
   'e',
   'i',
   'A',
   'R',
   'B',
   0, // glBlendFuncSeparateiARB
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'F',
   'u',
   'n',
   'c',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   't',
   'e',
   'i',
   'E',
   'X',
   'T',
   0, // glBlendFuncSeparateiEXT
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'F',
   'u',
   'n',
   'c',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   't',
   'e',
   'i',
   'O',
   'E',
   'S',
   0, // glBlendFuncSeparateiOES
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'F',
   'u',
   'n',
   'c',
   'i',
   0, // glBlendFunci
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'F',
   'u',
   'n',
   'c',
   'i',
   'A',
   'R',
   'B',
   0, // glBlendFunciARB
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'F',
   'u',
   'n',
   'c',
   'i',
   'E',
   'X',
   'T',
   0, // glBlendFunciEXT
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'F',
   'u',
   'n',
   'c',
   'i',
   'O',
   'E',
   'S',
   0, // glBlendFunciOES
   'g',
   'l',
   'B',
   'l',
   'e',
   'n',
   'd',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'N',
   'V',
   0, // glBlendParameteriNV
   'g',
   'l',
   'B',
   'l',
   'i',
   't',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glBlitFramebuffer
   'g',
   'l',
   'B',
   'l',
   'i',
   't',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'A',
   'N',
   'G',
   'L',
   'E',
   0, // glBlitFramebufferANGLE
   'g',
   'l',
   'B',
   'l',
   'i',
   't',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glBlitFramebufferEXT
   'g',
   'l',
   'B',
   'l',
   'i',
   't',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'N',
   'V',
   0, // glBlitFramebufferNV
   'g',
   'l',
   'B',
   'l',
   'i',
   't',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glBlitNamedFramebuffer
   'g',
   'l',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'A',
   'd',
   'd',
   'r',
   'e',
   's',
   's',
   'R',
   'a',
   'n',
   'g',
   'e',
   'N',
   'V',
   0, // glBufferAddressRangeNV
   'g',
   'l',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'D',
   'a',
   't',
   'a',
   0, // glBufferData
   'g',
   'l',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'D',
   'a',
   't',
   'a',
   'A',
   'R',
   'B',
   0, // glBufferDataARB
   'g',
   'l',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'g',
   'e',
   'C',
   'o',
   'm',
   'm',
   'i',
   't',
   'm',
   'e',
   'n',
   't',
   'A',
   'R',
   'B',
   0, // glBufferPageCommitmentARB
   'g',
   'l',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glBufferParameteriAPPLE
   'g',
   'l',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   0, // glBufferStorage
   'g',
   'l',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'E',
   'X',
   'T',
   0, // glBufferStorageEXT
   'g',
   'l',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'E',
   'x',
   't',
   'e',
   'r',
   'n',
   'a',
   'l',
   'E',
   'X',
   'T',
   0, // glBufferStorageExternalEXT
   'g',
   'l',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'M',
   'e',
   'm',
   'E',
   'X',
   'T',
   0, // glBufferStorageMemEXT
   'g',
   'l',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   0, // glBufferSubData
   'g',
   'l',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   'A',
   'R',
   'B',
   0, // glBufferSubDataARB
   'g',
   'l',
   'C',
   'a',
   'l',
   'l',
   'C',
   'o',
   'm',
   'm',
   'a',
   'n',
   'd',
   'L',
   'i',
   's',
   't',
   'N',
   'V',
   0, // glCallCommandListNV
   'g',
   'l',
   'C',
   'a',
   'l',
   'l',
   'L',
   'i',
   's',
   't',
   0, // glCallList
   'g',
   'l',
   'C',
   'a',
   'l',
   'l',
   'L',
   'i',
   's',
   't',
   's',
   0, // glCallLists
   'g',
   'l',
   'C',
   'h',
   'e',
   'c',
   'k',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'a',
   't',
   'u',
   's',
   0, // glCheckFramebufferStatus
   'g',
   'l',
   'C',
   'h',
   'e',
   'c',
   'k',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'a',
   't',
   'u',
   's',
   'E',
   'X',
   'T',
   0, // glCheckFramebufferStatusEXT
   'g',
   'l',
   'C',
   'h',
   'e',
   'c',
   'k',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'a',
   't',
   'u',
   's',
   'O',
   'E',
   'S',
   0, // glCheckFramebufferStatusOES
   'g',
   'l',
   'C',
   'h',
   'e',
   'c',
   'k',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'a',
   't',
   'u',
   's',
   0, // glCheckNamedFramebufferStatus
   'g',
   'l',
   'C',
   'h',
   'e',
   'c',
   'k',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'a',
   't',
   'u',
   's',
   'E',
   'X',
   'T',
   0, // glCheckNamedFramebufferStatusEXT
   'g',
   'l',
   'C',
   'l',
   'a',
   'm',
   'p',
   'C',
   'o',
   'l',
   'o',
   'r',
   0, // glClampColor
   'g',
   'l',
   'C',
   'l',
   'a',
   'm',
   'p',
   'C',
   'o',
   'l',
   'o',
   'r',
   'A',
   'R',
   'B',
   0, // glClampColorARB
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   0, // glClear
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'A',
   'c',
   'c',
   'u',
   'm',
   0, // glClearAccum
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'A',
   'c',
   'c',
   'u',
   'm',
   'x',
   'O',
   'E',
   'S',
   0, // glClearAccumxOES
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'D',
   'a',
   't',
   'a',
   0, // glClearBufferData
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   0, // glClearBufferSubData
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'f',
   'i',
   0, // glClearBufferfi
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'f',
   'v',
   0, // glClearBufferfv
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'i',
   'v',
   0, // glClearBufferiv
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'u',
   'i',
   'v',
   0, // glClearBufferuiv
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'C',
   'o',
   'l',
   'o',
   'r',
   0, // glClearColor
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'C',
   'o',
   'l',
   'o',
   'r',
   'I',
   'i',
   'E',
   'X',
   'T',
   0, // glClearColorIiEXT
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'C',
   'o',
   'l',
   'o',
   'r',
   'I',
   'u',
   'i',
   'E',
   'X',
   'T',
   0, // glClearColorIuiEXT
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'C',
   'o',
   'l',
   'o',
   'r',
   'x',
   0, // glClearColorx
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'C',
   'o',
   'l',
   'o',
   'r',
   'x',
   'O',
   'E',
   'S',
   0, // glClearColorxOES
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'D',
   'e',
   'p',
   't',
   'h',
   0, // glClearDepth
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'D',
   'e',
   'p',
   't',
   'h',
   'd',
   'N',
   'V',
   0, // glClearDepthdNV
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'D',
   'e',
   'p',
   't',
   'h',
   'f',
   0, // glClearDepthf
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'D',
   'e',
   'p',
   't',
   'h',
   'f',
   'O',
   'E',
   'S',
   0, // glClearDepthfOES
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'D',
   'e',
   'p',
   't',
   'h',
   'x',
   0, // glClearDepthx
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'D',
   'e',
   'p',
   't',
   'h',
   'x',
   'O',
   'E',
   'S',
   0, // glClearDepthxOES
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'I',
   'n',
   'd',
   'e',
   'x',
   0, // glClearIndex
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'D',
   'a',
   't',
   'a',
   0, // glClearNamedBufferData
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'D',
   'a',
   't',
   'a',
   'E',
   'X',
   'T',
   0, // glClearNamedBufferDataEXT
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   0, // glClearNamedBufferSubData
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   'E',
   'X',
   'T',
   0, // glClearNamedBufferSubDataEXT
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'f',
   'i',
   0, // glClearNamedFramebufferfi
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'f',
   'v',
   0, // glClearNamedFramebufferfv
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'i',
   'v',
   0, // glClearNamedFramebufferiv
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'u',
   'i',
   'v',
   0, // glClearNamedFramebufferuiv
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'P',
   'i',
   'x',
   'e',
   'l',
   'L',
   'o',
   'c',
   'a',
   'l',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'u',
   'i',
   'E',
   'X',
   'T',
   0, // glClearPixelLocalStorageuiEXT
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'S',
   't',
   'e',
   'n',
   'c',
   'i',
   'l',
   0, // glClearStencil
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   0, // glClearTexImage
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   'E',
   'X',
   'T',
   0, // glClearTexImageEXT
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   0, // glClearTexSubImage
   'g',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   'E',
   'X',
   'T',
   0, // glClearTexSubImageEXT
   'g',
   'l',
   'C',
   'l',
   'i',
   'e',
   'n',
   't',
   'A',
   'c',
   't',
   'i',
   'v',
   'e',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   0, // glClientActiveTexture
   'g',
   'l',
   'C',
   'l',
   'i',
   'e',
   'n',
   't',
   'A',
   'c',
   't',
   'i',
   'v',
   'e',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'A',
   'R',
   'B',
   0, // glClientActiveTextureARB
   'g',
   'l',
   'C',
   'l',
   'i',
   'e',
   'n',
   't',
   'A',
   'c',
   't',
   'i',
   'v',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   'A',
   'T',
   'I',
   0, // glClientActiveVertexStreamATI
   'g',
   'l',
   'C',
   'l',
   'i',
   'e',
   'n',
   't',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'D',
   'e',
   'f',
   'a',
   'u',
   'l',
   't',
   'E',
   'X',
   'T',
   0, // glClientAttribDefaultEXT
   'g',
   'l',
   'C',
   'l',
   'i',
   'e',
   'n',
   't',
   'W',
   'a',
   'i',
   't',
   'S',
   'y',
   'n',
   'c',
   0, // glClientWaitSync
   'g',
   'l',
   'C',
   'l',
   'i',
   'e',
   'n',
   't',
   'W',
   'a',
   'i',
   't',
   'S',
   'y',
   'n',
   'c',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glClientWaitSyncAPPLE
   'g',
   'l',
   'C',
   'l',
   'i',
   'p',
   'C',
   'o',
   'n',
   't',
   'r',
   'o',
   'l',
   0, // glClipControl
   'g',
   'l',
   'C',
   'l',
   'i',
   'p',
   'C',
   'o',
   'n',
   't',
   'r',
   'o',
   'l',
   'E',
   'X',
   'T',
   0, // glClipControlEXT
   'g',
   'l',
   'C',
   'l',
   'i',
   'p',
   'P',
   'l',
   'a',
   'n',
   'e',
   0, // glClipPlane
   'g',
   'l',
   'C',
   'l',
   'i',
   'p',
   'P',
   'l',
   'a',
   'n',
   'e',
   'f',
   0, // glClipPlanef
   'g',
   'l',
   'C',
   'l',
   'i',
   'p',
   'P',
   'l',
   'a',
   'n',
   'e',
   'f',
   'I',
   'M',
   'G',
   0, // glClipPlanefIMG
   'g',
   'l',
   'C',
   'l',
   'i',
   'p',
   'P',
   'l',
   'a',
   'n',
   'e',
   'f',
   'O',
   'E',
   'S',
   0, // glClipPlanefOES
   'g',
   'l',
   'C',
   'l',
   'i',
   'p',
   'P',
   'l',
   'a',
   'n',
   'e',
   'x',
   0, // glClipPlanex
   'g',
   'l',
   'C',
   'l',
   'i',
   'p',
   'P',
   'l',
   'a',
   'n',
   'e',
   'x',
   'I',
   'M',
   'G',
   0, // glClipPlanexIMG
   'g',
   'l',
   'C',
   'l',
   'i',
   'p',
   'P',
   'l',
   'a',
   'n',
   'e',
   'x',
   'O',
   'E',
   'S',
   0, // glClipPlanexOES
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'b',
   0, // glColor3b
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'b',
   'v',
   0, // glColor3bv
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'd',
   0, // glColor3d
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'd',
   'v',
   0, // glColor3dv
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'f',
   0, // glColor3f
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'S',
   'U',
   'N',
   0, // glColor3fVertex3fSUN
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'v',
   'S',
   'U',
   'N',
   0, // glColor3fVertex3fvSUN
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'f',
   'v',
   0, // glColor3fv
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'h',
   'N',
   'V',
   0, // glColor3hNV
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'h',
   'v',
   'N',
   'V',
   0, // glColor3hvNV
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'i',
   0, // glColor3i
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'i',
   'v',
   0, // glColor3iv
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   's',
   0, // glColor3s
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   's',
   'v',
   0, // glColor3sv
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'u',
   'b',
   0, // glColor3ub
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'u',
   'b',
   'v',
   0, // glColor3ubv
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'u',
   'i',
   0, // glColor3ui
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'u',
   'i',
   'v',
   0, // glColor3uiv
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'u',
   's',
   0, // glColor3us
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'u',
   's',
   'v',
   0, // glColor3usv
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'x',
   'O',
   'E',
   'S',
   0, // glColor3xOES
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glColor3xvOES
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'b',
   0, // glColor4b
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'b',
   'v',
   0, // glColor4bv
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'd',
   0, // glColor4d
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'd',
   'v',
   0, // glColor4dv
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'f',
   0, // glColor4f
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'f',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'S',
   'U',
   'N',
   0, // glColor4fNormal3fVertex3fSUN
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'f',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'v',
   'S',
   'U',
   'N',
   0, // glColor4fNormal3fVertex3fvSUN
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'f',
   'v',
   0, // glColor4fv
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'h',
   'N',
   'V',
   0, // glColor4hNV
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'h',
   'v',
   'N',
   'V',
   0, // glColor4hvNV
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'i',
   0, // glColor4i
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'i',
   'v',
   0, // glColor4iv
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   's',
   0, // glColor4s
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   's',
   'v',
   0, // glColor4sv
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'u',
   'b',
   0, // glColor4ub
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'u',
   'b',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '2',
   'f',
   'S',
   'U',
   'N',
   0, // glColor4ubVertex2fSUN
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'u',
   'b',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '2',
   'f',
   'v',
   'S',
   'U',
   'N',
   0, // glColor4ubVertex2fvSUN
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'u',
   'b',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'S',
   'U',
   'N',
   0, // glColor4ubVertex3fSUN
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'u',
   'b',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'v',
   'S',
   'U',
   'N',
   0, // glColor4ubVertex3fvSUN
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'u',
   'b',
   'v',
   0, // glColor4ubv
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'u',
   'i',
   0, // glColor4ui
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'u',
   'i',
   'v',
   0, // glColor4uiv
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'u',
   's',
   0, // glColor4us
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'u',
   's',
   'v',
   0, // glColor4usv
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'x',
   0, // glColor4x
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'x',
   'O',
   'E',
   'S',
   0, // glColor4xOES
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glColor4xvOES
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'F',
   'o',
   'r',
   'm',
   'a',
   't',
   'N',
   'V',
   0, // glColorFormatNV
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'O',
   'p',
   '1',
   'A',
   'T',
   'I',
   0, // glColorFragmentOp1ATI
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'O',
   'p',
   '2',
   'A',
   'T',
   'I',
   0, // glColorFragmentOp2ATI
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'O',
   'p',
   '3',
   'A',
   'T',
   'I',
   0, // glColorFragmentOp3ATI
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'M',
   'a',
   's',
   'k',
   0, // glColorMask
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'M',
   'a',
   's',
   'k',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'E',
   'X',
   'T',
   0, // glColorMaskIndexedEXT
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'M',
   'a',
   's',
   'k',
   'i',
   0, // glColorMaski
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'M',
   'a',
   's',
   'k',
   'i',
   'E',
   'X',
   'T',
   0, // glColorMaskiEXT
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'M',
   'a',
   's',
   'k',
   'i',
   'O',
   'E',
   'S',
   0, // glColorMaskiOES
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'M',
   'a',
   't',
   'e',
   'r',
   'i',
   'a',
   'l',
   0, // glColorMaterial
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'P',
   '3',
   'u',
   'i',
   0, // glColorP3ui
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'P',
   '3',
   'u',
   'i',
   'v',
   0, // glColorP3uiv
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'P',
   '4',
   'u',
   'i',
   0, // glColorP4ui
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'P',
   '4',
   'u',
   'i',
   'v',
   0, // glColorP4uiv
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   0, // glColorPointer
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glColorPointerEXT
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'L',
   'i',
   's',
   't',
   'I',
   'B',
   'M',
   0, // glColorPointerListIBM
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'v',
   'I',
   'N',
   'T',
   'E',
   'L',
   0, // glColorPointervINTEL
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'S',
   'u',
   'b',
   'T',
   'a',
   'b',
   'l',
   'e',
   0, // glColorSubTable
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'S',
   'u',
   'b',
   'T',
   'a',
   'b',
   'l',
   'e',
   'E',
   'X',
   'T',
   0, // glColorSubTableEXT
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'T',
   'a',
   'b',
   'l',
   'e',
   0, // glColorTable
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'T',
   'a',
   'b',
   'l',
   'e',
   'E',
   'X',
   'T',
   0, // glColorTableEXT
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'T',
   'a',
   'b',
   'l',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   0, // glColorTableParameterfv
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'T',
   'a',
   'b',
   'l',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'S',
   'G',
   'I',
   0, // glColorTableParameterfvSGI
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'T',
   'a',
   'b',
   'l',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   0, // glColorTableParameteriv
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'T',
   'a',
   'b',
   'l',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'S',
   'G',
   'I',
   0, // glColorTableParameterivSGI
   'g',
   'l',
   'C',
   'o',
   'l',
   'o',
   'r',
   'T',
   'a',
   'b',
   'l',
   'e',
   'S',
   'G',
   'I',
   0, // glColorTableSGI
   'g',
   'l',
   'C',
   'o',
   'm',
   'b',
   'i',
   'n',
   'e',
   'r',
   'I',
   'n',
   'p',
   'u',
   't',
   'N',
   'V',
   0, // glCombinerInputNV
   'g',
   'l',
   'C',
   'o',
   'm',
   'b',
   'i',
   'n',
   'e',
   'r',
   'O',
   'u',
   't',
   'p',
   'u',
   't',
   'N',
   'V',
   0, // glCombinerOutputNV
   'g',
   'l',
   'C',
   'o',
   'm',
   'b',
   'i',
   'n',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'N',
   'V',
   0, // glCombinerParameterfNV
   'g',
   'l',
   'C',
   'o',
   'm',
   'b',
   'i',
   'n',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'N',
   'V',
   0, // glCombinerParameterfvNV
   'g',
   'l',
   'C',
   'o',
   'm',
   'b',
   'i',
   'n',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'N',
   'V',
   0, // glCombinerParameteriNV
   'g',
   'l',
   'C',
   'o',
   'm',
   'b',
   'i',
   'n',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'N',
   'V',
   0, // glCombinerParameterivNV
   'g',
   'l',
   'C',
   'o',
   'm',
   'b',
   'i',
   'n',
   'e',
   'r',
   'S',
   't',
   'a',
   'g',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'N',
   'V',
   0, // glCombinerStageParameterfvNV
   'g',
   'l',
   'C',
   'o',
   'm',
   'm',
   'a',
   'n',
   'd',
   'L',
   'i',
   's',
   't',
   'S',
   'e',
   'g',
   'm',
   'e',
   'n',
   't',
   's',
   'N',
   'V',
   0, // glCommandListSegmentsNV
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'i',
   'l',
   'e',
   'C',
   'o',
   'm',
   'm',
   'a',
   'n',
   'd',
   'L',
   'i',
   's',
   't',
   'N',
   'V',
   0, // glCompileCommandListNV
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'i',
   'l',
   'e',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   0, // glCompileShader
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'i',
   'l',
   'e',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'A',
   'R',
   'B',
   0, // glCompileShaderARB
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'i',
   'l',
   'e',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'I',
   'n',
   'c',
   'l',
   'u',
   'd',
   'e',
   'A',
   'R',
   'B',
   0, // glCompileShaderIncludeARB
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   'E',
   'X',
   'T',
   0, // glCompressedMultiTexImage1DEXT
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   'E',
   'X',
   'T',
   0, // glCompressedMultiTexImage2DEXT
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   'E',
   'X',
   'T',
   0, // glCompressedMultiTexImage3DEXT
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   'E',
   'X',
   'T',
   0, // glCompressedMultiTexSubImage1DEXT
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   'E',
   'X',
   'T',
   0, // glCompressedMultiTexSubImage2DEXT
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   'E',
   'X',
   'T',
   0, // glCompressedMultiTexSubImage3DEXT
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   0, // glCompressedTexImage1D
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   'A',
   'R',
   'B',
   0, // glCompressedTexImage1DARB
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   0, // glCompressedTexImage2D
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   'A',
   'R',
   'B',
   0, // glCompressedTexImage2DARB
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   0, // glCompressedTexImage3D
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   'A',
   'R',
   'B',
   0, // glCompressedTexImage3DARB
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   'O',
   'E',
   'S',
   0, // glCompressedTexImage3DOES
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   0, // glCompressedTexSubImage1D
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   'A',
   'R',
   'B',
   0, // glCompressedTexSubImage1DARB
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   0, // glCompressedTexSubImage2D
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   'A',
   'R',
   'B',
   0, // glCompressedTexSubImage2DARB
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   0, // glCompressedTexSubImage3D
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   'A',
   'R',
   'B',
   0, // glCompressedTexSubImage3DARB
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   'O',
   'E',
   'S',
   0, // glCompressedTexSubImage3DOES
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   'E',
   'X',
   'T',
   0, // glCompressedTextureImage1DEXT
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   'E',
   'X',
   'T',
   0, // glCompressedTextureImage2DEXT
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   'E',
   'X',
   'T',
   0, // glCompressedTextureImage3DEXT
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   0, // glCompressedTextureSubImage1D
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   'E',
   'X',
   'T',
   0, // glCompressedTextureSubImage1DEXT
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   0, // glCompressedTextureSubImage2D
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   'E',
   'X',
   'T',
   0, // glCompressedTextureSubImage2DEXT
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   0, // glCompressedTextureSubImage3D
   'g',
   'l',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   'E',
   'X',
   'T',
   0, // glCompressedTextureSubImage3DEXT
   'g',
   'l',
   'C',
   'o',
   'n',
   's',
   'e',
   'r',
   'v',
   'a',
   't',
   'i',
   'v',
   'e',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'N',
   'V',
   0, // glConservativeRasterParameterfNV
   'g',
   'l',
   'C',
   'o',
   'n',
   's',
   'e',
   'r',
   'v',
   'a',
   't',
   'i',
   'v',
   'e',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'N',
   'V',
   0, // glConservativeRasterParameteriNV
   'g',
   'l',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'F',
   'i',
   'l',
   't',
   'e',
   'r',
   '1',
   'D',
   0, // glConvolutionFilter1D
   'g',
   'l',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'F',
   'i',
   'l',
   't',
   'e',
   'r',
   '1',
   'D',
   'E',
   'X',
   'T',
   0, // glConvolutionFilter1DEXT
   'g',
   'l',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'F',
   'i',
   'l',
   't',
   'e',
   'r',
   '2',
   'D',
   0, // glConvolutionFilter2D
   'g',
   'l',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'F',
   'i',
   'l',
   't',
   'e',
   'r',
   '2',
   'D',
   'E',
   'X',
   'T',
   0, // glConvolutionFilter2DEXT
   'g',
   'l',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   0, // glConvolutionParameterf
   'g',
   'l',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'E',
   'X',
   'T',
   0, // glConvolutionParameterfEXT
   'g',
   'l',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   0, // glConvolutionParameterfv
   'g',
   'l',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glConvolutionParameterfvEXT
   'g',
   'l',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   0, // glConvolutionParameteri
   'g',
   'l',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'E',
   'X',
   'T',
   0, // glConvolutionParameteriEXT
   'g',
   'l',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   0, // glConvolutionParameteriv
   'g',
   'l',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glConvolutionParameterivEXT
   'g',
   'l',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'x',
   'O',
   'E',
   'S',
   0, // glConvolutionParameterxOES
   'g',
   'l',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glConvolutionParameterxvOES
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   0, // glCopyBufferSubData
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   'N',
   'V',
   0, // glCopyBufferSubDataNV
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   'S',
   'u',
   'b',
   'T',
   'a',
   'b',
   'l',
   'e',
   0, // glCopyColorSubTable
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   'S',
   'u',
   'b',
   'T',
   'a',
   'b',
   'l',
   'e',
   'E',
   'X',
   'T',
   0, // glCopyColorSubTableEXT
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   'T',
   'a',
   'b',
   'l',
   'e',
   0, // glCopyColorTable
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   'T',
   'a',
   'b',
   'l',
   'e',
   'S',
   'G',
   'I',
   0, // glCopyColorTableSGI
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'F',
   'i',
   'l',
   't',
   'e',
   'r',
   '1',
   'D',
   0, // glCopyConvolutionFilter1D
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'F',
   'i',
   'l',
   't',
   'e',
   'r',
   '1',
   'D',
   'E',
   'X',
   'T',
   0, // glCopyConvolutionFilter1DEXT
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'F',
   'i',
   'l',
   't',
   'e',
   'r',
   '2',
   'D',
   0, // glCopyConvolutionFilter2D
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'F',
   'i',
   'l',
   't',
   'e',
   'r',
   '2',
   'D',
   'E',
   'X',
   'T',
   0, // glCopyConvolutionFilter2DEXT
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'I',
   'm',
   'a',
   'g',
   'e',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   0, // glCopyImageSubData
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'I',
   'm',
   'a',
   'g',
   'e',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   'E',
   'X',
   'T',
   0, // glCopyImageSubDataEXT
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'I',
   'm',
   'a',
   'g',
   'e',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   'N',
   'V',
   0, // glCopyImageSubDataNV
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'I',
   'm',
   'a',
   'g',
   'e',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   'O',
   'E',
   'S',
   0, // glCopyImageSubDataOES
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   'E',
   'X',
   'T',
   0, // glCopyMultiTexImage1DEXT
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   'E',
   'X',
   'T',
   0, // glCopyMultiTexImage2DEXT
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   'E',
   'X',
   'T',
   0, // glCopyMultiTexSubImage1DEXT
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   'E',
   'X',
   'T',
   0, // glCopyMultiTexSubImage2DEXT
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   'E',
   'X',
   'T',
   0, // glCopyMultiTexSubImage3DEXT
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   0, // glCopyNamedBufferSubData
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'P',
   'a',
   't',
   'h',
   'N',
   'V',
   0, // glCopyPathNV
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'P',
   'i',
   'x',
   'e',
   'l',
   's',
   0, // glCopyPixels
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   0, // glCopyTexImage1D
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   'E',
   'X',
   'T',
   0, // glCopyTexImage1DEXT
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   0, // glCopyTexImage2D
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   'E',
   'X',
   'T',
   0, // glCopyTexImage2DEXT
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   0, // glCopyTexSubImage1D
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   'E',
   'X',
   'T',
   0, // glCopyTexSubImage1DEXT
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   0, // glCopyTexSubImage2D
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   'E',
   'X',
   'T',
   0, // glCopyTexSubImage2DEXT
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   0, // glCopyTexSubImage3D
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   'E',
   'X',
   'T',
   0, // glCopyTexSubImage3DEXT
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   'O',
   'E',
   'S',
   0, // glCopyTexSubImage3DOES
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   'E',
   'X',
   'T',
   0, // glCopyTextureImage1DEXT
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   'E',
   'X',
   'T',
   0, // glCopyTextureImage2DEXT
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'L',
   'e',
   'v',
   'e',
   'l',
   's',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glCopyTextureLevelsAPPLE
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   0, // glCopyTextureSubImage1D
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   'E',
   'X',
   'T',
   0, // glCopyTextureSubImage1DEXT
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   0, // glCopyTextureSubImage2D
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   'E',
   'X',
   'T',
   0, // glCopyTextureSubImage2DEXT
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   0, // glCopyTextureSubImage3D
   'g',
   'l',
   'C',
   'o',
   'p',
   'y',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   'E',
   'X',
   'T',
   0, // glCopyTextureSubImage3DEXT
   'g',
   'l',
   'C',
   'o',
   'v',
   'e',
   'r',
   'F',
   'i',
   'l',
   'l',
   'P',
   'a',
   't',
   'h',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   'N',
   'V',
   0, // glCoverFillPathInstancedNV
   'g',
   'l',
   'C',
   'o',
   'v',
   'e',
   'r',
   'F',
   'i',
   'l',
   'l',
   'P',
   'a',
   't',
   'h',
   'N',
   'V',
   0, // glCoverFillPathNV
   'g',
   'l',
   'C',
   'o',
   'v',
   'e',
   'r',
   'S',
   't',
   'r',
   'o',
   'k',
   'e',
   'P',
   'a',
   't',
   'h',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   'N',
   'V',
   0, // glCoverStrokePathInstancedNV
   'g',
   'l',
   'C',
   'o',
   'v',
   'e',
   'r',
   'S',
   't',
   'r',
   'o',
   'k',
   'e',
   'P',
   'a',
   't',
   'h',
   'N',
   'V',
   0, // glCoverStrokePathNV
   'g',
   'l',
   'C',
   'o',
   'v',
   'e',
   'r',
   'a',
   'g',
   'e',
   'M',
   'a',
   's',
   'k',
   'N',
   'V',
   0, // glCoverageMaskNV
   'g',
   'l',
   'C',
   'o',
   'v',
   'e',
   'r',
   'a',
   'g',
   'e',
   'M',
   'o',
   'd',
   'u',
   'l',
   'a',
   't',
   'i',
   'o',
   'n',
   'N',
   'V',
   0, // glCoverageModulationNV
   'g',
   'l',
   'C',
   'o',
   'v',
   'e',
   'r',
   'a',
   'g',
   'e',
   'M',
   'o',
   'd',
   'u',
   'l',
   'a',
   't',
   'i',
   'o',
   'n',
   'T',
   'a',
   'b',
   'l',
   'e',
   'N',
   'V',
   0, // glCoverageModulationTableNV
   'g',
   'l',
   'C',
   'o',
   'v',
   'e',
   'r',
   'a',
   'g',
   'e',
   'O',
   'p',
   'e',
   'r',
   'a',
   't',
   'i',
   'o',
   'n',
   'N',
   'V',
   0, // glCoverageOperationNV
   'g',
   'l',
   'C',
   'r',
   'e',
   'a',
   't',
   'e',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   0, // glCreateBuffers
   'g',
   'l',
   'C',
   'r',
   'e',
   'a',
   't',
   'e',
   'C',
   'o',
   'm',
   'm',
   'a',
   'n',
   'd',
   'L',
   'i',
   's',
   't',
   's',
   'N',
   'V',
   0, // glCreateCommandListsNV
   'g',
   'l',
   'C',
   'r',
   'e',
   'a',
   't',
   'e',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   0, // glCreateFramebuffers
   'g',
   'l',
   'C',
   'r',
   'e',
   'a',
   't',
   'e',
   'M',
   'e',
   'm',
   'o',
   'r',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   's',
   'E',
   'X',
   'T',
   0, // glCreateMemoryObjectsEXT
   'g',
   'l',
   'C',
   'r',
   'e',
   'a',
   't',
   'e',
   'P',
   'e',
   'r',
   'f',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'I',
   'N',
   'T',
   'E',
   'L',
   0, // glCreatePerfQueryINTEL
   'g',
   'l',
   'C',
   'r',
   'e',
   'a',
   't',
   'e',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   0, // glCreateProgram
   'g',
   'l',
   'C',
   'r',
   'e',
   'a',
   't',
   'e',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'A',
   'R',
   'B',
   0, // glCreateProgramObjectARB
   'g',
   'l',
   'C',
   'r',
   'e',
   'a',
   't',
   'e',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'i',
   'p',
   'e',
   'l',
   'i',
   'n',
   'e',
   's',
   0, // glCreateProgramPipelines
   'g',
   'l',
   'C',
   'r',
   'e',
   'a',
   't',
   'e',
   'Q',
   'u',
   'e',
   'r',
   'i',
   'e',
   's',
   0, // glCreateQueries
   'g',
   'l',
   'C',
   'r',
   'e',
   'a',
   't',
   'e',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   0, // glCreateRenderbuffers
   'g',
   'l',
   'C',
   'r',
   'e',
   'a',
   't',
   'e',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   's',
   0, // glCreateSamplers
   'g',
   'l',
   'C',
   'r',
   'e',
   'a',
   't',
   'e',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   0, // glCreateShader
   'g',
   'l',
   'C',
   'r',
   'e',
   'a',
   't',
   'e',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'A',
   'R',
   'B',
   0, // glCreateShaderObjectARB
   'g',
   'l',
   'C',
   'r',
   'e',
   'a',
   't',
   'e',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'E',
   'X',
   'T',
   0, // glCreateShaderProgramEXT
   'g',
   'l',
   'C',
   'r',
   'e',
   'a',
   't',
   'e',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'v',
   0, // glCreateShaderProgramv
   'g',
   'l',
   'C',
   'r',
   'e',
   'a',
   't',
   'e',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'v',
   'E',
   'X',
   'T',
   0, // glCreateShaderProgramvEXT
   'g',
   'l',
   'C',
   'r',
   'e',
   'a',
   't',
   'e',
   'S',
   't',
   'a',
   't',
   'e',
   's',
   'N',
   'V',
   0, // glCreateStatesNV
   'g',
   'l',
   'C',
   'r',
   'e',
   'a',
   't',
   'e',
   'S',
   'y',
   'n',
   'c',
   'F',
   'r',
   'o',
   'm',
   'C',
   'L',
   'e',
   'v',
   'e',
   'n',
   't',
   'A',
   'R',
   'B',
   0, // glCreateSyncFromCLeventARB
   'g',
   'l',
   'C',
   'r',
   'e',
   'a',
   't',
   'e',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   's',
   0, // glCreateTextures
   'g',
   'l',
   'C',
   'r',
   'e',
   'a',
   't',
   'e',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   's',
   0, // glCreateTransformFeedbacks
   'g',
   'l',
   'C',
   'r',
   'e',
   'a',
   't',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   0, // glCreateVertexArrays
   'g',
   'l',
   'C',
   'u',
   'l',
   'l',
   'F',
   'a',
   'c',
   'e',
   0, // glCullFace
   'g',
   'l',
   'C',
   'u',
   'l',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glCullParameterdvEXT
   'g',
   'l',
   'C',
   'u',
   'l',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glCullParameterfvEXT
   'g',
   'l',
   'C',
   'u',
   'r',
   'r',
   'e',
   'n',
   't',
   'P',
   'a',
   'l',
   'e',
   't',
   't',
   'e',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'A',
   'R',
   'B',
   0, // glCurrentPaletteMatrixARB
   'g',
   'l',
   'C',
   'u',
   'r',
   'r',
   'e',
   'n',
   't',
   'P',
   'a',
   'l',
   'e',
   't',
   't',
   'e',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'O',
   'E',
   'S',
   0, // glCurrentPaletteMatrixOES
   'g',
   'l',
   'D',
   'e',
   'b',
   'u',
   'g',
   'M',
   'e',
   's',
   's',
   'a',
   'g',
   'e',
   'C',
   'a',
   'l',
   'l',
   'b',
   'a',
   'c',
   'k',
   0, // glDebugMessageCallback
   'g',
   'l',
   'D',
   'e',
   'b',
   'u',
   'g',
   'M',
   'e',
   's',
   's',
   'a',
   'g',
   'e',
   'C',
   'a',
   'l',
   'l',
   'b',
   'a',
   'c',
   'k',
   'A',
   'M',
   'D',
   0, // glDebugMessageCallbackAMD
   'g',
   'l',
   'D',
   'e',
   'b',
   'u',
   'g',
   'M',
   'e',
   's',
   's',
   'a',
   'g',
   'e',
   'C',
   'a',
   'l',
   'l',
   'b',
   'a',
   'c',
   'k',
   'A',
   'R',
   'B',
   0, // glDebugMessageCallbackARB
   'g',
   'l',
   'D',
   'e',
   'b',
   'u',
   'g',
   'M',
   'e',
   's',
   's',
   'a',
   'g',
   'e',
   'C',
   'a',
   'l',
   'l',
   'b',
   'a',
   'c',
   'k',
   'K',
   'H',
   'R',
   0, // glDebugMessageCallbackKHR
   'g',
   'l',
   'D',
   'e',
   'b',
   'u',
   'g',
   'M',
   'e',
   's',
   's',
   'a',
   'g',
   'e',
   'C',
   'o',
   'n',
   't',
   'r',
   'o',
   'l',
   0, // glDebugMessageControl
   'g',
   'l',
   'D',
   'e',
   'b',
   'u',
   'g',
   'M',
   'e',
   's',
   's',
   'a',
   'g',
   'e',
   'C',
   'o',
   'n',
   't',
   'r',
   'o',
   'l',
   'A',
   'R',
   'B',
   0, // glDebugMessageControlARB
   'g',
   'l',
   'D',
   'e',
   'b',
   'u',
   'g',
   'M',
   'e',
   's',
   's',
   'a',
   'g',
   'e',
   'C',
   'o',
   'n',
   't',
   'r',
   'o',
   'l',
   'K',
   'H',
   'R',
   0, // glDebugMessageControlKHR
   'g',
   'l',
   'D',
   'e',
   'b',
   'u',
   'g',
   'M',
   'e',
   's',
   's',
   'a',
   'g',
   'e',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'A',
   'M',
   'D',
   0, // glDebugMessageEnableAMD
   'g',
   'l',
   'D',
   'e',
   'b',
   'u',
   'g',
   'M',
   'e',
   's',
   's',
   'a',
   'g',
   'e',
   'I',
   'n',
   's',
   'e',
   'r',
   't',
   0, // glDebugMessageInsert
   'g',
   'l',
   'D',
   'e',
   'b',
   'u',
   'g',
   'M',
   'e',
   's',
   's',
   'a',
   'g',
   'e',
   'I',
   'n',
   's',
   'e',
   'r',
   't',
   'A',
   'M',
   'D',
   0, // glDebugMessageInsertAMD
   'g',
   'l',
   'D',
   'e',
   'b',
   'u',
   'g',
   'M',
   'e',
   's',
   's',
   'a',
   'g',
   'e',
   'I',
   'n',
   's',
   'e',
   'r',
   't',
   'A',
   'R',
   'B',
   0, // glDebugMessageInsertARB
   'g',
   'l',
   'D',
   'e',
   'b',
   'u',
   'g',
   'M',
   'e',
   's',
   's',
   'a',
   'g',
   'e',
   'I',
   'n',
   's',
   'e',
   'r',
   't',
   'K',
   'H',
   'R',
   0, // glDebugMessageInsertKHR
   'g',
   'l',
   'D',
   'e',
   'f',
   'o',
   'r',
   'm',
   'S',
   'G',
   'I',
   'X',
   0, // glDeformSGIX
   'g',
   'l',
   'D',
   'e',
   'f',
   'o',
   'r',
   'm',
   'a',
   't',
   'i',
   'o',
   'n',
   'M',
   'a',
   'p',
   '3',
   'd',
   'S',
   'G',
   'I',
   'X',
   0, // glDeformationMap3dSGIX
   'g',
   'l',
   'D',
   'e',
   'f',
   'o',
   'r',
   'm',
   'a',
   't',
   'i',
   'o',
   'n',
   'M',
   'a',
   'p',
   '3',
   'f',
   'S',
   'G',
   'I',
   'X',
   0, // glDeformationMap3fSGIX
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'A',
   's',
   'y',
   'n',
   'c',
   'M',
   'a',
   'r',
   'k',
   'e',
   'r',
   's',
   'S',
   'G',
   'I',
   'X',
   0, // glDeleteAsyncMarkersSGIX
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   0, // glDeleteBuffers
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   'A',
   'R',
   'B',
   0, // glDeleteBuffersARB
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'C',
   'o',
   'm',
   'm',
   'a',
   'n',
   'd',
   'L',
   'i',
   's',
   't',
   's',
   'N',
   'V',
   0, // glDeleteCommandListsNV
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'F',
   'e',
   'n',
   'c',
   'e',
   's',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glDeleteFencesAPPLE
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'F',
   'e',
   'n',
   'c',
   'e',
   's',
   'N',
   'V',
   0, // glDeleteFencesNV
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'A',
   'T',
   'I',
   0, // glDeleteFragmentShaderATI
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   0, // glDeleteFramebuffers
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   'E',
   'X',
   'T',
   0, // glDeleteFramebuffersEXT
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   'O',
   'E',
   'S',
   0, // glDeleteFramebuffersOES
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'L',
   'i',
   's',
   't',
   's',
   0, // glDeleteLists
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'M',
   'e',
   'm',
   'o',
   'r',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   's',
   'E',
   'X',
   'T',
   0, // glDeleteMemoryObjectsEXT
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'N',
   'a',
   'm',
   'e',
   'd',
   'S',
   't',
   'r',
   'i',
   'n',
   'g',
   'A',
   'R',
   'B',
   0, // glDeleteNamedStringARB
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'N',
   'a',
   'm',
   'e',
   's',
   'A',
   'M',
   'D',
   0, // glDeleteNamesAMD
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'A',
   'R',
   'B',
   0, // glDeleteObjectARB
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'O',
   'c',
   'c',
   'l',
   'u',
   's',
   'i',
   'o',
   'n',
   'Q',
   'u',
   'e',
   'r',
   'i',
   'e',
   's',
   'N',
   'V',
   0, // glDeleteOcclusionQueriesNV
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'P',
   'a',
   't',
   'h',
   's',
   'N',
   'V',
   0, // glDeletePathsNV
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'P',
   'e',
   'r',
   'f',
   'M',
   'o',
   'n',
   'i',
   't',
   'o',
   'r',
   's',
   'A',
   'M',
   'D',
   0, // glDeletePerfMonitorsAMD
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'P',
   'e',
   'r',
   'f',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'I',
   'N',
   'T',
   'E',
   'L',
   0, // glDeletePerfQueryINTEL
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   0, // glDeleteProgram
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'i',
   'p',
   'e',
   'l',
   'i',
   'n',
   'e',
   's',
   0, // glDeleteProgramPipelines
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'i',
   'p',
   'e',
   'l',
   'i',
   'n',
   'e',
   's',
   'E',
   'X',
   'T',
   0, // glDeleteProgramPipelinesEXT
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   's',
   'A',
   'R',
   'B',
   0, // glDeleteProgramsARB
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   's',
   'N',
   'V',
   0, // glDeleteProgramsNV
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'Q',
   'u',
   'e',
   'r',
   'i',
   'e',
   's',
   0, // glDeleteQueries
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'Q',
   'u',
   'e',
   'r',
   'i',
   'e',
   's',
   'A',
   'R',
   'B',
   0, // glDeleteQueriesARB
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'Q',
   'u',
   'e',
   'r',
   'i',
   'e',
   's',
   'E',
   'X',
   'T',
   0, // glDeleteQueriesEXT
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'R',
   'e',
   's',
   'o',
   'u',
   'r',
   'c',
   'e',
   'T',
   'a',
   'g',
   'N',
   'V',
   0, // glDeleteQueryResourceTagNV
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   0, // glDeleteRenderbuffers
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   'E',
   'X',
   'T',
   0, // glDeleteRenderbuffersEXT
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   'O',
   'E',
   'S',
   0, // glDeleteRenderbuffersOES
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   's',
   0, // glDeleteSamplers
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'S',
   'e',
   'm',
   'a',
   'p',
   'h',
   'o',
   'r',
   'e',
   's',
   'E',
   'X',
   'T',
   0, // glDeleteSemaphoresEXT
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   0, // glDeleteShader
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'S',
   't',
   'a',
   't',
   'e',
   's',
   'N',
   'V',
   0, // glDeleteStatesNV
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'S',
   'y',
   'n',
   'c',
   0, // glDeleteSync
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'S',
   'y',
   'n',
   'c',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glDeleteSyncAPPLE
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   's',
   0, // glDeleteTextures
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   's',
   'E',
   'X',
   'T',
   0, // glDeleteTexturesEXT
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   's',
   0, // glDeleteTransformFeedbacks
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   's',
   'N',
   'V',
   0, // glDeleteTransformFeedbacksNV
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   0, // glDeleteVertexArrays
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glDeleteVertexArraysAPPLE
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'O',
   'E',
   'S',
   0, // glDeleteVertexArraysOES
   'g',
   'l',
   'D',
   'e',
   'l',
   'e',
   't',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glDeleteVertexShaderEXT
   'g',
   'l',
   'D',
   'e',
   'p',
   't',
   'h',
   'B',
   'o',
   'u',
   'n',
   'd',
   's',
   'E',
   'X',
   'T',
   0, // glDepthBoundsEXT
   'g',
   'l',
   'D',
   'e',
   'p',
   't',
   'h',
   'B',
   'o',
   'u',
   'n',
   'd',
   's',
   'd',
   'N',
   'V',
   0, // glDepthBoundsdNV
   'g',
   'l',
   'D',
   'e',
   'p',
   't',
   'h',
   'F',
   'u',
   'n',
   'c',
   0, // glDepthFunc
   'g',
   'l',
   'D',
   'e',
   'p',
   't',
   'h',
   'M',
   'a',
   's',
   'k',
   0, // glDepthMask
   'g',
   'l',
   'D',
   'e',
   'p',
   't',
   'h',
   'R',
   'a',
   'n',
   'g',
   'e',
   0, // glDepthRange
   'g',
   'l',
   'D',
   'e',
   'p',
   't',
   'h',
   'R',
   'a',
   'n',
   'g',
   'e',
   'A',
   'r',
   'r',
   'a',
   'y',
   'f',
   'v',
   'N',
   'V',
   0, // glDepthRangeArrayfvNV
   'g',
   'l',
   'D',
   'e',
   'p',
   't',
   'h',
   'R',
   'a',
   'n',
   'g',
   'e',
   'A',
   'r',
   'r',
   'a',
   'y',
   'f',
   'v',
   'O',
   'E',
   'S',
   0, // glDepthRangeArrayfvOES
   'g',
   'l',
   'D',
   'e',
   'p',
   't',
   'h',
   'R',
   'a',
   'n',
   'g',
   'e',
   'A',
   'r',
   'r',
   'a',
   'y',
   'v',
   0, // glDepthRangeArrayv
   'g',
   'l',
   'D',
   'e',
   'p',
   't',
   'h',
   'R',
   'a',
   'n',
   'g',
   'e',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   0, // glDepthRangeIndexed
   'g',
   'l',
   'D',
   'e',
   'p',
   't',
   'h',
   'R',
   'a',
   'n',
   'g',
   'e',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'f',
   'N',
   'V',
   0, // glDepthRangeIndexedfNV
   'g',
   'l',
   'D',
   'e',
   'p',
   't',
   'h',
   'R',
   'a',
   'n',
   'g',
   'e',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'f',
   'O',
   'E',
   'S',
   0, // glDepthRangeIndexedfOES
   'g',
   'l',
   'D',
   'e',
   'p',
   't',
   'h',
   'R',
   'a',
   'n',
   'g',
   'e',
   'd',
   'N',
   'V',
   0, // glDepthRangedNV
   'g',
   'l',
   'D',
   'e',
   'p',
   't',
   'h',
   'R',
   'a',
   'n',
   'g',
   'e',
   'f',
   0, // glDepthRangef
   'g',
   'l',
   'D',
   'e',
   'p',
   't',
   'h',
   'R',
   'a',
   'n',
   'g',
   'e',
   'f',
   'O',
   'E',
   'S',
   0, // glDepthRangefOES
   'g',
   'l',
   'D',
   'e',
   'p',
   't',
   'h',
   'R',
   'a',
   'n',
   'g',
   'e',
   'x',
   0, // glDepthRangex
   'g',
   'l',
   'D',
   'e',
   'p',
   't',
   'h',
   'R',
   'a',
   'n',
   'g',
   'e',
   'x',
   'O',
   'E',
   'S',
   0, // glDepthRangexOES
   'g',
   'l',
   'D',
   'e',
   't',
   'a',
   'c',
   'h',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'A',
   'R',
   'B',
   0, // glDetachObjectARB
   'g',
   'l',
   'D',
   'e',
   't',
   'a',
   'c',
   'h',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   0, // glDetachShader
   'g',
   'l',
   'D',
   'e',
   't',
   'a',
   'i',
   'l',
   'T',
   'e',
   'x',
   'F',
   'u',
   'n',
   'c',
   'S',
   'G',
   'I',
   'S',
   0, // glDetailTexFuncSGIS
   'g',
   'l',
   'D',
   'i',
   's',
   'a',
   'b',
   'l',
   'e',
   0, // glDisable
   'g',
   'l',
   'D',
   'i',
   's',
   'a',
   'b',
   'l',
   'e',
   'C',
   'l',
   'i',
   'e',
   'n',
   't',
   'S',
   't',
   'a',
   't',
   'e',
   0, // glDisableClientState
   'g',
   'l',
   'D',
   'i',
   's',
   'a',
   'b',
   'l',
   'e',
   'C',
   'l',
   'i',
   'e',
   'n',
   't',
   'S',
   't',
   'a',
   't',
   'e',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'E',
   'X',
   'T',
   0, // glDisableClientStateIndexedEXT
   'g',
   'l',
   'D',
   'i',
   's',
   'a',
   'b',
   'l',
   'e',
   'C',
   'l',
   'i',
   'e',
   'n',
   't',
   'S',
   't',
   'a',
   't',
   'e',
   'i',
   'E',
   'X',
   'T',
   0, // glDisableClientStateiEXT
   'g',
   'l',
   'D',
   'i',
   's',
   'a',
   'b',
   'l',
   'e',
   'D',
   'r',
   'i',
   'v',
   'e',
   'r',
   'C',
   'o',
   'n',
   't',
   'r',
   'o',
   'l',
   'Q',
   'C',
   'O',
   'M',
   0, // glDisableDriverControlQCOM
   'g',
   'l',
   'D',
   'i',
   's',
   'a',
   'b',
   'l',
   'e',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'E',
   'X',
   'T',
   0, // glDisableIndexedEXT
   'g',
   'l',
   'D',
   'i',
   's',
   'a',
   'b',
   'l',
   'e',
   'V',
   'a',
   'r',
   'i',
   'a',
   'n',
   't',
   'C',
   'l',
   'i',
   'e',
   'n',
   't',
   'S',
   't',
   'a',
   't',
   'e',
   'E',
   'X',
   'T',
   0, // glDisableVariantClientStateEXT
   'g',
   'l',
   'D',
   'i',
   's',
   'a',
   'b',
   'l',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   0, // glDisableVertexArrayAttrib
   'g',
   'l',
   'D',
   'i',
   's',
   'a',
   'b',
   'l',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'E',
   'X',
   'T',
   0, // glDisableVertexArrayAttribEXT
   'g',
   'l',
   'D',
   'i',
   's',
   'a',
   'b',
   'l',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'E',
   'X',
   'T',
   0, // glDisableVertexArrayEXT
   'g',
   'l',
   'D',
   'i',
   's',
   'a',
   'b',
   'l',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glDisableVertexAttribAPPLE
   'g',
   'l',
   'D',
   'i',
   's',
   'a',
   'b',
   'l',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'A',
   'r',
   'r',
   'a',
   'y',
   0, // glDisableVertexAttribArray
   'g',
   'l',
   'D',
   'i',
   's',
   'a',
   'b',
   'l',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'A',
   'r',
   'r',
   'a',
   'y',
   'A',
   'R',
   'B',
   0, // glDisableVertexAttribArrayARB
   'g',
   'l',
   'D',
   'i',
   's',
   'a',
   'b',
   'l',
   'e',
   'i',
   0, // glDisablei
   'g',
   'l',
   'D',
   'i',
   's',
   'a',
   'b',
   'l',
   'e',
   'i',
   'E',
   'X',
   'T',
   0, // glDisableiEXT
   'g',
   'l',
   'D',
   'i',
   's',
   'a',
   'b',
   'l',
   'e',
   'i',
   'N',
   'V',
   0, // glDisableiNV
   'g',
   'l',
   'D',
   'i',
   's',
   'a',
   'b',
   'l',
   'e',
   'i',
   'O',
   'E',
   'S',
   0, // glDisableiOES
   'g',
   'l',
   'D',
   'i',
   's',
   'c',
   'a',
   'r',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glDiscardFramebufferEXT
   'g',
   'l',
   'D',
   'i',
   's',
   'p',
   'a',
   't',
   'c',
   'h',
   'C',
   'o',
   'm',
   'p',
   'u',
   't',
   'e',
   0, // glDispatchCompute
   'g',
   'l',
   'D',
   'i',
   's',
   'p',
   'a',
   't',
   'c',
   'h',
   'C',
   'o',
   'm',
   'p',
   'u',
   't',
   'e',
   'G',
   'r',
   'o',
   'u',
   'p',
   'S',
   'i',
   'z',
   'e',
   'A',
   'R',
   'B',
   0, // glDispatchComputeGroupSizeARB
   'g',
   'l',
   'D',
   'i',
   's',
   'p',
   'a',
   't',
   'c',
   'h',
   'C',
   'o',
   'm',
   'p',
   'u',
   't',
   'e',
   'I',
   'n',
   'd',
   'i',
   'r',
   'e',
   'c',
   't',
   0, // glDispatchComputeIndirect
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   0, // glDrawArrays
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'E',
   'X',
   'T',
   0, // glDrawArraysEXT
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'I',
   'n',
   'd',
   'i',
   'r',
   'e',
   'c',
   't',
   0, // glDrawArraysIndirect
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   0, // glDrawArraysInstanced
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   'A',
   'N',
   'G',
   'L',
   'E',
   0, // glDrawArraysInstancedANGLE
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   'A',
   'R',
   'B',
   0, // glDrawArraysInstancedARB
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   'B',
   'a',
   's',
   'e',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   0, // glDrawArraysInstancedBaseInstance
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   'B',
   'a',
   's',
   'e',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'E',
   'X',
   'T',
   0, // glDrawArraysInstancedBaseInstanceEXT
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   'E',
   'X',
   'T',
   0, // glDrawArraysInstancedEXT
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   'N',
   'V',
   0, // glDrawArraysInstancedNV
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glDrawBuffer
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   0, // glDrawBuffers
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   'A',
   'R',
   'B',
   0, // glDrawBuffersARB
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   'A',
   'T',
   'I',
   0, // glDrawBuffersATI
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   'E',
   'X',
   'T',
   0, // glDrawBuffersEXT
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'E',
   'X',
   'T',
   0, // glDrawBuffersIndexedEXT
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   'N',
   'V',
   0, // glDrawBuffersNV
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'C',
   'o',
   'm',
   'm',
   'a',
   'n',
   'd',
   's',
   'A',
   'd',
   'd',
   'r',
   'e',
   's',
   's',
   'N',
   'V',
   0, // glDrawCommandsAddressNV
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'C',
   'o',
   'm',
   'm',
   'a',
   'n',
   'd',
   's',
   'N',
   'V',
   0, // glDrawCommandsNV
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'C',
   'o',
   'm',
   'm',
   'a',
   'n',
   'd',
   's',
   'S',
   't',
   'a',
   't',
   'e',
   's',
   'A',
   'd',
   'd',
   'r',
   'e',
   's',
   's',
   'N',
   'V',
   0, // glDrawCommandsStatesAddressNV
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'C',
   'o',
   'm',
   'm',
   'a',
   'n',
   'd',
   's',
   'S',
   't',
   'a',
   't',
   'e',
   's',
   'N',
   'V',
   0, // glDrawCommandsStatesNV
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   'A',
   'r',
   'r',
   'a',
   'y',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glDrawElementArrayAPPLE
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   'A',
   'r',
   'r',
   'a',
   'y',
   'A',
   'T',
   'I',
   0, // glDrawElementArrayATI
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   0, // glDrawElements
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'B',
   'a',
   's',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   0, // glDrawElementsBaseVertex
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'B',
   'a',
   's',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'E',
   'X',
   'T',
   0, // glDrawElementsBaseVertexEXT
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'B',
   'a',
   's',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'O',
   'E',
   'S',
   0, // glDrawElementsBaseVertexOES
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'I',
   'n',
   'd',
   'i',
   'r',
   'e',
   'c',
   't',
   0, // glDrawElementsIndirect
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   0, // glDrawElementsInstanced
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   'A',
   'N',
   'G',
   'L',
   'E',
   0, // glDrawElementsInstancedANGLE
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   'A',
   'R',
   'B',
   0, // glDrawElementsInstancedARB
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   'B',
   'a',
   's',
   'e',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   0, // glDrawElementsInstancedBaseInstance
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   'B',
   'a',
   's',
   'e',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'E',
   'X',
   'T',
   0, // glDrawElementsInstancedBaseInstanceEXT
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   'B',
   'a',
   's',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   0, // glDrawElementsInstancedBaseVertex
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   'B',
   'a',
   's',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'B',
   'a',
   's',
   'e',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   0, // glDrawElementsInstancedBaseVertexBaseInstance
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   'B',
   'a',
   's',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'B',
   'a',
   's',
   'e',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'E',
   'X',
   'T',
   0, // glDrawElementsInstancedBaseVertexBaseInstanceEXT
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   'B',
   'a',
   's',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'E',
   'X',
   'T',
   0, // glDrawElementsInstancedBaseVertexEXT
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   'B',
   'a',
   's',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'O',
   'E',
   'S',
   0, // glDrawElementsInstancedBaseVertexOES
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   'E',
   'X',
   'T',
   0, // glDrawElementsInstancedEXT
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   'N',
   'V',
   0, // glDrawElementsInstancedNV
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'M',
   'e',
   's',
   'h',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'S',
   'U',
   'N',
   0, // glDrawMeshArraysSUN
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'P',
   'i',
   'x',
   'e',
   'l',
   's',
   0, // glDrawPixels
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'R',
   'a',
   'n',
   'g',
   'e',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   'A',
   'r',
   'r',
   'a',
   'y',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glDrawRangeElementArrayAPPLE
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'R',
   'a',
   'n',
   'g',
   'e',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   'A',
   'r',
   'r',
   'a',
   'y',
   'A',
   'T',
   'I',
   0, // glDrawRangeElementArrayATI
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'R',
   'a',
   'n',
   'g',
   'e',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   0, // glDrawRangeElements
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'R',
   'a',
   'n',
   'g',
   'e',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'B',
   'a',
   's',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   0, // glDrawRangeElementsBaseVertex
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'R',
   'a',
   'n',
   'g',
   'e',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'B',
   'a',
   's',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'E',
   'X',
   'T',
   0, // glDrawRangeElementsBaseVertexEXT
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'R',
   'a',
   'n',
   'g',
   'e',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'B',
   'a',
   's',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'O',
   'E',
   'S',
   0, // glDrawRangeElementsBaseVertexOES
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'R',
   'a',
   'n',
   'g',
   'e',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'E',
   'X',
   'T',
   0, // glDrawRangeElementsEXT
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'T',
   'e',
   'x',
   'f',
   'O',
   'E',
   'S',
   0, // glDrawTexfOES
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'T',
   'e',
   'x',
   'f',
   'v',
   'O',
   'E',
   'S',
   0, // glDrawTexfvOES
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'T',
   'e',
   'x',
   'i',
   'O',
   'E',
   'S',
   0, // glDrawTexiOES
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'T',
   'e',
   'x',
   'i',
   'v',
   'O',
   'E',
   'S',
   0, // glDrawTexivOES
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'T',
   'e',
   'x',
   's',
   'O',
   'E',
   'S',
   0, // glDrawTexsOES
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'T',
   'e',
   'x',
   's',
   'v',
   'O',
   'E',
   'S',
   0, // glDrawTexsvOES
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'N',
   'V',
   0, // glDrawTextureNV
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'T',
   'e',
   'x',
   'x',
   'O',
   'E',
   'S',
   0, // glDrawTexxOES
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'T',
   'e',
   'x',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glDrawTexxvOES
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   0, // glDrawTransformFeedback
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'E',
   'X',
   'T',
   0, // glDrawTransformFeedbackEXT
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   0, // glDrawTransformFeedbackInstanced
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   'E',
   'X',
   'T',
   0, // glDrawTransformFeedbackInstancedEXT
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'N',
   'V',
   0, // glDrawTransformFeedbackNV
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   0, // glDrawTransformFeedbackStream
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   0, // glDrawTransformFeedbackStreamInstanced
   'g',
   'l',
   'D',
   'r',
   'a',
   'w',
   'V',
   'k',
   'I',
   'm',
   'a',
   'g',
   'e',
   'N',
   'V',
   0, // glDrawVkImageNV
   'g',
   'l',
   'E',
   'G',
   'L',
   'I',
   'm',
   'a',
   'g',
   'e',
   'T',
   'a',
   'r',
   'g',
   'e',
   't',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'O',
   'E',
   'S',
   0, // glEGLImageTargetRenderbufferStorageOES
   'g',
   'l',
   'E',
   'G',
   'L',
   'I',
   'm',
   'a',
   'g',
   'e',
   'T',
   'a',
   'r',
   'g',
   'e',
   't',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   '2',
   'D',
   'O',
   'E',
   'S',
   0, // glEGLImageTargetTexture2DOES
   'g',
   'l',
   'E',
   'd',
   'g',
   'e',
   'F',
   'l',
   'a',
   'g',
   0, // glEdgeFlag
   'g',
   'l',
   'E',
   'd',
   'g',
   'e',
   'F',
   'l',
   'a',
   'g',
   'F',
   'o',
   'r',
   'm',
   'a',
   't',
   'N',
   'V',
   0, // glEdgeFlagFormatNV
   'g',
   'l',
   'E',
   'd',
   'g',
   'e',
   'F',
   'l',
   'a',
   'g',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   0, // glEdgeFlagPointer
   'g',
   'l',
   'E',
   'd',
   'g',
   'e',
   'F',
   'l',
   'a',
   'g',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glEdgeFlagPointerEXT
   'g',
   'l',
   'E',
   'd',
   'g',
   'e',
   'F',
   'l',
   'a',
   'g',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'L',
   'i',
   's',
   't',
   'I',
   'B',
   'M',
   0, // glEdgeFlagPointerListIBM
   'g',
   'l',
   'E',
   'd',
   'g',
   'e',
   'F',
   'l',
   'a',
   'g',
   'v',
   0, // glEdgeFlagv
   'g',
   'l',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glElementPointerAPPLE
   'g',
   'l',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'A',
   'T',
   'I',
   0, // glElementPointerATI
   'g',
   'l',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   0, // glEnable
   'g',
   'l',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'C',
   'l',
   'i',
   'e',
   'n',
   't',
   'S',
   't',
   'a',
   't',
   'e',
   0, // glEnableClientState
   'g',
   'l',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'C',
   'l',
   'i',
   'e',
   'n',
   't',
   'S',
   't',
   'a',
   't',
   'e',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'E',
   'X',
   'T',
   0, // glEnableClientStateIndexedEXT
   'g',
   'l',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'C',
   'l',
   'i',
   'e',
   'n',
   't',
   'S',
   't',
   'a',
   't',
   'e',
   'i',
   'E',
   'X',
   'T',
   0, // glEnableClientStateiEXT
   'g',
   'l',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'D',
   'r',
   'i',
   'v',
   'e',
   'r',
   'C',
   'o',
   'n',
   't',
   'r',
   'o',
   'l',
   'Q',
   'C',
   'O',
   'M',
   0, // glEnableDriverControlQCOM
   'g',
   'l',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'E',
   'X',
   'T',
   0, // glEnableIndexedEXT
   'g',
   'l',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'V',
   'a',
   'r',
   'i',
   'a',
   'n',
   't',
   'C',
   'l',
   'i',
   'e',
   'n',
   't',
   'S',
   't',
   'a',
   't',
   'e',
   'E',
   'X',
   'T',
   0, // glEnableVariantClientStateEXT
   'g',
   'l',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   0, // glEnableVertexArrayAttrib
   'g',
   'l',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'E',
   'X',
   'T',
   0, // glEnableVertexArrayAttribEXT
   'g',
   'l',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'E',
   'X',
   'T',
   0, // glEnableVertexArrayEXT
   'g',
   'l',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glEnableVertexAttribAPPLE
   'g',
   'l',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'A',
   'r',
   'r',
   'a',
   'y',
   0, // glEnableVertexAttribArray
   'g',
   'l',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'A',
   'r',
   'r',
   'a',
   'y',
   'A',
   'R',
   'B',
   0, // glEnableVertexAttribArrayARB
   'g',
   'l',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'i',
   0, // glEnablei
   'g',
   'l',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'i',
   'E',
   'X',
   'T',
   0, // glEnableiEXT
   'g',
   'l',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'i',
   'N',
   'V',
   0, // glEnableiNV
   'g',
   'l',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'i',
   'O',
   'E',
   'S',
   0, // glEnableiOES
   'g',
   'l',
   'E',
   'n',
   'd',
   0, // glEnd
   'g',
   'l',
   'E',
   'n',
   'd',
   'C',
   'o',
   'n',
   'd',
   'i',
   't',
   'i',
   'o',
   'n',
   'a',
   'l',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   0, // glEndConditionalRender
   'g',
   'l',
   'E',
   'n',
   'd',
   'C',
   'o',
   'n',
   'd',
   'i',
   't',
   'i',
   'o',
   'n',
   'a',
   'l',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'N',
   'V',
   0, // glEndConditionalRenderNV
   'g',
   'l',
   'E',
   'n',
   'd',
   'C',
   'o',
   'n',
   'd',
   'i',
   't',
   'i',
   'o',
   'n',
   'a',
   'l',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'N',
   'V',
   'X',
   0, // glEndConditionalRenderNVX
   'g',
   'l',
   'E',
   'n',
   'd',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'A',
   'T',
   'I',
   0, // glEndFragmentShaderATI
   'g',
   'l',
   'E',
   'n',
   'd',
   'L',
   'i',
   's',
   't',
   0, // glEndList
   'g',
   'l',
   'E',
   'n',
   'd',
   'O',
   'c',
   'c',
   'l',
   'u',
   's',
   'i',
   'o',
   'n',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'N',
   'V',
   0, // glEndOcclusionQueryNV
   'g',
   'l',
   'E',
   'n',
   'd',
   'P',
   'e',
   'r',
   'f',
   'M',
   'o',
   'n',
   'i',
   't',
   'o',
   'r',
   'A',
   'M',
   'D',
   0, // glEndPerfMonitorAMD
   'g',
   'l',
   'E',
   'n',
   'd',
   'P',
   'e',
   'r',
   'f',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'I',
   'N',
   'T',
   'E',
   'L',
   0, // glEndPerfQueryINTEL
   'g',
   'l',
   'E',
   'n',
   'd',
   'Q',
   'u',
   'e',
   'r',
   'y',
   0, // glEndQuery
   'g',
   'l',
   'E',
   'n',
   'd',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'A',
   'R',
   'B',
   0, // glEndQueryARB
   'g',
   'l',
   'E',
   'n',
   'd',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'E',
   'X',
   'T',
   0, // glEndQueryEXT
   'g',
   'l',
   'E',
   'n',
   'd',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   0, // glEndQueryIndexed
   'g',
   'l',
   'E',
   'n',
   'd',
   'T',
   'i',
   'l',
   'i',
   'n',
   'g',
   'Q',
   'C',
   'O',
   'M',
   0, // glEndTilingQCOM
   'g',
   'l',
   'E',
   'n',
   'd',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   0, // glEndTransformFeedback
   'g',
   'l',
   'E',
   'n',
   'd',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'E',
   'X',
   'T',
   0, // glEndTransformFeedbackEXT
   'g',
   'l',
   'E',
   'n',
   'd',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'N',
   'V',
   0, // glEndTransformFeedbackNV
   'g',
   'l',
   'E',
   'n',
   'd',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glEndVertexShaderEXT
   'g',
   'l',
   'E',
   'n',
   'd',
   'V',
   'i',
   'd',
   'e',
   'o',
   'C',
   'a',
   'p',
   't',
   'u',
   'r',
   'e',
   'N',
   'V',
   0, // glEndVideoCaptureNV
   'g',
   'l',
   'E',
   'v',
   'a',
   'l',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'd',
   0, // glEvalCoord1d
   'g',
   'l',
   'E',
   'v',
   'a',
   'l',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'd',
   'v',
   0, // glEvalCoord1dv
   'g',
   'l',
   'E',
   'v',
   'a',
   'l',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'f',
   0, // glEvalCoord1f
   'g',
   'l',
   'E',
   'v',
   'a',
   'l',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'f',
   'v',
   0, // glEvalCoord1fv
   'g',
   'l',
   'E',
   'v',
   'a',
   'l',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'x',
   'O',
   'E',
   'S',
   0, // glEvalCoord1xOES
   'g',
   'l',
   'E',
   'v',
   'a',
   'l',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glEvalCoord1xvOES
   'g',
   'l',
   'E',
   'v',
   'a',
   'l',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'd',
   0, // glEvalCoord2d
   'g',
   'l',
   'E',
   'v',
   'a',
   'l',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'd',
   'v',
   0, // glEvalCoord2dv
   'g',
   'l',
   'E',
   'v',
   'a',
   'l',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'f',
   0, // glEvalCoord2f
   'g',
   'l',
   'E',
   'v',
   'a',
   'l',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'f',
   'v',
   0, // glEvalCoord2fv
   'g',
   'l',
   'E',
   'v',
   'a',
   'l',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'x',
   'O',
   'E',
   'S',
   0, // glEvalCoord2xOES
   'g',
   'l',
   'E',
   'v',
   'a',
   'l',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glEvalCoord2xvOES
   'g',
   'l',
   'E',
   'v',
   'a',
   'l',
   'M',
   'a',
   'p',
   's',
   'N',
   'V',
   0, // glEvalMapsNV
   'g',
   'l',
   'E',
   'v',
   'a',
   'l',
   'M',
   'e',
   's',
   'h',
   '1',
   0, // glEvalMesh1
   'g',
   'l',
   'E',
   'v',
   'a',
   'l',
   'M',
   'e',
   's',
   'h',
   '2',
   0, // glEvalMesh2
   'g',
   'l',
   'E',
   'v',
   'a',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   '1',
   0, // glEvalPoint1
   'g',
   'l',
   'E',
   'v',
   'a',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   '2',
   0, // glEvalPoint2
   'g',
   'l',
   'E',
   'v',
   'a',
   'l',
   'u',
   'a',
   't',
   'e',
   'D',
   'e',
   'p',
   't',
   'h',
   'V',
   'a',
   'l',
   'u',
   'e',
   's',
   'A',
   'R',
   'B',
   0, // glEvaluateDepthValuesARB
   'g',
   'l',
   'E',
   'x',
   'e',
   'c',
   'u',
   't',
   'e',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'N',
   'V',
   0, // glExecuteProgramNV
   'g',
   'l',
   'E',
   'x',
   't',
   'G',
   'e',
   't',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'v',
   'Q',
   'C',
   'O',
   'M',
   0, // glExtGetBufferPointervQCOM
   'g',
   'l',
   'E',
   'x',
   't',
   'G',
   'e',
   't',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   'Q',
   'C',
   'O',
   'M',
   0, // glExtGetBuffersQCOM
   'g',
   'l',
   'E',
   'x',
   't',
   'G',
   'e',
   't',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   'Q',
   'C',
   'O',
   'M',
   0, // glExtGetFramebuffersQCOM
   'g',
   'l',
   'E',
   'x',
   't',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'B',
   'i',
   'n',
   'a',
   'r',
   'y',
   'S',
   'o',
   'u',
   'r',
   'c',
   'e',
   'Q',
   'C',
   'O',
   'M',
   0, // glExtGetProgramBinarySourceQCOM
   'g',
   'l',
   'E',
   'x',
   't',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   's',
   'Q',
   'C',
   'O',
   'M',
   0, // glExtGetProgramsQCOM
   'g',
   'l',
   'E',
   'x',
   't',
   'G',
   'e',
   't',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   'Q',
   'C',
   'O',
   'M',
   0, // glExtGetRenderbuffersQCOM
   'g',
   'l',
   'E',
   'x',
   't',
   'G',
   'e',
   't',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   's',
   'Q',
   'C',
   'O',
   'M',
   0, // glExtGetShadersQCOM
   'g',
   'l',
   'E',
   'x',
   't',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'L',
   'e',
   'v',
   'e',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'Q',
   'C',
   'O',
   'M',
   0, // glExtGetTexLevelParameterivQCOM
   'g',
   'l',
   'E',
   'x',
   't',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   'Q',
   'C',
   'O',
   'M',
   0, // glExtGetTexSubImageQCOM
   'g',
   'l',
   'E',
   'x',
   't',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   's',
   'Q',
   'C',
   'O',
   'M',
   0, // glExtGetTexturesQCOM
   'g',
   'l',
   'E',
   'x',
   't',
   'I',
   's',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'B',
   'i',
   'n',
   'a',
   'r',
   'y',
   'Q',
   'C',
   'O',
   'M',
   0, // glExtIsProgramBinaryQCOM
   'g',
   'l',
   'E',
   'x',
   't',
   'T',
   'e',
   'x',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'S',
   't',
   'a',
   't',
   'e',
   'O',
   'v',
   'e',
   'r',
   'r',
   'i',
   'd',
   'e',
   'i',
   'Q',
   'C',
   'O',
   'M',
   0, // glExtTexObjectStateOverrideiQCOM
   'g',
   'l',
   'E',
   'x',
   't',
   'r',
   'a',
   'c',
   't',
   'C',
   'o',
   'm',
   'p',
   'o',
   'n',
   'e',
   'n',
   't',
   'E',
   'X',
   'T',
   0, // glExtractComponentEXT
   'g',
   'l',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glFeedbackBuffer
   'g',
   'l',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'x',
   'O',
   'E',
   'S',
   0, // glFeedbackBufferxOES
   'g',
   'l',
   'F',
   'e',
   'n',
   'c',
   'e',
   'S',
   'y',
   'n',
   'c',
   0, // glFenceSync
   'g',
   'l',
   'F',
   'e',
   'n',
   'c',
   'e',
   'S',
   'y',
   'n',
   'c',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glFenceSyncAPPLE
   'g',
   'l',
   'F',
   'i',
   'n',
   'a',
   'l',
   'C',
   'o',
   'm',
   'b',
   'i',
   'n',
   'e',
   'r',
   'I',
   'n',
   'p',
   'u',
   't',
   'N',
   'V',
   0, // glFinalCombinerInputNV
   'g',
   'l',
   'F',
   'i',
   'n',
   'i',
   's',
   'h',
   0, // glFinish
   'g',
   'l',
   'F',
   'i',
   'n',
   'i',
   's',
   'h',
   'A',
   's',
   'y',
   'n',
   'c',
   'S',
   'G',
   'I',
   'X',
   0, // glFinishAsyncSGIX
   'g',
   'l',
   'F',
   'i',
   'n',
   'i',
   's',
   'h',
   'F',
   'e',
   'n',
   'c',
   'e',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glFinishFenceAPPLE
   'g',
   'l',
   'F',
   'i',
   'n',
   'i',
   's',
   'h',
   'F',
   'e',
   'n',
   'c',
   'e',
   'N',
   'V',
   0, // glFinishFenceNV
   'g',
   'l',
   'F',
   'i',
   'n',
   'i',
   's',
   'h',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glFinishObjectAPPLE
   'g',
   'l',
   'F',
   'i',
   'n',
   'i',
   's',
   'h',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   'U',
   'N',
   'X',
   0, // glFinishTextureSUNX
   'g',
   'l',
   'F',
   'l',
   'u',
   's',
   'h',
   0, // glFlush
   'g',
   'l',
   'F',
   'l',
   'u',
   's',
   'h',
   'M',
   'a',
   'p',
   'p',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'a',
   'n',
   'g',
   'e',
   0, // glFlushMappedBufferRange
   'g',
   'l',
   'F',
   'l',
   'u',
   's',
   'h',
   'M',
   'a',
   'p',
   'p',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'a',
   'n',
   'g',
   'e',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glFlushMappedBufferRangeAPPLE
   'g',
   'l',
   'F',
   'l',
   'u',
   's',
   'h',
   'M',
   'a',
   'p',
   'p',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'a',
   'n',
   'g',
   'e',
   'E',
   'X',
   'T',
   0, // glFlushMappedBufferRangeEXT
   'g',
   'l',
   'F',
   'l',
   'u',
   's',
   'h',
   'M',
   'a',
   'p',
   'p',
   'e',
   'd',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'a',
   'n',
   'g',
   'e',
   0, // glFlushMappedNamedBufferRange
   'g',
   'l',
   'F',
   'l',
   'u',
   's',
   'h',
   'M',
   'a',
   'p',
   'p',
   'e',
   'd',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'a',
   'n',
   'g',
   'e',
   'E',
   'X',
   'T',
   0, // glFlushMappedNamedBufferRangeEXT
   'g',
   'l',
   'F',
   'l',
   'u',
   's',
   'h',
   'P',
   'i',
   'x',
   'e',
   'l',
   'D',
   'a',
   't',
   'a',
   'R',
   'a',
   'n',
   'g',
   'e',
   'N',
   'V',
   0, // glFlushPixelDataRangeNV
   'g',
   'l',
   'F',
   'l',
   'u',
   's',
   'h',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'S',
   'G',
   'I',
   'X',
   0, // glFlushRasterSGIX
   'g',
   'l',
   'F',
   'l',
   'u',
   's',
   'h',
   'S',
   't',
   'a',
   't',
   'i',
   'c',
   'D',
   'a',
   't',
   'a',
   'I',
   'B',
   'M',
   0, // glFlushStaticDataIBM
   'g',
   'l',
   'F',
   'l',
   'u',
   's',
   'h',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'R',
   'a',
   'n',
   'g',
   'e',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glFlushVertexArrayRangeAPPLE
   'g',
   'l',
   'F',
   'l',
   'u',
   's',
   'h',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'R',
   'a',
   'n',
   'g',
   'e',
   'N',
   'V',
   0, // glFlushVertexArrayRangeNV
   'g',
   'l',
   'F',
   'o',
   'g',
   'C',
   'o',
   'o',
   'r',
   'd',
   'F',
   'o',
   'r',
   'm',
   'a',
   't',
   'N',
   'V',
   0, // glFogCoordFormatNV
   'g',
   'l',
   'F',
   'o',
   'g',
   'C',
   'o',
   'o',
   'r',
   'd',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   0, // glFogCoordPointer
   'g',
   'l',
   'F',
   'o',
   'g',
   'C',
   'o',
   'o',
   'r',
   'd',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glFogCoordPointerEXT
   'g',
   'l',
   'F',
   'o',
   'g',
   'C',
   'o',
   'o',
   'r',
   'd',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'L',
   'i',
   's',
   't',
   'I',
   'B',
   'M',
   0, // glFogCoordPointerListIBM
   'g',
   'l',
   'F',
   'o',
   'g',
   'C',
   'o',
   'o',
   'r',
   'd',
   'd',
   0, // glFogCoordd
   'g',
   'l',
   'F',
   'o',
   'g',
   'C',
   'o',
   'o',
   'r',
   'd',
   'd',
   'E',
   'X',
   'T',
   0, // glFogCoorddEXT
   'g',
   'l',
   'F',
   'o',
   'g',
   'C',
   'o',
   'o',
   'r',
   'd',
   'd',
   'v',
   0, // glFogCoorddv
   'g',
   'l',
   'F',
   'o',
   'g',
   'C',
   'o',
   'o',
   'r',
   'd',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glFogCoorddvEXT
   'g',
   'l',
   'F',
   'o',
   'g',
   'C',
   'o',
   'o',
   'r',
   'd',
   'f',
   0, // glFogCoordf
   'g',
   'l',
   'F',
   'o',
   'g',
   'C',
   'o',
   'o',
   'r',
   'd',
   'f',
   'E',
   'X',
   'T',
   0, // glFogCoordfEXT
   'g',
   'l',
   'F',
   'o',
   'g',
   'C',
   'o',
   'o',
   'r',
   'd',
   'f',
   'v',
   0, // glFogCoordfv
   'g',
   'l',
   'F',
   'o',
   'g',
   'C',
   'o',
   'o',
   'r',
   'd',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glFogCoordfvEXT
   'g',
   'l',
   'F',
   'o',
   'g',
   'C',
   'o',
   'o',
   'r',
   'd',
   'h',
   'N',
   'V',
   0, // glFogCoordhNV
   'g',
   'l',
   'F',
   'o',
   'g',
   'C',
   'o',
   'o',
   'r',
   'd',
   'h',
   'v',
   'N',
   'V',
   0, // glFogCoordhvNV
   'g',
   'l',
   'F',
   'o',
   'g',
   'F',
   'u',
   'n',
   'c',
   'S',
   'G',
   'I',
   'S',
   0, // glFogFuncSGIS
   'g',
   'l',
   'F',
   'o',
   'g',
   'f',
   0, // glFogf
   'g',
   'l',
   'F',
   'o',
   'g',
   'f',
   'v',
   0, // glFogfv
   'g',
   'l',
   'F',
   'o',
   'g',
   'i',
   0, // glFogi
   'g',
   'l',
   'F',
   'o',
   'g',
   'i',
   'v',
   0, // glFogiv
   'g',
   'l',
   'F',
   'o',
   'g',
   'x',
   0, // glFogx
   'g',
   'l',
   'F',
   'o',
   'g',
   'x',
   'O',
   'E',
   'S',
   0, // glFogxOES
   'g',
   'l',
   'F',
   'o',
   'g',
   'x',
   'v',
   0, // glFogxv
   'g',
   'l',
   'F',
   'o',
   'g',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glFogxvOES
   'g',
   'l',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'l',
   'o',
   'r',
   'M',
   'a',
   't',
   'e',
   'r',
   'i',
   'a',
   'l',
   'S',
   'G',
   'I',
   'X',
   0, // glFragmentColorMaterialSGIX
   'g',
   'l',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'v',
   'e',
   'r',
   'a',
   'g',
   'e',
   'C',
   'o',
   'l',
   'o',
   'r',
   'N',
   'V',
   0, // glFragmentCoverageColorNV
   'g',
   'l',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'L',
   'i',
   'g',
   'h',
   't',
   'M',
   'o',
   'd',
   'e',
   'l',
   'f',
   'S',
   'G',
   'I',
   'X',
   0, // glFragmentLightModelfSGIX
   'g',
   'l',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'L',
   'i',
   'g',
   'h',
   't',
   'M',
   'o',
   'd',
   'e',
   'l',
   'f',
   'v',
   'S',
   'G',
   'I',
   'X',
   0, // glFragmentLightModelfvSGIX
   'g',
   'l',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'L',
   'i',
   'g',
   'h',
   't',
   'M',
   'o',
   'd',
   'e',
   'l',
   'i',
   'S',
   'G',
   'I',
   'X',
   0, // glFragmentLightModeliSGIX
   'g',
   'l',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'L',
   'i',
   'g',
   'h',
   't',
   'M',
   'o',
   'd',
   'e',
   'l',
   'i',
   'v',
   'S',
   'G',
   'I',
   'X',
   0, // glFragmentLightModelivSGIX
   'g',
   'l',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'L',
   'i',
   'g',
   'h',
   't',
   'f',
   'S',
   'G',
   'I',
   'X',
   0, // glFragmentLightfSGIX
   'g',
   'l',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'L',
   'i',
   'g',
   'h',
   't',
   'f',
   'v',
   'S',
   'G',
   'I',
   'X',
   0, // glFragmentLightfvSGIX
   'g',
   'l',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'L',
   'i',
   'g',
   'h',
   't',
   'i',
   'S',
   'G',
   'I',
   'X',
   0, // glFragmentLightiSGIX
   'g',
   'l',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'L',
   'i',
   'g',
   'h',
   't',
   'i',
   'v',
   'S',
   'G',
   'I',
   'X',
   0, // glFragmentLightivSGIX
   'g',
   'l',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'M',
   'a',
   't',
   'e',
   'r',
   'i',
   'a',
   'l',
   'f',
   'S',
   'G',
   'I',
   'X',
   0, // glFragmentMaterialfSGIX
   'g',
   'l',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'M',
   'a',
   't',
   'e',
   'r',
   'i',
   'a',
   'l',
   'f',
   'v',
   'S',
   'G',
   'I',
   'X',
   0, // glFragmentMaterialfvSGIX
   'g',
   'l',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'M',
   'a',
   't',
   'e',
   'r',
   'i',
   'a',
   'l',
   'i',
   'S',
   'G',
   'I',
   'X',
   0, // glFragmentMaterialiSGIX
   'g',
   'l',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'M',
   'a',
   't',
   'e',
   'r',
   'i',
   'a',
   'l',
   'i',
   'v',
   'S',
   'G',
   'I',
   'X',
   0, // glFragmentMaterialivSGIX
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'T',
   'e',
   'r',
   'm',
   'i',
   'n',
   'a',
   't',
   'o',
   'r',
   'G',
   'R',
   'E',
   'M',
   'E',
   'D',
   'Y',
   0, // glFrameTerminatorGREMEDY
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'Z',
   'o',
   'o',
   'm',
   'S',
   'G',
   'I',
   'X',
   0, // glFrameZoomSGIX
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'D',
   'r',
   'a',
   'w',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glFramebufferDrawBufferEXT
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'D',
   'r',
   'a',
   'w',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   'E',
   'X',
   'T',
   0, // glFramebufferDrawBuffersEXT
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'F',
   'e',
   't',
   'c',
   'h',
   'B',
   'a',
   'r',
   'r',
   'i',
   'e',
   'r',
   'Q',
   'C',
   'O',
   'M',
   0, // glFramebufferFetchBarrierQCOM
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'F',
   'o',
   'v',
   'e',
   'a',
   't',
   'i',
   'o',
   'n',
   'C',
   'o',
   'n',
   'f',
   'i',
   'g',
   'Q',
   'C',
   'O',
   'M',
   0, // glFramebufferFoveationConfigQCOM
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'F',
   'o',
   'v',
   'e',
   'a',
   't',
   'i',
   'o',
   'n',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   's',
   'Q',
   'C',
   'O',
   'M',
   0, // glFramebufferFoveationParametersQCOM
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   0, // glFramebufferParameteri
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'i',
   'x',
   'e',
   'l',
   'L',
   'o',
   'c',
   'a',
   'l',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'S',
   'i',
   'z',
   'e',
   'E',
   'X',
   'T',
   0, // glFramebufferPixelLocalStorageSizeEXT
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'e',
   'a',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glFramebufferReadBufferEXT
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glFramebufferRenderbuffer
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glFramebufferRenderbufferEXT
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'O',
   'E',
   'S',
   0, // glFramebufferRenderbufferOES
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'L',
   'o',
   'c',
   'a',
   't',
   'i',
   'o',
   'n',
   's',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glFramebufferSampleLocationsfvARB
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'L',
   'o',
   'c',
   'a',
   't',
   'i',
   'o',
   'n',
   's',
   'f',
   'v',
   'N',
   'V',
   0, // glFramebufferSampleLocationsfvNV
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'P',
   'o',
   's',
   'i',
   't',
   'i',
   'o',
   'n',
   's',
   'f',
   'v',
   'A',
   'M',
   'D',
   0, // glFramebufferSamplePositionsfvAMD
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   0, // glFramebufferTexture
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   '1',
   'D',
   0, // glFramebufferTexture1D
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   '1',
   'D',
   'E',
   'X',
   'T',
   0, // glFramebufferTexture1DEXT
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   '2',
   'D',
   0, // glFramebufferTexture2D
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   '2',
   'D',
   'D',
   'o',
   'w',
   'n',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'I',
   'M',
   'G',
   0, // glFramebufferTexture2DDownsampleIMG
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   '2',
   'D',
   'E',
   'X',
   'T',
   0, // glFramebufferTexture2DEXT
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   '2',
   'D',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'E',
   'X',
   'T',
   0, // glFramebufferTexture2DMultisampleEXT
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   '2',
   'D',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'I',
   'M',
   'G',
   0, // glFramebufferTexture2DMultisampleIMG
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   '2',
   'D',
   'O',
   'E',
   'S',
   0, // glFramebufferTexture2DOES
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   '3',
   'D',
   0, // glFramebufferTexture3D
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   '3',
   'D',
   'E',
   'X',
   'T',
   0, // glFramebufferTexture3DEXT
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   '3',
   'D',
   'O',
   'E',
   'S',
   0, // glFramebufferTexture3DOES
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'A',
   'R',
   'B',
   0, // glFramebufferTextureARB
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'E',
   'X',
   'T',
   0, // glFramebufferTextureEXT
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'F',
   'a',
   'c',
   'e',
   'A',
   'R',
   'B',
   0, // glFramebufferTextureFaceARB
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'F',
   'a',
   'c',
   'e',
   'E',
   'X',
   'T',
   0, // glFramebufferTextureFaceEXT
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'L',
   'a',
   'y',
   'e',
   'r',
   0, // glFramebufferTextureLayer
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'L',
   'a',
   'y',
   'e',
   'r',
   'A',
   'R',
   'B',
   0, // glFramebufferTextureLayerARB
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'L',
   'a',
   'y',
   'e',
   'r',
   'D',
   'o',
   'w',
   'n',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'I',
   'M',
   'G',
   0, // glFramebufferTextureLayerDownsampleIMG
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'L',
   'a',
   'y',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glFramebufferTextureLayerEXT
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'M',
   'u',
   'l',
   't',
   'i',
   'v',
   'i',
   'e',
   'w',
   'O',
   'V',
   'R',
   0, // glFramebufferTextureMultisampleMultiviewOVR
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'M',
   'u',
   'l',
   't',
   'i',
   'v',
   'i',
   'e',
   'w',
   'O',
   'V',
   'R',
   0, // glFramebufferTextureMultiviewOVR
   'g',
   'l',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'O',
   'E',
   'S',
   0, // glFramebufferTextureOES
   'g',
   'l',
   'F',
   'r',
   'e',
   'e',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'A',
   'T',
   'I',
   0, // glFreeObjectBufferATI
   'g',
   'l',
   'F',
   'r',
   'o',
   'n',
   't',
   'F',
   'a',
   'c',
   'e',
   0, // glFrontFace
   'g',
   'l',
   'F',
   'r',
   'u',
   's',
   't',
   'u',
   'm',
   0, // glFrustum
   'g',
   'l',
   'F',
   'r',
   'u',
   's',
   't',
   'u',
   'm',
   'f',
   0, // glFrustumf
   'g',
   'l',
   'F',
   'r',
   'u',
   's',
   't',
   'u',
   'm',
   'f',
   'O',
   'E',
   'S',
   0, // glFrustumfOES
   'g',
   'l',
   'F',
   'r',
   'u',
   's',
   't',
   'u',
   'm',
   'x',
   0, // glFrustumx
   'g',
   'l',
   'F',
   'r',
   'u',
   's',
   't',
   'u',
   'm',
   'x',
   'O',
   'E',
   'S',
   0, // glFrustumxOES
   'g',
   'l',
   'G',
   'e',
   'n',
   'A',
   's',
   'y',
   'n',
   'c',
   'M',
   'a',
   'r',
   'k',
   'e',
   'r',
   's',
   'S',
   'G',
   'I',
   'X',
   0, // glGenAsyncMarkersSGIX
   'g',
   'l',
   'G',
   'e',
   'n',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   0, // glGenBuffers
   'g',
   'l',
   'G',
   'e',
   'n',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   'A',
   'R',
   'B',
   0, // glGenBuffersARB
   'g',
   'l',
   'G',
   'e',
   'n',
   'F',
   'e',
   'n',
   'c',
   'e',
   's',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glGenFencesAPPLE
   'g',
   'l',
   'G',
   'e',
   'n',
   'F',
   'e',
   'n',
   'c',
   'e',
   's',
   'N',
   'V',
   0, // glGenFencesNV
   'g',
   'l',
   'G',
   'e',
   'n',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   's',
   'A',
   'T',
   'I',
   0, // glGenFragmentShadersATI
   'g',
   'l',
   'G',
   'e',
   'n',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   0, // glGenFramebuffers
   'g',
   'l',
   'G',
   'e',
   'n',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   'E',
   'X',
   'T',
   0, // glGenFramebuffersEXT
   'g',
   'l',
   'G',
   'e',
   'n',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   'O',
   'E',
   'S',
   0, // glGenFramebuffersOES
   'g',
   'l',
   'G',
   'e',
   'n',
   'L',
   'i',
   's',
   't',
   's',
   0, // glGenLists
   'g',
   'l',
   'G',
   'e',
   'n',
   'N',
   'a',
   'm',
   'e',
   's',
   'A',
   'M',
   'D',
   0, // glGenNamesAMD
   'g',
   'l',
   'G',
   'e',
   'n',
   'O',
   'c',
   'c',
   'l',
   'u',
   's',
   'i',
   'o',
   'n',
   'Q',
   'u',
   'e',
   'r',
   'i',
   'e',
   's',
   'N',
   'V',
   0, // glGenOcclusionQueriesNV
   'g',
   'l',
   'G',
   'e',
   'n',
   'P',
   'a',
   't',
   'h',
   's',
   'N',
   'V',
   0, // glGenPathsNV
   'g',
   'l',
   'G',
   'e',
   'n',
   'P',
   'e',
   'r',
   'f',
   'M',
   'o',
   'n',
   'i',
   't',
   'o',
   'r',
   's',
   'A',
   'M',
   'D',
   0, // glGenPerfMonitorsAMD
   'g',
   'l',
   'G',
   'e',
   'n',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'i',
   'p',
   'e',
   'l',
   'i',
   'n',
   'e',
   's',
   0, // glGenProgramPipelines
   'g',
   'l',
   'G',
   'e',
   'n',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'i',
   'p',
   'e',
   'l',
   'i',
   'n',
   'e',
   's',
   'E',
   'X',
   'T',
   0, // glGenProgramPipelinesEXT
   'g',
   'l',
   'G',
   'e',
   'n',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   's',
   'A',
   'R',
   'B',
   0, // glGenProgramsARB
   'g',
   'l',
   'G',
   'e',
   'n',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   's',
   'N',
   'V',
   0, // glGenProgramsNV
   'g',
   'l',
   'G',
   'e',
   'n',
   'Q',
   'u',
   'e',
   'r',
   'i',
   'e',
   's',
   0, // glGenQueries
   'g',
   'l',
   'G',
   'e',
   'n',
   'Q',
   'u',
   'e',
   'r',
   'i',
   'e',
   's',
   'A',
   'R',
   'B',
   0, // glGenQueriesARB
   'g',
   'l',
   'G',
   'e',
   'n',
   'Q',
   'u',
   'e',
   'r',
   'i',
   'e',
   's',
   'E',
   'X',
   'T',
   0, // glGenQueriesEXT
   'g',
   'l',
   'G',
   'e',
   'n',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'R',
   'e',
   's',
   'o',
   'u',
   'r',
   'c',
   'e',
   'T',
   'a',
   'g',
   'N',
   'V',
   0, // glGenQueryResourceTagNV
   'g',
   'l',
   'G',
   'e',
   'n',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   0, // glGenRenderbuffers
   'g',
   'l',
   'G',
   'e',
   'n',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   'E',
   'X',
   'T',
   0, // glGenRenderbuffersEXT
   'g',
   'l',
   'G',
   'e',
   'n',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   'O',
   'E',
   'S',
   0, // glGenRenderbuffersOES
   'g',
   'l',
   'G',
   'e',
   'n',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   's',
   0, // glGenSamplers
   'g',
   'l',
   'G',
   'e',
   'n',
   'S',
   'e',
   'm',
   'a',
   'p',
   'h',
   'o',
   'r',
   'e',
   's',
   'E',
   'X',
   'T',
   0, // glGenSemaphoresEXT
   'g',
   'l',
   'G',
   'e',
   'n',
   'S',
   'y',
   'm',
   'b',
   'o',
   'l',
   's',
   'E',
   'X',
   'T',
   0, // glGenSymbolsEXT
   'g',
   'l',
   'G',
   'e',
   'n',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   's',
   0, // glGenTextures
   'g',
   'l',
   'G',
   'e',
   'n',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   's',
   'E',
   'X',
   'T',
   0, // glGenTexturesEXT
   'g',
   'l',
   'G',
   'e',
   'n',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   's',
   0, // glGenTransformFeedbacks
   'g',
   'l',
   'G',
   'e',
   'n',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   's',
   'N',
   'V',
   0, // glGenTransformFeedbacksNV
   'g',
   'l',
   'G',
   'e',
   'n',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   0, // glGenVertexArrays
   'g',
   'l',
   'G',
   'e',
   'n',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glGenVertexArraysAPPLE
   'g',
   'l',
   'G',
   'e',
   'n',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'O',
   'E',
   'S',
   0, // glGenVertexArraysOES
   'g',
   'l',
   'G',
   'e',
   'n',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   's',
   'E',
   'X',
   'T',
   0, // glGenVertexShadersEXT
   'g',
   'l',
   'G',
   'e',
   'n',
   'e',
   'r',
   'a',
   't',
   'e',
   'M',
   'i',
   'p',
   'm',
   'a',
   'p',
   0, // glGenerateMipmap
   'g',
   'l',
   'G',
   'e',
   'n',
   'e',
   'r',
   'a',
   't',
   'e',
   'M',
   'i',
   'p',
   'm',
   'a',
   'p',
   'E',
   'X',
   'T',
   0, // glGenerateMipmapEXT
   'g',
   'l',
   'G',
   'e',
   'n',
   'e',
   'r',
   'a',
   't',
   'e',
   'M',
   'i',
   'p',
   'm',
   'a',
   'p',
   'O',
   'E',
   'S',
   0, // glGenerateMipmapOES
   'g',
   'l',
   'G',
   'e',
   'n',
   'e',
   'r',
   'a',
   't',
   'e',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'M',
   'i',
   'p',
   'm',
   'a',
   'p',
   'E',
   'X',
   'T',
   0, // glGenerateMultiTexMipmapEXT
   'g',
   'l',
   'G',
   'e',
   'n',
   'e',
   'r',
   'a',
   't',
   'e',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'M',
   'i',
   'p',
   'm',
   'a',
   'p',
   0, // glGenerateTextureMipmap
   'g',
   'l',
   'G',
   'e',
   'n',
   'e',
   'r',
   'a',
   't',
   'e',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'M',
   'i',
   'p',
   'm',
   'a',
   'p',
   'E',
   'X',
   'T',
   0, // glGenerateTextureMipmapEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'A',
   'c',
   't',
   'i',
   'v',
   'e',
   'A',
   't',
   'o',
   'm',
   'i',
   'c',
   'C',
   'o',
   'u',
   'n',
   't',
   'e',
   'r',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'i',
   'v',
   0, // glGetActiveAtomicCounterBufferiv
   'g',
   'l',
   'G',
   'e',
   't',
   'A',
   'c',
   't',
   'i',
   'v',
   'e',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   0, // glGetActiveAttrib
   'g',
   'l',
   'G',
   'e',
   't',
   'A',
   'c',
   't',
   'i',
   'v',
   'e',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'A',
   'R',
   'B',
   0, // glGetActiveAttribARB
   'g',
   'l',
   'G',
   'e',
   't',
   'A',
   'c',
   't',
   'i',
   'v',
   'e',
   'S',
   'u',
   'b',
   'r',
   'o',
   'u',
   't',
   'i',
   'n',
   'e',
   'N',
   'a',
   'm',
   'e',
   0, // glGetActiveSubroutineName
   'g',
   'l',
   'G',
   'e',
   't',
   'A',
   'c',
   't',
   'i',
   'v',
   'e',
   'S',
   'u',
   'b',
   'r',
   'o',
   'u',
   't',
   'i',
   'n',
   'e',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'N',
   'a',
   'm',
   'e',
   0, // glGetActiveSubroutineUniformName
   'g',
   'l',
   'G',
   'e',
   't',
   'A',
   'c',
   't',
   'i',
   'v',
   'e',
   'S',
   'u',
   'b',
   'r',
   'o',
   'u',
   't',
   'i',
   'n',
   'e',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'i',
   'v',
   0, // glGetActiveSubroutineUniformiv
   'g',
   'l',
   'G',
   'e',
   't',
   'A',
   'c',
   't',
   'i',
   'v',
   'e',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   0, // glGetActiveUniform
   'g',
   'l',
   'G',
   'e',
   't',
   'A',
   'c',
   't',
   'i',
   'v',
   'e',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'A',
   'R',
   'B',
   0, // glGetActiveUniformARB
   'g',
   'l',
   'G',
   'e',
   't',
   'A',
   'c',
   't',
   'i',
   'v',
   'e',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'B',
   'l',
   'o',
   'c',
   'k',
   'N',
   'a',
   'm',
   'e',
   0, // glGetActiveUniformBlockName
   'g',
   'l',
   'G',
   'e',
   't',
   'A',
   'c',
   't',
   'i',
   'v',
   'e',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'B',
   'l',
   'o',
   'c',
   'k',
   'i',
   'v',
   0, // glGetActiveUniformBlockiv
   'g',
   'l',
   'G',
   'e',
   't',
   'A',
   'c',
   't',
   'i',
   'v',
   'e',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'N',
   'a',
   'm',
   'e',
   0, // glGetActiveUniformName
   'g',
   'l',
   'G',
   'e',
   't',
   'A',
   'c',
   't',
   'i',
   'v',
   'e',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   's',
   'i',
   'v',
   0, // glGetActiveUniformsiv
   'g',
   'l',
   'G',
   'e',
   't',
   'A',
   'c',
   't',
   'i',
   'v',
   'e',
   'V',
   'a',
   'r',
   'y',
   'i',
   'n',
   'g',
   'N',
   'V',
   0, // glGetActiveVaryingNV
   'g',
   'l',
   'G',
   'e',
   't',
   'A',
   'r',
   'r',
   'a',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'f',
   'v',
   'A',
   'T',
   'I',
   0, // glGetArrayObjectfvATI
   'g',
   'l',
   'G',
   'e',
   't',
   'A',
   'r',
   'r',
   'a',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'i',
   'v',
   'A',
   'T',
   'I',
   0, // glGetArrayObjectivATI
   'g',
   'l',
   'G',
   'e',
   't',
   'A',
   't',
   't',
   'a',
   'c',
   'h',
   'e',
   'd',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   's',
   'A',
   'R',
   'B',
   0, // glGetAttachedObjectsARB
   'g',
   'l',
   'G',
   'e',
   't',
   'A',
   't',
   't',
   'a',
   'c',
   'h',
   'e',
   'd',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   's',
   0, // glGetAttachedShaders
   'g',
   'l',
   'G',
   'e',
   't',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   'o',
   'c',
   'a',
   't',
   'i',
   'o',
   'n',
   0, // glGetAttribLocation
   'g',
   'l',
   'G',
   'e',
   't',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   'o',
   'c',
   'a',
   't',
   'i',
   'o',
   'n',
   'A',
   'R',
   'B',
   0, // glGetAttribLocationARB
   'g',
   'l',
   'G',
   'e',
   't',
   'B',
   'o',
   'o',
   'l',
   'e',
   'a',
   'n',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glGetBooleanIndexedvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'B',
   'o',
   'o',
   'l',
   'e',
   'a',
   'n',
   'i',
   '_',
   'v',
   0, // glGetBooleani_v
   'g',
   'l',
   'G',
   'e',
   't',
   'B',
   'o',
   'o',
   'l',
   'e',
   'a',
   'n',
   'v',
   0, // glGetBooleanv
   'g',
   'l',
   'G',
   'e',
   't',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   '6',
   '4',
   'v',
   0, // glGetBufferParameteri64v
   'g',
   'l',
   'G',
   'e',
   't',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   0, // glGetBufferParameteriv
   'g',
   'l',
   'G',
   'e',
   't',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glGetBufferParameterivARB
   'g',
   'l',
   'G',
   'e',
   't',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'u',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glGetBufferParameterui64vNV
   'g',
   'l',
   'G',
   'e',
   't',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'v',
   0, // glGetBufferPointerv
   'g',
   'l',
   'G',
   'e',
   't',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'v',
   'A',
   'R',
   'B',
   0, // glGetBufferPointervARB
   'g',
   'l',
   'G',
   'e',
   't',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'v',
   'O',
   'E',
   'S',
   0, // glGetBufferPointervOES
   'g',
   'l',
   'G',
   'e',
   't',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   0, // glGetBufferSubData
   'g',
   'l',
   'G',
   'e',
   't',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   'A',
   'R',
   'B',
   0, // glGetBufferSubDataARB
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'l',
   'i',
   'p',
   'P',
   'l',
   'a',
   'n',
   'e',
   0, // glGetClipPlane
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'l',
   'i',
   'p',
   'P',
   'l',
   'a',
   'n',
   'e',
   'f',
   0, // glGetClipPlanef
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'l',
   'i',
   'p',
   'P',
   'l',
   'a',
   'n',
   'e',
   'f',
   'O',
   'E',
   'S',
   0, // glGetClipPlanefOES
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'l',
   'i',
   'p',
   'P',
   'l',
   'a',
   'n',
   'e',
   'x',
   0, // glGetClipPlanex
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'l',
   'i',
   'p',
   'P',
   'l',
   'a',
   'n',
   'e',
   'x',
   'O',
   'E',
   'S',
   0, // glGetClipPlanexOES
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'l',
   'o',
   'r',
   'T',
   'a',
   'b',
   'l',
   'e',
   0, // glGetColorTable
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'l',
   'o',
   'r',
   'T',
   'a',
   'b',
   'l',
   'e',
   'E',
   'X',
   'T',
   0, // glGetColorTableEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'l',
   'o',
   'r',
   'T',
   'a',
   'b',
   'l',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   0, // glGetColorTableParameterfv
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'l',
   'o',
   'r',
   'T',
   'a',
   'b',
   'l',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glGetColorTableParameterfvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'l',
   'o',
   'r',
   'T',
   'a',
   'b',
   'l',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'S',
   'G',
   'I',
   0, // glGetColorTableParameterfvSGI
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'l',
   'o',
   'r',
   'T',
   'a',
   'b',
   'l',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   0, // glGetColorTableParameteriv
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'l',
   'o',
   'r',
   'T',
   'a',
   'b',
   'l',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetColorTableParameterivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'l',
   'o',
   'r',
   'T',
   'a',
   'b',
   'l',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'S',
   'G',
   'I',
   0, // glGetColorTableParameterivSGI
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'l',
   'o',
   'r',
   'T',
   'a',
   'b',
   'l',
   'e',
   'S',
   'G',
   'I',
   0, // glGetColorTableSGI
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'm',
   'b',
   'i',
   'n',
   'e',
   'r',
   'I',
   'n',
   'p',
   'u',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'N',
   'V',
   0, // glGetCombinerInputParameterfvNV
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'm',
   'b',
   'i',
   'n',
   'e',
   'r',
   'I',
   'n',
   'p',
   'u',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'N',
   'V',
   0, // glGetCombinerInputParameterivNV
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'm',
   'b',
   'i',
   'n',
   'e',
   'r',
   'O',
   'u',
   't',
   'p',
   'u',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'N',
   'V',
   0, // glGetCombinerOutputParameterfvNV
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'm',
   'b',
   'i',
   'n',
   'e',
   'r',
   'O',
   'u',
   't',
   'p',
   'u',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'N',
   'V',
   0, // glGetCombinerOutputParameterivNV
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'm',
   'b',
   'i',
   'n',
   'e',
   'r',
   'S',
   't',
   'a',
   'g',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'N',
   'V',
   0, // glGetCombinerStageParameterfvNV
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'm',
   'm',
   'a',
   'n',
   'd',
   'H',
   'e',
   'a',
   'd',
   'e',
   'r',
   'N',
   'V',
   0, // glGetCommandHeaderNV
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   'E',
   'X',
   'T',
   0, // glGetCompressedMultiTexImageEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   0, // glGetCompressedTexImage
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   'A',
   'R',
   'B',
   0, // glGetCompressedTexImageARB
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'I',
   'm',
   'a',
   'g',
   'e',
   0, // glGetCompressedTextureImage
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'I',
   'm',
   'a',
   'g',
   'e',
   'E',
   'X',
   'T',
   0, // glGetCompressedTextureImageEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   0, // glGetCompressedTextureSubImage
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'F',
   'i',
   'l',
   't',
   'e',
   'r',
   0, // glGetConvolutionFilter
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'F',
   'i',
   'l',
   't',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glGetConvolutionFilterEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   0, // glGetConvolutionParameterfv
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glGetConvolutionParameterfvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   0, // glGetConvolutionParameteriv
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetConvolutionParameterivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glGetConvolutionParameterxvOES
   'g',
   'l',
   'G',
   'e',
   't',
   'C',
   'o',
   'v',
   'e',
   'r',
   'a',
   'g',
   'e',
   'M',
   'o',
   'd',
   'u',
   'l',
   'a',
   't',
   'i',
   'o',
   'n',
   'T',
   'a',
   'b',
   'l',
   'e',
   'N',
   'V',
   0, // glGetCoverageModulationTableNV
   'g',
   'l',
   'G',
   'e',
   't',
   'D',
   'e',
   'b',
   'u',
   'g',
   'M',
   'e',
   's',
   's',
   'a',
   'g',
   'e',
   'L',
   'o',
   'g',
   0, // glGetDebugMessageLog
   'g',
   'l',
   'G',
   'e',
   't',
   'D',
   'e',
   'b',
   'u',
   'g',
   'M',
   'e',
   's',
   's',
   'a',
   'g',
   'e',
   'L',
   'o',
   'g',
   'A',
   'M',
   'D',
   0, // glGetDebugMessageLogAMD
   'g',
   'l',
   'G',
   'e',
   't',
   'D',
   'e',
   'b',
   'u',
   'g',
   'M',
   'e',
   's',
   's',
   'a',
   'g',
   'e',
   'L',
   'o',
   'g',
   'A',
   'R',
   'B',
   0, // glGetDebugMessageLogARB
   'g',
   'l',
   'G',
   'e',
   't',
   'D',
   'e',
   'b',
   'u',
   'g',
   'M',
   'e',
   's',
   's',
   'a',
   'g',
   'e',
   'L',
   'o',
   'g',
   'K',
   'H',
   'R',
   0, // glGetDebugMessageLogKHR
   'g',
   'l',
   'G',
   'e',
   't',
   'D',
   'e',
   't',
   'a',
   'i',
   'l',
   'T',
   'e',
   'x',
   'F',
   'u',
   'n',
   'c',
   'S',
   'G',
   'I',
   'S',
   0, // glGetDetailTexFuncSGIS
   'g',
   'l',
   'G',
   'e',
   't',
   'D',
   'o',
   'u',
   'b',
   'l',
   'e',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glGetDoubleIndexedvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'D',
   'o',
   'u',
   'b',
   'l',
   'e',
   'i',
   '_',
   'v',
   0, // glGetDoublei_v
   'g',
   'l',
   'G',
   'e',
   't',
   'D',
   'o',
   'u',
   'b',
   'l',
   'e',
   'i',
   '_',
   'v',
   'E',
   'X',
   'T',
   0, // glGetDoublei_vEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'D',
   'o',
   'u',
   'b',
   'l',
   'e',
   'v',
   0, // glGetDoublev
   'g',
   'l',
   'G',
   'e',
   't',
   'D',
   'r',
   'i',
   'v',
   'e',
   'r',
   'C',
   'o',
   'n',
   't',
   'r',
   'o',
   'l',
   'S',
   't',
   'r',
   'i',
   'n',
   'g',
   'Q',
   'C',
   'O',
   'M',
   0, // glGetDriverControlStringQCOM
   'g',
   'l',
   'G',
   'e',
   't',
   'D',
   'r',
   'i',
   'v',
   'e',
   'r',
   'C',
   'o',
   'n',
   't',
   'r',
   'o',
   'l',
   's',
   'Q',
   'C',
   'O',
   'M',
   0, // glGetDriverControlsQCOM
   'g',
   'l',
   'G',
   'e',
   't',
   'E',
   'r',
   'r',
   'o',
   'r',
   0, // glGetError
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'e',
   'n',
   'c',
   'e',
   'i',
   'v',
   'N',
   'V',
   0, // glGetFenceivNV
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'i',
   'n',
   'a',
   'l',
   'C',
   'o',
   'm',
   'b',
   'i',
   'n',
   'e',
   'r',
   'I',
   'n',
   'p',
   'u',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'N',
   'V',
   0, // glGetFinalCombinerInputParameterfvNV
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'i',
   'n',
   'a',
   'l',
   'C',
   'o',
   'm',
   'b',
   'i',
   'n',
   'e',
   'r',
   'I',
   'n',
   'p',
   'u',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'N',
   'V',
   0, // glGetFinalCombinerInputParameterivNV
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'i',
   'r',
   's',
   't',
   'P',
   'e',
   'r',
   'f',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'I',
   'd',
   'I',
   'N',
   'T',
   'E',
   'L',
   0, // glGetFirstPerfQueryIdINTEL
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'i',
   'x',
   'e',
   'd',
   'v',
   0, // glGetFixedv
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'i',
   'x',
   'e',
   'd',
   'v',
   'O',
   'E',
   'S',
   0, // glGetFixedvOES
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'l',
   'o',
   'a',
   't',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glGetFloatIndexedvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'l',
   'o',
   'a',
   't',
   'i',
   '_',
   'v',
   0, // glGetFloati_v
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'l',
   'o',
   'a',
   't',
   'i',
   '_',
   'v',
   'E',
   'X',
   'T',
   0, // glGetFloati_vEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'l',
   'o',
   'a',
   't',
   'i',
   '_',
   'v',
   'N',
   'V',
   0, // glGetFloati_vNV
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'l',
   'o',
   'a',
   't',
   'i',
   '_',
   'v',
   'O',
   'E',
   'S',
   0, // glGetFloati_vOES
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'l',
   'o',
   'a',
   't',
   'v',
   0, // glGetFloatv
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'o',
   'g',
   'F',
   'u',
   'n',
   'c',
   'S',
   'G',
   'I',
   'S',
   0, // glGetFogFuncSGIS
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'r',
   'a',
   'g',
   'D',
   'a',
   't',
   'a',
   'I',
   'n',
   'd',
   'e',
   'x',
   0, // glGetFragDataIndex
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'r',
   'a',
   'g',
   'D',
   'a',
   't',
   'a',
   'I',
   'n',
   'd',
   'e',
   'x',
   'E',
   'X',
   'T',
   0, // glGetFragDataIndexEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'r',
   'a',
   'g',
   'D',
   'a',
   't',
   'a',
   'L',
   'o',
   'c',
   'a',
   't',
   'i',
   'o',
   'n',
   0, // glGetFragDataLocation
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'r',
   'a',
   'g',
   'D',
   'a',
   't',
   'a',
   'L',
   'o',
   'c',
   'a',
   't',
   'i',
   'o',
   'n',
   'E',
   'X',
   'T',
   0, // glGetFragDataLocationEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'L',
   'i',
   'g',
   'h',
   't',
   'f',
   'v',
   'S',
   'G',
   'I',
   'X',
   0, // glGetFragmentLightfvSGIX
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'L',
   'i',
   'g',
   'h',
   't',
   'i',
   'v',
   'S',
   'G',
   'I',
   'X',
   0, // glGetFragmentLightivSGIX
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'M',
   'a',
   't',
   'e',
   'r',
   'i',
   'a',
   'l',
   'f',
   'v',
   'S',
   'G',
   'I',
   'X',
   0, // glGetFragmentMaterialfvSGIX
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'M',
   'a',
   't',
   'e',
   'r',
   'i',
   'a',
   'l',
   'i',
   'v',
   'S',
   'G',
   'I',
   'X',
   0, // glGetFragmentMaterialivSGIX
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'A',
   't',
   't',
   'a',
   'c',
   'h',
   'm',
   'e',
   'n',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   0, // glGetFramebufferAttachmentParameteriv
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'A',
   't',
   't',
   'a',
   'c',
   'h',
   'm',
   'e',
   'n',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetFramebufferAttachmentParameterivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'A',
   't',
   't',
   'a',
   'c',
   'h',
   'm',
   'e',
   'n',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'O',
   'E',
   'S',
   0, // glGetFramebufferAttachmentParameterivOES
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'A',
   'M',
   'D',
   0, // glGetFramebufferParameterfvAMD
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   0, // glGetFramebufferParameteriv
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetFramebufferParameterivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'i',
   'x',
   'e',
   'l',
   'L',
   'o',
   'c',
   'a',
   'l',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'S',
   'i',
   'z',
   'e',
   'E',
   'X',
   'T',
   0, // glGetFramebufferPixelLocalStorageSizeEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'G',
   'r',
   'a',
   'p',
   'h',
   'i',
   'c',
   's',
   'R',
   'e',
   's',
   'e',
   't',
   'S',
   't',
   'a',
   't',
   'u',
   's',
   0, // glGetGraphicsResetStatus
   'g',
   'l',
   'G',
   'e',
   't',
   'G',
   'r',
   'a',
   'p',
   'h',
   'i',
   'c',
   's',
   'R',
   'e',
   's',
   'e',
   't',
   'S',
   't',
   'a',
   't',
   'u',
   's',
   'A',
   'R',
   'B',
   0, // glGetGraphicsResetStatusARB
   'g',
   'l',
   'G',
   'e',
   't',
   'G',
   'r',
   'a',
   'p',
   'h',
   'i',
   'c',
   's',
   'R',
   'e',
   's',
   'e',
   't',
   'S',
   't',
   'a',
   't',
   'u',
   's',
   'E',
   'X',
   'T',
   0, // glGetGraphicsResetStatusEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'G',
   'r',
   'a',
   'p',
   'h',
   'i',
   'c',
   's',
   'R',
   'e',
   's',
   'e',
   't',
   'S',
   't',
   'a',
   't',
   'u',
   's',
   'K',
   'H',
   'R',
   0, // glGetGraphicsResetStatusKHR
   'g',
   'l',
   'G',
   'e',
   't',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'A',
   'R',
   'B',
   0, // glGetHandleARB
   'g',
   'l',
   'G',
   'e',
   't',
   'H',
   'i',
   's',
   't',
   'o',
   'g',
   'r',
   'a',
   'm',
   0, // glGetHistogram
   'g',
   'l',
   'G',
   'e',
   't',
   'H',
   'i',
   's',
   't',
   'o',
   'g',
   'r',
   'a',
   'm',
   'E',
   'X',
   'T',
   0, // glGetHistogramEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'H',
   'i',
   's',
   't',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   0, // glGetHistogramParameterfv
   'g',
   'l',
   'G',
   'e',
   't',
   'H',
   'i',
   's',
   't',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glGetHistogramParameterfvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'H',
   'i',
   's',
   't',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   0, // glGetHistogramParameteriv
   'g',
   'l',
   'G',
   'e',
   't',
   'H',
   'i',
   's',
   't',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetHistogramParameterivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'H',
   'i',
   's',
   't',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glGetHistogramParameterxvOES
   'g',
   'l',
   'G',
   'e',
   't',
   'I',
   'm',
   'a',
   'g',
   'e',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'A',
   'R',
   'B',
   0, // glGetImageHandleARB
   'g',
   'l',
   'G',
   'e',
   't',
   'I',
   'm',
   'a',
   'g',
   'e',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'N',
   'V',
   0, // glGetImageHandleNV
   'g',
   'l',
   'G',
   'e',
   't',
   'I',
   'm',
   'a',
   'g',
   'e',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'H',
   'P',
   0, // glGetImageTransformParameterfvHP
   'g',
   'l',
   'G',
   'e',
   't',
   'I',
   'm',
   'a',
   'g',
   'e',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'H',
   'P',
   0, // glGetImageTransformParameterivHP
   'g',
   'l',
   'G',
   'e',
   't',
   'I',
   'n',
   'f',
   'o',
   'L',
   'o',
   'g',
   'A',
   'R',
   'B',
   0, // glGetInfoLogARB
   'g',
   'l',
   'G',
   'e',
   't',
   'I',
   'n',
   's',
   't',
   'r',
   'u',
   'm',
   'e',
   'n',
   't',
   's',
   'S',
   'G',
   'I',
   'X',
   0, // glGetInstrumentsSGIX
   'g',
   'l',
   'G',
   'e',
   't',
   'I',
   'n',
   't',
   'e',
   'g',
   'e',
   'r',
   '6',
   '4',
   'i',
   '_',
   'v',
   0, // glGetInteger64i_v
   'g',
   'l',
   'G',
   'e',
   't',
   'I',
   'n',
   't',
   'e',
   'g',
   'e',
   'r',
   '6',
   '4',
   'v',
   0, // glGetInteger64v
   'g',
   'l',
   'G',
   'e',
   't',
   'I',
   'n',
   't',
   'e',
   'g',
   'e',
   'r',
   '6',
   '4',
   'v',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glGetInteger64vAPPLE
   'g',
   'l',
   'G',
   'e',
   't',
   'I',
   'n',
   't',
   'e',
   'g',
   'e',
   'r',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glGetIntegerIndexedvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'I',
   'n',
   't',
   'e',
   'g',
   'e',
   'r',
   'i',
   '_',
   'v',
   0, // glGetIntegeri_v
   'g',
   'l',
   'G',
   'e',
   't',
   'I',
   'n',
   't',
   'e',
   'g',
   'e',
   'r',
   'i',
   '_',
   'v',
   'E',
   'X',
   'T',
   0, // glGetIntegeri_vEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'I',
   'n',
   't',
   'e',
   'g',
   'e',
   'r',
   'u',
   'i',
   '6',
   '4',
   'i',
   '_',
   'v',
   'N',
   'V',
   0, // glGetIntegerui64i_vNV
   'g',
   'l',
   'G',
   'e',
   't',
   'I',
   'n',
   't',
   'e',
   'g',
   'e',
   'r',
   'u',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glGetIntegerui64vNV
   'g',
   'l',
   'G',
   'e',
   't',
   'I',
   'n',
   't',
   'e',
   'g',
   'e',
   'r',
   'v',
   0, // glGetIntegerv
   'g',
   'l',
   'G',
   'e',
   't',
   'I',
   'n',
   't',
   'e',
   'r',
   'n',
   'a',
   'l',
   'f',
   'o',
   'r',
   'm',
   'a',
   't',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'i',
   'v',
   'N',
   'V',
   0, // glGetInternalformatSampleivNV
   'g',
   'l',
   'G',
   'e',
   't',
   'I',
   'n',
   't',
   'e',
   'r',
   'n',
   'a',
   'l',
   'f',
   'o',
   'r',
   'm',
   'a',
   't',
   'i',
   '6',
   '4',
   'v',
   0, // glGetInternalformati64v
   'g',
   'l',
   'G',
   'e',
   't',
   'I',
   'n',
   't',
   'e',
   'r',
   'n',
   'a',
   'l',
   'f',
   'o',
   'r',
   'm',
   'a',
   't',
   'i',
   'v',
   0, // glGetInternalformativ
   'g',
   'l',
   'G',
   'e',
   't',
   'I',
   'n',
   'v',
   'a',
   'r',
   'i',
   'a',
   'n',
   't',
   'B',
   'o',
   'o',
   'l',
   'e',
   'a',
   'n',
   'v',
   'E',
   'X',
   'T',
   0, // glGetInvariantBooleanvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'I',
   'n',
   'v',
   'a',
   'r',
   'i',
   'a',
   'n',
   't',
   'F',
   'l',
   'o',
   'a',
   't',
   'v',
   'E',
   'X',
   'T',
   0, // glGetInvariantFloatvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'I',
   'n',
   'v',
   'a',
   'r',
   'i',
   'a',
   'n',
   't',
   'I',
   'n',
   't',
   'e',
   'g',
   'e',
   'r',
   'v',
   'E',
   'X',
   'T',
   0, // glGetInvariantIntegervEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'L',
   'i',
   'g',
   'h',
   't',
   'f',
   'v',
   0, // glGetLightfv
   'g',
   'l',
   'G',
   'e',
   't',
   'L',
   'i',
   'g',
   'h',
   't',
   'i',
   'v',
   0, // glGetLightiv
   'g',
   'l',
   'G',
   'e',
   't',
   'L',
   'i',
   'g',
   'h',
   't',
   'x',
   'O',
   'E',
   'S',
   0, // glGetLightxOES
   'g',
   'l',
   'G',
   'e',
   't',
   'L',
   'i',
   'g',
   'h',
   't',
   'x',
   'v',
   0, // glGetLightxv
   'g',
   'l',
   'G',
   'e',
   't',
   'L',
   'i',
   'g',
   'h',
   't',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glGetLightxvOES
   'g',
   'l',
   'G',
   'e',
   't',
   'L',
   'i',
   's',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'S',
   'G',
   'I',
   'X',
   0, // glGetListParameterfvSGIX
   'g',
   'l',
   'G',
   'e',
   't',
   'L',
   'i',
   's',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'S',
   'G',
   'I',
   'X',
   0, // glGetListParameterivSGIX
   'g',
   'l',
   'G',
   'e',
   't',
   'L',
   'o',
   'c',
   'a',
   'l',
   'C',
   'o',
   'n',
   's',
   't',
   'a',
   'n',
   't',
   'B',
   'o',
   'o',
   'l',
   'e',
   'a',
   'n',
   'v',
   'E',
   'X',
   'T',
   0, // glGetLocalConstantBooleanvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'L',
   'o',
   'c',
   'a',
   'l',
   'C',
   'o',
   'n',
   's',
   't',
   'a',
   'n',
   't',
   'F',
   'l',
   'o',
   'a',
   't',
   'v',
   'E',
   'X',
   'T',
   0, // glGetLocalConstantFloatvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'L',
   'o',
   'c',
   'a',
   'l',
   'C',
   'o',
   'n',
   's',
   't',
   'a',
   'n',
   't',
   'I',
   'n',
   't',
   'e',
   'g',
   'e',
   'r',
   'v',
   'E',
   'X',
   'T',
   0, // glGetLocalConstantIntegervEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'a',
   'p',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'N',
   'V',
   0, // glGetMapAttribParameterfvNV
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'a',
   'p',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'N',
   'V',
   0, // glGetMapAttribParameterivNV
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'a',
   'p',
   'C',
   'o',
   'n',
   't',
   'r',
   'o',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   's',
   'N',
   'V',
   0, // glGetMapControlPointsNV
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'a',
   'p',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'N',
   'V',
   0, // glGetMapParameterfvNV
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'a',
   'p',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'N',
   'V',
   0, // glGetMapParameterivNV
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'a',
   'p',
   'd',
   'v',
   0, // glGetMapdv
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'a',
   'p',
   'f',
   'v',
   0, // glGetMapfv
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'a',
   'p',
   'i',
   'v',
   0, // glGetMapiv
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'a',
   'p',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glGetMapxvOES
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'a',
   't',
   'e',
   'r',
   'i',
   'a',
   'l',
   'f',
   'v',
   0, // glGetMaterialfv
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'a',
   't',
   'e',
   'r',
   'i',
   'a',
   'l',
   'i',
   'v',
   0, // glGetMaterialiv
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'a',
   't',
   'e',
   'r',
   'i',
   'a',
   'l',
   'x',
   'O',
   'E',
   'S',
   0, // glGetMaterialxOES
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'a',
   't',
   'e',
   'r',
   'i',
   'a',
   'l',
   'x',
   'v',
   0, // glGetMaterialxv
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'a',
   't',
   'e',
   'r',
   'i',
   'a',
   'l',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glGetMaterialxvOES
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'e',
   'm',
   'o',
   'r',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetMemoryObjectParameterivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'i',
   'n',
   'm',
   'a',
   'x',
   0, // glGetMinmax
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'i',
   'n',
   'm',
   'a',
   'x',
   'E',
   'X',
   'T',
   0, // glGetMinmaxEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'i',
   'n',
   'm',
   'a',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   0, // glGetMinmaxParameterfv
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'i',
   'n',
   'm',
   'a',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glGetMinmaxParameterfvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'i',
   'n',
   'm',
   'a',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   0, // glGetMinmaxParameteriv
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'i',
   'n',
   'm',
   'a',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetMinmaxParameterivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'E',
   'n',
   'v',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glGetMultiTexEnvfvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'E',
   'n',
   'v',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetMultiTexEnvivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glGetMultiTexGendvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glGetMultiTexGenfvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetMultiTexGenivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   'E',
   'X',
   'T',
   0, // glGetMultiTexImageEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'L',
   'e',
   'v',
   'e',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glGetMultiTexLevelParameterfvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'L',
   'e',
   'v',
   'e',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetMultiTexLevelParameterivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetMultiTexParameterIivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetMultiTexParameterIuivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glGetMultiTexParameterfvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetMultiTexParameterivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'f',
   'v',
   0, // glGetMultisamplefv
   'g',
   'l',
   'G',
   'e',
   't',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'f',
   'v',
   'N',
   'V',
   0, // glGetMultisamplefvNV
   'g',
   'l',
   'G',
   'e',
   't',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   '6',
   '4',
   'v',
   0, // glGetNamedBufferParameteri64v
   'g',
   'l',
   'G',
   'e',
   't',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   0, // glGetNamedBufferParameteriv
   'g',
   'l',
   'G',
   'e',
   't',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetNamedBufferParameterivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'u',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glGetNamedBufferParameterui64vNV
   'g',
   'l',
   'G',
   'e',
   't',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'v',
   0, // glGetNamedBufferPointerv
   'g',
   'l',
   'G',
   'e',
   't',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'v',
   'E',
   'X',
   'T',
   0, // glGetNamedBufferPointervEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   0, // glGetNamedBufferSubData
   'g',
   'l',
   'G',
   'e',
   't',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   'E',
   'X',
   'T',
   0, // glGetNamedBufferSubDataEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'A',
   't',
   't',
   'a',
   'c',
   'h',
   'm',
   'e',
   'n',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   0, // glGetNamedFramebufferAttachmentParameteriv
   'g',
   'l',
   'G',
   'e',
   't',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'A',
   't',
   't',
   'a',
   'c',
   'h',
   'm',
   'e',
   'n',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetNamedFramebufferAttachmentParameterivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'A',
   'M',
   'D',
   0, // glGetNamedFramebufferParameterfvAMD
   'g',
   'l',
   'G',
   'e',
   't',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   0, // glGetNamedFramebufferParameteriv
   'g',
   'l',
   'G',
   'e',
   't',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetNamedFramebufferParameterivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'N',
   'a',
   'm',
   'e',
   'd',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetNamedProgramLocalParameterIivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'N',
   'a',
   'm',
   'e',
   'd',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetNamedProgramLocalParameterIuivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'N',
   'a',
   'm',
   'e',
   'd',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glGetNamedProgramLocalParameterdvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'N',
   'a',
   'm',
   'e',
   'd',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glGetNamedProgramLocalParameterfvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'N',
   'a',
   'm',
   'e',
   'd',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'S',
   't',
   'r',
   'i',
   'n',
   'g',
   'E',
   'X',
   'T',
   0, // glGetNamedProgramStringEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'N',
   'a',
   'm',
   'e',
   'd',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetNamedProgramivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'N',
   'a',
   'm',
   'e',
   'd',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   0, // glGetNamedRenderbufferParameteriv
   'g',
   'l',
   'G',
   'e',
   't',
   'N',
   'a',
   'm',
   'e',
   'd',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetNamedRenderbufferParameterivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'N',
   'a',
   'm',
   'e',
   'd',
   'S',
   't',
   'r',
   'i',
   'n',
   'g',
   'A',
   'R',
   'B',
   0, // glGetNamedStringARB
   'g',
   'l',
   'G',
   'e',
   't',
   'N',
   'a',
   'm',
   'e',
   'd',
   'S',
   't',
   'r',
   'i',
   'n',
   'g',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glGetNamedStringivARB
   'g',
   'l',
   'G',
   'e',
   't',
   'N',
   'e',
   'x',
   't',
   'P',
   'e',
   'r',
   'f',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'I',
   'd',
   'I',
   'N',
   'T',
   'E',
   'L',
   0, // glGetNextPerfQueryIdINTEL
   'g',
   'l',
   'G',
   'e',
   't',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'f',
   'v',
   'A',
   'T',
   'I',
   0, // glGetObjectBufferfvATI
   'g',
   'l',
   'G',
   'e',
   't',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'i',
   'v',
   'A',
   'T',
   'I',
   0, // glGetObjectBufferivATI
   'g',
   'l',
   'G',
   'e',
   't',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'L',
   'a',
   'b',
   'e',
   'l',
   0, // glGetObjectLabel
   'g',
   'l',
   'G',
   'e',
   't',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'L',
   'a',
   'b',
   'e',
   'l',
   'E',
   'X',
   'T',
   0, // glGetObjectLabelEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'L',
   'a',
   'b',
   'e',
   'l',
   'K',
   'H',
   'R',
   0, // glGetObjectLabelKHR
   'g',
   'l',
   'G',
   'e',
   't',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glGetObjectParameterfvARB
   'g',
   'l',
   'G',
   'e',
   't',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glGetObjectParameterivAPPLE
   'g',
   'l',
   'G',
   'e',
   't',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glGetObjectParameterivARB
   'g',
   'l',
   'G',
   'e',
   't',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'P',
   't',
   'r',
   'L',
   'a',
   'b',
   'e',
   'l',
   0, // glGetObjectPtrLabel
   'g',
   'l',
   'G',
   'e',
   't',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'P',
   't',
   'r',
   'L',
   'a',
   'b',
   'e',
   'l',
   'K',
   'H',
   'R',
   0, // glGetObjectPtrLabelKHR
   'g',
   'l',
   'G',
   'e',
   't',
   'O',
   'c',
   'c',
   'l',
   'u',
   's',
   'i',
   'o',
   'n',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'i',
   'v',
   'N',
   'V',
   0, // glGetOcclusionQueryivNV
   'g',
   'l',
   'G',
   'e',
   't',
   'O',
   'c',
   'c',
   'l',
   'u',
   's',
   'i',
   'o',
   'n',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'u',
   'i',
   'v',
   'N',
   'V',
   0, // glGetOcclusionQueryuivNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'a',
   't',
   'h',
   'C',
   'o',
   'l',
   'o',
   'r',
   'G',
   'e',
   'n',
   'f',
   'v',
   'N',
   'V',
   0, // glGetPathColorGenfvNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'a',
   't',
   'h',
   'C',
   'o',
   'l',
   'o',
   'r',
   'G',
   'e',
   'n',
   'i',
   'v',
   'N',
   'V',
   0, // glGetPathColorGenivNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'a',
   't',
   'h',
   'C',
   'o',
   'm',
   'm',
   'a',
   'n',
   'd',
   's',
   'N',
   'V',
   0, // glGetPathCommandsNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'a',
   't',
   'h',
   'C',
   'o',
   'o',
   'r',
   'd',
   's',
   'N',
   'V',
   0, // glGetPathCoordsNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'a',
   't',
   'h',
   'D',
   'a',
   's',
   'h',
   'A',
   'r',
   'r',
   'a',
   'y',
   'N',
   'V',
   0, // glGetPathDashArrayNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'a',
   't',
   'h',
   'L',
   'e',
   'n',
   'g',
   't',
   'h',
   'N',
   'V',
   0, // glGetPathLengthNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'a',
   't',
   'h',
   'M',
   'e',
   't',
   'r',
   'i',
   'c',
   'R',
   'a',
   'n',
   'g',
   'e',
   'N',
   'V',
   0, // glGetPathMetricRangeNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'a',
   't',
   'h',
   'M',
   'e',
   't',
   'r',
   'i',
   'c',
   's',
   'N',
   'V',
   0, // glGetPathMetricsNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'a',
   't',
   'h',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'N',
   'V',
   0, // glGetPathParameterfvNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'a',
   't',
   'h',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'N',
   'V',
   0, // glGetPathParameterivNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'a',
   't',
   'h',
   'S',
   'p',
   'a',
   'c',
   'i',
   'n',
   'g',
   'N',
   'V',
   0, // glGetPathSpacingNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'a',
   't',
   'h',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'f',
   'v',
   'N',
   'V',
   0, // glGetPathTexGenfvNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'a',
   't',
   'h',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'i',
   'v',
   'N',
   'V',
   0, // glGetPathTexGenivNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'e',
   'r',
   'f',
   'C',
   'o',
   'u',
   'n',
   't',
   'e',
   'r',
   'I',
   'n',
   'f',
   'o',
   'I',
   'N',
   'T',
   'E',
   'L',
   0, // glGetPerfCounterInfoINTEL
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'e',
   'r',
   'f',
   'M',
   'o',
   'n',
   'i',
   't',
   'o',
   'r',
   'C',
   'o',
   'u',
   'n',
   't',
   'e',
   'r',
   'D',
   'a',
   't',
   'a',
   'A',
   'M',
   'D',
   0, // glGetPerfMonitorCounterDataAMD
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'e',
   'r',
   'f',
   'M',
   'o',
   'n',
   'i',
   't',
   'o',
   'r',
   'C',
   'o',
   'u',
   'n',
   't',
   'e',
   'r',
   'I',
   'n',
   'f',
   'o',
   'A',
   'M',
   'D',
   0, // glGetPerfMonitorCounterInfoAMD
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'e',
   'r',
   'f',
   'M',
   'o',
   'n',
   'i',
   't',
   'o',
   'r',
   'C',
   'o',
   'u',
   'n',
   't',
   'e',
   'r',
   'S',
   't',
   'r',
   'i',
   'n',
   'g',
   'A',
   'M',
   'D',
   0, // glGetPerfMonitorCounterStringAMD
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'e',
   'r',
   'f',
   'M',
   'o',
   'n',
   'i',
   't',
   'o',
   'r',
   'C',
   'o',
   'u',
   'n',
   't',
   'e',
   'r',
   's',
   'A',
   'M',
   'D',
   0, // glGetPerfMonitorCountersAMD
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'e',
   'r',
   'f',
   'M',
   'o',
   'n',
   'i',
   't',
   'o',
   'r',
   'G',
   'r',
   'o',
   'u',
   'p',
   'S',
   't',
   'r',
   'i',
   'n',
   'g',
   'A',
   'M',
   'D',
   0, // glGetPerfMonitorGroupStringAMD
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'e',
   'r',
   'f',
   'M',
   'o',
   'n',
   'i',
   't',
   'o',
   'r',
   'G',
   'r',
   'o',
   'u',
   'p',
   's',
   'A',
   'M',
   'D',
   0, // glGetPerfMonitorGroupsAMD
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'e',
   'r',
   'f',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'D',
   'a',
   't',
   'a',
   'I',
   'N',
   'T',
   'E',
   'L',
   0, // glGetPerfQueryDataINTEL
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'e',
   'r',
   'f',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'I',
   'd',
   'B',
   'y',
   'N',
   'a',
   'm',
   'e',
   'I',
   'N',
   'T',
   'E',
   'L',
   0, // glGetPerfQueryIdByNameINTEL
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'e',
   'r',
   'f',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'I',
   'n',
   'f',
   'o',
   'I',
   'N',
   'T',
   'E',
   'L',
   0, // glGetPerfQueryInfoINTEL
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'i',
   'x',
   'e',
   'l',
   'M',
   'a',
   'p',
   'f',
   'v',
   0, // glGetPixelMapfv
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'i',
   'x',
   'e',
   'l',
   'M',
   'a',
   'p',
   'u',
   'i',
   'v',
   0, // glGetPixelMapuiv
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'i',
   'x',
   'e',
   'l',
   'M',
   'a',
   'p',
   'u',
   's',
   'v',
   0, // glGetPixelMapusv
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'i',
   'x',
   'e',
   'l',
   'M',
   'a',
   'p',
   'x',
   'v',
   0, // glGetPixelMapxv
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'i',
   'x',
   'e',
   'l',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'S',
   'G',
   'I',
   'S',
   0, // glGetPixelTexGenParameterfvSGIS
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'i',
   'x',
   'e',
   'l',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'S',
   'G',
   'I',
   'S',
   0, // glGetPixelTexGenParameterivSGIS
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'i',
   'x',
   'e',
   'l',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glGetPixelTransformParameterfvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'i',
   'x',
   'e',
   'l',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetPixelTransformParameterivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glGetPointerIndexedvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'i',
   '_',
   'v',
   'E',
   'X',
   'T',
   0, // glGetPointeri_vEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'v',
   0, // glGetPointerv
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'v',
   'E',
   'X',
   'T',
   0, // glGetPointervEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'v',
   'K',
   'H',
   'R',
   0, // glGetPointervKHR
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'o',
   'l',
   'y',
   'g',
   'o',
   'n',
   'S',
   't',
   'i',
   'p',
   'p',
   'l',
   'e',
   0, // glGetPolygonStipple
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'B',
   'i',
   'n',
   'a',
   'r',
   'y',
   0, // glGetProgramBinary
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'B',
   'i',
   'n',
   'a',
   'r',
   'y',
   'O',
   'E',
   'S',
   0, // glGetProgramBinaryOES
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'E',
   'n',
   'v',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'i',
   'v',
   'N',
   'V',
   0, // glGetProgramEnvParameterIivNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'E',
   'n',
   'v',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'u',
   'i',
   'v',
   'N',
   'V',
   0, // glGetProgramEnvParameterIuivNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'E',
   'n',
   'v',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'd',
   'v',
   'A',
   'R',
   'B',
   0, // glGetProgramEnvParameterdvARB
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'E',
   'n',
   'v',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glGetProgramEnvParameterfvARB
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'I',
   'n',
   'f',
   'o',
   'L',
   'o',
   'g',
   0, // glGetProgramInfoLog
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'I',
   'n',
   't',
   'e',
   'r',
   'f',
   'a',
   'c',
   'e',
   'i',
   'v',
   0, // glGetProgramInterfaceiv
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'i',
   'v',
   'N',
   'V',
   0, // glGetProgramLocalParameterIivNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'u',
   'i',
   'v',
   'N',
   'V',
   0, // glGetProgramLocalParameterIuivNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'd',
   'v',
   'A',
   'R',
   'B',
   0, // glGetProgramLocalParameterdvARB
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glGetProgramLocalParameterfvARB
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'N',
   'a',
   'm',
   'e',
   'd',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'd',
   'v',
   'N',
   'V',
   0, // glGetProgramNamedParameterdvNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'N',
   'a',
   'm',
   'e',
   'd',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'N',
   'V',
   0, // glGetProgramNamedParameterfvNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'd',
   'v',
   'N',
   'V',
   0, // glGetProgramParameterdvNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'N',
   'V',
   0, // glGetProgramParameterfvNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'i',
   'p',
   'e',
   'l',
   'i',
   'n',
   'e',
   'I',
   'n',
   'f',
   'o',
   'L',
   'o',
   'g',
   0, // glGetProgramPipelineInfoLog
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'i',
   'p',
   'e',
   'l',
   'i',
   'n',
   'e',
   'I',
   'n',
   'f',
   'o',
   'L',
   'o',
   'g',
   'E',
   'X',
   'T',
   0, // glGetProgramPipelineInfoLogEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'i',
   'p',
   'e',
   'l',
   'i',
   'n',
   'e',
   'i',
   'v',
   0, // glGetProgramPipelineiv
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'i',
   'p',
   'e',
   'l',
   'i',
   'n',
   'e',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetProgramPipelineivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'R',
   'e',
   's',
   'o',
   'u',
   'r',
   'c',
   'e',
   'I',
   'n',
   'd',
   'e',
   'x',
   0, // glGetProgramResourceIndex
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'R',
   'e',
   's',
   'o',
   'u',
   'r',
   'c',
   'e',
   'L',
   'o',
   'c',
   'a',
   't',
   'i',
   'o',
   'n',
   0, // glGetProgramResourceLocation
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'R',
   'e',
   's',
   'o',
   'u',
   'r',
   'c',
   'e',
   'L',
   'o',
   'c',
   'a',
   't',
   'i',
   'o',
   'n',
   'I',
   'n',
   'd',
   'e',
   'x',
   0, // glGetProgramResourceLocationIndex
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'R',
   'e',
   's',
   'o',
   'u',
   'r',
   'c',
   'e',
   'L',
   'o',
   'c',
   'a',
   't',
   'i',
   'o',
   'n',
   'I',
   'n',
   'd',
   'e',
   'x',
   'E',
   'X',
   'T',
   0, // glGetProgramResourceLocationIndexEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'R',
   'e',
   's',
   'o',
   'u',
   'r',
   'c',
   'e',
   'N',
   'a',
   'm',
   'e',
   0, // glGetProgramResourceName
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'R',
   'e',
   's',
   'o',
   'u',
   'r',
   'c',
   'e',
   'f',
   'v',
   'N',
   'V',
   0, // glGetProgramResourcefvNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'R',
   'e',
   's',
   'o',
   'u',
   'r',
   'c',
   'e',
   'i',
   'v',
   0, // glGetProgramResourceiv
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'S',
   't',
   'a',
   'g',
   'e',
   'i',
   'v',
   0, // glGetProgramStageiv
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'S',
   't',
   'r',
   'i',
   'n',
   'g',
   'A',
   'R',
   'B',
   0, // glGetProgramStringARB
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'S',
   't',
   'r',
   'i',
   'n',
   'g',
   'N',
   'V',
   0, // glGetProgramStringNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'S',
   'u',
   'b',
   'r',
   'o',
   'u',
   't',
   'i',
   'n',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'u',
   'i',
   'v',
   'N',
   'V',
   0, // glGetProgramSubroutineParameteruivNV
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'i',
   'v',
   0, // glGetProgramiv
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glGetProgramivARB
   'g',
   'l',
   'G',
   'e',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'i',
   'v',
   'N',
   'V',
   0, // glGetProgramivNV
   'g',
   'l',
   'G',
   'e',
   't',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'i',
   '6',
   '4',
   'v',
   0, // glGetQueryBufferObjecti64v
   'g',
   'l',
   'G',
   'e',
   't',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'i',
   'v',
   0, // glGetQueryBufferObjectiv
   'g',
   'l',
   'G',
   'e',
   't',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'u',
   'i',
   '6',
   '4',
   'v',
   0, // glGetQueryBufferObjectui64v
   'g',
   'l',
   'G',
   'e',
   't',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'u',
   'i',
   'v',
   0, // glGetQueryBufferObjectuiv
   'g',
   'l',
   'G',
   'e',
   't',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'i',
   'v',
   0, // glGetQueryIndexediv
   'g',
   'l',
   'G',
   'e',
   't',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'i',
   '6',
   '4',
   'v',
   0, // glGetQueryObjecti64v
   'g',
   'l',
   'G',
   'e',
   't',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'i',
   '6',
   '4',
   'v',
   'E',
   'X',
   'T',
   0, // glGetQueryObjecti64vEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'i',
   'v',
   0, // glGetQueryObjectiv
   'g',
   'l',
   'G',
   'e',
   't',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glGetQueryObjectivARB
   'g',
   'l',
   'G',
   'e',
   't',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetQueryObjectivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'u',
   'i',
   '6',
   '4',
   'v',
   0, // glGetQueryObjectui64v
   'g',
   'l',
   'G',
   'e',
   't',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'u',
   'i',
   '6',
   '4',
   'v',
   'E',
   'X',
   'T',
   0, // glGetQueryObjectui64vEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'u',
   'i',
   'v',
   0, // glGetQueryObjectuiv
   'g',
   'l',
   'G',
   'e',
   't',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'u',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glGetQueryObjectuivARB
   'g',
   'l',
   'G',
   'e',
   't',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetQueryObjectuivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'i',
   'v',
   0, // glGetQueryiv
   'g',
   'l',
   'G',
   'e',
   't',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glGetQueryivARB
   'g',
   'l',
   'G',
   'e',
   't',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetQueryivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   0, // glGetRenderbufferParameteriv
   'g',
   'l',
   'G',
   'e',
   't',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetRenderbufferParameterivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'O',
   'E',
   'S',
   0, // glGetRenderbufferParameterivOES
   'g',
   'l',
   'G',
   'e',
   't',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'i',
   'v',
   0, // glGetSamplerParameterIiv
   'g',
   'l',
   'G',
   'e',
   't',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetSamplerParameterIivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'i',
   'v',
   'O',
   'E',
   'S',
   0, // glGetSamplerParameterIivOES
   'g',
   'l',
   'G',
   'e',
   't',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'u',
   'i',
   'v',
   0, // glGetSamplerParameterIuiv
   'g',
   'l',
   'G',
   'e',
   't',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetSamplerParameterIuivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'u',
   'i',
   'v',
   'O',
   'E',
   'S',
   0, // glGetSamplerParameterIuivOES
   'g',
   'l',
   'G',
   'e',
   't',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   0, // glGetSamplerParameterfv
   'g',
   'l',
   'G',
   'e',
   't',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   0, // glGetSamplerParameteriv
   'g',
   'l',
   'G',
   'e',
   't',
   'S',
   'e',
   'm',
   'a',
   'p',
   'h',
   'o',
   'r',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'u',
   'i',
   '6',
   '4',
   'v',
   'E',
   'X',
   'T',
   0, // glGetSemaphoreParameterui64vEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   'b',
   'l',
   'e',
   'F',
   'i',
   'l',
   't',
   'e',
   'r',
   0, // glGetSeparableFilter
   'g',
   'l',
   'G',
   'e',
   't',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   'b',
   'l',
   'e',
   'F',
   'i',
   'l',
   't',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glGetSeparableFilterEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'I',
   'n',
   'f',
   'o',
   'L',
   'o',
   'g',
   0, // glGetShaderInfoLog
   'g',
   'l',
   'G',
   'e',
   't',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'P',
   'r',
   'e',
   'c',
   'i',
   's',
   'i',
   'o',
   'n',
   'F',
   'o',
   'r',
   'm',
   'a',
   't',
   0, // glGetShaderPrecisionFormat
   'g',
   'l',
   'G',
   'e',
   't',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'S',
   'o',
   'u',
   'r',
   'c',
   'e',
   0, // glGetShaderSource
   'g',
   'l',
   'G',
   'e',
   't',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'S',
   'o',
   'u',
   'r',
   'c',
   'e',
   'A',
   'R',
   'B',
   0, // glGetShaderSourceARB
   'g',
   'l',
   'G',
   'e',
   't',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'i',
   'v',
   0, // glGetShaderiv
   'g',
   'l',
   'G',
   'e',
   't',
   'S',
   'h',
   'a',
   'r',
   'p',
   'e',
   'n',
   'T',
   'e',
   'x',
   'F',
   'u',
   'n',
   'c',
   'S',
   'G',
   'I',
   'S',
   0, // glGetSharpenTexFuncSGIS
   'g',
   'l',
   'G',
   'e',
   't',
   'S',
   't',
   'a',
   'g',
   'e',
   'I',
   'n',
   'd',
   'e',
   'x',
   'N',
   'V',
   0, // glGetStageIndexNV
   'g',
   'l',
   'G',
   'e',
   't',
   'S',
   't',
   'r',
   'i',
   'n',
   'g',
   0, // glGetString
   'g',
   'l',
   'G',
   'e',
   't',
   'S',
   't',
   'r',
   'i',
   'n',
   'g',
   'i',
   0, // glGetStringi
   'g',
   'l',
   'G',
   'e',
   't',
   'S',
   'u',
   'b',
   'r',
   'o',
   'u',
   't',
   'i',
   'n',
   'e',
   'I',
   'n',
   'd',
   'e',
   'x',
   0, // glGetSubroutineIndex
   'g',
   'l',
   'G',
   'e',
   't',
   'S',
   'u',
   'b',
   'r',
   'o',
   'u',
   't',
   'i',
   'n',
   'e',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'L',
   'o',
   'c',
   'a',
   't',
   'i',
   'o',
   'n',
   0, // glGetSubroutineUniformLocation
   'g',
   'l',
   'G',
   'e',
   't',
   'S',
   'y',
   'n',
   'c',
   'i',
   'v',
   0, // glGetSynciv
   'g',
   'l',
   'G',
   'e',
   't',
   'S',
   'y',
   'n',
   'c',
   'i',
   'v',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glGetSyncivAPPLE
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'B',
   'u',
   'm',
   'p',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'A',
   'T',
   'I',
   0, // glGetTexBumpParameterfvATI
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'B',
   'u',
   'm',
   'p',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'A',
   'T',
   'I',
   0, // glGetTexBumpParameterivATI
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'E',
   'n',
   'v',
   'f',
   'v',
   0, // glGetTexEnvfv
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'E',
   'n',
   'v',
   'i',
   'v',
   0, // glGetTexEnviv
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'E',
   'n',
   'v',
   'x',
   'v',
   0, // glGetTexEnvxv
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'E',
   'n',
   'v',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glGetTexEnvxvOES
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'F',
   'i',
   'l',
   't',
   'e',
   'r',
   'F',
   'u',
   'n',
   'c',
   'S',
   'G',
   'I',
   'S',
   0, // glGetTexFilterFuncSGIS
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'd',
   'v',
   0, // glGetTexGendv
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'f',
   'v',
   0, // glGetTexGenfv
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'f',
   'v',
   'O',
   'E',
   'S',
   0, // glGetTexGenfvOES
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'i',
   'v',
   0, // glGetTexGeniv
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'i',
   'v',
   'O',
   'E',
   'S',
   0, // glGetTexGenivOES
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glGetTexGenxvOES
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   0, // glGetTexImage
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'L',
   'e',
   'v',
   'e',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   0, // glGetTexLevelParameterfv
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'L',
   'e',
   'v',
   'e',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   0, // glGetTexLevelParameteriv
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'L',
   'e',
   'v',
   'e',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glGetTexLevelParameterxvOES
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'i',
   'v',
   0, // glGetTexParameterIiv
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetTexParameterIivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'i',
   'v',
   'O',
   'E',
   'S',
   0, // glGetTexParameterIivOES
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'u',
   'i',
   'v',
   0, // glGetTexParameterIuiv
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetTexParameterIuivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'u',
   'i',
   'v',
   'O',
   'E',
   'S',
   0, // glGetTexParameterIuivOES
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'v',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glGetTexParameterPointervAPPLE
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   0, // glGetTexParameterfv
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   0, // glGetTexParameteriv
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'x',
   'v',
   0, // glGetTexParameterxv
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glGetTexParameterxvOES
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'A',
   'R',
   'B',
   0, // glGetTextureHandleARB
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'I',
   'M',
   'G',
   0, // glGetTextureHandleIMG
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'N',
   'V',
   0, // glGetTextureHandleNV
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'I',
   'm',
   'a',
   'g',
   'e',
   0, // glGetTextureImage
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'I',
   'm',
   'a',
   'g',
   'e',
   'E',
   'X',
   'T',
   0, // glGetTextureImageEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'L',
   'e',
   'v',
   'e',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   0, // glGetTextureLevelParameterfv
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'L',
   'e',
   'v',
   'e',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glGetTextureLevelParameterfvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'L',
   'e',
   'v',
   'e',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   0, // glGetTextureLevelParameteriv
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'L',
   'e',
   'v',
   'e',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetTextureLevelParameterivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'i',
   'v',
   0, // glGetTextureParameterIiv
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetTextureParameterIivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'u',
   'i',
   'v',
   0, // glGetTextureParameterIuiv
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetTextureParameterIuivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   0, // glGetTextureParameterfv
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glGetTextureParameterfvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   0, // glGetTextureParameteriv
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetTextureParameterivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'A',
   'R',
   'B',
   0, // glGetTextureSamplerHandleARB
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'I',
   'M',
   'G',
   0, // glGetTextureSamplerHandleIMG
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'N',
   'V',
   0, // glGetTextureSamplerHandleNV
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   0, // glGetTextureSubImage
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'r',
   'a',
   'c',
   'k',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'i',
   'v',
   'N',
   'V',
   0, // glGetTrackMatrixivNV
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'V',
   'a',
   'r',
   'y',
   'i',
   'n',
   'g',
   0, // glGetTransformFeedbackVarying
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'V',
   'a',
   'r',
   'y',
   'i',
   'n',
   'g',
   'E',
   'X',
   'T',
   0, // glGetTransformFeedbackVaryingEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'V',
   'a',
   'r',
   'y',
   'i',
   'n',
   'g',
   'N',
   'V',
   0, // glGetTransformFeedbackVaryingNV
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'i',
   '6',
   '4',
   '_',
   'v',
   0, // glGetTransformFeedbacki64_v
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'i',
   '_',
   'v',
   0, // glGetTransformFeedbacki_v
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'i',
   'v',
   0, // glGetTransformFeedbackiv
   'g',
   'l',
   'G',
   'e',
   't',
   'T',
   'r',
   'a',
   'n',
   's',
   'l',
   'a',
   't',
   'e',
   'd',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'S',
   'o',
   'u',
   'r',
   'c',
   'e',
   'A',
   'N',
   'G',
   'L',
   'E',
   0, // glGetTranslatedShaderSourceANGLE
   'g',
   'l',
   'G',
   'e',
   't',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'B',
   'l',
   'o',
   'c',
   'k',
   'I',
   'n',
   'd',
   'e',
   'x',
   0, // glGetUniformBlockIndex
   'g',
   'l',
   'G',
   'e',
   't',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'i',
   'z',
   'e',
   'E',
   'X',
   'T',
   0, // glGetUniformBufferSizeEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'I',
   'n',
   'd',
   'i',
   'c',
   'e',
   's',
   0, // glGetUniformIndices
   'g',
   'l',
   'G',
   'e',
   't',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'L',
   'o',
   'c',
   'a',
   't',
   'i',
   'o',
   'n',
   0, // glGetUniformLocation
   'g',
   'l',
   'G',
   'e',
   't',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'L',
   'o',
   'c',
   'a',
   't',
   'i',
   'o',
   'n',
   'A',
   'R',
   'B',
   0, // glGetUniformLocationARB
   'g',
   'l',
   'G',
   'e',
   't',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'O',
   'f',
   'f',
   's',
   'e',
   't',
   'E',
   'X',
   'T',
   0, // glGetUniformOffsetEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'S',
   'u',
   'b',
   'r',
   'o',
   'u',
   't',
   'i',
   'n',
   'e',
   'u',
   'i',
   'v',
   0, // glGetUniformSubroutineuiv
   'g',
   'l',
   'G',
   'e',
   't',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'd',
   'v',
   0, // glGetUniformdv
   'g',
   'l',
   'G',
   'e',
   't',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'f',
   'v',
   0, // glGetUniformfv
   'g',
   'l',
   'G',
   'e',
   't',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glGetUniformfvARB
   'g',
   'l',
   'G',
   'e',
   't',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'i',
   '6',
   '4',
   'v',
   'A',
   'R',
   'B',
   0, // glGetUniformi64vARB
   'g',
   'l',
   'G',
   'e',
   't',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glGetUniformi64vNV
   'g',
   'l',
   'G',
   'e',
   't',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'i',
   'v',
   0, // glGetUniformiv
   'g',
   'l',
   'G',
   'e',
   't',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glGetUniformivARB
   'g',
   'l',
   'G',
   'e',
   't',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'u',
   'i',
   '6',
   '4',
   'v',
   'A',
   'R',
   'B',
   0, // glGetUniformui64vARB
   'g',
   'l',
   'G',
   'e',
   't',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'u',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glGetUniformui64vNV
   'g',
   'l',
   'G',
   'e',
   't',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'u',
   'i',
   'v',
   0, // glGetUniformuiv
   'g',
   'l',
   'G',
   'e',
   't',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetUniformuivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'U',
   'n',
   's',
   'i',
   'g',
   'n',
   'e',
   'd',
   'B',
   'y',
   't',
   'e',
   'i',
   '_',
   'v',
   'E',
   'X',
   'T',
   0, // glGetUnsignedBytei_vEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'U',
   'n',
   's',
   'i',
   'g',
   'n',
   'e',
   'd',
   'B',
   'y',
   't',
   'e',
   'v',
   'E',
   'X',
   'T',
   0, // glGetUnsignedBytevEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'a',
   'r',
   'i',
   'a',
   'n',
   't',
   'A',
   'r',
   'r',
   'a',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'f',
   'v',
   'A',
   'T',
   'I',
   0, // glGetVariantArrayObjectfvATI
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'a',
   'r',
   'i',
   'a',
   'n',
   't',
   'A',
   'r',
   'r',
   'a',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'i',
   'v',
   'A',
   'T',
   'I',
   0, // glGetVariantArrayObjectivATI
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'a',
   'r',
   'i',
   'a',
   'n',
   't',
   'B',
   'o',
   'o',
   'l',
   'e',
   'a',
   'n',
   'v',
   'E',
   'X',
   'T',
   0, // glGetVariantBooleanvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'a',
   'r',
   'i',
   'a',
   'n',
   't',
   'F',
   'l',
   'o',
   'a',
   't',
   'v',
   'E',
   'X',
   'T',
   0, // glGetVariantFloatvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'a',
   'r',
   'i',
   'a',
   'n',
   't',
   'I',
   'n',
   't',
   'e',
   'g',
   'e',
   'r',
   'v',
   'E',
   'X',
   'T',
   0, // glGetVariantIntegervEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'a',
   'r',
   'i',
   'a',
   'n',
   't',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'v',
   'E',
   'X',
   'T',
   0, // glGetVariantPointervEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'a',
   'r',
   'y',
   'i',
   'n',
   'g',
   'L',
   'o',
   'c',
   'a',
   't',
   'i',
   'o',
   'n',
   'N',
   'V',
   0, // glGetVaryingLocationNV
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   '6',
   '4',
   'i',
   'v',
   0, // glGetVertexArrayIndexed64iv
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'i',
   'v',
   0, // glGetVertexArrayIndexediv
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'I',
   'n',
   't',
   'e',
   'g',
   'e',
   'r',
   'i',
   '_',
   'v',
   'E',
   'X',
   'T',
   0, // glGetVertexArrayIntegeri_vEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'I',
   'n',
   't',
   'e',
   'g',
   'e',
   'r',
   'v',
   'E',
   'X',
   'T',
   0, // glGetVertexArrayIntegervEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'i',
   '_',
   'v',
   'E',
   'X',
   'T',
   0, // glGetVertexArrayPointeri_vEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'v',
   'E',
   'X',
   'T',
   0, // glGetVertexArrayPointervEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'i',
   'v',
   0, // glGetVertexArrayiv
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'A',
   'r',
   'r',
   'a',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'f',
   'v',
   'A',
   'T',
   'I',
   0, // glGetVertexAttribArrayObjectfvATI
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'A',
   'r',
   'r',
   'a',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'i',
   'v',
   'A',
   'T',
   'I',
   0, // glGetVertexAttribArrayObjectivATI
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   'i',
   'v',
   0, // glGetVertexAttribIiv
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetVertexAttribIivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   'u',
   'i',
   'v',
   0, // glGetVertexAttribIuiv
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetVertexAttribIuivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   'd',
   'v',
   0, // glGetVertexAttribLdv
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glGetVertexAttribLdvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glGetVertexAttribLi64vNV
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   'u',
   'i',
   '6',
   '4',
   'v',
   'A',
   'R',
   'B',
   0, // glGetVertexAttribLui64vARB
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   'u',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glGetVertexAttribLui64vNV
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'v',
   0, // glGetVertexAttribPointerv
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'v',
   'A',
   'R',
   'B',
   0, // glGetVertexAttribPointervARB
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'v',
   'N',
   'V',
   0, // glGetVertexAttribPointervNV
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'd',
   'v',
   0, // glGetVertexAttribdv
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'd',
   'v',
   'A',
   'R',
   'B',
   0, // glGetVertexAttribdvARB
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'd',
   'v',
   'N',
   'V',
   0, // glGetVertexAttribdvNV
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'f',
   'v',
   0, // glGetVertexAttribfv
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glGetVertexAttribfvARB
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'f',
   'v',
   'N',
   'V',
   0, // glGetVertexAttribfvNV
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'i',
   'v',
   0, // glGetVertexAttribiv
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glGetVertexAttribivARB
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'i',
   'v',
   'N',
   'V',
   0, // glGetVertexAttribivNV
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'i',
   'd',
   'e',
   'o',
   'C',
   'a',
   'p',
   't',
   'u',
   'r',
   'e',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   'd',
   'v',
   'N',
   'V',
   0, // glGetVideoCaptureStreamdvNV
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'i',
   'd',
   'e',
   'o',
   'C',
   'a',
   'p',
   't',
   'u',
   'r',
   'e',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   'f',
   'v',
   'N',
   'V',
   0, // glGetVideoCaptureStreamfvNV
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'i',
   'd',
   'e',
   'o',
   'C',
   'a',
   'p',
   't',
   'u',
   'r',
   'e',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   'i',
   'v',
   'N',
   'V',
   0, // glGetVideoCaptureStreamivNV
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'i',
   'd',
   'e',
   'o',
   'C',
   'a',
   'p',
   't',
   'u',
   'r',
   'e',
   'i',
   'v',
   'N',
   'V',
   0, // glGetVideoCaptureivNV
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'i',
   'd',
   'e',
   'o',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glGetVideoi64vNV
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'i',
   'd',
   'e',
   'o',
   'i',
   'v',
   'N',
   'V',
   0, // glGetVideoivNV
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'i',
   'd',
   'e',
   'o',
   'u',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glGetVideoui64vNV
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'i',
   'd',
   'e',
   'o',
   'u',
   'i',
   'v',
   'N',
   'V',
   0, // glGetVideouivNV
   'g',
   'l',
   'G',
   'e',
   't',
   'V',
   'k',
   'P',
   'r',
   'o',
   'c',
   'A',
   'd',
   'd',
   'r',
   'N',
   'V',
   0, // glGetVkProcAddrNV
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'C',
   'o',
   'l',
   'o',
   'r',
   'T',
   'a',
   'b',
   'l',
   'e',
   0, // glGetnColorTable
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'C',
   'o',
   'l',
   'o',
   'r',
   'T',
   'a',
   'b',
   'l',
   'e',
   'A',
   'R',
   'B',
   0, // glGetnColorTableARB
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   0, // glGetnCompressedTexImage
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'C',
   'o',
   'm',
   'p',
   'r',
   'e',
   's',
   's',
   'e',
   'd',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   'A',
   'R',
   'B',
   0, // glGetnCompressedTexImageARB
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'F',
   'i',
   'l',
   't',
   'e',
   'r',
   0, // glGetnConvolutionFilter
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'C',
   'o',
   'n',
   'v',
   'o',
   'l',
   'u',
   't',
   'i',
   'o',
   'n',
   'F',
   'i',
   'l',
   't',
   'e',
   'r',
   'A',
   'R',
   'B',
   0, // glGetnConvolutionFilterARB
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'H',
   'i',
   's',
   't',
   'o',
   'g',
   'r',
   'a',
   'm',
   0, // glGetnHistogram
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'H',
   'i',
   's',
   't',
   'o',
   'g',
   'r',
   'a',
   'm',
   'A',
   'R',
   'B',
   0, // glGetnHistogramARB
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'M',
   'a',
   'p',
   'd',
   'v',
   0, // glGetnMapdv
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'M',
   'a',
   'p',
   'd',
   'v',
   'A',
   'R',
   'B',
   0, // glGetnMapdvARB
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'M',
   'a',
   'p',
   'f',
   'v',
   0, // glGetnMapfv
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'M',
   'a',
   'p',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glGetnMapfvARB
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'M',
   'a',
   'p',
   'i',
   'v',
   0, // glGetnMapiv
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'M',
   'a',
   'p',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glGetnMapivARB
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'M',
   'i',
   'n',
   'm',
   'a',
   'x',
   0, // glGetnMinmax
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'M',
   'i',
   'n',
   'm',
   'a',
   'x',
   'A',
   'R',
   'B',
   0, // glGetnMinmaxARB
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'P',
   'i',
   'x',
   'e',
   'l',
   'M',
   'a',
   'p',
   'f',
   'v',
   0, // glGetnPixelMapfv
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'P',
   'i',
   'x',
   'e',
   'l',
   'M',
   'a',
   'p',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glGetnPixelMapfvARB
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'P',
   'i',
   'x',
   'e',
   'l',
   'M',
   'a',
   'p',
   'u',
   'i',
   'v',
   0, // glGetnPixelMapuiv
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'P',
   'i',
   'x',
   'e',
   'l',
   'M',
   'a',
   'p',
   'u',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glGetnPixelMapuivARB
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'P',
   'i',
   'x',
   'e',
   'l',
   'M',
   'a',
   'p',
   'u',
   's',
   'v',
   0, // glGetnPixelMapusv
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'P',
   'i',
   'x',
   'e',
   'l',
   'M',
   'a',
   'p',
   'u',
   's',
   'v',
   'A',
   'R',
   'B',
   0, // glGetnPixelMapusvARB
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'P',
   'o',
   'l',
   'y',
   'g',
   'o',
   'n',
   'S',
   't',
   'i',
   'p',
   'p',
   'l',
   'e',
   0, // glGetnPolygonStipple
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'P',
   'o',
   'l',
   'y',
   'g',
   'o',
   'n',
   'S',
   't',
   'i',
   'p',
   'p',
   'l',
   'e',
   'A',
   'R',
   'B',
   0, // glGetnPolygonStippleARB
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   'b',
   'l',
   'e',
   'F',
   'i',
   'l',
   't',
   'e',
   'r',
   0, // glGetnSeparableFilter
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   'b',
   'l',
   'e',
   'F',
   'i',
   'l',
   't',
   'e',
   'r',
   'A',
   'R',
   'B',
   0, // glGetnSeparableFilterARB
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   0, // glGetnTexImage
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   'A',
   'R',
   'B',
   0, // glGetnTexImageARB
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'd',
   'v',
   0, // glGetnUniformdv
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'd',
   'v',
   'A',
   'R',
   'B',
   0, // glGetnUniformdvARB
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'f',
   'v',
   0, // glGetnUniformfv
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glGetnUniformfvARB
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glGetnUniformfvEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'f',
   'v',
   'K',
   'H',
   'R',
   0, // glGetnUniformfvKHR
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'i',
   '6',
   '4',
   'v',
   'A',
   'R',
   'B',
   0, // glGetnUniformi64vARB
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'i',
   'v',
   0, // glGetnUniformiv
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glGetnUniformivARB
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glGetnUniformivEXT
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'i',
   'v',
   'K',
   'H',
   'R',
   0, // glGetnUniformivKHR
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'u',
   'i',
   '6',
   '4',
   'v',
   'A',
   'R',
   'B',
   0, // glGetnUniformui64vARB
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'u',
   'i',
   'v',
   0, // glGetnUniformuiv
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'u',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glGetnUniformuivARB
   'g',
   'l',
   'G',
   'e',
   't',
   'n',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'u',
   'i',
   'v',
   'K',
   'H',
   'R',
   0, // glGetnUniformuivKHR
   'g',
   'l',
   'G',
   'l',
   'o',
   'b',
   'a',
   'l',
   'A',
   'l',
   'p',
   'h',
   'a',
   'F',
   'a',
   'c',
   't',
   'o',
   'r',
   'b',
   'S',
   'U',
   'N',
   0, // glGlobalAlphaFactorbSUN
   'g',
   'l',
   'G',
   'l',
   'o',
   'b',
   'a',
   'l',
   'A',
   'l',
   'p',
   'h',
   'a',
   'F',
   'a',
   'c',
   't',
   'o',
   'r',
   'd',
   'S',
   'U',
   'N',
   0, // glGlobalAlphaFactordSUN
   'g',
   'l',
   'G',
   'l',
   'o',
   'b',
   'a',
   'l',
   'A',
   'l',
   'p',
   'h',
   'a',
   'F',
   'a',
   'c',
   't',
   'o',
   'r',
   'f',
   'S',
   'U',
   'N',
   0, // glGlobalAlphaFactorfSUN
   'g',
   'l',
   'G',
   'l',
   'o',
   'b',
   'a',
   'l',
   'A',
   'l',
   'p',
   'h',
   'a',
   'F',
   'a',
   'c',
   't',
   'o',
   'r',
   'i',
   'S',
   'U',
   'N',
   0, // glGlobalAlphaFactoriSUN
   'g',
   'l',
   'G',
   'l',
   'o',
   'b',
   'a',
   'l',
   'A',
   'l',
   'p',
   'h',
   'a',
   'F',
   'a',
   'c',
   't',
   'o',
   'r',
   's',
   'S',
   'U',
   'N',
   0, // glGlobalAlphaFactorsSUN
   'g',
   'l',
   'G',
   'l',
   'o',
   'b',
   'a',
   'l',
   'A',
   'l',
   'p',
   'h',
   'a',
   'F',
   'a',
   'c',
   't',
   'o',
   'r',
   'u',
   'b',
   'S',
   'U',
   'N',
   0, // glGlobalAlphaFactorubSUN
   'g',
   'l',
   'G',
   'l',
   'o',
   'b',
   'a',
   'l',
   'A',
   'l',
   'p',
   'h',
   'a',
   'F',
   'a',
   'c',
   't',
   'o',
   'r',
   'u',
   'i',
   'S',
   'U',
   'N',
   0, // glGlobalAlphaFactoruiSUN
   'g',
   'l',
   'G',
   'l',
   'o',
   'b',
   'a',
   'l',
   'A',
   'l',
   'p',
   'h',
   'a',
   'F',
   'a',
   'c',
   't',
   'o',
   'r',
   'u',
   's',
   'S',
   'U',
   'N',
   0, // glGlobalAlphaFactorusSUN
   'g',
   'l',
   'H',
   'i',
   'n',
   't',
   0, // glHint
   'g',
   'l',
   'H',
   'i',
   'n',
   't',
   'P',
   'G',
   'I',
   0, // glHintPGI
   'g',
   'l',
   'H',
   'i',
   's',
   't',
   'o',
   'g',
   'r',
   'a',
   'm',
   0, // glHistogram
   'g',
   'l',
   'H',
   'i',
   's',
   't',
   'o',
   'g',
   'r',
   'a',
   'm',
   'E',
   'X',
   'T',
   0, // glHistogramEXT
   'g',
   'l',
   'I',
   'g',
   'l',
   'o',
   'o',
   'I',
   'n',
   't',
   'e',
   'r',
   'f',
   'a',
   'c',
   'e',
   'S',
   'G',
   'I',
   'X',
   0, // glIglooInterfaceSGIX
   'g',
   'l',
   'I',
   'm',
   'a',
   'g',
   'e',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'H',
   'P',
   0, // glImageTransformParameterfHP
   'g',
   'l',
   'I',
   'm',
   'a',
   'g',
   'e',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'H',
   'P',
   0, // glImageTransformParameterfvHP
   'g',
   'l',
   'I',
   'm',
   'a',
   'g',
   'e',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'H',
   'P',
   0, // glImageTransformParameteriHP
   'g',
   'l',
   'I',
   'm',
   'a',
   'g',
   'e',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'H',
   'P',
   0, // glImageTransformParameterivHP
   'g',
   'l',
   'I',
   'm',
   'p',
   'o',
   'r',
   't',
   'M',
   'e',
   'm',
   'o',
   'r',
   'y',
   'F',
   'd',
   'E',
   'X',
   'T',
   0, // glImportMemoryFdEXT
   'g',
   'l',
   'I',
   'm',
   'p',
   'o',
   'r',
   't',
   'M',
   'e',
   'm',
   'o',
   'r',
   'y',
   'W',
   'i',
   'n',
   '3',
   '2',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'E',
   'X',
   'T',
   0, // glImportMemoryWin32HandleEXT
   'g',
   'l',
   'I',
   'm',
   'p',
   'o',
   'r',
   't',
   'M',
   'e',
   'm',
   'o',
   'r',
   'y',
   'W',
   'i',
   'n',
   '3',
   '2',
   'N',
   'a',
   'm',
   'e',
   'E',
   'X',
   'T',
   0, // glImportMemoryWin32NameEXT
   'g',
   'l',
   'I',
   'm',
   'p',
   'o',
   'r',
   't',
   'S',
   'e',
   'm',
   'a',
   'p',
   'h',
   'o',
   'r',
   'e',
   'F',
   'd',
   'E',
   'X',
   'T',
   0, // glImportSemaphoreFdEXT
   'g',
   'l',
   'I',
   'm',
   'p',
   'o',
   'r',
   't',
   'S',
   'e',
   'm',
   'a',
   'p',
   'h',
   'o',
   'r',
   'e',
   'W',
   'i',
   'n',
   '3',
   '2',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'E',
   'X',
   'T',
   0, // glImportSemaphoreWin32HandleEXT
   'g',
   'l',
   'I',
   'm',
   'p',
   'o',
   'r',
   't',
   'S',
   'e',
   'm',
   'a',
   'p',
   'h',
   'o',
   'r',
   'e',
   'W',
   'i',
   'n',
   '3',
   '2',
   'N',
   'a',
   'm',
   'e',
   'E',
   'X',
   'T',
   0, // glImportSemaphoreWin32NameEXT
   'g',
   'l',
   'I',
   'm',
   'p',
   'o',
   'r',
   't',
   'S',
   'y',
   'n',
   'c',
   'E',
   'X',
   'T',
   0, // glImportSyncEXT
   'g',
   'l',
   'I',
   'n',
   'd',
   'e',
   'x',
   'F',
   'o',
   'r',
   'm',
   'a',
   't',
   'N',
   'V',
   0, // glIndexFormatNV
   'g',
   'l',
   'I',
   'n',
   'd',
   'e',
   'x',
   'F',
   'u',
   'n',
   'c',
   'E',
   'X',
   'T',
   0, // glIndexFuncEXT
   'g',
   'l',
   'I',
   'n',
   'd',
   'e',
   'x',
   'M',
   'a',
   's',
   'k',
   0, // glIndexMask
   'g',
   'l',
   'I',
   'n',
   'd',
   'e',
   'x',
   'M',
   'a',
   't',
   'e',
   'r',
   'i',
   'a',
   'l',
   'E',
   'X',
   'T',
   0, // glIndexMaterialEXT
   'g',
   'l',
   'I',
   'n',
   'd',
   'e',
   'x',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   0, // glIndexPointer
   'g',
   'l',
   'I',
   'n',
   'd',
   'e',
   'x',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glIndexPointerEXT
   'g',
   'l',
   'I',
   'n',
   'd',
   'e',
   'x',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'L',
   'i',
   's',
   't',
   'I',
   'B',
   'M',
   0, // glIndexPointerListIBM
   'g',
   'l',
   'I',
   'n',
   'd',
   'e',
   'x',
   'd',
   0, // glIndexd
   'g',
   'l',
   'I',
   'n',
   'd',
   'e',
   'x',
   'd',
   'v',
   0, // glIndexdv
   'g',
   'l',
   'I',
   'n',
   'd',
   'e',
   'x',
   'f',
   0, // glIndexf
   'g',
   'l',
   'I',
   'n',
   'd',
   'e',
   'x',
   'f',
   'v',
   0, // glIndexfv
   'g',
   'l',
   'I',
   'n',
   'd',
   'e',
   'x',
   'i',
   0, // glIndexi
   'g',
   'l',
   'I',
   'n',
   'd',
   'e',
   'x',
   'i',
   'v',
   0, // glIndexiv
   'g',
   'l',
   'I',
   'n',
   'd',
   'e',
   'x',
   's',
   0, // glIndexs
   'g',
   'l',
   'I',
   'n',
   'd',
   'e',
   'x',
   's',
   'v',
   0, // glIndexsv
   'g',
   'l',
   'I',
   'n',
   'd',
   'e',
   'x',
   'u',
   'b',
   0, // glIndexub
   'g',
   'l',
   'I',
   'n',
   'd',
   'e',
   'x',
   'u',
   'b',
   'v',
   0, // glIndexubv
   'g',
   'l',
   'I',
   'n',
   'd',
   'e',
   'x',
   'x',
   'O',
   'E',
   'S',
   0, // glIndexxOES
   'g',
   'l',
   'I',
   'n',
   'd',
   'e',
   'x',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glIndexxvOES
   'g',
   'l',
   'I',
   'n',
   'i',
   't',
   'N',
   'a',
   'm',
   'e',
   's',
   0, // glInitNames
   'g',
   'l',
   'I',
   'n',
   's',
   'e',
   'r',
   't',
   'C',
   'o',
   'm',
   'p',
   'o',
   'n',
   'e',
   'n',
   't',
   'E',
   'X',
   'T',
   0, // glInsertComponentEXT
   'g',
   'l',
   'I',
   'n',
   's',
   'e',
   'r',
   't',
   'E',
   'v',
   'e',
   'n',
   't',
   'M',
   'a',
   'r',
   'k',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glInsertEventMarkerEXT
   'g',
   'l',
   'I',
   'n',
   's',
   't',
   'r',
   'u',
   'm',
   'e',
   'n',
   't',
   's',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'G',
   'I',
   'X',
   0, // glInstrumentsBufferSGIX
   'g',
   'l',
   'I',
   'n',
   't',
   'e',
   'r',
   'l',
   'e',
   'a',
   'v',
   'e',
   'd',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   0, // glInterleavedArrays
   'g',
   'l',
   'I',
   'n',
   't',
   'e',
   'r',
   'p',
   'o',
   'l',
   'a',
   't',
   'e',
   'P',
   'a',
   't',
   'h',
   's',
   'N',
   'V',
   0, // glInterpolatePathsNV
   'g',
   'l',
   'I',
   'n',
   'v',
   'a',
   'l',
   'i',
   'd',
   'a',
   't',
   'e',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'D',
   'a',
   't',
   'a',
   0, // glInvalidateBufferData
   'g',
   'l',
   'I',
   'n',
   'v',
   'a',
   'l',
   'i',
   'd',
   'a',
   't',
   'e',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   0, // glInvalidateBufferSubData
   'g',
   'l',
   'I',
   'n',
   'v',
   'a',
   'l',
   'i',
   'd',
   'a',
   't',
   'e',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glInvalidateFramebuffer
   'g',
   'l',
   'I',
   'n',
   'v',
   'a',
   'l',
   'i',
   'd',
   'a',
   't',
   'e',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'D',
   'a',
   't',
   'a',
   0, // glInvalidateNamedFramebufferData
   'g',
   'l',
   'I',
   'n',
   'v',
   'a',
   'l',
   'i',
   'd',
   'a',
   't',
   'e',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   0, // glInvalidateNamedFramebufferSubData
   'g',
   'l',
   'I',
   'n',
   'v',
   'a',
   'l',
   'i',
   'd',
   'a',
   't',
   'e',
   'S',
   'u',
   'b',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glInvalidateSubFramebuffer
   'g',
   'l',
   'I',
   'n',
   'v',
   'a',
   'l',
   'i',
   'd',
   'a',
   't',
   'e',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   0, // glInvalidateTexImage
   'g',
   'l',
   'I',
   'n',
   'v',
   'a',
   'l',
   'i',
   'd',
   'a',
   't',
   'e',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   0, // glInvalidateTexSubImage
   'g',
   'l',
   'I',
   's',
   'A',
   's',
   'y',
   'n',
   'c',
   'M',
   'a',
   'r',
   'k',
   'e',
   'r',
   'S',
   'G',
   'I',
   'X',
   0, // glIsAsyncMarkerSGIX
   'g',
   'l',
   'I',
   's',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glIsBuffer
   'g',
   'l',
   'I',
   's',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'A',
   'R',
   'B',
   0, // glIsBufferARB
   'g',
   'l',
   'I',
   's',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'e',
   's',
   'i',
   'd',
   'e',
   'n',
   't',
   'N',
   'V',
   0, // glIsBufferResidentNV
   'g',
   'l',
   'I',
   's',
   'C',
   'o',
   'm',
   'm',
   'a',
   'n',
   'd',
   'L',
   'i',
   's',
   't',
   'N',
   'V',
   0, // glIsCommandListNV
   'g',
   'l',
   'I',
   's',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'd',
   0, // glIsEnabled
   'g',
   'l',
   'I',
   's',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'd',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'E',
   'X',
   'T',
   0, // glIsEnabledIndexedEXT
   'g',
   'l',
   'I',
   's',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'd',
   'i',
   0, // glIsEnabledi
   'g',
   'l',
   'I',
   's',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'd',
   'i',
   'E',
   'X',
   'T',
   0, // glIsEnablediEXT
   'g',
   'l',
   'I',
   's',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'd',
   'i',
   'N',
   'V',
   0, // glIsEnablediNV
   'g',
   'l',
   'I',
   's',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'd',
   'i',
   'O',
   'E',
   'S',
   0, // glIsEnablediOES
   'g',
   'l',
   'I',
   's',
   'F',
   'e',
   'n',
   'c',
   'e',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glIsFenceAPPLE
   'g',
   'l',
   'I',
   's',
   'F',
   'e',
   'n',
   'c',
   'e',
   'N',
   'V',
   0, // glIsFenceNV
   'g',
   'l',
   'I',
   's',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glIsFramebuffer
   'g',
   'l',
   'I',
   's',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glIsFramebufferEXT
   'g',
   'l',
   'I',
   's',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'O',
   'E',
   'S',
   0, // glIsFramebufferOES
   'g',
   'l',
   'I',
   's',
   'I',
   'm',
   'a',
   'g',
   'e',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'R',
   'e',
   's',
   'i',
   'd',
   'e',
   'n',
   't',
   'A',
   'R',
   'B',
   0, // glIsImageHandleResidentARB
   'g',
   'l',
   'I',
   's',
   'I',
   'm',
   'a',
   'g',
   'e',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'R',
   'e',
   's',
   'i',
   'd',
   'e',
   'n',
   't',
   'N',
   'V',
   0, // glIsImageHandleResidentNV
   'g',
   'l',
   'I',
   's',
   'L',
   'i',
   's',
   't',
   0, // glIsList
   'g',
   'l',
   'I',
   's',
   'M',
   'e',
   'm',
   'o',
   'r',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'E',
   'X',
   'T',
   0, // glIsMemoryObjectEXT
   'g',
   'l',
   'I',
   's',
   'N',
   'a',
   'm',
   'e',
   'A',
   'M',
   'D',
   0, // glIsNameAMD
   'g',
   'l',
   'I',
   's',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'e',
   's',
   'i',
   'd',
   'e',
   'n',
   't',
   'N',
   'V',
   0, // glIsNamedBufferResidentNV
   'g',
   'l',
   'I',
   's',
   'N',
   'a',
   'm',
   'e',
   'd',
   'S',
   't',
   'r',
   'i',
   'n',
   'g',
   'A',
   'R',
   'B',
   0, // glIsNamedStringARB
   'g',
   'l',
   'I',
   's',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'A',
   'T',
   'I',
   0, // glIsObjectBufferATI
   'g',
   'l',
   'I',
   's',
   'O',
   'c',
   'c',
   'l',
   'u',
   's',
   'i',
   'o',
   'n',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'N',
   'V',
   0, // glIsOcclusionQueryNV
   'g',
   'l',
   'I',
   's',
   'P',
   'a',
   't',
   'h',
   'N',
   'V',
   0, // glIsPathNV
   'g',
   'l',
   'I',
   's',
   'P',
   'o',
   'i',
   'n',
   't',
   'I',
   'n',
   'F',
   'i',
   'l',
   'l',
   'P',
   'a',
   't',
   'h',
   'N',
   'V',
   0, // glIsPointInFillPathNV
   'g',
   'l',
   'I',
   's',
   'P',
   'o',
   'i',
   'n',
   't',
   'I',
   'n',
   'S',
   't',
   'r',
   'o',
   'k',
   'e',
   'P',
   'a',
   't',
   'h',
   'N',
   'V',
   0, // glIsPointInStrokePathNV
   'g',
   'l',
   'I',
   's',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   0, // glIsProgram
   'g',
   'l',
   'I',
   's',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'A',
   'R',
   'B',
   0, // glIsProgramARB
   'g',
   'l',
   'I',
   's',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'N',
   'V',
   0, // glIsProgramNV
   'g',
   'l',
   'I',
   's',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'i',
   'p',
   'e',
   'l',
   'i',
   'n',
   'e',
   0, // glIsProgramPipeline
   'g',
   'l',
   'I',
   's',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'i',
   'p',
   'e',
   'l',
   'i',
   'n',
   'e',
   'E',
   'X',
   'T',
   0, // glIsProgramPipelineEXT
   'g',
   'l',
   'I',
   's',
   'Q',
   'u',
   'e',
   'r',
   'y',
   0, // glIsQuery
   'g',
   'l',
   'I',
   's',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'A',
   'R',
   'B',
   0, // glIsQueryARB
   'g',
   'l',
   'I',
   's',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'E',
   'X',
   'T',
   0, // glIsQueryEXT
   'g',
   'l',
   'I',
   's',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glIsRenderbuffer
   'g',
   'l',
   'I',
   's',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glIsRenderbufferEXT
   'g',
   'l',
   'I',
   's',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'O',
   'E',
   'S',
   0, // glIsRenderbufferOES
   'g',
   'l',
   'I',
   's',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   0, // glIsSampler
   'g',
   'l',
   'I',
   's',
   'S',
   'e',
   'm',
   'a',
   'p',
   'h',
   'o',
   'r',
   'e',
   'E',
   'X',
   'T',
   0, // glIsSemaphoreEXT
   'g',
   'l',
   'I',
   's',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   0, // glIsShader
   'g',
   'l',
   'I',
   's',
   'S',
   't',
   'a',
   't',
   'e',
   'N',
   'V',
   0, // glIsStateNV
   'g',
   'l',
   'I',
   's',
   'S',
   'y',
   'n',
   'c',
   0, // glIsSync
   'g',
   'l',
   'I',
   's',
   'S',
   'y',
   'n',
   'c',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glIsSyncAPPLE
   'g',
   'l',
   'I',
   's',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   0, // glIsTexture
   'g',
   'l',
   'I',
   's',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'E',
   'X',
   'T',
   0, // glIsTextureEXT
   'g',
   'l',
   'I',
   's',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'R',
   'e',
   's',
   'i',
   'd',
   'e',
   'n',
   't',
   'A',
   'R',
   'B',
   0, // glIsTextureHandleResidentARB
   'g',
   'l',
   'I',
   's',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'R',
   'e',
   's',
   'i',
   'd',
   'e',
   'n',
   't',
   'N',
   'V',
   0, // glIsTextureHandleResidentNV
   'g',
   'l',
   'I',
   's',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   0, // glIsTransformFeedback
   'g',
   'l',
   'I',
   's',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'N',
   'V',
   0, // glIsTransformFeedbackNV
   'g',
   'l',
   'I',
   's',
   'V',
   'a',
   'r',
   'i',
   'a',
   'n',
   't',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'd',
   'E',
   'X',
   'T',
   0, // glIsVariantEnabledEXT
   'g',
   'l',
   'I',
   's',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   0, // glIsVertexArray
   'g',
   'l',
   'I',
   's',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glIsVertexArrayAPPLE
   'g',
   'l',
   'I',
   's',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'O',
   'E',
   'S',
   0, // glIsVertexArrayOES
   'g',
   'l',
   'I',
   's',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'E',
   'n',
   'a',
   'b',
   'l',
   'e',
   'd',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glIsVertexAttribEnabledAPPLE
   'g',
   'l',
   'L',
   'G',
   'P',
   'U',
   'C',
   'o',
   'p',
   'y',
   'I',
   'm',
   'a',
   'g',
   'e',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   'N',
   'V',
   'X',
   0, // glLGPUCopyImageSubDataNVX
   'g',
   'l',
   'L',
   'G',
   'P',
   'U',
   'I',
   'n',
   't',
   'e',
   'r',
   'l',
   'o',
   'c',
   'k',
   'N',
   'V',
   'X',
   0, // glLGPUInterlockNVX
   'g',
   'l',
   'L',
   'G',
   'P',
   'U',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   'N',
   'V',
   'X',
   0, // glLGPUNamedBufferSubDataNVX
   'g',
   'l',
   'L',
   'a',
   'b',
   'e',
   'l',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'E',
   'X',
   'T',
   0, // glLabelObjectEXT
   'g',
   'l',
   'L',
   'i',
   'g',
   'h',
   't',
   'E',
   'n',
   'v',
   'i',
   'S',
   'G',
   'I',
   'X',
   0, // glLightEnviSGIX
   'g',
   'l',
   'L',
   'i',
   'g',
   'h',
   't',
   'M',
   'o',
   'd',
   'e',
   'l',
   'f',
   0, // glLightModelf
   'g',
   'l',
   'L',
   'i',
   'g',
   'h',
   't',
   'M',
   'o',
   'd',
   'e',
   'l',
   'f',
   'v',
   0, // glLightModelfv
   'g',
   'l',
   'L',
   'i',
   'g',
   'h',
   't',
   'M',
   'o',
   'd',
   'e',
   'l',
   'i',
   0, // glLightModeli
   'g',
   'l',
   'L',
   'i',
   'g',
   'h',
   't',
   'M',
   'o',
   'd',
   'e',
   'l',
   'i',
   'v',
   0, // glLightModeliv
   'g',
   'l',
   'L',
   'i',
   'g',
   'h',
   't',
   'M',
   'o',
   'd',
   'e',
   'l',
   'x',
   0, // glLightModelx
   'g',
   'l',
   'L',
   'i',
   'g',
   'h',
   't',
   'M',
   'o',
   'd',
   'e',
   'l',
   'x',
   'O',
   'E',
   'S',
   0, // glLightModelxOES
   'g',
   'l',
   'L',
   'i',
   'g',
   'h',
   't',
   'M',
   'o',
   'd',
   'e',
   'l',
   'x',
   'v',
   0, // glLightModelxv
   'g',
   'l',
   'L',
   'i',
   'g',
   'h',
   't',
   'M',
   'o',
   'd',
   'e',
   'l',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glLightModelxvOES
   'g',
   'l',
   'L',
   'i',
   'g',
   'h',
   't',
   'f',
   0, // glLightf
   'g',
   'l',
   'L',
   'i',
   'g',
   'h',
   't',
   'f',
   'v',
   0, // glLightfv
   'g',
   'l',
   'L',
   'i',
   'g',
   'h',
   't',
   'i',
   0, // glLighti
   'g',
   'l',
   'L',
   'i',
   'g',
   'h',
   't',
   'i',
   'v',
   0, // glLightiv
   'g',
   'l',
   'L',
   'i',
   'g',
   'h',
   't',
   'x',
   0, // glLightx
   'g',
   'l',
   'L',
   'i',
   'g',
   'h',
   't',
   'x',
   'O',
   'E',
   'S',
   0, // glLightxOES
   'g',
   'l',
   'L',
   'i',
   'g',
   'h',
   't',
   'x',
   'v',
   0, // glLightxv
   'g',
   'l',
   'L',
   'i',
   'g',
   'h',
   't',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glLightxvOES
   'g',
   'l',
   'L',
   'i',
   'n',
   'e',
   'S',
   't',
   'i',
   'p',
   'p',
   'l',
   'e',
   0, // glLineStipple
   'g',
   'l',
   'L',
   'i',
   'n',
   'e',
   'W',
   'i',
   'd',
   't',
   'h',
   0, // glLineWidth
   'g',
   'l',
   'L',
   'i',
   'n',
   'e',
   'W',
   'i',
   'd',
   't',
   'h',
   'x',
   0, // glLineWidthx
   'g',
   'l',
   'L',
   'i',
   'n',
   'e',
   'W',
   'i',
   'd',
   't',
   'h',
   'x',
   'O',
   'E',
   'S',
   0, // glLineWidthxOES
   'g',
   'l',
   'L',
   'i',
   'n',
   'k',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   0, // glLinkProgram
   'g',
   'l',
   'L',
   'i',
   'n',
   'k',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'A',
   'R',
   'B',
   0, // glLinkProgramARB
   'g',
   'l',
   'L',
   'i',
   's',
   't',
   'B',
   'a',
   's',
   'e',
   0, // glListBase
   'g',
   'l',
   'L',
   'i',
   's',
   't',
   'D',
   'r',
   'a',
   'w',
   'C',
   'o',
   'm',
   'm',
   'a',
   'n',
   'd',
   's',
   'S',
   't',
   'a',
   't',
   'e',
   's',
   'C',
   'l',
   'i',
   'e',
   'n',
   't',
   'N',
   'V',
   0, // glListDrawCommandsStatesClientNV
   'g',
   'l',
   'L',
   'i',
   's',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'S',
   'G',
   'I',
   'X',
   0, // glListParameterfSGIX
   'g',
   'l',
   'L',
   'i',
   's',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'S',
   'G',
   'I',
   'X',
   0, // glListParameterfvSGIX
   'g',
   'l',
   'L',
   'i',
   's',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'S',
   'G',
   'I',
   'X',
   0, // glListParameteriSGIX
   'g',
   'l',
   'L',
   'i',
   's',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'S',
   'G',
   'I',
   'X',
   0, // glListParameterivSGIX
   'g',
   'l',
   'L',
   'o',
   'a',
   'd',
   'I',
   'd',
   'e',
   'n',
   't',
   'i',
   't',
   'y',
   0, // glLoadIdentity
   'g',
   'l',
   'L',
   'o',
   'a',
   'd',
   'I',
   'd',
   'e',
   'n',
   't',
   'i',
   't',
   'y',
   'D',
   'e',
   'f',
   'o',
   'r',
   'm',
   'a',
   't',
   'i',
   'o',
   'n',
   'M',
   'a',
   'p',
   'S',
   'G',
   'I',
   'X',
   0, // glLoadIdentityDeformationMapSGIX
   'g',
   'l',
   'L',
   'o',
   'a',
   'd',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'd',
   0, // glLoadMatrixd
   'g',
   'l',
   'L',
   'o',
   'a',
   'd',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'f',
   0, // glLoadMatrixf
   'g',
   'l',
   'L',
   'o',
   'a',
   'd',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'x',
   0, // glLoadMatrixx
   'g',
   'l',
   'L',
   'o',
   'a',
   'd',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'x',
   'O',
   'E',
   'S',
   0, // glLoadMatrixxOES
   'g',
   'l',
   'L',
   'o',
   'a',
   'd',
   'N',
   'a',
   'm',
   'e',
   0, // glLoadName
   'g',
   'l',
   'L',
   'o',
   'a',
   'd',
   'P',
   'a',
   'l',
   'e',
   't',
   't',
   'e',
   'F',
   'r',
   'o',
   'm',
   'M',
   'o',
   'd',
   'e',
   'l',
   'V',
   'i',
   'e',
   'w',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'O',
   'E',
   'S',
   0, // glLoadPaletteFromModelViewMatrixOES
   'g',
   'l',
   'L',
   'o',
   'a',
   'd',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'N',
   'V',
   0, // glLoadProgramNV
   'g',
   'l',
   'L',
   'o',
   'a',
   'd',
   'T',
   'r',
   'a',
   'n',
   's',
   'p',
   'o',
   's',
   'e',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'd',
   0, // glLoadTransposeMatrixd
   'g',
   'l',
   'L',
   'o',
   'a',
   'd',
   'T',
   'r',
   'a',
   'n',
   's',
   'p',
   'o',
   's',
   'e',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'd',
   'A',
   'R',
   'B',
   0, // glLoadTransposeMatrixdARB
   'g',
   'l',
   'L',
   'o',
   'a',
   'd',
   'T',
   'r',
   'a',
   'n',
   's',
   'p',
   'o',
   's',
   'e',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'f',
   0, // glLoadTransposeMatrixf
   'g',
   'l',
   'L',
   'o',
   'a',
   'd',
   'T',
   'r',
   'a',
   'n',
   's',
   'p',
   'o',
   's',
   'e',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'f',
   'A',
   'R',
   'B',
   0, // glLoadTransposeMatrixfARB
   'g',
   'l',
   'L',
   'o',
   'a',
   'd',
   'T',
   'r',
   'a',
   'n',
   's',
   'p',
   'o',
   's',
   'e',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'x',
   'O',
   'E',
   'S',
   0, // glLoadTransposeMatrixxOES
   'g',
   'l',
   'L',
   'o',
   'c',
   'k',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'E',
   'X',
   'T',
   0, // glLockArraysEXT
   'g',
   'l',
   'L',
   'o',
   'g',
   'i',
   'c',
   'O',
   'p',
   0, // glLogicOp
   'g',
   'l',
   'M',
   'a',
   'k',
   'e',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'N',
   'o',
   'n',
   'R',
   'e',
   's',
   'i',
   'd',
   'e',
   'n',
   't',
   'N',
   'V',
   0, // glMakeBufferNonResidentNV
   'g',
   'l',
   'M',
   'a',
   'k',
   'e',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'e',
   's',
   'i',
   'd',
   'e',
   'n',
   't',
   'N',
   'V',
   0, // glMakeBufferResidentNV
   'g',
   'l',
   'M',
   'a',
   'k',
   'e',
   'I',
   'm',
   'a',
   'g',
   'e',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'N',
   'o',
   'n',
   'R',
   'e',
   's',
   'i',
   'd',
   'e',
   'n',
   't',
   'A',
   'R',
   'B',
   0, // glMakeImageHandleNonResidentARB
   'g',
   'l',
   'M',
   'a',
   'k',
   'e',
   'I',
   'm',
   'a',
   'g',
   'e',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'N',
   'o',
   'n',
   'R',
   'e',
   's',
   'i',
   'd',
   'e',
   'n',
   't',
   'N',
   'V',
   0, // glMakeImageHandleNonResidentNV
   'g',
   'l',
   'M',
   'a',
   'k',
   'e',
   'I',
   'm',
   'a',
   'g',
   'e',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'R',
   'e',
   's',
   'i',
   'd',
   'e',
   'n',
   't',
   'A',
   'R',
   'B',
   0, // glMakeImageHandleResidentARB
   'g',
   'l',
   'M',
   'a',
   'k',
   'e',
   'I',
   'm',
   'a',
   'g',
   'e',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'R',
   'e',
   's',
   'i',
   'd',
   'e',
   'n',
   't',
   'N',
   'V',
   0, // glMakeImageHandleResidentNV
   'g',
   'l',
   'M',
   'a',
   'k',
   'e',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'N',
   'o',
   'n',
   'R',
   'e',
   's',
   'i',
   'd',
   'e',
   'n',
   't',
   'N',
   'V',
   0, // glMakeNamedBufferNonResidentNV
   'g',
   'l',
   'M',
   'a',
   'k',
   'e',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'e',
   's',
   'i',
   'd',
   'e',
   'n',
   't',
   'N',
   'V',
   0, // glMakeNamedBufferResidentNV
   'g',
   'l',
   'M',
   'a',
   'k',
   'e',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'N',
   'o',
   'n',
   'R',
   'e',
   's',
   'i',
   'd',
   'e',
   'n',
   't',
   'A',
   'R',
   'B',
   0, // glMakeTextureHandleNonResidentARB
   'g',
   'l',
   'M',
   'a',
   'k',
   'e',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'N',
   'o',
   'n',
   'R',
   'e',
   's',
   'i',
   'd',
   'e',
   'n',
   't',
   'N',
   'V',
   0, // glMakeTextureHandleNonResidentNV
   'g',
   'l',
   'M',
   'a',
   'k',
   'e',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'R',
   'e',
   's',
   'i',
   'd',
   'e',
   'n',
   't',
   'A',
   'R',
   'B',
   0, // glMakeTextureHandleResidentARB
   'g',
   'l',
   'M',
   'a',
   'k',
   'e',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'R',
   'e',
   's',
   'i',
   'd',
   'e',
   'n',
   't',
   'N',
   'V',
   0, // glMakeTextureHandleResidentNV
   'g',
   'l',
   'M',
   'a',
   'p',
   '1',
   'd',
   0, // glMap1d
   'g',
   'l',
   'M',
   'a',
   'p',
   '1',
   'f',
   0, // glMap1f
   'g',
   'l',
   'M',
   'a',
   'p',
   '1',
   'x',
   'O',
   'E',
   'S',
   0, // glMap1xOES
   'g',
   'l',
   'M',
   'a',
   'p',
   '2',
   'd',
   0, // glMap2d
   'g',
   'l',
   'M',
   'a',
   'p',
   '2',
   'f',
   0, // glMap2f
   'g',
   'l',
   'M',
   'a',
   'p',
   '2',
   'x',
   'O',
   'E',
   'S',
   0, // glMap2xOES
   'g',
   'l',
   'M',
   'a',
   'p',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glMapBuffer
   'g',
   'l',
   'M',
   'a',
   'p',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'A',
   'R',
   'B',
   0, // glMapBufferARB
   'g',
   'l',
   'M',
   'a',
   'p',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'O',
   'E',
   'S',
   0, // glMapBufferOES
   'g',
   'l',
   'M',
   'a',
   'p',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'a',
   'n',
   'g',
   'e',
   0, // glMapBufferRange
   'g',
   'l',
   'M',
   'a',
   'p',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'a',
   'n',
   'g',
   'e',
   'E',
   'X',
   'T',
   0, // glMapBufferRangeEXT
   'g',
   'l',
   'M',
   'a',
   'p',
   'C',
   'o',
   'n',
   't',
   'r',
   'o',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   's',
   'N',
   'V',
   0, // glMapControlPointsNV
   'g',
   'l',
   'M',
   'a',
   'p',
   'G',
   'r',
   'i',
   'd',
   '1',
   'd',
   0, // glMapGrid1d
   'g',
   'l',
   'M',
   'a',
   'p',
   'G',
   'r',
   'i',
   'd',
   '1',
   'f',
   0, // glMapGrid1f
   'g',
   'l',
   'M',
   'a',
   'p',
   'G',
   'r',
   'i',
   'd',
   '1',
   'x',
   'O',
   'E',
   'S',
   0, // glMapGrid1xOES
   'g',
   'l',
   'M',
   'a',
   'p',
   'G',
   'r',
   'i',
   'd',
   '2',
   'd',
   0, // glMapGrid2d
   'g',
   'l',
   'M',
   'a',
   'p',
   'G',
   'r',
   'i',
   'd',
   '2',
   'f',
   0, // glMapGrid2f
   'g',
   'l',
   'M',
   'a',
   'p',
   'G',
   'r',
   'i',
   'd',
   '2',
   'x',
   'O',
   'E',
   'S',
   0, // glMapGrid2xOES
   'g',
   'l',
   'M',
   'a',
   'p',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glMapNamedBuffer
   'g',
   'l',
   'M',
   'a',
   'p',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glMapNamedBufferEXT
   'g',
   'l',
   'M',
   'a',
   'p',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'a',
   'n',
   'g',
   'e',
   0, // glMapNamedBufferRange
   'g',
   'l',
   'M',
   'a',
   'p',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'a',
   'n',
   'g',
   'e',
   'E',
   'X',
   'T',
   0, // glMapNamedBufferRangeEXT
   'g',
   'l',
   'M',
   'a',
   'p',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'A',
   'T',
   'I',
   0, // glMapObjectBufferATI
   'g',
   'l',
   'M',
   'a',
   'p',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'N',
   'V',
   0, // glMapParameterfvNV
   'g',
   'l',
   'M',
   'a',
   'p',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'N',
   'V',
   0, // glMapParameterivNV
   'g',
   'l',
   'M',
   'a',
   'p',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   '2',
   'D',
   'I',
   'N',
   'T',
   'E',
   'L',
   0, // glMapTexture2DINTEL
   'g',
   'l',
   'M',
   'a',
   'p',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '1',
   'd',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glMapVertexAttrib1dAPPLE
   'g',
   'l',
   'M',
   'a',
   'p',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '1',
   'f',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glMapVertexAttrib1fAPPLE
   'g',
   'l',
   'M',
   'a',
   'p',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '2',
   'd',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glMapVertexAttrib2dAPPLE
   'g',
   'l',
   'M',
   'a',
   'p',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '2',
   'f',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glMapVertexAttrib2fAPPLE
   'g',
   'l',
   'M',
   'a',
   't',
   'e',
   'r',
   'i',
   'a',
   'l',
   'f',
   0, // glMaterialf
   'g',
   'l',
   'M',
   'a',
   't',
   'e',
   'r',
   'i',
   'a',
   'l',
   'f',
   'v',
   0, // glMaterialfv
   'g',
   'l',
   'M',
   'a',
   't',
   'e',
   'r',
   'i',
   'a',
   'l',
   'i',
   0, // glMateriali
   'g',
   'l',
   'M',
   'a',
   't',
   'e',
   'r',
   'i',
   'a',
   'l',
   'i',
   'v',
   0, // glMaterialiv
   'g',
   'l',
   'M',
   'a',
   't',
   'e',
   'r',
   'i',
   'a',
   'l',
   'x',
   0, // glMaterialx
   'g',
   'l',
   'M',
   'a',
   't',
   'e',
   'r',
   'i',
   'a',
   'l',
   'x',
   'O',
   'E',
   'S',
   0, // glMaterialxOES
   'g',
   'l',
   'M',
   'a',
   't',
   'e',
   'r',
   'i',
   'a',
   'l',
   'x',
   'v',
   0, // glMaterialxv
   'g',
   'l',
   'M',
   'a',
   't',
   'e',
   'r',
   'i',
   'a',
   'l',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glMaterialxvOES
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'F',
   'r',
   'u',
   's',
   't',
   'u',
   'm',
   'E',
   'X',
   'T',
   0, // glMatrixFrustumEXT
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'I',
   'n',
   'd',
   'e',
   'x',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'A',
   'R',
   'B',
   0, // glMatrixIndexPointerARB
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'I',
   'n',
   'd',
   'e',
   'x',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'O',
   'E',
   'S',
   0, // glMatrixIndexPointerOES
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'I',
   'n',
   'd',
   'e',
   'x',
   'u',
   'b',
   'v',
   'A',
   'R',
   'B',
   0, // glMatrixIndexubvARB
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'I',
   'n',
   'd',
   'e',
   'x',
   'u',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glMatrixIndexuivARB
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'I',
   'n',
   'd',
   'e',
   'x',
   'u',
   's',
   'v',
   'A',
   'R',
   'B',
   0, // glMatrixIndexusvARB
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'L',
   'o',
   'a',
   'd',
   '3',
   'x',
   '2',
   'f',
   'N',
   'V',
   0, // glMatrixLoad3x2fNV
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'L',
   'o',
   'a',
   'd',
   '3',
   'x',
   '3',
   'f',
   'N',
   'V',
   0, // glMatrixLoad3x3fNV
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'L',
   'o',
   'a',
   'd',
   'I',
   'd',
   'e',
   'n',
   't',
   'i',
   't',
   'y',
   'E',
   'X',
   'T',
   0, // glMatrixLoadIdentityEXT
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'L',
   'o',
   'a',
   'd',
   'T',
   'r',
   'a',
   'n',
   's',
   'p',
   'o',
   's',
   'e',
   '3',
   'x',
   '3',
   'f',
   'N',
   'V',
   0, // glMatrixLoadTranspose3x3fNV
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'L',
   'o',
   'a',
   'd',
   'T',
   'r',
   'a',
   'n',
   's',
   'p',
   'o',
   's',
   'e',
   'd',
   'E',
   'X',
   'T',
   0, // glMatrixLoadTransposedEXT
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'L',
   'o',
   'a',
   'd',
   'T',
   'r',
   'a',
   'n',
   's',
   'p',
   'o',
   's',
   'e',
   'f',
   'E',
   'X',
   'T',
   0, // glMatrixLoadTransposefEXT
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'L',
   'o',
   'a',
   'd',
   'd',
   'E',
   'X',
   'T',
   0, // glMatrixLoaddEXT
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'L',
   'o',
   'a',
   'd',
   'f',
   'E',
   'X',
   'T',
   0, // glMatrixLoadfEXT
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'M',
   'o',
   'd',
   'e',
   0, // glMatrixMode
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'M',
   'u',
   'l',
   't',
   '3',
   'x',
   '2',
   'f',
   'N',
   'V',
   0, // glMatrixMult3x2fNV
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'M',
   'u',
   'l',
   't',
   '3',
   'x',
   '3',
   'f',
   'N',
   'V',
   0, // glMatrixMult3x3fNV
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'M',
   'u',
   'l',
   't',
   'T',
   'r',
   'a',
   'n',
   's',
   'p',
   'o',
   's',
   'e',
   '3',
   'x',
   '3',
   'f',
   'N',
   'V',
   0, // glMatrixMultTranspose3x3fNV
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'M',
   'u',
   'l',
   't',
   'T',
   'r',
   'a',
   'n',
   's',
   'p',
   'o',
   's',
   'e',
   'd',
   'E',
   'X',
   'T',
   0, // glMatrixMultTransposedEXT
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'M',
   'u',
   'l',
   't',
   'T',
   'r',
   'a',
   'n',
   's',
   'p',
   'o',
   's',
   'e',
   'f',
   'E',
   'X',
   'T',
   0, // glMatrixMultTransposefEXT
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'M',
   'u',
   'l',
   't',
   'd',
   'E',
   'X',
   'T',
   0, // glMatrixMultdEXT
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'M',
   'u',
   'l',
   't',
   'f',
   'E',
   'X',
   'T',
   0, // glMatrixMultfEXT
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'O',
   'r',
   't',
   'h',
   'o',
   'E',
   'X',
   'T',
   0, // glMatrixOrthoEXT
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'P',
   'o',
   'p',
   'E',
   'X',
   'T',
   0, // glMatrixPopEXT
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'P',
   'u',
   's',
   'h',
   'E',
   'X',
   'T',
   0, // glMatrixPushEXT
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'R',
   'o',
   't',
   'a',
   't',
   'e',
   'd',
   'E',
   'X',
   'T',
   0, // glMatrixRotatedEXT
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'R',
   'o',
   't',
   'a',
   't',
   'e',
   'f',
   'E',
   'X',
   'T',
   0, // glMatrixRotatefEXT
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'S',
   'c',
   'a',
   'l',
   'e',
   'd',
   'E',
   'X',
   'T',
   0, // glMatrixScaledEXT
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'S',
   'c',
   'a',
   'l',
   'e',
   'f',
   'E',
   'X',
   'T',
   0, // glMatrixScalefEXT
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'T',
   'r',
   'a',
   'n',
   's',
   'l',
   'a',
   't',
   'e',
   'd',
   'E',
   'X',
   'T',
   0, // glMatrixTranslatedEXT
   'g',
   'l',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'T',
   'r',
   'a',
   'n',
   's',
   'l',
   'a',
   't',
   'e',
   'f',
   'E',
   'X',
   'T',
   0, // glMatrixTranslatefEXT
   'g',
   'l',
   'M',
   'a',
   'x',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'C',
   'o',
   'm',
   'p',
   'i',
   'l',
   'e',
   'r',
   'T',
   'h',
   'r',
   'e',
   'a',
   'd',
   's',
   'A',
   'R',
   'B',
   0, // glMaxShaderCompilerThreadsARB
   'g',
   'l',
   'M',
   'a',
   'x',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'C',
   'o',
   'm',
   'p',
   'i',
   'l',
   'e',
   'r',
   'T',
   'h',
   'r',
   'e',
   'a',
   'd',
   's',
   'K',
   'H',
   'R',
   0, // glMaxShaderCompilerThreadsKHR
   'g',
   'l',
   'M',
   'e',
   'm',
   'o',
   'r',
   'y',
   'B',
   'a',
   'r',
   'r',
   'i',
   'e',
   'r',
   0, // glMemoryBarrier
   'g',
   'l',
   'M',
   'e',
   'm',
   'o',
   'r',
   'y',
   'B',
   'a',
   'r',
   'r',
   'i',
   'e',
   'r',
   'B',
   'y',
   'R',
   'e',
   'g',
   'i',
   'o',
   'n',
   0, // glMemoryBarrierByRegion
   'g',
   'l',
   'M',
   'e',
   'm',
   'o',
   'r',
   'y',
   'B',
   'a',
   'r',
   'r',
   'i',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glMemoryBarrierEXT
   'g',
   'l',
   'M',
   'e',
   'm',
   'o',
   'r',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glMemoryObjectParameterivEXT
   'g',
   'l',
   'M',
   'i',
   'n',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'S',
   'h',
   'a',
   'd',
   'i',
   'n',
   'g',
   0, // glMinSampleShading
   'g',
   'l',
   'M',
   'i',
   'n',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'S',
   'h',
   'a',
   'd',
   'i',
   'n',
   'g',
   'A',
   'R',
   'B',
   0, // glMinSampleShadingARB
   'g',
   'l',
   'M',
   'i',
   'n',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'S',
   'h',
   'a',
   'd',
   'i',
   'n',
   'g',
   'O',
   'E',
   'S',
   0, // glMinSampleShadingOES
   'g',
   'l',
   'M',
   'i',
   'n',
   'm',
   'a',
   'x',
   0, // glMinmax
   'g',
   'l',
   'M',
   'i',
   'n',
   'm',
   'a',
   'x',
   'E',
   'X',
   'T',
   0, // glMinmaxEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'd',
   0, // glMultMatrixd
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'f',
   0, // glMultMatrixf
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'x',
   0, // glMultMatrixx
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'x',
   'O',
   'E',
   'S',
   0, // glMultMatrixxOES
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'T',
   'r',
   'a',
   'n',
   's',
   'p',
   'o',
   's',
   'e',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'd',
   0, // glMultTransposeMatrixd
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'T',
   'r',
   'a',
   'n',
   's',
   'p',
   'o',
   's',
   'e',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'd',
   'A',
   'R',
   'B',
   0, // glMultTransposeMatrixdARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'T',
   'r',
   'a',
   'n',
   's',
   'p',
   'o',
   's',
   'e',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'f',
   0, // glMultTransposeMatrixf
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'T',
   'r',
   'a',
   'n',
   's',
   'p',
   'o',
   's',
   'e',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'f',
   'A',
   'R',
   'B',
   0, // glMultTransposeMatrixfARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'T',
   'r',
   'a',
   'n',
   's',
   'p',
   'o',
   's',
   'e',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'x',
   'O',
   'E',
   'S',
   0, // glMultTransposeMatrixxOES
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'D',
   'r',
   'a',
   'w',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   0, // glMultiDrawArrays
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'D',
   'r',
   'a',
   'w',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'E',
   'X',
   'T',
   0, // glMultiDrawArraysEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'D',
   'r',
   'a',
   'w',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'I',
   'n',
   'd',
   'i',
   'r',
   'e',
   'c',
   't',
   0, // glMultiDrawArraysIndirect
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'D',
   'r',
   'a',
   'w',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'I',
   'n',
   'd',
   'i',
   'r',
   'e',
   'c',
   't',
   'A',
   'M',
   'D',
   0, // glMultiDrawArraysIndirectAMD
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'D',
   'r',
   'a',
   'w',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'I',
   'n',
   'd',
   'i',
   'r',
   'e',
   'c',
   't',
   'B',
   'i',
   'n',
   'd',
   'l',
   'e',
   's',
   's',
   'C',
   'o',
   'u',
   'n',
   't',
   'N',
   'V',
   0, // glMultiDrawArraysIndirectBindlessCountNV
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'D',
   'r',
   'a',
   'w',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'I',
   'n',
   'd',
   'i',
   'r',
   'e',
   'c',
   't',
   'B',
   'i',
   'n',
   'd',
   'l',
   'e',
   's',
   's',
   'N',
   'V',
   0, // glMultiDrawArraysIndirectBindlessNV
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'D',
   'r',
   'a',
   'w',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'I',
   'n',
   'd',
   'i',
   'r',
   'e',
   'c',
   't',
   'C',
   'o',
   'u',
   'n',
   't',
   0, // glMultiDrawArraysIndirectCount
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'D',
   'r',
   'a',
   'w',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'I',
   'n',
   'd',
   'i',
   'r',
   'e',
   'c',
   't',
   'C',
   'o',
   'u',
   'n',
   't',
   'A',
   'R',
   'B',
   0, // glMultiDrawArraysIndirectCountARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'D',
   'r',
   'a',
   'w',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'I',
   'n',
   'd',
   'i',
   'r',
   'e',
   'c',
   't',
   'E',
   'X',
   'T',
   0, // glMultiDrawArraysIndirectEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   'A',
   'r',
   'r',
   'a',
   'y',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glMultiDrawElementArrayAPPLE
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   0, // glMultiDrawElements
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'B',
   'a',
   's',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   0, // glMultiDrawElementsBaseVertex
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'B',
   'a',
   's',
   'e',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'E',
   'X',
   'T',
   0, // glMultiDrawElementsBaseVertexEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'E',
   'X',
   'T',
   0, // glMultiDrawElementsEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'I',
   'n',
   'd',
   'i',
   'r',
   'e',
   'c',
   't',
   0, // glMultiDrawElementsIndirect
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'I',
   'n',
   'd',
   'i',
   'r',
   'e',
   'c',
   't',
   'A',
   'M',
   'D',
   0, // glMultiDrawElementsIndirectAMD
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'I',
   'n',
   'd',
   'i',
   'r',
   'e',
   'c',
   't',
   'B',
   'i',
   'n',
   'd',
   'l',
   'e',
   's',
   's',
   'C',
   'o',
   'u',
   'n',
   't',
   'N',
   'V',
   0, // glMultiDrawElementsIndirectBindlessCountNV
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'I',
   'n',
   'd',
   'i',
   'r',
   'e',
   'c',
   't',
   'B',
   'i',
   'n',
   'd',
   'l',
   'e',
   's',
   's',
   'N',
   'V',
   0, // glMultiDrawElementsIndirectBindlessNV
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'I',
   'n',
   'd',
   'i',
   'r',
   'e',
   'c',
   't',
   'C',
   'o',
   'u',
   'n',
   't',
   0, // glMultiDrawElementsIndirectCount
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'I',
   'n',
   'd',
   'i',
   'r',
   'e',
   'c',
   't',
   'C',
   'o',
   'u',
   'n',
   't',
   'A',
   'R',
   'B',
   0, // glMultiDrawElementsIndirectCountARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'I',
   'n',
   'd',
   'i',
   'r',
   'e',
   'c',
   't',
   'E',
   'X',
   'T',
   0, // glMultiDrawElementsIndirectEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'D',
   'r',
   'a',
   'w',
   'R',
   'a',
   'n',
   'g',
   'e',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   'A',
   'r',
   'r',
   'a',
   'y',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glMultiDrawRangeElementArrayAPPLE
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'M',
   'o',
   'd',
   'e',
   'D',
   'r',
   'a',
   'w',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'I',
   'B',
   'M',
   0, // glMultiModeDrawArraysIBM
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'M',
   'o',
   'd',
   'e',
   'D',
   'r',
   'a',
   'w',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   's',
   'I',
   'B',
   'M',
   0, // glMultiModeDrawElementsIBM
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glMultiTexBufferEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'b',
   'O',
   'E',
   'S',
   0, // glMultiTexCoord1bOES
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'b',
   'v',
   'O',
   'E',
   'S',
   0, // glMultiTexCoord1bvOES
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'd',
   0, // glMultiTexCoord1d
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'd',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord1dARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'd',
   'v',
   0, // glMultiTexCoord1dv
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'd',
   'v',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord1dvARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'f',
   0, // glMultiTexCoord1f
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'f',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord1fARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'f',
   'v',
   0, // glMultiTexCoord1fv
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord1fvARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'h',
   'N',
   'V',
   0, // glMultiTexCoord1hNV
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'h',
   'v',
   'N',
   'V',
   0, // glMultiTexCoord1hvNV
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'i',
   0, // glMultiTexCoord1i
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'i',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord1iARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'i',
   'v',
   0, // glMultiTexCoord1iv
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord1ivARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   's',
   0, // glMultiTexCoord1s
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   's',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord1sARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   's',
   'v',
   0, // glMultiTexCoord1sv
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   's',
   'v',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord1svARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'x',
   'O',
   'E',
   'S',
   0, // glMultiTexCoord1xOES
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glMultiTexCoord1xvOES
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'b',
   'O',
   'E',
   'S',
   0, // glMultiTexCoord2bOES
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'b',
   'v',
   'O',
   'E',
   'S',
   0, // glMultiTexCoord2bvOES
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'd',
   0, // glMultiTexCoord2d
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'd',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord2dARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'd',
   'v',
   0, // glMultiTexCoord2dv
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'd',
   'v',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord2dvARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'f',
   0, // glMultiTexCoord2f
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'f',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord2fARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'f',
   'v',
   0, // glMultiTexCoord2fv
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord2fvARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'h',
   'N',
   'V',
   0, // glMultiTexCoord2hNV
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'h',
   'v',
   'N',
   'V',
   0, // glMultiTexCoord2hvNV
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'i',
   0, // glMultiTexCoord2i
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'i',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord2iARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'i',
   'v',
   0, // glMultiTexCoord2iv
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord2ivARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   's',
   0, // glMultiTexCoord2s
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   's',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord2sARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   's',
   'v',
   0, // glMultiTexCoord2sv
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   's',
   'v',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord2svARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'x',
   'O',
   'E',
   'S',
   0, // glMultiTexCoord2xOES
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glMultiTexCoord2xvOES
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'b',
   'O',
   'E',
   'S',
   0, // glMultiTexCoord3bOES
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'b',
   'v',
   'O',
   'E',
   'S',
   0, // glMultiTexCoord3bvOES
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'd',
   0, // glMultiTexCoord3d
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'd',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord3dARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'd',
   'v',
   0, // glMultiTexCoord3dv
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'd',
   'v',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord3dvARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'f',
   0, // glMultiTexCoord3f
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'f',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord3fARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'f',
   'v',
   0, // glMultiTexCoord3fv
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord3fvARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'h',
   'N',
   'V',
   0, // glMultiTexCoord3hNV
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'h',
   'v',
   'N',
   'V',
   0, // glMultiTexCoord3hvNV
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'i',
   0, // glMultiTexCoord3i
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'i',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord3iARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'i',
   'v',
   0, // glMultiTexCoord3iv
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord3ivARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   's',
   0, // glMultiTexCoord3s
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   's',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord3sARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   's',
   'v',
   0, // glMultiTexCoord3sv
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   's',
   'v',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord3svARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'x',
   'O',
   'E',
   'S',
   0, // glMultiTexCoord3xOES
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glMultiTexCoord3xvOES
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'b',
   'O',
   'E',
   'S',
   0, // glMultiTexCoord4bOES
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'b',
   'v',
   'O',
   'E',
   'S',
   0, // glMultiTexCoord4bvOES
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'd',
   0, // glMultiTexCoord4d
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'd',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord4dARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'd',
   'v',
   0, // glMultiTexCoord4dv
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'd',
   'v',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord4dvARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'f',
   0, // glMultiTexCoord4f
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'f',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord4fARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'f',
   'v',
   0, // glMultiTexCoord4fv
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord4fvARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'h',
   'N',
   'V',
   0, // glMultiTexCoord4hNV
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'h',
   'v',
   'N',
   'V',
   0, // glMultiTexCoord4hvNV
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'i',
   0, // glMultiTexCoord4i
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'i',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord4iARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'i',
   'v',
   0, // glMultiTexCoord4iv
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord4ivARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   's',
   0, // glMultiTexCoord4s
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   's',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord4sARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   's',
   'v',
   0, // glMultiTexCoord4sv
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   's',
   'v',
   'A',
   'R',
   'B',
   0, // glMultiTexCoord4svARB
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'x',
   0, // glMultiTexCoord4x
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'x',
   'O',
   'E',
   'S',
   0, // glMultiTexCoord4xOES
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glMultiTexCoord4xvOES
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'P',
   '1',
   'u',
   'i',
   0, // glMultiTexCoordP1ui
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'P',
   '1',
   'u',
   'i',
   'v',
   0, // glMultiTexCoordP1uiv
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'P',
   '2',
   'u',
   'i',
   0, // glMultiTexCoordP2ui
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'P',
   '2',
   'u',
   'i',
   'v',
   0, // glMultiTexCoordP2uiv
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'P',
   '3',
   'u',
   'i',
   0, // glMultiTexCoordP3ui
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'P',
   '3',
   'u',
   'i',
   'v',
   0, // glMultiTexCoordP3uiv
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'P',
   '4',
   'u',
   'i',
   0, // glMultiTexCoordP4ui
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'P',
   '4',
   'u',
   'i',
   'v',
   0, // glMultiTexCoordP4uiv
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glMultiTexCoordPointerEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'E',
   'n',
   'v',
   'f',
   'E',
   'X',
   'T',
   0, // glMultiTexEnvfEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'E',
   'n',
   'v',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glMultiTexEnvfvEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'E',
   'n',
   'v',
   'i',
   'E',
   'X',
   'T',
   0, // glMultiTexEnviEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'E',
   'n',
   'v',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glMultiTexEnvivEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'd',
   'E',
   'X',
   'T',
   0, // glMultiTexGendEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glMultiTexGendvEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'f',
   'E',
   'X',
   'T',
   0, // glMultiTexGenfEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glMultiTexGenfvEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'i',
   'E',
   'X',
   'T',
   0, // glMultiTexGeniEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glMultiTexGenivEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   'E',
   'X',
   'T',
   0, // glMultiTexImage1DEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   'E',
   'X',
   'T',
   0, // glMultiTexImage2DEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   'E',
   'X',
   'T',
   0, // glMultiTexImage3DEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glMultiTexParameterIivEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glMultiTexParameterIuivEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'E',
   'X',
   'T',
   0, // glMultiTexParameterfEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glMultiTexParameterfvEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'E',
   'X',
   'T',
   0, // glMultiTexParameteriEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glMultiTexParameterivEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glMultiTexRenderbufferEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   'E',
   'X',
   'T',
   0, // glMultiTexSubImage1DEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   'E',
   'X',
   'T',
   0, // glMultiTexSubImage2DEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   'E',
   'X',
   'T',
   0, // glMultiTexSubImage3DEXT
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'c',
   'a',
   's',
   't',
   'B',
   'a',
   'r',
   'r',
   'i',
   'e',
   'r',
   'N',
   'V',
   0, // glMulticastBarrierNV
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'c',
   'a',
   's',
   't',
   'B',
   'l',
   'i',
   't',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'N',
   'V',
   0, // glMulticastBlitFramebufferNV
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'c',
   'a',
   's',
   't',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   'N',
   'V',
   0, // glMulticastBufferSubDataNV
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'c',
   'a',
   's',
   't',
   'C',
   'o',
   'p',
   'y',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   'N',
   'V',
   0, // glMulticastCopyBufferSubDataNV
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'c',
   'a',
   's',
   't',
   'C',
   'o',
   'p',
   'y',
   'I',
   'm',
   'a',
   'g',
   'e',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   'N',
   'V',
   0, // glMulticastCopyImageSubDataNV
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'c',
   'a',
   's',
   't',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'L',
   'o',
   'c',
   'a',
   't',
   'i',
   'o',
   'n',
   's',
   'f',
   'v',
   'N',
   'V',
   0, // glMulticastFramebufferSampleLocationsfvNV
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'c',
   'a',
   's',
   't',
   'G',
   'e',
   't',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glMulticastGetQueryObjecti64vNV
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'c',
   'a',
   's',
   't',
   'G',
   'e',
   't',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'i',
   'v',
   'N',
   'V',
   0, // glMulticastGetQueryObjectivNV
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'c',
   'a',
   's',
   't',
   'G',
   'e',
   't',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'u',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glMulticastGetQueryObjectui64vNV
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'c',
   'a',
   's',
   't',
   'G',
   'e',
   't',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'u',
   'i',
   'v',
   'N',
   'V',
   0, // glMulticastGetQueryObjectuivNV
   'g',
   'l',
   'M',
   'u',
   'l',
   't',
   'i',
   'c',
   'a',
   's',
   't',
   'W',
   'a',
   'i',
   't',
   'S',
   'y',
   'n',
   'c',
   'N',
   'V',
   0, // glMulticastWaitSyncNV
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'D',
   'a',
   't',
   'a',
   0, // glNamedBufferData
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'D',
   'a',
   't',
   'a',
   'E',
   'X',
   'T',
   0, // glNamedBufferDataEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'g',
   'e',
   'C',
   'o',
   'm',
   'm',
   'i',
   't',
   'm',
   'e',
   'n',
   't',
   'A',
   'R',
   'B',
   0, // glNamedBufferPageCommitmentARB
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'g',
   'e',
   'C',
   'o',
   'm',
   'm',
   'i',
   't',
   'm',
   'e',
   'n',
   't',
   'E',
   'X',
   'T',
   0, // glNamedBufferPageCommitmentEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   0, // glNamedBufferStorage
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'E',
   'X',
   'T',
   0, // glNamedBufferStorageEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'E',
   'x',
   't',
   'e',
   'r',
   'n',
   'a',
   'l',
   'E',
   'X',
   'T',
   0, // glNamedBufferStorageExternalEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'M',
   'e',
   'm',
   'E',
   'X',
   'T',
   0, // glNamedBufferStorageMemEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   0, // glNamedBufferSubData
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   'E',
   'X',
   'T',
   0, // glNamedBufferSubDataEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'C',
   'o',
   'p',
   'y',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'u',
   'b',
   'D',
   'a',
   't',
   'a',
   'E',
   'X',
   'T',
   0, // glNamedCopyBufferSubDataEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'D',
   'r',
   'a',
   'w',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glNamedFramebufferDrawBuffer
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'D',
   'r',
   'a',
   'w',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   0, // glNamedFramebufferDrawBuffers
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   0, // glNamedFramebufferParameteri
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'E',
   'X',
   'T',
   0, // glNamedFramebufferParameteriEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'e',
   'a',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glNamedFramebufferReadBuffer
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glNamedFramebufferRenderbuffer
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glNamedFramebufferRenderbufferEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'L',
   'o',
   'c',
   'a',
   't',
   'i',
   'o',
   'n',
   's',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glNamedFramebufferSampleLocationsfvARB
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'L',
   'o',
   'c',
   'a',
   't',
   'i',
   'o',
   'n',
   's',
   'f',
   'v',
   'N',
   'V',
   0, // glNamedFramebufferSampleLocationsfvNV
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'P',
   'o',
   's',
   'i',
   't',
   'i',
   'o',
   'n',
   's',
   'f',
   'v',
   'A',
   'M',
   'D',
   0, // glNamedFramebufferSamplePositionsfvAMD
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   0, // glNamedFramebufferTexture
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   '1',
   'D',
   'E',
   'X',
   'T',
   0, // glNamedFramebufferTexture1DEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   '2',
   'D',
   'E',
   'X',
   'T',
   0, // glNamedFramebufferTexture2DEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   '3',
   'D',
   'E',
   'X',
   'T',
   0, // glNamedFramebufferTexture3DEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'E',
   'X',
   'T',
   0, // glNamedFramebufferTextureEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'F',
   'a',
   'c',
   'e',
   'E',
   'X',
   'T',
   0, // glNamedFramebufferTextureFaceEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'L',
   'a',
   'y',
   'e',
   'r',
   0, // glNamedFramebufferTextureLayer
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'L',
   'a',
   'y',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glNamedFramebufferTextureLayerEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   '4',
   'd',
   'E',
   'X',
   'T',
   0, // glNamedProgramLocalParameter4dEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   '4',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glNamedProgramLocalParameter4dvEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   '4',
   'f',
   'E',
   'X',
   'T',
   0, // glNamedProgramLocalParameter4fEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   '4',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glNamedProgramLocalParameter4fvEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   '4',
   'i',
   'E',
   'X',
   'T',
   0, // glNamedProgramLocalParameterI4iEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   '4',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glNamedProgramLocalParameterI4ivEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   '4',
   'u',
   'i',
   'E',
   'X',
   'T',
   0, // glNamedProgramLocalParameterI4uiEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   '4',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glNamedProgramLocalParameterI4uivEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   's',
   '4',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glNamedProgramLocalParameters4fvEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   's',
   'I',
   '4',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glNamedProgramLocalParametersI4ivEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   's',
   'I',
   '4',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glNamedProgramLocalParametersI4uivEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'S',
   't',
   'r',
   'i',
   'n',
   'g',
   'E',
   'X',
   'T',
   0, // glNamedProgramStringEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   0, // glNamedRenderbufferStorage
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'E',
   'X',
   'T',
   0, // glNamedRenderbufferStorageEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   0, // glNamedRenderbufferStorageMultisample
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'C',
   'o',
   'v',
   'e',
   'r',
   'a',
   'g',
   'e',
   'E',
   'X',
   'T',
   0, // glNamedRenderbufferStorageMultisampleCoverageEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'E',
   'X',
   'T',
   0, // glNamedRenderbufferStorageMultisampleEXT
   'g',
   'l',
   'N',
   'a',
   'm',
   'e',
   'd',
   'S',
   't',
   'r',
   'i',
   'n',
   'g',
   'A',
   'R',
   'B',
   0, // glNamedStringARB
   'g',
   'l',
   'N',
   'e',
   'w',
   'L',
   'i',
   's',
   't',
   0, // glNewList
   'g',
   'l',
   'N',
   'e',
   'w',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'A',
   'T',
   'I',
   0, // glNewObjectBufferATI
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'b',
   0, // glNormal3b
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'b',
   'v',
   0, // glNormal3bv
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'd',
   0, // glNormal3d
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'd',
   'v',
   0, // glNormal3dv
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'f',
   0, // glNormal3f
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'S',
   'U',
   'N',
   0, // glNormal3fVertex3fSUN
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'v',
   'S',
   'U',
   'N',
   0, // glNormal3fVertex3fvSUN
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'f',
   'v',
   0, // glNormal3fv
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'h',
   'N',
   'V',
   0, // glNormal3hNV
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'h',
   'v',
   'N',
   'V',
   0, // glNormal3hvNV
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'i',
   0, // glNormal3i
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'i',
   'v',
   0, // glNormal3iv
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   's',
   0, // glNormal3s
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   's',
   'v',
   0, // glNormal3sv
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'x',
   0, // glNormal3x
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'x',
   'O',
   'E',
   'S',
   0, // glNormal3xOES
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glNormal3xvOES
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   'F',
   'o',
   'r',
   'm',
   'a',
   't',
   'N',
   'V',
   0, // glNormalFormatNV
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   'P',
   '3',
   'u',
   'i',
   0, // glNormalP3ui
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   'P',
   '3',
   'u',
   'i',
   'v',
   0, // glNormalP3uiv
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   0, // glNormalPointer
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glNormalPointerEXT
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'L',
   'i',
   's',
   't',
   'I',
   'B',
   'M',
   0, // glNormalPointerListIBM
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'v',
   'I',
   'N',
   'T',
   'E',
   'L',
   0, // glNormalPointervINTEL
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '3',
   'b',
   'A',
   'T',
   'I',
   0, // glNormalStream3bATI
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '3',
   'b',
   'v',
   'A',
   'T',
   'I',
   0, // glNormalStream3bvATI
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '3',
   'd',
   'A',
   'T',
   'I',
   0, // glNormalStream3dATI
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '3',
   'd',
   'v',
   'A',
   'T',
   'I',
   0, // glNormalStream3dvATI
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '3',
   'f',
   'A',
   'T',
   'I',
   0, // glNormalStream3fATI
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '3',
   'f',
   'v',
   'A',
   'T',
   'I',
   0, // glNormalStream3fvATI
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '3',
   'i',
   'A',
   'T',
   'I',
   0, // glNormalStream3iATI
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '3',
   'i',
   'v',
   'A',
   'T',
   'I',
   0, // glNormalStream3ivATI
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '3',
   's',
   'A',
   'T',
   'I',
   0, // glNormalStream3sATI
   'g',
   'l',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '3',
   's',
   'v',
   'A',
   'T',
   'I',
   0, // glNormalStream3svATI
   'g',
   'l',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'L',
   'a',
   'b',
   'e',
   'l',
   0, // glObjectLabel
   'g',
   'l',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'L',
   'a',
   'b',
   'e',
   'l',
   'K',
   'H',
   'R',
   0, // glObjectLabelKHR
   'g',
   'l',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'P',
   't',
   'r',
   'L',
   'a',
   'b',
   'e',
   'l',
   0, // glObjectPtrLabel
   'g',
   'l',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'P',
   't',
   'r',
   'L',
   'a',
   'b',
   'e',
   'l',
   'K',
   'H',
   'R',
   0, // glObjectPtrLabelKHR
   'g',
   'l',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'P',
   'u',
   'r',
   'g',
   'e',
   'a',
   'b',
   'l',
   'e',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glObjectPurgeableAPPLE
   'g',
   'l',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'U',
   'n',
   'p',
   'u',
   'r',
   'g',
   'e',
   'a',
   'b',
   'l',
   'e',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glObjectUnpurgeableAPPLE
   'g',
   'l',
   'O',
   'r',
   't',
   'h',
   'o',
   0, // glOrtho
   'g',
   'l',
   'O',
   'r',
   't',
   'h',
   'o',
   'f',
   0, // glOrthof
   'g',
   'l',
   'O',
   'r',
   't',
   'h',
   'o',
   'f',
   'O',
   'E',
   'S',
   0, // glOrthofOES
   'g',
   'l',
   'O',
   'r',
   't',
   'h',
   'o',
   'x',
   0, // glOrthox
   'g',
   'l',
   'O',
   'r',
   't',
   'h',
   'o',
   'x',
   'O',
   'E',
   'S',
   0, // glOrthoxOES
   'g',
   'l',
   'P',
   'N',
   'T',
   'r',
   'i',
   'a',
   'n',
   'g',
   'l',
   'e',
   's',
   'f',
   'A',
   'T',
   'I',
   0, // glPNTrianglesfATI
   'g',
   'l',
   'P',
   'N',
   'T',
   'r',
   'i',
   'a',
   'n',
   'g',
   'l',
   'e',
   's',
   'i',
   'A',
   'T',
   'I',
   0, // glPNTrianglesiATI
   'g',
   'l',
   'P',
   'a',
   's',
   's',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'A',
   'T',
   'I',
   0, // glPassTexCoordATI
   'g',
   'l',
   'P',
   'a',
   's',
   's',
   'T',
   'h',
   'r',
   'o',
   'u',
   'g',
   'h',
   0, // glPassThrough
   'g',
   'l',
   'P',
   'a',
   's',
   's',
   'T',
   'h',
   'r',
   'o',
   'u',
   'g',
   'h',
   'x',
   'O',
   'E',
   'S',
   0, // glPassThroughxOES
   'g',
   'l',
   'P',
   'a',
   't',
   'c',
   'h',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   0, // glPatchParameterfv
   'g',
   'l',
   'P',
   'a',
   't',
   'c',
   'h',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   0, // glPatchParameteri
   'g',
   'l',
   'P',
   'a',
   't',
   'c',
   'h',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'E',
   'X',
   'T',
   0, // glPatchParameteriEXT
   'g',
   'l',
   'P',
   'a',
   't',
   'c',
   'h',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'O',
   'E',
   'S',
   0, // glPatchParameteriOES
   'g',
   'l',
   'P',
   'a',
   't',
   'h',
   'C',
   'o',
   'l',
   'o',
   'r',
   'G',
   'e',
   'n',
   'N',
   'V',
   0, // glPathColorGenNV
   'g',
   'l',
   'P',
   'a',
   't',
   'h',
   'C',
   'o',
   'm',
   'm',
   'a',
   'n',
   'd',
   's',
   'N',
   'V',
   0, // glPathCommandsNV
   'g',
   'l',
   'P',
   'a',
   't',
   'h',
   'C',
   'o',
   'o',
   'r',
   'd',
   's',
   'N',
   'V',
   0, // glPathCoordsNV
   'g',
   'l',
   'P',
   'a',
   't',
   'h',
   'C',
   'o',
   'v',
   'e',
   'r',
   'D',
   'e',
   'p',
   't',
   'h',
   'F',
   'u',
   'n',
   'c',
   'N',
   'V',
   0, // glPathCoverDepthFuncNV
   'g',
   'l',
   'P',
   'a',
   't',
   'h',
   'D',
   'a',
   's',
   'h',
   'A',
   'r',
   'r',
   'a',
   'y',
   'N',
   'V',
   0, // glPathDashArrayNV
   'g',
   'l',
   'P',
   'a',
   't',
   'h',
   'F',
   'o',
   'g',
   'G',
   'e',
   'n',
   'N',
   'V',
   0, // glPathFogGenNV
   'g',
   'l',
   'P',
   'a',
   't',
   'h',
   'G',
   'l',
   'y',
   'p',
   'h',
   'I',
   'n',
   'd',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'N',
   'V',
   0, // glPathGlyphIndexArrayNV
   'g',
   'l',
   'P',
   'a',
   't',
   'h',
   'G',
   'l',
   'y',
   'p',
   'h',
   'I',
   'n',
   'd',
   'e',
   'x',
   'R',
   'a',
   'n',
   'g',
   'e',
   'N',
   'V',
   0, // glPathGlyphIndexRangeNV
   'g',
   'l',
   'P',
   'a',
   't',
   'h',
   'G',
   'l',
   'y',
   'p',
   'h',
   'R',
   'a',
   'n',
   'g',
   'e',
   'N',
   'V',
   0, // glPathGlyphRangeNV
   'g',
   'l',
   'P',
   'a',
   't',
   'h',
   'G',
   'l',
   'y',
   'p',
   'h',
   's',
   'N',
   'V',
   0, // glPathGlyphsNV
   'g',
   'l',
   'P',
   'a',
   't',
   'h',
   'M',
   'e',
   'm',
   'o',
   'r',
   'y',
   'G',
   'l',
   'y',
   'p',
   'h',
   'I',
   'n',
   'd',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'N',
   'V',
   0, // glPathMemoryGlyphIndexArrayNV
   'g',
   'l',
   'P',
   'a',
   't',
   'h',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'N',
   'V',
   0, // glPathParameterfNV
   'g',
   'l',
   'P',
   'a',
   't',
   'h',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'N',
   'V',
   0, // glPathParameterfvNV
   'g',
   'l',
   'P',
   'a',
   't',
   'h',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'N',
   'V',
   0, // glPathParameteriNV
   'g',
   'l',
   'P',
   'a',
   't',
   'h',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'N',
   'V',
   0, // glPathParameterivNV
   'g',
   'l',
   'P',
   'a',
   't',
   'h',
   'S',
   't',
   'e',
   'n',
   'c',
   'i',
   'l',
   'D',
   'e',
   'p',
   't',
   'h',
   'O',
   'f',
   'f',
   's',
   'e',
   't',
   'N',
   'V',
   0, // glPathStencilDepthOffsetNV
   'g',
   'l',
   'P',
   'a',
   't',
   'h',
   'S',
   't',
   'e',
   'n',
   'c',
   'i',
   'l',
   'F',
   'u',
   'n',
   'c',
   'N',
   'V',
   0, // glPathStencilFuncNV
   'g',
   'l',
   'P',
   'a',
   't',
   'h',
   'S',
   't',
   'r',
   'i',
   'n',
   'g',
   'N',
   'V',
   0, // glPathStringNV
   'g',
   'l',
   'P',
   'a',
   't',
   'h',
   'S',
   'u',
   'b',
   'C',
   'o',
   'm',
   'm',
   'a',
   'n',
   'd',
   's',
   'N',
   'V',
   0, // glPathSubCommandsNV
   'g',
   'l',
   'P',
   'a',
   't',
   'h',
   'S',
   'u',
   'b',
   'C',
   'o',
   'o',
   'r',
   'd',
   's',
   'N',
   'V',
   0, // glPathSubCoordsNV
   'g',
   'l',
   'P',
   'a',
   't',
   'h',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'N',
   'V',
   0, // glPathTexGenNV
   'g',
   'l',
   'P',
   'a',
   'u',
   's',
   'e',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   0, // glPauseTransformFeedback
   'g',
   'l',
   'P',
   'a',
   'u',
   's',
   'e',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'N',
   'V',
   0, // glPauseTransformFeedbackNV
   'g',
   'l',
   'P',
   'i',
   'x',
   'e',
   'l',
   'D',
   'a',
   't',
   'a',
   'R',
   'a',
   'n',
   'g',
   'e',
   'N',
   'V',
   0, // glPixelDataRangeNV
   'g',
   'l',
   'P',
   'i',
   'x',
   'e',
   'l',
   'M',
   'a',
   'p',
   'f',
   'v',
   0, // glPixelMapfv
   'g',
   'l',
   'P',
   'i',
   'x',
   'e',
   'l',
   'M',
   'a',
   'p',
   'u',
   'i',
   'v',
   0, // glPixelMapuiv
   'g',
   'l',
   'P',
   'i',
   'x',
   'e',
   'l',
   'M',
   'a',
   'p',
   'u',
   's',
   'v',
   0, // glPixelMapusv
   'g',
   'l',
   'P',
   'i',
   'x',
   'e',
   'l',
   'M',
   'a',
   'p',
   'x',
   0, // glPixelMapx
   'g',
   'l',
   'P',
   'i',
   'x',
   'e',
   'l',
   'S',
   't',
   'o',
   'r',
   'e',
   'f',
   0, // glPixelStoref
   'g',
   'l',
   'P',
   'i',
   'x',
   'e',
   'l',
   'S',
   't',
   'o',
   'r',
   'e',
   'i',
   0, // glPixelStorei
   'g',
   'l',
   'P',
   'i',
   'x',
   'e',
   'l',
   'S',
   't',
   'o',
   'r',
   'e',
   'x',
   0, // glPixelStorex
   'g',
   'l',
   'P',
   'i',
   'x',
   'e',
   'l',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'S',
   'G',
   'I',
   'S',
   0, // glPixelTexGenParameterfSGIS
   'g',
   'l',
   'P',
   'i',
   'x',
   'e',
   'l',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'S',
   'G',
   'I',
   'S',
   0, // glPixelTexGenParameterfvSGIS
   'g',
   'l',
   'P',
   'i',
   'x',
   'e',
   'l',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'S',
   'G',
   'I',
   'S',
   0, // glPixelTexGenParameteriSGIS
   'g',
   'l',
   'P',
   'i',
   'x',
   'e',
   'l',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'S',
   'G',
   'I',
   'S',
   0, // glPixelTexGenParameterivSGIS
   'g',
   'l',
   'P',
   'i',
   'x',
   'e',
   'l',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'S',
   'G',
   'I',
   'X',
   0, // glPixelTexGenSGIX
   'g',
   'l',
   'P',
   'i',
   'x',
   'e',
   'l',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'e',
   'r',
   'f',
   0, // glPixelTransferf
   'g',
   'l',
   'P',
   'i',
   'x',
   'e',
   'l',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'e',
   'r',
   'i',
   0, // glPixelTransferi
   'g',
   'l',
   'P',
   'i',
   'x',
   'e',
   'l',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'e',
   'r',
   'x',
   'O',
   'E',
   'S',
   0, // glPixelTransferxOES
   'g',
   'l',
   'P',
   'i',
   'x',
   'e',
   'l',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'E',
   'X',
   'T',
   0, // glPixelTransformParameterfEXT
   'g',
   'l',
   'P',
   'i',
   'x',
   'e',
   'l',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glPixelTransformParameterfvEXT
   'g',
   'l',
   'P',
   'i',
   'x',
   'e',
   'l',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'E',
   'X',
   'T',
   0, // glPixelTransformParameteriEXT
   'g',
   'l',
   'P',
   'i',
   'x',
   'e',
   'l',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glPixelTransformParameterivEXT
   'g',
   'l',
   'P',
   'i',
   'x',
   'e',
   'l',
   'Z',
   'o',
   'o',
   'm',
   0, // glPixelZoom
   'g',
   'l',
   'P',
   'i',
   'x',
   'e',
   'l',
   'Z',
   'o',
   'o',
   'm',
   'x',
   'O',
   'E',
   'S',
   0, // glPixelZoomxOES
   'g',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'A',
   'l',
   'o',
   'n',
   'g',
   'P',
   'a',
   't',
   'h',
   'N',
   'V',
   0, // glPointAlongPathNV
   'g',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   0, // glPointParameterf
   'g',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'A',
   'R',
   'B',
   0, // glPointParameterfARB
   'g',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'E',
   'X',
   'T',
   0, // glPointParameterfEXT
   'g',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'S',
   'G',
   'I',
   'S',
   0, // glPointParameterfSGIS
   'g',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   0, // glPointParameterfv
   'g',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glPointParameterfvARB
   'g',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glPointParameterfvEXT
   'g',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'S',
   'G',
   'I',
   'S',
   0, // glPointParameterfvSGIS
   'g',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   0, // glPointParameteri
   'g',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'N',
   'V',
   0, // glPointParameteriNV
   'g',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   0, // glPointParameteriv
   'g',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'N',
   'V',
   0, // glPointParameterivNV
   'g',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'x',
   0, // glPointParameterx
   'g',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'x',
   'O',
   'E',
   'S',
   0, // glPointParameterxOES
   'g',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'x',
   'v',
   0, // glPointParameterxv
   'g',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glPointParameterxvOES
   'g',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'S',
   'i',
   'z',
   'e',
   0, // glPointSize
   'g',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'S',
   'i',
   'z',
   'e',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'O',
   'E',
   'S',
   0, // glPointSizePointerOES
   'g',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'S',
   'i',
   'z',
   'e',
   'x',
   0, // glPointSizex
   'g',
   'l',
   'P',
   'o',
   'i',
   'n',
   't',
   'S',
   'i',
   'z',
   'e',
   'x',
   'O',
   'E',
   'S',
   0, // glPointSizexOES
   'g',
   'l',
   'P',
   'o',
   'l',
   'l',
   'A',
   's',
   'y',
   'n',
   'c',
   'S',
   'G',
   'I',
   'X',
   0, // glPollAsyncSGIX
   'g',
   'l',
   'P',
   'o',
   'l',
   'l',
   'I',
   'n',
   's',
   't',
   'r',
   'u',
   'm',
   'e',
   'n',
   't',
   's',
   'S',
   'G',
   'I',
   'X',
   0, // glPollInstrumentsSGIX
   'g',
   'l',
   'P',
   'o',
   'l',
   'y',
   'g',
   'o',
   'n',
   'M',
   'o',
   'd',
   'e',
   0, // glPolygonMode
   'g',
   'l',
   'P',
   'o',
   'l',
   'y',
   'g',
   'o',
   'n',
   'M',
   'o',
   'd',
   'e',
   'N',
   'V',
   0, // glPolygonModeNV
   'g',
   'l',
   'P',
   'o',
   'l',
   'y',
   'g',
   'o',
   'n',
   'O',
   'f',
   'f',
   's',
   'e',
   't',
   0, // glPolygonOffset
   'g',
   'l',
   'P',
   'o',
   'l',
   'y',
   'g',
   'o',
   'n',
   'O',
   'f',
   'f',
   's',
   'e',
   't',
   'C',
   'l',
   'a',
   'm',
   'p',
   0, // glPolygonOffsetClamp
   'g',
   'l',
   'P',
   'o',
   'l',
   'y',
   'g',
   'o',
   'n',
   'O',
   'f',
   'f',
   's',
   'e',
   't',
   'C',
   'l',
   'a',
   'm',
   'p',
   'E',
   'X',
   'T',
   0, // glPolygonOffsetClampEXT
   'g',
   'l',
   'P',
   'o',
   'l',
   'y',
   'g',
   'o',
   'n',
   'O',
   'f',
   'f',
   's',
   'e',
   't',
   'E',
   'X',
   'T',
   0, // glPolygonOffsetEXT
   'g',
   'l',
   'P',
   'o',
   'l',
   'y',
   'g',
   'o',
   'n',
   'O',
   'f',
   'f',
   's',
   'e',
   't',
   'x',
   0, // glPolygonOffsetx
   'g',
   'l',
   'P',
   'o',
   'l',
   'y',
   'g',
   'o',
   'n',
   'O',
   'f',
   'f',
   's',
   'e',
   't',
   'x',
   'O',
   'E',
   'S',
   0, // glPolygonOffsetxOES
   'g',
   'l',
   'P',
   'o',
   'l',
   'y',
   'g',
   'o',
   'n',
   'S',
   't',
   'i',
   'p',
   'p',
   'l',
   'e',
   0, // glPolygonStipple
   'g',
   'l',
   'P',
   'o',
   'p',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   0, // glPopAttrib
   'g',
   'l',
   'P',
   'o',
   'p',
   'C',
   'l',
   'i',
   'e',
   'n',
   't',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   0, // glPopClientAttrib
   'g',
   'l',
   'P',
   'o',
   'p',
   'D',
   'e',
   'b',
   'u',
   'g',
   'G',
   'r',
   'o',
   'u',
   'p',
   0, // glPopDebugGroup
   'g',
   'l',
   'P',
   'o',
   'p',
   'D',
   'e',
   'b',
   'u',
   'g',
   'G',
   'r',
   'o',
   'u',
   'p',
   'K',
   'H',
   'R',
   0, // glPopDebugGroupKHR
   'g',
   'l',
   'P',
   'o',
   'p',
   'G',
   'r',
   'o',
   'u',
   'p',
   'M',
   'a',
   'r',
   'k',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glPopGroupMarkerEXT
   'g',
   'l',
   'P',
   'o',
   'p',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   0, // glPopMatrix
   'g',
   'l',
   'P',
   'o',
   'p',
   'N',
   'a',
   'm',
   'e',
   0, // glPopName
   'g',
   'l',
   'P',
   'r',
   'e',
   's',
   'e',
   'n',
   't',
   'F',
   'r',
   'a',
   'm',
   'e',
   'D',
   'u',
   'a',
   'l',
   'F',
   'i',
   'l',
   'l',
   'N',
   'V',
   0, // glPresentFrameDualFillNV
   'g',
   'l',
   'P',
   'r',
   'e',
   's',
   'e',
   'n',
   't',
   'F',
   'r',
   'a',
   'm',
   'e',
   'K',
   'e',
   'y',
   'e',
   'd',
   'N',
   'V',
   0, // glPresentFrameKeyedNV
   'g',
   'l',
   'P',
   'r',
   'i',
   'm',
   'i',
   't',
   'i',
   'v',
   'e',
   'B',
   'o',
   'u',
   'n',
   'd',
   'i',
   'n',
   'g',
   'B',
   'o',
   'x',
   0, // glPrimitiveBoundingBox
   'g',
   'l',
   'P',
   'r',
   'i',
   'm',
   'i',
   't',
   'i',
   'v',
   'e',
   'B',
   'o',
   'u',
   'n',
   'd',
   'i',
   'n',
   'g',
   'B',
   'o',
   'x',
   'A',
   'R',
   'B',
   0, // glPrimitiveBoundingBoxARB
   'g',
   'l',
   'P',
   'r',
   'i',
   'm',
   'i',
   't',
   'i',
   'v',
   'e',
   'B',
   'o',
   'u',
   'n',
   'd',
   'i',
   'n',
   'g',
   'B',
   'o',
   'x',
   'E',
   'X',
   'T',
   0, // glPrimitiveBoundingBoxEXT
   'g',
   'l',
   'P',
   'r',
   'i',
   'm',
   'i',
   't',
   'i',
   'v',
   'e',
   'B',
   'o',
   'u',
   'n',
   'd',
   'i',
   'n',
   'g',
   'B',
   'o',
   'x',
   'O',
   'E',
   'S',
   0, // glPrimitiveBoundingBoxOES
   'g',
   'l',
   'P',
   'r',
   'i',
   'm',
   'i',
   't',
   'i',
   'v',
   'e',
   'R',
   'e',
   's',
   't',
   'a',
   'r',
   't',
   'I',
   'n',
   'd',
   'e',
   'x',
   0, // glPrimitiveRestartIndex
   'g',
   'l',
   'P',
   'r',
   'i',
   'm',
   'i',
   't',
   'i',
   'v',
   'e',
   'R',
   'e',
   's',
   't',
   'a',
   'r',
   't',
   'I',
   'n',
   'd',
   'e',
   'x',
   'N',
   'V',
   0, // glPrimitiveRestartIndexNV
   'g',
   'l',
   'P',
   'r',
   'i',
   'm',
   'i',
   't',
   'i',
   'v',
   'e',
   'R',
   'e',
   's',
   't',
   'a',
   'r',
   't',
   'N',
   'V',
   0, // glPrimitiveRestartNV
   'g',
   'l',
   'P',
   'r',
   'i',
   'o',
   'r',
   'i',
   't',
   'i',
   'z',
   'e',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   's',
   0, // glPrioritizeTextures
   'g',
   'l',
   'P',
   'r',
   'i',
   'o',
   'r',
   'i',
   't',
   'i',
   'z',
   'e',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   's',
   'E',
   'X',
   'T',
   0, // glPrioritizeTexturesEXT
   'g',
   'l',
   'P',
   'r',
   'i',
   'o',
   'r',
   'i',
   't',
   'i',
   'z',
   'e',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   's',
   'x',
   'O',
   'E',
   'S',
   0, // glPrioritizeTexturesxOES
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'B',
   'i',
   'n',
   'a',
   'r',
   'y',
   0, // glProgramBinary
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'B',
   'i',
   'n',
   'a',
   'r',
   'y',
   'O',
   'E',
   'S',
   0, // glProgramBinaryOES
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   's',
   'I',
   'i',
   'v',
   'N',
   'V',
   0, // glProgramBufferParametersIivNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   's',
   'I',
   'u',
   'i',
   'v',
   'N',
   'V',
   0, // glProgramBufferParametersIuivNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   's',
   'f',
   'v',
   'N',
   'V',
   0, // glProgramBufferParametersfvNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'E',
   'n',
   'v',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   '4',
   'd',
   'A',
   'R',
   'B',
   0, // glProgramEnvParameter4dARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'E',
   'n',
   'v',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   '4',
   'd',
   'v',
   'A',
   'R',
   'B',
   0, // glProgramEnvParameter4dvARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'E',
   'n',
   'v',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   '4',
   'f',
   'A',
   'R',
   'B',
   0, // glProgramEnvParameter4fARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'E',
   'n',
   'v',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   '4',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glProgramEnvParameter4fvARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'E',
   'n',
   'v',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   '4',
   'i',
   'N',
   'V',
   0, // glProgramEnvParameterI4iNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'E',
   'n',
   'v',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   '4',
   'i',
   'v',
   'N',
   'V',
   0, // glProgramEnvParameterI4ivNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'E',
   'n',
   'v',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   '4',
   'u',
   'i',
   'N',
   'V',
   0, // glProgramEnvParameterI4uiNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'E',
   'n',
   'v',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   '4',
   'u',
   'i',
   'v',
   'N',
   'V',
   0, // glProgramEnvParameterI4uivNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'E',
   'n',
   'v',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   's',
   '4',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramEnvParameters4fvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'E',
   'n',
   'v',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   's',
   'I',
   '4',
   'i',
   'v',
   'N',
   'V',
   0, // glProgramEnvParametersI4ivNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'E',
   'n',
   'v',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   's',
   'I',
   '4',
   'u',
   'i',
   'v',
   'N',
   'V',
   0, // glProgramEnvParametersI4uivNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   '4',
   'd',
   'A',
   'R',
   'B',
   0, // glProgramLocalParameter4dARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   '4',
   'd',
   'v',
   'A',
   'R',
   'B',
   0, // glProgramLocalParameter4dvARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   '4',
   'f',
   'A',
   'R',
   'B',
   0, // glProgramLocalParameter4fARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   '4',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glProgramLocalParameter4fvARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   '4',
   'i',
   'N',
   'V',
   0, // glProgramLocalParameterI4iNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   '4',
   'i',
   'v',
   'N',
   'V',
   0, // glProgramLocalParameterI4ivNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   '4',
   'u',
   'i',
   'N',
   'V',
   0, // glProgramLocalParameterI4uiNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   '4',
   'u',
   'i',
   'v',
   'N',
   'V',
   0, // glProgramLocalParameterI4uivNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   's',
   '4',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramLocalParameters4fvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   's',
   'I',
   '4',
   'i',
   'v',
   'N',
   'V',
   0, // glProgramLocalParametersI4ivNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'L',
   'o',
   'c',
   'a',
   'l',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   's',
   'I',
   '4',
   'u',
   'i',
   'v',
   'N',
   'V',
   0, // glProgramLocalParametersI4uivNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'N',
   'a',
   'm',
   'e',
   'd',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   '4',
   'd',
   'N',
   'V',
   0, // glProgramNamedParameter4dNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'N',
   'a',
   'm',
   'e',
   'd',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   '4',
   'd',
   'v',
   'N',
   'V',
   0, // glProgramNamedParameter4dvNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'N',
   'a',
   'm',
   'e',
   'd',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   '4',
   'f',
   'N',
   'V',
   0, // glProgramNamedParameter4fNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'N',
   'a',
   'm',
   'e',
   'd',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   '4',
   'f',
   'v',
   'N',
   'V',
   0, // glProgramNamedParameter4fvNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   '4',
   'd',
   'N',
   'V',
   0, // glProgramParameter4dNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   '4',
   'd',
   'v',
   'N',
   'V',
   0, // glProgramParameter4dvNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   '4',
   'f',
   'N',
   'V',
   0, // glProgramParameter4fNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   '4',
   'f',
   'v',
   'N',
   'V',
   0, // glProgramParameter4fvNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   0, // glProgramParameteri
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'A',
   'R',
   'B',
   0, // glProgramParameteriARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'E',
   'X',
   'T',
   0, // glProgramParameteriEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   's',
   '4',
   'd',
   'v',
   'N',
   'V',
   0, // glProgramParameters4dvNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   's',
   '4',
   'f',
   'v',
   'N',
   'V',
   0, // glProgramParameters4fvNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'a',
   't',
   'h',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'I',
   'n',
   'p',
   'u',
   't',
   'G',
   'e',
   'n',
   'N',
   'V',
   0, // glProgramPathFragmentInputGenNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'S',
   't',
   'r',
   'i',
   'n',
   'g',
   'A',
   'R',
   'B',
   0, // glProgramStringARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'S',
   'u',
   'b',
   'r',
   'o',
   'u',
   't',
   'i',
   'n',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   's',
   'u',
   'i',
   'v',
   'N',
   'V',
   0, // glProgramSubroutineParametersuivNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'd',
   0, // glProgramUniform1d
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'd',
   'E',
   'X',
   'T',
   0, // glProgramUniform1dEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'd',
   'v',
   0, // glProgramUniform1dv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniform1dvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'f',
   0, // glProgramUniform1f
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'f',
   'E',
   'X',
   'T',
   0, // glProgramUniform1fEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'f',
   'v',
   0, // glProgramUniform1fv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniform1fvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'i',
   0, // glProgramUniform1i
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'i',
   '6',
   '4',
   'A',
   'R',
   'B',
   0, // glProgramUniform1i64ARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glProgramUniform1i64NV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'i',
   '6',
   '4',
   'v',
   'A',
   'R',
   'B',
   0, // glProgramUniform1i64vARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glProgramUniform1i64vNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'i',
   'E',
   'X',
   'T',
   0, // glProgramUniform1iEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'i',
   'v',
   0, // glProgramUniform1iv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniform1ivEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'u',
   'i',
   0, // glProgramUniform1ui
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'u',
   'i',
   '6',
   '4',
   'A',
   'R',
   'B',
   0, // glProgramUniform1ui64ARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'u',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glProgramUniform1ui64NV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'u',
   'i',
   '6',
   '4',
   'v',
   'A',
   'R',
   'B',
   0, // glProgramUniform1ui64vARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'u',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glProgramUniform1ui64vNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'u',
   'i',
   'E',
   'X',
   'T',
   0, // glProgramUniform1uiEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'u',
   'i',
   'v',
   0, // glProgramUniform1uiv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniform1uivEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'd',
   0, // glProgramUniform2d
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'd',
   'E',
   'X',
   'T',
   0, // glProgramUniform2dEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'd',
   'v',
   0, // glProgramUniform2dv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniform2dvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'f',
   0, // glProgramUniform2f
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'f',
   'E',
   'X',
   'T',
   0, // glProgramUniform2fEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'f',
   'v',
   0, // glProgramUniform2fv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniform2fvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'i',
   0, // glProgramUniform2i
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'i',
   '6',
   '4',
   'A',
   'R',
   'B',
   0, // glProgramUniform2i64ARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glProgramUniform2i64NV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'i',
   '6',
   '4',
   'v',
   'A',
   'R',
   'B',
   0, // glProgramUniform2i64vARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glProgramUniform2i64vNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'i',
   'E',
   'X',
   'T',
   0, // glProgramUniform2iEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'i',
   'v',
   0, // glProgramUniform2iv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniform2ivEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'u',
   'i',
   0, // glProgramUniform2ui
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'u',
   'i',
   '6',
   '4',
   'A',
   'R',
   'B',
   0, // glProgramUniform2ui64ARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'u',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glProgramUniform2ui64NV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'u',
   'i',
   '6',
   '4',
   'v',
   'A',
   'R',
   'B',
   0, // glProgramUniform2ui64vARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'u',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glProgramUniform2ui64vNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'u',
   'i',
   'E',
   'X',
   'T',
   0, // glProgramUniform2uiEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'u',
   'i',
   'v',
   0, // glProgramUniform2uiv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniform2uivEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'd',
   0, // glProgramUniform3d
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'd',
   'E',
   'X',
   'T',
   0, // glProgramUniform3dEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'd',
   'v',
   0, // glProgramUniform3dv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniform3dvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'f',
   0, // glProgramUniform3f
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'f',
   'E',
   'X',
   'T',
   0, // glProgramUniform3fEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'f',
   'v',
   0, // glProgramUniform3fv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniform3fvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'i',
   0, // glProgramUniform3i
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'i',
   '6',
   '4',
   'A',
   'R',
   'B',
   0, // glProgramUniform3i64ARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glProgramUniform3i64NV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'i',
   '6',
   '4',
   'v',
   'A',
   'R',
   'B',
   0, // glProgramUniform3i64vARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glProgramUniform3i64vNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'i',
   'E',
   'X',
   'T',
   0, // glProgramUniform3iEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'i',
   'v',
   0, // glProgramUniform3iv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniform3ivEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'u',
   'i',
   0, // glProgramUniform3ui
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'u',
   'i',
   '6',
   '4',
   'A',
   'R',
   'B',
   0, // glProgramUniform3ui64ARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'u',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glProgramUniform3ui64NV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'u',
   'i',
   '6',
   '4',
   'v',
   'A',
   'R',
   'B',
   0, // glProgramUniform3ui64vARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'u',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glProgramUniform3ui64vNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'u',
   'i',
   'E',
   'X',
   'T',
   0, // glProgramUniform3uiEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'u',
   'i',
   'v',
   0, // glProgramUniform3uiv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniform3uivEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'd',
   0, // glProgramUniform4d
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'd',
   'E',
   'X',
   'T',
   0, // glProgramUniform4dEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'd',
   'v',
   0, // glProgramUniform4dv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniform4dvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'f',
   0, // glProgramUniform4f
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'f',
   'E',
   'X',
   'T',
   0, // glProgramUniform4fEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'f',
   'v',
   0, // glProgramUniform4fv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniform4fvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'i',
   0, // glProgramUniform4i
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'i',
   '6',
   '4',
   'A',
   'R',
   'B',
   0, // glProgramUniform4i64ARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glProgramUniform4i64NV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'i',
   '6',
   '4',
   'v',
   'A',
   'R',
   'B',
   0, // glProgramUniform4i64vARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glProgramUniform4i64vNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'i',
   'E',
   'X',
   'T',
   0, // glProgramUniform4iEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'i',
   'v',
   0, // glProgramUniform4iv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniform4ivEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'u',
   'i',
   0, // glProgramUniform4ui
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'u',
   'i',
   '6',
   '4',
   'A',
   'R',
   'B',
   0, // glProgramUniform4ui64ARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'u',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glProgramUniform4ui64NV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'u',
   'i',
   '6',
   '4',
   'v',
   'A',
   'R',
   'B',
   0, // glProgramUniform4ui64vARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'u',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glProgramUniform4ui64vNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'u',
   'i',
   'E',
   'X',
   'T',
   0, // glProgramUniform4uiEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'u',
   'i',
   'v',
   0, // glProgramUniform4uiv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniform4uivEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'u',
   'i',
   '6',
   '4',
   'A',
   'R',
   'B',
   0, // glProgramUniformHandleui64ARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'u',
   'i',
   '6',
   '4',
   'I',
   'M',
   'G',
   0, // glProgramUniformHandleui64IMG
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'u',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glProgramUniformHandleui64NV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'u',
   'i',
   '6',
   '4',
   'v',
   'A',
   'R',
   'B',
   0, // glProgramUniformHandleui64vARB
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'u',
   'i',
   '6',
   '4',
   'v',
   'I',
   'M',
   'G',
   0, // glProgramUniformHandleui64vIMG
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'u',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glProgramUniformHandleui64vNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '2',
   'd',
   'v',
   0, // glProgramUniformMatrix2dv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '2',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniformMatrix2dvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '2',
   'f',
   'v',
   0, // glProgramUniformMatrix2fv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '2',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniformMatrix2fvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '2',
   'x',
   '3',
   'd',
   'v',
   0, // glProgramUniformMatrix2x3dv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '2',
   'x',
   '3',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniformMatrix2x3dvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '2',
   'x',
   '3',
   'f',
   'v',
   0, // glProgramUniformMatrix2x3fv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '2',
   'x',
   '3',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniformMatrix2x3fvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '2',
   'x',
   '4',
   'd',
   'v',
   0, // glProgramUniformMatrix2x4dv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '2',
   'x',
   '4',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniformMatrix2x4dvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '2',
   'x',
   '4',
   'f',
   'v',
   0, // glProgramUniformMatrix2x4fv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '2',
   'x',
   '4',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniformMatrix2x4fvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '3',
   'd',
   'v',
   0, // glProgramUniformMatrix3dv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '3',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniformMatrix3dvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '3',
   'f',
   'v',
   0, // glProgramUniformMatrix3fv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '3',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniformMatrix3fvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '3',
   'x',
   '2',
   'd',
   'v',
   0, // glProgramUniformMatrix3x2dv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '3',
   'x',
   '2',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniformMatrix3x2dvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '3',
   'x',
   '2',
   'f',
   'v',
   0, // glProgramUniformMatrix3x2fv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '3',
   'x',
   '2',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniformMatrix3x2fvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '3',
   'x',
   '4',
   'd',
   'v',
   0, // glProgramUniformMatrix3x4dv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '3',
   'x',
   '4',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniformMatrix3x4dvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '3',
   'x',
   '4',
   'f',
   'v',
   0, // glProgramUniformMatrix3x4fv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '3',
   'x',
   '4',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniformMatrix3x4fvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '4',
   'd',
   'v',
   0, // glProgramUniformMatrix4dv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '4',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniformMatrix4dvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '4',
   'f',
   'v',
   0, // glProgramUniformMatrix4fv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '4',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniformMatrix4fvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '4',
   'x',
   '2',
   'd',
   'v',
   0, // glProgramUniformMatrix4x2dv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '4',
   'x',
   '2',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniformMatrix4x2dvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '4',
   'x',
   '2',
   'f',
   'v',
   0, // glProgramUniformMatrix4x2fv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '4',
   'x',
   '2',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniformMatrix4x2fvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '4',
   'x',
   '3',
   'd',
   'v',
   0, // glProgramUniformMatrix4x3dv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '4',
   'x',
   '3',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniformMatrix4x3dvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '4',
   'x',
   '3',
   'f',
   'v',
   0, // glProgramUniformMatrix4x3fv
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '4',
   'x',
   '3',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glProgramUniformMatrix4x3fvEXT
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'u',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glProgramUniformui64NV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'u',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glProgramUniformui64vNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'L',
   'i',
   'm',
   'i',
   't',
   'N',
   'V',
   0, // glProgramVertexLimitNV
   'g',
   'l',
   'P',
   'r',
   'o',
   'v',
   'o',
   'k',
   'i',
   'n',
   'g',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   0, // glProvokingVertex
   'g',
   'l',
   'P',
   'r',
   'o',
   'v',
   'o',
   'k',
   'i',
   'n',
   'g',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'E',
   'X',
   'T',
   0, // glProvokingVertexEXT
   'g',
   'l',
   'P',
   'u',
   's',
   'h',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   0, // glPushAttrib
   'g',
   'l',
   'P',
   'u',
   's',
   'h',
   'C',
   'l',
   'i',
   'e',
   'n',
   't',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   0, // glPushClientAttrib
   'g',
   'l',
   'P',
   'u',
   's',
   'h',
   'C',
   'l',
   'i',
   'e',
   'n',
   't',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'D',
   'e',
   'f',
   'a',
   'u',
   'l',
   't',
   'E',
   'X',
   'T',
   0, // glPushClientAttribDefaultEXT
   'g',
   'l',
   'P',
   'u',
   's',
   'h',
   'D',
   'e',
   'b',
   'u',
   'g',
   'G',
   'r',
   'o',
   'u',
   'p',
   0, // glPushDebugGroup
   'g',
   'l',
   'P',
   'u',
   's',
   'h',
   'D',
   'e',
   'b',
   'u',
   'g',
   'G',
   'r',
   'o',
   'u',
   'p',
   'K',
   'H',
   'R',
   0, // glPushDebugGroupKHR
   'g',
   'l',
   'P',
   'u',
   's',
   'h',
   'G',
   'r',
   'o',
   'u',
   'p',
   'M',
   'a',
   'r',
   'k',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glPushGroupMarkerEXT
   'g',
   'l',
   'P',
   'u',
   's',
   'h',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   0, // glPushMatrix
   'g',
   'l',
   'P',
   'u',
   's',
   'h',
   'N',
   'a',
   'm',
   'e',
   0, // glPushName
   'g',
   'l',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'C',
   'o',
   'u',
   'n',
   't',
   'e',
   'r',
   0, // glQueryCounter
   'g',
   'l',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'C',
   'o',
   'u',
   'n',
   't',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glQueryCounterEXT
   'g',
   'l',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'x',
   'O',
   'E',
   'S',
   0, // glQueryMatrixxOES
   'g',
   'l',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'u',
   'i',
   'A',
   'M',
   'D',
   0, // glQueryObjectParameteruiAMD
   'g',
   'l',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'R',
   'e',
   's',
   'o',
   'u',
   'r',
   'c',
   'e',
   'N',
   'V',
   0, // glQueryResourceNV
   'g',
   'l',
   'Q',
   'u',
   'e',
   'r',
   'y',
   'R',
   'e',
   's',
   'o',
   'u',
   'r',
   'c',
   'e',
   'T',
   'a',
   'g',
   'N',
   'V',
   0, // glQueryResourceTagNV
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '2',
   'd',
   0, // glRasterPos2d
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '2',
   'd',
   'v',
   0, // glRasterPos2dv
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '2',
   'f',
   0, // glRasterPos2f
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '2',
   'f',
   'v',
   0, // glRasterPos2fv
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '2',
   'i',
   0, // glRasterPos2i
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '2',
   'i',
   'v',
   0, // glRasterPos2iv
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '2',
   's',
   0, // glRasterPos2s
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '2',
   's',
   'v',
   0, // glRasterPos2sv
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '2',
   'x',
   'O',
   'E',
   'S',
   0, // glRasterPos2xOES
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '2',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glRasterPos2xvOES
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '3',
   'd',
   0, // glRasterPos3d
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '3',
   'd',
   'v',
   0, // glRasterPos3dv
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '3',
   'f',
   0, // glRasterPos3f
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '3',
   'f',
   'v',
   0, // glRasterPos3fv
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '3',
   'i',
   0, // glRasterPos3i
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '3',
   'i',
   'v',
   0, // glRasterPos3iv
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '3',
   's',
   0, // glRasterPos3s
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '3',
   's',
   'v',
   0, // glRasterPos3sv
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '3',
   'x',
   'O',
   'E',
   'S',
   0, // glRasterPos3xOES
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '3',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glRasterPos3xvOES
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '4',
   'd',
   0, // glRasterPos4d
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '4',
   'd',
   'v',
   0, // glRasterPos4dv
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '4',
   'f',
   0, // glRasterPos4f
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '4',
   'f',
   'v',
   0, // glRasterPos4fv
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '4',
   'i',
   0, // glRasterPos4i
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '4',
   'i',
   'v',
   0, // glRasterPos4iv
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '4',
   's',
   0, // glRasterPos4s
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '4',
   's',
   'v',
   0, // glRasterPos4sv
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '4',
   'x',
   'O',
   'E',
   'S',
   0, // glRasterPos4xOES
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'P',
   'o',
   's',
   '4',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glRasterPos4xvOES
   'g',
   'l',
   'R',
   'a',
   's',
   't',
   'e',
   'r',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   's',
   'E',
   'X',
   'T',
   0, // glRasterSamplesEXT
   'g',
   'l',
   'R',
   'e',
   'a',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glReadBuffer
   'g',
   'l',
   'R',
   'e',
   'a',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'E',
   'X',
   'T',
   0, // glReadBufferIndexedEXT
   'g',
   'l',
   'R',
   'e',
   'a',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'N',
   'V',
   0, // glReadBufferNV
   'g',
   'l',
   'R',
   'e',
   'a',
   'd',
   'I',
   'n',
   's',
   't',
   'r',
   'u',
   'm',
   'e',
   'n',
   't',
   's',
   'S',
   'G',
   'I',
   'X',
   0, // glReadInstrumentsSGIX
   'g',
   'l',
   'R',
   'e',
   'a',
   'd',
   'P',
   'i',
   'x',
   'e',
   'l',
   's',
   0, // glReadPixels
   'g',
   'l',
   'R',
   'e',
   'a',
   'd',
   'n',
   'P',
   'i',
   'x',
   'e',
   'l',
   's',
   0, // glReadnPixels
   'g',
   'l',
   'R',
   'e',
   'a',
   'd',
   'n',
   'P',
   'i',
   'x',
   'e',
   'l',
   's',
   'A',
   'R',
   'B',
   0, // glReadnPixelsARB
   'g',
   'l',
   'R',
   'e',
   'a',
   'd',
   'n',
   'P',
   'i',
   'x',
   'e',
   'l',
   's',
   'E',
   'X',
   'T',
   0, // glReadnPixelsEXT
   'g',
   'l',
   'R',
   'e',
   'a',
   'd',
   'n',
   'P',
   'i',
   'x',
   'e',
   'l',
   's',
   'K',
   'H',
   'R',
   0, // glReadnPixelsKHR
   'g',
   'l',
   'R',
   'e',
   'c',
   't',
   'd',
   0, // glRectd
   'g',
   'l',
   'R',
   'e',
   'c',
   't',
   'd',
   'v',
   0, // glRectdv
   'g',
   'l',
   'R',
   'e',
   'c',
   't',
   'f',
   0, // glRectf
   'g',
   'l',
   'R',
   'e',
   'c',
   't',
   'f',
   'v',
   0, // glRectfv
   'g',
   'l',
   'R',
   'e',
   'c',
   't',
   'i',
   0, // glRecti
   'g',
   'l',
   'R',
   'e',
   'c',
   't',
   'i',
   'v',
   0, // glRectiv
   'g',
   'l',
   'R',
   'e',
   'c',
   't',
   's',
   0, // glRects
   'g',
   'l',
   'R',
   'e',
   'c',
   't',
   's',
   'v',
   0, // glRectsv
   'g',
   'l',
   'R',
   'e',
   'c',
   't',
   'x',
   'O',
   'E',
   'S',
   0, // glRectxOES
   'g',
   'l',
   'R',
   'e',
   'c',
   't',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glRectxvOES
   'g',
   'l',
   'R',
   'e',
   'f',
   'e',
   'r',
   'e',
   'n',
   'c',
   'e',
   'P',
   'l',
   'a',
   'n',
   'e',
   'S',
   'G',
   'I',
   'X',
   0, // glReferencePlaneSGIX
   'g',
   'l',
   'R',
   'e',
   'l',
   'e',
   'a',
   's',
   'e',
   'K',
   'e',
   'y',
   'e',
   'd',
   'M',
   'u',
   't',
   'e',
   'x',
   'W',
   'i',
   'n',
   '3',
   '2',
   'E',
   'X',
   'T',
   0, // glReleaseKeyedMutexWin32EXT
   'g',
   'l',
   'R',
   'e',
   'l',
   'e',
   'a',
   's',
   'e',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'C',
   'o',
   'm',
   'p',
   'i',
   'l',
   'e',
   'r',
   0, // glReleaseShaderCompiler
   'g',
   'l',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'G',
   'p',
   'u',
   'M',
   'a',
   's',
   'k',
   'N',
   'V',
   0, // glRenderGpuMaskNV
   'g',
   'l',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'M',
   'o',
   'd',
   'e',
   0, // glRenderMode
   'g',
   'l',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   0, // glRenderbufferStorage
   'g',
   'l',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'E',
   'X',
   'T',
   0, // glRenderbufferStorageEXT
   'g',
   'l',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   0, // glRenderbufferStorageMultisample
   'g',
   'l',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'A',
   'N',
   'G',
   'L',
   'E',
   0, // glRenderbufferStorageMultisampleANGLE
   'g',
   'l',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glRenderbufferStorageMultisampleAPPLE
   'g',
   'l',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'C',
   'o',
   'v',
   'e',
   'r',
   'a',
   'g',
   'e',
   'N',
   'V',
   0, // glRenderbufferStorageMultisampleCoverageNV
   'g',
   'l',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'E',
   'X',
   'T',
   0, // glRenderbufferStorageMultisampleEXT
   'g',
   'l',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'I',
   'M',
   'G',
   0, // glRenderbufferStorageMultisampleIMG
   'g',
   'l',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'N',
   'V',
   0, // glRenderbufferStorageMultisampleNV
   'g',
   'l',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'O',
   'E',
   'S',
   0, // glRenderbufferStorageOES
   'g',
   'l',
   'R',
   'e',
   'p',
   'l',
   'a',
   'c',
   'e',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'd',
   'e',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'S',
   'U',
   'N',
   0, // glReplacementCodePointerSUN
   'g',
   'l',
   'R',
   'e',
   'p',
   'l',
   'a',
   'c',
   'e',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'd',
   'e',
   'u',
   'b',
   'S',
   'U',
   'N',
   0, // glReplacementCodeubSUN
   'g',
   'l',
   'R',
   'e',
   'p',
   'l',
   'a',
   'c',
   'e',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'd',
   'e',
   'u',
   'b',
   'v',
   'S',
   'U',
   'N',
   0, // glReplacementCodeubvSUN
   'g',
   'l',
   'R',
   'e',
   'p',
   'l',
   'a',
   'c',
   'e',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'd',
   'e',
   'u',
   'i',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'S',
   'U',
   'N',
   0, // glReplacementCodeuiColor3fVertex3fSUN
   'g',
   'l',
   'R',
   'e',
   'p',
   'l',
   'a',
   'c',
   'e',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'd',
   'e',
   'u',
   'i',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'v',
   'S',
   'U',
   'N',
   0, // glReplacementCodeuiColor3fVertex3fvSUN
   'g',
   'l',
   'R',
   'e',
   'p',
   'l',
   'a',
   'c',
   'e',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'd',
   'e',
   'u',
   'i',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'f',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'S',
   'U',
   'N',
   0, // glReplacementCodeuiColor4fNormal3fVertex3fSUN
   'g',
   'l',
   'R',
   'e',
   'p',
   'l',
   'a',
   'c',
   'e',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'd',
   'e',
   'u',
   'i',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'f',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'v',
   'S',
   'U',
   'N',
   0, // glReplacementCodeuiColor4fNormal3fVertex3fvSUN
   'g',
   'l',
   'R',
   'e',
   'p',
   'l',
   'a',
   'c',
   'e',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'd',
   'e',
   'u',
   'i',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'u',
   'b',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'S',
   'U',
   'N',
   0, // glReplacementCodeuiColor4ubVertex3fSUN
   'g',
   'l',
   'R',
   'e',
   'p',
   'l',
   'a',
   'c',
   'e',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'd',
   'e',
   'u',
   'i',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'u',
   'b',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'v',
   'S',
   'U',
   'N',
   0, // glReplacementCodeuiColor4ubVertex3fvSUN
   'g',
   'l',
   'R',
   'e',
   'p',
   'l',
   'a',
   'c',
   'e',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'd',
   'e',
   'u',
   'i',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'S',
   'U',
   'N',
   0, // glReplacementCodeuiNormal3fVertex3fSUN
   'g',
   'l',
   'R',
   'e',
   'p',
   'l',
   'a',
   'c',
   'e',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'd',
   'e',
   'u',
   'i',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'v',
   'S',
   'U',
   'N',
   0, // glReplacementCodeuiNormal3fVertex3fvSUN
   'g',
   'l',
   'R',
   'e',
   'p',
   'l',
   'a',
   'c',
   'e',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'd',
   'e',
   'u',
   'i',
   'S',
   'U',
   'N',
   0, // glReplacementCodeuiSUN
   'g',
   'l',
   'R',
   'e',
   'p',
   'l',
   'a',
   'c',
   'e',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'd',
   'e',
   'u',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'f',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'f',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'S',
   'U',
   'N',
   0, // glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN
   'g',
   'l',
   'R',
   'e',
   'p',
   'l',
   'a',
   'c',
   'e',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'd',
   'e',
   'u',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'f',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'f',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'v',
   'S',
   'U',
   'N',
   0, // glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN
   'g',
   'l',
   'R',
   'e',
   'p',
   'l',
   'a',
   'c',
   'e',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'd',
   'e',
   'u',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'f',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'S',
   'U',
   'N',
   0, // glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN
   'g',
   'l',
   'R',
   'e',
   'p',
   'l',
   'a',
   'c',
   'e',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'd',
   'e',
   'u',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'f',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'v',
   'S',
   'U',
   'N',
   0, // glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN
   'g',
   'l',
   'R',
   'e',
   'p',
   'l',
   'a',
   'c',
   'e',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'd',
   'e',
   'u',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'S',
   'U',
   'N',
   0, // glReplacementCodeuiTexCoord2fVertex3fSUN
   'g',
   'l',
   'R',
   'e',
   'p',
   'l',
   'a',
   'c',
   'e',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'd',
   'e',
   'u',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'v',
   'S',
   'U',
   'N',
   0, // glReplacementCodeuiTexCoord2fVertex3fvSUN
   'g',
   'l',
   'R',
   'e',
   'p',
   'l',
   'a',
   'c',
   'e',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'd',
   'e',
   'u',
   'i',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'S',
   'U',
   'N',
   0, // glReplacementCodeuiVertex3fSUN
   'g',
   'l',
   'R',
   'e',
   'p',
   'l',
   'a',
   'c',
   'e',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'd',
   'e',
   'u',
   'i',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'v',
   'S',
   'U',
   'N',
   0, // glReplacementCodeuiVertex3fvSUN
   'g',
   'l',
   'R',
   'e',
   'p',
   'l',
   'a',
   'c',
   'e',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'd',
   'e',
   'u',
   'i',
   'v',
   'S',
   'U',
   'N',
   0, // glReplacementCodeuivSUN
   'g',
   'l',
   'R',
   'e',
   'p',
   'l',
   'a',
   'c',
   'e',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'd',
   'e',
   'u',
   's',
   'S',
   'U',
   'N',
   0, // glReplacementCodeusSUN
   'g',
   'l',
   'R',
   'e',
   'p',
   'l',
   'a',
   'c',
   'e',
   'm',
   'e',
   'n',
   't',
   'C',
   'o',
   'd',
   'e',
   'u',
   's',
   'v',
   'S',
   'U',
   'N',
   0, // glReplacementCodeusvSUN
   'g',
   'l',
   'R',
   'e',
   'q',
   'u',
   'e',
   's',
   't',
   'R',
   'e',
   's',
   'i',
   'd',
   'e',
   'n',
   't',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   's',
   'N',
   'V',
   0, // glRequestResidentProgramsNV
   'g',
   'l',
   'R',
   'e',
   's',
   'e',
   't',
   'H',
   'i',
   's',
   't',
   'o',
   'g',
   'r',
   'a',
   'm',
   0, // glResetHistogram
   'g',
   'l',
   'R',
   'e',
   's',
   'e',
   't',
   'H',
   'i',
   's',
   't',
   'o',
   'g',
   'r',
   'a',
   'm',
   'E',
   'X',
   'T',
   0, // glResetHistogramEXT
   'g',
   'l',
   'R',
   'e',
   's',
   'e',
   't',
   'M',
   'i',
   'n',
   'm',
   'a',
   'x',
   0, // glResetMinmax
   'g',
   'l',
   'R',
   'e',
   's',
   'e',
   't',
   'M',
   'i',
   'n',
   'm',
   'a',
   'x',
   'E',
   'X',
   'T',
   0, // glResetMinmaxEXT
   'g',
   'l',
   'R',
   'e',
   's',
   'i',
   'z',
   'e',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   'M',
   'E',
   'S',
   'A',
   0, // glResizeBuffersMESA
   'g',
   'l',
   'R',
   'e',
   's',
   'o',
   'l',
   'v',
   'e',
   'D',
   'e',
   'p',
   't',
   'h',
   'V',
   'a',
   'l',
   'u',
   'e',
   's',
   'N',
   'V',
   0, // glResolveDepthValuesNV
   'g',
   'l',
   'R',
   'e',
   's',
   'o',
   'l',
   'v',
   'e',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'F',
   'r',
   'a',
   'm',
   'e',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glResolveMultisampleFramebufferAPPLE
   'g',
   'l',
   'R',
   'e',
   's',
   'u',
   'm',
   'e',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   0, // glResumeTransformFeedback
   'g',
   'l',
   'R',
   'e',
   's',
   'u',
   'm',
   'e',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'N',
   'V',
   0, // glResumeTransformFeedbackNV
   'g',
   'l',
   'R',
   'o',
   't',
   'a',
   't',
   'e',
   'd',
   0, // glRotated
   'g',
   'l',
   'R',
   'o',
   't',
   'a',
   't',
   'e',
   'f',
   0, // glRotatef
   'g',
   'l',
   'R',
   'o',
   't',
   'a',
   't',
   'e',
   'x',
   0, // glRotatex
   'g',
   'l',
   'R',
   'o',
   't',
   'a',
   't',
   'e',
   'x',
   'O',
   'E',
   'S',
   0, // glRotatexOES
   'g',
   'l',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'C',
   'o',
   'v',
   'e',
   'r',
   'a',
   'g',
   'e',
   0, // glSampleCoverage
   'g',
   'l',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'C',
   'o',
   'v',
   'e',
   'r',
   'a',
   'g',
   'e',
   'A',
   'R',
   'B',
   0, // glSampleCoverageARB
   'g',
   'l',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'C',
   'o',
   'v',
   'e',
   'r',
   'a',
   'g',
   'e',
   'x',
   0, // glSampleCoveragex
   'g',
   'l',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'C',
   'o',
   'v',
   'e',
   'r',
   'a',
   'g',
   'e',
   'x',
   'O',
   'E',
   'S',
   0, // glSampleCoveragexOES
   'g',
   'l',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'M',
   'a',
   'p',
   'A',
   'T',
   'I',
   0, // glSampleMapATI
   'g',
   'l',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'M',
   'a',
   's',
   'k',
   'E',
   'X',
   'T',
   0, // glSampleMaskEXT
   'g',
   'l',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'M',
   'a',
   's',
   'k',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'N',
   'V',
   0, // glSampleMaskIndexedNV
   'g',
   'l',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'M',
   'a',
   's',
   'k',
   'S',
   'G',
   'I',
   'S',
   0, // glSampleMaskSGIS
   'g',
   'l',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'M',
   'a',
   's',
   'k',
   'i',
   0, // glSampleMaski
   'g',
   'l',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'P',
   'a',
   't',
   't',
   'e',
   'r',
   'n',
   'E',
   'X',
   'T',
   0, // glSamplePatternEXT
   'g',
   'l',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'P',
   'a',
   't',
   't',
   'e',
   'r',
   'n',
   'S',
   'G',
   'I',
   'S',
   0, // glSamplePatternSGIS
   'g',
   'l',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'i',
   'v',
   0, // glSamplerParameterIiv
   'g',
   'l',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glSamplerParameterIivEXT
   'g',
   'l',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'i',
   'v',
   'O',
   'E',
   'S',
   0, // glSamplerParameterIivOES
   'g',
   'l',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'u',
   'i',
   'v',
   0, // glSamplerParameterIuiv
   'g',
   'l',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glSamplerParameterIuivEXT
   'g',
   'l',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'u',
   'i',
   'v',
   'O',
   'E',
   'S',
   0, // glSamplerParameterIuivOES
   'g',
   'l',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   0, // glSamplerParameterf
   'g',
   'l',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   0, // glSamplerParameterfv
   'g',
   'l',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   0, // glSamplerParameteri
   'g',
   'l',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'r',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   0, // glSamplerParameteriv
   'g',
   'l',
   'S',
   'c',
   'a',
   'l',
   'e',
   'd',
   0, // glScaled
   'g',
   'l',
   'S',
   'c',
   'a',
   'l',
   'e',
   'f',
   0, // glScalef
   'g',
   'l',
   'S',
   'c',
   'a',
   'l',
   'e',
   'x',
   0, // glScalex
   'g',
   'l',
   'S',
   'c',
   'a',
   'l',
   'e',
   'x',
   'O',
   'E',
   'S',
   0, // glScalexOES
   'g',
   'l',
   'S',
   'c',
   'i',
   's',
   's',
   'o',
   'r',
   0, // glScissor
   'g',
   'l',
   'S',
   'c',
   'i',
   's',
   's',
   'o',
   'r',
   'A',
   'r',
   'r',
   'a',
   'y',
   'v',
   0, // glScissorArrayv
   'g',
   'l',
   'S',
   'c',
   'i',
   's',
   's',
   'o',
   'r',
   'A',
   'r',
   'r',
   'a',
   'y',
   'v',
   'N',
   'V',
   0, // glScissorArrayvNV
   'g',
   'l',
   'S',
   'c',
   'i',
   's',
   's',
   'o',
   'r',
   'A',
   'r',
   'r',
   'a',
   'y',
   'v',
   'O',
   'E',
   'S',
   0, // glScissorArrayvOES
   'g',
   'l',
   'S',
   'c',
   'i',
   's',
   's',
   'o',
   'r',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   0, // glScissorIndexed
   'g',
   'l',
   'S',
   'c',
   'i',
   's',
   's',
   'o',
   'r',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'N',
   'V',
   0, // glScissorIndexedNV
   'g',
   'l',
   'S',
   'c',
   'i',
   's',
   's',
   'o',
   'r',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'O',
   'E',
   'S',
   0, // glScissorIndexedOES
   'g',
   'l',
   'S',
   'c',
   'i',
   's',
   's',
   'o',
   'r',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'v',
   0, // glScissorIndexedv
   'g',
   'l',
   'S',
   'c',
   'i',
   's',
   's',
   'o',
   'r',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'v',
   'N',
   'V',
   0, // glScissorIndexedvNV
   'g',
   'l',
   'S',
   'c',
   'i',
   's',
   's',
   'o',
   'r',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'v',
   'O',
   'E',
   'S',
   0, // glScissorIndexedvOES
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'b',
   0, // glSecondaryColor3b
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'b',
   'E',
   'X',
   'T',
   0, // glSecondaryColor3bEXT
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'b',
   'v',
   0, // glSecondaryColor3bv
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'b',
   'v',
   'E',
   'X',
   'T',
   0, // glSecondaryColor3bvEXT
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'd',
   0, // glSecondaryColor3d
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'd',
   'E',
   'X',
   'T',
   0, // glSecondaryColor3dEXT
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'd',
   'v',
   0, // glSecondaryColor3dv
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glSecondaryColor3dvEXT
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'f',
   0, // glSecondaryColor3f
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'f',
   'E',
   'X',
   'T',
   0, // glSecondaryColor3fEXT
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'f',
   'v',
   0, // glSecondaryColor3fv
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glSecondaryColor3fvEXT
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'h',
   'N',
   'V',
   0, // glSecondaryColor3hNV
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'h',
   'v',
   'N',
   'V',
   0, // glSecondaryColor3hvNV
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'i',
   0, // glSecondaryColor3i
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'i',
   'E',
   'X',
   'T',
   0, // glSecondaryColor3iEXT
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'i',
   'v',
   0, // glSecondaryColor3iv
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glSecondaryColor3ivEXT
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   's',
   0, // glSecondaryColor3s
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   's',
   'E',
   'X',
   'T',
   0, // glSecondaryColor3sEXT
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   's',
   'v',
   0, // glSecondaryColor3sv
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   's',
   'v',
   'E',
   'X',
   'T',
   0, // glSecondaryColor3svEXT
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'u',
   'b',
   0, // glSecondaryColor3ub
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'u',
   'b',
   'E',
   'X',
   'T',
   0, // glSecondaryColor3ubEXT
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'u',
   'b',
   'v',
   0, // glSecondaryColor3ubv
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'u',
   'b',
   'v',
   'E',
   'X',
   'T',
   0, // glSecondaryColor3ubvEXT
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'u',
   'i',
   0, // glSecondaryColor3ui
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'u',
   'i',
   'E',
   'X',
   'T',
   0, // glSecondaryColor3uiEXT
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'u',
   'i',
   'v',
   0, // glSecondaryColor3uiv
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glSecondaryColor3uivEXT
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'u',
   's',
   0, // glSecondaryColor3us
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'u',
   's',
   'E',
   'X',
   'T',
   0, // glSecondaryColor3usEXT
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'u',
   's',
   'v',
   0, // glSecondaryColor3usv
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'u',
   's',
   'v',
   'E',
   'X',
   'T',
   0, // glSecondaryColor3usvEXT
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   'F',
   'o',
   'r',
   'm',
   'a',
   't',
   'N',
   'V',
   0, // glSecondaryColorFormatNV
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   'P',
   '3',
   'u',
   'i',
   0, // glSecondaryColorP3ui
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   'P',
   '3',
   'u',
   'i',
   'v',
   0, // glSecondaryColorP3uiv
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   0, // glSecondaryColorPointer
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glSecondaryColorPointerEXT
   'g',
   'l',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'L',
   'i',
   's',
   't',
   'I',
   'B',
   'M',
   0, // glSecondaryColorPointerListIBM
   'g',
   'l',
   'S',
   'e',
   'l',
   'e',
   'c',
   't',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glSelectBuffer
   'g',
   'l',
   'S',
   'e',
   'l',
   'e',
   'c',
   't',
   'P',
   'e',
   'r',
   'f',
   'M',
   'o',
   'n',
   'i',
   't',
   'o',
   'r',
   'C',
   'o',
   'u',
   'n',
   't',
   'e',
   'r',
   's',
   'A',
   'M',
   'D',
   0, // glSelectPerfMonitorCountersAMD
   'g',
   'l',
   'S',
   'e',
   'm',
   'a',
   'p',
   'h',
   'o',
   'r',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'u',
   'i',
   '6',
   '4',
   'v',
   'E',
   'X',
   'T',
   0, // glSemaphoreParameterui64vEXT
   'g',
   'l',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   'b',
   'l',
   'e',
   'F',
   'i',
   'l',
   't',
   'e',
   'r',
   '2',
   'D',
   0, // glSeparableFilter2D
   'g',
   'l',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   'b',
   'l',
   'e',
   'F',
   'i',
   'l',
   't',
   'e',
   'r',
   '2',
   'D',
   'E',
   'X',
   'T',
   0, // glSeparableFilter2DEXT
   'g',
   'l',
   'S',
   'e',
   't',
   'F',
   'e',
   'n',
   'c',
   'e',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glSetFenceAPPLE
   'g',
   'l',
   'S',
   'e',
   't',
   'F',
   'e',
   'n',
   'c',
   'e',
   'N',
   'V',
   0, // glSetFenceNV
   'g',
   'l',
   'S',
   'e',
   't',
   'F',
   'r',
   'a',
   'g',
   'm',
   'e',
   'n',
   't',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'C',
   'o',
   'n',
   's',
   't',
   'a',
   'n',
   't',
   'A',
   'T',
   'I',
   0, // glSetFragmentShaderConstantATI
   'g',
   'l',
   'S',
   'e',
   't',
   'I',
   'n',
   'v',
   'a',
   'r',
   'i',
   'a',
   'n',
   't',
   'E',
   'X',
   'T',
   0, // glSetInvariantEXT
   'g',
   'l',
   'S',
   'e',
   't',
   'L',
   'o',
   'c',
   'a',
   'l',
   'C',
   'o',
   'n',
   's',
   't',
   'a',
   'n',
   't',
   'E',
   'X',
   'T',
   0, // glSetLocalConstantEXT
   'g',
   'l',
   'S',
   'e',
   't',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'f',
   'v',
   'A',
   'M',
   'D',
   0, // glSetMultisamplefvAMD
   'g',
   'l',
   'S',
   'h',
   'a',
   'd',
   'e',
   'M',
   'o',
   'd',
   'e',
   'l',
   0, // glShadeModel
   'g',
   'l',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'B',
   'i',
   'n',
   'a',
   'r',
   'y',
   0, // glShaderBinary
   'g',
   'l',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'O',
   'p',
   '1',
   'E',
   'X',
   'T',
   0, // glShaderOp1EXT
   'g',
   'l',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'O',
   'p',
   '2',
   'E',
   'X',
   'T',
   0, // glShaderOp2EXT
   'g',
   'l',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'O',
   'p',
   '3',
   'E',
   'X',
   'T',
   0, // glShaderOp3EXT
   'g',
   'l',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'S',
   'o',
   'u',
   'r',
   'c',
   'e',
   0, // glShaderSource
   'g',
   'l',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'S',
   'o',
   'u',
   'r',
   'c',
   'e',
   'A',
   'R',
   'B',
   0, // glShaderSourceARB
   'g',
   'l',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'B',
   'l',
   'o',
   'c',
   'k',
   'B',
   'i',
   'n',
   'd',
   'i',
   'n',
   'g',
   0, // glShaderStorageBlockBinding
   'g',
   'l',
   'S',
   'h',
   'a',
   'r',
   'p',
   'e',
   'n',
   'T',
   'e',
   'x',
   'F',
   'u',
   'n',
   'c',
   'S',
   'G',
   'I',
   'S',
   0, // glSharpenTexFuncSGIS
   'g',
   'l',
   'S',
   'i',
   'g',
   'n',
   'a',
   'l',
   'S',
   'e',
   'm',
   'a',
   'p',
   'h',
   'o',
   'r',
   'e',
   'E',
   'X',
   'T',
   0, // glSignalSemaphoreEXT
   'g',
   'l',
   'S',
   'i',
   'g',
   'n',
   'a',
   'l',
   'V',
   'k',
   'F',
   'e',
   'n',
   'c',
   'e',
   'N',
   'V',
   0, // glSignalVkFenceNV
   'g',
   'l',
   'S',
   'i',
   'g',
   'n',
   'a',
   'l',
   'V',
   'k',
   'S',
   'e',
   'm',
   'a',
   'p',
   'h',
   'o',
   'r',
   'e',
   'N',
   'V',
   0, // glSignalVkSemaphoreNV
   'g',
   'l',
   'S',
   'p',
   'e',
   'c',
   'i',
   'a',
   'l',
   'i',
   'z',
   'e',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   0, // glSpecializeShader
   'g',
   'l',
   'S',
   'p',
   'e',
   'c',
   'i',
   'a',
   'l',
   'i',
   'z',
   'e',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'A',
   'R',
   'B',
   0, // glSpecializeShaderARB
   'g',
   'l',
   'S',
   'p',
   'r',
   'i',
   't',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'S',
   'G',
   'I',
   'X',
   0, // glSpriteParameterfSGIX
   'g',
   'l',
   'S',
   'p',
   'r',
   'i',
   't',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'S',
   'G',
   'I',
   'X',
   0, // glSpriteParameterfvSGIX
   'g',
   'l',
   'S',
   'p',
   'r',
   'i',
   't',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'S',
   'G',
   'I',
   'X',
   0, // glSpriteParameteriSGIX
   'g',
   'l',
   'S',
   'p',
   'r',
   'i',
   't',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'S',
   'G',
   'I',
   'X',
   0, // glSpriteParameterivSGIX
   'g',
   'l',
   'S',
   't',
   'a',
   'r',
   't',
   'I',
   'n',
   's',
   't',
   'r',
   'u',
   'm',
   'e',
   'n',
   't',
   's',
   'S',
   'G',
   'I',
   'X',
   0, // glStartInstrumentsSGIX
   'g',
   'l',
   'S',
   't',
   'a',
   'r',
   't',
   'T',
   'i',
   'l',
   'i',
   'n',
   'g',
   'Q',
   'C',
   'O',
   'M',
   0, // glStartTilingQCOM
   'g',
   'l',
   'S',
   't',
   'a',
   't',
   'e',
   'C',
   'a',
   'p',
   't',
   'u',
   'r',
   'e',
   'N',
   'V',
   0, // glStateCaptureNV
   'g',
   'l',
   'S',
   't',
   'e',
   'n',
   'c',
   'i',
   'l',
   'C',
   'l',
   'e',
   'a',
   'r',
   'T',
   'a',
   'g',
   'E',
   'X',
   'T',
   0, // glStencilClearTagEXT
   'g',
   'l',
   'S',
   't',
   'e',
   'n',
   'c',
   'i',
   'l',
   'F',
   'i',
   'l',
   'l',
   'P',
   'a',
   't',
   'h',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   'N',
   'V',
   0, // glStencilFillPathInstancedNV
   'g',
   'l',
   'S',
   't',
   'e',
   'n',
   'c',
   'i',
   'l',
   'F',
   'i',
   'l',
   'l',
   'P',
   'a',
   't',
   'h',
   'N',
   'V',
   0, // glStencilFillPathNV
   'g',
   'l',
   'S',
   't',
   'e',
   'n',
   'c',
   'i',
   'l',
   'F',
   'u',
   'n',
   'c',
   0, // glStencilFunc
   'g',
   'l',
   'S',
   't',
   'e',
   'n',
   'c',
   'i',
   'l',
   'F',
   'u',
   'n',
   'c',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   't',
   'e',
   0, // glStencilFuncSeparate
   'g',
   'l',
   'S',
   't',
   'e',
   'n',
   'c',
   'i',
   'l',
   'F',
   'u',
   'n',
   'c',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   't',
   'e',
   'A',
   'T',
   'I',
   0, // glStencilFuncSeparateATI
   'g',
   'l',
   'S',
   't',
   'e',
   'n',
   'c',
   'i',
   'l',
   'M',
   'a',
   's',
   'k',
   0, // glStencilMask
   'g',
   'l',
   'S',
   't',
   'e',
   'n',
   'c',
   'i',
   'l',
   'M',
   'a',
   's',
   'k',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   't',
   'e',
   0, // glStencilMaskSeparate
   'g',
   'l',
   'S',
   't',
   'e',
   'n',
   'c',
   'i',
   'l',
   'O',
   'p',
   0, // glStencilOp
   'g',
   'l',
   'S',
   't',
   'e',
   'n',
   'c',
   'i',
   'l',
   'O',
   'p',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   't',
   'e',
   0, // glStencilOpSeparate
   'g',
   'l',
   'S',
   't',
   'e',
   'n',
   'c',
   'i',
   'l',
   'O',
   'p',
   'S',
   'e',
   'p',
   'a',
   'r',
   'a',
   't',
   'e',
   'A',
   'T',
   'I',
   0, // glStencilOpSeparateATI
   'g',
   'l',
   'S',
   't',
   'e',
   'n',
   'c',
   'i',
   'l',
   'O',
   'p',
   'V',
   'a',
   'l',
   'u',
   'e',
   'A',
   'M',
   'D',
   0, // glStencilOpValueAMD
   'g',
   'l',
   'S',
   't',
   'e',
   'n',
   'c',
   'i',
   'l',
   'S',
   't',
   'r',
   'o',
   'k',
   'e',
   'P',
   'a',
   't',
   'h',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   'N',
   'V',
   0, // glStencilStrokePathInstancedNV
   'g',
   'l',
   'S',
   't',
   'e',
   'n',
   'c',
   'i',
   'l',
   'S',
   't',
   'r',
   'o',
   'k',
   'e',
   'P',
   'a',
   't',
   'h',
   'N',
   'V',
   0, // glStencilStrokePathNV
   'g',
   'l',
   'S',
   't',
   'e',
   'n',
   'c',
   'i',
   'l',
   'T',
   'h',
   'e',
   'n',
   'C',
   'o',
   'v',
   'e',
   'r',
   'F',
   'i',
   'l',
   'l',
   'P',
   'a',
   't',
   'h',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   'N',
   'V',
   0, // glStencilThenCoverFillPathInstancedNV
   'g',
   'l',
   'S',
   't',
   'e',
   'n',
   'c',
   'i',
   'l',
   'T',
   'h',
   'e',
   'n',
   'C',
   'o',
   'v',
   'e',
   'r',
   'F',
   'i',
   'l',
   'l',
   'P',
   'a',
   't',
   'h',
   'N',
   'V',
   0, // glStencilThenCoverFillPathNV
   'g',
   'l',
   'S',
   't',
   'e',
   'n',
   'c',
   'i',
   'l',
   'T',
   'h',
   'e',
   'n',
   'C',
   'o',
   'v',
   'e',
   'r',
   'S',
   't',
   'r',
   'o',
   'k',
   'e',
   'P',
   'a',
   't',
   'h',
   'I',
   'n',
   's',
   't',
   'a',
   'n',
   'c',
   'e',
   'd',
   'N',
   'V',
   0, // glStencilThenCoverStrokePathInstancedNV
   'g',
   'l',
   'S',
   't',
   'e',
   'n',
   'c',
   'i',
   'l',
   'T',
   'h',
   'e',
   'n',
   'C',
   'o',
   'v',
   'e',
   'r',
   'S',
   't',
   'r',
   'o',
   'k',
   'e',
   'P',
   'a',
   't',
   'h',
   'N',
   'V',
   0, // glStencilThenCoverStrokePathNV
   'g',
   'l',
   'S',
   't',
   'o',
   'p',
   'I',
   'n',
   's',
   't',
   'r',
   'u',
   'm',
   'e',
   'n',
   't',
   's',
   'S',
   'G',
   'I',
   'X',
   0, // glStopInstrumentsSGIX
   'g',
   'l',
   'S',
   't',
   'r',
   'i',
   'n',
   'g',
   'M',
   'a',
   'r',
   'k',
   'e',
   'r',
   'G',
   'R',
   'E',
   'M',
   'E',
   'D',
   'Y',
   0, // glStringMarkerGREMEDY
   'g',
   'l',
   'S',
   'u',
   'b',
   'p',
   'i',
   'x',
   'e',
   'l',
   'P',
   'r',
   'e',
   'c',
   'i',
   's',
   'i',
   'o',
   'n',
   'B',
   'i',
   'a',
   's',
   'N',
   'V',
   0, // glSubpixelPrecisionBiasNV
   'g',
   'l',
   'S',
   'w',
   'i',
   'z',
   'z',
   'l',
   'e',
   'E',
   'X',
   'T',
   0, // glSwizzleEXT
   'g',
   'l',
   'S',
   'y',
   'n',
   'c',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'I',
   'N',
   'T',
   'E',
   'L',
   0, // glSyncTextureINTEL
   'g',
   'l',
   'T',
   'a',
   'g',
   'S',
   'a',
   'm',
   'p',
   'l',
   'e',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'S',
   'G',
   'I',
   'X',
   0, // glTagSampleBufferSGIX
   'g',
   'l',
   'T',
   'a',
   'n',
   'g',
   'e',
   'n',
   't',
   '3',
   'b',
   'E',
   'X',
   'T',
   0, // glTangent3bEXT
   'g',
   'l',
   'T',
   'a',
   'n',
   'g',
   'e',
   'n',
   't',
   '3',
   'b',
   'v',
   'E',
   'X',
   'T',
   0, // glTangent3bvEXT
   'g',
   'l',
   'T',
   'a',
   'n',
   'g',
   'e',
   'n',
   't',
   '3',
   'd',
   'E',
   'X',
   'T',
   0, // glTangent3dEXT
   'g',
   'l',
   'T',
   'a',
   'n',
   'g',
   'e',
   'n',
   't',
   '3',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glTangent3dvEXT
   'g',
   'l',
   'T',
   'a',
   'n',
   'g',
   'e',
   'n',
   't',
   '3',
   'f',
   'E',
   'X',
   'T',
   0, // glTangent3fEXT
   'g',
   'l',
   'T',
   'a',
   'n',
   'g',
   'e',
   'n',
   't',
   '3',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glTangent3fvEXT
   'g',
   'l',
   'T',
   'a',
   'n',
   'g',
   'e',
   'n',
   't',
   '3',
   'i',
   'E',
   'X',
   'T',
   0, // glTangent3iEXT
   'g',
   'l',
   'T',
   'a',
   'n',
   'g',
   'e',
   'n',
   't',
   '3',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glTangent3ivEXT
   'g',
   'l',
   'T',
   'a',
   'n',
   'g',
   'e',
   'n',
   't',
   '3',
   's',
   'E',
   'X',
   'T',
   0, // glTangent3sEXT
   'g',
   'l',
   'T',
   'a',
   'n',
   'g',
   'e',
   'n',
   't',
   '3',
   's',
   'v',
   'E',
   'X',
   'T',
   0, // glTangent3svEXT
   'g',
   'l',
   'T',
   'a',
   'n',
   'g',
   'e',
   'n',
   't',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glTangentPointerEXT
   'g',
   'l',
   'T',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'M',
   'a',
   's',
   'k',
   '3',
   'D',
   'F',
   'X',
   0, // glTbufferMask3DFX
   'g',
   'l',
   'T',
   'e',
   's',
   's',
   'e',
   'l',
   'l',
   'a',
   't',
   'i',
   'o',
   'n',
   'F',
   'a',
   'c',
   't',
   'o',
   'r',
   'A',
   'M',
   'D',
   0, // glTessellationFactorAMD
   'g',
   'l',
   'T',
   'e',
   's',
   's',
   'e',
   'l',
   'l',
   'a',
   't',
   'i',
   'o',
   'n',
   'M',
   'o',
   'd',
   'e',
   'A',
   'M',
   'D',
   0, // glTessellationModeAMD
   'g',
   'l',
   'T',
   'e',
   's',
   't',
   'F',
   'e',
   'n',
   'c',
   'e',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glTestFenceAPPLE
   'g',
   'l',
   'T',
   'e',
   's',
   't',
   'F',
   'e',
   'n',
   'c',
   'e',
   'N',
   'V',
   0, // glTestFenceNV
   'g',
   'l',
   'T',
   'e',
   's',
   't',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glTestObjectAPPLE
   'g',
   'l',
   'T',
   'e',
   'x',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glTexBuffer
   'g',
   'l',
   'T',
   'e',
   'x',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'A',
   'R',
   'B',
   0, // glTexBufferARB
   'g',
   'l',
   'T',
   'e',
   'x',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glTexBufferEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'O',
   'E',
   'S',
   0, // glTexBufferOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'a',
   'n',
   'g',
   'e',
   0, // glTexBufferRange
   'g',
   'l',
   'T',
   'e',
   'x',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'a',
   'n',
   'g',
   'e',
   'E',
   'X',
   'T',
   0, // glTexBufferRangeEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'a',
   'n',
   'g',
   'e',
   'O',
   'E',
   'S',
   0, // glTexBufferRangeOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'B',
   'u',
   'm',
   'p',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'A',
   'T',
   'I',
   0, // glTexBumpParameterfvATI
   'g',
   'l',
   'T',
   'e',
   'x',
   'B',
   'u',
   'm',
   'p',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'A',
   'T',
   'I',
   0, // glTexBumpParameterivATI
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'b',
   'O',
   'E',
   'S',
   0, // glTexCoord1bOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'b',
   'v',
   'O',
   'E',
   'S',
   0, // glTexCoord1bvOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'd',
   0, // glTexCoord1d
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'd',
   'v',
   0, // glTexCoord1dv
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'f',
   0, // glTexCoord1f
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'f',
   'v',
   0, // glTexCoord1fv
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'h',
   'N',
   'V',
   0, // glTexCoord1hNV
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'h',
   'v',
   'N',
   'V',
   0, // glTexCoord1hvNV
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'i',
   0, // glTexCoord1i
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'i',
   'v',
   0, // glTexCoord1iv
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   's',
   0, // glTexCoord1s
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   's',
   'v',
   0, // glTexCoord1sv
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'x',
   'O',
   'E',
   'S',
   0, // glTexCoord1xOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '1',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glTexCoord1xvOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'b',
   'O',
   'E',
   'S',
   0, // glTexCoord2bOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'b',
   'v',
   'O',
   'E',
   'S',
   0, // glTexCoord2bvOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'd',
   0, // glTexCoord2d
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'd',
   'v',
   0, // glTexCoord2dv
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'f',
   0, // glTexCoord2f
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'f',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'S',
   'U',
   'N',
   0, // glTexCoord2fColor3fVertex3fSUN
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'f',
   'C',
   'o',
   'l',
   'o',
   'r',
   '3',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'v',
   'S',
   'U',
   'N',
   0, // glTexCoord2fColor3fVertex3fvSUN
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'f',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'f',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'S',
   'U',
   'N',
   0, // glTexCoord2fColor4fNormal3fVertex3fSUN
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'f',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'f',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'v',
   'S',
   'U',
   'N',
   0, // glTexCoord2fColor4fNormal3fVertex3fvSUN
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'f',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'u',
   'b',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'S',
   'U',
   'N',
   0, // glTexCoord2fColor4ubVertex3fSUN
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'f',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'u',
   'b',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'v',
   'S',
   'U',
   'N',
   0, // glTexCoord2fColor4ubVertex3fvSUN
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'f',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'S',
   'U',
   'N',
   0, // glTexCoord2fNormal3fVertex3fSUN
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'f',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'v',
   'S',
   'U',
   'N',
   0, // glTexCoord2fNormal3fVertex3fvSUN
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'S',
   'U',
   'N',
   0, // glTexCoord2fVertex3fSUN
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'v',
   'S',
   'U',
   'N',
   0, // glTexCoord2fVertex3fvSUN
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'f',
   'v',
   0, // glTexCoord2fv
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'h',
   'N',
   'V',
   0, // glTexCoord2hNV
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'h',
   'v',
   'N',
   'V',
   0, // glTexCoord2hvNV
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'i',
   0, // glTexCoord2i
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'i',
   'v',
   0, // glTexCoord2iv
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   's',
   0, // glTexCoord2s
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   's',
   'v',
   0, // glTexCoord2sv
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'x',
   'O',
   'E',
   'S',
   0, // glTexCoord2xOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '2',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glTexCoord2xvOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'b',
   'O',
   'E',
   'S',
   0, // glTexCoord3bOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'b',
   'v',
   'O',
   'E',
   'S',
   0, // glTexCoord3bvOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'd',
   0, // glTexCoord3d
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'd',
   'v',
   0, // glTexCoord3dv
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'f',
   0, // glTexCoord3f
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'f',
   'v',
   0, // glTexCoord3fv
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'h',
   'N',
   'V',
   0, // glTexCoord3hNV
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'h',
   'v',
   'N',
   'V',
   0, // glTexCoord3hvNV
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'i',
   0, // glTexCoord3i
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'i',
   'v',
   0, // glTexCoord3iv
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   's',
   0, // glTexCoord3s
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   's',
   'v',
   0, // glTexCoord3sv
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'x',
   'O',
   'E',
   'S',
   0, // glTexCoord3xOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '3',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glTexCoord3xvOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'b',
   'O',
   'E',
   'S',
   0, // glTexCoord4bOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'b',
   'v',
   'O',
   'E',
   'S',
   0, // glTexCoord4bvOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'd',
   0, // glTexCoord4d
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'd',
   'v',
   0, // glTexCoord4dv
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'f',
   0, // glTexCoord4f
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'f',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'f',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '4',
   'f',
   'S',
   'U',
   'N',
   0, // glTexCoord4fColor4fNormal3fVertex4fSUN
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'f',
   'C',
   'o',
   'l',
   'o',
   'r',
   '4',
   'f',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   '3',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '4',
   'f',
   'v',
   'S',
   'U',
   'N',
   0, // glTexCoord4fColor4fNormal3fVertex4fvSUN
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '4',
   'f',
   'S',
   'U',
   'N',
   0, // glTexCoord4fVertex4fSUN
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'f',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '4',
   'f',
   'v',
   'S',
   'U',
   'N',
   0, // glTexCoord4fVertex4fvSUN
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'f',
   'v',
   0, // glTexCoord4fv
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'h',
   'N',
   'V',
   0, // glTexCoord4hNV
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'h',
   'v',
   'N',
   'V',
   0, // glTexCoord4hvNV
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'i',
   0, // glTexCoord4i
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'i',
   'v',
   0, // glTexCoord4iv
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   's',
   0, // glTexCoord4s
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   's',
   'v',
   0, // glTexCoord4sv
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'x',
   'O',
   'E',
   'S',
   0, // glTexCoord4xOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   '4',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glTexCoord4xvOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'F',
   'o',
   'r',
   'm',
   'a',
   't',
   'N',
   'V',
   0, // glTexCoordFormatNV
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'P',
   '1',
   'u',
   'i',
   0, // glTexCoordP1ui
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'P',
   '1',
   'u',
   'i',
   'v',
   0, // glTexCoordP1uiv
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'P',
   '2',
   'u',
   'i',
   0, // glTexCoordP2ui
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'P',
   '2',
   'u',
   'i',
   'v',
   0, // glTexCoordP2uiv
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'P',
   '3',
   'u',
   'i',
   0, // glTexCoordP3ui
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'P',
   '3',
   'u',
   'i',
   'v',
   0, // glTexCoordP3uiv
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'P',
   '4',
   'u',
   'i',
   0, // glTexCoordP4ui
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'P',
   '4',
   'u',
   'i',
   'v',
   0, // glTexCoordP4uiv
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   0, // glTexCoordPointer
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glTexCoordPointerEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'L',
   'i',
   's',
   't',
   'I',
   'B',
   'M',
   0, // glTexCoordPointerListIBM
   'g',
   'l',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'v',
   'I',
   'N',
   'T',
   'E',
   'L',
   0, // glTexCoordPointervINTEL
   'g',
   'l',
   'T',
   'e',
   'x',
   'E',
   'n',
   'v',
   'f',
   0, // glTexEnvf
   'g',
   'l',
   'T',
   'e',
   'x',
   'E',
   'n',
   'v',
   'f',
   'v',
   0, // glTexEnvfv
   'g',
   'l',
   'T',
   'e',
   'x',
   'E',
   'n',
   'v',
   'i',
   0, // glTexEnvi
   'g',
   'l',
   'T',
   'e',
   'x',
   'E',
   'n',
   'v',
   'i',
   'v',
   0, // glTexEnviv
   'g',
   'l',
   'T',
   'e',
   'x',
   'E',
   'n',
   'v',
   'x',
   0, // glTexEnvx
   'g',
   'l',
   'T',
   'e',
   'x',
   'E',
   'n',
   'v',
   'x',
   'O',
   'E',
   'S',
   0, // glTexEnvxOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'E',
   'n',
   'v',
   'x',
   'v',
   0, // glTexEnvxv
   'g',
   'l',
   'T',
   'e',
   'x',
   'E',
   'n',
   'v',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glTexEnvxvOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'F',
   'i',
   'l',
   't',
   'e',
   'r',
   'F',
   'u',
   'n',
   'c',
   'S',
   'G',
   'I',
   'S',
   0, // glTexFilterFuncSGIS
   'g',
   'l',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'd',
   0, // glTexGend
   'g',
   'l',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'd',
   'v',
   0, // glTexGendv
   'g',
   'l',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'f',
   0, // glTexGenf
   'g',
   'l',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'f',
   'O',
   'E',
   'S',
   0, // glTexGenfOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'f',
   'v',
   0, // glTexGenfv
   'g',
   'l',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'f',
   'v',
   'O',
   'E',
   'S',
   0, // glTexGenfvOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'i',
   0, // glTexGeni
   'g',
   'l',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'i',
   'O',
   'E',
   'S',
   0, // glTexGeniOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'i',
   'v',
   0, // glTexGeniv
   'g',
   'l',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'i',
   'v',
   'O',
   'E',
   'S',
   0, // glTexGenivOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'x',
   'O',
   'E',
   'S',
   0, // glTexGenxOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'G',
   'e',
   'n',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glTexGenxvOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   0, // glTexImage1D
   'g',
   'l',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   0, // glTexImage2D
   'g',
   'l',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   0, // glTexImage2DMultisample
   'g',
   'l',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'C',
   'o',
   'v',
   'e',
   'r',
   'a',
   'g',
   'e',
   'N',
   'V',
   0, // glTexImage2DMultisampleCoverageNV
   'g',
   'l',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   0, // glTexImage3D
   'g',
   'l',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   'E',
   'X',
   'T',
   0, // glTexImage3DEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   0, // glTexImage3DMultisample
   'g',
   'l',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'C',
   'o',
   'v',
   'e',
   'r',
   'a',
   'g',
   'e',
   'N',
   'V',
   0, // glTexImage3DMultisampleCoverageNV
   'g',
   'l',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   'O',
   'E',
   'S',
   0, // glTexImage3DOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'I',
   'm',
   'a',
   'g',
   'e',
   '4',
   'D',
   'S',
   'G',
   'I',
   'S',
   0, // glTexImage4DSGIS
   'g',
   'l',
   'T',
   'e',
   'x',
   'P',
   'a',
   'g',
   'e',
   'C',
   'o',
   'm',
   'm',
   'i',
   't',
   'm',
   'e',
   'n',
   't',
   'A',
   'R',
   'B',
   0, // glTexPageCommitmentARB
   'g',
   'l',
   'T',
   'e',
   'x',
   'P',
   'a',
   'g',
   'e',
   'C',
   'o',
   'm',
   'm',
   'i',
   't',
   'm',
   'e',
   'n',
   't',
   'E',
   'X',
   'T',
   0, // glTexPageCommitmentEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'i',
   'v',
   0, // glTexParameterIiv
   'g',
   'l',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glTexParameterIivEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'i',
   'v',
   'O',
   'E',
   'S',
   0, // glTexParameterIivOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'u',
   'i',
   'v',
   0, // glTexParameterIuiv
   'g',
   'l',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glTexParameterIuivEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'u',
   'i',
   'v',
   'O',
   'E',
   'S',
   0, // glTexParameterIuivOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   0, // glTexParameterf
   'g',
   'l',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   0, // glTexParameterfv
   'g',
   'l',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   0, // glTexParameteri
   'g',
   'l',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   0, // glTexParameteriv
   'g',
   'l',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'x',
   0, // glTexParameterx
   'g',
   'l',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'x',
   'O',
   'E',
   'S',
   0, // glTexParameterxOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'x',
   'v',
   0, // glTexParameterxv
   'g',
   'l',
   'T',
   'e',
   'x',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glTexParameterxvOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'N',
   'V',
   0, // glTexRenderbufferNV
   'g',
   'l',
   'T',
   'e',
   'x',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   '1',
   'D',
   0, // glTexStorage1D
   'g',
   'l',
   'T',
   'e',
   'x',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   '1',
   'D',
   'E',
   'X',
   'T',
   0, // glTexStorage1DEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   '2',
   'D',
   0, // glTexStorage2D
   'g',
   'l',
   'T',
   'e',
   'x',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   '2',
   'D',
   'E',
   'X',
   'T',
   0, // glTexStorage2DEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   '2',
   'D',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   0, // glTexStorage2DMultisample
   'g',
   'l',
   'T',
   'e',
   'x',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   '3',
   'D',
   0, // glTexStorage3D
   'g',
   'l',
   'T',
   'e',
   'x',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   '3',
   'D',
   'E',
   'X',
   'T',
   0, // glTexStorage3DEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   '3',
   'D',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   0, // glTexStorage3DMultisample
   'g',
   'l',
   'T',
   'e',
   'x',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   '3',
   'D',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'O',
   'E',
   'S',
   0, // glTexStorage3DMultisampleOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'M',
   'e',
   'm',
   '1',
   'D',
   'E',
   'X',
   'T',
   0, // glTexStorageMem1DEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'M',
   'e',
   'm',
   '2',
   'D',
   'E',
   'X',
   'T',
   0, // glTexStorageMem2DEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'M',
   'e',
   'm',
   '2',
   'D',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'E',
   'X',
   'T',
   0, // glTexStorageMem2DMultisampleEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'M',
   'e',
   'm',
   '3',
   'D',
   'E',
   'X',
   'T',
   0, // glTexStorageMem3DEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'M',
   'e',
   'm',
   '3',
   'D',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'E',
   'X',
   'T',
   0, // glTexStorageMem3DMultisampleEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'S',
   'p',
   'a',
   'r',
   's',
   'e',
   'A',
   'M',
   'D',
   0, // glTexStorageSparseAMD
   'g',
   'l',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   0, // glTexSubImage1D
   'g',
   'l',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   'E',
   'X',
   'T',
   0, // glTexSubImage1DEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   0, // glTexSubImage2D
   'g',
   'l',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   'E',
   'X',
   'T',
   0, // glTexSubImage2DEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   0, // glTexSubImage3D
   'g',
   'l',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   'E',
   'X',
   'T',
   0, // glTexSubImage3DEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   'O',
   'E',
   'S',
   0, // glTexSubImage3DOES
   'g',
   'l',
   'T',
   'e',
   'x',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '4',
   'D',
   'S',
   'G',
   'I',
   'S',
   0, // glTexSubImage4DSGIS
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'B',
   'a',
   'r',
   'r',
   'i',
   'e',
   'r',
   0, // glTextureBarrier
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'B',
   'a',
   'r',
   'r',
   'i',
   'e',
   'r',
   'N',
   'V',
   0, // glTextureBarrierNV
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glTextureBuffer
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glTextureBufferEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'a',
   'n',
   'g',
   'e',
   0, // glTextureBufferRange
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'a',
   'n',
   'g',
   'e',
   'E',
   'X',
   'T',
   0, // glTextureBufferRangeEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'C',
   'o',
   'l',
   'o',
   'r',
   'M',
   'a',
   's',
   'k',
   'S',
   'G',
   'I',
   'S',
   0, // glTextureColorMaskSGIS
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'F',
   'o',
   'v',
   'e',
   'a',
   't',
   'i',
   'o',
   'n',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   's',
   'Q',
   'C',
   'O',
   'M',
   0, // glTextureFoveationParametersQCOM
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   'E',
   'X',
   'T',
   0, // glTextureImage1DEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   'E',
   'X',
   'T',
   0, // glTextureImage2DEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'C',
   'o',
   'v',
   'e',
   'r',
   'a',
   'g',
   'e',
   'N',
   'V',
   0, // glTextureImage2DMultisampleCoverageNV
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'N',
   'V',
   0, // glTextureImage2DMultisampleNV
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   'E',
   'X',
   'T',
   0, // glTextureImage3DEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'C',
   'o',
   'v',
   'e',
   'r',
   'a',
   'g',
   'e',
   'N',
   'V',
   0, // glTextureImage3DMultisampleCoverageNV
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'N',
   'V',
   0, // glTextureImage3DMultisampleNV
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'L',
   'i',
   'g',
   'h',
   't',
   'E',
   'X',
   'T',
   0, // glTextureLightEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'M',
   'a',
   't',
   'e',
   'r',
   'i',
   'a',
   'l',
   'E',
   'X',
   'T',
   0, // glTextureMaterialEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   'E',
   'X',
   'T',
   0, // glTextureNormalEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'P',
   'a',
   'g',
   'e',
   'C',
   'o',
   'm',
   'm',
   'i',
   't',
   'm',
   'e',
   'n',
   't',
   'E',
   'X',
   'T',
   0, // glTexturePageCommitmentEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'i',
   'v',
   0, // glTextureParameterIiv
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glTextureParameterIivEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'u',
   'i',
   'v',
   0, // glTextureParameterIuiv
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'I',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glTextureParameterIuivEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   0, // glTextureParameterf
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'E',
   'X',
   'T',
   0, // glTextureParameterfEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   0, // glTextureParameterfv
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glTextureParameterfvEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   0, // glTextureParameteri
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'E',
   'X',
   'T',
   0, // glTextureParameteriEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   0, // glTextureParameteriv
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glTextureParameterivEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'R',
   'a',
   'n',
   'g',
   'e',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glTextureRangeAPPLE
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'R',
   'e',
   'n',
   'd',
   'e',
   'r',
   'b',
   'u',
   'f',
   'f',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glTextureRenderbufferEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   '1',
   'D',
   0, // glTextureStorage1D
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   '1',
   'D',
   'E',
   'X',
   'T',
   0, // glTextureStorage1DEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   '2',
   'D',
   0, // glTextureStorage2D
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   '2',
   'D',
   'E',
   'X',
   'T',
   0, // glTextureStorage2DEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   '2',
   'D',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   0, // glTextureStorage2DMultisample
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   '2',
   'D',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'E',
   'X',
   'T',
   0, // glTextureStorage2DMultisampleEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   '3',
   'D',
   0, // glTextureStorage3D
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   '3',
   'D',
   'E',
   'X',
   'T',
   0, // glTextureStorage3DEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   '3',
   'D',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   0, // glTextureStorage3DMultisample
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   '3',
   'D',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'E',
   'X',
   'T',
   0, // glTextureStorage3DMultisampleEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'M',
   'e',
   'm',
   '1',
   'D',
   'E',
   'X',
   'T',
   0, // glTextureStorageMem1DEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'M',
   'e',
   'm',
   '2',
   'D',
   'E',
   'X',
   'T',
   0, // glTextureStorageMem2DEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'M',
   'e',
   'm',
   '2',
   'D',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'E',
   'X',
   'T',
   0, // glTextureStorageMem2DMultisampleEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'M',
   'e',
   'm',
   '3',
   'D',
   'E',
   'X',
   'T',
   0, // glTextureStorageMem3DEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'M',
   'e',
   'm',
   '3',
   'D',
   'M',
   'u',
   'l',
   't',
   'i',
   's',
   'a',
   'm',
   'p',
   'l',
   'e',
   'E',
   'X',
   'T',
   0, // glTextureStorageMem3DMultisampleEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   't',
   'o',
   'r',
   'a',
   'g',
   'e',
   'S',
   'p',
   'a',
   'r',
   's',
   'e',
   'A',
   'M',
   'D',
   0, // glTextureStorageSparseAMD
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   0, // glTextureSubImage1D
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '1',
   'D',
   'E',
   'X',
   'T',
   0, // glTextureSubImage1DEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   0, // glTextureSubImage2D
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '2',
   'D',
   'E',
   'X',
   'T',
   0, // glTextureSubImage2DEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   0, // glTextureSubImage3D
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'S',
   'u',
   'b',
   'I',
   'm',
   'a',
   'g',
   'e',
   '3',
   'D',
   'E',
   'X',
   'T',
   0, // glTextureSubImage3DEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'V',
   'i',
   'e',
   'w',
   0, // glTextureView
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'V',
   'i',
   'e',
   'w',
   'E',
   'X',
   'T',
   0, // glTextureViewEXT
   'g',
   'l',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   'V',
   'i',
   'e',
   'w',
   'O',
   'E',
   'S',
   0, // glTextureViewOES
   'g',
   'l',
   'T',
   'r',
   'a',
   'c',
   'k',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   'N',
   'V',
   0, // glTrackMatrixNV
   'g',
   'l',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   's',
   'N',
   'V',
   0, // glTransformFeedbackAttribsNV
   'g',
   'l',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'B',
   'a',
   's',
   'e',
   0, // glTransformFeedbackBufferBase
   'g',
   'l',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'R',
   'a',
   'n',
   'g',
   'e',
   0, // glTransformFeedbackBufferRange
   'g',
   'l',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   's',
   'N',
   'V',
   0, // glTransformFeedbackStreamAttribsNV
   'g',
   'l',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'V',
   'a',
   'r',
   'y',
   'i',
   'n',
   'g',
   's',
   0, // glTransformFeedbackVaryings
   'g',
   'l',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'V',
   'a',
   'r',
   'y',
   'i',
   'n',
   'g',
   's',
   'E',
   'X',
   'T',
   0, // glTransformFeedbackVaryingsEXT
   'g',
   'l',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'F',
   'e',
   'e',
   'd',
   'b',
   'a',
   'c',
   'k',
   'V',
   'a',
   'r',
   'y',
   'i',
   'n',
   'g',
   's',
   'N',
   'V',
   0, // glTransformFeedbackVaryingsNV
   'g',
   'l',
   'T',
   'r',
   'a',
   'n',
   's',
   'f',
   'o',
   'r',
   'm',
   'P',
   'a',
   't',
   'h',
   'N',
   'V',
   0, // glTransformPathNV
   'g',
   'l',
   'T',
   'r',
   'a',
   'n',
   's',
   'l',
   'a',
   't',
   'e',
   'd',
   0, // glTranslated
   'g',
   'l',
   'T',
   'r',
   'a',
   'n',
   's',
   'l',
   'a',
   't',
   'e',
   'f',
   0, // glTranslatef
   'g',
   'l',
   'T',
   'r',
   'a',
   'n',
   's',
   'l',
   'a',
   't',
   'e',
   'x',
   0, // glTranslatex
   'g',
   'l',
   'T',
   'r',
   'a',
   'n',
   's',
   'l',
   'a',
   't',
   'e',
   'x',
   'O',
   'E',
   'S',
   0, // glTranslatexOES
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'd',
   0, // glUniform1d
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'd',
   'v',
   0, // glUniform1dv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'f',
   0, // glUniform1f
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'f',
   'A',
   'R',
   'B',
   0, // glUniform1fARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'f',
   'v',
   0, // glUniform1fv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glUniform1fvARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'i',
   0, // glUniform1i
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'i',
   '6',
   '4',
   'A',
   'R',
   'B',
   0, // glUniform1i64ARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glUniform1i64NV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'i',
   '6',
   '4',
   'v',
   'A',
   'R',
   'B',
   0, // glUniform1i64vARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glUniform1i64vNV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'i',
   'A',
   'R',
   'B',
   0, // glUniform1iARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'i',
   'v',
   0, // glUniform1iv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glUniform1ivARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'u',
   'i',
   0, // glUniform1ui
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'u',
   'i',
   '6',
   '4',
   'A',
   'R',
   'B',
   0, // glUniform1ui64ARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'u',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glUniform1ui64NV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'u',
   'i',
   '6',
   '4',
   'v',
   'A',
   'R',
   'B',
   0, // glUniform1ui64vARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'u',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glUniform1ui64vNV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'u',
   'i',
   'E',
   'X',
   'T',
   0, // glUniform1uiEXT
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'u',
   'i',
   'v',
   0, // glUniform1uiv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '1',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glUniform1uivEXT
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'd',
   0, // glUniform2d
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'd',
   'v',
   0, // glUniform2dv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'f',
   0, // glUniform2f
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'f',
   'A',
   'R',
   'B',
   0, // glUniform2fARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'f',
   'v',
   0, // glUniform2fv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glUniform2fvARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'i',
   0, // glUniform2i
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'i',
   '6',
   '4',
   'A',
   'R',
   'B',
   0, // glUniform2i64ARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glUniform2i64NV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'i',
   '6',
   '4',
   'v',
   'A',
   'R',
   'B',
   0, // glUniform2i64vARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glUniform2i64vNV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'i',
   'A',
   'R',
   'B',
   0, // glUniform2iARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'i',
   'v',
   0, // glUniform2iv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glUniform2ivARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'u',
   'i',
   0, // glUniform2ui
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'u',
   'i',
   '6',
   '4',
   'A',
   'R',
   'B',
   0, // glUniform2ui64ARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'u',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glUniform2ui64NV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'u',
   'i',
   '6',
   '4',
   'v',
   'A',
   'R',
   'B',
   0, // glUniform2ui64vARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'u',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glUniform2ui64vNV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'u',
   'i',
   'E',
   'X',
   'T',
   0, // glUniform2uiEXT
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'u',
   'i',
   'v',
   0, // glUniform2uiv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '2',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glUniform2uivEXT
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'd',
   0, // glUniform3d
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'd',
   'v',
   0, // glUniform3dv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'f',
   0, // glUniform3f
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'f',
   'A',
   'R',
   'B',
   0, // glUniform3fARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'f',
   'v',
   0, // glUniform3fv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glUniform3fvARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'i',
   0, // glUniform3i
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'i',
   '6',
   '4',
   'A',
   'R',
   'B',
   0, // glUniform3i64ARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glUniform3i64NV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'i',
   '6',
   '4',
   'v',
   'A',
   'R',
   'B',
   0, // glUniform3i64vARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glUniform3i64vNV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'i',
   'A',
   'R',
   'B',
   0, // glUniform3iARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'i',
   'v',
   0, // glUniform3iv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glUniform3ivARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'u',
   'i',
   0, // glUniform3ui
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'u',
   'i',
   '6',
   '4',
   'A',
   'R',
   'B',
   0, // glUniform3ui64ARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'u',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glUniform3ui64NV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'u',
   'i',
   '6',
   '4',
   'v',
   'A',
   'R',
   'B',
   0, // glUniform3ui64vARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'u',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glUniform3ui64vNV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'u',
   'i',
   'E',
   'X',
   'T',
   0, // glUniform3uiEXT
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'u',
   'i',
   'v',
   0, // glUniform3uiv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '3',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glUniform3uivEXT
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'd',
   0, // glUniform4d
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'd',
   'v',
   0, // glUniform4dv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'f',
   0, // glUniform4f
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'f',
   'A',
   'R',
   'B',
   0, // glUniform4fARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'f',
   'v',
   0, // glUniform4fv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glUniform4fvARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'i',
   0, // glUniform4i
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'i',
   '6',
   '4',
   'A',
   'R',
   'B',
   0, // glUniform4i64ARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glUniform4i64NV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'i',
   '6',
   '4',
   'v',
   'A',
   'R',
   'B',
   0, // glUniform4i64vARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glUniform4i64vNV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'i',
   'A',
   'R',
   'B',
   0, // glUniform4iARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'i',
   'v',
   0, // glUniform4iv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glUniform4ivARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'u',
   'i',
   0, // glUniform4ui
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'u',
   'i',
   '6',
   '4',
   'A',
   'R',
   'B',
   0, // glUniform4ui64ARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'u',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glUniform4ui64NV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'u',
   'i',
   '6',
   '4',
   'v',
   'A',
   'R',
   'B',
   0, // glUniform4ui64vARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'u',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glUniform4ui64vNV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'u',
   'i',
   'E',
   'X',
   'T',
   0, // glUniform4uiEXT
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'u',
   'i',
   'v',
   0, // glUniform4uiv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   '4',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glUniform4uivEXT
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'B',
   'l',
   'o',
   'c',
   'k',
   'B',
   'i',
   'n',
   'd',
   'i',
   'n',
   'g',
   0, // glUniformBlockBinding
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glUniformBufferEXT
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'u',
   'i',
   '6',
   '4',
   'A',
   'R',
   'B',
   0, // glUniformHandleui64ARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'u',
   'i',
   '6',
   '4',
   'I',
   'M',
   'G',
   0, // glUniformHandleui64IMG
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'u',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glUniformHandleui64NV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'u',
   'i',
   '6',
   '4',
   'v',
   'A',
   'R',
   'B',
   0, // glUniformHandleui64vARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'u',
   'i',
   '6',
   '4',
   'v',
   'I',
   'M',
   'G',
   0, // glUniformHandleui64vIMG
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'H',
   'a',
   'n',
   'd',
   'l',
   'e',
   'u',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glUniformHandleui64vNV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '2',
   'd',
   'v',
   0, // glUniformMatrix2dv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '2',
   'f',
   'v',
   0, // glUniformMatrix2fv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '2',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glUniformMatrix2fvARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '2',
   'x',
   '3',
   'd',
   'v',
   0, // glUniformMatrix2x3dv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '2',
   'x',
   '3',
   'f',
   'v',
   0, // glUniformMatrix2x3fv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '2',
   'x',
   '3',
   'f',
   'v',
   'N',
   'V',
   0, // glUniformMatrix2x3fvNV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '2',
   'x',
   '4',
   'd',
   'v',
   0, // glUniformMatrix2x4dv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '2',
   'x',
   '4',
   'f',
   'v',
   0, // glUniformMatrix2x4fv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '2',
   'x',
   '4',
   'f',
   'v',
   'N',
   'V',
   0, // glUniformMatrix2x4fvNV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '3',
   'd',
   'v',
   0, // glUniformMatrix3dv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '3',
   'f',
   'v',
   0, // glUniformMatrix3fv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '3',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glUniformMatrix3fvARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '3',
   'x',
   '2',
   'd',
   'v',
   0, // glUniformMatrix3x2dv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '3',
   'x',
   '2',
   'f',
   'v',
   0, // glUniformMatrix3x2fv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '3',
   'x',
   '2',
   'f',
   'v',
   'N',
   'V',
   0, // glUniformMatrix3x2fvNV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '3',
   'x',
   '4',
   'd',
   'v',
   0, // glUniformMatrix3x4dv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '3',
   'x',
   '4',
   'f',
   'v',
   0, // glUniformMatrix3x4fv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '3',
   'x',
   '4',
   'f',
   'v',
   'N',
   'V',
   0, // glUniformMatrix3x4fvNV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '4',
   'd',
   'v',
   0, // glUniformMatrix4dv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '4',
   'f',
   'v',
   0, // glUniformMatrix4fv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '4',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glUniformMatrix4fvARB
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '4',
   'x',
   '2',
   'd',
   'v',
   0, // glUniformMatrix4x2dv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '4',
   'x',
   '2',
   'f',
   'v',
   0, // glUniformMatrix4x2fv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '4',
   'x',
   '2',
   'f',
   'v',
   'N',
   'V',
   0, // glUniformMatrix4x2fvNV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '4',
   'x',
   '3',
   'd',
   'v',
   0, // glUniformMatrix4x3dv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '4',
   'x',
   '3',
   'f',
   'v',
   0, // glUniformMatrix4x3fv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'M',
   'a',
   't',
   'r',
   'i',
   'x',
   '4',
   'x',
   '3',
   'f',
   'v',
   'N',
   'V',
   0, // glUniformMatrix4x3fvNV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'S',
   'u',
   'b',
   'r',
   'o',
   'u',
   't',
   'i',
   'n',
   'e',
   's',
   'u',
   'i',
   'v',
   0, // glUniformSubroutinesuiv
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'u',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glUniformui64NV
   'g',
   'l',
   'U',
   'n',
   'i',
   'f',
   'o',
   'r',
   'm',
   'u',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glUniformui64vNV
   'g',
   'l',
   'U',
   'n',
   'l',
   'o',
   'c',
   'k',
   'A',
   'r',
   'r',
   'a',
   'y',
   's',
   'E',
   'X',
   'T',
   0, // glUnlockArraysEXT
   'g',
   'l',
   'U',
   'n',
   'm',
   'a',
   'p',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glUnmapBuffer
   'g',
   'l',
   'U',
   'n',
   'm',
   'a',
   'p',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'A',
   'R',
   'B',
   0, // glUnmapBufferARB
   'g',
   'l',
   'U',
   'n',
   'm',
   'a',
   'p',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'O',
   'E',
   'S',
   0, // glUnmapBufferOES
   'g',
   'l',
   'U',
   'n',
   'm',
   'a',
   'p',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glUnmapNamedBuffer
   'g',
   'l',
   'U',
   'n',
   'm',
   'a',
   'p',
   'N',
   'a',
   'm',
   'e',
   'd',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glUnmapNamedBufferEXT
   'g',
   'l',
   'U',
   'n',
   'm',
   'a',
   'p',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'A',
   'T',
   'I',
   0, // glUnmapObjectBufferATI
   'g',
   'l',
   'U',
   'n',
   'm',
   'a',
   'p',
   'T',
   'e',
   'x',
   't',
   'u',
   'r',
   'e',
   '2',
   'D',
   'I',
   'N',
   'T',
   'E',
   'L',
   0, // glUnmapTexture2DINTEL
   'g',
   'l',
   'U',
   'p',
   'd',
   'a',
   't',
   'e',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'A',
   'T',
   'I',
   0, // glUpdateObjectBufferATI
   'g',
   'l',
   'U',
   's',
   'e',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   0, // glUseProgram
   'g',
   'l',
   'U',
   's',
   'e',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'A',
   'R',
   'B',
   0, // glUseProgramObjectARB
   'g',
   'l',
   'U',
   's',
   'e',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'S',
   't',
   'a',
   'g',
   'e',
   's',
   0, // glUseProgramStages
   'g',
   'l',
   'U',
   's',
   'e',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'S',
   't',
   'a',
   'g',
   'e',
   's',
   'E',
   'X',
   'T',
   0, // glUseProgramStagesEXT
   'g',
   'l',
   'U',
   's',
   'e',
   'S',
   'h',
   'a',
   'd',
   'e',
   'r',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'E',
   'X',
   'T',
   0, // glUseShaderProgramEXT
   'g',
   'l',
   'V',
   'D',
   'P',
   'A',
   'U',
   'F',
   'i',
   'n',
   'i',
   'N',
   'V',
   0, // glVDPAUFiniNV
   'g',
   'l',
   'V',
   'D',
   'P',
   'A',
   'U',
   'G',
   'e',
   't',
   'S',
   'u',
   'r',
   'f',
   'a',
   'c',
   'e',
   'i',
   'v',
   'N',
   'V',
   0, // glVDPAUGetSurfaceivNV
   'g',
   'l',
   'V',
   'D',
   'P',
   'A',
   'U',
   'I',
   'n',
   'i',
   't',
   'N',
   'V',
   0, // glVDPAUInitNV
   'g',
   'l',
   'V',
   'D',
   'P',
   'A',
   'U',
   'I',
   's',
   'S',
   'u',
   'r',
   'f',
   'a',
   'c',
   'e',
   'N',
   'V',
   0, // glVDPAUIsSurfaceNV
   'g',
   'l',
   'V',
   'D',
   'P',
   'A',
   'U',
   'M',
   'a',
   'p',
   'S',
   'u',
   'r',
   'f',
   'a',
   'c',
   'e',
   's',
   'N',
   'V',
   0, // glVDPAUMapSurfacesNV
   'g',
   'l',
   'V',
   'D',
   'P',
   'A',
   'U',
   'R',
   'e',
   'g',
   'i',
   's',
   't',
   'e',
   'r',
   'O',
   'u',
   't',
   'p',
   'u',
   't',
   'S',
   'u',
   'r',
   'f',
   'a',
   'c',
   'e',
   'N',
   'V',
   0, // glVDPAURegisterOutputSurfaceNV
   'g',
   'l',
   'V',
   'D',
   'P',
   'A',
   'U',
   'R',
   'e',
   'g',
   'i',
   's',
   't',
   'e',
   'r',
   'V',
   'i',
   'd',
   'e',
   'o',
   'S',
   'u',
   'r',
   'f',
   'a',
   'c',
   'e',
   'N',
   'V',
   0, // glVDPAURegisterVideoSurfaceNV
   'g',
   'l',
   'V',
   'D',
   'P',
   'A',
   'U',
   'S',
   'u',
   'r',
   'f',
   'a',
   'c',
   'e',
   'A',
   'c',
   'c',
   'e',
   's',
   's',
   'N',
   'V',
   0, // glVDPAUSurfaceAccessNV
   'g',
   'l',
   'V',
   'D',
   'P',
   'A',
   'U',
   'U',
   'n',
   'm',
   'a',
   'p',
   'S',
   'u',
   'r',
   'f',
   'a',
   'c',
   'e',
   's',
   'N',
   'V',
   0, // glVDPAUUnmapSurfacesNV
   'g',
   'l',
   'V',
   'D',
   'P',
   'A',
   'U',
   'U',
   'n',
   'r',
   'e',
   'g',
   'i',
   's',
   't',
   'e',
   'r',
   'S',
   'u',
   'r',
   'f',
   'a',
   'c',
   'e',
   'N',
   'V',
   0, // glVDPAUUnregisterSurfaceNV
   'g',
   'l',
   'V',
   'a',
   'l',
   'i',
   'd',
   'a',
   't',
   'e',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   0, // glValidateProgram
   'g',
   'l',
   'V',
   'a',
   'l',
   'i',
   'd',
   'a',
   't',
   'e',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'A',
   'R',
   'B',
   0, // glValidateProgramARB
   'g',
   'l',
   'V',
   'a',
   'l',
   'i',
   'd',
   'a',
   't',
   'e',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'i',
   'p',
   'e',
   'l',
   'i',
   'n',
   'e',
   0, // glValidateProgramPipeline
   'g',
   'l',
   'V',
   'a',
   'l',
   'i',
   'd',
   'a',
   't',
   'e',
   'P',
   'r',
   'o',
   'g',
   'r',
   'a',
   'm',
   'P',
   'i',
   'p',
   'e',
   'l',
   'i',
   'n',
   'e',
   'E',
   'X',
   'T',
   0, // glValidateProgramPipelineEXT
   'g',
   'l',
   'V',
   'a',
   'r',
   'i',
   'a',
   'n',
   't',
   'A',
   'r',
   'r',
   'a',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'A',
   'T',
   'I',
   0, // glVariantArrayObjectATI
   'g',
   'l',
   'V',
   'a',
   'r',
   'i',
   'a',
   'n',
   't',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glVariantPointerEXT
   'g',
   'l',
   'V',
   'a',
   'r',
   'i',
   'a',
   'n',
   't',
   'b',
   'v',
   'E',
   'X',
   'T',
   0, // glVariantbvEXT
   'g',
   'l',
   'V',
   'a',
   'r',
   'i',
   'a',
   'n',
   't',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glVariantdvEXT
   'g',
   'l',
   'V',
   'a',
   'r',
   'i',
   'a',
   'n',
   't',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glVariantfvEXT
   'g',
   'l',
   'V',
   'a',
   'r',
   'i',
   'a',
   'n',
   't',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glVariantivEXT
   'g',
   'l',
   'V',
   'a',
   'r',
   'i',
   'a',
   'n',
   't',
   's',
   'v',
   'E',
   'X',
   'T',
   0, // glVariantsvEXT
   'g',
   'l',
   'V',
   'a',
   'r',
   'i',
   'a',
   'n',
   't',
   'u',
   'b',
   'v',
   'E',
   'X',
   'T',
   0, // glVariantubvEXT
   'g',
   'l',
   'V',
   'a',
   'r',
   'i',
   'a',
   'n',
   't',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glVariantuivEXT
   'g',
   'l',
   'V',
   'a',
   'r',
   'i',
   'a',
   'n',
   't',
   'u',
   's',
   'v',
   'E',
   'X',
   'T',
   0, // glVariantusvEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '2',
   'b',
   'O',
   'E',
   'S',
   0, // glVertex2bOES
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '2',
   'b',
   'v',
   'O',
   'E',
   'S',
   0, // glVertex2bvOES
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '2',
   'd',
   0, // glVertex2d
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '2',
   'd',
   'v',
   0, // glVertex2dv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '2',
   'f',
   0, // glVertex2f
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '2',
   'f',
   'v',
   0, // glVertex2fv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '2',
   'h',
   'N',
   'V',
   0, // glVertex2hNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '2',
   'h',
   'v',
   'N',
   'V',
   0, // glVertex2hvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '2',
   'i',
   0, // glVertex2i
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '2',
   'i',
   'v',
   0, // glVertex2iv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '2',
   's',
   0, // glVertex2s
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '2',
   's',
   'v',
   0, // glVertex2sv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '2',
   'x',
   'O',
   'E',
   'S',
   0, // glVertex2xOES
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '2',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glVertex2xvOES
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'b',
   'O',
   'E',
   'S',
   0, // glVertex3bOES
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'b',
   'v',
   'O',
   'E',
   'S',
   0, // glVertex3bvOES
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'd',
   0, // glVertex3d
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'd',
   'v',
   0, // glVertex3dv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   0, // glVertex3f
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'f',
   'v',
   0, // glVertex3fv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'h',
   'N',
   'V',
   0, // glVertex3hNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'h',
   'v',
   'N',
   'V',
   0, // glVertex3hvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'i',
   0, // glVertex3i
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'i',
   'v',
   0, // glVertex3iv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   's',
   0, // glVertex3s
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   's',
   'v',
   0, // glVertex3sv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'x',
   'O',
   'E',
   'S',
   0, // glVertex3xOES
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '3',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glVertex3xvOES
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '4',
   'b',
   'O',
   'E',
   'S',
   0, // glVertex4bOES
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '4',
   'b',
   'v',
   'O',
   'E',
   'S',
   0, // glVertex4bvOES
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '4',
   'd',
   0, // glVertex4d
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '4',
   'd',
   'v',
   0, // glVertex4dv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '4',
   'f',
   0, // glVertex4f
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '4',
   'f',
   'v',
   0, // glVertex4fv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '4',
   'h',
   'N',
   'V',
   0, // glVertex4hNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '4',
   'h',
   'v',
   'N',
   'V',
   0, // glVertex4hvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '4',
   'i',
   0, // glVertex4i
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '4',
   'i',
   'v',
   0, // glVertex4iv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '4',
   's',
   0, // glVertex4s
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '4',
   's',
   'v',
   0, // glVertex4sv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '4',
   'x',
   'O',
   'E',
   'S',
   0, // glVertex4xOES
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   '4',
   'x',
   'v',
   'O',
   'E',
   'S',
   0, // glVertex4xvOES
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'B',
   'i',
   'n',
   'd',
   'i',
   'n',
   'g',
   0, // glVertexArrayAttribBinding
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'F',
   'o',
   'r',
   'm',
   'a',
   't',
   0, // glVertexArrayAttribFormat
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   'F',
   'o',
   'r',
   'm',
   'a',
   't',
   0, // glVertexArrayAttribIFormat
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   'F',
   'o',
   'r',
   'm',
   'a',
   't',
   0, // glVertexArrayAttribLFormat
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'B',
   'i',
   'n',
   'd',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glVertexArrayBindVertexBufferEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'B',
   'i',
   'n',
   'd',
   'i',
   'n',
   'g',
   'D',
   'i',
   'v',
   'i',
   's',
   'o',
   'r',
   0, // glVertexArrayBindingDivisor
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   'O',
   'f',
   'f',
   's',
   'e',
   't',
   'E',
   'X',
   'T',
   0, // glVertexArrayColorOffsetEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'E',
   'd',
   'g',
   'e',
   'F',
   'l',
   'a',
   'g',
   'O',
   'f',
   'f',
   's',
   'e',
   't',
   'E',
   'X',
   'T',
   0, // glVertexArrayEdgeFlagOffsetEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'E',
   'l',
   'e',
   'm',
   'e',
   'n',
   't',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glVertexArrayElementBuffer
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'F',
   'o',
   'g',
   'C',
   'o',
   'o',
   'r',
   'd',
   'O',
   'f',
   'f',
   's',
   'e',
   't',
   'E',
   'X',
   'T',
   0, // glVertexArrayFogCoordOffsetEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'I',
   'n',
   'd',
   'e',
   'x',
   'O',
   'f',
   'f',
   's',
   'e',
   't',
   'E',
   'X',
   'T',
   0, // glVertexArrayIndexOffsetEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'M',
   'u',
   'l',
   't',
   'i',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'O',
   'f',
   'f',
   's',
   'e',
   't',
   'E',
   'X',
   'T',
   0, // glVertexArrayMultiTexCoordOffsetEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'N',
   'o',
   'r',
   'm',
   'a',
   'l',
   'O',
   'f',
   'f',
   's',
   'e',
   't',
   'E',
   'X',
   'T',
   0, // glVertexArrayNormalOffsetEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glVertexArrayParameteriAPPLE
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'R',
   'a',
   'n',
   'g',
   'e',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glVertexArrayRangeAPPLE
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'R',
   'a',
   'n',
   'g',
   'e',
   'N',
   'V',
   0, // glVertexArrayRangeNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'S',
   'e',
   'c',
   'o',
   'n',
   'd',
   'a',
   'r',
   'y',
   'C',
   'o',
   'l',
   'o',
   'r',
   'O',
   'f',
   'f',
   's',
   'e',
   't',
   'E',
   'X',
   'T',
   0, // glVertexArraySecondaryColorOffsetEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'T',
   'e',
   'x',
   'C',
   'o',
   'o',
   'r',
   'd',
   'O',
   'f',
   'f',
   's',
   'e',
   't',
   'E',
   'X',
   'T',
   0, // glVertexArrayTexCoordOffsetEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'B',
   'i',
   'n',
   'd',
   'i',
   'n',
   'g',
   'E',
   'X',
   'T',
   0, // glVertexArrayVertexAttribBindingEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'D',
   'i',
   'v',
   'i',
   's',
   'o',
   'r',
   'E',
   'X',
   'T',
   0, // glVertexArrayVertexAttribDivisorEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'F',
   'o',
   'r',
   'm',
   'a',
   't',
   'E',
   'X',
   'T',
   0, // glVertexArrayVertexAttribFormatEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   'F',
   'o',
   'r',
   'm',
   'a',
   't',
   'E',
   'X',
   'T',
   0, // glVertexArrayVertexAttribIFormatEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   'O',
   'f',
   'f',
   's',
   'e',
   't',
   'E',
   'X',
   'T',
   0, // glVertexArrayVertexAttribIOffsetEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   'F',
   'o',
   'r',
   'm',
   'a',
   't',
   'E',
   'X',
   'T',
   0, // glVertexArrayVertexAttribLFormatEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   'O',
   'f',
   'f',
   's',
   'e',
   't',
   'E',
   'X',
   'T',
   0, // glVertexArrayVertexAttribLOffsetEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'O',
   'f',
   'f',
   's',
   'e',
   't',
   'E',
   'X',
   'T',
   0, // glVertexArrayVertexAttribOffsetEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'B',
   'i',
   'n',
   'd',
   'i',
   'n',
   'g',
   'D',
   'i',
   'v',
   'i',
   's',
   'o',
   'r',
   'E',
   'X',
   'T',
   0, // glVertexArrayVertexBindingDivisorEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   0, // glVertexArrayVertexBuffer
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'B',
   'u',
   'f',
   'f',
   'e',
   'r',
   's',
   0, // glVertexArrayVertexBuffers
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   'r',
   'r',
   'a',
   'y',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'O',
   'f',
   'f',
   's',
   'e',
   't',
   'E',
   'X',
   'T',
   0, // glVertexArrayVertexOffsetEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '1',
   'd',
   0, // glVertexAttrib1d
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '1',
   'd',
   'A',
   'R',
   'B',
   0, // glVertexAttrib1dARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '1',
   'd',
   'N',
   'V',
   0, // glVertexAttrib1dNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '1',
   'd',
   'v',
   0, // glVertexAttrib1dv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '1',
   'd',
   'v',
   'A',
   'R',
   'B',
   0, // glVertexAttrib1dvARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '1',
   'd',
   'v',
   'N',
   'V',
   0, // glVertexAttrib1dvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '1',
   'f',
   0, // glVertexAttrib1f
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '1',
   'f',
   'A',
   'R',
   'B',
   0, // glVertexAttrib1fARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '1',
   'f',
   'N',
   'V',
   0, // glVertexAttrib1fNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '1',
   'f',
   'v',
   0, // glVertexAttrib1fv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '1',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glVertexAttrib1fvARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '1',
   'f',
   'v',
   'N',
   'V',
   0, // glVertexAttrib1fvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '1',
   'h',
   'N',
   'V',
   0, // glVertexAttrib1hNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '1',
   'h',
   'v',
   'N',
   'V',
   0, // glVertexAttrib1hvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '1',
   's',
   0, // glVertexAttrib1s
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '1',
   's',
   'A',
   'R',
   'B',
   0, // glVertexAttrib1sARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '1',
   's',
   'N',
   'V',
   0, // glVertexAttrib1sNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '1',
   's',
   'v',
   0, // glVertexAttrib1sv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '1',
   's',
   'v',
   'A',
   'R',
   'B',
   0, // glVertexAttrib1svARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '1',
   's',
   'v',
   'N',
   'V',
   0, // glVertexAttrib1svNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '2',
   'd',
   0, // glVertexAttrib2d
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '2',
   'd',
   'A',
   'R',
   'B',
   0, // glVertexAttrib2dARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '2',
   'd',
   'N',
   'V',
   0, // glVertexAttrib2dNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '2',
   'd',
   'v',
   0, // glVertexAttrib2dv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '2',
   'd',
   'v',
   'A',
   'R',
   'B',
   0, // glVertexAttrib2dvARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '2',
   'd',
   'v',
   'N',
   'V',
   0, // glVertexAttrib2dvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '2',
   'f',
   0, // glVertexAttrib2f
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '2',
   'f',
   'A',
   'R',
   'B',
   0, // glVertexAttrib2fARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '2',
   'f',
   'N',
   'V',
   0, // glVertexAttrib2fNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '2',
   'f',
   'v',
   0, // glVertexAttrib2fv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '2',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glVertexAttrib2fvARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '2',
   'f',
   'v',
   'N',
   'V',
   0, // glVertexAttrib2fvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '2',
   'h',
   'N',
   'V',
   0, // glVertexAttrib2hNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '2',
   'h',
   'v',
   'N',
   'V',
   0, // glVertexAttrib2hvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '2',
   's',
   0, // glVertexAttrib2s
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '2',
   's',
   'A',
   'R',
   'B',
   0, // glVertexAttrib2sARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '2',
   's',
   'N',
   'V',
   0, // glVertexAttrib2sNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '2',
   's',
   'v',
   0, // glVertexAttrib2sv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '2',
   's',
   'v',
   'A',
   'R',
   'B',
   0, // glVertexAttrib2svARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '2',
   's',
   'v',
   'N',
   'V',
   0, // glVertexAttrib2svNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '3',
   'd',
   0, // glVertexAttrib3d
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '3',
   'd',
   'A',
   'R',
   'B',
   0, // glVertexAttrib3dARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '3',
   'd',
   'N',
   'V',
   0, // glVertexAttrib3dNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '3',
   'd',
   'v',
   0, // glVertexAttrib3dv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '3',
   'd',
   'v',
   'A',
   'R',
   'B',
   0, // glVertexAttrib3dvARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '3',
   'd',
   'v',
   'N',
   'V',
   0, // glVertexAttrib3dvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '3',
   'f',
   0, // glVertexAttrib3f
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '3',
   'f',
   'A',
   'R',
   'B',
   0, // glVertexAttrib3fARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '3',
   'f',
   'N',
   'V',
   0, // glVertexAttrib3fNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '3',
   'f',
   'v',
   0, // glVertexAttrib3fv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '3',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glVertexAttrib3fvARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '3',
   'f',
   'v',
   'N',
   'V',
   0, // glVertexAttrib3fvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '3',
   'h',
   'N',
   'V',
   0, // glVertexAttrib3hNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '3',
   'h',
   'v',
   'N',
   'V',
   0, // glVertexAttrib3hvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '3',
   's',
   0, // glVertexAttrib3s
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '3',
   's',
   'A',
   'R',
   'B',
   0, // glVertexAttrib3sARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '3',
   's',
   'N',
   'V',
   0, // glVertexAttrib3sNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '3',
   's',
   'v',
   0, // glVertexAttrib3sv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '3',
   's',
   'v',
   'A',
   'R',
   'B',
   0, // glVertexAttrib3svARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '3',
   's',
   'v',
   'N',
   'V',
   0, // glVertexAttrib3svNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'N',
   'b',
   'v',
   0, // glVertexAttrib4Nbv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'N',
   'b',
   'v',
   'A',
   'R',
   'B',
   0, // glVertexAttrib4NbvARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'N',
   'i',
   'v',
   0, // glVertexAttrib4Niv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'N',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glVertexAttrib4NivARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'N',
   's',
   'v',
   0, // glVertexAttrib4Nsv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'N',
   's',
   'v',
   'A',
   'R',
   'B',
   0, // glVertexAttrib4NsvARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'N',
   'u',
   'b',
   0, // glVertexAttrib4Nub
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'N',
   'u',
   'b',
   'A',
   'R',
   'B',
   0, // glVertexAttrib4NubARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'N',
   'u',
   'b',
   'v',
   0, // glVertexAttrib4Nubv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'N',
   'u',
   'b',
   'v',
   'A',
   'R',
   'B',
   0, // glVertexAttrib4NubvARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'N',
   'u',
   'i',
   'v',
   0, // glVertexAttrib4Nuiv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'N',
   'u',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glVertexAttrib4NuivARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'N',
   'u',
   's',
   'v',
   0, // glVertexAttrib4Nusv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'N',
   'u',
   's',
   'v',
   'A',
   'R',
   'B',
   0, // glVertexAttrib4NusvARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'b',
   'v',
   0, // glVertexAttrib4bv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'b',
   'v',
   'A',
   'R',
   'B',
   0, // glVertexAttrib4bvARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'd',
   0, // glVertexAttrib4d
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'd',
   'A',
   'R',
   'B',
   0, // glVertexAttrib4dARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'd',
   'N',
   'V',
   0, // glVertexAttrib4dNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'd',
   'v',
   0, // glVertexAttrib4dv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'd',
   'v',
   'A',
   'R',
   'B',
   0, // glVertexAttrib4dvARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'd',
   'v',
   'N',
   'V',
   0, // glVertexAttrib4dvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'f',
   0, // glVertexAttrib4f
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'f',
   'A',
   'R',
   'B',
   0, // glVertexAttrib4fARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'f',
   'N',
   'V',
   0, // glVertexAttrib4fNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'f',
   'v',
   0, // glVertexAttrib4fv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glVertexAttrib4fvARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'f',
   'v',
   'N',
   'V',
   0, // glVertexAttrib4fvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'h',
   'N',
   'V',
   0, // glVertexAttrib4hNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'h',
   'v',
   'N',
   'V',
   0, // glVertexAttrib4hvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'i',
   'v',
   0, // glVertexAttrib4iv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glVertexAttrib4ivARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   's',
   0, // glVertexAttrib4s
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   's',
   'A',
   'R',
   'B',
   0, // glVertexAttrib4sARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   's',
   'N',
   'V',
   0, // glVertexAttrib4sNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   's',
   'v',
   0, // glVertexAttrib4sv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   's',
   'v',
   'A',
   'R',
   'B',
   0, // glVertexAttrib4svARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   's',
   'v',
   'N',
   'V',
   0, // glVertexAttrib4svNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'u',
   'b',
   'N',
   'V',
   0, // glVertexAttrib4ubNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'u',
   'b',
   'v',
   0, // glVertexAttrib4ubv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'u',
   'b',
   'v',
   'A',
   'R',
   'B',
   0, // glVertexAttrib4ubvARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'u',
   'b',
   'v',
   'N',
   'V',
   0, // glVertexAttrib4ubvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'u',
   'i',
   'v',
   0, // glVertexAttrib4uiv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'u',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glVertexAttrib4uivARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'u',
   's',
   'v',
   0, // glVertexAttrib4usv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   '4',
   'u',
   's',
   'v',
   'A',
   'R',
   'B',
   0, // glVertexAttrib4usvARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'A',
   'r',
   'r',
   'a',
   'y',
   'O',
   'b',
   'j',
   'e',
   'c',
   't',
   'A',
   'T',
   'I',
   0, // glVertexAttribArrayObjectATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'B',
   'i',
   'n',
   'd',
   'i',
   'n',
   'g',
   0, // glVertexAttribBinding
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'D',
   'i',
   'v',
   'i',
   's',
   'o',
   'r',
   0, // glVertexAttribDivisor
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'D',
   'i',
   'v',
   'i',
   's',
   'o',
   'r',
   'A',
   'N',
   'G',
   'L',
   'E',
   0, // glVertexAttribDivisorANGLE
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'D',
   'i',
   'v',
   'i',
   's',
   'o',
   'r',
   'A',
   'R',
   'B',
   0, // glVertexAttribDivisorARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'D',
   'i',
   'v',
   'i',
   's',
   'o',
   'r',
   'E',
   'X',
   'T',
   0, // glVertexAttribDivisorEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'D',
   'i',
   'v',
   'i',
   's',
   'o',
   'r',
   'N',
   'V',
   0, // glVertexAttribDivisorNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'F',
   'o',
   'r',
   'm',
   'a',
   't',
   0, // glVertexAttribFormat
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'F',
   'o',
   'r',
   'm',
   'a',
   't',
   'N',
   'V',
   0, // glVertexAttribFormatNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '1',
   'i',
   0, // glVertexAttribI1i
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '1',
   'i',
   'E',
   'X',
   'T',
   0, // glVertexAttribI1iEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '1',
   'i',
   'v',
   0, // glVertexAttribI1iv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '1',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glVertexAttribI1ivEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '1',
   'u',
   'i',
   0, // glVertexAttribI1ui
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '1',
   'u',
   'i',
   'E',
   'X',
   'T',
   0, // glVertexAttribI1uiEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '1',
   'u',
   'i',
   'v',
   0, // glVertexAttribI1uiv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '1',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glVertexAttribI1uivEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '2',
   'i',
   0, // glVertexAttribI2i
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '2',
   'i',
   'E',
   'X',
   'T',
   0, // glVertexAttribI2iEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '2',
   'i',
   'v',
   0, // glVertexAttribI2iv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '2',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glVertexAttribI2ivEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '2',
   'u',
   'i',
   0, // glVertexAttribI2ui
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '2',
   'u',
   'i',
   'E',
   'X',
   'T',
   0, // glVertexAttribI2uiEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '2',
   'u',
   'i',
   'v',
   0, // glVertexAttribI2uiv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '2',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glVertexAttribI2uivEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '3',
   'i',
   0, // glVertexAttribI3i
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '3',
   'i',
   'E',
   'X',
   'T',
   0, // glVertexAttribI3iEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '3',
   'i',
   'v',
   0, // glVertexAttribI3iv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '3',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glVertexAttribI3ivEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '3',
   'u',
   'i',
   0, // glVertexAttribI3ui
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '3',
   'u',
   'i',
   'E',
   'X',
   'T',
   0, // glVertexAttribI3uiEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '3',
   'u',
   'i',
   'v',
   0, // glVertexAttribI3uiv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '3',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glVertexAttribI3uivEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '4',
   'b',
   'v',
   0, // glVertexAttribI4bv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '4',
   'b',
   'v',
   'E',
   'X',
   'T',
   0, // glVertexAttribI4bvEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '4',
   'i',
   0, // glVertexAttribI4i
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '4',
   'i',
   'E',
   'X',
   'T',
   0, // glVertexAttribI4iEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '4',
   'i',
   'v',
   0, // glVertexAttribI4iv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '4',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glVertexAttribI4ivEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '4',
   's',
   'v',
   0, // glVertexAttribI4sv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '4',
   's',
   'v',
   'E',
   'X',
   'T',
   0, // glVertexAttribI4svEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '4',
   'u',
   'b',
   'v',
   0, // glVertexAttribI4ubv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '4',
   'u',
   'b',
   'v',
   'E',
   'X',
   'T',
   0, // glVertexAttribI4ubvEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '4',
   'u',
   'i',
   0, // glVertexAttribI4ui
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '4',
   'u',
   'i',
   'E',
   'X',
   'T',
   0, // glVertexAttribI4uiEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '4',
   'u',
   'i',
   'v',
   0, // glVertexAttribI4uiv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '4',
   'u',
   'i',
   'v',
   'E',
   'X',
   'T',
   0, // glVertexAttribI4uivEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '4',
   'u',
   's',
   'v',
   0, // glVertexAttribI4usv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   '4',
   'u',
   's',
   'v',
   'E',
   'X',
   'T',
   0, // glVertexAttribI4usvEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   'F',
   'o',
   'r',
   'm',
   'a',
   't',
   0, // glVertexAttribIFormat
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   'F',
   'o',
   'r',
   'm',
   'a',
   't',
   'N',
   'V',
   0, // glVertexAttribIFormatNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   0, // glVertexAttribIPointer
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'I',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glVertexAttribIPointerEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '1',
   'd',
   0, // glVertexAttribL1d
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '1',
   'd',
   'E',
   'X',
   'T',
   0, // glVertexAttribL1dEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '1',
   'd',
   'v',
   0, // glVertexAttribL1dv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '1',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glVertexAttribL1dvEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '1',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glVertexAttribL1i64NV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '1',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glVertexAttribL1i64vNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '1',
   'u',
   'i',
   '6',
   '4',
   'A',
   'R',
   'B',
   0, // glVertexAttribL1ui64ARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '1',
   'u',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glVertexAttribL1ui64NV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '1',
   'u',
   'i',
   '6',
   '4',
   'v',
   'A',
   'R',
   'B',
   0, // glVertexAttribL1ui64vARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '1',
   'u',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glVertexAttribL1ui64vNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '2',
   'd',
   0, // glVertexAttribL2d
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '2',
   'd',
   'E',
   'X',
   'T',
   0, // glVertexAttribL2dEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '2',
   'd',
   'v',
   0, // glVertexAttribL2dv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '2',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glVertexAttribL2dvEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '2',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glVertexAttribL2i64NV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '2',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glVertexAttribL2i64vNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '2',
   'u',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glVertexAttribL2ui64NV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '2',
   'u',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glVertexAttribL2ui64vNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '3',
   'd',
   0, // glVertexAttribL3d
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '3',
   'd',
   'E',
   'X',
   'T',
   0, // glVertexAttribL3dEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '3',
   'd',
   'v',
   0, // glVertexAttribL3dv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '3',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glVertexAttribL3dvEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '3',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glVertexAttribL3i64NV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '3',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glVertexAttribL3i64vNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '3',
   'u',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glVertexAttribL3ui64NV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '3',
   'u',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glVertexAttribL3ui64vNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '4',
   'd',
   0, // glVertexAttribL4d
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '4',
   'd',
   'E',
   'X',
   'T',
   0, // glVertexAttribL4dEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '4',
   'd',
   'v',
   0, // glVertexAttribL4dv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '4',
   'd',
   'v',
   'E',
   'X',
   'T',
   0, // glVertexAttribL4dvEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '4',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glVertexAttribL4i64NV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '4',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glVertexAttribL4i64vNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '4',
   'u',
   'i',
   '6',
   '4',
   'N',
   'V',
   0, // glVertexAttribL4ui64NV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   '4',
   'u',
   'i',
   '6',
   '4',
   'v',
   'N',
   'V',
   0, // glVertexAttribL4ui64vNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   'F',
   'o',
   'r',
   'm',
   'a',
   't',
   0, // glVertexAttribLFormat
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   'F',
   'o',
   'r',
   'm',
   'a',
   't',
   'N',
   'V',
   0, // glVertexAttribLFormatNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   0, // glVertexAttribLPointer
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'L',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glVertexAttribLPointerEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'P',
   '1',
   'u',
   'i',
   0, // glVertexAttribP1ui
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'P',
   '1',
   'u',
   'i',
   'v',
   0, // glVertexAttribP1uiv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'P',
   '2',
   'u',
   'i',
   0, // glVertexAttribP2ui
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'P',
   '2',
   'u',
   'i',
   'v',
   0, // glVertexAttribP2uiv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'P',
   '3',
   'u',
   'i',
   0, // glVertexAttribP3ui
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'P',
   '3',
   'u',
   'i',
   'v',
   0, // glVertexAttribP3uiv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'P',
   '4',
   'u',
   'i',
   0, // glVertexAttribP4ui
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'P',
   '4',
   'u',
   'i',
   'v',
   0, // glVertexAttribP4uiv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'A',
   'M',
   'D',
   0, // glVertexAttribParameteriAMD
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   0, // glVertexAttribPointer
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'A',
   'R',
   'B',
   0, // glVertexAttribPointerARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'N',
   'V',
   0, // glVertexAttribPointerNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   's',
   '1',
   'd',
   'v',
   'N',
   'V',
   0, // glVertexAttribs1dvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   's',
   '1',
   'f',
   'v',
   'N',
   'V',
   0, // glVertexAttribs1fvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   's',
   '1',
   'h',
   'v',
   'N',
   'V',
   0, // glVertexAttribs1hvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   's',
   '1',
   's',
   'v',
   'N',
   'V',
   0, // glVertexAttribs1svNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   's',
   '2',
   'd',
   'v',
   'N',
   'V',
   0, // glVertexAttribs2dvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   's',
   '2',
   'f',
   'v',
   'N',
   'V',
   0, // glVertexAttribs2fvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   's',
   '2',
   'h',
   'v',
   'N',
   'V',
   0, // glVertexAttribs2hvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   's',
   '2',
   's',
   'v',
   'N',
   'V',
   0, // glVertexAttribs2svNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   's',
   '3',
   'd',
   'v',
   'N',
   'V',
   0, // glVertexAttribs3dvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   's',
   '3',
   'f',
   'v',
   'N',
   'V',
   0, // glVertexAttribs3fvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   's',
   '3',
   'h',
   'v',
   'N',
   'V',
   0, // glVertexAttribs3hvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   's',
   '3',
   's',
   'v',
   'N',
   'V',
   0, // glVertexAttribs3svNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   's',
   '4',
   'd',
   'v',
   'N',
   'V',
   0, // glVertexAttribs4dvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   's',
   '4',
   'f',
   'v',
   'N',
   'V',
   0, // glVertexAttribs4fvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   's',
   '4',
   'h',
   'v',
   'N',
   'V',
   0, // glVertexAttribs4hvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   's',
   '4',
   's',
   'v',
   'N',
   'V',
   0, // glVertexAttribs4svNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'A',
   't',
   't',
   'r',
   'i',
   'b',
   's',
   '4',
   'u',
   'b',
   'v',
   'N',
   'V',
   0, // glVertexAttribs4ubvNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'B',
   'i',
   'n',
   'd',
   'i',
   'n',
   'g',
   'D',
   'i',
   'v',
   'i',
   's',
   'o',
   'r',
   0, // glVertexBindingDivisor
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'B',
   'l',
   'e',
   'n',
   'd',
   'A',
   'R',
   'B',
   0, // glVertexBlendARB
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'B',
   'l',
   'e',
   'n',
   'd',
   'E',
   'n',
   'v',
   'f',
   'A',
   'T',
   'I',
   0, // glVertexBlendEnvfATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'B',
   'l',
   'e',
   'n',
   'd',
   'E',
   'n',
   'v',
   'i',
   'A',
   'T',
   'I',
   0, // glVertexBlendEnviATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'F',
   'o',
   'r',
   'm',
   'a',
   't',
   'N',
   'V',
   0, // glVertexFormatNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'P',
   '2',
   'u',
   'i',
   0, // glVertexP2ui
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'P',
   '2',
   'u',
   'i',
   'v',
   0, // glVertexP2uiv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'P',
   '3',
   'u',
   'i',
   0, // glVertexP3ui
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'P',
   '3',
   'u',
   'i',
   'v',
   0, // glVertexP3uiv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'P',
   '4',
   'u',
   'i',
   0, // glVertexP4ui
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'P',
   '4',
   'u',
   'i',
   'v',
   0, // glVertexP4uiv
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   0, // glVertexPointer
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glVertexPointerEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'L',
   'i',
   's',
   't',
   'I',
   'B',
   'M',
   0, // glVertexPointerListIBM
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'v',
   'I',
   'N',
   'T',
   'E',
   'L',
   0, // glVertexPointervINTEL
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '1',
   'd',
   'A',
   'T',
   'I',
   0, // glVertexStream1dATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '1',
   'd',
   'v',
   'A',
   'T',
   'I',
   0, // glVertexStream1dvATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '1',
   'f',
   'A',
   'T',
   'I',
   0, // glVertexStream1fATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '1',
   'f',
   'v',
   'A',
   'T',
   'I',
   0, // glVertexStream1fvATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '1',
   'i',
   'A',
   'T',
   'I',
   0, // glVertexStream1iATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '1',
   'i',
   'v',
   'A',
   'T',
   'I',
   0, // glVertexStream1ivATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '1',
   's',
   'A',
   'T',
   'I',
   0, // glVertexStream1sATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '1',
   's',
   'v',
   'A',
   'T',
   'I',
   0, // glVertexStream1svATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '2',
   'd',
   'A',
   'T',
   'I',
   0, // glVertexStream2dATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '2',
   'd',
   'v',
   'A',
   'T',
   'I',
   0, // glVertexStream2dvATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '2',
   'f',
   'A',
   'T',
   'I',
   0, // glVertexStream2fATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '2',
   'f',
   'v',
   'A',
   'T',
   'I',
   0, // glVertexStream2fvATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '2',
   'i',
   'A',
   'T',
   'I',
   0, // glVertexStream2iATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '2',
   'i',
   'v',
   'A',
   'T',
   'I',
   0, // glVertexStream2ivATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '2',
   's',
   'A',
   'T',
   'I',
   0, // glVertexStream2sATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '2',
   's',
   'v',
   'A',
   'T',
   'I',
   0, // glVertexStream2svATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '3',
   'd',
   'A',
   'T',
   'I',
   0, // glVertexStream3dATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '3',
   'd',
   'v',
   'A',
   'T',
   'I',
   0, // glVertexStream3dvATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '3',
   'f',
   'A',
   'T',
   'I',
   0, // glVertexStream3fATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '3',
   'f',
   'v',
   'A',
   'T',
   'I',
   0, // glVertexStream3fvATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '3',
   'i',
   'A',
   'T',
   'I',
   0, // glVertexStream3iATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '3',
   'i',
   'v',
   'A',
   'T',
   'I',
   0, // glVertexStream3ivATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '3',
   's',
   'A',
   'T',
   'I',
   0, // glVertexStream3sATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '3',
   's',
   'v',
   'A',
   'T',
   'I',
   0, // glVertexStream3svATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '4',
   'd',
   'A',
   'T',
   'I',
   0, // glVertexStream4dATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '4',
   'd',
   'v',
   'A',
   'T',
   'I',
   0, // glVertexStream4dvATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '4',
   'f',
   'A',
   'T',
   'I',
   0, // glVertexStream4fATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '4',
   'f',
   'v',
   'A',
   'T',
   'I',
   0, // glVertexStream4fvATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '4',
   'i',
   'A',
   'T',
   'I',
   0, // glVertexStream4iATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '4',
   'i',
   'v',
   'A',
   'T',
   'I',
   0, // glVertexStream4ivATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '4',
   's',
   'A',
   'T',
   'I',
   0, // glVertexStream4sATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   '4',
   's',
   'v',
   'A',
   'T',
   'I',
   0, // glVertexStream4svATI
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'W',
   'e',
   'i',
   'g',
   'h',
   't',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'E',
   'X',
   'T',
   0, // glVertexWeightPointerEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'W',
   'e',
   'i',
   'g',
   'h',
   't',
   'f',
   'E',
   'X',
   'T',
   0, // glVertexWeightfEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'W',
   'e',
   'i',
   'g',
   'h',
   't',
   'f',
   'v',
   'E',
   'X',
   'T',
   0, // glVertexWeightfvEXT
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'W',
   'e',
   'i',
   'g',
   'h',
   't',
   'h',
   'N',
   'V',
   0, // glVertexWeighthNV
   'g',
   'l',
   'V',
   'e',
   'r',
   't',
   'e',
   'x',
   'W',
   'e',
   'i',
   'g',
   'h',
   't',
   'h',
   'v',
   'N',
   'V',
   0, // glVertexWeighthvNV
   'g',
   'l',
   'V',
   'i',
   'd',
   'e',
   'o',
   'C',
   'a',
   'p',
   't',
   'u',
   'r',
   'e',
   'N',
   'V',
   0, // glVideoCaptureNV
   'g',
   'l',
   'V',
   'i',
   'd',
   'e',
   'o',
   'C',
   'a',
   'p',
   't',
   'u',
   'r',
   'e',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'd',
   'v',
   'N',
   'V',
   0, // glVideoCaptureStreamParameterdvNV
   'g',
   'l',
   'V',
   'i',
   'd',
   'e',
   'o',
   'C',
   'a',
   'p',
   't',
   'u',
   'r',
   'e',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'f',
   'v',
   'N',
   'V',
   0, // glVideoCaptureStreamParameterfvNV
   'g',
   'l',
   'V',
   'i',
   'd',
   'e',
   'o',
   'C',
   'a',
   'p',
   't',
   'u',
   'r',
   'e',
   'S',
   't',
   'r',
   'e',
   'a',
   'm',
   'P',
   'a',
   'r',
   'a',
   'm',
   'e',
   't',
   'e',
   'r',
   'i',
   'v',
   'N',
   'V',
   0, // glVideoCaptureStreamParameterivNV
   'g',
   'l',
   'V',
   'i',
   'e',
   'w',
   'p',
   'o',
   'r',
   't',
   0, // glViewport
   'g',
   'l',
   'V',
   'i',
   'e',
   'w',
   'p',
   'o',
   'r',
   't',
   'A',
   'r',
   'r',
   'a',
   'y',
   'v',
   0, // glViewportArrayv
   'g',
   'l',
   'V',
   'i',
   'e',
   'w',
   'p',
   'o',
   'r',
   't',
   'A',
   'r',
   'r',
   'a',
   'y',
   'v',
   'N',
   'V',
   0, // glViewportArrayvNV
   'g',
   'l',
   'V',
   'i',
   'e',
   'w',
   'p',
   'o',
   'r',
   't',
   'A',
   'r',
   'r',
   'a',
   'y',
   'v',
   'O',
   'E',
   'S',
   0, // glViewportArrayvOES
   'g',
   'l',
   'V',
   'i',
   'e',
   'w',
   'p',
   'o',
   'r',
   't',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'f',
   0, // glViewportIndexedf
   'g',
   'l',
   'V',
   'i',
   'e',
   'w',
   'p',
   'o',
   'r',
   't',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'f',
   'N',
   'V',
   0, // glViewportIndexedfNV
   'g',
   'l',
   'V',
   'i',
   'e',
   'w',
   'p',
   'o',
   'r',
   't',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'f',
   'O',
   'E',
   'S',
   0, // glViewportIndexedfOES
   'g',
   'l',
   'V',
   'i',
   'e',
   'w',
   'p',
   'o',
   'r',
   't',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'f',
   'v',
   0, // glViewportIndexedfv
   'g',
   'l',
   'V',
   'i',
   'e',
   'w',
   'p',
   'o',
   'r',
   't',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'f',
   'v',
   'N',
   'V',
   0, // glViewportIndexedfvNV
   'g',
   'l',
   'V',
   'i',
   'e',
   'w',
   'p',
   'o',
   'r',
   't',
   'I',
   'n',
   'd',
   'e',
   'x',
   'e',
   'd',
   'f',
   'v',
   'O',
   'E',
   'S',
   0, // glViewportIndexedfvOES
   'g',
   'l',
   'V',
   'i',
   'e',
   'w',
   'p',
   'o',
   'r',
   't',
   'P',
   'o',
   's',
   'i',
   't',
   'i',
   'o',
   'n',
   'W',
   'S',
   'c',
   'a',
   'l',
   'e',
   'N',
   'V',
   0, // glViewportPositionWScaleNV
   'g',
   'l',
   'V',
   'i',
   'e',
   'w',
   'p',
   'o',
   'r',
   't',
   'S',
   'w',
   'i',
   'z',
   'z',
   'l',
   'e',
   'N',
   'V',
   0, // glViewportSwizzleNV
   'g',
   'l',
   'W',
   'a',
   'i',
   't',
   'S',
   'e',
   'm',
   'a',
   'p',
   'h',
   'o',
   'r',
   'e',
   'E',
   'X',
   'T',
   0, // glWaitSemaphoreEXT
   'g',
   'l',
   'W',
   'a',
   'i',
   't',
   'S',
   'y',
   'n',
   'c',
   0, // glWaitSync
   'g',
   'l',
   'W',
   'a',
   'i',
   't',
   'S',
   'y',
   'n',
   'c',
   'A',
   'P',
   'P',
   'L',
   'E',
   0, // glWaitSyncAPPLE
   'g',
   'l',
   'W',
   'a',
   'i',
   't',
   'V',
   'k',
   'S',
   'e',
   'm',
   'a',
   'p',
   'h',
   'o',
   'r',
   'e',
   'N',
   'V',
   0, // glWaitVkSemaphoreNV
   'g',
   'l',
   'W',
   'e',
   'i',
   'g',
   'h',
   't',
   'P',
   'a',
   't',
   'h',
   's',
   'N',
   'V',
   0, // glWeightPathsNV
   'g',
   'l',
   'W',
   'e',
   'i',
   'g',
   'h',
   't',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'A',
   'R',
   'B',
   0, // glWeightPointerARB
   'g',
   'l',
   'W',
   'e',
   'i',
   'g',
   'h',
   't',
   'P',
   'o',
   'i',
   'n',
   't',
   'e',
   'r',
   'O',
   'E',
   'S',
   0, // glWeightPointerOES
   'g',
   'l',
   'W',
   'e',
   'i',
   'g',
   'h',
   't',
   'b',
   'v',
   'A',
   'R',
   'B',
   0, // glWeightbvARB
   'g',
   'l',
   'W',
   'e',
   'i',
   'g',
   'h',
   't',
   'd',
   'v',
   'A',
   'R',
   'B',
   0, // glWeightdvARB
   'g',
   'l',
   'W',
   'e',
   'i',
   'g',
   'h',
   't',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glWeightfvARB
   'g',
   'l',
   'W',
   'e',
   'i',
   'g',
   'h',
   't',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glWeightivARB
   'g',
   'l',
   'W',
   'e',
   'i',
   'g',
   'h',
   't',
   's',
   'v',
   'A',
   'R',
   'B',
   0, // glWeightsvARB
   'g',
   'l',
   'W',
   'e',
   'i',
   'g',
   'h',
   't',
   'u',
   'b',
   'v',
   'A',
   'R',
   'B',
   0, // glWeightubvARB
   'g',
   'l',
   'W',
   'e',
   'i',
   'g',
   'h',
   't',
   'u',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glWeightuivARB
   'g',
   'l',
   'W',
   'e',
   'i',
   'g',
   'h',
   't',
   'u',
   's',
   'v',
   'A',
   'R',
   'B',
   0, // glWeightusvARB
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '2',
   'd',
   0, // glWindowPos2d
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '2',
   'd',
   'A',
   'R',
   'B',
   0, // glWindowPos2dARB
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '2',
   'd',
   'M',
   'E',
   'S',
   'A',
   0, // glWindowPos2dMESA
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '2',
   'd',
   'v',
   0, // glWindowPos2dv
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '2',
   'd',
   'v',
   'A',
   'R',
   'B',
   0, // glWindowPos2dvARB
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '2',
   'd',
   'v',
   'M',
   'E',
   'S',
   'A',
   0, // glWindowPos2dvMESA
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '2',
   'f',
   0, // glWindowPos2f
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '2',
   'f',
   'A',
   'R',
   'B',
   0, // glWindowPos2fARB
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '2',
   'f',
   'M',
   'E',
   'S',
   'A',
   0, // glWindowPos2fMESA
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '2',
   'f',
   'v',
   0, // glWindowPos2fv
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '2',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glWindowPos2fvARB
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '2',
   'f',
   'v',
   'M',
   'E',
   'S',
   'A',
   0, // glWindowPos2fvMESA
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '2',
   'i',
   0, // glWindowPos2i
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '2',
   'i',
   'A',
   'R',
   'B',
   0, // glWindowPos2iARB
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '2',
   'i',
   'M',
   'E',
   'S',
   'A',
   0, // glWindowPos2iMESA
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '2',
   'i',
   'v',
   0, // glWindowPos2iv
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '2',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glWindowPos2ivARB
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '2',
   'i',
   'v',
   'M',
   'E',
   'S',
   'A',
   0, // glWindowPos2ivMESA
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '2',
   's',
   0, // glWindowPos2s
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '2',
   's',
   'A',
   'R',
   'B',
   0, // glWindowPos2sARB
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '2',
   's',
   'M',
   'E',
   'S',
   'A',
   0, // glWindowPos2sMESA
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '2',
   's',
   'v',
   0, // glWindowPos2sv
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '2',
   's',
   'v',
   'A',
   'R',
   'B',
   0, // glWindowPos2svARB
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '2',
   's',
   'v',
   'M',
   'E',
   'S',
   'A',
   0, // glWindowPos2svMESA
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '3',
   'd',
   0, // glWindowPos3d
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '3',
   'd',
   'A',
   'R',
   'B',
   0, // glWindowPos3dARB
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '3',
   'd',
   'M',
   'E',
   'S',
   'A',
   0, // glWindowPos3dMESA
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '3',
   'd',
   'v',
   0, // glWindowPos3dv
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '3',
   'd',
   'v',
   'A',
   'R',
   'B',
   0, // glWindowPos3dvARB
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '3',
   'd',
   'v',
   'M',
   'E',
   'S',
   'A',
   0, // glWindowPos3dvMESA
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '3',
   'f',
   0, // glWindowPos3f
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '3',
   'f',
   'A',
   'R',
   'B',
   0, // glWindowPos3fARB
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '3',
   'f',
   'M',
   'E',
   'S',
   'A',
   0, // glWindowPos3fMESA
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '3',
   'f',
   'v',
   0, // glWindowPos3fv
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '3',
   'f',
   'v',
   'A',
   'R',
   'B',
   0, // glWindowPos3fvARB
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '3',
   'f',
   'v',
   'M',
   'E',
   'S',
   'A',
   0, // glWindowPos3fvMESA
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '3',
   'i',
   0, // glWindowPos3i
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '3',
   'i',
   'A',
   'R',
   'B',
   0, // glWindowPos3iARB
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '3',
   'i',
   'M',
   'E',
   'S',
   'A',
   0, // glWindowPos3iMESA
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '3',
   'i',
   'v',
   0, // glWindowPos3iv
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '3',
   'i',
   'v',
   'A',
   'R',
   'B',
   0, // glWindowPos3ivARB
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '3',
   'i',
   'v',
   'M',
   'E',
   'S',
   'A',
   0, // glWindowPos3ivMESA
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '3',
   's',
   0, // glWindowPos3s
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '3',
   's',
   'A',
   'R',
   'B',
   0, // glWindowPos3sARB
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '3',
   's',
   'M',
   'E',
   'S',
   'A',
   0, // glWindowPos3sMESA
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '3',
   's',
   'v',
   0, // glWindowPos3sv
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '3',
   's',
   'v',
   'A',
   'R',
   'B',
   0, // glWindowPos3svARB
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '3',
   's',
   'v',
   'M',
   'E',
   'S',
   'A',
   0, // glWindowPos3svMESA
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '4',
   'd',
   'M',
   'E',
   'S',
   'A',
   0, // glWindowPos4dMESA
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '4',
   'd',
   'v',
   'M',
   'E',
   'S',
   'A',
   0, // glWindowPos4dvMESA
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '4',
   'f',
   'M',
   'E',
   'S',
   'A',
   0, // glWindowPos4fMESA
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '4',
   'f',
   'v',
   'M',
   'E',
   'S',
   'A',
   0, // glWindowPos4fvMESA
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '4',
   'i',
   'M',
   'E',
   'S',
   'A',
   0, // glWindowPos4iMESA
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '4',
   'i',
   'v',
   'M',
   'E',
   'S',
   'A',
   0, // glWindowPos4ivMESA
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '4',
   's',
   'M',
   'E',
   'S',
   'A',
   0, // glWindowPos4sMESA
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'P',
   'o',
   's',
   '4',
   's',
   'v',
   'M',
   'E',
   'S',
   'A',
   0, // glWindowPos4svMESA
   'g',
   'l',
   'W',
   'i',
   'n',
   'd',
   'o',
   'w',
   'R',
   'e',
   'c',
   't',
   'a',
   'n',
   'g',
   'l',
   'e',
   's',
   'E',
   'X',
   'T',
   0, // glWindowRectanglesEXT
   'g',
   'l',
   'W',
   'r',
   'i',
   't',
   'e',
   'M',
   'a',
   's',
   'k',
   'E',
   'X',
   'T',
   0, // glWriteMaskEXT
    0 };

static void *gl_provider_resolver(const char *name,
                                   const enum gl_provider *providers,
                                   const uint32_t *entrypoints)
{
    int i;
    for (i = 0; providers[i] != gl_provider_terminator; i++) {
        switch (providers[i]) {
        case Desktop_OpenGL_1_0:
            if (epoxy_is_desktop_gl())
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 10);
            break;
        case Desktop_OpenGL_1_1:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 11)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 11);
            break;
        case Desktop_OpenGL_1_2:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 12)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 12);
            break;
        case Desktop_OpenGL_1_3:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 13)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 13);
            break;
        case Desktop_OpenGL_1_4:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 14)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 14);
            break;
        case Desktop_OpenGL_1_5:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 15)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 15);
            break;
        case Desktop_OpenGL_2_0:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 20)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 20);
            break;
        case Desktop_OpenGL_2_1:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 21)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 21);
            break;
        case Desktop_OpenGL_3_0:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 30)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 30);
            break;
        case Desktop_OpenGL_3_1:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 31)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 31);
            break;
        case Desktop_OpenGL_3_2:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 32)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 32);
            break;
        case Desktop_OpenGL_3_3:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 33)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 33);
            break;
        case Desktop_OpenGL_4_0:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 40)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 40);
            break;
        case Desktop_OpenGL_4_1:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 41)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 41);
            break;
        case Desktop_OpenGL_4_2:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 42)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 42);
            break;
        case Desktop_OpenGL_4_3:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 43)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 43);
            break;
        case Desktop_OpenGL_4_4:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 44)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 44);
            break;
        case Desktop_OpenGL_4_5:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 45)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 45);
            break;
        case Desktop_OpenGL_4_6:
            if (epoxy_is_desktop_gl() && epoxy_conservative_gl_version() >= 46)
                return epoxy_get_core_proc_address(entrypoint_strings + entrypoints[i], 46);
            break;
        case GL_extension_GL_3DFX_tbuffer:
            if (epoxy_conservative_has_gl_extension("GL_3DFX_tbuffer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_debug_output:
            if (epoxy_conservative_has_gl_extension("GL_AMD_debug_output"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_draw_buffers_blend:
            if (epoxy_conservative_has_gl_extension("GL_AMD_draw_buffers_blend"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_framebuffer_sample_positions:
            if (epoxy_conservative_has_gl_extension("GL_AMD_framebuffer_sample_positions"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_gpu_shader_int64:
            if (epoxy_conservative_has_gl_extension("GL_AMD_gpu_shader_int64"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_interleaved_elements:
            if (epoxy_conservative_has_gl_extension("GL_AMD_interleaved_elements"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_multi_draw_indirect:
            if (epoxy_conservative_has_gl_extension("GL_AMD_multi_draw_indirect"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_name_gen_delete:
            if (epoxy_conservative_has_gl_extension("GL_AMD_name_gen_delete"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_occlusion_query_event:
            if (epoxy_conservative_has_gl_extension("GL_AMD_occlusion_query_event"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_performance_monitor:
            if (epoxy_conservative_has_gl_extension("GL_AMD_performance_monitor"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_sample_positions:
            if (epoxy_conservative_has_gl_extension("GL_AMD_sample_positions"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_sparse_texture:
            if (epoxy_conservative_has_gl_extension("GL_AMD_sparse_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_stencil_operation_extended:
            if (epoxy_conservative_has_gl_extension("GL_AMD_stencil_operation_extended"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_AMD_vertex_shader_tessellator:
            if (epoxy_conservative_has_gl_extension("GL_AMD_vertex_shader_tessellator"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ANGLE_framebuffer_blit:
            if (epoxy_conservative_has_gl_extension("GL_ANGLE_framebuffer_blit"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ANGLE_framebuffer_multisample:
            if (epoxy_conservative_has_gl_extension("GL_ANGLE_framebuffer_multisample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ANGLE_instanced_arrays:
            if (epoxy_conservative_has_gl_extension("GL_ANGLE_instanced_arrays"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ANGLE_translated_shader_source:
            if (epoxy_conservative_has_gl_extension("GL_ANGLE_translated_shader_source"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_APPLE_copy_texture_levels:
            if (epoxy_conservative_has_gl_extension("GL_APPLE_copy_texture_levels"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_APPLE_element_array:
            if (epoxy_conservative_has_gl_extension("GL_APPLE_element_array"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_APPLE_fence:
            if (epoxy_conservative_has_gl_extension("GL_APPLE_fence"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_APPLE_flush_buffer_range:
            if (epoxy_conservative_has_gl_extension("GL_APPLE_flush_buffer_range"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_APPLE_framebuffer_multisample:
            if (epoxy_conservative_has_gl_extension("GL_APPLE_framebuffer_multisample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_APPLE_object_purgeable:
            if (epoxy_conservative_has_gl_extension("GL_APPLE_object_purgeable"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_APPLE_sync:
            if (epoxy_conservative_has_gl_extension("GL_APPLE_sync"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_APPLE_texture_range:
            if (epoxy_conservative_has_gl_extension("GL_APPLE_texture_range"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_APPLE_vertex_array_object:
            if (epoxy_conservative_has_gl_extension("GL_APPLE_vertex_array_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_APPLE_vertex_array_range:
            if (epoxy_conservative_has_gl_extension("GL_APPLE_vertex_array_range"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_APPLE_vertex_program_evaluators:
            if (epoxy_conservative_has_gl_extension("GL_APPLE_vertex_program_evaluators"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_ES2_compatibility:
            if (epoxy_conservative_has_gl_extension("GL_ARB_ES2_compatibility"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_ES3_1_compatibility:
            if (epoxy_conservative_has_gl_extension("GL_ARB_ES3_1_compatibility"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_ES3_2_compatibility:
            if (epoxy_conservative_has_gl_extension("GL_ARB_ES3_2_compatibility"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_base_instance:
            if (epoxy_conservative_has_gl_extension("GL_ARB_base_instance"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_bindless_texture:
            if (epoxy_conservative_has_gl_extension("GL_ARB_bindless_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_blend_func_extended:
            if (epoxy_conservative_has_gl_extension("GL_ARB_blend_func_extended"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_buffer_storage:
            if (epoxy_conservative_has_gl_extension("GL_ARB_buffer_storage"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_cl_event:
            if (epoxy_conservative_has_gl_extension("GL_ARB_cl_event"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_clear_buffer_object:
            if (epoxy_conservative_has_gl_extension("GL_ARB_clear_buffer_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_clear_texture:
            if (epoxy_conservative_has_gl_extension("GL_ARB_clear_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_clip_control:
            if (epoxy_conservative_has_gl_extension("GL_ARB_clip_control"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_color_buffer_float:
            if (epoxy_conservative_has_gl_extension("GL_ARB_color_buffer_float"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_compute_shader:
            if (epoxy_conservative_has_gl_extension("GL_ARB_compute_shader"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_compute_variable_group_size:
            if (epoxy_conservative_has_gl_extension("GL_ARB_compute_variable_group_size"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_copy_buffer:
            if (epoxy_conservative_has_gl_extension("GL_ARB_copy_buffer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_copy_image:
            if (epoxy_conservative_has_gl_extension("GL_ARB_copy_image"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_debug_output:
            if (epoxy_conservative_has_gl_extension("GL_ARB_debug_output"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_direct_state_access:
            if (epoxy_conservative_has_gl_extension("GL_ARB_direct_state_access"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_draw_buffers:
            if (epoxy_conservative_has_gl_extension("GL_ARB_draw_buffers"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_draw_buffers_blend:
            if (epoxy_conservative_has_gl_extension("GL_ARB_draw_buffers_blend"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_draw_elements_base_vertex:
            if (epoxy_conservative_has_gl_extension("GL_ARB_draw_elements_base_vertex"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_draw_indirect:
            if (epoxy_conservative_has_gl_extension("GL_ARB_draw_indirect"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_draw_instanced:
            if (epoxy_conservative_has_gl_extension("GL_ARB_draw_instanced"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_fragment_program:
            if (epoxy_conservative_has_gl_extension("GL_ARB_fragment_program"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_framebuffer_no_attachments:
            if (epoxy_conservative_has_gl_extension("GL_ARB_framebuffer_no_attachments"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_framebuffer_object:
            if (epoxy_conservative_has_gl_extension("GL_ARB_framebuffer_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_geometry_shader4:
            if (epoxy_conservative_has_gl_extension("GL_ARB_geometry_shader4"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_get_program_binary:
            if (epoxy_conservative_has_gl_extension("GL_ARB_get_program_binary"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_get_texture_sub_image:
            if (epoxy_conservative_has_gl_extension("GL_ARB_get_texture_sub_image"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_gl_spirv:
            if (epoxy_conservative_has_gl_extension("GL_ARB_gl_spirv"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_gpu_shader_fp64:
            if (epoxy_conservative_has_gl_extension("GL_ARB_gpu_shader_fp64"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_gpu_shader_int64:
            if (epoxy_conservative_has_gl_extension("GL_ARB_gpu_shader_int64"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_imaging:
            if (epoxy_conservative_has_gl_extension("GL_ARB_imaging"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_indirect_parameters:
            if (epoxy_conservative_has_gl_extension("GL_ARB_indirect_parameters"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_instanced_arrays:
            if (epoxy_conservative_has_gl_extension("GL_ARB_instanced_arrays"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_internalformat_query2:
            if (epoxy_conservative_has_gl_extension("GL_ARB_internalformat_query2"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_internalformat_query:
            if (epoxy_conservative_has_gl_extension("GL_ARB_internalformat_query"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_invalidate_subdata:
            if (epoxy_conservative_has_gl_extension("GL_ARB_invalidate_subdata"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_map_buffer_range:
            if (epoxy_conservative_has_gl_extension("GL_ARB_map_buffer_range"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_matrix_palette:
            if (epoxy_conservative_has_gl_extension("GL_ARB_matrix_palette"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_multi_bind:
            if (epoxy_conservative_has_gl_extension("GL_ARB_multi_bind"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_multi_draw_indirect:
            if (epoxy_conservative_has_gl_extension("GL_ARB_multi_draw_indirect"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_multisample:
            if (epoxy_conservative_has_gl_extension("GL_ARB_multisample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_multitexture:
            if (epoxy_conservative_has_gl_extension("GL_ARB_multitexture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_occlusion_query:
            if (epoxy_conservative_has_gl_extension("GL_ARB_occlusion_query"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_parallel_shader_compile:
            if (epoxy_conservative_has_gl_extension("GL_ARB_parallel_shader_compile"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_point_parameters:
            if (epoxy_conservative_has_gl_extension("GL_ARB_point_parameters"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_polygon_offset_clamp:
            if (epoxy_conservative_has_gl_extension("GL_ARB_polygon_offset_clamp"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_program_interface_query:
            if (epoxy_conservative_has_gl_extension("GL_ARB_program_interface_query"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_provoking_vertex:
            if (epoxy_conservative_has_gl_extension("GL_ARB_provoking_vertex"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_robustness:
            if (epoxy_conservative_has_gl_extension("GL_ARB_robustness"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_sample_locations:
            if (epoxy_conservative_has_gl_extension("GL_ARB_sample_locations"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_sample_shading:
            if (epoxy_conservative_has_gl_extension("GL_ARB_sample_shading"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_sampler_objects:
            if (epoxy_conservative_has_gl_extension("GL_ARB_sampler_objects"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_separate_shader_objects:
            if (epoxy_conservative_has_gl_extension("GL_ARB_separate_shader_objects"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_shader_atomic_counters:
            if (epoxy_conservative_has_gl_extension("GL_ARB_shader_atomic_counters"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_shader_image_load_store:
            if (epoxy_conservative_has_gl_extension("GL_ARB_shader_image_load_store"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_shader_objects:
            if (epoxy_conservative_has_gl_extension("GL_ARB_shader_objects"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_shader_storage_buffer_object:
            if (epoxy_conservative_has_gl_extension("GL_ARB_shader_storage_buffer_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_shader_subroutine:
            if (epoxy_conservative_has_gl_extension("GL_ARB_shader_subroutine"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_shading_language_include:
            if (epoxy_conservative_has_gl_extension("GL_ARB_shading_language_include"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_sparse_buffer:
            if (epoxy_conservative_has_gl_extension("GL_ARB_sparse_buffer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_sparse_texture:
            if (epoxy_conservative_has_gl_extension("GL_ARB_sparse_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_sync:
            if (epoxy_conservative_has_gl_extension("GL_ARB_sync"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_tessellation_shader:
            if (epoxy_conservative_has_gl_extension("GL_ARB_tessellation_shader"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_texture_barrier:
            if (epoxy_conservative_has_gl_extension("GL_ARB_texture_barrier"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_texture_buffer_object:
            if (epoxy_conservative_has_gl_extension("GL_ARB_texture_buffer_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_texture_buffer_range:
            if (epoxy_conservative_has_gl_extension("GL_ARB_texture_buffer_range"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_texture_compression:
            if (epoxy_conservative_has_gl_extension("GL_ARB_texture_compression"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_texture_multisample:
            if (epoxy_conservative_has_gl_extension("GL_ARB_texture_multisample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_texture_storage:
            if (epoxy_conservative_has_gl_extension("GL_ARB_texture_storage"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_texture_storage_multisample:
            if (epoxy_conservative_has_gl_extension("GL_ARB_texture_storage_multisample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_texture_view:
            if (epoxy_conservative_has_gl_extension("GL_ARB_texture_view"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_timer_query:
            if (epoxy_conservative_has_gl_extension("GL_ARB_timer_query"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_transform_feedback2:
            if (epoxy_conservative_has_gl_extension("GL_ARB_transform_feedback2"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_transform_feedback3:
            if (epoxy_conservative_has_gl_extension("GL_ARB_transform_feedback3"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_transform_feedback_instanced:
            if (epoxy_conservative_has_gl_extension("GL_ARB_transform_feedback_instanced"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_transpose_matrix:
            if (epoxy_conservative_has_gl_extension("GL_ARB_transpose_matrix"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_uniform_buffer_object:
            if (epoxy_conservative_has_gl_extension("GL_ARB_uniform_buffer_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_vertex_array_object:
            if (epoxy_conservative_has_gl_extension("GL_ARB_vertex_array_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_vertex_attrib_64bit:
            if (epoxy_conservative_has_gl_extension("GL_ARB_vertex_attrib_64bit"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_vertex_attrib_binding:
            if (epoxy_conservative_has_gl_extension("GL_ARB_vertex_attrib_binding"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_vertex_blend:
            if (epoxy_conservative_has_gl_extension("GL_ARB_vertex_blend"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_vertex_buffer_object:
            if (epoxy_conservative_has_gl_extension("GL_ARB_vertex_buffer_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_vertex_program:
            if (epoxy_conservative_has_gl_extension("GL_ARB_vertex_program"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_vertex_shader:
            if (epoxy_conservative_has_gl_extension("GL_ARB_vertex_shader"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_vertex_type_2_10_10_10_rev:
            if (epoxy_conservative_has_gl_extension("GL_ARB_vertex_type_2_10_10_10_rev"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_viewport_array:
            if (epoxy_conservative_has_gl_extension("GL_ARB_viewport_array"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ARB_window_pos:
            if (epoxy_conservative_has_gl_extension("GL_ARB_window_pos"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ATI_draw_buffers:
            if (epoxy_conservative_has_gl_extension("GL_ATI_draw_buffers"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ATI_element_array:
            if (epoxy_conservative_has_gl_extension("GL_ATI_element_array"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ATI_envmap_bumpmap:
            if (epoxy_conservative_has_gl_extension("GL_ATI_envmap_bumpmap"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ATI_fragment_shader:
            if (epoxy_conservative_has_gl_extension("GL_ATI_fragment_shader"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ATI_map_object_buffer:
            if (epoxy_conservative_has_gl_extension("GL_ATI_map_object_buffer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ATI_pn_triangles:
            if (epoxy_conservative_has_gl_extension("GL_ATI_pn_triangles"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ATI_separate_stencil:
            if (epoxy_conservative_has_gl_extension("GL_ATI_separate_stencil"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ATI_vertex_array_object:
            if (epoxy_conservative_has_gl_extension("GL_ATI_vertex_array_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ATI_vertex_attrib_array_object:
            if (epoxy_conservative_has_gl_extension("GL_ATI_vertex_attrib_array_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_ATI_vertex_streams:
            if (epoxy_conservative_has_gl_extension("GL_ATI_vertex_streams"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_base_instance:
            if (epoxy_conservative_has_gl_extension("GL_EXT_base_instance"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_bindable_uniform:
            if (epoxy_conservative_has_gl_extension("GL_EXT_bindable_uniform"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_blend_color:
            if (epoxy_conservative_has_gl_extension("GL_EXT_blend_color"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_blend_equation_separate:
            if (epoxy_conservative_has_gl_extension("GL_EXT_blend_equation_separate"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_blend_func_extended:
            if (epoxy_conservative_has_gl_extension("GL_EXT_blend_func_extended"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_blend_func_separate:
            if (epoxy_conservative_has_gl_extension("GL_EXT_blend_func_separate"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_blend_minmax:
            if (epoxy_conservative_has_gl_extension("GL_EXT_blend_minmax"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_buffer_storage:
            if (epoxy_conservative_has_gl_extension("GL_EXT_buffer_storage"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_clear_texture:
            if (epoxy_conservative_has_gl_extension("GL_EXT_clear_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_clip_control:
            if (epoxy_conservative_has_gl_extension("GL_EXT_clip_control"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_color_subtable:
            if (epoxy_conservative_has_gl_extension("GL_EXT_color_subtable"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_compiled_vertex_array:
            if (epoxy_conservative_has_gl_extension("GL_EXT_compiled_vertex_array"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_convolution:
            if (epoxy_conservative_has_gl_extension("GL_EXT_convolution"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_coordinate_frame:
            if (epoxy_conservative_has_gl_extension("GL_EXT_coordinate_frame"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_copy_image:
            if (epoxy_conservative_has_gl_extension("GL_EXT_copy_image"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_copy_texture:
            if (epoxy_conservative_has_gl_extension("GL_EXT_copy_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_cull_vertex:
            if (epoxy_conservative_has_gl_extension("GL_EXT_cull_vertex"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_debug_label:
            if (epoxy_conservative_has_gl_extension("GL_EXT_debug_label"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_debug_marker:
            if (epoxy_conservative_has_gl_extension("GL_EXT_debug_marker"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_depth_bounds_test:
            if (epoxy_conservative_has_gl_extension("GL_EXT_depth_bounds_test"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_direct_state_access:
            if (epoxy_conservative_has_gl_extension("GL_EXT_direct_state_access"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_discard_framebuffer:
            if (epoxy_conservative_has_gl_extension("GL_EXT_discard_framebuffer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_disjoint_timer_query:
            if (epoxy_conservative_has_gl_extension("GL_EXT_disjoint_timer_query"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_draw_buffers2:
            if (epoxy_conservative_has_gl_extension("GL_EXT_draw_buffers2"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_draw_buffers:
            if (epoxy_conservative_has_gl_extension("GL_EXT_draw_buffers"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_draw_buffers_indexed:
            if (epoxy_conservative_has_gl_extension("GL_EXT_draw_buffers_indexed"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_draw_elements_base_vertex:
            if (epoxy_conservative_has_gl_extension("GL_EXT_draw_elements_base_vertex"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_draw_instanced:
            if (epoxy_conservative_has_gl_extension("GL_EXT_draw_instanced"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_draw_range_elements:
            if (epoxy_conservative_has_gl_extension("GL_EXT_draw_range_elements"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_draw_transform_feedback:
            if (epoxy_conservative_has_gl_extension("GL_EXT_draw_transform_feedback"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_external_buffer:
            if (epoxy_conservative_has_gl_extension("GL_EXT_external_buffer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_fog_coord:
            if (epoxy_conservative_has_gl_extension("GL_EXT_fog_coord"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_framebuffer_blit:
            if (epoxy_conservative_has_gl_extension("GL_EXT_framebuffer_blit"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_framebuffer_multisample:
            if (epoxy_conservative_has_gl_extension("GL_EXT_framebuffer_multisample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_framebuffer_object:
            if (epoxy_conservative_has_gl_extension("GL_EXT_framebuffer_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_geometry_shader4:
            if (epoxy_conservative_has_gl_extension("GL_EXT_geometry_shader4"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_geometry_shader:
            if (epoxy_conservative_has_gl_extension("GL_EXT_geometry_shader"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_gpu_program_parameters:
            if (epoxy_conservative_has_gl_extension("GL_EXT_gpu_program_parameters"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_gpu_shader4:
            if (epoxy_conservative_has_gl_extension("GL_EXT_gpu_shader4"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_histogram:
            if (epoxy_conservative_has_gl_extension("GL_EXT_histogram"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_index_func:
            if (epoxy_conservative_has_gl_extension("GL_EXT_index_func"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_index_material:
            if (epoxy_conservative_has_gl_extension("GL_EXT_index_material"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_instanced_arrays:
            if (epoxy_conservative_has_gl_extension("GL_EXT_instanced_arrays"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_light_texture:
            if (epoxy_conservative_has_gl_extension("GL_EXT_light_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_map_buffer_range:
            if (epoxy_conservative_has_gl_extension("GL_EXT_map_buffer_range"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_memory_object:
            if (epoxy_conservative_has_gl_extension("GL_EXT_memory_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_memory_object_fd:
            if (epoxy_conservative_has_gl_extension("GL_EXT_memory_object_fd"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_memory_object_win32:
            if (epoxy_conservative_has_gl_extension("GL_EXT_memory_object_win32"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_multi_draw_arrays:
            if (epoxy_conservative_has_gl_extension("GL_EXT_multi_draw_arrays"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_multi_draw_indirect:
            if (epoxy_conservative_has_gl_extension("GL_EXT_multi_draw_indirect"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_multisample:
            if (epoxy_conservative_has_gl_extension("GL_EXT_multisample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_multisampled_render_to_texture:
            if (epoxy_conservative_has_gl_extension("GL_EXT_multisampled_render_to_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_multiview_draw_buffers:
            if (epoxy_conservative_has_gl_extension("GL_EXT_multiview_draw_buffers"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_occlusion_query_boolean:
            if (epoxy_conservative_has_gl_extension("GL_EXT_occlusion_query_boolean"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_paletted_texture:
            if (epoxy_conservative_has_gl_extension("GL_EXT_paletted_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_pixel_transform:
            if (epoxy_conservative_has_gl_extension("GL_EXT_pixel_transform"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_point_parameters:
            if (epoxy_conservative_has_gl_extension("GL_EXT_point_parameters"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_polygon_offset:
            if (epoxy_conservative_has_gl_extension("GL_EXT_polygon_offset"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_polygon_offset_clamp:
            if (epoxy_conservative_has_gl_extension("GL_EXT_polygon_offset_clamp"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_primitive_bounding_box:
            if (epoxy_conservative_has_gl_extension("GL_EXT_primitive_bounding_box"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_provoking_vertex:
            if (epoxy_conservative_has_gl_extension("GL_EXT_provoking_vertex"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_raster_multisample:
            if (epoxy_conservative_has_gl_extension("GL_EXT_raster_multisample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_robustness:
            if (epoxy_conservative_has_gl_extension("GL_EXT_robustness"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_secondary_color:
            if (epoxy_conservative_has_gl_extension("GL_EXT_secondary_color"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_semaphore:
            if (epoxy_conservative_has_gl_extension("GL_EXT_semaphore"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_semaphore_fd:
            if (epoxy_conservative_has_gl_extension("GL_EXT_semaphore_fd"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_semaphore_win32:
            if (epoxy_conservative_has_gl_extension("GL_EXT_semaphore_win32"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_separate_shader_objects:
            if (epoxy_conservative_has_gl_extension("GL_EXT_separate_shader_objects"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_shader_image_load_store:
            if (epoxy_conservative_has_gl_extension("GL_EXT_shader_image_load_store"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_shader_pixel_local_storage2:
            if (epoxy_conservative_has_gl_extension("GL_EXT_shader_pixel_local_storage2"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_sparse_texture:
            if (epoxy_conservative_has_gl_extension("GL_EXT_sparse_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_stencil_clear_tag:
            if (epoxy_conservative_has_gl_extension("GL_EXT_stencil_clear_tag"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_stencil_two_side:
            if (epoxy_conservative_has_gl_extension("GL_EXT_stencil_two_side"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_subtexture:
            if (epoxy_conservative_has_gl_extension("GL_EXT_subtexture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_tessellation_shader:
            if (epoxy_conservative_has_gl_extension("GL_EXT_tessellation_shader"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_texture3D:
            if (epoxy_conservative_has_gl_extension("GL_EXT_texture3D"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_texture_array:
            if (epoxy_conservative_has_gl_extension("GL_EXT_texture_array"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_texture_border_clamp:
            if (epoxy_conservative_has_gl_extension("GL_EXT_texture_border_clamp"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_texture_buffer:
            if (epoxy_conservative_has_gl_extension("GL_EXT_texture_buffer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_texture_buffer_object:
            if (epoxy_conservative_has_gl_extension("GL_EXT_texture_buffer_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_texture_integer:
            if (epoxy_conservative_has_gl_extension("GL_EXT_texture_integer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_texture_object:
            if (epoxy_conservative_has_gl_extension("GL_EXT_texture_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_texture_perturb_normal:
            if (epoxy_conservative_has_gl_extension("GL_EXT_texture_perturb_normal"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_texture_storage:
            if (epoxy_conservative_has_gl_extension("GL_EXT_texture_storage"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_texture_view:
            if (epoxy_conservative_has_gl_extension("GL_EXT_texture_view"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_timer_query:
            if (epoxy_conservative_has_gl_extension("GL_EXT_timer_query"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_transform_feedback:
            if (epoxy_conservative_has_gl_extension("GL_EXT_transform_feedback"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_vertex_array:
            if (epoxy_conservative_has_gl_extension("GL_EXT_vertex_array"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_vertex_attrib_64bit:
            if (epoxy_conservative_has_gl_extension("GL_EXT_vertex_attrib_64bit"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_vertex_shader:
            if (epoxy_conservative_has_gl_extension("GL_EXT_vertex_shader"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_vertex_weighting:
            if (epoxy_conservative_has_gl_extension("GL_EXT_vertex_weighting"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_win32_keyed_mutex:
            if (epoxy_conservative_has_gl_extension("GL_EXT_win32_keyed_mutex"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_window_rectangles:
            if (epoxy_conservative_has_gl_extension("GL_EXT_window_rectangles"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_EXT_x11_sync_object:
            if (epoxy_conservative_has_gl_extension("GL_EXT_x11_sync_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_GREMEDY_frame_terminator:
            if (epoxy_conservative_has_gl_extension("GL_GREMEDY_frame_terminator"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_GREMEDY_string_marker:
            if (epoxy_conservative_has_gl_extension("GL_GREMEDY_string_marker"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_HP_image_transform:
            if (epoxy_conservative_has_gl_extension("GL_HP_image_transform"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_IBM_multimode_draw_arrays:
            if (epoxy_conservative_has_gl_extension("GL_IBM_multimode_draw_arrays"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_IBM_static_data:
            if (epoxy_conservative_has_gl_extension("GL_IBM_static_data"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_IBM_vertex_array_lists:
            if (epoxy_conservative_has_gl_extension("GL_IBM_vertex_array_lists"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_IMG_bindless_texture:
            if (epoxy_conservative_has_gl_extension("GL_IMG_bindless_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_IMG_framebuffer_downsample:
            if (epoxy_conservative_has_gl_extension("GL_IMG_framebuffer_downsample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_IMG_multisampled_render_to_texture:
            if (epoxy_conservative_has_gl_extension("GL_IMG_multisampled_render_to_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_IMG_user_clip_plane:
            if (epoxy_conservative_has_gl_extension("GL_IMG_user_clip_plane"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_INGR_blend_func_separate:
            if (epoxy_conservative_has_gl_extension("GL_INGR_blend_func_separate"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_INTEL_framebuffer_CMAA:
            if (epoxy_conservative_has_gl_extension("GL_INTEL_framebuffer_CMAA"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_INTEL_map_texture:
            if (epoxy_conservative_has_gl_extension("GL_INTEL_map_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_INTEL_parallel_arrays:
            if (epoxy_conservative_has_gl_extension("GL_INTEL_parallel_arrays"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_INTEL_performance_query:
            if (epoxy_conservative_has_gl_extension("GL_INTEL_performance_query"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_KHR_blend_equation_advanced:
            if (epoxy_conservative_has_gl_extension("GL_KHR_blend_equation_advanced"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_KHR_debug:
            if (epoxy_conservative_has_gl_extension("GL_KHR_debug"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_KHR_parallel_shader_compile:
            if (epoxy_conservative_has_gl_extension("GL_KHR_parallel_shader_compile"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_KHR_robustness:
            if (epoxy_conservative_has_gl_extension("GL_KHR_robustness"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_MESA_resize_buffers:
            if (epoxy_conservative_has_gl_extension("GL_MESA_resize_buffers"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_MESA_window_pos:
            if (epoxy_conservative_has_gl_extension("GL_MESA_window_pos"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NVX_conditional_render:
            if (epoxy_conservative_has_gl_extension("GL_NVX_conditional_render"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NVX_linked_gpu_multicast:
            if (epoxy_conservative_has_gl_extension("GL_NVX_linked_gpu_multicast"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_alpha_to_coverage_dither_control:
            if (epoxy_conservative_has_gl_extension("GL_NV_alpha_to_coverage_dither_control"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_bindless_multi_draw_indirect:
            if (epoxy_conservative_has_gl_extension("GL_NV_bindless_multi_draw_indirect"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_bindless_multi_draw_indirect_count:
            if (epoxy_conservative_has_gl_extension("GL_NV_bindless_multi_draw_indirect_count"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_bindless_texture:
            if (epoxy_conservative_has_gl_extension("GL_NV_bindless_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_blend_equation_advanced:
            if (epoxy_conservative_has_gl_extension("GL_NV_blend_equation_advanced"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_clip_space_w_scaling:
            if (epoxy_conservative_has_gl_extension("GL_NV_clip_space_w_scaling"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_command_list:
            if (epoxy_conservative_has_gl_extension("GL_NV_command_list"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_conditional_render:
            if (epoxy_conservative_has_gl_extension("GL_NV_conditional_render"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_conservative_raster:
            if (epoxy_conservative_has_gl_extension("GL_NV_conservative_raster"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_conservative_raster_dilate:
            if (epoxy_conservative_has_gl_extension("GL_NV_conservative_raster_dilate"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_conservative_raster_pre_snap_triangles:
            if (epoxy_conservative_has_gl_extension("GL_NV_conservative_raster_pre_snap_triangles"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_copy_buffer:
            if (epoxy_conservative_has_gl_extension("GL_NV_copy_buffer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_copy_image:
            if (epoxy_conservative_has_gl_extension("GL_NV_copy_image"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_coverage_sample:
            if (epoxy_conservative_has_gl_extension("GL_NV_coverage_sample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_depth_buffer_float:
            if (epoxy_conservative_has_gl_extension("GL_NV_depth_buffer_float"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_draw_buffers:
            if (epoxy_conservative_has_gl_extension("GL_NV_draw_buffers"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_draw_instanced:
            if (epoxy_conservative_has_gl_extension("GL_NV_draw_instanced"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_draw_texture:
            if (epoxy_conservative_has_gl_extension("GL_NV_draw_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_draw_vulkan_image:
            if (epoxy_conservative_has_gl_extension("GL_NV_draw_vulkan_image"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_evaluators:
            if (epoxy_conservative_has_gl_extension("GL_NV_evaluators"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_explicit_multisample:
            if (epoxy_conservative_has_gl_extension("GL_NV_explicit_multisample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_fence:
            if (epoxy_conservative_has_gl_extension("GL_NV_fence"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_fragment_coverage_to_color:
            if (epoxy_conservative_has_gl_extension("GL_NV_fragment_coverage_to_color"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_fragment_program:
            if (epoxy_conservative_has_gl_extension("GL_NV_fragment_program"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_framebuffer_blit:
            if (epoxy_conservative_has_gl_extension("GL_NV_framebuffer_blit"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_framebuffer_mixed_samples:
            if (epoxy_conservative_has_gl_extension("GL_NV_framebuffer_mixed_samples"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_framebuffer_multisample:
            if (epoxy_conservative_has_gl_extension("GL_NV_framebuffer_multisample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_framebuffer_multisample_coverage:
            if (epoxy_conservative_has_gl_extension("GL_NV_framebuffer_multisample_coverage"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_geometry_program4:
            if (epoxy_conservative_has_gl_extension("GL_NV_geometry_program4"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_gpu_multicast:
            if (epoxy_conservative_has_gl_extension("GL_NV_gpu_multicast"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_gpu_program4:
            if (epoxy_conservative_has_gl_extension("GL_NV_gpu_program4"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_gpu_program5:
            if (epoxy_conservative_has_gl_extension("GL_NV_gpu_program5"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_gpu_shader5:
            if (epoxy_conservative_has_gl_extension("GL_NV_gpu_shader5"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_half_float:
            if (epoxy_conservative_has_gl_extension("GL_NV_half_float"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_instanced_arrays:
            if (epoxy_conservative_has_gl_extension("GL_NV_instanced_arrays"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_internalformat_sample_query:
            if (epoxy_conservative_has_gl_extension("GL_NV_internalformat_sample_query"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_non_square_matrices:
            if (epoxy_conservative_has_gl_extension("GL_NV_non_square_matrices"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_occlusion_query:
            if (epoxy_conservative_has_gl_extension("GL_NV_occlusion_query"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_parameter_buffer_object:
            if (epoxy_conservative_has_gl_extension("GL_NV_parameter_buffer_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_path_rendering:
            if (epoxy_conservative_has_gl_extension("GL_NV_path_rendering"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_pixel_data_range:
            if (epoxy_conservative_has_gl_extension("GL_NV_pixel_data_range"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_point_sprite:
            if (epoxy_conservative_has_gl_extension("GL_NV_point_sprite"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_polygon_mode:
            if (epoxy_conservative_has_gl_extension("GL_NV_polygon_mode"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_present_video:
            if (epoxy_conservative_has_gl_extension("GL_NV_present_video"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_primitive_restart:
            if (epoxy_conservative_has_gl_extension("GL_NV_primitive_restart"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_query_resource:
            if (epoxy_conservative_has_gl_extension("GL_NV_query_resource"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_query_resource_tag:
            if (epoxy_conservative_has_gl_extension("GL_NV_query_resource_tag"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_read_buffer:
            if (epoxy_conservative_has_gl_extension("GL_NV_read_buffer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_register_combiners2:
            if (epoxy_conservative_has_gl_extension("GL_NV_register_combiners2"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_register_combiners:
            if (epoxy_conservative_has_gl_extension("GL_NV_register_combiners"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_sample_locations:
            if (epoxy_conservative_has_gl_extension("GL_NV_sample_locations"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_shader_buffer_load:
            if (epoxy_conservative_has_gl_extension("GL_NV_shader_buffer_load"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_texture_barrier:
            if (epoxy_conservative_has_gl_extension("GL_NV_texture_barrier"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_texture_multisample:
            if (epoxy_conservative_has_gl_extension("GL_NV_texture_multisample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_transform_feedback2:
            if (epoxy_conservative_has_gl_extension("GL_NV_transform_feedback2"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_transform_feedback:
            if (epoxy_conservative_has_gl_extension("GL_NV_transform_feedback"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_vdpau_interop:
            if (epoxy_conservative_has_gl_extension("GL_NV_vdpau_interop"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_vertex_array_range:
            if (epoxy_conservative_has_gl_extension("GL_NV_vertex_array_range"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_vertex_attrib_integer_64bit:
            if (epoxy_conservative_has_gl_extension("GL_NV_vertex_attrib_integer_64bit"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_vertex_buffer_unified_memory:
            if (epoxy_conservative_has_gl_extension("GL_NV_vertex_buffer_unified_memory"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_vertex_program4:
            if (epoxy_conservative_has_gl_extension("GL_NV_vertex_program4"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_vertex_program:
            if (epoxy_conservative_has_gl_extension("GL_NV_vertex_program"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_video_capture:
            if (epoxy_conservative_has_gl_extension("GL_NV_video_capture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_viewport_array:
            if (epoxy_conservative_has_gl_extension("GL_NV_viewport_array"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_NV_viewport_swizzle:
            if (epoxy_conservative_has_gl_extension("GL_NV_viewport_swizzle"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_EGL_image:
            if (epoxy_conservative_has_gl_extension("GL_OES_EGL_image"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_blend_equation_separate:
            if (epoxy_conservative_has_gl_extension("GL_OES_blend_equation_separate"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_blend_func_separate:
            if (epoxy_conservative_has_gl_extension("GL_OES_blend_func_separate"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_blend_subtract:
            if (epoxy_conservative_has_gl_extension("GL_OES_blend_subtract"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_byte_coordinates:
            if (epoxy_conservative_has_gl_extension("GL_OES_byte_coordinates"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_copy_image:
            if (epoxy_conservative_has_gl_extension("GL_OES_copy_image"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_draw_buffers_indexed:
            if (epoxy_conservative_has_gl_extension("GL_OES_draw_buffers_indexed"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_draw_elements_base_vertex:
            if (epoxy_conservative_has_gl_extension("GL_OES_draw_elements_base_vertex"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_draw_texture:
            if (epoxy_conservative_has_gl_extension("GL_OES_draw_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_fixed_point:
            if (epoxy_conservative_has_gl_extension("GL_OES_fixed_point"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_framebuffer_object:
            if (epoxy_conservative_has_gl_extension("GL_OES_framebuffer_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_geometry_shader:
            if (epoxy_conservative_has_gl_extension("GL_OES_geometry_shader"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_get_program_binary:
            if (epoxy_conservative_has_gl_extension("GL_OES_get_program_binary"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_mapbuffer:
            if (epoxy_conservative_has_gl_extension("GL_OES_mapbuffer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_matrix_palette:
            if (epoxy_conservative_has_gl_extension("GL_OES_matrix_palette"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_point_size_array:
            if (epoxy_conservative_has_gl_extension("GL_OES_point_size_array"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_primitive_bounding_box:
            if (epoxy_conservative_has_gl_extension("GL_OES_primitive_bounding_box"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_query_matrix:
            if (epoxy_conservative_has_gl_extension("GL_OES_query_matrix"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_sample_shading:
            if (epoxy_conservative_has_gl_extension("GL_OES_sample_shading"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_single_precision:
            if (epoxy_conservative_has_gl_extension("GL_OES_single_precision"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_tessellation_shader:
            if (epoxy_conservative_has_gl_extension("GL_OES_tessellation_shader"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_texture_3D:
            if (epoxy_conservative_has_gl_extension("GL_OES_texture_3D"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_texture_border_clamp:
            if (epoxy_conservative_has_gl_extension("GL_OES_texture_border_clamp"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_texture_buffer:
            if (epoxy_conservative_has_gl_extension("GL_OES_texture_buffer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_texture_cube_map:
            if (epoxy_conservative_has_gl_extension("GL_OES_texture_cube_map"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_texture_storage_multisample_2d_array:
            if (epoxy_conservative_has_gl_extension("GL_OES_texture_storage_multisample_2d_array"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_texture_view:
            if (epoxy_conservative_has_gl_extension("GL_OES_texture_view"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_vertex_array_object:
            if (epoxy_conservative_has_gl_extension("GL_OES_vertex_array_object"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OES_viewport_array:
            if (epoxy_conservative_has_gl_extension("GL_OES_viewport_array"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OVR_multiview:
            if (epoxy_conservative_has_gl_extension("GL_OVR_multiview"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_OVR_multiview_multisampled_render_to_texture:
            if (epoxy_conservative_has_gl_extension("GL_OVR_multiview_multisampled_render_to_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_PGI_misc_hints:
            if (epoxy_conservative_has_gl_extension("GL_PGI_misc_hints"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_QCOM_alpha_test:
            if (epoxy_conservative_has_gl_extension("GL_QCOM_alpha_test"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_QCOM_driver_control:
            if (epoxy_conservative_has_gl_extension("GL_QCOM_driver_control"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_QCOM_extended_get2:
            if (epoxy_conservative_has_gl_extension("GL_QCOM_extended_get2"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_QCOM_extended_get:
            if (epoxy_conservative_has_gl_extension("GL_QCOM_extended_get"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_QCOM_framebuffer_foveated:
            if (epoxy_conservative_has_gl_extension("GL_QCOM_framebuffer_foveated"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_QCOM_shader_framebuffer_fetch_noncoherent:
            if (epoxy_conservative_has_gl_extension("GL_QCOM_shader_framebuffer_fetch_noncoherent"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_QCOM_texture_foveated:
            if (epoxy_conservative_has_gl_extension("GL_QCOM_texture_foveated"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_QCOM_tiled_rendering:
            if (epoxy_conservative_has_gl_extension("GL_QCOM_tiled_rendering"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIS_detail_texture:
            if (epoxy_conservative_has_gl_extension("GL_SGIS_detail_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIS_fog_function:
            if (epoxy_conservative_has_gl_extension("GL_SGIS_fog_function"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIS_multisample:
            if (epoxy_conservative_has_gl_extension("GL_SGIS_multisample"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIS_pixel_texture:
            if (epoxy_conservative_has_gl_extension("GL_SGIS_pixel_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIS_point_parameters:
            if (epoxy_conservative_has_gl_extension("GL_SGIS_point_parameters"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIS_sharpen_texture:
            if (epoxy_conservative_has_gl_extension("GL_SGIS_sharpen_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIS_texture4D:
            if (epoxy_conservative_has_gl_extension("GL_SGIS_texture4D"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIS_texture_color_mask:
            if (epoxy_conservative_has_gl_extension("GL_SGIS_texture_color_mask"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIS_texture_filter4:
            if (epoxy_conservative_has_gl_extension("GL_SGIS_texture_filter4"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIX_async:
            if (epoxy_conservative_has_gl_extension("GL_SGIX_async"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIX_flush_raster:
            if (epoxy_conservative_has_gl_extension("GL_SGIX_flush_raster"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIX_fragment_lighting:
            if (epoxy_conservative_has_gl_extension("GL_SGIX_fragment_lighting"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIX_framezoom:
            if (epoxy_conservative_has_gl_extension("GL_SGIX_framezoom"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIX_igloo_interface:
            if (epoxy_conservative_has_gl_extension("GL_SGIX_igloo_interface"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIX_instruments:
            if (epoxy_conservative_has_gl_extension("GL_SGIX_instruments"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIX_list_priority:
            if (epoxy_conservative_has_gl_extension("GL_SGIX_list_priority"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIX_pixel_texture:
            if (epoxy_conservative_has_gl_extension("GL_SGIX_pixel_texture"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIX_polynomial_ffd:
            if (epoxy_conservative_has_gl_extension("GL_SGIX_polynomial_ffd"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIX_reference_plane:
            if (epoxy_conservative_has_gl_extension("GL_SGIX_reference_plane"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIX_sprite:
            if (epoxy_conservative_has_gl_extension("GL_SGIX_sprite"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGIX_tag_sample_buffer:
            if (epoxy_conservative_has_gl_extension("GL_SGIX_tag_sample_buffer"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SGI_color_table:
            if (epoxy_conservative_has_gl_extension("GL_SGI_color_table"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SUNX_constant_data:
            if (epoxy_conservative_has_gl_extension("GL_SUNX_constant_data"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SUN_global_alpha:
            if (epoxy_conservative_has_gl_extension("GL_SUN_global_alpha"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SUN_mesh_array:
            if (epoxy_conservative_has_gl_extension("GL_SUN_mesh_array"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SUN_triangle_list:
            if (epoxy_conservative_has_gl_extension("GL_SUN_triangle_list"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case GL_extension_GL_SUN_vertex:
            if (epoxy_conservative_has_gl_extension("GL_SUN_vertex"))
                return epoxy_get_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case OpenGL_ES_1_0:
            if (!epoxy_is_desktop_gl() && epoxy_gl_version() >= 10 && epoxy_gl_version() < 20)
                return epoxy_gles1_dlsym(entrypoint_strings + entrypoints[i]);
            break;
        case OpenGL_ES_2_0:
            if (!epoxy_is_desktop_gl() && epoxy_gl_version() >= 20)
                return epoxy_gles2_dlsym(entrypoint_strings + entrypoints[i]);
            break;
        case OpenGL_ES_3_0:
            if (!epoxy_is_desktop_gl() && epoxy_gl_version() >= 30)
                return epoxy_gles3_dlsym(entrypoint_strings + entrypoints[i]);
            break;
        case OpenGL_ES_3_1:
            if (!epoxy_is_desktop_gl() && epoxy_gl_version() >= 31)
                return epoxy_gles3_dlsym(entrypoint_strings + entrypoints[i]);
            break;
        case OpenGL_ES_3_2:
            if (!epoxy_is_desktop_gl() && epoxy_gl_version() >= 32)
                return epoxy_gles3_dlsym(entrypoint_strings + entrypoints[i]);
            break;
        case always_present:
            if (true)
                return epoxy_get_bootstrap_proc_address(entrypoint_strings + entrypoints[i]);
            break;
        case gl_provider_terminator:
            abort(); /* Not reached */
        }
    }

    if (epoxy_resolver_failure_handler)
        return epoxy_resolver_failure_handler(name);

    fprintf(stderr, "No provider of %s found.  Requires one of:\n", name);
    for (i = 0; providers[i] != gl_provider_terminator; i++) {
        fprintf(stderr, "    %s\n", enum_string + enum_string_offsets[providers[i]]);
    }
    if (providers[0] == gl_provider_terminator) {
        fprintf(stderr, "    No known providers.  This is likely a bug "
                        "in libepoxy code generation\n");
    }
    abort();
}

EPOXY_NOINLINE static void *
gl_single_resolver(enum gl_provider provider, uint32_t entrypoint_offset);

static void *
gl_single_resolver(enum gl_provider provider, uint32_t entrypoint_offset)
{
    enum gl_provider providers[] = {
        provider,
        gl_provider_terminator
    };
    return gl_provider_resolver(entrypoint_strings + entrypoint_offset,
                                providers, &entrypoint_offset);
}

static PFNGLACCUMPROC
epoxy_glAccum_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 0 /* glAccum */);
}

static PFNGLACCUMXOESPROC
epoxy_glAccumxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 8 /* glAccumxOES */);
}

static PFNGLACQUIREKEYEDMUTEXWIN32EXTPROC
epoxy_glAcquireKeyedMutexWin32EXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_win32_keyed_mutex, 20 /* glAcquireKeyedMutexWin32EXT */);
}

static PFNGLACTIVEPROGRAMEXTPROC
epoxy_glActiveProgramEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_separate_shader_objects, 48 /* glActiveProgramEXT */);
}

static PFNGLACTIVESHADERPROGRAMPROC
epoxy_glActiveShaderProgram_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_1,
        GL_extension_GL_ARB_separate_shader_objects,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        67 /* "glActiveShaderProgram" */,
        67 /* "glActiveShaderProgram" */,
        67 /* "glActiveShaderProgram" */,
    };
    return gl_provider_resolver(entrypoint_strings + 67 /* "glActiveShaderProgram" */,
                                providers, entrypoints);
}

static PFNGLACTIVESHADERPROGRAMEXTPROC
epoxy_glActiveShaderProgramEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_separate_shader_objects, 89 /* glActiveShaderProgramEXT */);
}

static PFNGLACTIVESTENCILFACEEXTPROC
epoxy_glActiveStencilFaceEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_stencil_two_side, 114 /* glActiveStencilFaceEXT */);
}

static PFNGLACTIVETEXTUREPROC
epoxy_glActiveTexture_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_3,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_multitexture,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        137 /* "glActiveTexture" */,
        137 /* "glActiveTexture" */,
        137 /* "glActiveTexture" */,
        153 /* "glActiveTextureARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 137 /* "glActiveTexture" */,
                                providers, entrypoints);
}

static PFNGLACTIVETEXTUREARBPROC
epoxy_glActiveTextureARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_multitexture,
        Desktop_OpenGL_1_3,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        153 /* "glActiveTextureARB" */,
        137 /* "glActiveTexture" */,
        137 /* "glActiveTexture" */,
        137 /* "glActiveTexture" */,
    };
    return gl_provider_resolver(entrypoint_strings + 153 /* "glActiveTextureARB" */,
                                providers, entrypoints);
}

static PFNGLACTIVEVARYINGNVPROC
epoxy_glActiveVaryingNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_transform_feedback, 172 /* glActiveVaryingNV */);
}

static PFNGLALPHAFRAGMENTOP1ATIPROC
epoxy_glAlphaFragmentOp1ATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_fragment_shader, 190 /* glAlphaFragmentOp1ATI */);
}

static PFNGLALPHAFRAGMENTOP2ATIPROC
epoxy_glAlphaFragmentOp2ATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_fragment_shader, 212 /* glAlphaFragmentOp2ATI */);
}

static PFNGLALPHAFRAGMENTOP3ATIPROC
epoxy_glAlphaFragmentOp3ATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_fragment_shader, 234 /* glAlphaFragmentOp3ATI */);
}

static PFNGLALPHAFUNCPROC
epoxy_glAlphaFunc_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_0,
        OpenGL_ES_1_0,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        256 /* "glAlphaFunc" */,
        256 /* "glAlphaFunc" */,
    };
    return gl_provider_resolver(entrypoint_strings + 256 /* "glAlphaFunc" */,
                                providers, entrypoints);
}

static PFNGLALPHAFUNCQCOMPROC
epoxy_glAlphaFuncQCOM_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_QCOM_alpha_test, 268 /* glAlphaFuncQCOM */);
}

static PFNGLALPHAFUNCXPROC
epoxy_glAlphaFuncx_resolver(void)
{
    return gl_single_resolver(OpenGL_ES_1_0, 284 /* glAlphaFuncx */);
}

static PFNGLALPHAFUNCXOESPROC
epoxy_glAlphaFuncxOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_fixed_point, 297 /* glAlphaFuncxOES */);
}

static PFNGLALPHATOCOVERAGEDITHERCONTROLNVPROC
epoxy_glAlphaToCoverageDitherControlNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_alpha_to_coverage_dither_control, 313 /* glAlphaToCoverageDitherControlNV */);
}

static PFNGLAPPLYFRAMEBUFFERATTACHMENTCMAAINTELPROC
epoxy_glApplyFramebufferAttachmentCMAAINTEL_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_INTEL_framebuffer_CMAA, 346 /* glApplyFramebufferAttachmentCMAAINTEL */);
}

static PFNGLAPPLYTEXTUREEXTPROC
epoxy_glApplyTextureEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_light_texture, 384 /* glApplyTextureEXT */);
}

static PFNGLAREPROGRAMSRESIDENTNVPROC
epoxy_glAreProgramsResidentNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_vertex_program, 402 /* glAreProgramsResidentNV */);
}

static PFNGLARETEXTURESRESIDENTPROC
epoxy_glAreTexturesResident_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_1, 426 /* glAreTexturesResident */);
}

static PFNGLARETEXTURESRESIDENTEXTPROC
epoxy_glAreTexturesResidentEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_texture_object, 448 /* glAreTexturesResidentEXT */);
}

static PFNGLARRAYELEMENTPROC
epoxy_glArrayElement_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_1,
        GL_extension_GL_EXT_vertex_array,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        473 /* "glArrayElement" */,
        488 /* "glArrayElementEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 473 /* "glArrayElement" */,
                                providers, entrypoints);
}

static PFNGLARRAYELEMENTEXTPROC
epoxy_glArrayElementEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_vertex_array,
        Desktop_OpenGL_1_1,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        488 /* "glArrayElementEXT" */,
        473 /* "glArrayElement" */,
    };
    return gl_provider_resolver(entrypoint_strings + 488 /* "glArrayElementEXT" */,
                                providers, entrypoints);
}

static PFNGLARRAYOBJECTATIPROC
epoxy_glArrayObjectATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_vertex_array_object, 506 /* glArrayObjectATI */);
}

static PFNGLASYNCMARKERSGIXPROC
epoxy_glAsyncMarkerSGIX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_SGIX_async, 523 /* glAsyncMarkerSGIX */);
}

static PFNGLATTACHOBJECTARBPROC
epoxy_glAttachObjectARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_shader_objects,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        541 /* "glAttachObjectARB" */,
        559 /* "glAttachShader" */,
        559 /* "glAttachShader" */,
    };
    return gl_provider_resolver(entrypoint_strings + 541 /* "glAttachObjectARB" */,
                                providers, entrypoints);
}

static PFNGLATTACHSHADERPROC
epoxy_glAttachShader_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_shader_objects,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        559 /* "glAttachShader" */,
        559 /* "glAttachShader" */,
        541 /* "glAttachObjectARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 559 /* "glAttachShader" */,
                                providers, entrypoints);
}

static PFNGLBEGINPROC
epoxy_glBegin_unwrapped_resolver(void)
{
    return gl_single_resolver(Desktop_OpenGL_1_0, 574 /* glBegin */);
}

static PFNGLBEGINCONDITIONALRENDERPROC
epoxy_glBeginConditionalRender_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_NV_conditional_render,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        582 /* "glBeginConditionalRender" */,
        607 /* "glBeginConditionalRenderNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 582 /* "glBeginConditionalRender" */,
                                providers, entrypoints);
}

static PFNGLBEGINCONDITIONALRENDERNVPROC
epoxy_glBeginConditionalRenderNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_conditional_render,
        Desktop_OpenGL_3_0,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        607 /* "glBeginConditionalRenderNV" */,
        582 /* "glBeginConditionalRender" */,
    };
    return gl_provider_resolver(entrypoint_strings + 607 /* "glBeginConditionalRenderNV" */,
                                providers, entrypoints);
}

static PFNGLBEGINCONDITIONALRENDERNVXPROC
epoxy_glBeginConditionalRenderNVX_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NVX_conditional_render, 634 /* glBeginConditionalRenderNVX */);
}

static PFNGLBEGINFRAGMENTSHADERATIPROC
epoxy_glBeginFragmentShaderATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_fragment_shader, 662 /* glBeginFragmentShaderATI */);
}

static PFNGLBEGINOCCLUSIONQUERYNVPROC
epoxy_glBeginOcclusionQueryNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_occlusion_query, 687 /* glBeginOcclusionQueryNV */);
}

static PFNGLBEGINPERFMONITORAMDPROC
epoxy_glBeginPerfMonitorAMD_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_AMD_performance_monitor, 711 /* glBeginPerfMonitorAMD */);
}

static PFNGLBEGINPERFQUERYINTELPROC
epoxy_glBeginPerfQueryINTEL_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_INTEL_performance_query, 733 /* glBeginPerfQueryINTEL */);
}

static PFNGLBEGINQUERYPROC
epoxy_glBeginQuery_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_5,
        OpenGL_ES_3_0,
        GL_extension_GL_ARB_occlusion_query,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        755 /* "glBeginQuery" */,
        755 /* "glBeginQuery" */,
        768 /* "glBeginQueryARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 755 /* "glBeginQuery" */,
                                providers, entrypoints);
}

static PFNGLBEGINQUERYARBPROC
epoxy_glBeginQueryARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_occlusion_query,
        Desktop_OpenGL_1_5,
        OpenGL_ES_3_0,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        768 /* "glBeginQueryARB" */,
        755 /* "glBeginQuery" */,
        755 /* "glBeginQuery" */,
    };
    return gl_provider_resolver(entrypoint_strings + 768 /* "glBeginQueryARB" */,
                                providers, entrypoints);
}

static PFNGLBEGINQUERYEXTPROC
epoxy_glBeginQueryEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_disjoint_timer_query,
        GL_extension_GL_EXT_occlusion_query_boolean,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        784 /* "glBeginQueryEXT" */,
        784 /* "glBeginQueryEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 784 /* "glBeginQueryEXT" */,
                                providers, entrypoints);
}

static PFNGLBEGINQUERYINDEXEDPROC
epoxy_glBeginQueryIndexed_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_0,
        GL_extension_GL_ARB_transform_feedback3,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        800 /* "glBeginQueryIndexed" */,
        800 /* "glBeginQueryIndexed" */,
    };
    return gl_provider_resolver(entrypoint_strings + 800 /* "glBeginQueryIndexed" */,
                                providers, entrypoints);
}

static PFNGLBEGINTRANSFORMFEEDBACKPROC
epoxy_glBeginTransformFeedback_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_transform_feedback,
        GL_extension_GL_NV_transform_feedback,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        820 /* "glBeginTransformFeedback" */,
        820 /* "glBeginTransformFeedback" */,
        845 /* "glBeginTransformFeedbackEXT" */,
        873 /* "glBeginTransformFeedbackNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 820 /* "glBeginTransformFeedback" */,
                                providers, entrypoints);
}

static PFNGLBEGINTRANSFORMFEEDBACKEXTPROC
epoxy_glBeginTransformFeedbackEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_transform_feedback,
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_0,
        GL_extension_GL_NV_transform_feedback,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        845 /* "glBeginTransformFeedbackEXT" */,
        820 /* "glBeginTransformFeedback" */,
        820 /* "glBeginTransformFeedback" */,
        873 /* "glBeginTransformFeedbackNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 845 /* "glBeginTransformFeedbackEXT" */,
                                providers, entrypoints);
}

static PFNGLBEGINTRANSFORMFEEDBACKNVPROC
epoxy_glBeginTransformFeedbackNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_transform_feedback,
        Desktop_OpenGL_3_0,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_transform_feedback,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        873 /* "glBeginTransformFeedbackNV" */,
        820 /* "glBeginTransformFeedback" */,
        820 /* "glBeginTransformFeedback" */,
        845 /* "glBeginTransformFeedbackEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 873 /* "glBeginTransformFeedbackNV" */,
                                providers, entrypoints);
}

static PFNGLBEGINVERTEXSHADEREXTPROC
epoxy_glBeginVertexShaderEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 900 /* glBeginVertexShaderEXT */);
}

static PFNGLBEGINVIDEOCAPTURENVPROC
epoxy_glBeginVideoCaptureNV_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_NV_video_capture, 923 /* glBeginVideoCaptureNV */);
}

static PFNGLBINDATTRIBLOCATIONPROC
epoxy_glBindAttribLocation_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_vertex_shader,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        945 /* "glBindAttribLocation" */,
        945 /* "glBindAttribLocation" */,
        966 /* "glBindAttribLocationARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 945 /* "glBindAttribLocation" */,
                                providers, entrypoints);
}

static PFNGLBINDATTRIBLOCATIONARBPROC
epoxy_glBindAttribLocationARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_vertex_shader,
        Desktop_OpenGL_2_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        966 /* "glBindAttribLocationARB" */,
        945 /* "glBindAttribLocation" */,
        945 /* "glBindAttribLocation" */,
    };
    return gl_provider_resolver(entrypoint_strings + 966 /* "glBindAttribLocationARB" */,
                                providers, entrypoints);
}

static PFNGLBINDBUFFERPROC
epoxy_glBindBuffer_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_1_5,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        GL_extension_GL_ARB_vertex_buffer_object,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        990 /* "glBindBuffer" */,
        990 /* "glBindBuffer" */,
        990 /* "glBindBuffer" */,
        1003 /* "glBindBufferARB" */,
    };
    return gl_provider_resolver(entrypoint_strings + 990 /* "glBindBuffer" */,
                                providers, entrypoints);
}

static PFNGLBINDBUFFERARBPROC
epoxy_glBindBufferARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_vertex_buffer_object,
        Desktop_OpenGL_1_5,
        OpenGL_ES_1_0,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        1003 /* "glBindBufferARB" */,
        990 /* "glBindBuffer" */,
        990 /* "glBindBuffer" */,
        990 /* "glBindBuffer" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1003 /* "glBindBufferARB" */,
                                providers, entrypoints);
}

static PFNGLBINDBUFFERBASEPROC
epoxy_glBindBufferBase_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        Desktop_OpenGL_3_1,
        GL_extension_GL_ARB_uniform_buffer_object,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_transform_feedback,
        GL_extension_GL_NV_transform_feedback,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        1019 /* "glBindBufferBase" */,
        1019 /* "glBindBufferBase" */,
        1019 /* "glBindBufferBase" */,
        1019 /* "glBindBufferBase" */,
        1036 /* "glBindBufferBaseEXT" */,
        1056 /* "glBindBufferBaseNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1019 /* "glBindBufferBase" */,
                                providers, entrypoints);
}

static PFNGLBINDBUFFERBASEEXTPROC
epoxy_glBindBufferBaseEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_transform_feedback,
        Desktop_OpenGL_3_0,
        Desktop_OpenGL_3_1,
        GL_extension_GL_ARB_uniform_buffer_object,
        OpenGL_ES_3_0,
        GL_extension_GL_NV_transform_feedback,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        1036 /* "glBindBufferBaseEXT" */,
        1019 /* "glBindBufferBase" */,
        1019 /* "glBindBufferBase" */,
        1019 /* "glBindBufferBase" */,
        1019 /* "glBindBufferBase" */,
        1056 /* "glBindBufferBaseNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1036 /* "glBindBufferBaseEXT" */,
                                providers, entrypoints);
}

static PFNGLBINDBUFFERBASENVPROC
epoxy_glBindBufferBaseNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_transform_feedback,
        Desktop_OpenGL_3_0,
        Desktop_OpenGL_3_1,
        GL_extension_GL_ARB_uniform_buffer_object,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_transform_feedback,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        1056 /* "glBindBufferBaseNV" */,
        1019 /* "glBindBufferBase" */,
        1019 /* "glBindBufferBase" */,
        1019 /* "glBindBufferBase" */,
        1019 /* "glBindBufferBase" */,
        1036 /* "glBindBufferBaseEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1056 /* "glBindBufferBaseNV" */,
                                providers, entrypoints);
}

static PFNGLBINDBUFFEROFFSETEXTPROC
epoxy_glBindBufferOffsetEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_transform_feedback,
        GL_extension_GL_NV_transform_feedback,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        1075 /* "glBindBufferOffsetEXT" */,
        1097 /* "glBindBufferOffsetNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1075 /* "glBindBufferOffsetEXT" */,
                                providers, entrypoints);
}

static PFNGLBINDBUFFEROFFSETNVPROC
epoxy_glBindBufferOffsetNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_transform_feedback,
        GL_extension_GL_EXT_transform_feedback,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        1097 /* "glBindBufferOffsetNV" */,
        1075 /* "glBindBufferOffsetEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1097 /* "glBindBufferOffsetNV" */,
                                providers, entrypoints);
}

static PFNGLBINDBUFFERRANGEPROC
epoxy_glBindBufferRange_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        Desktop_OpenGL_3_1,
        GL_extension_GL_ARB_uniform_buffer_object,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_transform_feedback,
        GL_extension_GL_NV_transform_feedback,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        1118 /* "glBindBufferRange" */,
        1118 /* "glBindBufferRange" */,
        1118 /* "glBindBufferRange" */,
        1118 /* "glBindBufferRange" */,
        1136 /* "glBindBufferRangeEXT" */,
        1157 /* "glBindBufferRangeNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1118 /* "glBindBufferRange" */,
                                providers, entrypoints);
}

static PFNGLBINDBUFFERRANGEEXTPROC
epoxy_glBindBufferRangeEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_transform_feedback,
        Desktop_OpenGL_3_0,
        Desktop_OpenGL_3_1,
        GL_extension_GL_ARB_uniform_buffer_object,
        OpenGL_ES_3_0,
        GL_extension_GL_NV_transform_feedback,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        1136 /* "glBindBufferRangeEXT" */,
        1118 /* "glBindBufferRange" */,
        1118 /* "glBindBufferRange" */,
        1118 /* "glBindBufferRange" */,
        1118 /* "glBindBufferRange" */,
        1157 /* "glBindBufferRangeNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1136 /* "glBindBufferRangeEXT" */,
                                providers, entrypoints);
}

static PFNGLBINDBUFFERRANGENVPROC
epoxy_glBindBufferRangeNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_transform_feedback,
        Desktop_OpenGL_3_0,
        Desktop_OpenGL_3_1,
        GL_extension_GL_ARB_uniform_buffer_object,
        OpenGL_ES_3_0,
        GL_extension_GL_EXT_transform_feedback,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        1157 /* "glBindBufferRangeNV" */,
        1118 /* "glBindBufferRange" */,
        1118 /* "glBindBufferRange" */,
        1118 /* "glBindBufferRange" */,
        1118 /* "glBindBufferRange" */,
        1136 /* "glBindBufferRangeEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1157 /* "glBindBufferRangeNV" */,
                                providers, entrypoints);
}

static PFNGLBINDBUFFERSBASEPROC
epoxy_glBindBuffersBase_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_4,
        GL_extension_GL_ARB_multi_bind,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        1177 /* "glBindBuffersBase" */,
        1177 /* "glBindBuffersBase" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1177 /* "glBindBuffersBase" */,
                                providers, entrypoints);
}

static PFNGLBINDBUFFERSRANGEPROC
epoxy_glBindBuffersRange_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_4,
        GL_extension_GL_ARB_multi_bind,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        1195 /* "glBindBuffersRange" */,
        1195 /* "glBindBuffersRange" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1195 /* "glBindBuffersRange" */,
                                providers, entrypoints);
}

static PFNGLBINDFRAGDATALOCATIONPROC
epoxy_glBindFragDataLocation_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_EXT_blend_func_extended,
        GL_extension_GL_EXT_gpu_shader4,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        1214 /* "glBindFragDataLocation" */,
        1237 /* "glBindFragDataLocationEXT" */,
        1237 /* "glBindFragDataLocationEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1214 /* "glBindFragDataLocation" */,
                                providers, entrypoints);
}

static PFNGLBINDFRAGDATALOCATIONEXTPROC
epoxy_glBindFragDataLocationEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_blend_func_extended,
        GL_extension_GL_EXT_gpu_shader4,
        Desktop_OpenGL_3_0,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        1237 /* "glBindFragDataLocationEXT" */,
        1237 /* "glBindFragDataLocationEXT" */,
        1214 /* "glBindFragDataLocation" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1237 /* "glBindFragDataLocationEXT" */,
                                providers, entrypoints);
}

static PFNGLBINDFRAGDATALOCATIONINDEXEDPROC
epoxy_glBindFragDataLocationIndexed_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_3,
        GL_extension_GL_ARB_blend_func_extended,
        GL_extension_GL_EXT_blend_func_extended,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        1263 /* "glBindFragDataLocationIndexed" */,
        1263 /* "glBindFragDataLocationIndexed" */,
        1293 /* "glBindFragDataLocationIndexedEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1263 /* "glBindFragDataLocationIndexed" */,
                                providers, entrypoints);
}

static PFNGLBINDFRAGDATALOCATIONINDEXEDEXTPROC
epoxy_glBindFragDataLocationIndexedEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_blend_func_extended,
        Desktop_OpenGL_3_3,
        GL_extension_GL_ARB_blend_func_extended,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        1293 /* "glBindFragDataLocationIndexedEXT" */,
        1263 /* "glBindFragDataLocationIndexed" */,
        1263 /* "glBindFragDataLocationIndexed" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1293 /* "glBindFragDataLocationIndexedEXT" */,
                                providers, entrypoints);
}

static PFNGLBINDFRAGMENTSHADERATIPROC
epoxy_glBindFragmentShaderATI_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_ATI_fragment_shader, 1326 /* glBindFragmentShaderATI */);
}

static PFNGLBINDFRAMEBUFFERPROC
epoxy_glBindFramebuffer_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        GL_extension_GL_EXT_framebuffer_object,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        1350 /* "glBindFramebuffer" */,
        1350 /* "glBindFramebuffer" */,
        1350 /* "glBindFramebuffer" */,
        1368 /* "glBindFramebufferEXT" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1350 /* "glBindFramebuffer" */,
                                providers, entrypoints);
}

static PFNGLBINDFRAMEBUFFEREXTPROC
epoxy_glBindFramebufferEXT_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_EXT_framebuffer_object,
        Desktop_OpenGL_3_0,
        GL_extension_GL_ARB_framebuffer_object,
        OpenGL_ES_2_0,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        1368 /* "glBindFramebufferEXT" */,
        1350 /* "glBindFramebuffer" */,
        1350 /* "glBindFramebuffer" */,
        1350 /* "glBindFramebuffer" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1368 /* "glBindFramebufferEXT" */,
                                providers, entrypoints);
}

static PFNGLBINDFRAMEBUFFEROESPROC
epoxy_glBindFramebufferOES_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_OES_framebuffer_object, 1389 /* glBindFramebufferOES */);
}

static PFNGLBINDIMAGETEXTUREPROC
epoxy_glBindImageTexture_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_2,
        GL_extension_GL_ARB_shader_image_load_store,
        OpenGL_ES_3_1,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        1410 /* "glBindImageTexture" */,
        1410 /* "glBindImageTexture" */,
        1410 /* "glBindImageTexture" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1410 /* "glBindImageTexture" */,
                                providers, entrypoints);
}

static PFNGLBINDIMAGETEXTUREEXTPROC
epoxy_glBindImageTextureEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_shader_image_load_store, 1429 /* glBindImageTextureEXT */);
}

static PFNGLBINDIMAGETEXTURESPROC
epoxy_glBindImageTextures_resolver(void)
{
    static const enum gl_provider providers[] = {
        Desktop_OpenGL_4_4,
        GL_extension_GL_ARB_multi_bind,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        1451 /* "glBindImageTextures" */,
        1451 /* "glBindImageTextures" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1451 /* "glBindImageTextures" */,
                                providers, entrypoints);
}

static PFNGLBINDLIGHTPARAMETEREXTPROC
epoxy_glBindLightParameterEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 1471 /* glBindLightParameterEXT */);
}

static PFNGLBINDMATERIALPARAMETEREXTPROC
epoxy_glBindMaterialParameterEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 1495 /* glBindMaterialParameterEXT */);
}

static PFNGLBINDMULTITEXTUREEXTPROC
epoxy_glBindMultiTextureEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_direct_state_access, 1522 /* glBindMultiTextureEXT */);
}

static PFNGLBINDPARAMETEREXTPROC
epoxy_glBindParameterEXT_resolver(void)
{
    return gl_single_resolver(GL_extension_GL_EXT_vertex_shader, 1544 /* glBindParameterEXT */);
}

static PFNGLBINDPROGRAMARBPROC
epoxy_glBindProgramARB_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_ARB_fragment_program,
        GL_extension_GL_ARB_vertex_program,
        GL_extension_GL_NV_vertex_program,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[] = {
        1563 /* "glBindProgramARB" */,
        1563 /* "glBindProgramARB" */,
        1580 /* "glBindProgramNV" */,
    };
    return gl_provider_resolver(entrypoint_strings + 1563 /* "glBindProgramARB" */,
                                providers, entrypoints);
}

static PFNGLBINDPROGRAMNVPROC
epoxy_glBindProgramNV_resolver(void)
{
    static const enum gl_provider providers[] = {
        GL_extension_GL_NV_vertex_program,
        GL_extension_GL_ARB_fragment_program,
        GL_extension_GL_ARB_vertex_program,
        gl_provider_terminator
    };
    static const uint32_t entrypoints[