(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/text/json#read-json__%
    (lambda (_port113536_)
      (std/text/json#read-json-object__% _port113536_ '#f)))
  (define std/text/json#read-json__0
    (lambda ()
      (let ((_port113542_ (current-input-port)))
        (std/text/json#read-json__% _port113542_))))
  (define std/text/json#read-json
    (lambda _g113580_
      (let ((_g113579_ (length _g113580_)))
        (cond ((##fx= _g113579_ 0)
               (apply std/text/json#read-json__0 _g113580_))
              ((##fx= _g113579_ 1)
               (apply std/text/json#read-json__% _g113580_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/text/json#read-json
                _g113580_))))))
  (define std/text/json#string->json-object
    (lambda (_str113533_)
      (std/text/json#read-json-object__% (open-input-string _str113533_) '#f)))
  (define std/text/json#write-json__%
    (lambda (_obj113520_ _port113521_)
      (std/text/json#write-json-object _obj113520_ _port113521_)))
  (define std/text/json#write-json__0
    (lambda (_obj113526_)
      (let ((_port113528_ (current-output-port)))
        (std/text/json#write-json-object _obj113526_ _port113528_))))
  (define std/text/json#write-json
    (lambda _g113582_
      (let ((_g113581_ (length _g113582_)))
        (cond ((##fx= _g113581_ 1)
               (apply std/text/json#write-json__0 _g113582_))
              ((##fx= _g113581_ 2)
               (apply std/text/json#write-json-object _g113582_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/text/json#write-json
                _g113582_))))))
  (define std/text/json#json-object->string
    (lambda (_obj113515_)
      (let ((_port113517_ (open-output-string)))
        (std/text/json#write-json-object _obj113515_ _port113517_)
        (get-output-string _port113517_))))
  (define std/text/json#json-symbolic-keys (make-parameter '#t))
  (define std/text/json#raise-invalid-token
    (lambda (_port113512_ _char113513_)
      (if (eof-object? _char113513_)
          (std/error#raise-io-error
           'read-json
           '"Incomplete JSON object; EOF reached"
           _port113512_)
          (std/error#raise-io-error
           'read-json
           '"Invalid JSON token"
           _port113512_
           _char113513_))))
  (define std/text/json#read-json-object__%
    (lambda (_port113480_ _raise-eof?113481_)
      (std/text/json#skip-whitespace _port113480_)
      (let ((_char113483_ (peek-char _port113480_)))
        (if (eof-object? _char113483_)
            (if _raise-eof?113481_
                (std/error#raise-io-error
                 'read-json
                 '"EOF reached"
                 _port113480_)
                '#!eof)
            (let ((_$e113485_ _char113483_))
              (let ((_default113487113491_
                     (lambda ()
                       (std/text/json#raise-invalid-token
                        _port113480_
                        _char113483_)))
                    (_table113488113493_
                     '#(#f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        2
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        6
                        #f
                        #f
                        6
                        6
                        6
                        6
                        6
                        6
                        6
                        6
                        6
                        6
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        1
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        4
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        5
                        #f
                        #f
                        #f
                        #f
                        #f
                        3
                        #f
                        #f
                        #f
                        #f
                        #f
                        #f
                        0)))
                (if (char? _$e113485_)
                    (let ((_ix113496_ (##char->integer _$e113485_)))
                      (if (##fx< _ix113496_ '124)
                          (let ((_x113499_
                                 (##vector-ref
                                  _table113488113493_
                                  _ix113496_)))
                            (if _x113499_
                                (if (##fx< _x113499_ '3)
                                    (if (##fx= _x113499_ '0)
                                        (std/text/json#read-json-hash
                                         _port113480_)
                                        (if (##fx= _x113499_ '1)
                                            (std/text/json#read-json-list
                                             _port113480_)
                                            (std/text/json#read-json-string
                                             _port113480_)))
                                    (if (##fx< _x113499_ '5)
                                        (if (##fx= _x113499_ '3)
                                            (std/text/json#read-json-true
                                             _port113480_)
                                            (std/text/json#read-json-false
                                             _port113480_))
                                        (if (##fx= _x113499_ '5)
                                            (std/text/json#read-json-null
                                             _port113480_)
                                            (std/text/json#read-json-number
                                             _port113480_))))
                                (_default113487113491_)))
                          (_default113487113491_)))
                    (_default113487113491_))))))))
  (define std/text/json#read-json-object__0
    (lambda (_port113505_)
      (let ((_raise-eof?113507_ '#t))
        (std/text/json#read-json-object__% _port113505_ _raise-eof?113507_))))
  (define std/text/json#read-json-object
    (lambda _g113584_
      (let ((_g113583_ (length _g113584_)))
        (cond ((##fx= _g113583_ 1)
               (apply std/text/json#read-json-object__0 _g113584_))
              ((##fx= _g113583_ 2)
               (apply std/text/json#read-json-object__% _g113584_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/text/json#read-json-object
                _g113584_))))))
  (define std/text/json#skip-whitespace
    (lambda (_port113475_)
      (let ((_char113477_ (peek-char _port113475_)))
        (if (eof-object? _char113477_)
            '#!void
            (if (char-whitespace? _char113477_)
                (begin
                  (read-char _port113475_)
                  (std/text/json#skip-whitespace _port113475_))
                '#!void)))))
  (define std/text/json#skip-chars
    (lambda (_chars113433_ _port113434_)
      (let _lp113436_ ((_rest113438_ _chars113433_))
        (let* ((_rest113439113447_ _rest113438_)
               (_else113441113455_ (lambda () '#!void))
               (_K113443113463_
                (lambda (_rest113458_ _char113459_)
                  (let ((_next113461_ (read-char _port113434_)))
                    (if (eq? _next113461_ _char113459_)
                        (_lp113436_ _rest113458_)
                        (std/text/json#raise-invalid-token
                         _port113434_
                         _next113461_))))))
          (if (##pair? _rest113439113447_)
              (let ((_hd113444113466_ (##car _rest113439113447_))
                    (_tl113445113468_ (##cdr _rest113439113447_)))
                (let* ((_char113471_ _hd113444113466_)
                       (_rest113473_ _tl113445113468_))
                  (_K113443113463_ _rest113473_ _char113471_)))
              '#!void)))))
  (define std/text/json#read-json-hash
    (lambda (_port113417_)
      (read-char _port113417_)
      (let ((_obj113419_
             (if (std/text/json#json-symbolic-keys)
                 (make-table 'test: eq?)
                 (make-table))))
        (let _lp113421_ ()
          (let ((_key113424_ (std/text/json#read-json-hash-key _port113417_)))
            (if _key113424_
                (if (hash-key? _obj113419_ _key113424_)
                    (error '"Duplicate hash key in JSON input" _key113424_)
                    (let ((_val113426_
                           (std/text/json#read-json-object__0 _port113417_)))
                      (table-set! _obj113419_ _key113424_ _val113426_)
                      (std/text/json#skip-whitespace _port113417_)
                      (let* ((_char113428_ (peek-char _port113417_))
                             (_$e113430_ _char113428_))
                        (if (eq? '#\, _$e113430_)
                            (begin (read-char _port113417_) (_lp113421_))
                            (if (eq? '#\} _$e113430_)
                                (begin (read-char _port113417_) _obj113419_)
                                (std/text/json#raise-invalid-token
                                 _port113417_
                                 _char113428_))))))
                _obj113419_))))))
  (define std/text/json#read-json-hash-key
    (lambda (_port113403_)
      (std/text/json#skip-whitespace _port113403_)
      (let* ((_char113405_ (peek-char _port113403_)) (_$e113407_ _char113405_))
        (if (eq? '#\" _$e113407_)
            (let ((_key113410_ (std/text/json#read-json-string _port113403_)))
              (std/text/json#skip-whitespace _port113403_)
              (let* ((_char113412_ (peek-char _port113403_))
                     (_$e113414_ _char113412_))
                (if (eq? '#\: _$e113414_)
                    (begin
                      (read-char _port113403_)
                      (if (std/text/json#json-symbolic-keys)
                          (string->symbol _key113410_)
                          _key113410_))
                    (std/text/json#raise-invalid-token
                     _port113403_
                     _char113412_))))
            (if (eq? '#\} _$e113407_)
                (begin (read-char _port113403_) '#f)
                (std/text/json#raise-invalid-token
                 _port113403_
                 _char113405_))))))
  (define std/text/json#read-json-list
    (lambda (_port113395_)
      (read-char _port113395_)
      (let _lp113397_ ((_els113399_ '()))
        (let ((_next113401_ (std/text/json#read-json-list-next _port113395_)))
          (if _next113401_
              (_lp113397_ (cons _next113401_ _els113399_))
              (std/srfi/1#reverse! _els113399_))))))
  (define std/text/json#read-json-list-next
    (lambda (_port113381_)
      (std/text/json#skip-whitespace _port113381_)
      (let* ((_char113383_ (peek-char _port113381_)) (_$e113385_ _char113383_))
        (if (eq? '#\] _$e113385_)
            (begin (read-char _port113381_) '#f)
            (let ((_obj113388_
                   (std/text/json#read-json-object__0 _port113381_)))
              (std/text/json#skip-whitespace _port113381_)
              (let* ((_char113390_ (peek-char _port113381_))
                     (_$e113392_ _char113390_))
                (if (eq? '#\, _$e113392_)
                    (begin (read-char _port113381_) _obj113388_)
                    (if (eq? '#\] _$e113392_)
                        _obj113388_
                        (std/text/json#raise-invalid-token
                         _port113381_
                         _char113390_)))))))))
  (define std/text/json#hexes '"0123456789abcdef")
  (define std/text/json#HEXES '"0123456789ABCDEF")
  (define std/text/json#hextab
    (let ((_ht113369_ (make-table 'test: eq?)))
      (letrec ((_put113371_
                (lambda (_str113373_)
                  (let ((_len113375_ (string-length _str113373_)))
                    (let _lp113377_ ((_k113379_ '0))
                      (if (##fx< _k113379_ _len113375_)
                          (begin
                            (table-set!
                             _ht113369_
                             (##string-ref _str113373_ _k113379_)
                             _k113379_)
                            (_lp113377_ (##fx+ _k113379_ '1)))
                          '#!void))))))
        (_put113371_ std/text/json#hexes)
        (_put113371_ std/text/json#HEXES)
        _ht113369_)))
  (define std/text/json#read-json-string
    (lambda (_port113277_)
      (letrec ((_read-escape-char113279_
                (lambda (_port113348_)
                  (let* ((_char113350_ (read-char _port113348_))
                         (_$e113352_ _char113350_))
                    (let ((_default113354113358_
                           (lambda ()
                             (std/text/json#raise-invalid-token
                              _port113348_
                              _char113350_)))
                          (_table113355113360_
                           '#(#f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              0
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              0
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              0
                              #f
                              #f
                              #f
                              #f
                              #f
                              1
                              #f
                              #f
                              #f
                              3
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              #f
                              2
                              #f
                              #f
                              #f
                              4
                              #f
                              5
                              6)))
                      (if (char? _$e113352_)
                          (let ((_ix113363_ (##char->integer _$e113352_)))
                            (if (##fx< _ix113363_ '118)
                                (let ((_x113366_
                                       (##vector-ref
                                        _table113355113360_
                                        _ix113363_)))
                                  (if _x113366_
                                      (if (##fx< _x113366_ '3)
                                          (if (##fx= _x113366_ '0)
                                              _char113350_
                                              (if (##fx= _x113366_ '1)
                                                  '#\backspace
                                                  '#\newline))
                                          (if (##fx< _x113366_ '5)
                                              (if (##fx= _x113366_ '3)
                                                  '#\page
                                                  '#\return)
                                              (if (##fx= _x113366_ '5)
                                                  '#\tab
                                                  (_read-escape-unicode113280_
                                                   _port113348_))))
                                      (_default113354113358_)))
                                (_default113354113358_)))
                          (_default113354113358_))))))
               (_read-escape-unicode113280_
                (lambda (_port113297_)
                  (let _lp113299_ ((_n113301_ '0) (_chars113302_ '()))
                    (if (##fx< _n113301_ '4)
                        (_lp113299_
                         (##fx+ _n113301_ '1)
                         (cons (read-char _port113297_) _chars113302_))
                        (let _lp113304_ ((_rest113306_ _chars113302_)
                                         (_val113307_ '0)
                                         (_shift113308_ '0))
                          (let* ((_rest113309113317_ _rest113306_)
                                 (_else113311113328_
                                  (lambda ()
                                    (if (and (##fx< _val113307_ ##max-char)
                                             (or (##fx< _val113307_ '55296)
                                                 (##fx< '57343 _val113307_)))
                                        (##integer->char _val113307_)
                                        '#\xfffd)))
                                 (_K113313113336_
                                  (lambda (_rest113331_ _char113332_)
                                    (let ((_n113334_
                                           (##fxarithmetic-shift
                                            (_hex-value113281_ _char113332_)
                                            _shift113308_)))
                                      (_lp113304_
                                       _rest113331_
                                       (bitwise-ior _n113334_ _val113307_)
                                       (##fx+ _shift113308_ '4))))))
                            (if (##pair? _rest113309113317_)
                                (let ((_hd113314113339_
                                       (##car _rest113309113317_))
                                      (_tl113315113341_
                                       (##cdr _rest113309113317_)))
                                  (let* ((_char113344_ _hd113314113339_)
                                         (_rest113346_ _tl113315113341_))
                                    (_K113313113336_
                                     _rest113346_
                                     _char113344_)))
                                (_else113311113328_))))))))
               (_hex-value113281_
                (lambda (_char113292_)
                  (let ((_$e113294_
                         (table-ref std/text/json#hextab _char113292_ '#f)))
                    (if _$e113294_
                        (values _$e113294_)
                        (std/text/json#raise-invalid-token
                         _port113277_
                         _char113292_))))))
        (read-char _port113277_)
        (let _lp113283_ ((_chars113285_ '()))
          (let* ((_char113287_ (read-char _port113277_))
                 (_$e113289_ _char113287_))
            (if (eq? '#\" _$e113289_)
                (list->string (std/srfi/1#reverse! _chars113285_))
                (if (eq? '#\\ _$e113289_)
                    (_lp113283_
                     (cons (_read-escape-char113279_ _port113277_)
                           _chars113285_))
                    (if (eof-object? _char113287_)
                        (std/text/json#raise-invalid-token
                         _port113277_
                         _char113287_)
                        (_lp113283_ (cons _char113287_ _chars113285_))))))))))
  (define std/text/json#read-json-number
    (lambda (_port113254_)
      (letrec ((_parse113256_
                (lambda (_chars113270_)
                  (let* ((_str113272_
                          (list->string (std/srfi/1#reverse! _chars113270_)))
                         (_$e113274_ (string->number _str113272_)))
                    (if _$e113274_
                        _$e113274_
                        (std/text/json#raise-invalid-token
                         _port113254_
                         _str113272_))))))
        (let _lp113258_ ((_chars113260_ (cons (read-char _port113254_) '())))
          (let ((_char113262_ (peek-char _port113254_)))
            (if (or (eof-object? _char113262_)
                    (memq _char113262_ '(#\] #\} #\,))
                    (char-whitespace? _char113262_))
                (_parse113256_ _chars113260_)
                (_lp113258_
                 (cons (read-char _port113254_) _chars113260_))))))))
  (define std/text/json#read-json-true
    (lambda (_port113252_)
      (std/text/json#skip-chars '(#\t #\r #\u #\e) _port113252_)
      '#t))
  (define std/text/json#read-json-false
    (lambda (_port113250_)
      (std/text/json#skip-chars '(#\f #\a #\l #\s #\e) _port113250_)
      '#f))
  (define std/text/json#read-json-null
    (lambda (_port113248_)
      (std/text/json#skip-chars '(#\n #\u #\l #\l) _port113248_)
      '#!void))
  (define std/text/json#write-json-object
    (lambda (_obj113245_ _port113246_)
      (if (number? _obj113245_)
          (if (and (exact? _obj113245_) (integer? _obj113245_))
              (gerbil/gambit/ports#write-string__%
               (number->string _obj113245_)
               _port113246_)
              (if (inexact? _obj113245_)
                  (std/text/json#write-json-inexact _obj113245_ _port113246_)
                  (if (rational? _obj113245_)
                      (std/text/json#write-json-inexact
                       (exact->inexact _obj113245_)
                       _port113246_)
                      (error '"Bad JSON object" _obj113245_))))
          (if (string? _obj113245_)
              (std/text/json#write-json-string _obj113245_ _port113246_)
              (if (symbol? _obj113245_)
                  (std/text/json#write-json-string
                   (symbol->string _obj113245_)
                   _port113246_)
                  (if (keyword? _obj113245_)
                      (std/text/json#write-json-string
                       (keyword->string _obj113245_)
                       _port113246_)
                      (if (list? _obj113245_)
                          (std/text/json#write-json-list
                           _obj113245_
                           _port113246_)
                          (if (vector? _obj113245_)
                              (std/text/json#write-json-vector
                               _obj113245_
                               _port113246_)
                              (if (table? _obj113245_)
                                  (std/text/json#write-json-hash
                                   _obj113245_
                                   _port113246_)
                                  (if (eq? '#t _obj113245_)
                                      (gerbil/gambit/ports#write-string__%
                                       '"true"
                                       _port113246_)
                                      (if (eq? '#f _obj113245_)
                                          (gerbil/gambit/ports#write-string__%
                                           '"false"
                                           _port113246_)
                                          (if (eq? _obj113245_ '#!void)
                                              (gerbil/gambit/ports#write-string__%
                                               '"null"
                                               _port113246_)
                                              (std/text/json#write-json-object
                                               (call-method _obj113245_ ':json)
                                               _port113246_)))))))))))))
  (define std/text/json#write-json-inexact
    (lambda (_obj113237_ _port113238_)
      (let* ((_mag113240_ (abs _obj113237_))
             (_str113242_ (number->string _mag113240_)))
        (if (flnegative? _obj113237_) (write-char '#\- _port113238_) '#!void)
        (if (eq? (string-ref _str113242_ '0) '#\.)
            (write-char '#\0 _port113238_)
            '#!void)
        (gerbil/gambit/ports#write-string__% _str113242_ _port113238_)
        (if (eq? (string-ref
                  _str113242_
                  (##fx- (string-length _str113242_) '1))
                 '#\.)
            (write-char '#\0 _port113238_)
            '#!void))))
  (define std/text/json#write-json-list
    (lambda (_obj113172_ _port113173_)
      (write-char '#\[ _port113173_)
      (let _lp113175_ ((_rest113177_ _obj113172_))
        (let* ((_rest113178113191_ _rest113177_)
               (_E113182113195_
                (lambda () (error '"No clause matching" _rest113178113191_))))
          (let ((_K113187113227_
                 (lambda (_val113225_)
                   (std/text/json#write-json-object _val113225_ _port113173_)
                   (write-char '#\] _port113173_)))
                (_K113184113210_
                 (lambda (_rest113207_ _val113208_)
                   (std/text/json#write-json-object _val113208_ _port113173_)
                   (write-char '#\, _port113173_)
                   (_lp113175_ _rest113207_)))
                (_K113183113200_ (lambda () (write-char '#\] _port113173_))))
            (let ((_try-match113181113203_
                   (lambda ()
                     (if (##null? _rest113178113191_)
                         (_K113183113200_)
                         (_E113182113195_)))))
              (if (##pair? _rest113178113191_)
                  (let ((_tl113189113232_ (##cdr _rest113178113191_))
                        (_hd113188113230_ (##car _rest113178113191_)))
                    (if (##null? _tl113189113232_)
                        (let ((_val113235_ _hd113188113230_))
                          (_K113187113227_ _val113235_))
                        (let ((_val113218_ _hd113188113230_)
                              (_rest113220_ _tl113189113232_))
                          (_K113184113210_ _rest113220_ _val113218_))))
                  (_try-match113181113203_))))))))
  (define std/text/json#write-json-vector
    (lambda (_obj113161_ _port113162_)
      (let ((_len113164_ (vector-length _obj113161_)))
        (if (##fxpositive? _len113164_)
            (let ((_last113166_ (##fx- _len113164_ '1)))
              (write-char '#\[ _port113162_)
              (let _lp113168_ ((_n113170_ '0))
                (if (##fx= _n113170_ _last113166_)
                    (begin
                      (std/text/json#write-json-object
                       (##vector-ref _obj113161_ _n113170_)
                       _port113162_)
                      (write-char '#\] _port113162_))
                    (begin
                      (std/text/json#write-json-object
                       (##vector-ref _obj113161_ _n113170_)
                       _port113162_)
                      (write-char '#\, _port113162_)
                      (_lp113168_ (##fx+ _n113170_ '1))))))
            (gerbil/gambit/ports#write-string__% '"[]" _port113162_)))))
  (define std/text/json#write-json-hash
    (lambda (_obj113070_ _port113071_)
      (letrec ((_string-e113073_
                (lambda (_key113159_)
                  (if (string? _key113159_)
                      _key113159_
                      (if (symbol? _key113159_)
                          (symbol->string _key113159_)
                          (if (keyword? _key113159_)
                              (keyword->string _key113159_)
                              (error '"Illegal hash key; must be symbol, keyword or string"
                                     _obj113070_
                                     _key113159_)))))))
        (write-char '#\{ _port113071_)
        (let ((_lst113075_ (table->list _obj113070_)))
          (let _lp113077_ ((_rest113079_ _lst113075_))
            (let* ((_rest113080113097_ _rest113079_)
                   (_E113084113101_
                    (lambda ()
                      (error '"No clause matching" _rest113080113097_))))
              (let ((_K113091113142_
                     (lambda (_val113139_ _key113140_)
                       (write (_string-e113073_ _key113140_) _port113071_)
                       (write-char '#\: _port113071_)
                       (std/text/json#write-json-object
                        _val113139_
                        _port113071_)
                       (write-char '#\} _port113071_)))
                    (_K113086113117_
                     (lambda (_rest113113_ _val113114_ _key113115_)
                       (write (_string-e113073_ _key113115_) _port113071_)
                       (write-char '#\: _port113071_)
                       (std/text/json#write-json-object
                        _val113114_
                        _port113071_)
                       (write-char '#\, _port113071_)
                       (_lp113077_ _rest113113_)))
                    (_K113085113106_
                     (lambda () (write-char '#\} _port113071_))))
                (let ((_try-match113083113109_
                       (lambda ()
                         (if (##null? _rest113080113097_)
                             (_K113085113106_)
                             (_E113084113101_)))))
                  (if (##pair? _rest113080113097_)
                      (let ((_tl113093113147_ (##cdr _rest113080113097_))
                            (_hd113092113145_ (##car _rest113080113097_)))
                        (if (##pair? _hd113092113145_)
                            (let ((_tl113095113152_ (##cdr _hd113092113145_))
                                  (_hd113094113150_ (##car _hd113092113145_)))
                              (if (##null? _tl113093113147_)
                                  (let ((_key113155_ _hd113094113150_)
                                        (_val113157_ _tl113095113152_))
                                    (_K113091113142_ _val113157_ _key113155_))
                                  (let ((_key113130_ _hd113094113150_)
                                        (_val113132_ _tl113095113152_)
                                        (_rest113134_ _tl113093113147_))
                                    (_K113086113117_
                                     _rest113134_
                                     _val113132_
                                     _key113130_))))
                            (_E113084113101_)))
                      (_try-match113083113109_))))))))))
  (define std/text/json#write-json-string
    (lambda (_obj113029_ _port113030_)
      (letrec* ((_escape113032_
                 '((#\" . #\")
                   (#\\ . #\\)
                   (#\backspace . #\b)
                   (#\newline . #\n)
                   (#\page . #\f)
                   (#\return . #\r)
                   (#\tab . #\t)))
                (_printable-char?113033_
                 (lambda (_char113066_)
                   (let ((_n113068_ (char->integer _char113066_)))
                     (if (##fx< _n113068_ '32)
                         '#f
                         (if (##fx= _n113068_ '127) '#f '#t)))))
                (_write-uchar113034_
                 (lambda (_char113053_ _port113054_)
                   (let ((_int113056_ (char->integer _char113053_)))
                     (gerbil/gambit/ports#write-string__% '"\\u" _port113054_)
                     (let _lp113058_ ((_n113060_ '0)
                                      (_mask113061_ '61440)
                                      (_shift113062_ '-12))
                       (if (##fx< _n113060_ '4)
                           (let ((_char113064_
                                  (string-ref
                                   std/text/json#hexes
                                   (arithmetic-shift
                                    (bitwise-and _int113056_ _mask113061_)
                                    _shift113062_))))
                             (write-char _char113064_ _port113054_)
                             (_lp113058_
                              (##fx+ _n113060_ '1)
                              (arithmetic-shift _mask113061_ '-4)
                              (##fx+ _shift113062_ '4)))
                           '#!void)))))
                (_write-str113035_
                 (lambda (_obj113037_ _port113038_)
                   (let ((_len113040_ (string-length _obj113037_)))
                     (let _lp113042_ ((_n113044_ '0))
                       (if (##fx< _n113044_ _len113040_)
                           (let ((_char113046_
                                  (string-ref _obj113037_ _n113044_)))
                             (let ((_$e113048_
                                    (assq _char113046_ _escape113032_)))
                               (if _$e113048_
                                   ((lambda (_esc113051_)
                                      (write-char '#\\ _port113038_)
                                      (write-char
                                       (cdr _esc113051_)
                                       _port113038_))
                                    _$e113048_)
                                   (if (_printable-char?113033_ _char113046_)
                                       (write-char _char113046_ _port113038_)
                                       (_write-uchar113034_
                                        _char113046_
                                        _port113038_))))
                             (_lp113042_ (##fx+ _n113044_ '1)))
                           '#!void))))))
        (write-char '#\" _port113030_)
        (_write-str113035_ _obj113029_ _port113030_)
        (write-char '#\" _port113030_)))))
