(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/srfi/41#stream-type
    (make-struct-type
     'std/srfi/41#stream-type
     '#f
     '1
     'stream-type
     '((fields: box))
     '#f))
  (define std/srfi/41#stream? (make-struct-predicate std/srfi/41#stream-type))
  (define std/srfi/41#stream-promise
    (make-struct-field-accessor std/srfi/41#stream-type '0))
  (define std/srfi/41#stream-promise!
    (make-struct-field-mutator std/srfi/41#stream-type '0))
  (define std/srfi/41#make-stream
    (lambda (_box52304_)
      (make-struct-instance std/srfi/41#stream-type _box52304_)))
  (define std/srfi/41#stream-eager
    (lambda (_expr52302_)
      (##structure std/srfi/41#stream-type (cons 'eager _expr52302_))))
  (define std/srfi/41#stream-force
    (lambda (_promise52290_)
      (let* ((_content52292_
              (##structure-ref _promise52290_ '1 std/srfi/41#stream-type '#f))
             (_$e52294_ (car _content52292_)))
        (if (eq? 'eager _$e52294_)
            (cdr _content52292_)
            (if (eq? 'lazy _$e52294_)
                (let* ((_promise*52297_ ((cdr _content52292_)))
                       (_content52299_
                        (##structure-ref
                         _promise52290_
                         '1
                         std/srfi/41#stream-type
                         '#f)))
                  (if (not (eqv? (car _content52299_) 'eager))
                      (begin
                        (set-car!
                         _content52299_
                         (car (##structure-ref
                               _promise*52297_
                               '1
                               std/srfi/41#stream-type
                               '#f)))
                        (set-cdr!
                         _content52299_
                         (cdr (##structure-ref
                               _promise*52297_
                               '1
                               std/srfi/41#stream-type
                               '#f)))
                        (##structure-set!
                         _promise*52297_
                         _content52299_
                         '1
                         std/srfi/41#stream-type
                         '#f))
                      '#!void)
                  (std/srfi/41#stream-force _promise52290_))
                '#!void)))))
  (define std/srfi/41#stream-null
    (##structure
     std/srfi/41#stream-type
     (cons 'lazy (lambda () (std/srfi/41#stream-eager (cons 'stream 'null))))))
  (define std/srfi/41#stream-pare-type
    (make-struct-type
     'std/srfi/41#stream-pare-type
     '#f
     '2
     'stream-pare-type
     '((fields: kar kdr))
     '#f))
  (define std/srfi/41#stream-pare?
    (make-struct-predicate std/srfi/41#stream-pare-type))
  (define std/srfi/41#stream-kar
    (make-struct-field-accessor std/srfi/41#stream-pare-type '0))
  (define std/srfi/41#stream-kdr
    (make-struct-field-accessor std/srfi/41#stream-pare-type '1))
  (define std/srfi/41#make-stream-pare
    (lambda (_kar52286_ _kdr52287_)
      (make-struct-instance
       std/srfi/41#stream-pare-type
       _kar52286_
       _kdr52287_)))
  (define std/srfi/41#stream-pair?
    (lambda (_obj52284_)
      (if (##structure-instance-of? _obj52284_ 'std/srfi/41#stream-type)
          (##structure-instance-of?
           (std/srfi/41#stream-force _obj52284_)
           'std/srfi/41#stream-pare-type)
          '#f)))
  (define std/srfi/41#stream-null?
    (lambda (_obj52282_)
      (if (##structure-instance-of? _obj52282_ 'std/srfi/41#stream-type)
          (eqv? (std/srfi/41#stream-force _obj52282_)
                (std/srfi/41#stream-force std/srfi/41#stream-null))
          '#f)))
  (define std/srfi/41#stream-car
    (lambda (_strm52280_)
      (if (not (##structure-instance-of? _strm52280_ 'std/srfi/41#stream-type))
          (error 'stream-car '"non-stream")
          (if (std/srfi/41#stream-null? _strm52280_)
              (error 'stream-car '"null stream")
              (std/srfi/41#stream-force
               (##structure-ref
                (std/srfi/41#stream-force _strm52280_)
                '1
                std/srfi/41#stream-pare-type
                '#f))))))
  (define std/srfi/41#stream-cdr
    (lambda (_strm52278_)
      (if (not (##structure-instance-of? _strm52278_ 'std/srfi/41#stream-type))
          (error 'stream-cdr '"non-stream")
          (if (std/srfi/41#stream-null? _strm52278_)
              (error 'stream-cdr '"null stream")
              (##structure-ref
               (std/srfi/41#stream-force _strm52278_)
               '2
               std/srfi/41#stream-pare-type
               '#f)))))
  (define std/srfi/41#exists
    (lambda (_pred?52272_ . _lists52273_)
      (if (not (null? (car _lists52273_)))
          (let ((_$e52275_ (apply _pred?52272_ (map car _lists52273_))))
            (if _$e52275_
                _$e52275_
                (apply std/srfi/41#exists
                       _pred?52272_
                       (map cdr _lists52273_))))
          '#f)))
  (define std/srfi/41#list->stream
    (lambda (_objs52262_)
      (letrec ((_list->stream52264_
                (lambda (_objs52266_)
                  (##structure
                   std/srfi/41#stream-type
                   (cons 'lazy
                         (lambda ()
                           (let ()
                             (if (null? _objs52266_)
                                 std/srfi/41#stream-null
                                 (std/srfi/41#stream-eager
                                  (##structure
                                   std/srfi/41#stream-pare-type
                                   (##structure
                                    std/srfi/41#stream-type
                                    (cons 'lazy
                                          (lambda ()
                                            (std/srfi/41#stream-eager
                                             (car _objs52266_)))))
                                   (##structure
                                    std/srfi/41#stream-type
                                    (cons 'lazy
                                          (lambda ()
                                            (_list->stream52264_
                                             (cdr _objs52266_)))))))))))))))
        (if (not (list? _objs52262_))
            (error 'list->stream '"non-list argument")
            (_list->stream52264_ _objs52262_)))))
  (define std/srfi/41#port->stream
    (lambda _port52248_
      (letrec ((_port->stream52250_
                (lambda (_p52254_)
                  (##structure
                   std/srfi/41#stream-type
                   (cons 'lazy
                         (lambda ()
                           (let ()
                             (let ((_c52258_ (read-char _p52254_)))
                               (if (eof-object? _c52258_)
                                   std/srfi/41#stream-null
                                   (std/srfi/41#stream-eager
                                    (##structure
                                     std/srfi/41#stream-pare-type
                                     (##structure
                                      std/srfi/41#stream-type
                                      (cons 'lazy
                                            (lambda ()
                                              (std/srfi/41#stream-eager
                                               _c52258_))))
                                     (##structure
                                      std/srfi/41#stream-type
                                      (cons 'lazy
                                            (lambda ()
                                              (_port->stream52250_
                                               _p52254_)))))))))))))))
        (let ((_p52252_
               (if (null? _port52248_)
                   (current-input-port)
                   (car _port52248_))))
          (if (not (input-port? _p52252_))
              (error 'port->stream '"non-input-port argument")
              (_port->stream52250_ _p52252_))))))
  (define std/srfi/41#stream->list
    (lambda _args52235_
      (let ((_n52237_ (if (= '1 (length _args52235_)) '#f (car _args52235_)))
            (_strm52238_
             (if (= '1 (length _args52235_))
                 (car _args52235_)
                 (cadr _args52235_))))
        (if (not (##structure-instance-of?
                  _strm52238_
                  'std/srfi/41#stream-type))
            (error 'stream->list '"non-stream argument")
            (if (and _n52237_ (not (integer? _n52237_)))
                (error 'stream->list '"non-integer count")
                (if (and _n52237_ (negative? _n52237_))
                    (error 'stream->list '"negative count")
                    (let _loop52240_ ((_n52242_ (if _n52237_ _n52237_ '-1))
                                      (_strm52243_ _strm52238_))
                      (if (or (zero? _n52242_)
                              (std/srfi/41#stream-null? _strm52243_))
                          '()
                          (cons (std/srfi/41#stream-car _strm52243_)
                                (_loop52240_
                                 (- _n52242_ '1)
                                 (std/srfi/41#stream-cdr _strm52243_)))))))))))
  (define std/srfi/41#stream-append
    (lambda _strms52223_
      (letrec ((_stream-append52225_
                (lambda (_strms52229_)
                  (##structure
                   std/srfi/41#stream-type
                   (cons 'lazy
                         (lambda ()
                           (let ()
                             (if (null? (cdr _strms52229_))
                                 (car _strms52229_)
                                 (if (std/srfi/41#stream-null?
                                      (car _strms52229_))
                                     (_stream-append52225_ (cdr _strms52229_))
                                     (std/srfi/41#stream-eager
                                      (##structure
                                       std/srfi/41#stream-pare-type
                                       (##structure
                                        std/srfi/41#stream-type
                                        (cons 'lazy
                                              (lambda ()
                                                (std/srfi/41#stream-eager
                                                 (std/srfi/41#stream-car
                                                  (car _strms52229_))))))
                                       (##structure
                                        std/srfi/41#stream-type
                                        (cons 'lazy
                                              (lambda ()
                                                (_stream-append52225_
                                                 (cons (std/srfi/41#stream-cdr
                                                        (car _strms52229_))
                                                       (cdr _strms52229_)))))))))))))))))
        (if (null? _strms52223_)
            std/srfi/41#stream-null
            (if (std/srfi/41#exists
                 (lambda (_x52227_)
                   (not (##structure-instance-of?
                         _x52227_
                         'std/srfi/41#stream-type)))
                 _strms52223_)
                (error 'stream-append '"non-stream argument")
                (_stream-append52225_ _strms52223_))))))
  (define std/srfi/41#stream-concat
    (lambda (_strms52211_)
      (letrec ((_stream-concat52213_
                (lambda (_strms52215_)
                  (##structure
                   std/srfi/41#stream-type
                   (cons 'lazy
                         (lambda ()
                           (let ()
                             (if (std/srfi/41#stream-null? _strms52215_)
                                 std/srfi/41#stream-null
                                 (if (not (##structure-instance-of?
                                           (std/srfi/41#stream-car
                                            _strms52215_)
                                           'std/srfi/41#stream-type))
                                     (error 'stream-concat
                                            '"non-stream object in input stream")
                                     (if (std/srfi/41#stream-null?
                                          (std/srfi/41#stream-car
                                           _strms52215_))
                                         (_stream-concat52213_
                                          (std/srfi/41#stream-cdr
                                           _strms52215_))
                                         (std/srfi/41#stream-eager
                                          (##structure
                                           std/srfi/41#stream-pare-type
                                           (##structure
                                            std/srfi/41#stream-type
                                            (cons 'lazy
                                                  (lambda ()
                                                    (std/srfi/41#stream-eager
                                                     (std/srfi/41#stream-car
                                                      (std/srfi/41#stream-car
                                                       _strms52215_))))))
                                           (##structure
                                            std/srfi/41#stream-type
                                            (cons 'lazy
                                                  (lambda ()
                                                    (_stream-concat52213_
                                                     (std/srfi/41#stream-eager
                                                      (##structure
                                                       std/srfi/41#stream-pare-type
                                                       (##structure
                                                        std/srfi/41#stream-type
                                                        (cons 'lazy
                                                              (lambda ()
                                                                (std/srfi/41#stream-eager
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         (std/srfi/41#stream-cdr
                          (std/srfi/41#stream-car _strms52215_))))))
               (##structure
                std/srfi/41#stream-type
                (cons 'lazy
                      (lambda ()
                        (std/srfi/41#stream-cdr
                         _strms52215_))))))))))))))))))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
        (if (not (##structure-instance-of?
                  _strms52211_
                  'std/srfi/41#stream-type))
            (error 'stream-concat '"non-stream argument")
            (_stream-concat52213_ _strms52211_)))))
  (define std/srfi/41#stream-constant
    (lambda _objs52203_
      (##structure
       std/srfi/41#stream-type
       (cons 'lazy
             (lambda ()
               (let ()
                 (if (null? _objs52203_)
                     std/srfi/41#stream-null
                     (if (null? (cdr _objs52203_))
                         (std/srfi/41#stream-eager
                          (##structure
                           std/srfi/41#stream-pare-type
                           (##structure
                            std/srfi/41#stream-type
                            (cons 'lazy
                                  (lambda ()
                                    (std/srfi/41#stream-eager
                                     (car _objs52203_)))))
                           (##structure
                            std/srfi/41#stream-type
                            (cons 'lazy
                                  (lambda ()
                                    (std/srfi/41#stream-constant
                                     (car _objs52203_)))))))
                         (std/srfi/41#stream-eager
                          (##structure
                           std/srfi/41#stream-pare-type
                           (##structure
                            std/srfi/41#stream-type
                            (cons 'lazy
                                  (lambda ()
                                    (std/srfi/41#stream-eager
                                     (car _objs52203_)))))
                           (##structure
                            std/srfi/41#stream-type
                            (cons 'lazy
                                  (lambda ()
                                    (apply std/srfi/41#stream-constant
                                           (append (cdr _objs52203_)
                                                   (list (car _objs52203_)))))))))))))))))
  (define std/srfi/41#stream-drop
    (lambda (_n52190_ _strm52191_)
      (letrec ((_stream-drop52193_
                (lambda (_n52195_ _strm52196_)
                  (##structure
                   std/srfi/41#stream-type
                   (cons 'lazy
                         (lambda ()
                           (let ()
                             (if (or (zero? _n52195_)
                                     (std/srfi/41#stream-null? _strm52196_))
                                 _strm52196_
                                 (_stream-drop52193_
                                  (- _n52195_ '1)
                                  (std/srfi/41#stream-cdr _strm52196_))))))))))
        (if (not (integer? _n52190_))
            (error 'stream-drop '"non-integer argument")
            (if (negative? _n52190_)
                (error 'stream-drop '"negative argument")
                (if (not (##structure-instance-of?
                          _strm52191_
                          'std/srfi/41#stream-type))
                    (error 'stream-drop '"non-stream argument")
                    (_stream-drop52193_ _n52190_ _strm52191_)))))))
  (define std/srfi/41#stream-drop-while
    (lambda (_pred?52181_ _strm52182_)
      (letrec ((_stream-drop-while52184_
                (lambda (_strm52186_)
                  (##structure
                   std/srfi/41#stream-type
                   (cons 'lazy
                         (lambda ()
                           (let ()
                             (if (and (std/srfi/41#stream-pair? _strm52186_)
                                      (_pred?52181_
                                       (std/srfi/41#stream-car _strm52186_)))
                                 (_stream-drop-while52184_
                                  (std/srfi/41#stream-cdr _strm52186_))
                                 _strm52186_))))))))
        (if (not (procedure? _pred?52181_))
            (error 'stream-drop-while '"non-procedural argument")
            (if (not (##structure-instance-of?
                      _strm52182_
                      'std/srfi/41#stream-type))
                (error 'stream-drop-while '"non-stream argument")
                (_stream-drop-while52184_ _strm52182_))))))
  (define std/srfi/41#stream-filter
    (lambda (_pred?52170_ _strm52171_)
      (letrec ((_stream-filter52173_
                (lambda (_strm52175_)
                  (##structure
                   std/srfi/41#stream-type
                   (cons 'lazy
                         (lambda ()
                           (let ()
                             (if (std/srfi/41#stream-null? _strm52175_)
                                 std/srfi/41#stream-null
                                 (if (_pred?52170_
                                      (std/srfi/41#stream-car _strm52175_))
                                     (std/srfi/41#stream-eager
                                      (##structure
                                       std/srfi/41#stream-pare-type
                                       (##structure
                                        std/srfi/41#stream-type
                                        (cons 'lazy
                                              (lambda ()
                                                (std/srfi/41#stream-eager
                                                 (std/srfi/41#stream-car
                                                  _strm52175_)))))
                                       (##structure
                                        std/srfi/41#stream-type
                                        (cons 'lazy
                                              (lambda ()
                                                (_stream-filter52173_
                                                 (std/srfi/41#stream-cdr
                                                  _strm52175_)))))))
                                     (_stream-filter52173_
                                      (std/srfi/41#stream-cdr
                                       _strm52175_)))))))))))
        (if (not (procedure? _pred?52170_))
            (error 'stream-filter '"non-procedural argument")
            (if (not (##structure-instance-of?
                      _strm52171_
                      'std/srfi/41#stream-type))
                (error 'stream-filter '"non-stream argument")
                (_stream-filter52173_ _strm52171_))))))
  (define std/srfi/41#stream-fold
    (lambda (_proc52161_ _base52162_ _strm52163_)
      (if (not (procedure? _proc52161_))
          (error 'stream-fold '"non-procedural argument")
          (if (not (##structure-instance-of?
                    _strm52163_
                    'std/srfi/41#stream-type))
              (error 'stream-fold '"non-stream argument")
              (let _loop52165_ ((_base52167_ _base52162_)
                                (_strm52168_ _strm52163_))
                (if (std/srfi/41#stream-null? _strm52168_)
                    _base52167_
                    (_loop52165_
                     (_proc52161_
                      _base52167_
                      (std/srfi/41#stream-car _strm52168_))
                     (std/srfi/41#stream-cdr _strm52168_))))))))
  (define std/srfi/41#stream-for-each
    (lambda (_proc52152_ . _strms52153_)
      (letrec ((_stream-for-each52155_
                (lambda (_strms52159_)
                  (if (not (std/srfi/41#exists
                            std/srfi/41#stream-null?
                            _strms52159_))
                      (begin
                        (apply _proc52152_
                               (map std/srfi/41#stream-car _strms52159_))
                        (_stream-for-each52155_
                         (map std/srfi/41#stream-cdr _strms52159_)))
                      '#!void))))
        (if (not (procedure? _proc52152_))
            (error 'stream-for-each '"non-procedural argument")
            (if (null? _strms52153_)
                (error 'stream-for-each '"no stream arguments")
                (if (std/srfi/41#exists
                     (lambda (_x52157_)
                       (not (##structure-instance-of?
                             _x52157_
                             'std/srfi/41#stream-type)))
                     _strms52153_)
                    (error 'stream-for-each '"non-stream argument")
                    (_stream-for-each52155_ _strms52153_)))))))
  (define std/srfi/41#stream-from
    (lambda (_first52138_ . _step52139_)
      (letrec ((_stream-from52141_
                (lambda (_first52145_ _delta52146_)
                  (##structure
                   std/srfi/41#stream-type
                   (cons 'lazy
                         (lambda ()
                           (let ()
                             (std/srfi/41#stream-eager
                              (##structure
                               std/srfi/41#stream-pare-type
                               (##structure
                                std/srfi/41#stream-type
                                (cons 'lazy
                                      (lambda ()
                                        (std/srfi/41#stream-eager
                                         _first52145_))))
                               (##structure
                                std/srfi/41#stream-type
                                (cons 'lazy
                                      (lambda ()
                                        (_stream-from52141_
                                         (+ _first52145_ _delta52146_)
                                         _delta52146_)))))))))))))
        (let ((_delta52143_ (if (null? _step52139_) '1 (car _step52139_))))
          (if (not (number? _first52138_))
              (error 'stream-from '"non-numeric starting number")
              (if (not (number? _delta52143_))
                  (error 'stream-from '"non-numeric step size")
                  (_stream-from52141_ _first52138_ _delta52143_)))))))
  (define std/srfi/41#stream-iterate
    (lambda (_proc52127_ _base52128_)
      (letrec ((_stream-iterate52130_
                (lambda (_base52132_)
                  (##structure
                   std/srfi/41#stream-type
                   (cons 'lazy
                         (lambda ()
                           (let ()
                             (std/srfi/41#stream-eager
                              (##structure
                               std/srfi/41#stream-pare-type
                               (##structure
                                std/srfi/41#stream-type
                                (cons 'lazy
                                      (lambda ()
                                        (std/srfi/41#stream-eager
                                         _base52132_))))
                               (##structure
                                std/srfi/41#stream-type
                                (cons 'lazy
                                      (lambda ()
                                        (_stream-iterate52130_
                                         (_proc52127_ _base52132_))))))))))))))
        (if (not (procedure? _proc52127_))
            (error 'stream-iterate '"non-procedural argument")
            (_stream-iterate52130_ _base52128_)))))
  (define std/srfi/41#stream-length
    (lambda (_strm52120_)
      (if (not (##structure-instance-of? _strm52120_ 'std/srfi/41#stream-type))
          (error 'stream-length '"non-stream argument")
          (let _loop52122_ ((_len52124_ '0) (_strm52125_ _strm52120_))
            (if (std/srfi/41#stream-null? _strm52125_)
                _len52124_
                (_loop52122_
                 (+ _len52124_ '1)
                 (std/srfi/41#stream-cdr _strm52125_)))))))
  (define std/srfi/41#stream-map
    (lambda (_proc52107_ . _strms52108_)
      (letrec ((_stream-map52110_
                (lambda (_strms52114_)
                  (##structure
                   std/srfi/41#stream-type
                   (cons 'lazy
                         (lambda ()
                           (let ()
                             (if (std/srfi/41#exists
                                  std/srfi/41#stream-null?
                                  _strms52114_)
                                 std/srfi/41#stream-null
                                 (std/srfi/41#stream-eager
                                  (##structure
                                   std/srfi/41#stream-pare-type
                                   (##structure
                                    std/srfi/41#stream-type
                                    (cons 'lazy
                                          (lambda ()
                                            (std/srfi/41#stream-eager
                                             (apply _proc52107_
                                                    (map std/srfi/41#stream-car
                                                         _strms52114_))))))
                                   (##structure
                                    std/srfi/41#stream-type
                                    (cons 'lazy
                                          (lambda ()
                                            (_stream-map52110_
                                             (map std/srfi/41#stream-cdr
                                                  _strms52114_)))))))))))))))
        (if (not (procedure? _proc52107_))
            (error 'stream-map '"non-procedural argument")
            (if (null? _strms52108_)
                (error 'stream-map '"no stream arguments")
                (if (std/srfi/41#exists
                     (lambda (_x52112_)
                       (not (##structure-instance-of?
                             _x52112_
                             'std/srfi/41#stream-type)))
                     _strms52108_)
                    (error 'stream-map '"non-stream argument")
                    (_stream-map52110_ _strms52108_)))))))
  (define std/srfi/41#stream-range
    (lambda (_first52088_ _past52089_ . _step52090_)
      (letrec ((_stream-range52092_
                (lambda (_first52098_ _past52099_ _delta52100_ _lt?52101_)
                  (##structure
                   std/srfi/41#stream-type
                   (cons 'lazy
                         (lambda ()
                           (let ()
                             (if (_lt?52101_ _first52098_ _past52099_)
                                 (std/srfi/41#stream-eager
                                  (##structure
                                   std/srfi/41#stream-pare-type
                                   (##structure
                                    std/srfi/41#stream-type
                                    (cons 'lazy
                                          (lambda ()
                                            (std/srfi/41#stream-eager
                                             _first52098_))))
                                   (##structure
                                    std/srfi/41#stream-type
                                    (cons 'lazy
                                          (lambda ()
                                            (_stream-range52092_
                                             (+ _first52098_ _delta52100_)
                                             _past52099_
                                             _delta52100_
                                             _lt?52101_))))))
                                 std/srfi/41#stream-null))))))))
        (if (not (number? _first52088_))
            (error 'stream-range '"non-numeric starting number")
            (if (not (number? _past52089_))
                (error 'stream-range '"non-numeric ending number")
                (let ((_delta52094_
                       (if (pair? _step52090_)
                           (car _step52090_)
                           (if (< _first52088_ _past52089_) '1 '-1))))
                  (if (not (number? _delta52094_))
                      (error 'stream-range '"non-numeric step size")
                      (let ((_lt?52096_ (if (< '0 _delta52094_) < >)))
                        (_stream-range52092_
                         _first52088_
                         _past52089_
                         _delta52094_
                         _lt?52096_)))))))))
  (define std/srfi/41#stream-ref
    (lambda (_strm52080_ _n52081_)
      (if (not (##structure-instance-of? _strm52080_ 'std/srfi/41#stream-type))
          (error 'stream-ref '"non-stream argument")
          (if (not (integer? _n52081_))
              (error 'stream-ref '"non-integer argument")
              (if (negative? _n52081_)
                  (error 'stream-ref '"negative argument")
                  (let _loop52083_ ((_strm52085_ _strm52080_)
                                    (_n52086_ _n52081_))
                    (if (std/srfi/41#stream-null? _strm52085_)
                        (error 'stream-ref '"beyond end of stream")
                        (if (zero? _n52086_)
                            (std/srfi/41#stream-car _strm52085_)
                            (_loop52083_
                             (std/srfi/41#stream-cdr _strm52085_)
                             (- _n52086_ '1))))))))))
  (define std/srfi/41#stream-reverse
    (lambda (_strm52069_)
      (letrec ((_stream-reverse52071_
                (lambda (_strm52073_ _rev52074_)
                  (##structure
                   std/srfi/41#stream-type
                   (cons 'lazy
                         (lambda ()
                           (let ()
                             (if (std/srfi/41#stream-null? _strm52073_)
                                 _rev52074_
                                 (_stream-reverse52071_
                                  (std/srfi/41#stream-cdr _strm52073_)
                                  (std/srfi/41#stream-eager
                                   (##structure
                                    std/srfi/41#stream-pare-type
                                    (##structure
                                     std/srfi/41#stream-type
                                     (cons 'lazy
                                           (lambda ()
                                             (std/srfi/41#stream-eager
                                              (std/srfi/41#stream-car
                                               _strm52073_)))))
                                    (##structure
                                     std/srfi/41#stream-type
                                     (cons 'lazy
                                           (lambda () _rev52074_))))))))))))))
        (if (not (##structure-instance-of?
                  _strm52069_
                  'std/srfi/41#stream-type))
            (error 'stream-reverse '"non-stream argument")
            (_stream-reverse52071_ _strm52069_ std/srfi/41#stream-null)))))
  (define std/srfi/41#stream-scan
    (lambda (_proc52054_ _base52055_ _strm52056_)
      (letrec ((_stream-scan52058_
                (lambda (_base52060_ _strm52061_)
                  (##structure
                   std/srfi/41#stream-type
                   (cons 'lazy
                         (lambda ()
                           (let ()
                             (if (std/srfi/41#stream-null? _strm52061_)
                                 (std/srfi/41#stream-eager
                                  (##structure
                                   std/srfi/41#stream-pare-type
                                   (##structure
                                    std/srfi/41#stream-type
                                    (cons 'lazy
                                          (lambda ()
                                            (std/srfi/41#stream-eager
                                             _base52060_))))
                                   (##structure
                                    std/srfi/41#stream-type
                                    (cons 'lazy
                                          (lambda ()
                                            std/srfi/41#stream-null)))))
                                 (std/srfi/41#stream-eager
                                  (##structure
                                   std/srfi/41#stream-pare-type
                                   (##structure
                                    std/srfi/41#stream-type
                                    (cons 'lazy
                                          (lambda ()
                                            (std/srfi/41#stream-eager
                                             _base52060_))))
                                   (##structure
                                    std/srfi/41#stream-type
                                    (cons 'lazy
                                          (lambda ()
                                            (_stream-scan52058_
                                             (_proc52054_
                                              _base52060_
                                              (std/srfi/41#stream-car
                                               _strm52061_))
                                             (std/srfi/41#stream-cdr
                                              _strm52061_)))))))))))))))
        (if (not (procedure? _proc52054_))
            (error 'stream-scan '"non-procedural argument")
            (if (not (##structure-instance-of?
                      _strm52056_
                      'std/srfi/41#stream-type))
                (error 'stream-scan '"non-stream argument")
                (_stream-scan52058_ _base52055_ _strm52056_))))))
  (define std/srfi/41#stream-take
    (lambda (_n52039_ _strm52040_)
      (letrec ((_stream-take52042_
                (lambda (_n52044_ _strm52045_)
                  (##structure
                   std/srfi/41#stream-type
                   (cons 'lazy
                         (lambda ()
                           (let ()
                             (if (or (std/srfi/41#stream-null? _strm52045_)
                                     (zero? _n52044_))
                                 std/srfi/41#stream-null
                                 (std/srfi/41#stream-eager
                                  (##structure
                                   std/srfi/41#stream-pare-type
                                   (##structure
                                    std/srfi/41#stream-type
                                    (cons 'lazy
                                          (lambda ()
                                            (std/srfi/41#stream-eager
                                             (std/srfi/41#stream-car
                                              _strm52045_)))))
                                   (##structure
                                    std/srfi/41#stream-type
                                    (cons 'lazy
                                          (lambda ()
                                            (_stream-take52042_
                                             (- _n52044_ '1)
                                             (std/srfi/41#stream-cdr
                                              _strm52045_)))))))))))))))
        (if (not (##structure-instance-of?
                  _strm52040_
                  'std/srfi/41#stream-type))
            (error 'stream-take '"non-stream argument")
            (if (not (integer? _n52039_))
                (error 'stream-take '"non-integer argument")
                (if (negative? _n52039_)
                    (error 'stream-take '"negative argument")
                    (_stream-take52042_ _n52039_ _strm52040_)))))))
  (define std/srfi/41#stream-take-while
    (lambda (_pred?52028_ _strm52029_)
      (letrec ((_stream-take-while52031_
                (lambda (_strm52033_)
                  (##structure
                   std/srfi/41#stream-type
                   (cons 'lazy
                         (lambda ()
                           (let ()
                             (if (std/srfi/41#stream-null? _strm52033_)
                                 std/srfi/41#stream-null
                                 (if (_pred?52028_
                                      (std/srfi/41#stream-car _strm52033_))
                                     (std/srfi/41#stream-eager
                                      (##structure
                                       std/srfi/41#stream-pare-type
                                       (##structure
                                        std/srfi/41#stream-type
                                        (cons 'lazy
                                              (lambda ()
                                                (std/srfi/41#stream-eager
                                                 (std/srfi/41#stream-car
                                                  _strm52033_)))))
                                       (##structure
                                        std/srfi/41#stream-type
                                        (cons 'lazy
                                              (lambda ()
                                                (_stream-take-while52031_
                                                 (std/srfi/41#stream-cdr
                                                  _strm52033_)))))))
                                     std/srfi/41#stream-null)))))))))
        (if (not (##structure-instance-of?
                  _strm52029_
                  'std/srfi/41#stream-type))
            (error 'stream-take-while '"non-stream argument")
            (if (not (procedure? _pred?52028_))
                (error 'stream-take-while '"non-procedural argument")
                (_stream-take-while52031_ _strm52029_))))))
  (define std/srfi/41#stream-unfold
    (lambda (_mapper52015_ _pred?52016_ _generator52017_ _base52018_)
      (letrec ((_stream-unfold52020_
                (lambda (_base52022_)
                  (##structure
                   std/srfi/41#stream-type
                   (cons 'lazy
                         (lambda ()
                           (let ()
                             (if (_pred?52016_ _base52022_)
                                 (std/srfi/41#stream-eager
                                  (##structure
                                   std/srfi/41#stream-pare-type
                                   (##structure
                                    std/srfi/41#stream-type
                                    (cons 'lazy
                                          (lambda ()
                                            (std/srfi/41#stream-eager
                                             (_mapper52015_ _base52022_)))))
                                   (##structure
                                    std/srfi/41#stream-type
                                    (cons 'lazy
                                          (lambda ()
                                            (_stream-unfold52020_
                                             (_generator52017_
                                              _base52022_)))))))
                                 std/srfi/41#stream-null))))))))
        (if (not (procedure? _mapper52015_))
            (error 'stream-unfold '"non-procedural mapper")
            (if (not (procedure? _pred?52016_))
                (error 'stream-unfold '"non-procedural pred?")
                (if (not (procedure? _generator52017_))
                    (error 'stream-unfold '"non-procedural generator")
                    (_stream-unfold52020_ _base52018_)))))))
  (define std/srfi/41#stream-unfolds
    (lambda (_gen51974_ _seed51975_)
      (letrec ((_len-values51977_
                (lambda (_gen52009_ _seed52010_)
                  (call-with-values
                   (lambda () (_gen52009_ _seed52010_))
                   (lambda _vs52013_ (- (length _vs52013_) '1)))))
               (_unfold-result-stream51978_
                (lambda (_gen51998_ _seed51999_)
                  (##structure
                   std/srfi/41#stream-type
                   (cons 'lazy
                         (lambda ()
                           (let ()
                             (call-with-values
                              (lambda () (_gen51998_ _seed51999_))
                              (lambda (_next52004_ . _results52005_)
                                (std/srfi/41#stream-eager
                                 (##structure
                                  std/srfi/41#stream-pare-type
                                  (##structure
                                   std/srfi/41#stream-type
                                   (cons 'lazy
                                         (lambda ()
                                           (std/srfi/41#stream-eager
                                            _results52005_))))
                                  (##structure
                                   std/srfi/41#stream-type
                                   (cons 'lazy
                                         (lambda ()
                                           (_unfold-result-stream51978_
                                            _gen51998_
                                            _next52004_))))))))))))))
               (_result-stream->output-stream51979_
                (lambda (_result-stream51989_ _i51990_)
                  (##structure
                   std/srfi/41#stream-type
                   (cons 'lazy
                         (lambda ()
                           (let ()
                             (let ((_result51994_
                                    (list-ref
                                     (std/srfi/41#stream-car
                                      _result-stream51989_)
                                     (- _i51990_ '1))))
                               (if (pair? _result51994_)
                                   (std/srfi/41#stream-eager
                                    (##structure
                                     std/srfi/41#stream-pare-type
                                     (##structure
                                      std/srfi/41#stream-type
                                      (cons 'lazy
                                            (lambda ()
                                              (std/srfi/41#stream-eager
                                               (car _result51994_)))))
                                     (##structure
                                      std/srfi/41#stream-type
                                      (cons 'lazy
                                            (lambda ()
                                              (_result-stream->output-stream51979_
                                               (std/srfi/41#stream-cdr
                                                _result-stream51989_)
                                               _i51990_))))))
                                   (if (not _result51994_)
                                       (_result-stream->output-stream51979_
                                        (std/srfi/41#stream-cdr
                                         _result-stream51989_)
                                        _i51990_)
                                       (if (null? _result51994_)
                                           std/srfi/41#stream-null
                                           (error 'stream-unfolds
                                                  '"can't happen")))))))))))
               (_result-stream->output-streams51980_
                (lambda (_result-stream51982_)
                  (let _loop51984_ ((_i51986_
                                     (_len-values51977_
                                      _gen51974_
                                      _seed51975_))
                                    (_outputs51987_ '()))
                    (if (zero? _i51986_)
                        (apply values _outputs51987_)
                        (_loop51984_
                         (- _i51986_ '1)
                         (cons (_result-stream->output-stream51979_
                                _result-stream51982_
                                _i51986_)
                               _outputs51987_)))))))
        (if (not (procedure? _gen51974_))
            (error 'stream-unfolds '"non-procedural argument")
            (_result-stream->output-streams51980_
             (_unfold-result-stream51978_ _gen51974_ _seed51975_))))))
  (define std/srfi/41#stream-zip
    (lambda _strms51962_
      (letrec ((_stream-zip51964_
                (lambda (_strms51968_)
                  (##structure
                   std/srfi/41#stream-type
                   (cons 'lazy
                         (lambda ()
                           (let ()
                             (if (std/srfi/41#exists
                                  std/srfi/41#stream-null?
                                  _strms51968_)
                                 std/srfi/41#stream-null
                                 (std/srfi/41#stream-eager
                                  (##structure
                                   std/srfi/41#stream-pare-type
                                   (##structure
                                    std/srfi/41#stream-type
                                    (cons 'lazy
                                          (lambda ()
                                            (std/srfi/41#stream-eager
                                             (map std/srfi/41#stream-car
                                                  _strms51968_)))))
                                   (##structure
                                    std/srfi/41#stream-type
                                    (cons 'lazy
                                          (lambda ()
                                            (_stream-zip51964_
                                             (map std/srfi/41#stream-cdr
                                                  _strms51968_)))))))))))))))
        (if (null? _strms51962_)
            (error 'stream-zip '"no stream arguments")
            (if (std/srfi/41#exists
                 (lambda (_x51966_)
                   (not (##structure-instance-of?
                         _x51966_
                         'std/srfi/41#stream-type)))
                 _strms51962_)
                (error 'stream-zip '"non-stream argument")
                (_stream-zip51964_ _strms51962_)))))))
