<-- This file is part 24 of the GNU version of
    The Collaborative International Dictionary of English (GCIDE)

    Copyright (C) 1992-2012 Patrick J. Cassidy

    GCIDE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3, or (at your option)
    any later version.

    GCIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this copy of GCIDE.  If not, see <http://www.gnu.org/licenses/>.
-->

<p><centered><point26>X.</point26></centered></p>

<p><ent>X</ent><br/
<hw>X</hw> <pr>(<ecr/ks)</pr>. <def>X, the twenty-fourth letter of the English alphabet, has three sounds; a compound nonvocal sound (that of <xex>ks</xex>), as in <xex>wax</xex>; a compound vocal sound (that of <xex>gz</xex>), as in <xex>example</xex>; and, at the beginning of a word, a simple vocal sound (that of <it>z</it>), as in <xex>xanthic</xex>.  See <xex>Guide to Pronunciation</xex>, <sect/<sect/ 217, 270, 271.</def><br/
[<source>1913 Webster</source>]</p>

<p><note> The form and value of X are from the Latin X, which is from the Greek <CHI/, which in some Greek alphabets had the value of <xex>ks</xex>, though in the one now in common use it represents an aspirated sound of <xex>k</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthamide</ent><br/
<hw>Xanth*am"ide</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Xanth</ets>ic + <ets>amide</ets>.]</ety> <fld>(Chem.)</fld> <def>An amido derivative of xanthic acid obtained as a white crystalline substance, <chform>C2H5O.CS.NH2</chform>; -- called also <altname>xanthogen amide</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthate</ent><br/
<hw>Xan"thate</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Xanthic</er>.]</ety> <fld>(Chem.)</fld> <def>A salt of xanthic; a xanthogenate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthelasma</ent><br/
\'d8<hw>Xan`the*las"ma</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL.; Gr. <grk>xanqo`s</grk> yellow + <grk>'e`lasma</grk> a metal plate.]</ety> <fld>(Med.)</fld> <def>See <er>Xanthoma</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthian</ent><br/
<hw>Xan"thi*an</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to <etsep>Xanthus</etsep>, an ancient town on Asia Minor; -- applied especially to certain marbles found near that place, and now in the British Museum.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthic</ent><br/
<hw>Xan"thic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <grk>xanqo`s</grk> yellow: cf. F. <ets>xanthique</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Tending toward a yellow color, or to one of those colors, green being excepted, in which yellow is a constituent, as scarlet, orange, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Chem.)</fld> <sd>(a)</sd> <def>Possessing, imparting, or producing a yellow color; <as>as, <ex>xanthic</ex> acid</as>.</def>  <sd>(b)</sd> <def>Of or pertaining to xanthic acid, or its compounds; xanthogenic.</def>  <sd>(c)</sd> <def>Of or pertaining to xanthin.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Xanthic acid</b></col> <fld>(Chem.)</fld>, <cd>a heavy, astringent, colorless oil, <chform>C2H5O.CS.SH</chform>, having a pungent odor. It is produced by leading carbon disulphide into a hot alcoholic solution of potassium hydroxide. So called from the yellow color of many of its salts. Called also <altname>xanthogenic acid</altname>.</cd> -- <col><b>Xanthic colors</b></col> <fld>(Bot.)</fld>, <cd>those colors (of flowers) having some tinge of yellow; -- opposed to <contr>cyanic colors</contr>.  See under <er>Cyanic</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthide</ent><br/
<hw>Xan"thide</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Xantho-</er>.]</ety> <fld>(Chem.)</fld> <def>A compound or derivative of xanthogen.</def>  <mark>[Archaic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthidium</ent><br/
\'d8<hw>Xan*thid"i*um</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Xanthidia</plw> <pr>(?)</pr>.</plu> <ety>[NL., fr. Gr. <grk>xanqo`s</grk> yellow.]</ety> <fld>(Bot.)</fld> <def>A genus of minute unicellular algae of the desmids. These algae have a rounded shape and are armed with glochidiate or branched aculei. Several species occur in ditches, and others are found fossil in flint or hornstone.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthin</ent><br/
<hw>Xan"thin</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>xanqo`s</grk> yellow.]</ety> <sn>1.</sn> <def>same as <er>xanthine</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Chem.)</fld> <def>A yellow insoluble coloring matter extracted from yellow flowers; specifically, the coloring matter of madder.</def>  <altsp>[Formerly written also <asp>xanthein</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Chem.)</fld> <def>One of the gaseous or volatile decomposition products of the xanthates, and probably identical with carbon disulphide.</def>  <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthin</ent><br/
<ent>Xanthine</ent><br/
<mhw>{ <hw>Xan"thine</hw> <pr>(?)</pr>, <pos>n.</pos> Also <hw>Xan"thin</hw>  }</mhw>. <ety>[Gr. <grk>xanqo`s</grk> yellow.]</ety> <fld>(Physiol. Chem.)</fld> <def>A type of purine obtainable as a white microcrystalline powder, <chform>C5H4O2N4</chform>, present in muscle tissue, in the liver, spleen, pancreas, and other organs, and also in urine (in small quantities) and some urinary calculi, and in the juices of certain plants; -- so called because it leaves a yellow residue when evaporated to dryness with nitric acid. It is also present in guano.  Xanthine is closely related to uric acid.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Xanthinine</ent><br/
<hw>Xan"thi*nine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>xanqo`s</grk> yellow + qu<ets>inine</ets>.]</ety> <fld>(Chem.)</fld> <def>A complex nitrogenous substance related to urea and uric acid, produced as a white powder; -- so called because it forms yellow salts, and because its solution forms a blue fluorescence like quinine.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthium</ent><br/
\'d8<hw>Xan"thi*um</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>xa`nqion</grk> a plant used for dyeing the hair yellow, said to be the <spn>Xanthium strumarium</spn>, from <grk>xanqo`s</grk> yellow.]</ety> <fld>(Bot.)</fld> <def>A genus of composite plants in which the scales of the involucre are united so as to form a kind of bur; cocklebur; clotbur.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xantho-</ent><br/
<hw>Xan"tho-</hw> <pr>(?)</pr>. <def>A combining form from Gr. <grk>xanqo`s</grk> yellow; as in <ex>xantho</ex>cobaltic salts. Used also adjectively in chemistry.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthocarpous</ent><br/
<hw>Xan`tho*car"pous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Xantho-</ets> + Gr. <grk>karpo`s</grk> fruit.]</ety> <fld>(Bot.)</fld> <def>Having yellow fruit.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthochroi</ent><br/
\'d8<hw>Xan*thoch"ro*i</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL.  See <er>Xanthochroic</er>.]</ety> <fld>(Ethnol.)</fld> <def>A division of the Caucasian races, comprising the lighter-colored members.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>Xanthochroi</qex>, or fair whites, . . . are the prevalent inhabitants of Northern Europe, and the type may be traced into North Africa, and eastward as far as Hindostan.</q> <rj><qau>Tylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthochroic</ent><br/
<hw>Xan`tho*chro"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Xantho-</ets> + Gr. <grk>chro`a</grk> color.]</ety> <fld>(Ethnol.)</fld> <def>Having a yellowish or fair complexion; of or pertaining to the Xanthochroi.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthochroid</ent><br/
<hw>Xan"tho*chroid</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See under <er>Xanthrochroic</er>, <er>-oid</er>.]</ety> <fld>(Ethnol.)</fld> <def>Having a yellowish or fair complexion.</def> -- <def2><pos>n.</pos>  <def>A person having xanthochroid traits.</def></def2><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Xanthochroism</ent><br/
<hw>Xan*thoch"ro*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Abnormal coloration of feathers in which yellow replaces the normal color, as in certain parrots. It is commonly due to lack of the dark pigment which with yellow forms green.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Xanthodontous</ent><br/
<hw>Xan`tho*don"tous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Xantho-</ets> + Gr. <grk>'odoy`s</grk>, <grk>'odo`ntos</grk>, tooth.]</ety> <def>Having yellow teeth.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthogen</ent><br/
<hw>Xan"tho*gen</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Xantho-</ets> + <ets>-gen</ets>.]</ety> <fld>(Chem.)</fld> <sd>(a)</sd> <def>The hypothetical radical supposed to be characteristic of xanthic acid.</def> <mark>[Archaic]</mark> <sd>(b)</sd> <def>Persulphocyanogen.</def>  <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthogenate</ent><br/
<hw>Xan"tho*gen*ate</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A salt of xanthic acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthogenic</ent><br/
<hw>Xan`tho*gen"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Xantho-</er>, and <er>-gen</er>.]</ety> <fld>(Chem.)</fld> <def>Producing a yellow color or compound; xanthic.  See <cref>Xanthic acid</cref>, under <er>Xanthic</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthoma</ent><br/
\'d8<hw>Xan*tho"ma</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL.  See <er>Xantho-</er>, and <er>-oma</er>.]</ety> <fld>(Med.)</fld> <def>A skin disease marked by the development or irregular yellowish patches upon the skin, especially upon the eyelids; -- called also <altname>xanthelasma</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthomatous</ent><br/
<hw>Xan*thom"a*tous</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Med.)</fld> <def>Of or pertaining to xanthoma.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Xanthomelanous</ent><br/
<hw>Xan`tho*mel"a*nous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Pref. <ets>xantho-</ets> + Gr. <?/, <?/, black.]</ety> <fld>(Ethnol.)</fld> <def>Of or pertaining to the lighter division of the Melanochroi, or those races having an olive or yellow complexion and black hair.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Xanthophane</ent><br/
<hw>Xan"tho*phane</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Xantho-</ets> + Gr. <grk>fai`nein</grk> to show.]</ety> <fld>(Physiol.)</fld> <def>The yellow pigment present in the inner segments of the retina in animals.  See <er>Chromophane</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthophyll</ent><br/
<hw>Xan"tho*phyll</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Xantho-</ets> + Gr. <grk>fy`llon</grk> leaf.]</ety> <fld>(Bot.)</fld> <def>A yellow coloring matter found in yellow autumn leaves, and also produced artificially from chlorophyll; -- formerly called also <altname>phylloxanthin</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthopous</ent><br/
<hw>Xan"tho*pous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Xantho-</ets> + Gr. <grk>poy`s</grk>, <grk>podo`s</grk>, foot.]</ety> <fld>(Bot.)</fld> <def>Having a yellow stipe, or stem.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthoproteic</ent><br/
<hw>Xan`tho*pro*te"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Physiol. Chem.)</fld> <def>Pertaining to, or derived from, xanthoprotein; showing the characters of xanthoprotein; <as>as, <ex>xanthoproteic</ex> acid; the <ex>xanthoproteic</ex> reaction for albumin.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthoprotein</ent><br/
<hw>Xan`tho*pro"te*in</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Xantho-</ets> + <ets>protein</ets>.]</ety> <fld>(Physiol. Chem.)</fld> <def>A yellow acid substance formed by the action of hot nitric acid on albuminous or proteid matter. It is changed to a deep orange-yellow color by the addition of ammonia.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthopuccine</ent><br/
<hw>Xan`tho*puc"cine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Xantho-</ets> + <ets>pucc</ets>oon + <ets>-ine</ets>.]</ety> <fld>(Chem.)</fld> <def>One of three alkaloids found in the root of the yellow puccoon (<spn>Hydrastis Canadensis</spn>). It is a yellow crystalline substance, and resembles berberine.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthorhamnin</ent><br/
<hw>Xan`tho*rham"nin</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Xantho-</ets> + NL. <ets>Rhamnus</ets>, the generic name of the plant bearing Persian berries.]</ety> <fld>(Chem.)</fld> <def>A glucoside extracted from Persian berries as a yellow crystalline powder, used as a dyestuff.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthorhiza</ent><br/
<hw>Xan`tho*rhi"za</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>xanqo`s</grk> yellow + <grk>"ri`za</grk> root.]</ety> <fld>(Bot.)</fld> <def>A genus of shrubby ranunculaceous plants of North America, including only the species <spn>Xanthorhiza apiifolia</spn>, which has roots of a deep yellow color; yellowroot. The bark is intensely bitter, and is sometimes used as a tonic.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1671 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthorhoea</ent><br/
\'d8<hw>Xan`tho*rhoe"a</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., from Gr. <grk>xanqo`s</grk> yellow + <grk>"rei^n</grk> to flow.]</ety> <fld>(Bot.)</fld> <def>A genus of endogenous plants, native to Australia, having a thick, sometimes arborescent, stem, and long grasslike leaves.  See <er>Grass tree</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthose</ent><br/
<hw>Xan"those</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>An orange-yellow substance found in pigment spots of certain crabs.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthosis</ent><br/
\'d8<hw>Xan*tho"sis</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>xanqo`s</grk> yellow.]</ety> <fld>(Med.)</fld> <def>The yellow discoloration often observed in cancerous tumors.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthospermous</ent><br/
<hw>Xan`tho*sper"mous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Xantho-</ets> + Gr. <grk>spe`rma</grk> sperm.]</ety> <fld>(Bot.)</fld> <def>Having yellow seeds.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthous</ent><br/
<hw>Xan"thous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <grk>xanqo`s</grk> yellow.]</ety> <def>Yellow; specifically <fld>(Ethnol.)</fld>, of or pertaining to those races of man which have yellowish, red, auburn, or brown hair.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthoxylene</ent><br/
<hw>Xan*thox"y*lene</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Xanthoxylum</er>.]</ety> <fld>(Chem.)</fld> <def>A liquid hydrocarbon of the terpene series extracted from the seeds of a Japanese prickly ash (<spn>Xanthoxylum pipertium</spn>) as an aromatic oil.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xanthoxylum</ent><br/
\'d8<hw>Xan*thox"y*lum</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., from Gr. <grk>xanqo`s</grk> yellow + <grk>xy`lon</grk> wood.]</ety> <fld>(Bot.)</fld> <def>A genus of prickly shrubs or small trees, the bark and rots of which are of a deep yellow color; prickly ash.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The commonest species in the Northern United States is <spn>Xanthoxylum Americanum</spn>.  See <cref>Prickly ash</cref>, under <er>Prickly</er>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xe</ent><br/
<hw>Xe</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The chemical symbol for the chemical element <er>xenon</er>, having atomic number 54; it is one of the six noble gases.</def><br/
<syn><b>Syn. --</b> xenon.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Xebec</ent><br/
<hw>Xe"bec</hw> <pr>(z<emac/"b<ecr/k)</pr>, <pos>n.</pos> <ety>[Sp. <ets>jabegue</ets>, formerly spelt <ets>xabeque</ets>, or Pg. <ets>xabeco</ets>; both from Turk. <ets>sumbeki</ets> a kind of Asiatic ship; cf. Per. <ets>sumbuk</ets>, Ar. <ets>sumb<umac/k</ets> a small ship.]</ety> <fld>(Naut.)</fld> <def>A small three-masted vessel, with projecting bow and stern and convex decks, used in the Mediterranean for transporting merchandise, etc.  It carries large square sails, or lateen sails, or both.  Xebecs were formerly armed and used by corsairs.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xeme</ent><br/
<hw>Xeme</hw> <pr>(z<emac/m)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>An Arctic fork-tailed gull (<spn>Xema Sabinii</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xenarthra</ent><br/
<hw>Xen*ar"thra</hw> <pos>prop. n.</pos>  <def>The suborder of mammals including the armadillos, American anteaters, and sloths.</def><br/
<syn><b>Syn. --</b> suborder <ord>Xenarthra</ord>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Xenelasia</ent><br/
\'d8<hw>Xen`e*la"si*a</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., from Gr. <grk>xenhlasi`a</grk> expulsion of strangers.]</ety> <fld>(Gr. Antiq.)</fld> <def>A Spartan institution which prohibited strangers from residing in Sparta without permission, its object probably being to preserve the national simplicity of manners.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xenicidae</ent><br/
<hw>Xe*ni"ci*dae</hw> <pr>(?)</pr>, <pos>pr. n.</pos>  <def>A natural family of birds comprising the New Zealand wrens, synonymous with <fam>Acanthisittidae</fam>.</def><br/
<syn><b>Syn. --</b> family Xenicidae, Acanthisittidae, family Acanthisittidae.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Xenicus</ent><br/
<hw>Xe"ni*cus</hw> <pr>(?)</pr>, <pos>pr. n.</pos> <def>The type genus for the bird family <fam>Xenicidae</fam>.</def><br/
<syn><b>Syn. --</b> genus <gen>Xenicus</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Xenium</ent><br/
\'d8<hw>Xe"ni*um</hw> <pr>(z<emac/"n<icr/*<ucr/m)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Xenia</plw> <pr>(z<emac/"n<icr/*<adot/)</pr>.</plu> <ety>[L., from Gr. <grk>xe`nion</grk> gift to a guest, fr. <grk>xe`nos</grk> guest.]</ety> <fld>(Class. Antiq.)</fld> <def>A present given to a guest or stranger, or to a foreign ambassador.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xenodochium</ent><br/
\'d8<hw>Xen`o*do*chi"um</hw> <pr>(z<ecr/n`<osl/*d<osl/*k<imac/"<ucr/m)</pr>, <pos>n.</pos> <ety>[LL., fr. L. <ets>xenodochium</ets> a building for the reception of strangers, Gr. <grk>xenodochei^on</grk> .]</ety> <sd>(a)</sd> <fld>(Class. Antiq.)</fld> <def>A house for the reception of strangers.</def>  <sd>(b)</sd> <def>In the Middle Ages, a room in a monastery for the reception and entertainment of strangers and pilgrims, and for the relief of paupers. [Called also <altname>Xenodocheion</altname>.]</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xenodochy</ent><br/
<hw>Xe*nod"o*chy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>xenodochi`a</grk>.]</ety> <def>Reception of strangers; hospitality.</def>  <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xenon</ent><br/
<hw>Xen"on</hw> <pr>(z<ecr/n"<ocr/n; z<emac/"n<ocr/n)</pr>, <pos>n.</pos> <ety>[Gr. <grk>xe`non</grk>, neut. of <grk>xe`nos</grk> strange.]</ety> <fld>(Chem.)</fld> <def>A very heavy, inert gaseous element of the noble gas group, occurring in the atmosphere in the proportion of one volume is about 20 millions.  It was discovered by <person>Ramsay</person> and <person>Travers</person> in 1898.  It can be condensed to a liquid boiling at -107<deg/ C., and to a solid which melts at -111.9<deg/ C.  Symbol <it>Xe</it> (formerly also <it>X</it>); atomic number 54; atomic weight 131.3.</def><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>Xenogamy</ent><br/
<hw>Xe*nog"a*my</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>xe`nos</grk> strange, foreign + <grk>ga`mos</grk> marriage.]</ety> <fld>(Bot.)</fld> <def>Cross fertilization.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xenogenesis</ent><br/
<hw>Xen`o*gen"e*sis</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>xe`nos</grk> a stranger + E. <ets>genesis</ets>.]</ety> <fld>(Biol.)</fld> <sd>(a)</sd> <def>Same as <er>Heterogenesis</er>.</def>  <sd>(b)</sd> <def>The fancied production of an organism of one kind by an organism of another.</def>  <rj><au>Huxley.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xenogenetic</ent><br/
<hw>Xen`o*ge*net"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Biol.)</fld> <def>Of or pertaining to xenogenesis; <as>as, the <ex>xenogenetic</ex> origin of microzymes</as>.</def>  <rj><au>Huxley.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xenomania</ent><br/
<hw>Xen`o*ma"ni*a</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>xe`nos</grk> strange + E. <ets>mania</ets>.]</ety> <def>A mania for, or an inordinate attachment to, foreign customs, institutions, manners, fashions, etc.</def>  <mark>[R.]</mark>  <rj><au>Saintsbury.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xenomi</ent><br/
\'d8<hw>Xen"o*mi</hw> <pr>(?)</pr>, <pos>prop. n. pl.</pos> <ety>[NL., from Gr. <grk>xe`nos</grk> strange.]</ety> <fld>(Zool.)</fld> <def>A suborder of soft-rayed fresh-water fishes of which the blackfish of Alaska (<spn>Dallia pectoralis</spn>) is the type.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xenopterygii</ent><br/
\'d8<hw>Xe*nop`te*ryg"i*i</hw> <pr>(?)</pr>, <pos>prop. n. pl.</pos> <ety>[NL., from Gr. <grk>xe`nos</grk> strange + <?/, dim. of <?/ a wing.]</ety> <fld>(Zool.)</fld> <def>A suborder of fishes including <gen>Gobiesox</gen> and allied genera. These fishes have soft-rayed fins, and a ventral sucker supported in front by the pectoral fins. They are destitute of scales.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xenotime</ent><br/
<hw>Xen"o*time</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>xeno`timos</grk> honoring guests or strangers; <grk>xe`nos</grk> guest, stranger + <grk>timh`</grk> honor: cf. G. <ets>xenotim</ets>.]</ety> <fld>(Min.)</fld> <def>A native phosphate of yttrium occurring in yellowish-brown tetragonal crystals.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xenurine</ent><br/
<hw>Xe*nu"rine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>xe`nos</grk> strange + <grk>o'yra`</grk> tail.]</ety> <fld>(Zool.)</fld> <def>A cabassou.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xenyl</ent><br/
<hw>Xen"yl</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>xe`nos</grk> strange + <ets>-yl</ets>.]</ety> <fld>(Chem.)</fld> <def>The radical characteristic of xenylic compounds.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xenylic</ent><br/
<hw>Xe*nyl"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Pertaining to, derived from, designating, certain amido compounds obtained by reducing certain nitro derivatives of diphenyl.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xeraphim</ent><br/
<hw>Xer"a*phim</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Pg. <ets>xarafin</ets>, <ets>xerafin</ets>, fr. Ar. <ets>ashraf<imac/</ets> noble, the name of a gold coin.]</ety> <def>An old money of account in Bombay, equal to three fifths of a rupee.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xeres</ent><br/
<hw>Xer"es</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Sherry.  See <er>Sherry</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xerif</ent><br/
<hw>Xer"if</hw> <pr>(z<ecr/r"<icr/f)</pr>, <pos>n.</pos> <def>A shereef.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xeriff</ent><br/
<hw>Xer"iff</hw> <pr>(z<ecr/r"<icr/f)</pr>, <pos>n.</pos> <ety>[See <er>Shereef</er>.]</ety> <def>A gold coin formerly current in Egypt and Turkey, of the value of about  9s. 6d., or about $2.30 (ca. 1900); -- also, in Morocco, a ducat.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xeroderma</ent><br/
\'d8<hw>Xe`ro*der"ma</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>xhro`s</grk> dry + <grk>de`rma</grk> skin.]</ety> <fld>(Med.)</fld> <sd>(a)</sd> <def>Ichthyosis.</def>  <sd>(b)</sd> <def>A skin disease characterized by the presence of numerous small pigmented spots resembling freckles, with which are subsequently mingled spots of atrophied skin.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xeronate</ent><br/
<hw>Xe"ro*nate</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A salt of xeronic acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xeronic</ent><br/
<hw>Xe*ron"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <grk>xhro`s</grk> dry + citra<ets>conic</ets>.]</ety> <fld>(Chem.)</fld> <def>Pertaining to, or designating, an acid, <chform>C8H12O4</chform>, related to fumaric acid, and obtained from citraconic acid as an oily substance having a bittersweet taste; -- so called from its tendency to form its anhydride.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xerophagy</ent><br/
<hw>Xe*roph"a*gy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>xerophagia</ets>, Gr. <?/; <grk>xhro`s</grk> dry + <?/ to eat.]</ety> <def>Among the primitive Christians, the living on a diet of dry food in Lent and on other fasts.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xerophilous</ent><br/
<hw>Xe*roph"i*lous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <grk>xhro`s</grk> dry + <?/ to love.]</ety> <fld>(Bot.)</fld> <def>Drought-loving; able withstand the absence or lack of moisture.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Plants which are peculiarly adapted to dry climates are termed by <person>De Candolle</person> <qex>xerophilous</qex>.</q> <rj><qau>Goodale.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xerophthalmia</ent><br/
\'d8<hw>Xe`roph*thal"mi*a</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., fr. Gr. <?/; <grk>xhro`s</grk> dry + <?/ the eye.  See <er>Ophthalmia</er>.]</ety> <fld>(Med.)</fld> <def>An abnormal dryness of the eyeball produced usually by long-continued inflammation and subsequent atrophy of the conjunctiva.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xerophthalmy</ent><br/
<hw>Xe`roph*thal"my</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Med.)</fld> <def>Xerophthalmia.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xerophyllum</ent><br/
<hw>Xe*ro"phyl*lum</hw> <pr>(?)</pr>, <pos>pr. n.</pos> <def>A small genus of North American herbs having grasslike basal leaves: squaw grass; sometimes placed in family <fam>Melanthiaceae</fam>.</def><br/
<syn><b>Syn. --</b> genus <gen>Xerophyllum</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>xerophyte</ent><br/
<hw>xe"ro*phyte</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A plant adapted for life with a limited supply of water; compare <contr>hydrophyte</contr> and <contr>mesophyte</contr>.</def><br/
<syn><b>Syn. --</b> desert plant, xerophytic plant, xerophile, xerophilous plant.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>xerophytic</ent><br/
<hw>xe`ro*phy"tic</hw> <pr>(?)</pr>, <pos>adj.</pos> <sn>1.</sn> <fld>(Botany)</fld> <ety>[Gr. <grk>xhro`s</grk> dry + <grk>fyto`n</grk> a plant.]</ety> <def>Adapted to a xeric (or dry) environment; <as>as, cacti are <ex>xerophytic</ex> plants; <ex>xerophytic</ex> adaptations</as>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Xerox</ent><br/
<hw>Xe"rox</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From a brand name of the Xerox corporation.]</ety>  <def>A copying machine which copies graphic matter by the action of light on an electrically charged photoconductive insulating surface in which the latent image is developed with a resinous powder.</def><br/
<syn><b>Syn. --</b> xerox, xerographic copier, xerox machine.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>A copy made by the xerox process.</def><br/
<syn><b>Syn. --</b> xerox copy.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>xerox</ent><br/
<hw>xe"rox</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>To copy a printed document on a xerographic device.</def><br/
[<source>WordNet 1.5</source>]</p> 

<p><ent>xi</ent><br/
<hw>xi</hw> <pr>(?)</pr>, <pos>adj.</pos> <def>The Roman number symbolizing the value eleven.  Used after a noun it may symbolize the ordinal number; <as>as, Superbowl <ex>XI</ex></as>.</def><br/
<syn><b>Syn. --</b> eleven, 11.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Xian</ent><br/
<hw>Xi"an</hw> <pr>(?)</pr>, <pos>pr. n.</pos> <def>The capital of the ancient Chinese empire.</def><br/
<syn><b>Syn. --</b> Sian, Singan, Changan.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>xii</ent><br/
<hw>xii</hw> <pr>(?)</pr>, <pos>adj.</pos>  <def>The Roman number symbolizing the value twelve; denoting a quantity consisting of 12 items or units.   Used after a noun it may symbolize the ordinal number; <as>as, Superbowl <ex>XII</ex></as>.</def><br/
<syn><b>Syn. --</b> twelve, 12, dozen.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>xiii</ent><br/
<hw>xiii</hw> <pr>(?)</pr>, <pos>adj.</pos> <sn>1.</sn>  <def>the Roman number symbolizing the value thirteen.  Used after a noun it may symbolize the ordinal number; <as>as, Superbowl <ex>XIII</ex></as>.</def><br/
<syn><b>Syn. --</b> thirteen, 13.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Xiphias</ent><br/
\'d8<hw>Xiph"i*as</hw> <pr>(?)</pr>, <pos>prop. n.</pos> <ety>[L., a swordfish, a sword-shaped comet, fr. Gr. <grk>xifi`as</grk>, fr. <grk>xi`fos</grk> a sword.]</ety>  <sn>1.</sn> <fld>(Zool.)</fld> <def>A genus of fishes comprising the common swordfish.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Anat.)</fld> <sd>(a)</sd> <def>The constellation Dorado.</def>  <sd>(b)</sd> <def>A comet shaped like a sword</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xiphidium</ent><br/
\'d8<hw>Xi*phid"i*um</hw> <pr>(?)</pr>, <pos>prop. n.</pos> <ety>[NL., from Gr. <?/, dim. of <grk>xi`fos</grk> sword.]</ety> <fld>(Bot.)</fld> <def>A genus of plants of the order <ord>Haemodraceae</ord>, having two-ranked, sword-shaped leaves.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xiphioid</ent><br/
<hw>Xiph"i*oid</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Xiphius</ets> + <ets>-oid</ets>.]</ety> <fld>(Zool.)</fld> <def>Of, pertaining to, or resembling, a cetacean of the genus <gen>Xiphius</gen> or family <fam>Xiphiidae</fam>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xiphiplastron</ent><br/
\'d8<hw>Xiph"i*plas"tron</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Xiphiplastra</plw> <pr>(?)</pr>.</plu> <ety>[NL., fr. Gr. <grk>xi`fos</grk> a sword + <ets>plastron</ets>.]</ety> <fld>(Anat.)</fld> <def>The posterior, or fourth, lateral plate in the plastron of turtles; -- called also <altname>xiphisternum</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xiphisternum</ent><br/
\'d8<hw>Xiph"i*ster"num</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Xiphisterna</plw> <pr>(?)</pr>.</plu> <ety>[NL., fr. Gr. <grk>xi`fos</grk> a sword + <ets>sternum</ets>.]</ety> <fld>(Anat.)</fld> <sd>(a)</sd> <def>The posterior segment, or extremity, of the sternum; -- sometimes called <altname>metasternum</altname>, <altname>ensiform cartilage</altname>, <altname>ensiform process</altname>, or <altname>xiphoid process</altname>.</def>  <sd>(b)</sd> <def>The xiphiplastron.</def>  -- <wordforms><wf>Xiph"i*ster"nal</wf> <pr>(?)</pr> <pos>a.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xiphius</ent><br/
\'d8<hw>Xiph"i*us</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>xi`fos</grk> a sword.]</ety> <fld>(Zool.)</fld> <def>A genus of cetaceans having a long, pointed, bony beak, usually two tusklike teeth in the lower jaw, but no teeth in the upper jaw.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xiphodon</ent><br/
<hw>Xiph"o*don</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>xi`fos</grk> a sword + <grk>'odoy`s</grk>, <grk>'odo`ntos</grk>, a tooth.]</ety> <fld>(Paleon.)</fld> <def>An extinct genus of artiodactylous mammals found in the European Tertiary formations. It had slender legs, didactylous feet, and small canine teeth.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xiphoid</ent><br/
<hw>Xiph"oid</hw> <pr>(?; 277)</pr>, <pos>a.</pos> <ety>[Gr. <grk>xifoeidh`s</grk> sword-shaped; <grk>xi`fos</grk> a sword + <grk>e`i^dos</grk> form, shape: cf. F. <ets>xiphoide</ets>.]</ety> <fld>(Anat.)</fld> <sd>(a)</sd> <def>Like a sword; ensiform.</def>  <sd>(b)</sd> <def>Of or pertaining to the xiphoid process; xiphoidian.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xiphoidian</ent><br/
<hw>Xiph*oid"i*an</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Anat.)</fld> <def>Xiphoid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xiphophyllous</ent><br/
<hw>Xi*phoph"yl*lous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <grk>xi`fos</grk> sword + <grk>fy`llon</grk> leaf.]</ety> <fld>(Bot.)</fld> <def>Having sword-shaped leaves.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xiphosura</ent><br/
\'d8<hw>Xiph`o*su"ra</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <def>See <er>Xiphura</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xiphura</ent><br/
\'d8<hw>Xi*phu"ra</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., from Gr. <grk>xi`fos</grk> sword + <grk>o'yra`</grk> tail.]</ety> <fld>(Zool.)</fld> <def>Same as <er>Limuloidea</er>. Called also <altname>Xiphosura</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>xl</ent><br/
<hw>xl</hw> <pr>(?)</pr>, <pos>adj.</pos> <sn>1.</sn>  <def>the Roman number symbolizing the value <sig>forty</sig>.</def><br/
<syn><b>Syn. --</b> forty, 40, twoscore.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Xmas</ent><br/
<hw>X"mas</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Christmas; -- an abbreviation for the Christian holiday celebrating the birth of Christ; a quarter day in England, Wales, and Ireland.</def><br/
<syn><b>Syn. --</b> Christmas, Christmas Day, Dec 25.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>XP</ent><br/
<hw>XP</hw> <pr>(?)</pr>. <ety>[Belongs here in appearance only.]</ety> <def>The first two letters of the Greek word <grk>CHRISTOS</grk>, Christ; -- an abbreviation used with the letters separate or, oftener, in a monogram, often inclosed in a circle, as a symbol or emblem of Christ. It use as an emblem was introduced by Constantine the Great, whence it is known as the <col><b>Constantinian symbol</b></col>, or <col><b>monogram</b></col>. See <er>Labarum</er>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>x-rated</ent><br/
<hw>x"-rat`ed</hw> <pr>(<ecr/ks"r<amac/t`<ecr/d)</pr>, <pos>a.</pos> <ety>[from a system of ratings for movies based on objectionableness of the content or suitability for children.]</ety> <def>having a rating of X; not suitable for children; broadly, obscene or sexually explicit.</def><br/
[<source>PJC</source>]</p>

<p><ent>X-ray</ent><br/
<ent>X ray</ent><br/
<mhw><hw>X ray</hw>, <hw>X-ray</hw></mhw> <pr>(<ecr/ks"r<amac/`)</pr>, <pos>n.</pos> <ety>[so called by its discoverer because of its enigmatical character, <it>x</it> being an algebraic symbol for an unknown quantity.]</ety> <fld>(Physics)</fld> <def>Originally, any of the rays produced when cathode rays strike upon surface of a solid (as a copper target or the wall of the vacuum tube); now defined as electromagnetic radiation with a wavelength of 0.1 to 10 nanometers. X-rays are noted for their penetration of many opaque substances, as wood and flesh, their action on photographic plates, and their fluorescent effects. They were called <altname>X rays</altname> by their discoverer, <person>W. K. R<oum/ntgen</person>, but were also referred to for some time as <altname>Roentgen rays</altname>. The term <ex>X-ray</ex> has become the most common designation.  They also ionize gases, but cannot be reflected, or polarized, or deflected by a magnetic field.  They are used in examining objects opaque to visible light, as for imaging bones or other structures inside the human body, and for detecting flaws in metal objects, such as in welds.</def><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>X-ray</ent><br/
<ent>X ray</ent><br/
<mhw><hw>X ray</hw>, <hw>X-ray</hw></mhw> <pr>(<ecr/ks"r<amac/`)</pr>, <pos>v. t.</pos>  <def>To examine by means of X-rays; to irradiate with X-rays.</def><br/
[<source>PJC</source>]</p>

<p><ent>X-ray astronomy</ent><br/
<hw>X"-ray` astronomy</hw>. <def>The branch of astronomy dealing with the study of astronomical objects which emit X-rays, and the methods used to detect such objects.</def><br/
[<source>PJC</source>]</p>

<p><ent>X-ray tube</ent><br/
<hw>X"-ray` tube</hw>. <fld>(Physics)</fld> <def>A vacuum tube suitable for producing Roentgen rays.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>XT</ent><br/
<hw>XT</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Electronics)</fld> <def>An abbreviation for <er>crosstalk</er>, the presence of an unwanted signal via an accidental coupling.</def> <mark>[abbrev.]</mark> <br/
<syn><b>Syn. --</b> crosstalk.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>xv</ent><br/
<hw>xv</hw> <pr>(?)</pr>, <pos>adj.</pos> <def>The Roman number symbolizing the value fifteen.</def><br/
<syn><b>Syn. --</b> fifteen, 15.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>xvi</ent><br/
<hw>xvi</hw> <pr>(?)</pr>, <pos>adj.</pos>  <def>The Roman number symbolizing the value sixteen.</def><br/
<syn><b>Syn. --</b> sixteen, 16.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>xvii</ent><br/
<hw>xvii</hw> <pr>(?)</pr>, <pos>adj.</pos>  <def>The Roman number symbolizing the value seventeen.</def><br/
<syn><b>Syn. --</b> seventeen, 17.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>xviii</ent><br/
<hw>xviii</hw> <pr>(?)</pr>, <pos>adj.</pos> <def>The Roman number symbolizing the value eighteen.</def><br/
<syn><b>Syn. --</b> eighteen, 18.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>xx</ent><br/
<hw>xx</hw> <pr>(?)</pr>, <pos>adj.</pos> <def>The Roman number representing <er>twenty</er>; denoting a quantity consisting of 20 items or units.</def><br/
<syn><b>Syn. --</b> twenty, 20, score.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>xxi</ent><br/
<hw>xxi</hw> <pr>(?)</pr>, <pos>adj.</pos> <def>The Roman number representing <er>twenty-one</er>.</def><br/
<syn><b>Syn. --</b> twenty-one, 21.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>xxii</ent><br/
<hw>xxii</hw> <pr>(?)</pr>, <pos>adj.</pos> <def>The Roman number representing <er>twenty-two</er>.</def><br/
<syn><b>Syn. --</b> twenty-two, 22.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>xxiii</ent><br/
<hw>xxiii</hw> <pr>(?)</pr>, <pos>adj.</pos> <def>The Roman number representing <er>twenty-three</er>.</def><br/
<syn><b>Syn. --</b> twenty-three, 23.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>xxiv</ent><br/
<hw>xxiv</hw> <pr>(?)</pr>, <pos>adj.</pos> <def>The Roman number representing <er>twenty-four</er>.</def><br/
<syn><b>Syn. --</b> twenty-four, 24.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>xxix</ent><br/
<hw>xxix</hw> <pr>(?)</pr>, <pos>adj.</pos> <def>The Roman number representing <er>twenty-nine</er>.</def><br/
<syn><b>Syn. --</b> twenty-nine, 29.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>xxv</ent><br/
<hw>xxv</hw> <pr>(?)</pr>, <pos>adj.</pos> <def>The Roman number representing <er>twenty-five</er>.</def><br/
<syn><b>Syn. --</b> twenty-five, 25.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>xxvi</ent><br/
<hw>xxvi</hw> <pr>(?)</pr>, <pos>adj.</pos> <def>The Roman number representing <er>twenty-six</er>.</def><br/
<syn><b>Syn. --</b> twenty-six, 26.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>xxvii</ent><br/
<hw>xxvii</hw> <pr>(?)</pr>, <pos>adj.</pos> <def>The Roman number representing <er>twenty-seven</er>.</def><br/
<syn><b>Syn. --</b> twenty-seven, 27.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>xxviii</ent><br/
<hw>xxviii</hw> <pr>(?)</pr>, <pos>adj.</pos> <def>The Roman number representing <er>twenty-eight</er>.</def><br/
<syn><b>Syn. --</b> twenty-eight, 28.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>xxx</ent><br/
<hw>xxx</hw> <pr>(?)</pr>, <pos>adj.</pos> <def>The Roman number representing <er>thirty</er>; -- in the postposition, designating the thirtieth in a series.</def><br/
<syn><b>Syn. --</b> thirty, 30.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>xxx</ent><br/
<hw>xxx</hw> <pr>(?)</pr>, <pos>adj.</pos> <ety>[by reduplication of the "X" used in some movie-rating systems.]</ety> <def>Very obscene or pornographic.</def><br/
<syn><b>Syn. --</b> X-rated, obscene, pornographic.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Xylamide</ent><br/
<hw>Xy*lam"ide</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Xyl</ets>ic + <ets>amide</ets>.]</ety> <fld>(Chem.)</fld> <def>An acid amide derivative of xylic acid, obtained as a white crystalline substance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylan</ent><br/
<hw>Xy"lan</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A gummy substance of the pentosan class, present in woody tissue, and yielding xylose on hydrolysis; wood gum.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Xylanthrax</ent><br/
<hw>Xy*lan"thrax</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>xy`lon</grk> wood + <grk>'a`nqrax</grk> coal.]</ety> <def>Wood coal, or charcoal; -- so called in distinction from <xex>mineral coal</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylaria</ent><br/
<hw>Xy*la"ria</hw> <pr>(?)</pr>, <pos>pr. n.</pos> <def>The type genus of the natural family <fam>Xylariaceae</fam>; fungi with perithecia in the upper part of erect black woody stromata.</def><br/
<syn><b>Syn. --</b> genus <gen>Xylaria</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Xylariaceae</ent><br/
<hw>Xy*la'ri*a"ce*ae</hw> <pos>pr. n.</pos> <def>A natural family of fungi characterized by dark brown to back spores.</def><br/
<syn><b>Syn. --</b> family <fam>Xylariaceae</fam>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Xylate</ent><br/
<hw>Xy"late</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A salt of xylic acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylem</ent><br/
<hw>Xy"lem</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>xy`lon</grk> wood.]</ety> <fld>(Bot.)</fld> <def>That portion of a fibrovascular bundle which has developed, or will develop, into wood cells; -- distinguished from <contr>phloem</contr>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylene</ent><br/
<hw>Xy"lene</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>xy`lon</grk> wood.]</ety> <fld>(Chem.)</fld> <def>Any of a group of three metameric hydrocarbons of the aromatic series, found in coal and wood tar, and so named because found in crude wood spirit. They are colorless, oily, inflammable liquids, <chform>C6H4.(CH3)2</chform>, being dimethyl benzenes, and are called respectively <stype>orthoxylene</stype>, <stype>metaxylene</stype>, and <stype>paraxylene</stype>. Called also <altname>xylol</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Each of these xylenes is the nucleus and prototype of a distinct series of compounds.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylenol</ent><br/
<hw>Xy"le*nol</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Xylene</ets> + <ets>-ol</ets>.]</ety> <fld>(Chem.)</fld> <def>Any one of six metameric phenol derivatives of xylene, obtained as crystalline substances, <chform>(CH3)2.C6H3.OH</chform>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xyletic</ent><br/
<hw>Xy*let"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Pertaining to, or designating, a complex acid related to mesitylenic acid, obtained as a white crystalline substance by the action of sodium and carbon dioxide on crude xylenol.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylic</ent><br/
<hw>Xy"lic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Pertaining to, derived from, or related to, xylene; specifically, designating any one of several metameric acids produced by the partial oxidation of mesitylene and pseudo-cumene.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylidic</ent><br/
<hw>Xy*lid"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Pertaining to, or designating, either one of two distinct acids which are derived from xylic acid and related compounds, and are metameric with uvitic acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylidine</ent><br/
<hw>Xy"li*dine</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>Any one of six metameric hydrocarbons, <chform>(CH3)2.C6H3.NH2</chform>, resembling aniline, and related to xylene. They are liquids, or easily fusible crystalline substances, of which three are derived from metaxylene, two from orthoxylene, and one from paraxylene. They are called the <xex>amido xylenes</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The xylidine of commerce, used in making certain dyes, consists chiefly of the derivatives of paraxylene and metaxylene.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylindein</ent><br/
<hw>Xy*lin"de*in</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A green or blue pigment produced by Peziza in certain kinds of decayed wood, as the beech, oak, birch, etc., and extracted as an amorphous powder resembling indigo.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylite</ent><br/
<hw>Xy"lite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>xy`lon</grk> wood.]</ety> <fld>(Chem.)</fld> <def>A liquid hydrocarbon found in crude wood spirits.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylitone</ent><br/
<hw>Xy"li*tone</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A yellow oil having a geraniumlike odor, produced as a side product in making phorone; -- called also <altname>xylite oil</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylo-</ent><br/
<hw>Xy"lo-</hw> <pr>(?)</pr>. <def>A combining form from Gr. <grk>xy`lon</grk> wood; as in <ex>xylo</ex>gen, <ex>xylo</ex>graph.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylobalsamum</ent><br/
\'d8<hw>Xy`lo*bal"sa*mum</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>xy`lon</grk> wood + <grk>ba`lsamon</grk> the balsam tree, balsam; cf. L. <ets>xylobalsamum</ets> balsam wood, Gr. <grk>xyloba`lsamon</grk>.]</ety> <fld>(Med.)</fld> <def>The dried twigs of a Syrian tree (<spn>Balsamodendron Gileadense</spn>).</def>  <rj><au>U. S. Disp.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylocarpous</ent><br/
<hw>Xy`lo*car"pous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Xylo-</ets> + Gr. <grk>karpo`s</grk> fruit.]</ety> <fld>(Bot.)</fld> <def>Bearing fruit which becomes hard or woody.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylocopa</ent><br/
\'d8<hw>Xy*loc"o*pa</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <?/ cutting wood; <grk>xy`lon</grk> wood + <?/ to cut.]</ety> <fld>(Zool.)</fld> <def>A genus of hymenopterous insects including the carpenter.  See <cref>Carpenter bee</cref>, under <er>Carpenter</er>.</def>  -- <wordforms><wf>Xy*loc"o*pine</wf> <pr>(?)</pr>, <pos>a.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylogen</ent><br/
<hw>Xy"lo*gen</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Xylo-</ets> + <ets>-gen</ets>.]</ety> <sd>(a)</sd> <fld>(Bot.)</fld> <def>Nascent wood; wood cells in a forming state.</def>  <sd>(b)</sd> <def>Lignin.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylograph</ent><br/
<hw>Xy"lo*graph</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Xylo-</ets> + <ets>-graph</ets>.]</ety> <def>An engraving on wood, or the impression from such an engraving; a print by xylography.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylographer</ent><br/
<hw>Xy*log"ra*pher</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who practices xylography.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylographical</ent><br/
<ent>Xylographic</ent><br/
<mhw>{ <hw>Xy`lo*graph"ic</hw> <pr>(?)</pr>, <hw>Xy`lo*graph"ic*al</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[Cf. F. <ets>xylographique</ets>.]</ety> <def>Of or pertaining to xylography, or wood engraving.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylography</ent><br/
<hw>Xy*log"ra*phy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Xylo-</ets> + <ets>-graphy</ets>: cf. F. <ets>xylographie</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>The art of engraving on wood.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The art of making prints from the natural grain of wood.</def>  <rj><au>Knight.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A method pf printing in colors upon wood for purposes of house decoration.</def>  <rj><au>Ure.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xyloid</ent><br/
<hw>Xy"loid</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Xyl</ets>o- + <ets>-oid</ets>.]</ety> <def>Resembling wood; having the nature of wood.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xyloidin</ent><br/
<hw>Xy*loid"in</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Xyl</ets>o- + <ets>-oid</ets>.]</ety> <fld>(Chem.)</fld> <def>A substance resembling pyroxylin, obtained by the action of nitric acid on starch; -- called also <altname>nitramidin</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylol</ent><br/
<hw>Xy"lol</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Xyl</ets>o- + L. <ets>ol</ets>eum oil.]</ety> <fld>(Chem.)</fld> <def>Same as <er>Xylene</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylology</ent><br/
<hw>Xy*lol"o*gy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Pref. <ets>xylo-</ets> + <ets>-logy</ets>.]</ety> <def>The branch of dendrology treating of the gross and minute structure of wood.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Xylonite</ent><br/
<hw>Xy"lon*ite</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Zylonite</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylophaga</ent><br/
\'d8<hw>Xy*loph"a*ga</hw> <pr>(?)</pr>, <pos>prop. n.</pos> <ety>[NL.  See <er>Xylophagous</er>.]</ety> <fld>(Zool.)</fld> <def>A genus of marine bivalves which bore holes in wood.  They are allied to Pholas.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylophagan</ent><br/
<hw>Xy*loph"a*gan</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Xylophagous</er>.]</ety> <fld>(Zool.)</fld> <sd>(a)</sd> <def>One of a tribe of beetles whose larvae bore or live in wood.</def>  <sd>(b)</sd> <def>Any species of <gen>Xylophaga</gen>.</def>  <sd>(c)</sd> <def>Any one of the <fam>Xylophagides</fam>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylophagides</ent><br/
\'d8<hw>Xy`lo*phag"i*des</hw> <pr>(?)</pr>, <pos>prop. n. pl.</pos> <ety>[See <er>Xylophagous</er>.]</ety> <fld>(Zool.)</fld> <def>A tribe or family of dipterous flies whose larvae live in decayed wood. Some of the tropical species are very large.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylophagous</ent><br/
<hw>Xy*loph"a*gous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <grk>xylofa`gos</grk> eating wood; <grk>xy`lon</grk> wood + <grk>fagei^n</grk> to eat.]</ety> <fld>(Zool.)</fld> <sd>(a)</sd> <def>Eating, boring in, or destroying, wood; -- said especially of certain insect larvae, crustaceans, and mollusks.</def>  <sd>(b)</sd> <def>Of or pertaining to the genus <gen>Xylophaga</gen>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylophilan</ent><br/
<hw>Xy*loph"i*lan</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Xylophilous</er>.]</ety> <fld>(Zool.)</fld> <def>One of a tribe of beetles (<fam>Xylophili</fam>) whose larvae live on decayed wood.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylophilous</ent><br/
<hw>Xy*loph"i*lous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Xylo-</ets> + Gr. <grk>filei^n</grk> to love.]</ety> <fld>(Zool.)</fld> <def>Of or pertaining to the xylophilans.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylophone</ent><br/
<hw>Xy"lo*phone</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Xylo-</ets> + Gr. <grk>fwnh`</grk> sound.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Mus.)</fld> <def>Originally, an instrument common among the Russians, Poles, and Tartars, consisting of a series of strips of wood or glass graduated in length to the musical scale, resting on belts of straw, and struck with two small hammers; now any similar musical instrument composed of a series of bars of graduated length.  Called in Germany <altname>strohfiedel</altname>, or <altname>straw fiddle</altname>.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>2.</sn> <def>An instrument to determine the vibrative properties of different kinds of wood.</def>  <rj><au>Knight.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xyloplastic</ent><br/
<hw>Xy`lo*plas"tic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Xylo-</ets> + <ets>-plastic</ets>.]</ety> <fld>(Technol.)</fld> <def>Formed of wood pulp by molds; relating to casts made of wood pulp in molds.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylopyrography</ent><br/
<hw>Xy`lo*py*rog"ra*phy</hw> <pr>(?)</pr>. <pos>n.</pos> <ety>[<ets>Xylo-</ets> + Gr. <?/, <?/, fire + <ets>-graphy</ets>.]</ety> <def>The art or practice of burning pictures on wood with a hot iron; -- called also <altname>wood burning</altname> and <altname>poker painting</altname>.  See <cref>Poker picture</cref>, under <er>Poker</er>.</def><br/
[<source>1913 Webster</source> + <source>PJC</source>]</p>

<p><-- p. 1672 --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xyloquinone</ent><br/
<hw>Xy`lo*qui"none</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Xyl</ets>ene + <ets>quinone</ets>.]</ety> <fld>(Chem.)</fld> <def>Any one of a group of quinone compounds obtained respectively by the oxidation of certain xylidine compounds. In general they are yellow crystalline substances.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylorcin</ent><br/
<hw>Xy*lor"cin</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Xyl</ets>ene + <ets>orcin</ets>.]</ety> <fld>(Chem.)</fld> <def>A derivative of xylene obtained as a white crystalline substance which on exposure in the air becomes red; -- called also <altname>betaorcin</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylose</ent><br/
<hw>Xy"lose</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Pref. <ets>xylo-</ets> + <ets>-ose</ets>.]</ety> <fld>(Chem.)</fld> <def>An unfermentable sugar of the pentose class, <chform>C5H10O5</chform>, formed by the hydrolysis of xylan; wood sugar.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Xylostein</ent><br/
<hw>Xy*los"te*in</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Xylo-</ets> + Gr. <grk>'oste`on</grk> bone.]</ety> <fld>(Chem.)</fld> <def>A glucoside found in the poisonous berries of a species of honeysuckle (<spn>Lonicera xylosteum</spn>), and extracted as a bitter, white, crystalline substance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylotile</ent><br/
<hw>Xy"lo*tile</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Same as <er>Parkesine</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylotomist</ent><br/
<hw>Xy*lot"o*mist</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One versed or engaged in xylotomy.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Xylotomous</ent><br/
<hw>Xy*lot"o*mous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Pref. <ets>xylo-</ets> + root of Gr. <grk>te`mnein</grk> to cut.]</ety> <fld>(Zool.)</fld> <def>Capable of boring or cutting wood; -- said of many insects.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Xylotomy</ent><br/
<hw>Xy*lot"o*my</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Pref. <ets>xylo-</ets> + <ets>-tomy</ets>.]</ety> <def>Art of preparing sections (transverse, tangential, or radial) of wood, esp. by means of a microtome, for microscopic examination.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Xylotrya</ent><br/
\'d8<hw>Xy*lo"try*a</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>xy`lon</grk> wood + <?/ to rub, wear out.]</ety> <fld>(Zool.)</fld> <def>A genus of marine bivalves closely allied to Teredo, and equally destructive to timber. One species (<spn>Xylotrya fimbriata</spn>) is very common on the Atlantic coast of the United States.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylyl</ent><br/
<hw>Xy"lyl</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Xylo-</ets> + <ets>-yl</ets>.]</ety> <fld>(Chem.)</fld> <def>Any one of three metameric radicals which are characteristic respectively of the three xylenes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xylylene</ent><br/
<hw>Xy"lyl*ene</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>Any one of three metameric radicals, <chform>CH2.C6H4.CH2</chform>, derived respectively from the three xylenes. Often used adjectively; <as>as, <ex>xylylene</ex> alcohol</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xyridaceous</ent><br/
<hw>Xyr`i*da"ceous</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Bot.)</fld> <def>Of or pertaining to a natural order (<ord>Xyrideae</ord>) of endogenous plants, of which <gen>Xyris</gen> is the type.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xyris</ent><br/
\'d8<hw>Xy"ris</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., a kind of Iris, Gr. <?/, fr. <?/ a razor.]</ety> <fld>(Bot.)</fld> <def>A genus of endogenous herbs with grassy leaves and small yellow flowers in short, scaly-bracted spikes; yellow-eyed grass. There are about seventeen species in the Atlantic United States.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xystus</ent><br/
<ent>Xyst</ent><br/
<mhw>{ <hw>Xyst</hw> <pr>(?)</pr>, \'d8<hw>Xys"tus</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos> <ety>[L. <ets>xystus</ets>, Gr. <?/, from <?/ to scrape, polish; -- so called from its smooth and polished floor.]</ety> <fld>(Anc. Arch.)</fld> <def>A long and open portico, for athletic exercises, as wrestling, running, etc., for use in winter or in stormy weather.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xystarch</ent><br/
<hw>Xyst"arch</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>xystarches</ets>, Gr. <?/, <?/ a xyst + <?/ to rule.]</ety> <fld>(Gr. Antiq.)</fld> <def>An officer having the superintendence of the xyst.</def>  <rj><au>Dr. W. Smith.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Xyster</ent><br/
<hw>Xys"ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>xysth`r</grk> a scraper.]</ety> <fld>(Surg.)</fld> <def>An instrument for scraping bones.</def><br/
[<source>1913 Webster</source>]</p>

