/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.view.ViewLocale;

public final class LocaleUtils {
    private static final Logger logger = Logger.getLogger(LocaleUtils.class);
    private static final String MESSAGES_BASE_FILENAME = "Messages_";
    private static final String DEFAULT_LOCALE = "en_GB";
    public static final String LANGUAGE_LOCALE_REGEX = "[a-zA-Z]{2,8}";
    public static final String COUNTRY_LOCALE_REGEX = "[a-zA-Z]{2}|[0-9]{3}";

    private LocaleUtils() {
    }

    public static Pattern createMessagesPropertiesFilePattern() {
        return LocaleUtils.createResourceFilesPattern("Messages", ".properties");
    }

    public static String createResourceFilesRegex(String fileName, String fileExtension) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter fileName must not be null.");
        }
        if (fileExtension == null) {
            throw new IllegalArgumentException("Parameter fileExtension must not be null.");
        }
        StringBuilder strBuilder = new StringBuilder(fileName.length() + LANGUAGE_LOCALE_REGEX.length() + COUNTRY_LOCALE_REGEX.length() + fileExtension.length() + 13);
        strBuilder.append(Pattern.quote(fileName));
        strBuilder.append("(?:_").append(LANGUAGE_LOCALE_REGEX);
        strBuilder.append("(?:_").append(COUNTRY_LOCALE_REGEX).append(")?").append(")?");
        strBuilder.append(Pattern.quote(fileExtension));
        strBuilder.append('$');
        return strBuilder.toString();
    }

    public static Pattern createResourceFilesPattern(String fileName, String fileExtension) {
        return Pattern.compile(LocaleUtils.createResourceFilesRegex(fileName, fileExtension));
    }

    public static List<String> getAvailableLocales() {
        List<String> locales = LocaleUtils.readAvailableLocales();
        Collections.sort(locales);
        locales.add(0, DEFAULT_LOCALE);
        return locales;
    }

    private static List<String> readAvailableLocales() {
        MessagesPropertiesFilenameFilter filter;
        File dir = new File(Constant.getZapInstall(), "lang");
        String[] files = dir.list(filter = new MessagesPropertiesFilenameFilter());
        if (files == null || files.length == 0) {
            logger.error((Object)("Failed to find any locale files in directory " + dir.getAbsolutePath()));
            return new ArrayList<String>(0);
        }
        ArrayList<String> locales = new ArrayList<String>(files.length);
        int baseFilenameLength = MESSAGES_BASE_FILENAME.length();
        for (String file : Arrays.asList(files)) {
            if (!file.startsWith(MESSAGES_BASE_FILENAME)) continue;
            locales.add(file.substring(baseFilenameLength, file.indexOf(".")));
        }
        return locales;
    }

    public static ViewLocale getViewLocale(String locale) {
        return new ViewLocale(locale, LocaleUtils.getLocalDisplayName(locale));
    }

    public static List<ViewLocale> getAvailableViewLocales() {
        List<String> locales = LocaleUtils.readAvailableLocales();
        ArrayList<ViewLocale> localesUI = new ArrayList<ViewLocale>();
        if (!locales.isEmpty()) {
            for (String locale : locales) {
                localesUI.add(new ViewLocale(locale, LocaleUtils.getLocalDisplayName(locale)));
            }
            Collections.sort(localesUI, new Comparator<ViewLocale>(){

                @Override
                public int compare(ViewLocale o1, ViewLocale o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
        }
        localesUI.add(0, new ViewLocale(DEFAULT_LOCALE, LocaleUtils.getLocalDisplayName(DEFAULT_LOCALE)));
        return localesUI;
    }

    public static String getLocalDisplayName(String locale) {
        String desc = "" + locale;
        if (locale != null) {
            String[] langArray = locale.split("_");
            Locale loc = null;
            if (langArray.length == 1) {
                loc = new Locale(langArray[0]);
            } else if (langArray.length == 2) {
                loc = new Locale(langArray[0], langArray[1]);
            } else if (langArray.length == 3) {
                loc = new Locale(langArray[0], langArray[1], langArray[2]);
            }
            if (loc != null) {
                desc = loc.getDisplayLanguage(loc);
            }
        }
        return desc;
    }

    private static final class MessagesPropertiesFilenameFilter
    implements FilenameFilter {
        private final Pattern messagesPropertiesPattern = LocaleUtils.createMessagesPropertiesFilePattern();

        private MessagesPropertiesFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.messagesPropertiesPattern.matcher(name).matches();
        }
    }
}

