/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.zaproxy.zap.utils.BoyerMooreMatcher;

public class ContentMatcher {
    private static final String TAG_PATTERNS = "Patterns";
    private static final String TAG_PATTERN = "Pattern";
    private static final String TAG_PATTERN_TYPE = "type";
    private static final String TAG_PATTERN_TYPE_STRING = "string";
    private static final String TAG_PATTERN_TYPE_REGEX = "regex";
    private List<BoyerMooreMatcher> strings;
    private List<Pattern> patterns;

    public static ContentMatcher getInstance(String xmlFileName) {
        ContentMatcher cm = new ContentMatcher();
        try {
            cm.loadXMLPatternDefinitions(cm.getClass().getResourceAsStream(xmlFileName));
        }
        catch (IOException | JDOMException ex) {
            throw new IllegalArgumentException("Failed to initialize the ContentMatcher object using: " + xmlFileName, ex);
        }
        return cm;
    }

    public static ContentMatcher getInstance(InputStream xmlInputStream) {
        ContentMatcher cm = new ContentMatcher();
        try {
            cm.loadXMLPatternDefinitions(xmlInputStream);
        }
        catch (IOException | JDOMException ex) {
            throw new IllegalArgumentException("Failed to initialize the ContentMatcher object using that stream", ex);
        }
        return cm;
    }

    protected void loadXMLPatternDefinitions(InputStream xmlInputStream) throws JDOMException, IOException {
        this.strings = new ArrayList<BoyerMooreMatcher>();
        this.patterns = new ArrayList<Pattern>();
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(xmlInputStream);
        Element el = doc.getRootElement();
        for (Object obj : el.getChildren(TAG_PATTERN)) {
            el = (Element)obj;
            String value = el.getText();
            if (value == null || value.isEmpty()) continue;
            if (el.getAttributeValue(TAG_PATTERN_TYPE).equalsIgnoreCase(TAG_PATTERN_TYPE_REGEX)) {
                this.patterns.add(Pattern.compile(el.getText()));
                continue;
            }
            this.strings.add(new BoyerMooreMatcher(el.getText()));
        }
    }

    public String findInContent(String content) {
        for (BoyerMooreMatcher matcher : this.strings) {
            if (matcher.findInContent(content) < 0) continue;
            return matcher.getPattern();
        }
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(content);
            if (!matcher.find()) continue;
            return matcher.group();
        }
        return null;
    }

    public List<String> findAllInContent(String content) {
        LinkedList<String> results = new LinkedList<String>();
        for (BoyerMooreMatcher matcher : this.strings) {
            if (matcher.findInContent(content) < 0) continue;
            results.add(matcher.getPattern());
        }
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(content);
            if (!matcher.find()) continue;
            results.add(content);
        }
        return results;
    }
}

