/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.core.scanner.MultipartFormParser;
import org.parosproxy.paros.core.scanner.MultipartParam;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.network.HttpMessage;

public class VariantMultipartFormQuery
implements Variant {
    private final List<NameValuePair> stringParam = new ArrayList<NameValuePair>();
    private final List<MultipartParam> fileParam = new ArrayList<MultipartParam>();
    private String boundary = null;

    @Override
    public void setMessage(HttpMessage msg) {
        String contentType = msg.getRequestHeader().getHeader("Content-Type");
        if (contentType == null || !contentType.startsWith("multipart/form-data")) {
            return;
        }
        try {
            MultipartParam param;
            MultipartFormParser parser = new MultipartFormParser(msg);
            int index = 0;
            this.boundary = parser.getBoundary();
            while ((param = parser.getNextParam()) != null) {
                if (param.getFileName() == null) {
                    this.stringParam.add(new NameValuePair(2, param.getName(), param.getContent(), index++));
                    continue;
                }
                this.fileParam.add(param);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public List<NameValuePair> getParamList() {
        return this.stringParam;
    }

    @Override
    public String setParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        return this.setParameter(msg, originalPair, name, value, false);
    }

    @Override
    public String setEscapedParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        return this.setParameter(msg, originalPair, name, value, true);
    }

    private String setParameter(HttpMessage msg, NameValuePair originalPair, String name, String value, boolean escaped) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.stringParam.size(); ++i) {
            NameValuePair pair = this.stringParam.get(i);
            sb.append(this.boundary);
            sb.append("\r\n");
            sb.append("Content-Disposition: form-data; name=\"");
            if (i == originalPair.getPosition()) {
                sb.append(name);
                sb.append("\"\r\n\r\n");
                sb.append(value);
            } else {
                sb.append(pair.getName());
                sb.append("\"\r\n\r\n");
                sb.append(pair.getValue());
            }
            sb.append("\r\n");
        }
        for (MultipartParam part : this.fileParam) {
            sb.append(this.boundary);
            sb.append("\r\n");
            sb.append(part.toString());
        }
        sb.append(this.boundary);
        sb.append("--");
        sb.append("\r\n");
        String query = sb.toString();
        msg.getRequestBody().setBody(query);
        return query;
    }
}

