/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.expression;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.jxls.expression.EvaluationException;
import org.jxls.expression.ExpressionEvaluator;

public class JexlExpressionEvaluatorNoThreadLocal
implements ExpressionEvaluator {
    private Expression jexlExpression;
    private JexlContext jexlContext;
    private static final JexlEngine jexl = new JexlEngine();
    private static final Map<String, Expression> expressionMap = new HashMap<String, Expression>();

    public JexlExpressionEvaluatorNoThreadLocal() {
    }

    public JexlExpressionEvaluatorNoThreadLocal(String expression) {
        this.jexlExpression = jexl.createExpression(expression);
    }

    public JexlExpressionEvaluatorNoThreadLocal(Map<String, Object> context) {
        this.jexlContext = new MapContext(context);
    }

    public JexlExpressionEvaluatorNoThreadLocal(JexlContext jexlContext) {
        this.jexlContext = jexlContext;
    }

    @Override
    public Object evaluate(String expression, Map<String, Object> context) {
        MapContext jexlContext = new MapContext(context);
        try {
            Expression jexlExpression = expressionMap.get(expression);
            if (jexlExpression == null) {
                jexlExpression = jexl.createExpression(expression);
                expressionMap.put(expression, jexlExpression);
            }
            return jexlExpression.evaluate((JexlContext)jexlContext);
        }
        catch (Exception e) {
            throw new EvaluationException("An error occurred when evaluating expression " + expression, e);
        }
    }

    @Override
    public Object evaluate(Map<String, Object> context) {
        this.jexlContext = new MapContext(context);
        try {
            return this.jexlExpression.evaluate(this.jexlContext);
        }
        catch (Exception e) {
            throw new EvaluationException("An error occurred when evaluating expression " + this.jexlExpression.getExpression(), e);
        }
    }

    public Expression getJexlExpression() {
        return this.jexlExpression;
    }

    public JexlEngine getJexlEngine() {
        return jexl;
    }

    @Override
    public String getExpression() {
        return this.jexlExpression == null ? null : this.jexlExpression.getExpression();
    }
}

