/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.sms;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.helper.DataConverter;
import org.traccar.notification.MessageException;
import org.traccar.sms.SmsManager;

public class HttpSmsClient
implements SmsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpSmsClient.class);
    private String url = Context.getConfig().getString("sms.http.url");
    private String authorizationHeader = Context.getConfig().getString("sms.http.authorizationHeader", "Authorization");
    private String authorization = Context.getConfig().getString("sms.http.authorization");
    private String template;
    private boolean encode;
    private MediaType mediaType;

    public HttpSmsClient() {
        if (this.authorization == null) {
            String user = Context.getConfig().getString("sms.http.user");
            String password = Context.getConfig().getString("sms.http.password");
            this.authorization = "Basic " + DataConverter.printBase64((user + ":" + password).getBytes(StandardCharsets.UTF_8));
        }
        this.template = Context.getConfig().getString("sms.http.template").trim();
        if (this.template.charAt(0) == '{' || this.template.charAt(0) == '[') {
            this.encode = false;
            this.mediaType = MediaType.APPLICATION_JSON_TYPE;
        } else {
            this.encode = true;
            this.mediaType = MediaType.APPLICATION_FORM_URLENCODED_TYPE;
        }
    }

    private String prepareValue(String value) throws UnsupportedEncodingException {
        return this.encode ? URLEncoder.encode(value, StandardCharsets.UTF_8.name()) : value;
    }

    private String preparePayload(String destAddress, String message) {
        try {
            return this.template.replace("{phone}", this.prepareValue(destAddress)).replace("{message}", this.prepareValue(message.trim()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private Invocation.Builder getRequestBuilder() {
        return Context.getClient().target(this.url).request().header(this.authorizationHeader, (Object)this.authorization);
    }

    @Override
    public void sendMessageSync(String destAddress, String message, boolean command) throws MessageException {
        Response response = this.getRequestBuilder().post(Entity.entity((Object)this.preparePayload(destAddress, message), (MediaType)this.mediaType));
        if (response.getStatus() / 100 != 2) {
            throw new MessageException((String)response.readEntity(String.class));
        }
    }

    @Override
    public void sendMessageAsync(String destAddress, String message, boolean command) {
        this.getRequestBuilder().async().post(Entity.entity((Object)this.preparePayload(destAddress, message), (MediaType)this.mediaType), (InvocationCallback)new InvocationCallback<String>(){

            public void completed(String s) {
            }

            public void failed(Throwable throwable) {
                LOGGER.warn("SMS send failed", throwable);
            }
        });
    }
}

