/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import javax.json.Json;
import javax.json.JsonObject;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.DataConverter;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class SigfoxProtocolDecoder
extends BaseHttpProtocolDecoder {
    public SigfoxProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        JsonObject json = Json.createReader((Reader)new StringReader(URLDecoder.decode(request.content().toString(StandardCharsets.UTF_8).split("=")[0], "UTF-8"))).readObject();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, json.getString("device"));
        if (deviceSession == null) {
            this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(new Date((long)json.getInt("time") * 1000L));
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])DataConverter.parseHex(json.getString("data")));
        try {
            int type = buf.readUnsignedByte() >> 4;
            if (type == 0) {
                position.setValid(true);
                position.setLatitude((double)buf.readIntLE() * 1.0E-7);
                position.setLongitude((double)buf.readIntLE() * 1.0E-7);
                position.setCourse(buf.readUnsignedByte() * 2);
                position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
                position.set("battery", (double)buf.readUnsignedByte() * 0.025);
            } else {
                this.getLastLocation(position, position.getDeviceTime());
            }
        }
        finally {
            buf.release();
        }
        position.set("rssi", json.getJsonNumber("rssi").doubleValue());
        position.set("index", json.getInt("seqNumber"));
        this.sendResponse(channel, HttpResponseStatus.OK);
        return position;
    }
}

