/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.database.BaseObjectManager;
import org.traccar.database.DataManager;
import org.traccar.database.ManagableObjects;
import org.traccar.model.BaseModel;
import org.traccar.model.Permission;
import org.traccar.model.User;

public abstract class SimpleObjectManager<T extends BaseModel>
extends BaseObjectManager<T>
implements ManagableObjects {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleObjectManager.class);
    private Map<Long, Set<Long>> userItems;

    protected SimpleObjectManager(DataManager dataManager, Class<T> baseClass) {
        super(dataManager, baseClass);
    }

    @Override
    public final Set<Long> getUserItems(long userId) {
        if (!this.userItems.containsKey(userId)) {
            this.userItems.put(userId, new HashSet());
        }
        return this.userItems.get(userId);
    }

    @Override
    public Set<Long> getManagedItems(long userId) {
        HashSet<Long> result = new HashSet<Long>();
        result.addAll(this.getUserItems(userId));
        for (long managedUserId : Context.getUsersManager().getUserItems(userId)) {
            result.addAll(this.getUserItems(managedUserId));
        }
        return result;
    }

    public final boolean checkItemPermission(long userId, long itemId) {
        return this.getUserItems(userId).contains(itemId);
    }

    @Override
    public void refreshItems() {
        super.refreshItems();
        this.refreshUserItems();
    }

    public final void refreshUserItems() {
        if (this.getDataManager() != null) {
            try {
                if (this.userItems != null) {
                    this.userItems.clear();
                } else {
                    this.userItems = new ConcurrentHashMap<Long, Set<Long>>();
                }
                for (Permission permission : this.getDataManager().getPermissions(User.class, this.getBaseClass())) {
                    this.getUserItems(permission.getOwnerId()).add(permission.getPropertyId());
                }
            }
            catch (ClassNotFoundException | SQLException error) {
                LOGGER.warn("Error getting permissions", (Throwable)error);
            }
        }
    }

    @Override
    public void removeItem(long itemId) throws SQLException {
        super.removeItem(itemId);
        this.refreshUserItems();
    }
}

