/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import com.cloudhopper.commons.util.ClassUtil;
import com.cloudhopper.commons.util.MetaFieldInfo;
import com.cloudhopper.commons.util.annotation.MetaField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaFieldUtil {
    private static Logger logger = LoggerFactory.getLogger(MetaFieldUtil.class);

    public static String toMetaFieldInfoString(Object obj) {
        StringBuffer buf = new StringBuffer(100);
        MetaFieldInfo[] fields = MetaFieldUtil.toMetaFieldInfoArray(obj, null, true);
        for (int i = 0; i < fields.length; ++i) {
            MetaFieldInfo field = fields[i];
            buf.append(field.name);
            buf.append("=");
            if (field.actualValue != null && field.actualValue.getClass().equals(String.class)) {
                buf.append('\"');
                buf.append(field.value);
                buf.append('\"');
            } else {
                buf.append(field.value);
            }
            if (i + 1 >= fields.length) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    public static MetaFieldInfo[] toMetaFieldInfoArray(Object obj) {
        return MetaFieldUtil.toMetaFieldInfoArray(obj, null);
    }

    public static MetaFieldInfo[] toMetaFieldInfoArray(Object obj, String stringForNullValues) {
        return MetaFieldUtil.toMetaFieldInfoArray(obj, stringForNullValues, false);
    }

    public static MetaFieldInfo[] toMetaFieldInfoArray(Object obj, String stringForNullValues, boolean ignoreAnnotatedName) {
        return MetaFieldUtil.toMetaFieldInfoArray(obj != null ? obj.getClass() : null, obj, stringForNullValues, ignoreAnnotatedName, true);
    }

    public static MetaFieldInfo[] toMetaFieldInfoArray(Class type, Object obj, String stringForNullValues, boolean ignoreAnnotatedName, boolean recursive) {
        return MetaFieldUtil.internalToMetaFieldInfoArray(type, obj, null, null, stringForNullValues, ignoreAnnotatedName, recursive);
    }

    protected static MetaFieldInfo[] internalToMetaFieldInfoArray(Class type, Object obj, String preFieldName, String postFieldName, String stringForNullValues, boolean ignoreAnnotatedName, boolean recursive) {
        Class<?>[] hierarchy = ClassUtil.getClassHierarchy(type);
        if (hierarchy == null || hierarchy.length == 0) {
            return null;
        }
        ArrayList<MetaFieldInfo> infos = new ArrayList<MetaFieldInfo>();
        if (preFieldName == null) {
            preFieldName = "";
        }
        if (postFieldName == null) {
            postFieldName = "";
        }
        for (Class<?> classType : hierarchy) {
            for (Field f : classType.getDeclaredFields()) {
                if (!f.isAnnotationPresent(MetaField.class)) continue;
                MetaField metaField = f.getAnnotation(MetaField.class);
                MetaFieldInfo info = new MetaFieldInfo();
                info.fieldName = f.getName();
                info.fieldClass = f.getType();
                info.level = metaField.level();
                info.name = preFieldName + (!metaField.name().equals("") && !ignoreAnnotatedName ? metaField.name() : f.getName()) + postFieldName;
                String recursivePreFieldName = preFieldName + f.getName() + ".";
                String recursivePostFieldName = "";
                if (!metaField.name().equals("") && !ignoreAnnotatedName) {
                    if (!preFieldName.equals("")) {
                        recursivePreFieldName = preFieldName + metaField.name() + "][";
                        recursivePostFieldName = "]";
                    } else {
                        recursivePreFieldName = metaField.name() + "[";
                        recursivePostFieldName = "]";
                    }
                }
                f.setAccessible(true);
                if (obj != null) {
                    try {
                        info.actualValue = f.get(obj);
                    }
                    catch (Exception e) {
                        logger.error("impossible case if run outside of an applet");
                    }
                    if (info.actualValue != null && f.getType().equals(AtomicReference.class)) {
                        AtomicReference ref = (AtomicReference)info.actualValue;
                        info.actualValue = ref.get();
                        if (info.actualValue != null) {
                            info.fieldClass = info.actualValue.getClass();
                        }
                    }
                } else {
                    info.actualValue = null;
                }
                info.value = info.actualValue == null ? stringForNullValues : info.actualValue.toString();
                info.description = metaField.description();
                if (recursive) {
                    MetaFieldInfo[] subInfos = MetaFieldUtil.internalToMetaFieldInfoArray(info.fieldClass, info.actualValue, recursivePreFieldName, recursivePostFieldName, stringForNullValues, ignoreAnnotatedName, recursive);
                    if (subInfos == null || subInfos.length == 0) {
                        infos.add(info);
                        continue;
                    }
                    for (MetaFieldInfo subInfo : subInfos) {
                        infos.add(subInfo);
                    }
                    continue;
                }
                infos.add(info);
            }
        }
        return infos.toArray(new MetaFieldInfo[0]);
    }
}

