/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpReceiver;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.client.http.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.Retainable;

public class HttpReceiverOverHTTP2
extends HttpReceiver
implements Stream.Listener {
    private final ContentNotifier contentNotifier = new ContentNotifier();

    public HttpReceiverOverHTTP2(HttpChannel channel) {
        super(channel);
    }

    protected HttpChannelOverHTTP2 getHttpChannel() {
        return (HttpChannelOverHTTP2)super.getHttpChannel();
    }

    protected void reset() {
        super.reset();
        this.contentNotifier.reset();
    }

    public void onHeaders(Stream stream, HeadersFrame frame) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        HttpResponse httpResponse = exchange.getResponse();
        MetaData metaData = frame.getMetaData();
        if (metaData.isResponse()) {
            MetaData.Response response = (MetaData.Response)frame.getMetaData();
            httpResponse.version(response.getHttpVersion()).status(response.getStatus()).reason(response.getReason());
            if (this.responseBegin(exchange)) {
                HttpFields headers = response.getFields();
                for (HttpField header : headers) {
                    if (this.responseHeader(exchange, header)) continue;
                    return;
                }
                if (this.responseHeaders(exchange)) {
                    boolean informational;
                    int status = response.getStatus();
                    boolean bl = informational = HttpStatus.isInformational((int)status) && status != 101;
                    if (frame.isEndStream() || informational) {
                        this.responseSuccess(exchange);
                    }
                }
            }
        } else {
            HttpFields trailers = metaData.getFields();
            trailers.forEach(arg_0 -> ((HttpResponse)httpResponse).trailer(arg_0));
            this.notifyContent(exchange, new DataFrame(stream.getId(), BufferUtil.EMPTY_BUFFER, true), Callback.NOOP);
        }
    }

    public Stream.Listener onPush(Stream stream, PushPromiseFrame frame) {
        Response.CompleteListener listener;
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return null;
        }
        HttpRequest request = exchange.getRequest();
        MetaData.Request metaData = (MetaData.Request)frame.getMetaData();
        HttpRequest pushRequest = (HttpRequest)this.getHttpDestination().getHttpClient().newRequest(metaData.getURIString());
        BiFunction pushListener = request.getPushListener();
        if (pushListener != null && (listener = (Response.CompleteListener)pushListener.apply(request, pushRequest)) != null) {
            HttpChannelOverHTTP2 pushChannel = this.getHttpChannel().getHttpConnection().acquireHttpChannel();
            List<Response.CompleteListener> listeners = Collections.singletonList(listener);
            HttpExchange pushExchange = new HttpExchange(this.getHttpDestination(), pushRequest, listeners);
            pushChannel.associate(pushExchange);
            pushChannel.setStream(stream);
            pushExchange.requestComplete(null);
            pushExchange.terminateRequest();
            return pushChannel.getStreamListener();
        }
        stream.reset(new ResetFrame(stream.getId(), ErrorCode.REFUSED_STREAM_ERROR.code), Callback.NOOP);
        return null;
    }

    public void onData(Stream stream, DataFrame frame, Callback callback) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            callback.failed((Throwable)new IOException("terminated"));
        } else {
            this.notifyContent(exchange, frame, callback);
        }
    }

    public void onReset(Stream stream, ResetFrame frame) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        int error = frame.getError();
        exchange.getRequest().abort((Throwable)new IOException(ErrorCode.toString((int)error, (String)("reset_code_" + error))));
    }

    public boolean onIdleTimeout(Stream stream, Throwable x) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        return !exchange.abort(x);
    }

    public void onFailure(Stream stream, int error, String reason, Callback callback) {
        this.responseFailure(new IOException(String.format("%s/%s", ErrorCode.toString((int)error, null), reason)));
        callback.succeeded();
    }

    public void onClosed(Stream stream) {
        this.getHttpChannel().onStreamClosed((IStream)stream);
    }

    private void notifyContent(HttpExchange exchange, DataFrame frame, Callback callback) {
        this.contentNotifier.offer(new DataInfo(exchange, frame, callback));
        this.contentNotifier.iterate();
    }

    private static class DataInfo {
        private final HttpExchange exchange;
        private final DataFrame frame;
        private final Callback callback;

        private DataInfo(HttpExchange exchange, DataFrame frame, Callback callback) {
            this.exchange = exchange;
            this.frame = frame;
            this.callback = callback;
        }
    }

    private class ContentNotifier
    extends IteratingCallback
    implements Retainable {
        private final Queue<DataInfo> queue = new ArrayDeque<DataInfo>();
        private DataInfo dataInfo;

        private ContentNotifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void offer(DataInfo dataInfo) {
            ContentNotifier contentNotifier = this;
            synchronized (contentNotifier) {
                this.queue.offer(dataInfo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IteratingCallback.Action process() {
            if (this.dataInfo != null) {
                this.dataInfo.callback.succeeded();
                if (this.dataInfo.frame.isEndStream()) {
                    return IteratingCallback.Action.SUCCEEDED;
                }
            }
            ContentNotifier contentNotifier = this;
            synchronized (contentNotifier) {
                this.dataInfo = this.queue.poll();
            }
            if (this.dataInfo == null) {
                return IteratingCallback.Action.IDLE;
            }
            ByteBuffer buffer = this.dataInfo.frame.getData();
            if (buffer.hasRemaining()) {
                HttpReceiverOverHTTP2.this.responseContent(this.dataInfo.exchange, buffer, (Callback)this);
            } else {
                this.succeeded();
            }
            return IteratingCallback.Action.SCHEDULED;
        }

        public void retain() {
            Callback callback = this.dataInfo.callback;
            if (callback instanceof Retainable) {
                ((Retainable)callback).retain();
            }
        }

        protected void onCompleteSuccess() {
            HttpReceiverOverHTTP2.this.responseSuccess(this.dataInfo.exchange);
        }

        protected void onCompleteFailure(Throwable failure) {
            this.dataInfo.callback.failed(failure);
            HttpReceiverOverHTTP2.this.responseFailure(failure);
        }

        public boolean reset() {
            this.queue.clear();
            this.dataInfo = null;
            return super.reset();
        }
    }
}

