/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import org.apache.solr.common.SolrException;

public class CloudConfig {
    private final String zkHost;
    private final int zkClientTimeout;
    private final int hostPort;
    private final String hostName;
    private final String hostContext;
    private final boolean useGenericCoreNames;
    private final int leaderVoteWait;
    private final int leaderConflictResolveWait;
    private final int autoReplicaFailoverWaitAfterExpiration;
    private final String zkCredentialsProviderClass;
    private final String zkACLProviderClass;
    private final int createCollectionWaitTimeTillActive;
    private final boolean createCollectionCheckLeaderActive;

    CloudConfig(String zkHost, int zkClientTimeout, int hostPort, String hostName, String hostContext, boolean useGenericCoreNames, int leaderVoteWait, int leaderConflictResolveWait, int autoReplicaFailoverWaitAfterExpiration, String zkCredentialsProviderClass, String zkACLProviderClass, int createCollectionWaitTimeTillActive, boolean createCollectionCheckLeaderActive) {
        this.zkHost = zkHost;
        this.zkClientTimeout = zkClientTimeout;
        this.hostPort = hostPort;
        this.hostName = hostName;
        this.hostContext = hostContext;
        this.useGenericCoreNames = useGenericCoreNames;
        this.leaderVoteWait = leaderVoteWait;
        this.leaderConflictResolveWait = leaderConflictResolveWait;
        this.autoReplicaFailoverWaitAfterExpiration = autoReplicaFailoverWaitAfterExpiration;
        this.zkCredentialsProviderClass = zkCredentialsProviderClass;
        this.zkACLProviderClass = zkACLProviderClass;
        this.createCollectionWaitTimeTillActive = createCollectionWaitTimeTillActive;
        this.createCollectionCheckLeaderActive = createCollectionCheckLeaderActive;
        if (this.hostPort == -1) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'hostPort' must be configured to run SolrCloud");
        }
        if (this.hostContext == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'hostContext' must be configured to run SolrCloud");
        }
    }

    public String getZkHost() {
        return this.zkHost;
    }

    public int getZkClientTimeout() {
        return this.zkClientTimeout;
    }

    public int getSolrHostPort() {
        return this.hostPort;
    }

    public String getSolrHostContext() {
        return this.hostContext;
    }

    public String getHost() {
        return this.hostName;
    }

    public String getZkCredentialsProviderClass() {
        return this.zkCredentialsProviderClass;
    }

    public String getZkACLProviderClass() {
        return this.zkACLProviderClass;
    }

    public int getLeaderVoteWait() {
        return this.leaderVoteWait;
    }

    public int getLeaderConflictResolveWait() {
        return this.leaderConflictResolveWait;
    }

    public int getAutoReplicaFailoverWaitAfterExpiration() {
        return this.autoReplicaFailoverWaitAfterExpiration;
    }

    public boolean getGenericCoreNodeNames() {
        return this.useGenericCoreNames;
    }

    public int getCreateCollectionWaitTimeTillActive() {
        return this.createCollectionWaitTimeTillActive;
    }

    public boolean isCreateCollectionCheckLeaderActive() {
        return this.createCollectionCheckLeaderActive;
    }

    public static class CloudConfigBuilder {
        private static final int DEFAULT_ZK_CLIENT_TIMEOUT = 45000;
        private static final int DEFAULT_LEADER_VOTE_WAIT = 180000;
        private static final int DEFAULT_LEADER_CONFLICT_RESOLVE_WAIT = 180000;
        private static final int DEFAULT_CREATE_COLLECTION_ACTIVE_WAIT = 45;
        private static final boolean DEFAULT_CREATE_COLLECTION_CHECK_LEADER_ACTIVE = false;
        private static final int DEFAULT_AUTO_REPLICA_FAILOVER_WAIT_AFTER_EXPIRATION = 120000;
        private String zkHost = System.getProperty("zkHost");
        private int zkClientTimeout = Integer.getInteger("zkClientTimeout", 45000);
        private final int hostPort;
        private final String hostName;
        private final String hostContext;
        private boolean useGenericCoreNames;
        private int leaderVoteWait = 180000;
        private int leaderConflictResolveWait = 180000;
        private int autoReplicaFailoverWaitAfterExpiration = 120000;
        private String zkCredentialsProviderClass;
        private String zkACLProviderClass;
        private int createCollectionWaitTimeTillActive = 45;
        private boolean createCollectionCheckLeaderActive = false;

        public CloudConfigBuilder(String hostName, int hostPort) {
            this(hostName, hostPort, null);
        }

        public CloudConfigBuilder(String hostName, int hostPort, String hostContext) {
            this.hostName = hostName;
            this.hostPort = hostPort;
            this.hostContext = hostContext;
        }

        public CloudConfigBuilder setZkHost(String zkHost) {
            this.zkHost = zkHost;
            return this;
        }

        public CloudConfigBuilder setZkClientTimeout(int zkClientTimeout) {
            this.zkClientTimeout = zkClientTimeout;
            return this;
        }

        public CloudConfigBuilder setUseGenericCoreNames(boolean useGenericCoreNames) {
            this.useGenericCoreNames = useGenericCoreNames;
            return this;
        }

        public CloudConfigBuilder setLeaderVoteWait(int leaderVoteWait) {
            this.leaderVoteWait = leaderVoteWait;
            return this;
        }

        public CloudConfigBuilder setLeaderConflictResolveWait(int leaderConflictResolveWait) {
            this.leaderConflictResolveWait = leaderConflictResolveWait;
            return this;
        }

        public CloudConfigBuilder setAutoReplicaFailoverWaitAfterExpiration(int autoReplicaFailoverWaitAfterExpiration) {
            this.autoReplicaFailoverWaitAfterExpiration = autoReplicaFailoverWaitAfterExpiration;
            return this;
        }

        public CloudConfigBuilder setZkCredentialsProviderClass(String zkCredentialsProviderClass) {
            this.zkCredentialsProviderClass = zkCredentialsProviderClass;
            return this;
        }

        public CloudConfigBuilder setZkACLProviderClass(String zkACLProviderClass) {
            this.zkACLProviderClass = zkACLProviderClass;
            return this;
        }

        public CloudConfigBuilder setCreateCollectionWaitTimeTillActive(int createCollectionWaitTimeTillActive) {
            this.createCollectionWaitTimeTillActive = createCollectionWaitTimeTillActive;
            return this;
        }

        public CloudConfigBuilder setCreateCollectionCheckLeaderActive(boolean createCollectionCheckLeaderActive) {
            this.createCollectionCheckLeaderActive = createCollectionCheckLeaderActive;
            return this;
        }

        public CloudConfig build() {
            return new CloudConfig(this.zkHost, this.zkClientTimeout, this.hostPort, this.hostName, this.hostContext, this.useGenericCoreNames, this.leaderVoteWait, this.leaderConflictResolveWait, this.autoReplicaFailoverWaitAfterExpiration, this.zkCredentialsProviderClass, this.zkACLProviderClass, this.createCollectionWaitTimeTillActive, this.createCollectionCheckLeaderActive);
        }
    }
}

