/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.VersionInfo;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicUpdateProcessorFactory
extends UpdateRequestProcessorFactory
implements SolrCoreAware {
    private static final String ADD = "add";
    private static final String INC = "inc";
    private static final String REMOVE = "remove";
    private static final String SET = "set";
    private static final String REMOVEREGEX = "removeregex";
    private static final String ADDDISTINCT = "add-distinct";
    private static final Set<String> VALID_OPS = new HashSet<String>(Arrays.asList("add", "inc", "remove", "set", "removeregex", "add-distinct"));
    private static final String VERSION = "_version_";
    public static final String NAME = "atomic";
    public static final String ATOMIC_FIELD_PREFIX = "atomic.";
    private static final int MAX_ATTEMPTS = 25;
    private VersionInfo vinfo;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void init(NamedList args) {
    }

    @Override
    public void inform(SolrCore core) {
        this.vinfo = core.getUpdateHandler().getUpdateLog() == null ? null : core.getUpdateHandler().getUpdateLog().getVersionInfo();
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        if (this.vinfo == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Atomic document updates are not supported unless <updateLog/> is configured");
        }
        return new AtomicUpdateProcessor(req, next);
    }

    private class AtomicUpdateProcessor
    extends UpdateRequestProcessor {
        private final SolrQueryRequest req;
        private final UpdateRequestProcessor next;

        private AtomicUpdateProcessor(SolrQueryRequest req, UpdateRequestProcessor next) {
            super(next);
            this.next = next;
            this.req = req;
        }

        @Override
        public void processAdd(AddUpdateCommand cmd) throws IOException {
            SolrInputDocument orgdoc = cmd.getSolrInputDocument();
            boolean isAtomicUpdateAddedByMe = false;
            Iterator paramsIterator = this.req.getParams().getParameterNamesIterator();
            while (paramsIterator.hasNext()) {
                String param = (String)paramsIterator.next();
                if (!param.startsWith(AtomicUpdateProcessorFactory.ATOMIC_FIELD_PREFIX)) continue;
                String field = param.substring(AtomicUpdateProcessorFactory.ATOMIC_FIELD_PREFIX.length(), param.length());
                String operation = this.req.getParams().get(param);
                if (!VALID_OPS.contains(operation)) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected param(s) for AtomicUpdateProcessor, invalid atomic op passed: '" + this.req.getParams().get(param) + "'");
                }
                if (orgdoc.get((Object)field) == null || orgdoc.get((Object)field).getValue() instanceof Map) continue;
                orgdoc.setField(field, Collections.singletonMap(operation, orgdoc.get((Object)field).getValue()));
                isAtomicUpdateAddedByMe = true;
            }
            if (isAtomicUpdateAddedByMe) {
                Long lastVersion = AtomicUpdateProcessorFactory.this.vinfo.lookupVersion(cmd.getIndexedId());
                lastVersion = lastVersion == null ? -1L : lastVersion;
                orgdoc.setField(AtomicUpdateProcessorFactory.VERSION, (Object)lastVersion);
                this.processAddWithRetry(cmd, 1, cmd.getSolrInputDocument().deepCopy());
            } else {
                super.processAdd(cmd);
            }
        }

        private void processAddWithRetry(AddUpdateCommand cmd, int attempts, SolrInputDocument clonedOriginalDoc) throws IOException {
            block3: {
                try {
                    super.processAdd(cmd);
                }
                catch (SolrException e) {
                    if (attempts++ >= 25) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Atomic update failed after multiple attempts due to " + e.getMessage());
                    }
                    if (e.code() != SolrException.ErrorCode.CONFLICT.code) break block3;
                    log.warn("Atomic update failed due to " + e.getMessage() + " Retrying with new version .... (" + attempts + ")");
                    Long lastVersion = AtomicUpdateProcessorFactory.this.vinfo.lookupVersion(cmd.getIndexedId());
                    lastVersion = lastVersion == null ? -1L : lastVersion;
                    cmd.solrDoc = clonedOriginalDoc;
                    clonedOriginalDoc = clonedOriginalDoc.deepCopy();
                    cmd.solrDoc.setField(AtomicUpdateProcessorFactory.VERSION, (Object)lastVersion);
                    this.processAddWithRetry(cmd, attempts, clonedOriginalDoc);
                }
            }
        }
    }
}

