/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.calcite.config.Lex;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.ExceptionStream;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.CalciteJDBCStream;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.StreamHandler;
import org.apache.solr.handler.sql.CalciteSolrDriver;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLHandler
extends RequestHandlerBase
implements SolrCoreAware,
PermissionNameProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static String defaultZkhost = null;
    private static String defaultWorkerCollection = null;
    static final String sqlNonCloudErrorMsg = "/sql handler only works in Solr Cloud mode";
    private boolean isCloud = false;

    @Override
    public void inform(SolrCore core) {
        CoreContainer coreContainer = core.getCoreContainer();
        if (coreContainer.isZooKeeperAware()) {
            defaultZkhost = core.getCoreContainer().getZkController().getZkServerAddress();
            defaultWorkerCollection = core.getCoreDescriptor().getCollectionName();
            this.isCloud = true;
        }
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.READ_PERM;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        ModifiableSolrParams params = new ModifiableSolrParams(req.getParams());
        params = this.adjustParams((SolrParams)params);
        req.setParams((SolrParams)params);
        String sql = params.get("stmt");
        params.set("numWorkers", params.getInt("numWorkers", 1));
        params.set("workerCollection", new String[]{params.get("workerCollection", defaultWorkerCollection)});
        params.set("workerZkhost", new String[]{params.get("workerZkhost", defaultZkhost)});
        params.set("aggregationMode", new String[]{params.get("aggregationMode", "facet")});
        Object tupleStream = null;
        try {
            if (!this.isCloud) {
                throw new IllegalStateException(sqlNonCloudErrorMsg);
            }
            if (sql == null) {
                throw new Exception("stmt parameter cannot be null");
            }
            String url = "jdbc:calcitesolr:";
            Properties properties = new Properties();
            Iterator parameterNamesIterator = params.getParameterNamesIterator();
            while (parameterNamesIterator.hasNext()) {
                String param = (String)parameterNamesIterator.next();
                properties.setProperty(param, params.get(param));
            }
            properties.setProperty("lex", Lex.MYSQL.toString());
            properties.setProperty("zk", defaultZkhost);
            String driverClass = CalciteSolrDriver.class.getCanonicalName();
            boolean includeMetadata = params.getBool("includeMetadata", false);
            tupleStream = new SqlHandlerStream(url, sql, null, properties, driverClass, includeMetadata);
            tupleStream = new StreamHandler.TimerStream((TupleStream)new ExceptionStream((TupleStream)tupleStream));
            rsp.add("result-set", tupleStream);
        }
        catch (Exception e) {
            if (tupleStream != null) {
                tupleStream.close();
            }
            SolrException.log((Logger)log, (Throwable)e);
            rsp.add("result-set", (Object)new StreamHandler.DummyErrorStream(e));
        }
    }

    @Override
    public String getDescription() {
        return "SQLHandler";
    }

    public String getSource() {
        return null;
    }

    private ModifiableSolrParams adjustParams(SolrParams params) {
        ModifiableSolrParams adjustedParams = new ModifiableSolrParams();
        adjustedParams.add(params);
        adjustedParams.add("omitHeader", new String[]{"true"});
        return adjustedParams;
    }

    private static class SqlHandlerStream
    extends CalciteJDBCStream {
        private final boolean includeMetadata;
        private boolean firstTuple = true;
        List<String> metadataFields = new ArrayList<String>();
        Map<String, String> metadataAliases = new HashMap<String, String>();

        SqlHandlerStream(String connectionUrl, String sqlQuery, StreamComparator definedSort, Properties connectionProperties, String driverClassName, boolean includeMetadata) throws IOException {
            super(connectionUrl, sqlQuery, definedSort, connectionProperties, driverClassName);
            this.includeMetadata = includeMetadata;
        }

        public Tuple read() throws IOException {
            if (this.firstTuple) {
                try {
                    HashMap<String, Object> fields = new HashMap<String, Object>();
                    this.firstTuple = false;
                    ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
                    for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                        String columnName = resultSetMetaData.getColumnName(i);
                        String columnLabel = resultSetMetaData.getColumnLabel(i);
                        this.metadataFields.add(columnName);
                        this.metadataAliases.put(columnName, columnLabel);
                    }
                    if (this.includeMetadata) {
                        fields.put("isMetadata", true);
                        fields.put("fields", this.metadataFields);
                        fields.put("aliases", this.metadataAliases);
                        return new Tuple(fields);
                    }
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
            Tuple tuple = super.read();
            if (!tuple.EOF) {
                tuple.fieldNames = this.metadataFields;
                tuple.fieldLabels = this.metadataAliases;
            }
            return tuple;
        }
    }
}

