/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import org.carrot2.core.attribute.Processing;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.filter.SingleLabelFilterBase;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;

@Bindable(prefix="MinLengthLabelFilter")
public class MinLengthLabelFilter
extends SingleLabelFilterBase {
    @Input
    @Processing
    @Attribute
    @Label(value="Remove short labels")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Labels")
    public boolean enabled = true;
    private static final int MIN_LENGTH = 3;

    @Override
    public boolean acceptPhrase(PreprocessingContext context, int phraseIndex) {
        int length;
        int[] wordIndices = context.allPhrases.wordIndices[phraseIndex];
        char[][] wordImage = context.allWords.image;
        int wordIndex = 0;
        for (length = wordImage[wordIndices[wordIndex++]].length; length < 3 && wordIndex < wordIndices.length; length += wordImage[wordIndices[wordIndex]].length + 1, ++wordIndex) {
        }
        return length >= 3;
    }

    @Override
    public boolean acceptWord(PreprocessingContext context, int wordIndex) {
        return context.allWords.image[wordIndex].length >= 3;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

