/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.entity.plan;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.loader.plan.build.internal.AbstractLoadPlanBuildingAssociationVisitationStrategy;
import org.hibernate.loader.plan.build.internal.FetchGraphLoadPlanBuildingStrategy;
import org.hibernate.loader.plan.build.internal.FetchStyleLoadPlanBuildingAssociationVisitationStrategy;
import org.hibernate.loader.plan.build.internal.LoadGraphLoadPlanBuildingStrategy;
import org.hibernate.loader.plan.build.spi.MetamodelDrivenLoadPlanBuilder;
import org.hibernate.loader.plan.exec.internal.AbstractLoadPlanBasedLoader;
import org.hibernate.loader.plan.exec.internal.BatchingLoadQueryDetailsFactory;
import org.hibernate.loader.plan.exec.query.spi.QueryBuildingParameters;
import org.hibernate.loader.plan.exec.spi.LoadQueryDetails;
import org.hibernate.loader.plan.spi.LoadPlan;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;

public abstract class AbstractLoadPlanBasedEntityLoader
extends AbstractLoadPlanBasedLoader
implements UniqueEntityLoader {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(AbstractLoadPlanBasedEntityLoader.class);
    private final OuterJoinLoadable entityPersister;
    private final Type uniqueKeyType;
    private final String entityName;
    private final LoadQueryDetails staticLoadQuery;

    public AbstractLoadPlanBasedEntityLoader(OuterJoinLoadable entityPersister, SessionFactoryImplementor factory, String[] uniqueKeyColumnNames, Type uniqueKeyType, QueryBuildingParameters buildingParameters) {
        super(factory);
        this.entityPersister = entityPersister;
        this.uniqueKeyType = uniqueKeyType;
        this.entityName = entityPersister.getEntityName();
        AbstractLoadPlanBuildingAssociationVisitationStrategy strategy = buildingParameters.getQueryInfluencers().getFetchGraph() != null ? new FetchGraphLoadPlanBuildingStrategy(factory, buildingParameters.getQueryInfluencers(), buildingParameters.getLockMode()) : (buildingParameters.getQueryInfluencers().getLoadGraph() != null ? new LoadGraphLoadPlanBuildingStrategy(factory, buildingParameters.getQueryInfluencers(), buildingParameters.getLockMode()) : new FetchStyleLoadPlanBuildingAssociationVisitationStrategy(factory, buildingParameters.getQueryInfluencers(), buildingParameters.getLockMode()));
        LoadPlan plan = MetamodelDrivenLoadPlanBuilder.buildRootEntityLoadPlan(strategy, entityPersister);
        this.staticLoadQuery = BatchingLoadQueryDetailsFactory.makeEntityLoadQueryDetails(plan, uniqueKeyColumnNames, buildingParameters, factory);
    }

    @Override
    protected LoadQueryDetails getStaticLoadQuery() {
        return this.staticLoadQuery;
    }

    protected String getEntityName() {
        return this.entityName;
    }

    public final List loadEntityBatch(SessionImplementor session, Serializable[] ids, Type idType, Object optionalObject, String optionalEntityName, Serializable optionalId, EntityPersister persister, LockOptions lockOptions) throws HibernateException {
        List result;
        if (log.isDebugEnabled()) {
            log.debugf("Batch loading entity: %s", (Object)MessageHelper.infoString(persister, ids, this.getFactory()));
        }
        Object[] types = new Type[ids.length];
        Arrays.fill(types, idType);
        try {
            QueryParameters qp = new QueryParameters();
            qp.setPositionalParameterTypes((Type[])types);
            qp.setPositionalParameterValues(ids);
            qp.setLockOptions(lockOptions);
            result = this.executeLoad(session, qp, this.staticLoadQuery, false, null);
        }
        catch (SQLException sqle) {
            throw this.getFactory().getSQLExceptionHelper().convert(sqle, "could not load an entity batch: " + MessageHelper.infoString((EntityPersister)this.entityPersister, ids, this.getFactory()), this.staticLoadQuery.getSqlStatement());
        }
        log.debug("Done entity batch load");
        return result;
    }

    @Override
    @Deprecated
    public Object load(Serializable id, Object optionalObject, SessionImplementor session) throws HibernateException {
        return this.load(id, optionalObject, session, LockOptions.NONE);
    }

    @Override
    public Object load(Serializable id, Object optionalObject, SessionImplementor session, LockOptions lockOptions) {
        Object result;
        try {
            QueryParameters qp = new QueryParameters();
            qp.setPositionalParameterTypes(new Type[]{this.entityPersister.getIdentifierType()});
            qp.setPositionalParameterValues(new Object[]{id});
            qp.setOptionalObject(optionalObject);
            qp.setOptionalEntityName(this.entityPersister.getEntityName());
            qp.setOptionalId(id);
            qp.setLockOptions(lockOptions);
            List results = this.executeLoad(session, qp, this.staticLoadQuery, false, null);
            result = this.extractEntityResult(results);
        }
        catch (SQLException sqle) {
            throw this.getFactory().getSQLExceptionHelper().convert(sqle, "could not load an entity: " + MessageHelper.infoString(this.entityPersister, id, this.entityPersister.getIdentifierType(), this.getFactory()), this.staticLoadQuery.getSqlStatement());
        }
        log.debugf("Done entity load : %s#%s", (Object)this.getEntityName(), (Object)id);
        return result;
    }

    protected Object extractEntityResult(List results) {
        if (results.size() == 0) {
            return null;
        }
        if (results.size() == 1) {
            return results.get(0);
        }
        Object row = results.get(0);
        if (row.getClass().isArray()) {
            Object[] rowArray = (Object[])row;
            if (rowArray.length == 1) {
                return rowArray[0];
            }
        } else {
            return row;
        }
        throw new HibernateException("Unable to interpret given query results in terms of a load-entity query");
    }

    @Override
    protected int[] getNamedParameterLocs(String name) {
        throw new AssertionFailure("no named parameters");
    }

    @Override
    protected void autoDiscoverTypes(ResultSet rs) {
        throw new AssertionFailure("Auto discover types not supported in this loader");
    }
}

