/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.packet;

import java.io.Serializable;
import net.jradius.exception.UnknownAttributeException;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.packet.attribute.value.AttributeValue;

public abstract class RadiusPacket
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final int MIN_PACKET_LENGTH = 20;
    public static final int MAX_PACKET_LENGTH = 4096;
    public static final short RADIUS_HEADER_LENGTH = 20;
    private static Object nextPacketIdLock = new Object();
    private static int nextPacketId = 1;
    protected int code;
    protected int identifier = -1;
    protected byte[] authenticator;
    protected final AttributeList attributes = new AttributeList();
    protected boolean recyclable;
    protected boolean recycled;

    public RadiusPacket() {
    }

    public RadiusPacket(AttributeList list) {
        if (list != null) {
            this.attributes.copy(list, this.recyclable);
        }
    }

    public void setCode(int code) {
        this.code = (byte)code;
    }

    public int getCode() {
        return this.code;
    }

    public void addAttribute(RadiusAttribute attribute) {
        if (null != attribute) {
            this.attributes.add(attribute, false);
        }
    }

    public void overwriteAttribute(RadiusAttribute attribute) {
        if (null != attribute) {
            this.attributes.add(attribute, true);
        }
    }

    public void addAttributes(AttributeList list) {
        this.attributes.add(list);
    }

    public void removeAttribute(RadiusAttribute attribute) {
        this.attributes.remove(attribute);
    }

    public void removeAttribute(long attributeType) {
        this.attributes.remove(attributeType);
    }

    public int getIdentifier() {
        if (this.identifier < 0) {
            this.identifier = RadiusPacket.getNewPacketId();
        }
        return this.identifier;
    }

    public void setIdentifier(int i) {
        this.identifier = i;
    }

    public AttributeList getAttributes() {
        return this.attributes;
    }

    public byte[] createAuthenticator(byte[] attributes, int offset, int attributsLength, String sharedSecret) {
        return new byte[16];
    }

    public boolean verifyAuthenticator(String sharedSecret) {
        return false;
    }

    public void setAuthenticator(byte[] authenticator) {
        this.authenticator = authenticator;
    }

    public byte[] getAuthenticator() {
        return this.authenticator;
    }

    public byte[] getAuthenticator(byte[] attributes, String sharedSecret) {
        if (this.authenticator == null) {
            this.authenticator = sharedSecret != null ? this.createAuthenticator(attributes, 0, attributes.length, sharedSecret) : new byte[16];
        }
        return this.authenticator;
    }

    public byte[] getAuthenticator(byte[] attributes, int offset, int attributesLength, String sharedSecret) {
        if (this.authenticator == null) {
            this.authenticator = sharedSecret != null ? this.createAuthenticator(attributes, offset, attributesLength, sharedSecret) : new byte[16];
        }
        return this.authenticator;
    }

    public RadiusAttribute findAttribute(long type) {
        return this.attributes.get(type);
    }

    public Object[] findAttributes(long type) {
        return this.attributes.getArray(type);
    }

    public RadiusAttribute findAttribute(String aName) throws UnknownAttributeException {
        return this.attributes.get(aName);
    }

    public Object getAttributeValue(long type) {
        return this.attributes.getValue(type);
    }

    public Object getAttributeValue(String aName) throws UnknownAttributeException {
        AttributeValue value;
        RadiusAttribute attribute = this.findAttribute(aName);
        if (attribute != null && (value = attribute.getValue()) != null) {
            return value.getValueObject();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getNewPacketId() {
        Object object = nextPacketIdLock;
        synchronized (object) {
            nextPacketId = (nextPacketId + 1) % 255;
            return nextPacketId;
        }
    }

    public String toString(boolean nonStandardAtts, boolean unknownAttrs) {
        StringBuffer sb = new StringBuffer();
        sb.append("Class: ").append(this.getClass().toString()).append("\n");
        sb.append("Attributes:\n");
        sb.append(this.attributes.toString(nonStandardAtts, unknownAttrs));
        return sb.toString();
    }

    public String toString() {
        return this.toString(true, true);
    }

    public boolean isRecyclable() {
        return this.recyclable;
    }
}

