/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.packet;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.jradius.packet.Format;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.packet.attribute.VSAttribute;
import net.jradius.packet.attribute.value.AttributeValue;

public class DiameterFormat
extends Format {
    private static final byte AVP_VENDOR = -128;

    public void packAttribute(ByteBuffer buffer, RadiusAttribute a) {
        AttributeValue attributeValue = a.getValue();
        int length = attributeValue.getLength();
        int padding = (length + 3 & 0xFFFFFFFC) - length;
        this.packHeader(buffer, a);
        attributeValue.getBytes(buffer);
        while (padding-- > 0) {
            DiameterFormat.putUnsignedByte(buffer, 0);
        }
    }

    public void packHeader(ByteBuffer buffer, RadiusAttribute a) {
        if (a instanceof VSAttribute) {
            this.packHeader(buffer, (VSAttribute)a);
            return;
        }
        AttributeValue attributeValue = a.getValue();
        DiameterFormat.putUnsignedInt(buffer, a.getType());
        DiameterFormat.putUnsignedByte(buffer, 0);
        DiameterFormat.putUnsignedByte(buffer, 0);
        DiameterFormat.putUnsignedShort(buffer, attributeValue.getLength() + 8);
    }

    public void packHeader(ByteBuffer buffer, VSAttribute a) {
        AttributeValue attributeValue = a.getValue();
        DiameterFormat.putUnsignedInt(buffer, a.getVsaAttributeType());
        DiameterFormat.putUnsignedByte(buffer, -128);
        DiameterFormat.putUnsignedByte(buffer, 0);
        DiameterFormat.putUnsignedShort(buffer, attributeValue.getLength() + 12);
        DiameterFormat.putUnsignedInt(buffer, a.getVendorId());
    }

    public void unpackAttributeHeader(ByteBuffer buffer, Format.AttributeParseContext ctx) throws IOException {
        ctx.attributeType = (int)DiameterFormat.getUnsignedInt(buffer);
        short flags = DiameterFormat.getUnsignedByte(buffer);
        DiameterFormat.getUnsignedByte(buffer);
        ctx.attributeLength = DiameterFormat.getUnsignedShort(buffer);
        ctx.headerLength = 8;
        if ((flags & 0xFFFFFF80) > 0) {
            ctx.vendorNumber = (int)DiameterFormat.getUnsignedInt(buffer);
            ctx.headerLength += 4;
        }
        ctx.padding = (int)((ctx.attributeLength + 3L & 0xFFFFFFFFFFFFFFFCL) - ctx.attributeLength);
    }
}

