/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.List;
import org.jd.core.v1.model.classfile.ClassFile;
import org.jd.core.v1.model.classfile.Method;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.AnnotationDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ClassDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ConstructorDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.EnumDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.InterfaceDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.MethodDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.StaticInitializerDeclaration;
import org.jd.core.v1.model.javasyntax.statement.ByteCodeStatement;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.ControlFlowGraph;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorOrMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ByteCodeWriter;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ControlFlowGraphGotoReducer;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ControlFlowGraphLoopReducer;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ControlFlowGraphMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ControlFlowGraphReducer;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.LocalVariableMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ObjectTypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.SignatureParser;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.StatementMaker;

public class CreateInstructionsVisitor
extends AbstractJavaSyntaxVisitor {
    protected ObjectTypeMaker objectTypeMaker;
    protected SignatureParser signatureParser;

    public CreateInstructionsVisitor(ObjectTypeMaker objectTypeMaker, SignatureParser signatureParser) {
        this.objectTypeMaker = objectTypeMaker;
        this.signatureParser = signatureParser;
    }

    @Override
    public void visit(AnnotationDeclaration declaration) {
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(BodyDeclaration declaration) {
        ClassFileBodyDeclaration bodyDeclaration = (ClassFileBodyDeclaration)declaration;
        List<ClassFileConstructorOrMethodDeclaration> methods = bodyDeclaration.getMethodDeclarations();
        if (methods != null) {
            block0: for (ClassFileConstructorOrMethodDeclaration method : methods) {
                if ((method.getFlags() & 0x1040) != 0) {
                    method.accept(this);
                    continue;
                }
                if ((method.getFlags() & 0x48) == 8) {
                    if (!method.getMethod().getName().startsWith("access$")) continue;
                    method.setFlags(method.getFlags() | 0x40);
                    method.accept(this);
                    continue;
                }
                if (method.getParameterTypes() == null) continue;
                for (Type type : method.getParameterTypes()) {
                    if (!type.isObject() || ((ObjectType)type).getName() != null) continue;
                    method.setFlags(method.getFlags() | 0x1000);
                    method.accept(this);
                    continue block0;
                }
            }
            for (ClassFileConstructorOrMethodDeclaration method : methods) {
                if ((method.getFlags() & 0x1040) != 0) continue;
                method.accept(this);
            }
        }
    }

    @Override
    public void visit(FieldDeclaration declaration) {
    }

    @Override
    public void visit(ConstructorDeclaration declaration) {
        ClassFileConstructorOrMethodDeclaration comdwln = (ClassFileConstructorOrMethodDeclaration)((Object)declaration);
        LocalVariableMaker localVariableMaker = new LocalVariableMaker(this.objectTypeMaker, this.signatureParser, comdwln, true, comdwln.getParameterTypes(), null);
        this.createParametersVariablesAndStatements(comdwln, localVariableMaker);
    }

    @Override
    public void visit(MethodDeclaration declaration) {
        ClassFileConstructorOrMethodDeclaration comdwln = (ClassFileConstructorOrMethodDeclaration)((Object)declaration);
        LocalVariableMaker localVariableMaker = new LocalVariableMaker(this.objectTypeMaker, this.signatureParser, comdwln, false, comdwln.getParameterTypes(), comdwln.getReturnedType());
        this.createParametersVariablesAndStatements(comdwln, localVariableMaker);
    }

    @Override
    public void visit(StaticInitializerDeclaration declaration) {
        ClassFileConstructorOrMethodDeclaration comdwln = (ClassFileConstructorOrMethodDeclaration)((Object)declaration);
        LocalVariableMaker localVariableMaker = new LocalVariableMaker(this.objectTypeMaker, this.signatureParser, comdwln, false, null, null);
        this.createParametersVariablesAndStatements(comdwln, localVariableMaker);
    }

    protected void createParametersVariablesAndStatements(ClassFileConstructorOrMethodDeclaration comdwln, LocalVariableMaker localVariableMaker) {
        ClassFile classFile = comdwln.getClassFile();
        ClassFileBodyDeclaration bodyDeclaration = comdwln.getBodyDeclaration();
        Method method = comdwln.getMethod();
        Type returnedType = comdwln.getReturnedType();
        StatementMaker statementMaker = new StatementMaker(this.objectTypeMaker, this.signatureParser, localVariableMaker, classFile, bodyDeclaration, returnedType);
        try {
            ControlFlowGraph cfg = ControlFlowGraphMaker.make(method);
            if (cfg != null) {
                ControlFlowGraphGotoReducer.reduce(cfg);
                ControlFlowGraphLoopReducer.reduce(cfg);
                if (ControlFlowGraphReducer.reduce(cfg)) {
                    comdwln.setStatements(statementMaker.make(cfg));
                } else {
                    comdwln.setStatements(new ByteCodeStatement(ByteCodeWriter.write("// ", method)));
                }
            }
        }
        catch (Exception e) {
            assert (ExceptionUtil.printStackTrace(e));
            comdwln.setStatements(new ByteCodeStatement(ByteCodeWriter.write("// ", method)));
        }
        if ((classFile.getAccessFlags() & 0x200) != 0) {
            comdwln.setFlags(comdwln.getFlags() & 0xFFFFFBFE);
        }
        localVariableMaker.make();
        comdwln.setFormalParameters(localVariableMaker.getFormalParameters());
    }

    @Override
    public void visit(ClassDeclaration declaration) {
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(EnumDeclaration declaration) {
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(InterfaceDeclaration declaration) {
        this.safeAccept(declaration.getBodyDeclaration());
    }
}

