/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable;

import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.LocalVariableVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.PrimitiveTypeUtil;

public class PrimitiveLocalVariable
extends AbstractLocalVariable {
    protected int flags;

    public PrimitiveLocalVariable(int index, int offset, String descriptor, String name) {
        super(index, offset, name, 0);
        assert (descriptor.charAt(0) != '[');
        this.flags = PrimitiveTypeUtil.getPrimitiveTypeFromDescriptor(descriptor).getFlags();
    }

    public PrimitiveLocalVariable(int index, int offset, PrimitiveType type, String name) {
        super(index, offset, name, 0);
        assert (type.getDimension() == 0);
        this.flags = type.getFlags();
    }

    public PrimitiveLocalVariable(int index, int offset, PrimitiveType type) {
        super(index, offset, 0);
        assert (type.getDimension() == 0);
        this.flags = type.getFlags();
    }

    public PrimitiveLocalVariable(int index, int offset, PrimitiveLocalVariable primitiveLocalVariable) {
        super(index, offset, 0);
        assert (primitiveLocalVariable.getDimension() == 0);
        int valueFlags = primitiveLocalVariable.flags;
        this.flags = (valueFlags & 0x40) != 0 ? valueFlags : ((valueFlags & 0x20) != 0 ? valueFlags | 0x40 : ((valueFlags & 2) != 0 ? valueFlags | 0x40 | 0x20 : ((valueFlags & 0x10) != 0 ? valueFlags | 0x40 | 0x20 : valueFlags)));
    }

    @Override
    public Type getType() {
        return PrimitiveTypeUtil.getPrimitiveType(this.flags, this.dimension);
    }

    @Override
    public boolean isAssignable(AbstractLocalVariable other) {
        if (other.getDimension() == 0 && other.getClass() == PrimitiveLocalVariable.class) {
            if (this.dimension == 0) {
                return (this.flags & ((PrimitiveLocalVariable)other).flags) != 0;
            }
            return this.flags == ((PrimitiveLocalVariable)other).flags;
        }
        return false;
    }

    @Override
    public boolean isAssignable(Type otherType) {
        if (otherType.getDimension() == 0 && otherType.isPrimitive()) {
            return (this.flags & ((PrimitiveType)otherType).getRightFlags()) != 0;
        }
        return false;
    }

    @Override
    public void leftReduce(AbstractLocalVariable other) {
        assert (other.getDimension() == 0);
        int otherFlags = ((PrimitiveLocalVariable)other).flags;
        int newFalgs = 0;
        if ((otherFlags & 0x10) != 0) {
            newFalgs |= 0x70;
        }
        if ((otherFlags & 2) != 0) {
            newFalgs |= 0x42;
        }
        if ((otherFlags & 0x20) != 0) {
            newFalgs |= 0x60;
        }
        if ((otherFlags & 0x40) != 0) {
            newFalgs |= 0x40;
        }
        if ((this.flags & newFalgs) != 0) {
            this.flags &= newFalgs;
        }
    }

    @Override
    public void rightReduce(AbstractLocalVariable other) {
        assert (other.getDimension() == 0);
        int otherFlags = ((PrimitiveLocalVariable)other).flags;
        int newFalgs = 0;
        if ((otherFlags & 0x40) != 0) {
            newFalgs |= 0x40;
        }
        if ((otherFlags & 0x20) != 0) {
            newFalgs |= 0x30;
        }
        if ((otherFlags & 2) != 0) {
            newFalgs |= 2;
        }
        if ((otherFlags & 0x10) != 0) {
            newFalgs |= 0x10;
        }
        if ((this.flags & newFalgs) != 0) {
            this.flags &= newFalgs;
        }
    }

    @Override
    public void leftReduce(Type otherType) {
        this.flags &= ((PrimitiveType)otherType).getRightFlags();
        assert (otherType.getDimension() == 0 && this.flags != 0);
    }

    @Override
    public void rightReduce(Type otherType) {
        this.flags &= ((PrimitiveType)otherType).getLeftFlags();
        assert (otherType.getDimension() == 0 && this.flags != 0) : "rightReduce : incompatible types";
    }

    @Override
    public void accept(LocalVariableVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PrimitiveLocalVariable{");
        if ((this.flags & 1) != 0) {
            sb.append("boolean ");
        }
        if ((this.flags & 2) != 0) {
            sb.append("char ");
        }
        if ((this.flags & 4) != 0) {
            sb.append("float ");
        }
        if ((this.flags & 8) != 0) {
            sb.append("double ");
        }
        if ((this.flags & 0x10) != 0) {
            sb.append("byte ");
        }
        if ((this.flags & 0x20) != 0) {
            sb.append("short ");
        }
        if ((this.flags & 0x40) != 0) {
            sb.append("int ");
        }
        if ((this.flags & 0x80) != 0) {
            sb.append("long ");
        }
        if ((this.flags & 0x100) != 0) {
            sb.append("void ");
        }
        sb.append(this.name).append(", index=").append(this.index);
        if (this.next != null) {
            sb.append(", next=").append(this.next);
        }
        return sb.append("}").toString();
    }
}

