/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.RawDexFile;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;
import org.jf.util.StringUtils;

public class StringIdItem {
    public static final int ITEM_SIZE = 4;

    @Nonnull
    public static SectionAnnotator makeAnnotator(@Nonnull DexAnnotator annotator, @Nonnull MapItem mapItem) {
        return new SectionAnnotator(annotator, mapItem){

            @Override
            @Nonnull
            public String getItemName() {
                return "string_id_item";
            }

            @Override
            public void annotateItem(@Nonnull AnnotatedBytes out, int itemIndex, @Nullable String itemIdentity) {
                int stringDataOffset = this.dexFile.readSmallUint(out.getCursor());
                try {
                    String stringValue = this.dexFile.getString(itemIndex);
                    out.annotate(4, "string_data_item[0x%x]: \"%s\"", stringDataOffset, StringUtils.escapeString(stringValue));
                    return;
                }
                catch (Exception ex) {
                    System.err.print("Error while resolving string value at index: ");
                    System.err.print(itemIndex);
                    ex.printStackTrace(System.err);
                    out.annotate(4, "string_id_item[0x%x]", stringDataOffset);
                    return;
                }
            }
        };
    }

    @Nonnull
    public static String getReferenceAnnotation(@Nonnull DexBackedDexFile dexFile, int stringIndex) {
        return StringIdItem.getReferenceAnnotation(dexFile, stringIndex, false);
    }

    public static String getReferenceAnnotation(@Nonnull DexBackedDexFile dexFile, int stringIndex, boolean quote) {
        try {
            String string = dexFile.getString(stringIndex);
            if (quote) {
                string = String.format("\"%s\"", StringUtils.escapeString(string));
            }
            return String.format("string_id_item[%d]: %s", stringIndex, string);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return String.format("string_id_item[%d]", stringIndex);
        }
    }

    @Nonnull
    public static String getOptionalReferenceAnnotation(@Nonnull DexBackedDexFile dexFile, int stringIndex) {
        return StringIdItem.getOptionalReferenceAnnotation(dexFile, stringIndex, false);
    }

    public static String getOptionalReferenceAnnotation(@Nonnull DexBackedDexFile dexFile, int stringIndex, boolean quote) {
        if (stringIndex == -1) {
            return "string_id_item[NO_INDEX]";
        }
        return StringIdItem.getReferenceAnnotation(dexFile, stringIndex, quote);
    }

    public static String[] getStrings(@Nonnull RawDexFile dexFile) {
        MapItem mapItem = dexFile.getMapItemForSection(1);
        if (mapItem == null) {
            return new String[0];
        }
        int stringCount = mapItem.getItemCount();
        String[] ret = new String[stringCount];
        for (int i = 0; i < stringCount; ++i) {
            ret[i] = dexFile.getString(i);
        }
        return ret;
    }
}

