/*
 * Decompiled with CFR 0.152.
 */
package org.jf.smali;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.writer.builder.DexBuilder;
import org.jf.dexlib2.writer.io.DexDataStore;
import org.jf.dexlib2.writer.io.FileDataStore;
import org.jf.smali.SmaliOptions;
import org.jf.smali.smaliFlexLexer;
import org.jf.smali.smaliParser;
import org.jf.smali.smaliTreeWalker;

public class Smali {
    public static boolean assemble(SmaliOptions options, String ... input) throws IOException {
        return Smali.assemble(options, Arrays.asList(input));
    }

    public static boolean assemble(final SmaliOptions options, List<String> input) throws IOException {
        TreeSet<File> filesToProcessSet = new TreeSet<File>();
        for (String fileToProcess : input) {
            File argFile = new File(fileToProcess);
            if (!argFile.exists()) {
                throw new IllegalArgumentException("Cannot find file or directory \"" + fileToProcess + "\"");
            }
            if (argFile.isDirectory()) {
                Smali.getSmaliFilesInDir(argFile, filesToProcessSet);
                continue;
            }
            if (!argFile.isFile()) continue;
            filesToProcessSet.add(argFile);
        }
        boolean errors = false;
        final DexBuilder dexBuilder = new DexBuilder(Opcodes.forApi((int)options.apiLevel));
        ExecutorService executor = Executors.newFixedThreadPool(options.jobs);
        ArrayList tasks = Lists.newArrayList();
        for (final File file : filesToProcessSet) {
            tasks.add(executor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return Smali.assembleSmaliFile(file, dexBuilder, options);
                }
            }));
        }
        block6: for (Future task : tasks) {
            while (true) {
                try {
                    try {
                        if (((Boolean)task.get()).booleanValue()) continue block6;
                        errors = true;
                        continue block6;
                    }
                    catch (ExecutionException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                catch (InterruptedException ex) {
                    continue;
                }
                break;
            }
        }
        executor.shutdown();
        if (errors) {
            return false;
        }
        dexBuilder.writeTo((DexDataStore)new FileDataStore(new File(options.outputDexFile)));
        return true;
    }

    private static void getSmaliFilesInDir(@Nonnull File dir, @Nonnull Set<File> smaliFiles) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    Smali.getSmaliFilesInDir(file, smaliFiles);
                    continue;
                }
                if (!file.getName().endsWith(".smali")) continue;
                smaliFiles.add(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean assembleSmaliFile(File smaliFile, DexBuilder dexBuilder, SmaliOptions options) throws Exception {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(smaliFile);
            InputStreamReader reader = new InputStreamReader((InputStream)fis, "UTF-8");
            smaliFlexLexer lexer = new smaliFlexLexer(reader);
            lexer.setSourceFile(smaliFile);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            if (options.printTokens) {
                tokens.getTokens();
                for (int i = 0; i < tokens.size(); ++i) {
                    Token token = tokens.get(i);
                    if (token.getChannel() == 99) continue;
                    System.out.println(smaliParser.tokenNames[token.getType()] + ": " + token.getText());
                }
                System.out.flush();
            }
            smaliParser parser = new smaliParser((TokenStream)tokens);
            parser.setVerboseErrors(options.verboseErrors);
            parser.setAllowOdex(options.allowOdexOpcodes);
            parser.setApiLevel(options.apiLevel);
            smaliParser.smali_file_return result = parser.smali_file();
            if (parser.getNumberOfSyntaxErrors() > 0 || lexer.getNumberOfSyntaxErrors() > 0) {
                boolean bl = false;
                return bl;
            }
            CommonTree t = result.getTree();
            CommonTreeNodeStream treeStream = new CommonTreeNodeStream((Object)t);
            treeStream.setTokenStream((TokenStream)tokens);
            if (options.printTokens) {
                System.out.println(t.toStringTree());
            }
            smaliTreeWalker dexGen = new smaliTreeWalker((TreeNodeStream)treeStream);
            dexGen.setApiLevel(options.apiLevel);
            dexGen.setVerboseErrors(options.verboseErrors);
            dexGen.setDexBuilder(dexBuilder);
            dexGen.smali_file();
            boolean bl = dexGen.getNumberOfSyntaxErrors() == 0;
            return bl;
        }
    }
}

