/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.logs;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import jadx.gui.utils.logs.ILogListener;
import jadx.gui.utils.logs.LogEvent;
import java.util.Deque;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

public class LogCollector
extends AppenderBase<ILoggingEvent> {
    public static final int BUFFER_SIZE = 5000;
    private static final LogCollector INSTANCE = new LogCollector();
    private Layout<ILoggingEvent> layout;
    @Nullable
    private ILogListener listener;
    private final Deque<LogEvent> buffer = new LinkedList<LogEvent>();

    public static LogCollector getInstance() {
        return INSTANCE;
    }

    public static void register() {
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        LoggerContext loggerContext = rootLogger.getLoggerContext();
        PatternLayout layout = new PatternLayout();
        layout.setContext((Context)loggerContext);
        layout.setPattern("%-5level: %msg%n");
        layout.start();
        INSTANCE.setContext((Context)loggerContext);
        INSTANCE.setLayout((Layout<ILoggingEvent>)layout);
        INSTANCE.start();
        rootLogger.addAppender((Appender)INSTANCE);
    }

    public LogCollector() {
        this.setName("LogCollector");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(ILoggingEvent event) {
        LogCollector logCollector = this;
        synchronized (logCollector) {
            Level level = event.getLevel();
            String msg = this.layout.doLayout((Object)event);
            this.store(level, msg);
            if (this.listener != null && level.isGreaterOrEqual(this.listener.getFilterLevel())) {
                this.listener.onAppend(msg);
            }
        }
    }

    private void store(Level level, String msg) {
        this.buffer.addLast(new LogEvent(level, msg));
        if (this.buffer.size() > 5000) {
            this.buffer.pollFirst();
        }
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(@NotNull ILogListener listener) {
        this.listener = listener;
        LogCollector logCollector = this;
        synchronized (logCollector) {
            listener.onAppend(this.init(listener.getFilterLevel()));
        }
    }

    public void resetListener() {
        this.listener = null;
    }

    private String init(Level filterLevel) {
        StringBuilder sb = new StringBuilder();
        for (LogEvent event : this.buffer) {
            if (!event.getLevel().isGreaterOrEqual(filterLevel)) continue;
            sb.append(event.getMsg());
        }
        return sb.toString();
    }
}

