(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/srfi/19#time-tai 'time-tai)
  (define std/srfi/19#time-utc 'time-utc)
  (define std/srfi/19#time-monotonic 'time-monotonic)
  (define std/srfi/19#time-thread 'time-thread)
  (define std/srfi/19#time-process 'time-process)
  (define std/srfi/19#time-duration 'time-duration)
  (define std/srfi/19#tm:locale-number-separator '".")
  (define std/srfi/19#tm:locale-abbr-weekday-vector
    (vector '"Sun" '"Mon" '"Tue" '"Wed" '"Thu" '"Fri" '"Sat"))
  (define std/srfi/19#tm:locale-long-weekday-vector
    (vector '"Sunday"
            '"Monday"
            '"Tuesday"
            '"Wednesday"
            '"Thursday"
            '"Friday"
            '"Saturday"))
  (define std/srfi/19#tm:locale-abbr-month-vector
    (vector '""
            '"Jan"
            '"Feb"
            '"Mar"
            '"Apr"
            '"May"
            '"Jun"
            '"Jul"
            '"Aug"
            '"Sep"
            '"Oct"
            '"Nov"
            '"Dec"))
  (define std/srfi/19#tm:locale-long-month-vector
    (vector '""
            '"January"
            '"February"
            '"March"
            '"April"
            '"May"
            '"June"
            '"July"
            '"August"
            '"September"
            '"October"
            '"November"
            '"December"))
  (define std/srfi/19#tm:locale-pm '"PM")
  (define std/srfi/19#tm:locale-am '"AM")
  (define std/srfi/19#tm:locale-date-time-format '"~a ~b ~d ~H:~M:~S~z ~Y")
  (define std/srfi/19#tm:locale-short-date-format '"~m/~d/~y")
  (define std/srfi/19#tm:locale-time-format '"~H:~M:~S")
  (define std/srfi/19#tm:iso-8601-date-time-format '"~Y-~m-~dT~H:~M:~S~z")
  (define std/srfi/19#tm:nano (expt '10 '9))
  (define std/srfi/19#tm:sid '86400)
  (define std/srfi/19#tm:sihd '43200)
  (define std/srfi/19#tm:tai-epoch-in-jd '4881175/2)
  (define std/srfi/19#tm:time-error-types
    '(invalid-clock-type
      unsupported-clock-type
      incompatible-time-types
      not-duration
      dates-are-immutable
      bad-date-format-string
      bad-date-template-string
      invalid-month-specification))
  (define std/srfi/19#tm:time-error
    (lambda (_caller21767_ _type21768_ _value21769_)
      (if (member _type21768_ std/srfi/19#tm:time-error-types)
          (if _value21769_
              (error '"TIME-ERROR type" _caller21767_ _type21768_ _value21769_)
              (error '"TIME-ERROR type" _caller21767_ _type21768_))
          (error '"TIME-ERROR unsupported error type"
                 _caller21767_
                 _type21768_))))
  (define std/srfi/19#tm:read-tai-utc-data
    (lambda (_filename21742_)
      (letrec ((_convert-jd21744_
                (lambda (_jd21765_)
                  (* (- (inexact->exact _jd21765_)
                        std/srfi/19#tm:tai-epoch-in-jd)
                     std/srfi/19#tm:sid)))
               (_convert-sec21745_
                (lambda (_sec21763_) (inexact->exact _sec21763_))))
        (let ((_port21747_ (open-input-file _filename21742_))
              (_table21748_ '()))
          (let _loop21750_ ((_line21752_ (read-line _port21747_)))
            (if (not (eof-object? _line21752_))
                (let* ((_data21754_
                        (read (open-input-string
                               (string-append '"(" _line21752_ '")"))))
                       (_year21756_ (car _data21754_))
                       (_jd21758_ (cadddr (cdr _data21754_)))
                       (_secs21760_ (cadddr (cdddr _data21754_))))
                  (if (>= _year21756_ '1972)
                      (set! _table21748_
                            (cons (cons (_convert-jd21744_ _jd21758_)
                                        (inexact->exact _secs21760_))
                                  _table21748_))
                      '#!void)
                  (_loop21750_ (read-line _port21747_)))
                '#!void))
          _table21748_))))
  (define std/srfi/19#tm:leap-second-table
    '((1483228800 . 37)
      (1435708800 . 36)
      (1341100800 . 35)
      (1230768000 . 34)
      (1136073600 . 33)
      (915148800 . 32)
      (867715200 . 31)
      (820454400 . 30)
      (773020800 . 29)
      (741484800 . 28)
      (709948800 . 27)
      (662688000 . 26)
      (631152000 . 25)
      (567993600 . 24)
      (489024000 . 23)
      (425865600 . 22)
      (394329600 . 21)
      (362793600 . 20)
      (315532800 . 19)
      (283996800 . 18)
      (252460800 . 17)
      (220924800 . 16)
      (189302400 . 15)
      (157766400 . 14)
      (126230400 . 13)
      (94694400 . 12)
      (78796800 . 11)
      (63072000 . 10)))
  (define std/srfi/19#read-leap-second-table
    (lambda (_filename21740_)
      (set! std/srfi/19#tm:leap-second-table
            (std/srfi/19#tm:read-tai-utc-data _filename21740_))
      '#!void))
  (define std/srfi/19#tm:leap-second-delta
    (lambda (_utc-seconds21734_)
      (letrec ((_lsd21736_
                (lambda (_table21738_)
                  (if (>= _utc-seconds21734_ (caar _table21738_))
                      (cdar _table21738_)
                      (_lsd21736_ (cdr _table21738_))))))
        (if (< _utc-seconds21734_ (* (- '1972 '1970) '365 std/srfi/19#tm:sid))
            '0
            (_lsd21736_ std/srfi/19#tm:leap-second-table)))))
  (define std/srfi/19#tm:leap-second-neg-delta
    (lambda (_tai-seconds21728_)
      (letrec ((_lsd21730_
                (lambda (_table21732_)
                  (if (null? _table21732_)
                      '0
                      (if (<= (cdar _table21732_)
                              (- _tai-seconds21728_ (caar _table21732_)))
                          (cdar _table21732_)
                          (_lsd21730_ (cdr _table21732_)))))))
        (if (< _tai-seconds21728_ (* (- '1972 '1970) '365 std/srfi/19#tm:sid))
            '0
            (_lsd21730_ std/srfi/19#tm:leap-second-table)))))
  (define std/srfi/19#time::t
    (make-struct-type
     'std/srfi/19#time::t
     '#f
     '3
     'time
     '()
     '#f
     '(type nanosecond second)))
  (define std/srfi/19#time? (make-struct-predicate std/srfi/19#time::t))
  (define std/srfi/19#make-time
    (lambda _$args21725_
      (apply make-struct-instance std/srfi/19#time::t _$args21725_)))
  (define std/srfi/19#time-type
    (make-struct-field-accessor std/srfi/19#time::t '0))
  (define std/srfi/19#time-nanosecond
    (make-struct-field-accessor std/srfi/19#time::t '1))
  (define std/srfi/19#time-second
    (make-struct-field-accessor std/srfi/19#time::t '2))
  (define std/srfi/19#time-type-set!
    (make-struct-field-mutator std/srfi/19#time::t '0))
  (define std/srfi/19#time-nanosecond-set!
    (make-struct-field-mutator std/srfi/19#time::t '1))
  (define std/srfi/19#time-second-set!
    (make-struct-field-mutator std/srfi/19#time::t '2))
  (define std/srfi/19#make-time%
    (lambda (_type21703_ _nanosecond21704_ _second21705_)
      (let ((_$e21707_ _type21703_))
        (if (or (eq? 'time-tai _$e21707_)
                (eq? 'time-utc _$e21707_)
                (eq? 'time-monotonic _$e21707_)
                (eq? 'time-thread _$e21707_)
                (eq? 'time-process _$e21707_)
                (eq? 'time-duration _$e21707_))
            '#t
            (error '"Wrong time type" _type21703_)))
      (if (exact-integer? _second21705_)
          '#!void
          (error '"Invalid time second" _second21705_))
      (if (and (exact-integer? _nanosecond21704_)
               (<= (if (eq? _type21703_ std/srfi/19#time-duration)
                       '-999999999
                       '0)
                   _nanosecond21704_
                   '999999999))
          '#!void
          (error '"Invalid time nanosecond" _nanosecond21704_))
      (##structure
       std/srfi/19#time::t
       _type21703_
       _nanosecond21704_
       _second21705_)))
  (define std/srfi/19#copy-time
    (lambda (_time21701_)
      (##structure
       std/srfi/19#time::t
       (##structure-ref _time21701_ '1 std/srfi/19#time::t '#f)
       (##structure-ref _time21701_ '2 std/srfi/19#time::t '#f)
       (##structure-ref _time21701_ '3 std/srfi/19#time::t '#f))))
  (define std/srfi/19#current-seconds
    (lambda () (inexact->exact (floor (##current-time-point)))))
  (define std/srfi/19#current-milliseconds
    (lambda () (inexact->exact (floor (fl* '1000. (##current-time-point))))))
  (define std/srfi/19#tm:get-time-of-day
    (lambda ()
      (let* ((_now21694_ (##current-time-point))
             (_sec21696_ (floor _now21694_)))
        (values (inexact->exact _sec21696_)
                (inexact->exact
                 (floor (fl* (fl- _now21694_ _sec21696_) '1000000000.)))))))
  (define std/srfi/19#tm:current-time-utc
    (lambda ()
      (let ((_g21770_ (std/srfi/19#tm:get-time-of-day)))
        (begin
          (let ((_g21771_
                 (if (##values? _g21770_) (##vector-length _g21770_) 1)))
            (if (not (##fx= _g21771_ 2))
                (error "Context expects 2 values" _g21771_)))
          (let ((_seconds21690_ (##vector-ref _g21770_ 0))
                (_ns21691_ (##vector-ref _g21770_ 1)))
            (##structure
             std/srfi/19#time::t
             std/srfi/19#time-utc
             _ns21691_
             _seconds21690_))))))
  (define std/srfi/19#tm:current-time-tai
    (lambda ()
      (let ((_g21772_ (std/srfi/19#tm:get-time-of-day)))
        (begin
          (let ((_g21773_
                 (if (##values? _g21772_) (##vector-length _g21772_) 1)))
            (if (not (##fx= _g21773_ 2))
                (error "Context expects 2 values" _g21773_)))
          (let ((_seconds21686_ (##vector-ref _g21772_ 0))
                (_ns21687_ (##vector-ref _g21772_ 1)))
            (##structure
             std/srfi/19#time::t
             std/srfi/19#time-tai
             _ns21687_
             (+ _seconds21686_
                (std/srfi/19#tm:leap-second-delta _seconds21686_))))))))
  (define std/srfi/19#tm:current-time-monotonic
    (lambda ()
      (let ((_g21774_ (std/srfi/19#tm:get-time-of-day)))
        (begin
          (let ((_g21775_
                 (if (##values? _g21774_) (##vector-length _g21774_) 1)))
            (if (not (##fx= _g21775_ 2))
                (error "Context expects 2 values" _g21775_)))
          (let ((_seconds21682_ (##vector-ref _g21774_ 0))
                (_ns21683_ (##vector-ref _g21774_ 1)))
            (##structure
             std/srfi/19#time::t
             std/srfi/19#time-monotonic
             _ns21683_
             (+ _seconds21682_
                (std/srfi/19#tm:leap-second-delta _seconds21682_))))))))
  (define std/srfi/19#tm:current-time-thread
    (lambda () (error '"Unimplemented")))
  (define std/srfi/19#tm:current-time-process
    (lambda () (error '"Unimplemented")))
  (define std/srfi/19#current-time
    (lambda _clock-type21672_
      (let ((_clock-type21677_
             (let ((_maybe-arg21674_ _clock-type21672_))
               (if (null? _maybe-arg21674_)
                   std/srfi/19#time-utc
                   (if (null? (cdr _maybe-arg21674_))
                       (car _maybe-arg21674_)
                       (error '"too many optional arguments"
                              _maybe-arg21674_))))))
        (if (eq? _clock-type21677_ std/srfi/19#time-tai)
            (std/srfi/19#tm:current-time-tai)
            (if (eq? _clock-type21677_ std/srfi/19#time-utc)
                (std/srfi/19#tm:current-time-utc)
                (if (eq? _clock-type21677_ std/srfi/19#time-monotonic)
                    (std/srfi/19#tm:current-time-monotonic)
                    (if (eq? _clock-type21677_ std/srfi/19#time-thread)
                        (std/srfi/19#tm:current-time-thread)
                        (if (eq? _clock-type21677_ std/srfi/19#time-process)
                            (std/srfi/19#tm:current-time-process)
                            (std/srfi/19#tm:time-error
                             'current-time
                             'invalid-clock-type
                             _clock-type21677_)))))))))
  (define std/srfi/19#time-resolution
    (lambda _clock-type21665_
      (let ((_clock-type21670_
             (let ((_maybe-arg21667_ _clock-type21665_))
               (if (null? _maybe-arg21667_)
                   std/srfi/19#time-utc
                   (if (null? (cdr _maybe-arg21667_))
                       (car _maybe-arg21667_)
                       (error '"too many optional arguments"
                              _maybe-arg21667_))))))
        (if (eq? _clock-type21670_ std/srfi/19#time-tai)
            '1
            (if (eq? _clock-type21670_ std/srfi/19#time-utc)
                '1
                (if (eq? _clock-type21670_ std/srfi/19#time-monotonic)
                    '1
                    (if (eq? _clock-type21670_ std/srfi/19#time-thread)
                        '1000
                        (if (eq? _clock-type21670_ std/srfi/19#time-process)
                            '1000
                            (std/srfi/19#tm:time-error
                             'time-resolution
                             'invalid-clock-type
                             _clock-type21670_)))))))))
  (define std/srfi/19#tm:time-compare-check
    (lambda (_time121658_ _time221659_ _caller21660_)
      (if (or (not (and (##structure-instance-of?
                         _time121658_
                         'std/srfi/19#time::t)
                        (##structure-instance-of?
                         _time221659_
                         'std/srfi/19#time::t)))
              (not (eq? (##structure-ref
                         _time121658_
                         '1
                         std/srfi/19#time::t
                         '#f)
                        (##structure-ref
                         _time221659_
                         '1
                         std/srfi/19#time::t
                         '#f))))
          (std/srfi/19#tm:time-error
           _caller21660_
           'incompatible-time-types
           '#f)
          '#t)))
  (define std/srfi/19#time=?
    (lambda (_time121655_ _time221656_)
      (std/srfi/19#tm:time-compare-check _time121655_ _time221656_ 'time=?)
      (if (= (##structure-ref _time121655_ '3 std/srfi/19#time::t '#f)
             (##structure-ref _time221656_ '3 std/srfi/19#time::t '#f))
          (= (##structure-ref _time121655_ '2 std/srfi/19#time::t '#f)
             (##structure-ref _time221656_ '2 std/srfi/19#time::t '#f))
          '#f)))
  (define std/srfi/19#time>?
    (lambda (_time121649_ _time221650_)
      (std/srfi/19#tm:time-compare-check _time121649_ _time221650_ 'time>?)
      (let ((_$e21652_
             (> (##structure-ref _time121649_ '3 std/srfi/19#time::t '#f)
                (##structure-ref _time221650_ '3 std/srfi/19#time::t '#f))))
        (if _$e21652_
            _$e21652_
            (if (= (##structure-ref _time121649_ '3 std/srfi/19#time::t '#f)
                   (##structure-ref _time221650_ '3 std/srfi/19#time::t '#f))
                (> (##structure-ref _time121649_ '2 std/srfi/19#time::t '#f)
                   (##structure-ref _time221650_ '2 std/srfi/19#time::t '#f))
                '#f)))))
  (define std/srfi/19#time<?
    (lambda (_time121643_ _time221644_)
      (std/srfi/19#tm:time-compare-check _time121643_ _time221644_ 'time<?)
      (let ((_$e21646_
             (< (##structure-ref _time121643_ '3 std/srfi/19#time::t '#f)
                (##structure-ref _time221644_ '3 std/srfi/19#time::t '#f))))
        (if _$e21646_
            _$e21646_
            (if (= (##structure-ref _time121643_ '3 std/srfi/19#time::t '#f)
                   (##structure-ref _time221644_ '3 std/srfi/19#time::t '#f))
                (< (##structure-ref _time121643_ '2 std/srfi/19#time::t '#f)
                   (##structure-ref _time221644_ '2 std/srfi/19#time::t '#f))
                '#f)))))
  (define std/srfi/19#time>=?
    (lambda (_time121637_ _time221638_)
      (std/srfi/19#tm:time-compare-check _time121637_ _time221638_ 'time>=?)
      (let ((_$e21640_
             (>= (##structure-ref _time121637_ '3 std/srfi/19#time::t '#f)
                 (##structure-ref _time221638_ '3 std/srfi/19#time::t '#f))))
        (if _$e21640_
            _$e21640_
            (if (= (##structure-ref _time121637_ '3 std/srfi/19#time::t '#f)
                   (##structure-ref _time221638_ '3 std/srfi/19#time::t '#f))
                (>= (##structure-ref _time121637_ '2 std/srfi/19#time::t '#f)
                    (##structure-ref _time221638_ '2 std/srfi/19#time::t '#f))
                '#f)))))
  (define std/srfi/19#time<=?
    (lambda (_time121631_ _time221632_)
      (std/srfi/19#tm:time-compare-check _time121631_ _time221632_ 'time<=?)
      (let ((_$e21634_
             (<= (##structure-ref _time121631_ '3 std/srfi/19#time::t '#f)
                 (##structure-ref _time221632_ '3 std/srfi/19#time::t '#f))))
        (if _$e21634_
            _$e21634_
            (if (= (##structure-ref _time121631_ '3 std/srfi/19#time::t '#f)
                   (##structure-ref _time221632_ '3 std/srfi/19#time::t '#f))
                (<= (##structure-ref _time121631_ '2 std/srfi/19#time::t '#f)
                    (##structure-ref _time221632_ '2 std/srfi/19#time::t '#f))
                '#f)))))
  (define std/srfi/19#tm:time->nanoseconds
    (lambda (_time21625_)
      (letrec ((_sign121627_
                (lambda (_n21629_) (if (negative? _n21629_) '-1 '1))))
        (+ (* (##structure-ref _time21625_ '3 std/srfi/19#time::t '#f)
              std/srfi/19#tm:nano)
           (##structure-ref _time21625_ '2 std/srfi/19#time::t '#f)))))
  (define std/srfi/19#tm:nanoseconds->time
    (lambda (_time-type21622_ _nanoseconds21623_)
      (##structure
       std/srfi/19#time::t
       _time-type21622_
       (remainder _nanoseconds21623_ std/srfi/19#tm:nano)
       (quotient _nanoseconds21623_ std/srfi/19#tm:nano))))
  (define std/srfi/19#tm:nanoseconds->values
    (lambda (_nanoseconds21620_)
      (values (abs (remainder _nanoseconds21620_ std/srfi/19#tm:nano))
              (quotient _nanoseconds21620_ std/srfi/19#tm:nano))))
  (define std/srfi/19#tm:time-difference
    (lambda (_time121610_ _time221611_ _time321612_)
      (if (or (not (and (##structure-instance-of?
                         _time121610_
                         'std/srfi/19#time::t)
                        (##structure-instance-of?
                         _time221611_
                         'std/srfi/19#time::t)))
              (not (eq? (##structure-ref
                         _time121610_
                         '1
                         std/srfi/19#time::t
                         '#f)
                        (##structure-ref
                         _time221611_
                         '1
                         std/srfi/19#time::t
                         '#f))))
          (std/srfi/19#tm:time-error
           'time-difference
           'incompatible-time-types
           '#f)
          '#!void)
      (##structure-set!
       _time321612_
       std/srfi/19#time-duration
       '1
       std/srfi/19#time::t
       '#f)
      (if (std/srfi/19#time=? _time121610_ _time221611_)
          (begin
            (##structure-set! _time321612_ '0 '3 std/srfi/19#time::t '#f)
            (##structure-set! _time321612_ '0 '2 std/srfi/19#time::t '#f))
          (let ((_g21776_
                 (std/srfi/19#tm:nanoseconds->values
                  (- (std/srfi/19#tm:time->nanoseconds _time121610_)
                     (std/srfi/19#tm:time->nanoseconds _time221611_)))))
            (begin
              (let ((_g21777_
                     (if (##values? _g21776_) (##vector-length _g21776_) 1)))
                (if (not (##fx= _g21777_ 2))
                    (error "Context expects 2 values" _g21777_)))
              (let ((_nanos21617_ (##vector-ref _g21776_ 0))
                    (_secs21618_ (##vector-ref _g21776_ 1)))
                (begin
                  (##structure-set!
                   _time321612_
                   _secs21618_
                   '3
                   std/srfi/19#time::t
                   '#f)
                  (##structure-set!
                   _time321612_
                   _nanos21617_
                   '2
                   std/srfi/19#time::t
                   '#f))))))
      _time321612_))
  (define std/srfi/19#time-difference
    (lambda (_time121607_ _time221608_)
      (std/srfi/19#tm:time-difference
       _time121607_
       _time221608_
       (##structure std/srfi/19#time::t '#f '#f '#f))))
  (define std/srfi/19#time-difference!
    (lambda (_time121604_ _time221605_)
      (std/srfi/19#tm:time-difference _time121604_ _time221605_ _time121604_)))
  (define std/srfi/19#tm:add-duration
    (lambda (_time121594_ _duration21595_ _time321596_)
      (if (not (and (##structure-instance-of?
                     _time121594_
                     'std/srfi/19#time::t)
                    (##structure-instance-of?
                     _duration21595_
                     'std/srfi/19#time::t)))
          (std/srfi/19#tm:time-error
           'add-duration
           'incompatible-time-types
           '#f)
          '#!void)
      (if (not (eq? (##structure-ref
                     _duration21595_
                     '1
                     std/srfi/19#time::t
                     '#f)
                    std/srfi/19#time-duration))
          (std/srfi/19#tm:time-error
           'add-duration
           'not-duration
           _duration21595_)
          (let ((_sec-plus21598_
                 (+ (##structure-ref _time121594_ '3 std/srfi/19#time::t '#f)
                    (##structure-ref
                     _duration21595_
                     '3
                     std/srfi/19#time::t
                     '#f)))
                (_nsec-plus21599_
                 (+ (##structure-ref _time121594_ '2 std/srfi/19#time::t '#f)
                    (##structure-ref
                     _duration21595_
                     '2
                     std/srfi/19#time::t
                     '#f))))
            (let ((_r21601_ (remainder _nsec-plus21599_ std/srfi/19#tm:nano))
                  (_q21602_ (quotient _nsec-plus21599_ std/srfi/19#tm:nano)))
              (if (negative? _r21601_)
                  (begin
                    (##structure-set!
                     _time321596_
                     (+ _sec-plus21598_ _q21602_ '-1)
                     '3
                     std/srfi/19#time::t
                     '#f)
                    (##structure-set!
                     _time321596_
                     (+ std/srfi/19#tm:nano _r21601_)
                     '2
                     std/srfi/19#time::t
                     '#f))
                  (begin
                    (##structure-set!
                     _time321596_
                     (+ _sec-plus21598_ _q21602_)
                     '3
                     std/srfi/19#time::t
                     '#f)
                    (##structure-set!
                     _time321596_
                     _r21601_
                     '2
                     std/srfi/19#time::t
                     '#f)))
              _time321596_)))))
  (define std/srfi/19#add-duration
    (lambda (_time121591_ _duration21592_)
      (std/srfi/19#tm:add-duration
       _time121591_
       _duration21592_
       (##structure
        std/srfi/19#time::t
        (##structure-ref _time121591_ '1 std/srfi/19#time::t '#f)
        '#f
        '#f))))
  (define std/srfi/19#add-duration!
    (lambda (_time121588_ _duration21589_)
      (std/srfi/19#tm:add-duration _time121588_ _duration21589_ _time121588_)))
  (define std/srfi/19#tm:subtract-duration
    (lambda (_time121578_ _duration21579_ _time321580_)
      (if (not (and (##structure-instance-of?
                     _time121578_
                     'std/srfi/19#time::t)
                    (##structure-instance-of?
                     _duration21579_
                     'std/srfi/19#time::t)))
          (std/srfi/19#tm:time-error
           'add-duration
           'incompatible-time-types
           '#f)
          '#!void)
      (if (not (eq? (##structure-ref
                     _duration21579_
                     '1
                     std/srfi/19#time::t
                     '#f)
                    std/srfi/19#time-duration))
          (std/srfi/19#tm:time-error
           'tm:subtract-duration
           'not-duration
           _duration21579_)
          (let ((_sec-minus21582_
                 (- (##structure-ref _time121578_ '3 std/srfi/19#time::t '#f)
                    (##structure-ref
                     _duration21579_
                     '3
                     std/srfi/19#time::t
                     '#f)))
                (_nsec-minus21583_
                 (- (##structure-ref _time121578_ '2 std/srfi/19#time::t '#f)
                    (##structure-ref
                     _duration21579_
                     '2
                     std/srfi/19#time::t
                     '#f))))
            (let ((_r21585_ (remainder _nsec-minus21583_ std/srfi/19#tm:nano))
                  (_q21586_ (quotient _nsec-minus21583_ std/srfi/19#tm:nano)))
              (if (negative? _r21585_)
                  (begin
                    (##structure-set!
                     _time321580_
                     (- _sec-minus21582_ _q21586_ '1)
                     '3
                     std/srfi/19#time::t
                     '#f)
                    (##structure-set!
                     _time321580_
                     (+ std/srfi/19#tm:nano _r21585_)
                     '2
                     std/srfi/19#time::t
                     '#f))
                  (begin
                    (##structure-set!
                     _time321580_
                     (- _sec-minus21582_ _q21586_)
                     '3
                     std/srfi/19#time::t
                     '#f)
                    (##structure-set!
                     _time321580_
                     _r21585_
                     '2
                     std/srfi/19#time::t
                     '#f)))
              _time321580_)))))
  (define std/srfi/19#subtract-duration
    (lambda (_time121575_ _duration21576_)
      (std/srfi/19#tm:subtract-duration
       _time121575_
       _duration21576_
       (##structure
        std/srfi/19#time::t
        (##structure-ref _time121575_ '1 std/srfi/19#time::t '#f)
        '#f
        '#f))))
  (define std/srfi/19#subtract-duration!
    (lambda (_time121572_ _duration21573_)
      (std/srfi/19#tm:subtract-duration
       _time121572_
       _duration21573_
       _time121572_)))
  (define std/srfi/19#tm:time-tai->time-utc!
    (lambda (_time-in21568_ _time-out21569_ _caller21570_)
      (if (not (eq? (##structure-ref _time-in21568_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-tai))
          (std/srfi/19#tm:time-error
           _caller21570_
           'incompatible-time-types
           _time-in21568_)
          '#!void)
      (##structure-set!
       _time-out21569_
       std/srfi/19#time-utc
       '1
       std/srfi/19#time::t
       '#f)
      (##structure-set!
       _time-out21569_
       (##structure-ref _time-in21568_ '2 std/srfi/19#time::t '#f)
       '2
       std/srfi/19#time::t
       '#f)
      (##structure-set!
       _time-out21569_
       (- (##structure-ref _time-in21568_ '3 std/srfi/19#time::t '#f)
          (std/srfi/19#tm:leap-second-neg-delta
           (##structure-ref _time-in21568_ '3 std/srfi/19#time::t '#f)))
       '3
       std/srfi/19#time::t
       '#f)
      _time-out21569_))
  (define std/srfi/19#time-tai->time-utc
    (lambda (_time-in21566_)
      (std/srfi/19#tm:time-tai->time-utc!
       _time-in21566_
       (##structure std/srfi/19#time::t '#f '#f '#f)
       'time-tai->time-utc)))
  (define std/srfi/19#time-tai->time-utc!
    (lambda (_time-in21564_)
      (std/srfi/19#tm:time-tai->time-utc!
       _time-in21564_
       _time-in21564_
       'time-tai->time-utc!)))
  (define std/srfi/19#tm:time-utc->time-tai!
    (lambda (_time-in21560_ _time-out21561_ _caller21562_)
      (if (not (eq? (##structure-ref _time-in21560_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-utc))
          (std/srfi/19#tm:time-error
           _caller21562_
           'incompatible-time-types
           _time-in21560_)
          '#!void)
      (##structure-set!
       _time-out21561_
       std/srfi/19#time-tai
       '1
       std/srfi/19#time::t
       '#f)
      (##structure-set!
       _time-out21561_
       (##structure-ref _time-in21560_ '2 std/srfi/19#time::t '#f)
       '2
       std/srfi/19#time::t
       '#f)
      (##structure-set!
       _time-out21561_
       (+ (##structure-ref _time-in21560_ '3 std/srfi/19#time::t '#f)
          (std/srfi/19#tm:leap-second-delta
           (##structure-ref _time-in21560_ '3 std/srfi/19#time::t '#f)))
       '3
       std/srfi/19#time::t
       '#f)
      _time-out21561_))
  (define std/srfi/19#time-utc->time-tai
    (lambda (_time-in21558_)
      (std/srfi/19#tm:time-utc->time-tai!
       _time-in21558_
       (##structure std/srfi/19#time::t '#f '#f '#f)
       'time-utc->time-tai)))
  (define std/srfi/19#time-utc->time-tai!
    (lambda (_time-in21556_)
      (std/srfi/19#tm:time-utc->time-tai!
       _time-in21556_
       _time-in21556_
       'time-utc->time-tai!)))
  (define std/srfi/19#time-monotonic->time-utc
    (lambda (_time-in21552_)
      (if (not (eq? (##structure-ref _time-in21552_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-monotonic))
          (std/srfi/19#tm:time-error
           'time-monotoinc->time-utc
           'incompatible-time-types
           _time-in21552_)
          '#!void)
      (let ((_ntime21554_ (std/srfi/19#copy-time _time-in21552_)))
        (##structure-set!
         _ntime21554_
         std/srfi/19#time-tai
         '1
         std/srfi/19#time::t
         '#f)
        (std/srfi/19#tm:time-tai->time-utc!
         _ntime21554_
         _ntime21554_
         'time-monotonic->time-utc))))
  (define std/srfi/19#time-monotonic->time-utc!
    (lambda (_time-in21550_)
      (if (not (eq? (##structure-ref _time-in21550_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-monotonic))
          (std/srfi/19#tm:time-error
           'time-monotonic->time-utc!
           'incompatible-time-types
           _time-in21550_)
          '#!void)
      (##structure-set!
       _time-in21550_
       std/srfi/19#time-tai
       '1
       std/srfi/19#time::t
       '#f)
      (std/srfi/19#tm:time-tai->time-utc!
       _time-in21550_
       _time-in21550_
       'time-monotonic->time-utc)))
  (define std/srfi/19#time-monotonic->time-tai
    (lambda (_time-in21546_)
      (if (not (eq? (##structure-ref _time-in21546_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-monotonic))
          (std/srfi/19#tm:time-error
           'time-monotonic->time-tai
           'incompatible-time-types
           _time-in21546_)
          '#!void)
      (let ((_ntime21548_ (std/srfi/19#copy-time _time-in21546_)))
        (##structure-set!
         _ntime21548_
         std/srfi/19#time-tai
         '1
         std/srfi/19#time::t
         '#f)
        _ntime21548_)))
  (define std/srfi/19#time-monotonic->time-tai!
    (lambda (_time-in21544_)
      (if (not (eq? (##structure-ref _time-in21544_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-monotonic))
          (std/srfi/19#tm:time-error
           'time-monotonic->time-tai!
           'incompatible-time-types
           _time-in21544_)
          '#!void)
      (##structure-set!
       _time-in21544_
       std/srfi/19#time-tai
       '1
       std/srfi/19#time::t
       '#f)
      _time-in21544_))
  (define std/srfi/19#time-utc->time-monotonic
    (lambda (_time-in21540_)
      (if (not (eq? (##structure-ref _time-in21540_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-utc))
          (std/srfi/19#tm:time-error
           'time-utc->time-monotonic
           'incompatible-time-types
           _time-in21540_)
          '#!void)
      (let ((_ntime21542_
             (std/srfi/19#tm:time-utc->time-tai!
              _time-in21540_
              (##structure std/srfi/19#time::t '#f '#f '#f)
              'time-utc->time-monotonic)))
        (##structure-set!
         _ntime21542_
         std/srfi/19#time-monotonic
         '1
         std/srfi/19#time::t
         '#f)
        _ntime21542_)))
  (define std/srfi/19#time-utc->time-monotonic!
    (lambda (_time-in21536_)
      (if (not (eq? (##structure-ref _time-in21536_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-utc))
          (std/srfi/19#tm:time-error
           'time-utc->time-montonic!
           'incompatible-time-types
           _time-in21536_)
          '#!void)
      (let ((_ntime21538_
             (std/srfi/19#tm:time-utc->time-tai!
              _time-in21536_
              _time-in21536_
              'time-utc->time-monotonic!)))
        (##structure-set!
         _ntime21538_
         std/srfi/19#time-monotonic
         '1
         std/srfi/19#time::t
         '#f)
        _ntime21538_)))
  (define std/srfi/19#time-tai->time-monotonic
    (lambda (_time-in21532_)
      (if (not (eq? (##structure-ref _time-in21532_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-tai))
          (std/srfi/19#tm:time-error
           'time-tai->time-monotonic
           'incompatible-time-types
           _time-in21532_)
          '#!void)
      (let ((_ntime21534_ (std/srfi/19#copy-time _time-in21532_)))
        (##structure-set!
         _ntime21534_
         std/srfi/19#time-monotonic
         '1
         std/srfi/19#time::t
         '#f)
        _ntime21534_)))
  (define std/srfi/19#time-tai->time-monotonic!
    (lambda (_time-in21530_)
      (if (not (eq? (##structure-ref _time-in21530_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-tai))
          (std/srfi/19#tm:time-error
           'time-tai->time-monotonic!
           'incompatible-time-types
           _time-in21530_)
          '#!void)
      (##structure-set!
       _time-in21530_
       std/srfi/19#time-monotonic
       '1
       std/srfi/19#time::t
       '#f)
      _time-in21530_))
  (define std/srfi/19#date::t
    (make-struct-type
     'std/srfi/19#date::t
     '#f
     '8
     'date
     '((equal: nanosecond second minute hour day month year zone-offset))
     '#f
     '(nanosecond second minute hour day month year zone-offset)))
  (define std/srfi/19#date? (make-struct-predicate std/srfi/19#date::t))
  (define std/srfi/19#make-date
    (lambda _$args21527_
      (apply make-struct-instance std/srfi/19#date::t _$args21527_)))
  (define std/srfi/19#date-nanosecond
    (make-struct-field-accessor std/srfi/19#date::t '0))
  (define std/srfi/19#date-second
    (make-struct-field-accessor std/srfi/19#date::t '1))
  (define std/srfi/19#date-minute
    (make-struct-field-accessor std/srfi/19#date::t '2))
  (define std/srfi/19#date-hour
    (make-struct-field-accessor std/srfi/19#date::t '3))
  (define std/srfi/19#date-day
    (make-struct-field-accessor std/srfi/19#date::t '4))
  (define std/srfi/19#date-month
    (make-struct-field-accessor std/srfi/19#date::t '5))
  (define std/srfi/19#date-year
    (make-struct-field-accessor std/srfi/19#date::t '6))
  (define std/srfi/19#date-zone-offset
    (make-struct-field-accessor std/srfi/19#date::t '7))
  (define std/srfi/19#date-nanosecond-set!
    (make-struct-field-mutator std/srfi/19#date::t '0))
  (define std/srfi/19#date-second-set!
    (make-struct-field-mutator std/srfi/19#date::t '1))
  (define std/srfi/19#date-minute-set!
    (make-struct-field-mutator std/srfi/19#date::t '2))
  (define std/srfi/19#date-hour-set!
    (make-struct-field-mutator std/srfi/19#date::t '3))
  (define std/srfi/19#date-day-set!
    (make-struct-field-mutator std/srfi/19#date::t '4))
  (define std/srfi/19#date-month-set!
    (make-struct-field-mutator std/srfi/19#date::t '5))
  (define std/srfi/19#date-year-set!
    (make-struct-field-mutator std/srfi/19#date::t '6))
  (define std/srfi/19#date-zone-offset-set!
    (make-struct-field-mutator std/srfi/19#date::t '7))
  (define std/srfi/19#tm:encode-julian-day-number
    (lambda (_day21516_ _month21517_ _year21518_)
      (let* ((_a21520_ (quotient (- '14 _month21517_) '12))
             (_y21522_
              (- (- (+ _year21518_ '4800) _a21520_)
                 (if (negative? _year21518_) '-1 '0)))
             (_m21524_ (- (+ _month21517_ (* '12 _a21520_)) '3)))
        (+ _day21516_
           (quotient (+ (* '153 _m21524_) '2) '5)
           (* '365 _y21522_)
           (quotient _y21522_ '4)
           (- (quotient _y21522_ '100))
           (quotient _y21522_ '400)
           '-32045))))
  (define std/srfi/19#tm:char-pos
    (lambda (_char21511_ _str21512_ _index21513_ _len21514_)
      (if (>= _index21513_ _len21514_)
          '#f
          (if (char=? (string-ref _str21512_ _index21513_) _char21511_)
              _index21513_
              (std/srfi/19#tm:char-pos
               _char21511_
               _str21512_
               (+ _index21513_ '1)
               _len21514_)))))
  (define std/srfi/19#tm:fractional-part
    (lambda (_r21505_)
      (if (integer? _r21505_)
          '"0"
          (let* ((_str21507_ (number->string (exact->inexact _r21505_)))
                 (_ppos21509_
                  (std/srfi/19#tm:char-pos
                   '#\.
                   _str21507_
                   '0
                   (string-length _str21507_))))
            (substring
             _str21507_
             (+ _ppos21509_ '1)
             (string-length _str21507_))))))
  (define std/srfi/19#tm:decode-julian-day-number
    (lambda (_jdn21486_)
      (let* ((_days21488_ (truncate _jdn21486_))
             (_a21490_ (+ _days21488_ '32044))
             (_b21492_ (quotient (+ (* '4 _a21490_) '3) '146097))
             (_c21494_ (- _a21490_ (quotient (* '146097 _b21492_) '4)))
             (_d21496_ (quotient (+ (* '4 _c21494_) '3) '1461))
             (_e21498_ (- _c21494_ (quotient (* '1461 _d21496_) '4)))
             (_m21500_ (quotient (+ (* '5 _e21498_) '2) '153))
             (_y21502_
              (+ (* '100 _b21492_) _d21496_ '-4800 (quotient _m21500_ '10))))
        (values (* (- _jdn21486_ _days21488_) std/srfi/19#tm:sid)
                (+ _e21498_ (- (quotient (+ (* '153 _m21500_) '2) '5)) '1)
                (+ _m21500_ '3 (* '-12 (quotient _m21500_ '10)))
                (if (>= '0 _y21502_) (- _y21502_ '1) _y21502_)))))
  (define std/srfi/19#tm:local-tz-offset (lambda () '0))
  (define std/srfi/19#tm:time->julian-day-number
    (lambda (_seconds21482_ _tz-offset21483_)
      (+ (/ (+ _seconds21482_ _tz-offset21483_ std/srfi/19#tm:sihd)
            std/srfi/19#tm:sid)
         std/srfi/19#tm:tai-epoch-in-jd)))
  (define std/srfi/19#tm:find
    (lambda (_proc21479_ _l21480_)
      (if (null? _l21480_)
          '#f
          (if (_proc21479_ (car _l21480_))
              '#t
              (std/srfi/19#tm:find _proc21479_ (cdr _l21480_))))))
  (define std/srfi/19#tm:tai-before-leap-second?
    (lambda (_second21475_)
      (std/srfi/19#tm:find
       (lambda (_x21477_)
         (= _second21475_ (- (+ (car _x21477_) (cdr _x21477_)) '1)))
       std/srfi/19#tm:leap-second-table)))
  (define std/srfi/19#tm:time->date
    (lambda (_time21451_ _tz-offset21452_ _ttype21453_)
      (if (not (eq? (##structure-ref _time21451_ '1 std/srfi/19#time::t '#f)
                    _ttype21453_))
          (std/srfi/19#tm:time-error
           'time->date
           'incompatible-time-types
           _time21451_)
          '#!void)
      (let ((_offset21458_
             (let ((_maybe-arg21455_ _tz-offset21452_))
               (if (null? _maybe-arg21455_)
                   (std/srfi/19#tm:local-tz-offset)
                   (if (null? (cdr _maybe-arg21455_))
                       (car _maybe-arg21455_)
                       (error '"too many optional arguments"
                              _maybe-arg21455_))))))
        (let ((_g21778_
               (std/srfi/19#tm:decode-julian-day-number
                (std/srfi/19#tm:time->julian-day-number
                 (##structure-ref _time21451_ '3 std/srfi/19#time::t '#f)
                 _offset21458_))))
          (begin
            (let ((_g21779_
                   (if (##values? _g21778_) (##vector-length _g21778_) 1)))
              (if (not (##fx= _g21779_ 4))
                  (error "Context expects 4 values" _g21779_)))
            (let ((_secs21461_ (##vector-ref _g21778_ 0))
                  (_date21462_ (##vector-ref _g21778_ 1))
                  (_month21463_ (##vector-ref _g21778_ 2))
                  (_year21464_ (##vector-ref _g21778_ 3)))
              (let* ((_hours21466_ (quotient _secs21461_ (* '60 '60)))
                     (_rem21468_ (remainder _secs21461_ (* '60 '60)))
                     (_minutes21470_ (quotient _rem21468_ '60))
                     (_seconds21472_ (remainder _rem21468_ '60)))
                (##structure
                 std/srfi/19#date::t
                 (##structure-ref _time21451_ '2 std/srfi/19#time::t '#f)
                 _seconds21472_
                 _minutes21470_
                 _hours21466_
                 _date21462_
                 _month21463_
                 _year21464_
                 _offset21458_))))))))
  (define std/srfi/19#time-tai->date
    (lambda (_time21446_ . _tz-offset21447_)
      (if (std/srfi/19#tm:tai-before-leap-second?
           (##structure-ref _time21446_ '3 std/srfi/19#time::t '#f))
          (let ((_d21449_
                 (std/srfi/19#tm:time->date
                  (std/srfi/19#subtract-duration!
                   (std/srfi/19#time-tai->time-utc _time21446_)
                   (##structure
                    std/srfi/19#time::t
                    std/srfi/19#time-duration
                    '0
                    '1))
                  _tz-offset21447_
                  std/srfi/19#time-utc)))
            (##structure-set! _d21449_ '60 '2 std/srfi/19#date::t '#f)
            _d21449_)
          (std/srfi/19#tm:time->date
           (std/srfi/19#time-tai->time-utc _time21446_)
           _tz-offset21447_
           std/srfi/19#time-utc))))
  (define std/srfi/19#time-utc->date
    (lambda (_time21443_ . _tz-offset21444_)
      (std/srfi/19#tm:time->date
       _time21443_
       _tz-offset21444_
       std/srfi/19#time-utc)))
  (define std/srfi/19#time-monotonic->date
    (lambda (_time21440_ . _tz-offset21441_)
      (std/srfi/19#tm:time->date
       _time21440_
       _tz-offset21441_
       std/srfi/19#time-monotonic)))
  (define std/srfi/19#date->time-utc
    (lambda (_date21427_)
      (let ((_nanosecond21429_
             (##structure-ref _date21427_ '1 std/srfi/19#date::t '#f))
            (_second21430_
             (##structure-ref _date21427_ '2 std/srfi/19#date::t '#f))
            (_minute21431_
             (##structure-ref _date21427_ '3 std/srfi/19#date::t '#f))
            (_hour21432_
             (##structure-ref _date21427_ '4 std/srfi/19#date::t '#f))
            (_day21433_
             (##structure-ref _date21427_ '5 std/srfi/19#date::t '#f))
            (_month21434_
             (##structure-ref _date21427_ '6 std/srfi/19#date::t '#f))
            (_year21435_
             (##structure-ref _date21427_ '7 std/srfi/19#date::t '#f))
            (_offset21436_
             (##structure-ref _date21427_ '8 std/srfi/19#date::t '#f)))
        (let ((_jdays21438_
               (- (std/srfi/19#tm:encode-julian-day-number
                   _day21433_
                   _month21434_
                   _year21435_)
                  std/srfi/19#tm:tai-epoch-in-jd)))
          (##structure
           std/srfi/19#time::t
           std/srfi/19#time-utc
           _nanosecond21429_
           (+ (* (- _jdays21438_ '1/2) '24 '60 '60)
              (* _hour21432_ '60 '60)
              (* _minute21431_ '60)
              _second21430_
              (- _offset21436_)))))))
  (define std/srfi/19#date->time-tai
    (lambda (_d21425_)
      (if (= (##structure-ref _d21425_ '2 std/srfi/19#date::t '#f) '60)
          (std/srfi/19#subtract-duration!
           (std/srfi/19#time-utc->time-tai!
            (std/srfi/19#date->time-utc _d21425_))
           (##structure std/srfi/19#time::t std/srfi/19#time-duration '0 '1))
          (std/srfi/19#time-utc->time-tai!
           (std/srfi/19#date->time-utc _d21425_)))))
  (define std/srfi/19#date->time-monotonic
    (lambda (_date21423_)
      (std/srfi/19#time-utc->time-monotonic!
       (std/srfi/19#date->time-utc _date21423_))))
  (define std/srfi/19#tm:leap-year?
    (lambda (_year21418_)
      (let ((_$e21420_ (= (modulo _year21418_ '400) '0)))
        (if _$e21420_
            _$e21420_
            (if (= (modulo _year21418_ '4) '0)
                (not (= (modulo _year21418_ '100) '0))
                '#f)))))
  (define std/srfi/19#leap-year?
    (lambda (_date21416_)
      (std/srfi/19#tm:leap-year?
       (##structure-ref _date21416_ '7 std/srfi/19#date::t '#f))))
  (define std/srfi/19#tm:month-assoc
    '((0 . 0)
      (1 . 31)
      (2 . 59)
      (3 . 90)
      (4 . 120)
      (5 . 151)
      (6 . 181)
      (7 . 212)
      (8 . 243)
      (9 . 273)
      (10 . 304)
      (11 . 334)))
  (define std/srfi/19#tm:year-day
    (lambda (_day21410_ _month21411_ _year21412_)
      (let ((_days-pr21414_
             (assoc (- _month21411_ '1) std/srfi/19#tm:month-assoc)))
        (if (not _days-pr21414_)
            (std/srfi/19#tm:time-error
             'date-year-day
             'invalid-month-specification
             _month21411_)
            '#!void)
        (if (and (std/srfi/19#tm:leap-year? _year21412_) (> _month21411_ '2))
            (+ _day21410_ (cdr _days-pr21414_) '1)
            (+ _day21410_ (cdr _days-pr21414_))))))
  (define std/srfi/19#date-year-day
    (lambda (_date21408_)
      (std/srfi/19#tm:year-day
       (##structure-ref _date21408_ '5 std/srfi/19#date::t '#f)
       (##structure-ref _date21408_ '6 std/srfi/19#date::t '#f)
       (##structure-ref _date21408_ '7 std/srfi/19#date::t '#f))))
  (define std/srfi/19#tm:week-day
    (lambda (_day21397_ _month21398_ _year21399_)
      (let* ((_a21401_ (quotient (- '14 _month21398_) '12))
             (_y21403_ (- _year21399_ _a21401_))
             (_m21405_ (+ _month21398_ (* '12 _a21401_) '-2)))
        (modulo (+ _day21397_
                   _y21403_
                   (quotient _y21403_ '4)
                   (- (quotient _y21403_ '100))
                   (quotient _y21403_ '400)
                   (quotient (* '31 _m21405_) '12))
                '7))))
  (define std/srfi/19#date-week-day
    (lambda (_date21395_)
      (std/srfi/19#tm:week-day
       (##structure-ref _date21395_ '5 std/srfi/19#date::t '#f)
       (##structure-ref _date21395_ '6 std/srfi/19#date::t '#f)
       (##structure-ref _date21395_ '7 std/srfi/19#date::t '#f))))
  (define std/srfi/19#tm:days-before-first-week
    (lambda (_date21387_ _day-of-week-starting-week21388_)
      (let* ((_first-day21390_
              (##structure
               std/srfi/19#date::t
               '0
               '0
               '0
               '0
               '1
               '1
               (##structure-ref _date21387_ '7 std/srfi/19#date::t '#f)
               '#f))
             (_fdweek-day21392_ (std/srfi/19#date-week-day _first-day21390_)))
        (modulo (- _day-of-week-starting-week21388_ _fdweek-day21392_) '7))))
  (define std/srfi/19#date-week-number
    (lambda (_date21384_ _day-of-week-starting-week21385_)
      (quotient
       (- (std/srfi/19#date-year-day _date21384_)
          (std/srfi/19#tm:days-before-first-week
           _date21384_
           _day-of-week-starting-week21385_))
       '7)))
  (define std/srfi/19#current-date
    (lambda _tz-offset21379_
      (std/srfi/19#time-utc->date
       (std/srfi/19#current-time std/srfi/19#time-utc)
       (let ((_maybe-arg21381_ _tz-offset21379_))
         (if (null? _maybe-arg21381_)
             (std/srfi/19#tm:local-tz-offset)
             (if (null? (cdr _maybe-arg21381_))
                 (car _maybe-arg21381_)
                 (error '"too many optional arguments" _maybe-arg21381_)))))))
  (define std/srfi/19#tm:natural-year
    (lambda (_n21372_)
      (let* ((_current-year21374_
              (##structure-ref
               (std/srfi/19#current-date)
               '7
               std/srfi/19#date::t
               '#f))
             (_current-century21376_
              (* (quotient _current-year21374_ '100) '100)))
        (if (>= _n21372_ '100)
            _n21372_
            (if (< _n21372_ '0)
                _n21372_
                (if (<= (- (+ _current-century21376_ _n21372_)
                           _current-year21374_)
                        '50)
                    (+ _current-century21376_ _n21372_)
                    (+ (- _current-century21376_ '100) _n21372_)))))))
  (define std/srfi/19#date->julian-day
    (lambda (_date21361_)
      (let ((_nanosecond21363_
             (##structure-ref _date21361_ '1 std/srfi/19#date::t '#f))
            (_second21364_
             (##structure-ref _date21361_ '2 std/srfi/19#date::t '#f))
            (_minute21365_
             (##structure-ref _date21361_ '3 std/srfi/19#date::t '#f))
            (_hour21366_
             (##structure-ref _date21361_ '4 std/srfi/19#date::t '#f))
            (_day21367_
             (##structure-ref _date21361_ '5 std/srfi/19#date::t '#f))
            (_month21368_
             (##structure-ref _date21361_ '6 std/srfi/19#date::t '#f))
            (_year21369_
             (##structure-ref _date21361_ '7 std/srfi/19#date::t '#f))
            (_offset21370_
             (##structure-ref _date21361_ '8 std/srfi/19#date::t '#f)))
        (+ (std/srfi/19#tm:encode-julian-day-number
            _day21367_
            _month21368_
            _year21369_)
           (- '1/2)
           (+ (/ (/ (+ (* _hour21366_ '60 '60)
                       (* _minute21365_ '60)
                       _second21364_
                       (/ _nanosecond21363_ std/srfi/19#tm:nano))
                    std/srfi/19#tm:sid)
                 (- _offset21370_)))))))
  (define std/srfi/19#date->modified-julian-day
    (lambda (_date21359_)
      (- (std/srfi/19#date->julian-day _date21359_) '4800001/2)))
  (define std/srfi/19#time-utc->julian-day
    (lambda (_time21357_)
      (if (not (eq? (##structure-ref _time21357_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-utc))
          (std/srfi/19#tm:time-error
           'time-utc->julian-day
           'incompatible-time-types
           _time21357_)
          '#!void)
      (+ (/ (+ (##structure-ref _time21357_ '3 std/srfi/19#time::t '#f)
               (/ (##structure-ref _time21357_ '2 std/srfi/19#time::t '#f)
                  std/srfi/19#tm:nano))
            std/srfi/19#tm:sid)
         std/srfi/19#tm:tai-epoch-in-jd)))
  (define std/srfi/19#time-utc->modified-julian-day
    (lambda (_time21355_)
      (- (std/srfi/19#time-utc->julian-day _time21355_) '4800001/2)))
  (define std/srfi/19#time-tai->julian-day
    (lambda (_time21353_)
      (if (not (eq? (##structure-ref _time21353_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-tai))
          (std/srfi/19#tm:time-error
           'time-tai->julian-day
           'incompatible-time-types
           _time21353_)
          '#!void)
      (+ (/ (+ (- (##structure-ref _time21353_ '3 std/srfi/19#time::t '#f)
                  (std/srfi/19#tm:leap-second-delta
                   (##structure-ref _time21353_ '3 std/srfi/19#time::t '#f)))
               (/ (##structure-ref _time21353_ '2 std/srfi/19#time::t '#f)
                  std/srfi/19#tm:nano))
            std/srfi/19#tm:sid)
         std/srfi/19#tm:tai-epoch-in-jd)))
  (define std/srfi/19#time-tai->modified-julian-day
    (lambda (_time21351_)
      (- (std/srfi/19#time-tai->julian-day _time21351_) '4800001/2)))
  (define std/srfi/19#time-monotonic->julian-day
    (lambda (_time21349_)
      (if (not (eq? (##structure-ref _time21349_ '1 std/srfi/19#time::t '#f)
                    std/srfi/19#time-monotonic))
          (std/srfi/19#tm:time-error
           'time-monotonic->julian-day
           'incompatible-time-types
           _time21349_)
          '#!void)
      (+ (/ (+ (- (##structure-ref _time21349_ '3 std/srfi/19#time::t '#f)
                  (std/srfi/19#tm:leap-second-delta
                   (##structure-ref _time21349_ '3 std/srfi/19#time::t '#f)))
               (/ (##structure-ref _time21349_ '2 std/srfi/19#time::t '#f)
                  std/srfi/19#tm:nano))
            std/srfi/19#tm:sid)
         std/srfi/19#tm:tai-epoch-in-jd)))
  (define std/srfi/19#time-monotonic->modified-julian-day
    (lambda (_time21347_)
      (- (std/srfi/19#time-monotonic->julian-day _time21347_) '4800001/2)))
  (define std/srfi/19#julian-day->time-utc
    (lambda (_jdn21343_)
      (let ((_nanosecs21345_
             (* std/srfi/19#tm:nano
                std/srfi/19#tm:sid
                (- _jdn21343_ std/srfi/19#tm:tai-epoch-in-jd))))
        (##structure
         std/srfi/19#time::t
         std/srfi/19#time-utc
         (remainder _nanosecs21345_ std/srfi/19#tm:nano)
         (floor (/ _nanosecs21345_ std/srfi/19#tm:nano))))))
  (define std/srfi/19#julian-day->time-tai
    (lambda (_jdn21341_)
      (std/srfi/19#time-utc->time-tai!
       (std/srfi/19#julian-day->time-utc _jdn21341_))))
  (define std/srfi/19#julian-day->time-monotonic
    (lambda (_jdn21339_)
      (std/srfi/19#time-utc->time-monotonic!
       (std/srfi/19#julian-day->time-utc _jdn21339_))))
  (define std/srfi/19#julian-day->date
    (lambda (_jdn21331_ . _tz-offset21332_)
      (let ((_offset21337_
             (let ((_maybe-arg21334_ _tz-offset21332_))
               (if (null? _maybe-arg21334_)
                   (std/srfi/19#tm:local-tz-offset)
                   (if (null? (cdr _maybe-arg21334_))
                       (car _maybe-arg21334_)
                       (error '"too many optional arguments"
                              _maybe-arg21334_))))))
        (std/srfi/19#time-utc->date
         (std/srfi/19#julian-day->time-utc _jdn21331_)
         _offset21337_))))
  (define std/srfi/19#modified-julian-day->date
    (lambda (_jdn21323_ . _tz-offset21324_)
      (let ((_offset21329_
             (let ((_maybe-arg21326_ _tz-offset21324_))
               (if (null? _maybe-arg21326_)
                   (std/srfi/19#tm:local-tz-offset)
                   (if (null? (cdr _maybe-arg21326_))
                       (car _maybe-arg21326_)
                       (error '"too many optional arguments"
                              _maybe-arg21326_))))))
        (std/srfi/19#julian-day->date
         (+ _jdn21323_ '4800001/2)
         _offset21329_))))
  (define std/srfi/19#modified-julian-day->time-utc
    (lambda (_jdn21321_)
      (std/srfi/19#julian-day->time-utc (+ _jdn21321_ '4800001/2))))
  (define std/srfi/19#modified-julian-day->time-tai
    (lambda (_jdn21319_)
      (std/srfi/19#julian-day->time-tai (+ _jdn21319_ '4800001/2))))
  (define std/srfi/19#modified-julian-day->time-monotonic
    (lambda (_jdn21317_)
      (std/srfi/19#julian-day->time-monotonic (+ _jdn21317_ '4800001/2))))
  (define std/srfi/19#current-julian-day
    (lambda ()
      (std/srfi/19#time-utc->julian-day
       (std/srfi/19#current-time std/srfi/19#time-utc))))
  (define std/srfi/19#current-modified-julian-day
    (lambda ()
      (std/srfi/19#time-utc->modified-julian-day
       (std/srfi/19#current-time std/srfi/19#time-utc))))
  (define std/srfi/19#tm:padding
    (lambda (_n21293_ _pad-with21294_ _length21295_)
      (let* ((_str21297_ (number->string _n21293_))
             (_str-len21299_ (string-length _str21297_)))
        (if (or (> _str-len21299_ _length21295_) (not _pad-with21294_))
            _str21297_
            (let* ((_new-str21305_ (make-string _length21295_ _pad-with21294_))
                   (_new-str-offset21307_
                    (- (string-length _new-str21305_) _str-len21299_)))
              (let _$loop21310_ ((_i21313_ '0))
                (if (>= _i21313_ (string-length _str21297_))
                    '#!void
                    (begin
                      (string-set!
                       _new-str21305_
                       (+ _new-str-offset21307_ _i21313_)
                       (string-ref _str21297_ _i21313_))
                      (_$loop21310_ (+ _i21313_ '1)))))
              _new-str21305_)))))
  (define std/srfi/19#tm:last-n-digits
    (lambda (_i21290_ _n21291_)
      (abs (remainder _i21290_ (expt '10 _n21291_)))))
  (define std/srfi/19#tm:locale-abbr-weekday
    (lambda (_n21288_)
      (vector-ref std/srfi/19#tm:locale-abbr-weekday-vector _n21288_)))
  (define std/srfi/19#tm:locale-long-weekday
    (lambda (_n21286_)
      (vector-ref std/srfi/19#tm:locale-long-weekday-vector _n21286_)))
  (define std/srfi/19#tm:locale-abbr-month
    (lambda (_n21284_)
      (vector-ref std/srfi/19#tm:locale-abbr-month-vector _n21284_)))
  (define std/srfi/19#tm:locale-long-month
    (lambda (_n21282_)
      (vector-ref std/srfi/19#tm:locale-long-month-vector _n21282_)))
  (define std/srfi/19#tm:vector-find
    (lambda (_needle21272_ _haystack21273_ _comparator21274_)
      (let ((_len21276_ (vector-length _haystack21273_)))
        (letrec ((_tm:vector-find-int21278_
                  (lambda (_index21280_)
                    (if (>= _index21280_ _len21276_)
                        '#f
                        (if (_comparator21274_
                             _needle21272_
                             (vector-ref _haystack21273_ _index21280_))
                            _index21280_
                            (_tm:vector-find-int21278_
                             (+ _index21280_ '1)))))))
          (_tm:vector-find-int21278_ '0)))))
  (define std/srfi/19#tm:locale-abbr-weekday->index
    (lambda (_string21270_)
      (std/srfi/19#tm:vector-find
       _string21270_
       std/srfi/19#tm:locale-abbr-weekday-vector
       string=?)))
  (define std/srfi/19#tm:locale-long-weekday->index
    (lambda (_string21268_)
      (std/srfi/19#tm:vector-find
       _string21268_
       std/srfi/19#tm:locale-long-weekday-vector
       string=?)))
  (define std/srfi/19#tm:locale-abbr-month->index
    (lambda (_string21266_)
      (std/srfi/19#tm:vector-find
       _string21266_
       std/srfi/19#tm:locale-abbr-month-vector
       string=?)))
  (define std/srfi/19#tm:locale-long-month->index
    (lambda (_string21264_)
      (std/srfi/19#tm:vector-find
       _string21264_
       std/srfi/19#tm:locale-long-month-vector
       string=?)))
  (define std/srfi/19#tm:locale-print-time-zone
    (lambda (_date21261_ _port21262_) '#!void))
  (define std/srfi/19#tm:locale-am/pm
    (lambda (_hr21259_)
      (if (> _hr21259_ '11)
          std/srfi/19#tm:locale-pm
          std/srfi/19#tm:locale-am)))
  (define std/srfi/19#tm:tz-printer
    (lambda (_offset21253_ _port21254_)
      (if (= _offset21253_ '0)
          (display '"Z" _port21254_)
          (if (negative? _offset21253_)
              (display '"-" _port21254_)
              (display '"+" _port21254_)))
      (if (not (= _offset21253_ '0))
          (let ((_hours21256_ (abs (quotient _offset21253_ (* '60 '60))))
                (_minutes21257_
                 (abs (quotient (remainder _offset21253_ (* '60 '60)) '60))))
            (display (std/srfi/19#tm:padding _hours21256_ '#\0 '2) _port21254_)
            (display (std/srfi/19#tm:padding _minutes21257_ '#\0 '2)
                     _port21254_))
          '#!void)))
  (define std/srfi/19#tm:directives
    (list (cons '#\~
                (lambda (_date21080_ _pad-with21081_ _port21082_)
                  (display '#\~ _port21082_)))
          (cons '#\a
                (lambda (_date21084_ _pad-with21085_ _port21086_)
                  (display (std/srfi/19#tm:locale-abbr-weekday
                            (std/srfi/19#date-week-day _date21084_))
                           _port21086_)))
          (cons '#\A
                (lambda (_date21088_ _pad-with21089_ _port21090_)
                  (display (std/srfi/19#tm:locale-long-weekday
                            (std/srfi/19#date-week-day _date21088_))
                           _port21090_)))
          (cons '#\b
                (lambda (_date21092_ _pad-with21093_ _port21094_)
                  (display (std/srfi/19#tm:locale-abbr-month
                            (##structure-ref
                             _date21092_
                             '6
                             std/srfi/19#date::t
                             '#f))
                           _port21094_)))
          (cons '#\B
                (lambda (_date21096_ _pad-with21097_ _port21098_)
                  (display (std/srfi/19#tm:locale-long-month
                            (##structure-ref
                             _date21096_
                             '6
                             std/srfi/19#date::t
                             '#f))
                           _port21098_)))
          (cons '#\c
                (lambda (_date21100_ _pad-with21101_ _port21102_)
                  (display (std/srfi/19#date->string
                            _date21100_
                            std/srfi/19#tm:locale-date-time-format)
                           _port21102_)))
          (cons '#\d
                (lambda (_date21104_ _pad-with21105_ _port21106_)
                  (display (std/srfi/19#tm:padding
                            (##structure-ref
                             _date21104_
                             '5
                             std/srfi/19#date::t
                             '#f)
                            '#\0
                            '2)
                           _port21106_)))
          (cons '#\D
                (lambda (_date21108_ _pad-with21109_ _port21110_)
                  (display (std/srfi/19#date->string _date21108_ '"~m/~d/~y")
                           _port21110_)))
          (cons '#\e
                (lambda (_date21112_ _pad-with21113_ _port21114_)
                  (display (std/srfi/19#tm:padding
                            (##structure-ref
                             _date21112_
                             '5
                             std/srfi/19#date::t
                             '#f)
                            '#\space
                            '2)
                           _port21114_)))
          (cons '#\f
                (lambda (_date21116_ _pad-with21117_ _port21118_)
                  (if (> (##structure-ref
                          _date21116_
                          '1
                          std/srfi/19#date::t
                          '#f)
                         std/srfi/19#tm:nano)
                      (display (std/srfi/19#tm:padding
                                (+ (##structure-ref
                                    _date21116_
                                    '2
                                    std/srfi/19#date::t
                                    '#f)
                                   '1)
                                _pad-with21117_
                                '2)
                               _port21118_)
                      (display (std/srfi/19#tm:padding
                                (##structure-ref
                                 _date21116_
                                 '2
                                 std/srfi/19#date::t
                                 '#f)
                                _pad-with21117_
                                '2)
                               _port21118_))
                  (let* ((_ns21120_
                          (std/srfi/19#tm:fractional-part
                           (/ (##structure-ref
                               _date21116_
                               '1
                               std/srfi/19#date::t
                               '#f)
                              std/srfi/19#tm:nano
                              '1.)))
                         (_le21122_ (string-length _ns21120_)))
                    (if (> _le21122_ '2)
                        (begin
                          (display std/srfi/19#tm:locale-number-separator
                                   _port21118_)
                          (display (substring _ns21120_ '2 _le21122_)
                                   _port21118_))
                        '#!void))))
          (cons '#\h
                (lambda (_date21125_ _pad-with21126_ _port21127_)
                  (display (std/srfi/19#date->string _date21125_ '"~b")
                           _port21127_)))
          (cons '#\H
                (lambda (_date21129_ _pad-with21130_ _port21131_)
                  (display (std/srfi/19#tm:padding
                            (##structure-ref
                             _date21129_
                             '4
                             std/srfi/19#date::t
                             '#f)
                            _pad-with21130_
                            '2)
                           _port21131_)))
          (cons '#\I
                (lambda (_date21133_ _pad-with21134_ _port21135_)
                  (let ((_hr21137_
                         (##structure-ref
                          _date21133_
                          '4
                          std/srfi/19#date::t
                          '#f)))
                    (if (> _hr21137_ '12)
                        (display (std/srfi/19#tm:padding
                                  (- _hr21137_ '12)
                                  _pad-with21134_
                                  '2)
                                 _port21135_)
                        (display (std/srfi/19#tm:padding
                                  _hr21137_
                                  _pad-with21134_
                                  '2)
                                 _port21135_)))))
          (cons '#\j
                (lambda (_date21139_ _pad-with21140_ _port21141_)
                  (display (std/srfi/19#tm:padding
                            (std/srfi/19#date-year-day _date21139_)
                            _pad-with21140_
                            '3)
                           _port21141_)))
          (cons '#\k
                (lambda (_date21143_ _pad-with21144_ _port21145_)
                  (display (std/srfi/19#tm:padding
                            (##structure-ref
                             _date21143_
                             '4
                             std/srfi/19#date::t
                             '#f)
                            '#\0
                            '2)
                           _port21145_)))
          (cons '#\l
                (lambda (_date21147_ _pad-with21148_ _port21149_)
                  (let ((_hr21151_
                         (if (> (##structure-ref
                                 _date21147_
                                 '4
                                 std/srfi/19#date::t
                                 '#f)
                                '12)
                             (- (##structure-ref
                                 _date21147_
                                 '4
                                 std/srfi/19#date::t
                                 '#f)
                                '12)
                             (##structure-ref
                              _date21147_
                              '4
                              std/srfi/19#date::t
                              '#f))))
                    (display (std/srfi/19#tm:padding _hr21151_ '#\space '2)
                             _port21149_))))
          (cons '#\m
                (lambda (_date21153_ _pad-with21154_ _port21155_)
                  (display (std/srfi/19#tm:padding
                            (##structure-ref
                             _date21153_
                             '6
                             std/srfi/19#date::t
                             '#f)
                            _pad-with21154_
                            '2)
                           _port21155_)))
          (cons '#\M
                (lambda (_date21157_ _pad-with21158_ _port21159_)
                  (display (std/srfi/19#tm:padding
                            (##structure-ref
                             _date21157_
                             '3
                             std/srfi/19#date::t
                             '#f)
                            _pad-with21158_
                            '2)
                           _port21159_)))
          (cons '#\n
                (lambda (_date21161_ _pad-with21162_ _port21163_)
                  (newline _port21163_)))
          (cons '#\N
                (lambda (_date21165_ _pad-with21166_ _port21167_)
                  (display (std/srfi/19#tm:padding
                            (##structure-ref
                             _date21165_
                             '1
                             std/srfi/19#date::t
                             '#f)
                            _pad-with21166_
                            '9)
                           _port21167_)))
          (cons '#\p
                (lambda (_date21169_ _pad-with21170_ _port21171_)
                  (display (std/srfi/19#tm:locale-am/pm
                            (##structure-ref
                             _date21169_
                             '4
                             std/srfi/19#date::t
                             '#f))
                           _port21171_)))
          (cons '#\r
                (lambda (_date21173_ _pad-with21174_ _port21175_)
                  (display (std/srfi/19#date->string
                            _date21173_
                            '"~I:~M:~S ~p")
                           _port21175_)))
          (cons '#\s
                (lambda (_date21177_ _pad-with21178_ _port21179_)
                  (display (##structure-ref
                            (std/srfi/19#date->time-utc _date21177_)
                            '3
                            std/srfi/19#time::t
                            '#f)
                           _port21179_)))
          (cons '#\S
                (lambda (_date21181_ _pad-with21182_ _port21183_)
                  (if (> (##structure-ref
                          _date21181_
                          '1
                          std/srfi/19#date::t
                          '#f)
                         std/srfi/19#tm:nano)
                      (display (std/srfi/19#tm:padding
                                (+ (##structure-ref
                                    _date21181_
                                    '2
                                    std/srfi/19#date::t
                                    '#f)
                                   '1)
                                _pad-with21182_
                                '2)
                               _port21183_)
                      (display (std/srfi/19#tm:padding
                                (##structure-ref
                                 _date21181_
                                 '2
                                 std/srfi/19#date::t
                                 '#f)
                                _pad-with21182_
                                '2)
                               _port21183_))))
          (cons '#\t
                (lambda (_date21185_ _pad-with21186_ _port21187_)
                  (display (integer->char '9) _port21187_)))
          (cons '#\T
                (lambda (_date21189_ _pad-with21190_ _port21191_)
                  (display (std/srfi/19#date->string _date21189_ '"~H:~M:~S")
                           _port21191_)))
          (cons '#\U
                (lambda (_date21193_ _pad-with21194_ _port21195_)
                  (if (> (std/srfi/19#tm:days-before-first-week _date21193_ '0)
                         '0)
                      (display (std/srfi/19#tm:padding
                                (+ (std/srfi/19#date-week-number
                                    _date21193_
                                    '0)
                                   '1)
                                '#\0
                                '2)
                               _port21195_)
                      (display (std/srfi/19#tm:padding
                                (std/srfi/19#date-week-number _date21193_ '0)
                                '#\0
                                '2)
                               _port21195_))))
          (cons '#\V
                (lambda (_date21197_ _pad-with21198_ _port21199_)
                  (display (std/srfi/19#tm:padding
                            (std/srfi/19#date-week-number _date21197_ '1)
                            '#\0
                            '2)
                           _port21199_)))
          (cons '#\w
                (lambda (_date21201_ _pad-with21202_ _port21203_)
                  (display (std/srfi/19#date-week-day _date21201_)
                           _port21203_)))
          (cons '#\x
                (lambda (_date21205_ _pad-with21206_ _port21207_)
                  (display (std/srfi/19#date->string
                            _date21205_
                            std/srfi/19#tm:locale-short-date-format)
                           _port21207_)))
          (cons '#\X
                (lambda (_date21209_ _pad-with21210_ _port21211_)
                  (display (std/srfi/19#date->string
                            _date21209_
                            std/srfi/19#tm:locale-time-format)
                           _port21211_)))
          (cons '#\W
                (lambda (_date21213_ _pad-with21214_ _port21215_)
                  (if (> (std/srfi/19#tm:days-before-first-week _date21213_ '1)
                         '0)
                      (display (std/srfi/19#tm:padding
                                (+ (std/srfi/19#date-week-number
                                    _date21213_
                                    '1)
                                   '1)
                                '#\0
                                '2)
                               _port21215_)
                      (display (std/srfi/19#tm:padding
                                (std/srfi/19#date-week-number _date21213_ '1)
                                '#\0
                                '2)
                               _port21215_))))
          (cons '#\y
                (lambda (_date21217_ _pad-with21218_ _port21219_)
                  (display (std/srfi/19#tm:padding
                            (std/srfi/19#tm:last-n-digits
                             (##structure-ref
                              _date21217_
                              '7
                              std/srfi/19#date::t
                              '#f)
                             '2)
                            _pad-with21218_
                            '2)
                           _port21219_)))
          (cons '#\Y
                (lambda (_date21221_ _pad-with21222_ _port21223_)
                  (display (##structure-ref
                            _date21221_
                            '7
                            std/srfi/19#date::t
                            '#f)
                           _port21223_)))
          (cons '#\z
                (lambda (_date21225_ _pad-with21226_ _port21227_)
                  (std/srfi/19#tm:tz-printer
                   (##structure-ref _date21225_ '8 std/srfi/19#date::t '#f)
                   _port21227_)))
          (cons '#\Z
                (lambda (_date21229_ _pad-with21230_ _port21231_)
                  (std/srfi/19#tm:locale-print-time-zone
                   _date21229_
                   _port21231_)))
          (cons '#\1
                (lambda (_date21233_ _pad-with21234_ _port21235_)
                  (display (std/srfi/19#date->string _date21233_ '"~Y-~m-~d")
                           _port21235_)))
          (cons '#\2
                (lambda (_date21237_ _pad-with21238_ _port21239_)
                  (display (std/srfi/19#date->string _date21237_ '"~k:~M:~S~z")
                           _port21239_)))
          (cons '#\3
                (lambda (_date21241_ _pad-with21242_ _port21243_)
                  (display (std/srfi/19#date->string _date21241_ '"~k:~M:~S")
                           _port21243_)))
          (cons '#\4
                (lambda (_date21245_ _pad-with21246_ _port21247_)
                  (display (std/srfi/19#date->string
                            _date21245_
                            '"~Y-~m-~dT~k:~M:~S~z")
                           _port21247_)))
          (cons '#\5
                (lambda (_date21249_ _pad-with21250_ _port21251_)
                  (display (std/srfi/19#date->string
                            _date21249_
                            '"~Y-~m-~dT~k:~M:~S")
                           _port21251_)))))
  (define std/srfi/19#tm:get-formatter
    (lambda (_char21076_)
      (let ((_associated21078_ (assoc _char21076_ std/srfi/19#tm:directives)))
        (if _associated21078_ (cdr _associated21078_) '#f))))
  (define std/srfi/19#tm:date-printer
    (lambda (_date21060_
             _index21061_
             _format-string21062_
             _str-len21063_
             _port21064_)
      (if (>= _index21061_ _str-len21063_)
          '#!void
          (let ((_current-char21066_
                 (string-ref _format-string21062_ _index21061_)))
            (if (not (char=? _current-char21066_ '#\~))
                (begin
                  (display _current-char21066_ _port21064_)
                  (std/srfi/19#tm:date-printer
                   _date21060_
                   (+ _index21061_ '1)
                   _format-string21062_
                   _str-len21063_
                   _port21064_))
                (if (= (+ _index21061_ '1) _str-len21063_)
                    (std/srfi/19#tm:time-error
                     'tm:date-printer
                     'bad-date-format-string
                     _format-string21062_)
                    (let ((_pad-char?21068_
                           (string-ref
                            _format-string21062_
                            (+ _index21061_ '1))))
                      (if (char=? _pad-char?21068_ '#\-)
                          (if (= (+ _index21061_ '2) _str-len21063_)
                              (std/srfi/19#tm:time-error
                               'tm:date-printer
                               'bad-date-format-string
                               _format-string21062_)
                              (let ((_formatter21070_
                                     (std/srfi/19#tm:get-formatter
                                      (string-ref
                                       _format-string21062_
                                       (+ _index21061_ '2)))))
                                (if (not _formatter21070_)
                                    (std/srfi/19#tm:time-error
                                     'tm:date-printer
                                     'bad-date-format-string
                                     _format-string21062_)
                                    (begin
                                      (_formatter21070_
                                       _date21060_
                                       '#f
                                       _port21064_)
                                      (std/srfi/19#tm:date-printer
                                       _date21060_
                                       (+ _index21061_ '3)
                                       _format-string21062_
                                       _str-len21063_
                                       _port21064_)))))
                          (if (char=? _pad-char?21068_ '#\_)
                              (if (= (+ _index21061_ '2) _str-len21063_)
                                  (std/srfi/19#tm:time-error
                                   'tm:date-printer
                                   'bad-date-format-string
                                   _format-string21062_)
                                  (let ((_formatter21072_
                                         (std/srfi/19#tm:get-formatter
                                          (string-ref
                                           _format-string21062_
                                           (+ _index21061_ '2)))))
                                    (if (not _formatter21072_)
                                        (std/srfi/19#tm:time-error
                                         'tm:date-printer
                                         'bad-date-format-string
                                         _format-string21062_)
                                        (begin
                                          (_formatter21072_
                                           _date21060_
                                           '#\space
                                           _port21064_)
                                          (std/srfi/19#tm:date-printer
                                           _date21060_
                                           (+ _index21061_ '3)
                                           _format-string21062_
                                           _str-len21063_
                                           _port21064_)))))
                              (let ((_formatter21074_
                                     (std/srfi/19#tm:get-formatter
                                      (string-ref
                                       _format-string21062_
                                       (+ _index21061_ '1)))))
                                (if (not _formatter21074_)
                                    (std/srfi/19#tm:time-error
                                     'tm:date-printer
                                     'bad-date-format-string
                                     _format-string21062_)
                                    (begin
                                      (_formatter21074_
                                       _date21060_
                                       '#\0
                                       _port21064_)
                                      (std/srfi/19#tm:date-printer
                                       _date21060_
                                       (+ _index21061_ '2)
                                       _format-string21062_
                                       _str-len21063_
                                       _port21064_)))))))))))))
  (define std/srfi/19#date->string
    (lambda (_date21051_ . _format-string21052_)
      (let ((_str-port21057_ (open-output-string))
            (_fmt-str21058_
             (let ((_maybe-arg21054_ _format-string21052_))
               (if (null? _maybe-arg21054_)
                   '"~c"
                   (if (null? (cdr _maybe-arg21054_))
                       (car _maybe-arg21054_)
                       (error '"too many optional arguments"
                              _maybe-arg21054_))))))
        (std/srfi/19#tm:date-printer
         _date21051_
         '0
         _fmt-str21058_
         (string-length _fmt-str21058_)
         _str-port21057_)
        (get-output-string _str-port21057_))))
  (define std/srfi/19#tm:char->int
    (lambda (_ch21049_)
      (if (char=? _ch21049_ '#\0)
          '0
          (if (char=? _ch21049_ '#\1)
              '1
              (if (char=? _ch21049_ '#\2)
                  '2
                  (if (char=? _ch21049_ '#\3)
                      '3
                      (if (char=? _ch21049_ '#\4)
                          '4
                          (if (char=? _ch21049_ '#\5)
                              '5
                              (if (char=? _ch21049_ '#\6)
                                  '6
                                  (if (char=? _ch21049_ '#\7)
                                      '7
                                      (if (char=? _ch21049_ '#\8)
                                          '8
                                          (if (char=? _ch21049_ '#\9)
                                              '9
                                              (std/srfi/19#tm:time-error
                                               'string->date
                                               'bad-date-template-string
                                               (list '"Non-integer character"
                                                     _ch21049_))))))))))))))
  (define std/srfi/19#tm:integer-reader
    (lambda (_upto21032_ _port21033_)
      (letrec ((_accum-int21035_
                (lambda (_port21037_ _accum21038_ _nchars21039_)
                  (let ((_ch21041_ (peek-char _port21037_)))
                    (if (or (eof-object? _ch21041_)
                            (not (char-numeric? _ch21041_))
                            (and _upto21032_ (>= _nchars21039_ _upto21032_)))
                        _accum21038_
                        (_accum-int21035_
                         _port21037_
                         (+ (* _accum21038_ '10)
                            (std/srfi/19#tm:char->int (read-char _port21037_)))
                         (+ _nchars21039_ '1)))))))
        (_accum-int21035_ _port21033_ '0 '0))))
  (define std/srfi/19#tm:make-integer-reader
    (lambda (_upto21028_)
      (lambda (_port21030_)
        (std/srfi/19#tm:integer-reader _upto21028_ _port21030_))))
  (define std/srfi/19#tm:fractional-integer-reader
    (lambda (_upto21011_ _port21012_)
      (letrec ((_accum-int21014_
                (lambda (_port21016_ _accum21017_ _nchars21018_)
                  (let ((_ch21020_ (peek-char _port21016_)))
                    (if (or (eof-object? _ch21020_)
                            (not (char-numeric? _ch21020_))
                            (and _upto21011_ (>= _nchars21018_ _upto21011_)))
                        (* _accum21017_
                           (expt '10 (- _upto21011_ _nchars21018_)))
                        (_accum-int21014_
                         _port21016_
                         (+ (* _accum21017_ '10)
                            (std/srfi/19#tm:char->int (read-char _port21016_)))
                         (+ _nchars21018_ '1)))))))
        (_accum-int21014_ _port21012_ '0 '0))))
  (define std/srfi/19#tm:make-fractional-integer-reader
    (lambda (_upto21007_)
      (lambda (_port21009_)
        (std/srfi/19#tm:fractional-integer-reader _upto21007_ _port21009_))))
  (define std/srfi/19#tm:integer-reader-exact
    (lambda (_n20994_ _port20995_)
      (let ((_padding-ok20997_ '#t))
        (letrec ((_accum-int20999_
                  (lambda (_port21001_ _accum21002_ _nchars21003_)
                    (let ((_ch21005_ (peek-char _port21001_)))
                      (if (>= _nchars21003_ _n20994_)
                          _accum21002_
                          (if (eof-object? _ch21005_)
                              (std/srfi/19#tm:time-error
                               'string->date
                               'bad-date-template-string
                               '"Premature ending to integer read.")
                              (if (char-numeric? _ch21005_)
                                  (begin
                                    (set! _padding-ok20997_ '#f)
                                    (_accum-int20999_
                                     _port21001_
                                     (+ (* _accum21002_ '10)
                                        (std/srfi/19#tm:char->int
                                         (read-char _port21001_)))
                                     (+ _nchars21003_ '1)))
                                  (if _padding-ok20997_
                                      (begin
                                        (read-char _port21001_)
                                        (_accum-int20999_
                                         _port21001_
                                         _accum21002_
                                         (+ _nchars21003_ '1)))
                                      (std/srfi/19#tm:time-error
                                       'string->date
                                       'bad-date-template-string
                                       '"Non-numeric characters in integer read.")))))))))
          (_accum-int20999_ _port20995_ '0 '0)))))
  (define std/srfi/19#tm:make-integer-exact-reader
    (lambda (_n20990_)
      (lambda (_port20992_)
        (std/srfi/19#tm:integer-reader-exact _n20990_ _port20992_))))
  (define std/srfi/19#tm:zone-reader
    (lambda (_port20972_)
      (let ((_offset20974_ '0) (_positive?20975_ '#f))
        (let ((_ch20977_ (read-char _port20972_)))
          (if (eof-object? _ch20977_)
              (std/srfi/19#tm:time-error
               'string->date
               'bad-date-template-string
               (list '"Invalid time zone +/-" _ch20977_))
              '#!void)
          (if (or (char=? _ch20977_ '#\Z) (char=? _ch20977_ '#\z))
              '0
              (begin
                (if (char=? _ch20977_ '#\+)
                    (set! _positive?20975_ '#t)
                    (if (char=? _ch20977_ '#\-)
                        (set! _positive?20975_ '#f)
                        (std/srfi/19#tm:time-error
                         'string->date
                         'bad-date-template-string
                         (list '"Invalid time zone +/-" _ch20977_))))
                (let ((_ch20982_ (read-char _port20972_)))
                  (if (eof-object? _ch20982_)
                      (std/srfi/19#tm:time-error
                       'string->date
                       'bad-date-template-string
                       (list '"Invalid time zone number" _ch20982_))
                      '#!void)
                  (set! _offset20974_
                        (* (std/srfi/19#tm:char->int _ch20982_) '10 '60 '60)))
                (let ((_ch20984_ (read-char _port20972_)))
                  (if (eof-object? _ch20984_)
                      (std/srfi/19#tm:time-error
                       'string->date
                       'bad-date-template-string
                       (list '"Invalid time zone number" _ch20984_))
                      '#!void)
                  (set! _offset20974_
                        (+ _offset20974_
                           (* (std/srfi/19#tm:char->int _ch20984_) '60 '60))))
                (let ((_ch20986_ (read-char _port20972_)))
                  (if (eof-object? _ch20986_)
                      (std/srfi/19#tm:time-error
                       'string->date
                       'bad-date-template-string
                       (list '"Invalid time zone number" _ch20986_))
                      '#!void)
                  (set! _offset20974_
                        (+ _offset20974_
                           (* (std/srfi/19#tm:char->int _ch20986_) '10 '60))))
                (let ((_ch20988_ (read-char _port20972_)))
                  (if (eof-object? _ch20988_)
                      (std/srfi/19#tm:time-error
                       'string->date
                       'bad-date-template-string
                       (list '"Invalid time zone number" _ch20988_))
                      '#!void)
                  (set! _offset20974_
                        (+ _offset20974_
                           (* (std/srfi/19#tm:char->int _ch20988_) '60))))
                (if _positive?20975_ _offset20974_ (- _offset20974_))))))))
  (define std/srfi/19#tm:locale-reader
    (lambda (_port20957_ _indexer20958_)
      (let ((_string-port20960_ (open-output-string)))
        (letrec ((_read-char-string20962_
                  (lambda ()
                    (let ((_ch20970_ (peek-char _port20957_)))
                      (if (char-alphabetic? _ch20970_)
                          (begin
                            (write-char
                             (read-char _port20957_)
                             _string-port20960_)
                            (_read-char-string20962_))
                          (get-output-string _string-port20960_))))))
          (let* ((_str20964_ (_read-char-string20962_))
                 (_index20966_ (_indexer20958_ _str20964_)))
            (if _index20966_
                _index20966_
                (std/srfi/19#tm:time-error
                 'string->date
                 'bad-date-template-string
                 (list '"Invalid string for " _indexer20958_))))))))
  (define std/srfi/19#tm:make-locale-reader
    (lambda (_indexer20953_)
      (lambda (_port20955_)
        (std/srfi/19#tm:locale-reader _port20955_ _indexer20953_))))
  (define std/srfi/19#tm:make-char-id-reader
    (lambda (_char20949_)
      (lambda (_port20951_)
        (if (char=? _char20949_ (read-char _port20951_))
            _char20949_
            (std/srfi/19#tm:time-error
             'string->date
             'bad-date-template-string
             '"Invalid character match.")))))
  (define std/srfi/19#tm:read-directives
    (let ((_ireader420883_ (std/srfi/19#tm:make-integer-reader '4))
          (_ireader220884_ (std/srfi/19#tm:make-integer-reader '2))
          (_fireader920885_ (std/srfi/19#tm:make-fractional-integer-reader '9))
          (_ireaderf20886_ (std/srfi/19#tm:make-integer-reader '#f))
          (_eireader220887_ (std/srfi/19#tm:make-integer-exact-reader '2))
          (_eireader420888_ (std/srfi/19#tm:make-integer-exact-reader '4))
          (_locale-reader-abbr-weekday20889_
           (std/srfi/19#tm:make-locale-reader
            std/srfi/19#tm:locale-abbr-weekday->index))
          (_locale-reader-long-weekday20890_
           (std/srfi/19#tm:make-locale-reader
            std/srfi/19#tm:locale-long-weekday->index))
          (_locale-reader-abbr-month20891_
           (std/srfi/19#tm:make-locale-reader
            std/srfi/19#tm:locale-abbr-month->index))
          (_locale-reader-long-month20892_
           (std/srfi/19#tm:make-locale-reader
            std/srfi/19#tm:locale-long-month->index))
          (_char-fail20893_ (lambda (_ch20878_) '#t))
          (_do-nothing20894_ (lambda (_val20880_ _object20881_) '#!void)))
      (list (list '#\~
                  _char-fail20893_
                  (std/srfi/19#tm:make-char-id-reader '#\~)
                  _do-nothing20894_)
            (list '#\a
                  char-alphabetic?
                  _locale-reader-abbr-weekday20889_
                  _do-nothing20894_)
            (list '#\A
                  char-alphabetic?
                  _locale-reader-long-weekday20890_
                  _do-nothing20894_)
            (list '#\b
                  char-alphabetic?
                  _locale-reader-abbr-month20891_
                  (lambda (_val20896_ _object20897_)
                    (##structure-set!
                     _object20897_
                     _val20896_
                     '6
                     std/srfi/19#date::t
                     '#f)))
            (list '#\B
                  char-alphabetic?
                  _locale-reader-long-month20892_
                  (lambda (_val20899_ _object20900_)
                    (##structure-set!
                     _object20900_
                     _val20899_
                     '6
                     std/srfi/19#date::t
                     '#f)))
            (list '#\d
                  char-numeric?
                  _ireader220884_
                  (lambda (_val20902_ _object20903_)
                    (##structure-set!
                     _object20903_
                     _val20902_
                     '5
                     std/srfi/19#date::t
                     '#f)))
            (list '#\e
                  _char-fail20893_
                  _eireader220887_
                  (lambda (_val20905_ _object20906_)
                    (##structure-set!
                     _object20906_
                     _val20905_
                     '5
                     std/srfi/19#date::t
                     '#f)))
            (list '#\h
                  char-alphabetic?
                  _locale-reader-abbr-month20891_
                  (lambda (_val20908_ _object20909_)
                    (##structure-set!
                     _object20909_
                     _val20908_
                     '6
                     std/srfi/19#date::t
                     '#f)))
            (list '#\H
                  char-numeric?
                  _ireader220884_
                  (lambda (_val20911_ _object20912_)
                    (##structure-set!
                     _object20912_
                     _val20911_
                     '4
                     std/srfi/19#date::t
                     '#f)))
            (list '#\k
                  _char-fail20893_
                  _eireader220887_
                  (lambda (_val20914_ _object20915_)
                    (##structure-set!
                     _object20915_
                     _val20914_
                     '4
                     std/srfi/19#date::t
                     '#f)))
            (list '#\m
                  char-numeric?
                  _ireader220884_
                  (lambda (_val20917_ _object20918_)
                    (##structure-set!
                     _object20918_
                     _val20917_
                     '6
                     std/srfi/19#date::t
                     '#f)))
            (list '#\M
                  char-numeric?
                  _ireader220884_
                  (lambda (_val20920_ _object20921_)
                    (##structure-set!
                     _object20921_
                     _val20920_
                     '3
                     std/srfi/19#date::t
                     '#f)))
            (list '#\N
                  char-numeric?
                  _fireader920885_
                  (lambda (_val20923_ _object20924_)
                    (##structure-set!
                     _object20924_
                     _val20923_
                     '1
                     std/srfi/19#date::t
                     '#f)))
            (list '#\S
                  char-numeric?
                  _ireader220884_
                  (lambda (_val20926_ _object20927_)
                    (##structure-set!
                     _object20927_
                     _val20926_
                     '2
                     std/srfi/19#date::t
                     '#f)))
            (list '#\y
                  _char-fail20893_
                  _eireader220887_
                  (lambda (_val20929_ _object20930_)
                    (##structure-set!
                     _object20930_
                     (std/srfi/19#tm:natural-year _val20929_)
                     '7
                     std/srfi/19#date::t
                     '#f)))
            (list '#\Y
                  char-numeric?
                  _ireader420883_
                  (lambda (_val20932_ _object20933_)
                    (##structure-set!
                     _object20933_
                     _val20932_
                     '7
                     std/srfi/19#date::t
                     '#f)))
            (list '#\z
                  (lambda (_c20935_)
                    (let ((_$e20937_ (char=? _c20935_ '#\Z)))
                      (if _$e20937_
                          _$e20937_
                          (let ((_$e20940_ (char=? _c20935_ '#\z)))
                            (if _$e20940_
                                _$e20940_
                                (let ((_$e20943_ (char=? _c20935_ '#\+)))
                                  (if _$e20943_
                                      _$e20943_
                                      (char=? _c20935_ '#\-))))))))
                  std/srfi/19#tm:zone-reader
                  (lambda (_val20946_ _object20947_)
                    (##structure-set!
                     _object20947_
                     _val20946_
                     '8
                     std/srfi/19#date::t
                     '#f))))))
  (define std/srfi/19#tm:string->date
    (lambda (_date20846_
             _index20847_
             _format-string20848_
             _str-len20849_
             _port20850_
             _template-string20851_)
      (letrec ((_skip-until20853_
                (lambda (_port20873_ _skipper20874_)
                  (let ((_ch20876_ (peek-char _port20873_)))
                    (if (eof-object? _ch20876_)
                        (std/srfi/19#tm:time-error
                         'string->date
                         'bad-date-format-string
                         _template-string20851_)
                        (if (not (_skipper20874_ _ch20876_))
                            (begin
                              (read-char _port20873_)
                              (_skip-until20853_ _port20873_ _skipper20874_))
                            '#!void))))))
        (if (>= _index20847_ _str-len20849_)
            '#!void
            (let ((_current-char20855_
                   (string-ref _format-string20848_ _index20847_)))
              (if (not (char=? _current-char20855_ '#\~))
                  (let ((_port-char20857_ (read-char _port20850_)))
                    (if (or (eof-object? _port-char20857_)
                            (not (char=? _current-char20855_
                                         _port-char20857_)))
                        (std/srfi/19#tm:time-error
                         'string->date
                         'bad-date-format-string
                         _template-string20851_)
                        '#!void)
                    (std/srfi/19#tm:string->date
                     _date20846_
                     (+ _index20847_ '1)
                     _format-string20848_
                     _str-len20849_
                     _port20850_
                     _template-string20851_))
                  (if (> (+ _index20847_ '1) _str-len20849_)
                      (std/srfi/19#tm:time-error
                       'string->date
                       'bad-date-format-string
                       _template-string20851_)
                      (let* ((_format-char20862_
                              (string-ref
                               _format-string20848_
                               (+ _index20847_ '1)))
                             (_format-info20864_
                              (assoc _format-char20862_
                                     std/srfi/19#tm:read-directives)))
                        (if (not _format-info20864_)
                            (std/srfi/19#tm:time-error
                             'string->date
                             'bad-date-format-string
                             _template-string20851_)
                            (let ((_skipper20867_ (cadr _format-info20864_))
                                  (_reader20868_ (caddr _format-info20864_))
                                  (_actor20869_ (cadddr _format-info20864_)))
                              (_skip-until20853_ _port20850_ _skipper20867_)
                              (let ((_val20871_ (_reader20868_ _port20850_)))
                                (if (eof-object? _val20871_)
                                    (std/srfi/19#tm:time-error
                                     'string->date
                                     'bad-date-format-string
                                     _template-string20851_)
                                    (_actor20869_ _val20871_ _date20846_)))
                              (std/srfi/19#tm:string->date
                               _date20846_
                               (+ _index20847_ '2)
                               _format-string20848_
                               _str-len20849_
                               _port20850_
                               _template-string20851_)))))))))))
  (define std/srfi/19#string->date
    (lambda (_input-string20837_ _template-string20838_)
      (letrec ((_tm:date-ok?20840_
                (lambda (_date20844_)
                  (if (##structure-ref _date20844_ '1 std/srfi/19#date::t '#f)
                      (if (##structure-ref
                           _date20844_
                           '2
                           std/srfi/19#date::t
                           '#f)
                          (if (##structure-ref
                               _date20844_
                               '3
                               std/srfi/19#date::t
                               '#f)
                              (if (##structure-ref
                                   _date20844_
                                   '4
                                   std/srfi/19#date::t
                                   '#f)
                                  (if (##structure-ref
                                       _date20844_
                                       '5
                                       std/srfi/19#date::t
                                       '#f)
                                      (if (##structure-ref
                                           _date20844_
                                           '6
                                           std/srfi/19#date::t
                                           '#f)
                                          (if (##structure-ref
                                               _date20844_
                                               '7
                                               std/srfi/19#date::t
                                               '#f)
                                              (##structure-ref
                                               _date20844_
                                               '8
                                               std/srfi/19#date::t
                                               '#f)
                                              '#f)
                                          '#f)
                                      '#f)
                                  '#f)
                              '#f)
                          '#f)
                      '#f))))
        (let ((_newdate20842_
               (##structure std/srfi/19#date::t '0 '0 '0 '0 '#f '#f '#f '0)))
          (std/srfi/19#tm:string->date
           _newdate20842_
           '0
           _template-string20838_
           (string-length _template-string20838_)
           (open-input-string _input-string20837_)
           _template-string20838_)
          (if (_tm:date-ok?20840_ _newdate20842_)
              _newdate20842_
              (std/srfi/19#tm:time-error
               'string->date
               'bad-date-format-string
               (list '"Incomplete date read. "
                     _newdate20842_
                     _template-string20838_))))))))
