/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.reader.zip;

import com.googlecode.d2j.util.zip.ZipEntry;
import com.googlecode.d2j.util.zip.ZipFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;

public class ZipUtil {
    public static byte[] toByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        int c = is.read(buff);
        while (c > 0) {
            out.write(buff, 0, c);
            c = is.read(buff);
        }
        return out.toByteArray();
    }

    public static byte[] readDex(File file) throws IOException {
        return ZipUtil.readDex(file.toPath());
    }

    public static byte[] readDex(Path file) throws IOException {
        return ZipUtil.readDex(Files.readAllBytes(file));
    }

    public static byte[] readDex(InputStream in) throws IOException {
        return ZipUtil.readDex(ZipUtil.toByteArray(in));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readDex(byte[] data) throws IOException {
        if (data.length < 3) {
            throw new IOException("File too small to be a dex/zip");
        }
        if ("dex".equals(new String(data, 0, 3, StandardCharsets.ISO_8859_1))) {
            return data;
        }
        if (!"PK".equals(new String(data, 0, 2, StandardCharsets.ISO_8859_1))) throw new IOException("the src file not a .dex or zip file");
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            byte[] byArray;
            ZipFile zipFile = new ZipFile(data);
            try {
                ZipEntry classes = zipFile.findFirstEntry("classes.dex");
                if (classes == null) throw new IOException("Can not find classes.dex in zip file");
                byArray = ZipUtil.toByteArray(zipFile.getInputStream(classes));
                return byArray;
            }
            finally {
                if (zipFile == null) return byArray;
                zipFile.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }
}

