/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.mysqlbulkfile;

import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.mysqlbulkfile.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryMysqlBulkFile
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String tablename;
    private String schemaname;
    private String filename;
    private String separator;
    private String enclosed;
    private String lineterminated;
    private String limitlines;
    private String listcolumn;
    private boolean highpriority;
    private boolean optionenclosed;
    public int outdumpvalue;
    public int iffileexists;
    private boolean addfiletoresult;
    private DatabaseMeta connection;

    public JobEntryMysqlBulkFile(String n) {
        super(n, "");
        this.tablename = null;
        this.schemaname = null;
        this.filename = null;
        this.separator = null;
        this.enclosed = null;
        this.limitlines = "0";
        this.listcolumn = null;
        this.lineterminated = null;
        this.highpriority = true;
        this.optionenclosed = false;
        this.iffileexists = 2;
        this.connection = null;
        this.addfiletoresult = false;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.MYSQL_BULK_FILE);
    }

    public JobEntryMysqlBulkFile() {
        this("");
    }

    public JobEntryMysqlBulkFile(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryMysqlBulkFile je = (JobEntryMysqlBulkFile)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"schemaname", (String)this.schemaname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"tablename", (String)this.tablename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"separator", (String)this.separator));
        retval.append("      ").append(XMLHandler.addTagValue((String)"enclosed", (String)this.enclosed));
        retval.append("      ").append(XMLHandler.addTagValue((String)"optionenclosed", (boolean)this.optionenclosed));
        retval.append("      ").append(XMLHandler.addTagValue((String)"lineterminated", (String)this.lineterminated));
        retval.append("      ").append(XMLHandler.addTagValue((String)"limitlines", (String)this.limitlines));
        retval.append("      ").append(XMLHandler.addTagValue((String)"listcolumn", (String)this.listcolumn));
        retval.append("      ").append(XMLHandler.addTagValue((String)"highpriority", (boolean)this.highpriority));
        retval.append("      ").append(XMLHandler.addTagValue((String)"outdumpvalue", (int)this.outdumpvalue));
        retval.append("      ").append(XMLHandler.addTagValue((String)"iffileexists", (int)this.iffileexists));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addfiletoresult", (boolean)this.addfiletoresult));
        retval.append("      ").append(XMLHandler.addTagValue((String)"connection", this.connection == null ? null : this.connection.getName()));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.schemaname = XMLHandler.getTagValue((Node)entrynode, (String)"schemaname");
            this.tablename = XMLHandler.getTagValue((Node)entrynode, (String)"tablename");
            this.filename = XMLHandler.getTagValue((Node)entrynode, (String)"filename");
            this.separator = XMLHandler.getTagValue((Node)entrynode, (String)"separator");
            this.enclosed = XMLHandler.getTagValue((Node)entrynode, (String)"enclosed");
            this.lineterminated = XMLHandler.getTagValue((Node)entrynode, (String)"lineterminated");
            this.limitlines = XMLHandler.getTagValue((Node)entrynode, (String)"limitlines");
            this.listcolumn = XMLHandler.getTagValue((Node)entrynode, (String)"listcolumn");
            this.highpriority = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"highpriority"));
            this.optionenclosed = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"optionenclosed"));
            this.outdumpvalue = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"outdumpvalue"), (int)-1);
            this.iffileexists = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"iffileexists"), (int)-1);
            String dbname = XMLHandler.getTagValue((Node)entrynode, (String)"connection");
            this.connection = DatabaseMeta.findDatabase(databases, (String)dbname);
            this.addfiletoresult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"addfiletoresult"));
        }
        catch (KettleException e) {
            throw new KettleXMLException("Unable to load job entry of type 'table exists' from XML node", (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.schemaname = rep.getJobEntryAttributeString(id_jobentry, "schemaname");
            this.tablename = rep.getJobEntryAttributeString(id_jobentry, "tablename");
            this.filename = rep.getJobEntryAttributeString(id_jobentry, "filename");
            this.separator = rep.getJobEntryAttributeString(id_jobentry, "separator");
            this.enclosed = rep.getJobEntryAttributeString(id_jobentry, "enclosed");
            this.lineterminated = rep.getJobEntryAttributeString(id_jobentry, "lineterminated");
            this.limitlines = rep.getJobEntryAttributeString(id_jobentry, "limitlines");
            this.listcolumn = rep.getJobEntryAttributeString(id_jobentry, "listcolumn");
            this.highpriority = rep.getJobEntryAttributeBoolean(id_jobentry, "highpriority");
            this.optionenclosed = rep.getJobEntryAttributeBoolean(id_jobentry, "optionenclosed");
            this.outdumpvalue = (int)rep.getJobEntryAttributeInteger(id_jobentry, "outdumpvalue");
            this.iffileexists = (int)rep.getJobEntryAttributeInteger(id_jobentry, "iffileexists");
            this.addfiletoresult = rep.getJobEntryAttributeBoolean(id_jobentry, "addfiletoresult");
            long id_db = rep.getJobEntryAttributeInteger(id_jobentry, "id_database");
            this.connection = id_db > 0L ? DatabaseMeta.findDatabase(databases, (long)id_db) : DatabaseMeta.findDatabase(databases, (String)rep.getJobEntryAttributeString(id_jobentry, "connection"));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry of type 'table exists' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "schemaname", this.schemaname);
            rep.saveJobEntryAttribute(id_job, this.getID(), "tablename", this.tablename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "filename", this.filename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "separator", this.separator);
            rep.saveJobEntryAttribute(id_job, this.getID(), "enclosed", this.enclosed);
            rep.saveJobEntryAttribute(id_job, this.getID(), "lineterminated", this.lineterminated);
            rep.saveJobEntryAttribute(id_job, this.getID(), "limitlines", this.limitlines);
            rep.saveJobEntryAttribute(id_job, this.getID(), "listcolumn", this.listcolumn);
            rep.saveJobEntryAttribute(id_job, this.getID(), "highpriority", this.highpriority);
            rep.saveJobEntryAttribute(id_job, this.getID(), "optionenclosed", this.optionenclosed);
            rep.saveJobEntryAttribute(id_job, this.getID(), "outdumpvalue", this.outdumpvalue);
            rep.saveJobEntryAttribute(id_job, this.getID(), "iffileexists", this.iffileexists);
            rep.saveJobEntryAttribute(id_job, this.getID(), "addfiletoresult", this.addfiletoresult);
            if (this.connection != null) {
                rep.saveJobEntryAttribute(id_job, this.getID(), "connection", this.connection.getName());
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry of type 'Mysql Bulk Load' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public void setSchemaname(String schemaname) {
        this.schemaname = schemaname;
    }

    public String getTablename() {
        return this.tablename;
    }

    public String getSchemaname() {
        return this.schemaname;
    }

    public void setDatabase(DatabaseMeta database) {
        this.connection = database;
    }

    public DatabaseMeta getDatabase() {
        return this.connection;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return false;
    }

    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        String LimitNbrLignes = "";
        String ListOfColumn = "*";
        String strHighPriority = "";
        String OutDumpText = "";
        String OptionEnclosed = "";
        String FieldSeparator = "";
        String LinesTerminated = "";
        LogWriter log = LogWriter.getInstance();
        Result result = previousResult;
        result.setResult(false);
        if (this.filename != null) {
            String realFilename = this.getRealFilename();
            File file = new File(realFilename);
            if (file.exists() && this.iffileexists == 2) {
                result.setResult(false);
                result.setNrErrors(1L);
                log.logError(this.toString(), Messages.getString("JobMysqlBulkFile.FileExists1.Label") + realFilename + Messages.getString("JobMysqlBulkFile.FileExists2.Label"), new Object[0]);
            } else if (file.exists() && this.iffileexists == 1) {
                result.setResult(true);
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobMysqlBulkFile.FileExists1.Label") + realFilename + Messages.getString("JobMysqlBulkFile.FileExists2.Label"), new Object[0]);
                }
            } else {
                if (file.exists() && this.iffileexists == 0) {
                    String wildcard = realFilename.substring(realFilename.length() - 4, realFilename.length());
                    realFilename = wildcard.substring(0, 1).equals(".") ? realFilename.substring(0, realFilename.length() - 4) + "_" + StringUtil.getFormattedDateTimeNow((boolean)true) + wildcard : realFilename + "_" + StringUtil.getFormattedDateTimeNow((boolean)true);
                    log.logDebug(this.toString(), Messages.getString("JobMysqlBulkFile.FileNameChange1.Label") + realFilename + Messages.getString("JobMysqlBulkFile.FileNameChange1.Label"), new Object[0]);
                }
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobMysqlBulkFile.FileExists1.Label") + realFilename + Messages.getString("JobMysqlBulkFile.FileExists2.Label"), new Object[0]);
                }
                if (this.connection != null) {
                    Database db = new Database(this.connection);
                    db.shareVariablesWith((VariableSpace)this);
                    try {
                        db.connect();
                        String realSchemaname = this.environmentSubstitute(this.schemaname);
                        String realTablename = this.environmentSubstitute(this.tablename);
                        if (db.checkTableExists(realTablename)) {
                            if (log.isDetailed()) {
                                log.logDetailed(this.toString(), Messages.getString("JobMysqlBulkFile.TableExists1.Label") + realTablename + Messages.getString("JobMysqlBulkFile.TableExists2.Label"), new Object[0]);
                            }
                            if (this.schemaname != null) {
                                realTablename = realSchemaname + "." + realTablename;
                            }
                            if (Const.toInt((String)this.getRealLimitlines(), (int)0) > 0) {
                                LimitNbrLignes = "LIMIT " + this.getRealLimitlines();
                            }
                            if (this.getRealListColumn() != null) {
                                ListOfColumn = this.MysqlString(this.getRealListColumn());
                            }
                            if (this.getRealSeparator() != null && this.outdumpvalue == 0) {
                                FieldSeparator = "FIELDS TERMINATED BY '" + Const.replace((String)this.getRealSeparator(), (String)"'", (String)"''") + "'";
                            }
                            if (this.getRealLineterminated() != null && this.outdumpvalue == 0) {
                                LinesTerminated = "LINES TERMINATED BY '" + Const.replace((String)this.getRealLineterminated(), (String)"'", (String)"''") + "'";
                            }
                            if (this.isHighPriority()) {
                                strHighPriority = "HIGH_PRIORITY";
                            }
                            if (this.getRealEnclosed() != null && this.outdumpvalue == 0) {
                                if (this.isOptionEnclosed()) {
                                    OptionEnclosed = "OPTIONALLY ";
                                }
                                OptionEnclosed = OptionEnclosed + "ENCLOSED BY '" + Const.replace((String)this.getRealEnclosed(), (String)"'", (String)"''") + "'";
                            }
                            OutDumpText = this.outdumpvalue == 0 ? "INTO OUTFILE" : "INTO DUMPFILE";
                            String FILEBulkFile = "SELECT " + strHighPriority + " " + ListOfColumn + " " + OutDumpText + " '" + realFilename + "' " + FieldSeparator + " " + OptionEnclosed + " " + LinesTerminated + " FROM " + realTablename + " " + LimitNbrLignes + " LOCK IN SHARE MODE";
                            try {
                                if (log.isDetailed()) {
                                    log.logDetailed(this.toString(), FILEBulkFile, new Object[0]);
                                }
                                PreparedStatement ps = db.prepareSQL(FILEBulkFile);
                                ps.execute();
                                db.disconnect();
                                if (this.isAddFileToResult()) {
                                    ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)realFilename), parentJob.getJobname(), this.toString());
                                    result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                                }
                                result.setResult(true);
                            }
                            catch (SQLException je) {
                                db.disconnect();
                                result.setNrErrors(1L);
                                log.logError(this.toString(), Messages.getString("JobMysqlBulkFile.Error.Label") + " " + je.getMessage(), new Object[0]);
                            }
                            catch (IOException e) {
                                log.logError(this.toString(), Messages.getString("JobMysqlBulkFile.Error.Label") + e.getMessage(), new Object[0]);
                                result.setNrErrors(1L);
                            }
                        } else {
                            db.disconnect();
                            result.setNrErrors(1L);
                            if (log.isDetailed()) {
                                log.logDetailed(this.toString(), Messages.getString("JobMysqlBulkFile.TableNotExists1.Label") + realTablename + Messages.getString("JobMysqlBulkFile.TableNotExists2.Label"), new Object[0]);
                            }
                        }
                    }
                    catch (KettleDatabaseException dbe) {
                        db.disconnect();
                        result.setNrErrors(1L);
                        log.logError(this.toString(), Messages.getString("JobMysqlBulkFile.Error.Label") + " " + dbe.getMessage(), new Object[0]);
                    }
                } else {
                    result.setNrErrors(1L);
                    log.logError(this.toString(), Messages.getString("JobMysqlBulkFile.Nodatabase.Label"), new Object[0]);
                }
            }
        } else {
            result.setNrErrors(1L);
            log.logError(this.toString(), Messages.getString("JobMysqlBulkFile.Nofilename.Label"), new Object[0]);
        }
        return result;
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.connection};
    }

    public void setHighPriority(boolean highpriority) {
        this.highpriority = highpriority;
    }

    public void setOptionEnclosed(boolean optionenclosed) {
        this.optionenclosed = optionenclosed;
    }

    public boolean isHighPriority() {
        return this.highpriority;
    }

    public boolean isOptionEnclosed() {
        return this.optionenclosed;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getRealFilename() {
        String RealFile = this.environmentSubstitute(this.getFilename());
        return RealFile.replace('\\', '/');
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setEnclosed(String enclosed) {
        this.enclosed = enclosed;
    }

    public void setLineterminated(String lineterminated) {
        this.lineterminated = lineterminated;
    }

    public String getLineterminated() {
        return this.lineterminated;
    }

    public String getRealLineterminated() {
        return this.environmentSubstitute(this.getLineterminated());
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getEnclosed() {
        return this.enclosed;
    }

    public String getRealSeparator() {
        return this.environmentSubstitute(this.getSeparator());
    }

    public String getRealEnclosed() {
        return this.environmentSubstitute(this.getEnclosed());
    }

    public void setLimitlines(String limitlines) {
        this.limitlines = limitlines;
    }

    public String getLimitlines() {
        return this.limitlines;
    }

    public String getRealLimitlines() {
        return this.environmentSubstitute(this.getLimitlines());
    }

    public void setListColumn(String listcolumn) {
        this.listcolumn = listcolumn;
    }

    public String getListColumn() {
        return this.listcolumn;
    }

    public String getRealListColumn() {
        return this.environmentSubstitute(this.getListColumn());
    }

    public void setAddFileToResult(boolean addfiletoresultin) {
        this.addfiletoresult = addfiletoresultin;
    }

    public boolean isAddFileToResult() {
        return this.addfiletoresult;
    }

    private String MysqlString(String listcolumns) {
        String ReturnString = "";
        String[] split = listcolumns.split(",");
        for (int i = 0; i < split.length; ++i) {
            ReturnString = ReturnString.equals("") ? "`" + Const.trim((String)split[i]) + "`" : ReturnString + ", `" + Const.trim((String)split[i]) + "`";
        }
        return ReturnString;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (this.connection != null) {
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(this.connection.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(this.connection.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "filename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "tablename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }
}

