/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap.action;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPUtil;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.olap.DimensionPane;
import ca.sqlpower.architect.swingui.olap.LevelEditPanel;
import ca.sqlpower.architect.swingui.olap.OSUtils;
import ca.sqlpower.architect.swingui.olap.action.CreateOLAPChildAction;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRuntimeException;
import ca.sqlpower.swingui.DataEntryPanel;
import java.util.List;
import javax.swing.KeyStroke;

public class CreateLevelAction
extends CreateOLAPChildAction<DimensionPane, MondrianModel.Level> {
    public CreateLevelAction(ArchitectSwingSession session, PlayPen olapPlayPen) {
        super(session, olapPlayPen, "Level", DimensionPane.class, "Hierarchy", 'l', OSUtils.LEVEL_ADD_ICON);
    }

    @Override
    protected MondrianModel.Level addNewChild(DimensionPane pane) {
        MondrianModel.Hierarchy newParent;
        MondrianModel.Dimension d = (MondrianModel.Dimension)((Object)pane.getModel());
        AddLocation addLocation = this.chooseAddLocation(pane);
        if (addLocation.newParent == null) {
            newParent = new MondrianModel.Hierarchy();
            newParent.setHasAll(true);
            newParent.setName(d.getName());
            d.addHierarchy(newParent);
            this.updateActionState();
        } else {
            newParent = addLocation.newParent;
        }
        MondrianModel.Level l = new MondrianModel.Level();
        int count = 1;
        while (!OLAPUtil.isNameUnique(newParent, MondrianModel.Level.class, "New Level " + count)) {
            ++count;
        }
        l.setName("New Level " + count);
        newParent.addLevel(addLocation.newIndex, l);
        return l;
    }

    private AddLocation chooseAddLocation(DimensionPane pane) {
        int newIndex;
        MondrianModel.Hierarchy newParent;
        List<MondrianModel.Level> selectedLevels = pane.getSelectedLevels();
        if (!selectedLevels.isEmpty()) {
            MondrianModel.Level addAfter = selectedLevels.get(selectedLevels.size() - 1);
            newParent = (MondrianModel.Hierarchy)addAfter.getParent();
            newIndex = newParent.getLevels().indexOf((Object)addAfter) + 1;
        } else {
            MondrianModel.Dimension d = (MondrianModel.Dimension)((Object)pane.getModel());
            if (d.getHierarchies().isEmpty()) {
                newParent = null;
                newIndex = 0;
            } else {
                newParent = d.getHierarchies().get(0);
                for (int i = 0; i < d.getHierarchies().size(); ++i) {
                    if (!pane.isSectionSelected(pane.getSections().get(i))) continue;
                    newParent = d.getHierarchies().get(i);
                    break;
                }
                newIndex = newParent.getLevels().size();
            }
        }
        return new AddLocation(newParent, newIndex);
    }

    @Override
    protected DataEntryPanel createDataEntryPanel(MondrianModel.Level model) {
        try {
            return new LevelEditPanel(model);
        }
        catch (SQLObjectException ex) {
            throw new SQLObjectRuntimeException(ex);
        }
    }

    @Override
    protected void updateActionState() {
        String description;
        List<PlayPenComponent> selectedItems = this.getPlaypen().getSelectedItems();
        if (selectedItems.size() == 1 && selectedItems.get(0) instanceof DimensionPane) {
            this.setEnabled(true);
            DimensionPane pane = (DimensionPane)selectedItems.get(0);
            AddLocation addLocation = this.chooseAddLocation(pane);
            String parentName = addLocation.newParent == null ? "new hierarchy" : addLocation.newParent.getName();
            description = "Add Level to " + parentName;
        } else {
            this.setEnabled(false);
            description = "Add Level to selected Hierarchy (" + ((KeyStroke)this.getValue("AcceleratorKey")).getKeyChar() + ")";
        }
        this.putValue("ShortDescription", description);
    }

    private static class AddLocation {
        private final MondrianModel.Hierarchy newParent;
        private final int newIndex;

        public AddLocation(MondrianModel.Hierarchy newParent, int newIndex) {
            this.newParent = newParent;
            this.newIndex = newIndex;
        }
    }
}

