/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.IOException;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.util.CamelContextHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultComponentResolver
implements ComponentResolver {
    public static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/component/";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultComponentResolver.class);
    private FactoryFinder factoryFinder;

    @Override
    public Component resolveComponent(String name, CamelContext context) {
        Class<?> type;
        Object bean = null;
        try {
            bean = context.getRegistry().lookupByName(name);
            this.getLog().debug("Found component: {} in registry: {}", (Object)name, bean);
        }
        catch (Exception e) {
            this.getLog().debug("Ignored error looking up bean: " + name, e);
        }
        if (bean != null) {
            if (bean instanceof Component) {
                return (Component)bean;
            }
            Component component = CamelContextHelper.convertTo(context, Component.class, bean);
            if (component != null) {
                return component;
            }
        }
        try {
            type = this.findComponent(name, context);
            if (type == null) {
                return null;
            }
        }
        catch (NoFactoryAvailableException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid URI, no Component registered for scheme: " + name, e);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Found component: {} via type: {} via: {}{}", name, type.getName(), this.factoryFinder.getResourcePath(), name);
        }
        if (Component.class.isAssignableFrom(type)) {
            return (Component)context.getInjector().newInstance(type);
        }
        throw new IllegalArgumentException("Type is not a Component implementation. Found: " + type.getName());
    }

    private Class<?> findComponent(String name, CamelContext context) throws ClassNotFoundException, IOException {
        if (this.factoryFinder == null) {
            this.factoryFinder = context.getFactoryFinder(RESOURCE_PATH);
        }
        return this.factoryFinder.findClass(name);
    }

    protected Logger getLog() {
        return LOG;
    }
}

