/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.StreamError;
import org.armedbear.lisp.Symbol;

public final class ReaderError
extends StreamError {
    public ReaderError(String message) {
        super(StandardClass.READER_ERROR);
        this.setFormatControl(message.replaceAll("~", "~~"));
        this.setFormatArguments(Lisp.NIL);
    }

    public ReaderError(String message, Stream stream) {
        super(StandardClass.READER_ERROR);
        this.setFormatControl(message.replaceAll("~", "~~"));
        this.setFormatArguments(Lisp.NIL);
        this.setStream(stream);
    }

    public ReaderError(LispObject initArgs) {
        super(StandardClass.READER_ERROR);
        this.initialize(initArgs);
    }

    @Override
    public LispObject typeOf() {
        return Symbol.READER_ERROR;
    }

    @Override
    public LispObject classOf() {
        return StandardClass.READER_ERROR;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.READER_ERROR) {
            return Lisp.T;
        }
        if (type == StandardClass.READER_ERROR) {
            return Lisp.T;
        }
        if (type == Symbol.PARSE_ERROR) {
            return Lisp.T;
        }
        if (type == StandardClass.PARSE_ERROR) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

