/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.attribute;

import java.util.ArrayList;
import java.util.Iterator;
import org.ice4j.StunException;
import org.ice4j.attribute.Attribute;

public class UnknownAttributesAttribute
extends Attribute {
    public static String NAME = "UNKNOWN-ATTRIBUTES";
    private ArrayList<Character> unknownAttributes = new ArrayList();

    UnknownAttributesAttribute() {
        super('\n');
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public char getDataLength() {
        char len = (char)this.unknownAttributes.size();
        if (len % 2 != 0) {
            len = (char)(len + '\u0001');
        }
        return (char)(len * 2);
    }

    public void addAttributeID(char attributeID) {
        if (!this.contains(attributeID)) {
            this.unknownAttributes.add(Character.valueOf(attributeID));
        }
    }

    public boolean contains(char attributeID) {
        return this.unknownAttributes.contains(Character.valueOf(attributeID));
    }

    public Iterator<Character> getAttributes() {
        return this.unknownAttributes.iterator();
    }

    public int getAttributeCount() {
        return this.unknownAttributes.size();
    }

    public char getAttribute(int index) {
        return this.unknownAttributes.get(index).charValue();
    }

    @Override
    public byte[] encode() {
        char att;
        byte[] binValue = new byte[this.getDataLength() + 4];
        int offset = 0;
        binValue[offset++] = (byte)(this.getAttributeType() >> 8);
        binValue[offset++] = (byte)(this.getAttributeType() & 0xFF);
        binValue[offset++] = (byte)(this.getDataLength() >> 8);
        binValue[offset++] = (byte)(this.getDataLength() & 0xFF);
        Iterator<Character> attributes = this.getAttributes();
        while (attributes.hasNext()) {
            att = attributes.next().charValue();
            binValue[offset++] = (byte)(att >> 8);
            binValue[offset++] = (byte)(att & 0xFF);
        }
        if (offset < binValue.length) {
            att = this.getAttribute(0);
            binValue[offset++] = (byte)(att >> 8);
            binValue[offset++] = (byte)(att & 0xFF);
        }
        return binValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof UnknownAttributesAttribute) || obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        UnknownAttributesAttribute att = (UnknownAttributesAttribute)obj;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && this.unknownAttributes.equals(att.unknownAttributes);
    }

    @Override
    void decodeAttributeBody(byte[] attributeValue, char offset, char length) throws StunException {
        if (length % 2 != 0) {
            throw new StunException("Attribute IDs are 2 bytes long and the passed binary array has an odd length value.");
        }
        int originalOffset = offset;
        for (int i = offset; i < originalOffset + length; i += 2) {
            int n = offset;
            int n2 = offset = (char)(offset + '\u0001');
            offset = (char)(offset + '\u0001');
            char attributeID = (char)(attributeValue[n] << 8 | attributeValue[n2]);
            this.addAttributeID(attributeID);
        }
    }
}

