/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public abstract class PagingTableModel<T>
extends AbstractTableModel {
    private static final long serialVersionUID = -6353414328926478100L;
    private static final Logger logger = Logger.getLogger(PagingTableModel.class);
    public static final String DEFAULT_SEGMENT_LOADER_THREAD_NAME = "ZAP-PagingTableModel-SegmentLoaderThread";
    public static final int DEFAULT_MAX_PAGE_SIZE = 50;
    private int maxPageSize;
    private int dataOffset = 0;
    private List<T> data = Collections.emptyList();
    private SortedSet<Segment> pending = new TreeSet<Segment>();
    private final String segmentLoaderThreadName;

    public PagingTableModel() {
        this(DEFAULT_SEGMENT_LOADER_THREAD_NAME, 50);
    }

    public PagingTableModel(String segmentLoaderThreadName) {
        this(segmentLoaderThreadName, 50);
    }

    public PagingTableModel(int maxPageSize) {
        this(DEFAULT_SEGMENT_LOADER_THREAD_NAME, maxPageSize);
    }

    public PagingTableModel(String segmentLoaderThreadName, int maxPageSize) {
        this.segmentLoaderThreadName = segmentLoaderThreadName;
        this.setMaxPageSizeWithoutPageChanges(maxPageSize);
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    public void setMaxPageSize(int maxPageSize) {
        if (maxPageSize <= 0) {
            throw new IllegalArgumentException("Parameter maxPageSize must be greater than zero.");
        }
        if (this.maxPageSize == maxPageSize) {
            return;
        }
        int oldMaxPageSize = this.maxPageSize;
        this.setMaxPageSizeWithoutPageChanges(maxPageSize);
        int rowCount = this.getRowCount();
        if (rowCount > 0) {
            if (maxPageSize > oldMaxPageSize) {
                this.schedule(this.dataOffset);
            } else if (this.data.size() > maxPageSize) {
                final List<T> shrunkData = this.data.subList(0, maxPageSize);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PagingTableModel.this.setData(PagingTableModel.this.dataOffset, new ArrayList(shrunkData));
                    }
                });
            }
        }
    }

    public void setMaxPageSizeWithoutPageChanges(int maxPageSize) {
        if (maxPageSize <= 0) {
            throw new IllegalArgumentException("Parameter maxPageSize must be greater than zero.");
        }
        this.maxPageSize = maxPageSize;
    }

    @Override
    public void fireTableDataChanged() {
        this.clear();
        super.fireTableDataChanged();
    }

    @Override
    public abstract int getRowCount();

    protected abstract Object getRealValueAt(T var1, int var2);

    protected abstract Object getPlaceholderValueAt(int var1);

    protected abstract List<T> loadPage(int var1, int var2);

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        T rowObject = this.getRowObject(rowIndex);
        if (rowObject == null) {
            this.schedule(rowIndex);
            return this.getPlaceholderValueAt(columnIndex);
        }
        return this.getRealValueAt(rowObject, columnIndex);
    }

    protected T getRowObject(int rowIndex) {
        int pageIndex = rowIndex - this.dataOffset;
        if (pageIndex >= 0 && pageIndex < this.data.size()) {
            return this.data.get(pageIndex);
        }
        return null;
    }

    private void schedule(int offset) {
        if (this.isPending(offset)) {
            return;
        }
        int startOffset = Math.max(0, offset - this.maxPageSize / 2);
        int length = offset + this.maxPageSize / 2 - startOffset;
        this.load(startOffset, length);
    }

    private boolean isPending(int offset) {
        int pendingCount = this.pending.size();
        if (pendingCount == 0) {
            return false;
        }
        if (pendingCount == 1) {
            Segment seg = this.pending.first();
            return seg.contains(offset);
        }
        Segment low = new Segment(offset - this.maxPageSize, 0);
        Segment high = new Segment(offset + 1, 0);
        for (Segment seg : this.pending.subSet(low, high)) {
            if (!seg.contains(offset)) continue;
            return true;
        }
        return false;
    }

    private void load(int startOffset, int length) {
        Segment seg = new Segment(startOffset, length);
        this.pending.add(seg);
        SegmentLoaderThread segmentLoader = new SegmentLoaderThread(seg, this.segmentLoaderThreadName);
        segmentLoader.start();
    }

    private void setData(int offset, List<T> page) {
        int lastRow = offset + page.size() - 1;
        this.dataOffset = offset;
        this.data = page;
        this.fireTableRowsUpdated(offset, lastRow);
    }

    protected void clear() {
        this.data.clear();
        this.data = Collections.emptyList();
        this.pending.clear();
    }

    private class SegmentLoaderThread
    extends Thread {
        private final Segment segment;

        public SegmentLoaderThread(Segment segment, String name) {
            super(name);
            this.segment = segment;
        }

        @Override
        public void run() {
            List page;
            try {
                page = PagingTableModel.this.loadPage(this.segment.getBase(), this.segment.getLength());
            }
            catch (Exception e) {
                logger.warn((Object)("error retrieving page at " + this.segment.getBase() + ": aborting"), (Throwable)e);
                PagingTableModel.this.pending.remove(this.segment);
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PagingTableModel.this.setData(SegmentLoaderThread.this.segment.getBase(), page);
                    PagingTableModel.this.pending.remove(SegmentLoaderThread.this.segment);
                }
            });
        }
    }

    static final class Segment
    implements Comparable<Segment> {
        private final int base;
        private final int length;

        public Segment(int base, int length) {
            this.base = base;
            this.length = length;
        }

        public int getBase() {
            return this.base;
        }

        public int getLength() {
            return this.length;
        }

        public boolean contains(int pos) {
            return this.base <= pos && pos < this.base + this.length;
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof Segment) {
                Segment s = (Segment)o;
                boolean hasSameBase = this.base == s.base;
                boolean hasSameLength = this.length == s.length;
                return hasSameBase && hasSameLength;
            }
            return false;
        }

        public int hashCode() {
            return 41 * (41 + this.base) + this.length;
        }

        @Override
        public int compareTo(Segment other) {
            int d = this.base - other.base;
            if (d != 0) {
                return d;
            }
            return this.length - other.length;
        }
    }
}

