/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.util.Locale;
import java.util.StringTokenizer;
import net.htmlparser.jericho.Source;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.parser.SpiderParser;

public class SpiderRobotstxtParser
extends SpiderParser {
    private static final String PATTERNS_USERAGENT = "(?i)^User-agent:.*";
    private static final String PATTERNS_DISALLOW = "(?i)Disallow:.*";
    private static final String PATTERNS_ALLOW = "(?i)Allow:.*";
    private static final int PATTERNS_USERAGENT_LENGTH = 11;
    private static final int PATTERNS_DISALLOW_LENGTH = 9;
    private static final int PATTERNS_ALLOW_LENGTH = 6;
    private SpiderParam params;

    public SpiderRobotstxtParser(SpiderParam params) {
        this.params = params;
    }

    @Override
    public boolean parseResource(HttpMessage message, Source source, int depth) {
        if (message == null || !this.params.isParseRobotsTxt()) {
            return false;
        }
        log.debug((Object)"Parsing a robots.txt resource...");
        String content = message.getResponseBody().toString();
        String baseURL = message.getRequestHeader().getURI().toString();
        boolean inMatchingUserAgent = false;
        StringTokenizer st = new StringTokenizer(content, "\n");
        while (st.hasMoreTokens()) {
            String path;
            String line = st.nextToken();
            int commentStart = line.indexOf("#");
            if (commentStart != -1) {
                line = line.substring(0, commentStart);
            }
            line = line.replaceAll("<[^>]+>", "");
            if ((line = line.trim()).length() == 0) continue;
            log.debug((Object)("Processing robots.txt line: " + line));
            if (line.matches(PATTERNS_USERAGENT)) {
                String ua = line.substring(11).trim().toLowerCase(Locale.ENGLISH);
                if (ua.equals("*") || ua.contains("")) {
                    log.debug((Object)"Parsing robots.txt file. Starting section applying to spider.");
                    inMatchingUserAgent = true;
                    continue;
                }
                log.debug((Object)"Parsing robots.txt file. Start section not applying to spider.");
                inMatchingUserAgent = false;
                continue;
            }
            if (line.matches(PATTERNS_DISALLOW)) {
                path = line.substring(9).trim();
                if (path.endsWith("*")) {
                    path = path.substring(0, path.length() - 1);
                }
                if ((path = path.trim()).length() <= 0) continue;
                this.processURL(message, depth, path, baseURL);
                continue;
            }
            if (!line.matches(PATTERNS_ALLOW)) continue;
            path = line.substring(6).trim();
            if (path.endsWith("*")) {
                path = path.substring(0, path.length() - 1);
            }
            if ((path = path.trim()).length() <= 0) continue;
            this.processURL(message, depth, path, baseURL);
        }
        return true;
    }

    @Override
    public boolean canParseResource(HttpMessage message, String path, boolean wasAlreadyParsed) {
        return path != null && path.equalsIgnoreCase("/robots.txt");
    }
}

