/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.session;

import java.lang.ref.WeakReference;
import java.net.HttpCookie;
import java.util.Iterator;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpState;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.api.ApiDynamicActionImplementor;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.httpsessions.ExtensionHttpSessions;
import org.zaproxy.zap.extension.httpsessions.HttpSessionTokensSet;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.session.AbstractSessionManagementMethodOptionsPanel;
import org.zaproxy.zap.session.SessionManagementMethod;
import org.zaproxy.zap.session.SessionManagementMethodType;
import org.zaproxy.zap.session.WebSession;
import org.zaproxy.zap.utils.ApiUtils;

public class CookieBasedSessionManagementMethodType
extends SessionManagementMethodType {
    private static final int METHOD_IDENTIFIER = 0;
    private static final Logger log = Logger.getLogger(CookieBasedSessionManagementMethod.class);
    private static final String METHOD_NAME = Constant.messages.getString("sessionmanagement.method.cb.name");
    private static final String API_METHOD_NAME = "cookieBasedSessionManagement";

    @Override
    public CookieBasedSessionManagementMethod createSessionManagementMethod(int contextId) {
        return new CookieBasedSessionManagementMethod(contextId);
    }

    @Override
    public String getName() {
        return METHOD_NAME;
    }

    @Override
    public AbstractSessionManagementMethodOptionsPanel buildOptionsPanel(Context uiSharedContext) {
        return null;
    }

    @Override
    public boolean hasOptionsPanel() {
        return false;
    }

    @Override
    public boolean isTypeForMethod(SessionManagementMethod method) {
        return method instanceof CookieBasedSessionManagementMethod;
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
    }

    @Override
    public int getUniqueIdentifier() {
        return 0;
    }

    @Override
    public SessionManagementMethod loadMethodFromSession(Session session, int contextId) throws DatabaseException {
        return new CookieBasedSessionManagementMethod(contextId);
    }

    @Override
    public void persistMethodToSession(Session session, int contextId, SessionManagementMethod method) throws SessionManagementMethodType.UnsupportedSessionManagementMethodException, DatabaseException {
    }

    @Override
    public void exportData(Configuration config, SessionManagementMethod sessionMethod) {
    }

    @Override
    public void importData(Configuration config, SessionManagementMethod sessionMethod) throws ConfigurationException {
    }

    @Override
    public ApiDynamicActionImplementor getSetMethodForContextApiAction() {
        return new ApiDynamicActionImplementor(API_METHOD_NAME, null, null){

            @Override
            public void handleAction(JSONObject params) throws ApiException {
                Context context = ApiUtils.getContextByParamId(params, "contextId");
                context.setSessionManagementMethod(CookieBasedSessionManagementMethodType.this.createSessionManagementMethod(context.getIndex()));
            }
        };
    }

    public static class CookieBasedSession
    extends WebSession {
        private static int generatedNameIndex;

        public CookieBasedSession(String name) {
            super(name, new HttpState());
        }

        public CookieBasedSession() {
            super("Cookie Based Session " + generatedNameIndex++, new HttpState());
        }
    }

    public static class CookieBasedSessionManagementMethod
    implements SessionManagementMethod {
        private int contextId;
        private Context context;
        private static WeakReference<ExtensionHttpSessions> extHttpSessions;

        public CookieBasedSessionManagementMethod(int contextId) {
            this.contextId = contextId;
        }

        public String toString() {
            return METHOD_NAME;
        }

        @Override
        public boolean isConfigured() {
            return true;
        }

        private Cookie convertCookie(HttpCookie cookie) {
            Cookie c = new Cookie(cookie.getDomain(), cookie.getName(), cookie.getValue(), cookie.getPath(), (int)cookie.getMaxAge(), cookie.getSecure());
            c.setVersion(cookie.getVersion());
            c.setComment(cookie.getComment());
            return c;
        }

        @Override
        public WebSession extractWebSession(HttpMessage msg) {
            if (msg.getRequestingUser() != null) {
                return msg.getRequestingUser().getAuthenticatedSession();
            }
            CookieBasedSession session = new CookieBasedSession();
            for (HttpCookie c : msg.getRequestHeader().getHttpCookies()) {
                session.getHttpState().addCookie(this.convertCookie(c));
            }
            for (HttpCookie c : msg.getResponseHeader().getHttpCookies(msg.getRequestHeader().getHostName())) {
                session.getHttpState().addCookie(this.convertCookie(c));
            }
            return session;
        }

        @Override
        public void processMessageToMatchSession(HttpMessage message, WebSession session) throws SessionManagementMethod.UnsupportedWebSessionException {
            if (session.getHttpState() == null) {
                return;
            }
            session.getHttpState().purgeExpiredCookies();
            List<HttpCookie> cookies = message.getRequestHeader().getHttpCookies();
            Iterator<HttpCookie> it = cookies.iterator();
            block0: while (it.hasNext()) {
                HttpCookie c = it.next();
                for (Cookie sc : session.getHttpState().getCookies()) {
                    if (!sc.getName().equals(c.getName())) continue;
                    it.remove();
                    continue block0;
                }
            }
            message.setCookies(cookies);
        }

        private ExtensionHttpSessions getHttpSessionsExtension() {
            if ((extHttpSessions == null || extHttpSessions.get() == null) && (extHttpSessions = new WeakReference<ExtensionHttpSessions>(Control.getSingleton().getExtensionLoader().getExtension(ExtensionHttpSessions.class))) == null) {
                log.error((Object)"An error occured while loading the ExtensionHttpSessions.");
            }
            return (ExtensionHttpSessions)extHttpSessions.get();
        }

        private Context getContext() {
            if (this.context == null) {
                this.context = Model.getSingleton().getSession().getContext(this.contextId);
            }
            return this.context;
        }

        @Override
        public SessionManagementMethod clone() {
            return new CookieBasedSessionManagementMethod(this.contextId);
        }

        @Override
        public void clearWebSessionIdentifiers(HttpMessage msg) {
            HttpSessionTokensSet tokens = this.getHttpSessionsExtension().getHttpSessionTokensSetForContext(this.getContext());
            if (tokens == null) {
                log.info((Object)"No tokens to clear.");
                return;
            }
            List<HttpCookie> requestCookies = msg.getRequestHeader().getHttpCookies();
            Iterator<HttpCookie> it = requestCookies.iterator();
            while (it.hasNext()) {
                if (!tokens.isSessionToken(it.next().getName())) continue;
                it.remove();
            }
            msg.setCookies(requestCookies);
        }

        @Override
        public SessionManagementMethodType getType() {
            return new CookieBasedSessionManagementMethodType();
        }

        @Override
        public ApiResponse getApiResponseRepresentation() {
            return new ApiResponseElement("methodName", CookieBasedSessionManagementMethodType.API_METHOD_NAME);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.contextId;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CookieBasedSessionManagementMethod other = (CookieBasedSessionManagementMethod)obj;
            return this.contextId == other.contextId;
        }

        @Override
        public WebSession createEmptyWebSession() {
            return new CookieBasedSession();
        }
    }
}

