/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.spider;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.tree.TreeNode;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.spider.ExtensionSpider;
import org.zaproxy.zap.extension.spider.SpiderPanelTableModel;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.ScanListenner;
import org.zaproxy.zap.model.ScanThread;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.TechSet;
import org.zaproxy.zap.spider.Spider;
import org.zaproxy.zap.spider.SpiderListener;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.SpiderTaskResult;
import org.zaproxy.zap.spider.filters.FetchFilter;
import org.zaproxy.zap.spider.filters.ParseFilter;
import org.zaproxy.zap.spider.parser.SpiderParser;
import org.zaproxy.zap.users.User;

public class SpiderThread
extends ScanThread
implements SpiderListener {
    private boolean stopScan = false;
    private boolean isPaused = false;
    private boolean isAlive = false;
    private ExtensionSpider extension;
    private Spider spider = null;
    private List<SpiderListener> pendingSpiderListeners;
    private int spiderDone = 0;
    private int spiderTodo = 1;
    private static final Logger log = Logger.getLogger(SpiderThread.class);
    private boolean justScanInScope = false;
    private boolean scanChildren = false;
    private Context scanContext = null;
    private User scanUser = null;
    private SpiderPanelTableModel resultsModel;
    private SpiderPanelTableModel addedNodesModel;
    private URI startURI = null;
    private SpiderParam spiderParams;
    private List<SpiderParser> customSpiderParsers = null;
    private List<FetchFilter> customFetchFilters = null;
    private List<ParseFilter> customParseFilters = null;
    private final String id;

    @Deprecated
    public SpiderThread(ExtensionSpider extension, SpiderParam spiderParams, String site, ScanListenner listenner) {
        this("?", extension, spiderParams, site, listenner);
    }

    public SpiderThread(String id, ExtensionSpider extension, SpiderParam spiderParams, String site, ScanListenner listenner) {
        super(site, listenner);
        log.debug((Object)("Initializing spider thread for site: " + site));
        this.id = id;
        this.extension = extension;
        this.site = site;
        this.pendingSpiderListeners = new LinkedList<SpiderListener>();
        this.resultsModel = extension.getView() != null ? new SpiderPanelTableModel() : null;
        this.addedNodesModel = new SpiderPanelTableModel(false);
        this.spiderParams = spiderParams;
        this.setName("ZAP-SpiderInitThread-" + id);
    }

    @Override
    public void run() {
        try {
            this.runScan();
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while starting the spider:", (Throwable)e);
            this.stopScan();
        }
    }

    private void runScan() {
        this.spiderDone = 0;
        Date start = new Date();
        log.info((Object)("Starting spidering scan on " + this.site + " at " + start));
        this.startSpider();
        this.isAlive = true;
    }

    @Override
    public void stopScan() {
        if (this.spider != null) {
            this.spider.stop();
        }
        this.stopScan = true;
        this.isAlive = false;
        this.listenner.scanFinshed(this.site);
    }

    @Override
    public boolean isStopped() {
        return this.stopScan;
    }

    @Override
    public boolean isRunning() {
        return this.isAlive;
    }

    public DefaultListModel<?> getList() {
        return null;
    }

    @Override
    public void pauseScan() {
        if (this.spider != null) {
            this.spider.pause();
        }
        this.isPaused = true;
    }

    @Override
    public void resumeScan() {
        if (this.spider != null) {
            this.spider.resume();
        }
        this.isPaused = false;
    }

    @Override
    public boolean isPaused() {
        return this.isPaused;
    }

    @Override
    public int getMaximum() {
        return this.spiderDone + this.spiderTodo;
    }

    private void startSpider() {
        this.spider = new Spider(this.id, this.extension, this.spiderParams, this.extension.getModel().getOptionsParam().getConnectionParam(), this.extension.getModel(), this.scanContext);
        this.spider.addSpiderListener(this);
        for (SpiderListener l : this.pendingSpiderListeners) {
            this.spider.addSpiderListener(l);
        }
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.addAll(this.extension.getExcludeList());
        excludeList.addAll(this.extension.getModel().getSession().getExcludeFromSpiderRegexs());
        excludeList.addAll(this.extension.getModel().getSession().getGlobalExcludeURLRegexs());
        this.spider.setExcludeList(excludeList);
        this.addSeeds();
        this.spider.setScanAsUser(this.scanUser);
        if (this.customSpiderParsers != null) {
            for (SpiderParser sp : this.customSpiderParsers) {
                this.spider.addCustomParser(sp);
            }
        }
        if (this.customFetchFilters != null) {
            for (FetchFilter ff : this.customFetchFilters) {
                this.spider.addFetchFilter(ff);
            }
        }
        if (this.customParseFilters != null) {
            for (ParseFilter pf : this.customParseFilters) {
                this.spider.addParseFilter(pf);
            }
        }
        this.spider.start();
    }

    private void addSeeds() {
        this.addStartSeeds();
        List<Object> nodesInScope = Collections.emptyList();
        if (this.scanContext != null) {
            log.debug((Object)("Adding seed for Scan of all in context " + this.scanContext.getName()));
            nodesInScope = this.scanContext.getNodesInContextFromSiteTree();
        } else if (this.justScanInScope) {
            log.debug((Object)"Adding seed for Scan of all in scope.");
            nodesInScope = Model.getSingleton().getSession().getNodesInScopeFromSiteTree();
        }
        if (!nodesInScope.isEmpty()) {
            for (SiteNode node : nodesInScope) {
                this.addSeed(node);
            }
        }
    }

    private void addStartSeeds() {
        if (this.scanContext != null) {
            if (this.startNode != null && this.scanContext.isInContext(this.startNode)) {
                this.addSeed(this.startNode);
            }
            if (this.startURI != null && this.scanContext.isInContext(this.startURI.toString())) {
                this.spider.addSeed(this.startURI);
            }
            return;
        }
        if (this.justScanInScope) {
            if (this.startNode != null && Model.getSingleton().getSession().isInScope(this.startNode)) {
                this.addSeed(this.startNode);
            }
            if (this.startURI != null && Model.getSingleton().getSession().isInScope(this.startURI.toString())) {
                this.spider.addSeed(this.startURI);
            }
            return;
        }
        if (this.startNode != null) {
            this.addSeeds(this.startNode);
        }
        if (this.startURI != null) {
            this.spider.addSeed(this.startURI);
        }
    }

    private void addSeed(SiteNode node) {
        try {
            HttpMessage msg;
            if (!node.isRoot() && node.getHistoryReference() != null && !(msg = node.getHistoryReference().getHttpMessage()).getResponseHeader().isImage()) {
                this.spider.addSeed(msg);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while adding seed for Spider scan: " + e.getMessage()), (Throwable)e);
        }
    }

    private void addSeeds(SiteNode node) {
        this.addSeed(node);
        if (this.scanChildren) {
            Enumeration<TreeNode> en = node.children();
            while (en.hasMoreElements()) {
                SiteNode sn = (SiteNode)en.nextElement();
                this.addSeeds(sn);
            }
        }
    }

    @Override
    public void spiderComplete(boolean successful) {
        log.info((Object)("Spider scanning complete: " + successful));
        this.stopScan = true;
        this.isAlive = false;
        this.listenner.scanFinshed(this.site);
    }

    @Override
    public void foundURI(String uri, String method, FetchFilter.FetchStatus status) {
        if (this.resultsModel != null) {
            this.addUriToResultsModel(uri, method, status);
        }
    }

    private void addUriToResultsModel(final String uri, final String method, final FetchFilter.FetchStatus status) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpiderThread.this.addUriToResultsModel(uri, method, status);
                }
            });
            return;
        }
        if (status == FetchFilter.FetchStatus.VALID) {
            this.resultsModel.addScanResult(uri, method, null, false);
        } else {
            this.resultsModel.addScanResult(uri, method, this.getStatusLabel(status), status != FetchFilter.FetchStatus.SEED);
        }
        this.extension.getSpiderPanel().updateFoundCount();
    }

    private void addUriToAddedNodesModel(final String uri, final String method, final String params) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpiderThread.this.addUriToAddedNodesModel(uri, method, params);
                }
            });
            return;
        }
        this.addedNodesModel.addScanResult(uri, method, null, false);
        if (this.extension.getView() != null) {
            this.extension.getSpiderPanel().updateAddedCount();
        }
    }

    private String getStatusLabel(FetchFilter.FetchStatus status) {
        switch (status) {
            case SEED: {
                return Constant.messages.getString("spider.table.flags.seed");
            }
            case OUT_OF_CONTEXT: {
                return Constant.messages.getString("spider.table.flags.outofcontext");
            }
            case OUT_OF_SCOPE: {
                return Constant.messages.getString("spider.table.flags.outofscope");
            }
            case ILLEGAL_PROTOCOL: {
                return Constant.messages.getString("spider.table.flags.illegalprotocol");
            }
            case USER_RULES: {
                return Constant.messages.getString("spider.table.flags.userrules");
            }
        }
        return status.toString();
    }

    @Override
    public void notifySpiderTaskResult(SpiderTaskResult spiderTaskResult) {
        try {
            HttpMessage msg = spiderTaskResult.getHttpMessage();
            int type = msg.isResponseFromTargetHost() ? 2 : 19;
            HistoryReference historyRef = new HistoryReference(this.extension.getModel().getSession(), type, msg);
            if (msg.isResponseFromTargetHost()) {
                this.addMessageToSitesTree(historyRef, msg);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void addMessageToSitesTree(final HistoryReference historyReference, final HttpMessage message) {
        if (View.isInitialised() && !EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpiderThread.this.addMessageToSitesTree(historyReference, message);
                }
            });
            return;
        }
        StructuralNode node = SessionStructure.addPath(Model.getSingleton().getSession(), historyReference, message, true);
        if (node != null) {
            try {
                this.addUriToAddedNodesModel(SessionStructure.getNodeName(message), message.getRequestHeader().getMethod(), "");
            }
            catch (URIException e) {
                log.error((Object)("Error while adding node to added nodes model: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public void spiderProgress(int percentageComplete, int numberCrawled, int numberToCrawl) {
        this.spiderDone = numberCrawled;
        this.spiderTodo = numberToCrawl;
        this.scanProgress(this.site, numberCrawled, numberCrawled + numberToCrawl);
    }

    @Override
    public SiteNode getStartNode() {
        return this.startNode;
    }

    @Override
    public void setStartNode(SiteNode startNode) {
        this.startNode = startNode;
    }

    public void setStartURI(URI startURI) {
        this.startURI = startURI;
    }

    @Override
    public void reset() {
        if (this.resultsModel != null) {
            this.resultsModel.removeAllElements();
        }
        if (this.addedNodesModel != null) {
            this.addedNodesModel.removeAllElements();
        }
    }

    public void addSpiderListener(SpiderListener listener) {
        if (this.spider != null) {
            this.spider.addSpiderListener(listener);
        } else {
            this.pendingSpiderListeners.add(listener);
        }
    }

    @Override
    public void setJustScanInScope(boolean scanInScope) {
        this.justScanInScope = scanInScope;
    }

    @Override
    public boolean getJustScanInScope() {
        return this.justScanInScope;
    }

    @Override
    public void setScanChildren(boolean scanChildren) {
        this.scanChildren = scanChildren;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    public SpiderPanelTableModel getResultsTableModel() {
        return this.resultsModel;
    }

    public SpiderPanelTableModel getAddedNodesTableModel() {
        return this.addedNodesModel;
    }

    @Override
    public void setScanContext(Context context) {
        this.scanContext = context;
    }

    @Override
    public void setScanAsUser(User user) {
        this.scanUser = user;
    }

    @Override
    public void setTechSet(TechSet techSet) {
    }

    public void setCustomSpiderParsers(List<SpiderParser> customSpiderParsers) {
        this.customSpiderParsers = customSpiderParsers;
    }

    public void setCustomFetchFilters(List<FetchFilter> customFetchFilters) {
        this.customFetchFilters = customFetchFilters;
    }

    public void setCustomParseFilters(List<ParseFilter> customParseFilters) {
        this.customParseFilters = customParseFilters;
    }

    public int getNumberOfNodesAdded() {
        return this.getAddedNodesTableModel().getRowCount();
    }
}

