/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.impl.models.http.response;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.AbstractHttpByteHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.HttpPanelViewModelUtils;

public class ResponseBodyByteHttpPanelViewModel
extends AbstractHttpByteHttpPanelViewModel {
    @Override
    public byte[] getData() {
        if (this.httpMessage == null) {
            return new byte[0];
        }
        if ("gzip".equals(this.httpMessage.getResponseHeader().getHeader("Content-Encoding"))) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.httpMessage.getResponseBody().getBytes());
                GZIPInputStream gis = new GZIPInputStream(bais);
                InputStreamReader isr = new InputStreamReader(gis);
                BufferedReader br = new BufferedReader(isr);
                StringBuilder sb = new StringBuilder();
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                br.close();
                isr.close();
                gis.close();
                bais.close();
                return sb.toString().getBytes();
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
        return this.httpMessage.getResponseBody().getBytes();
    }

    @Override
    public void setData(byte[] data) {
        if (this.httpMessage == null) {
            return;
        }
        if ("gzip".equals(this.httpMessage.getResponseHeader().getHeader("Content-Encoding"))) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gis = new GZIPOutputStream(baos);
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)gis, "UTF-8"));
                bw.append(new String(data));
                bw.close();
                gis.close();
                baos.close();
                this.httpMessage.getResponseBody().setBody(baos.toByteArray());
                HttpPanelViewModelUtils.updateResponseContentLength(this.httpMessage);
            }
            catch (IOException e) {
                System.out.println(e);
            }
        } else {
            this.httpMessage.getResponseBody().setBody(data);
            HttpPanelViewModelUtils.updateResponseContentLength(this.httpMessage);
        }
    }
}

