/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ext;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;

public class ExtensionParam
extends AbstractParam {
    private static final Logger LOGGER = Logger.getLogger(ExtensionParam.class);
    private static final String EXTENSION_BASE_KEY = "extensions";
    private static final String ALL_EXTENSIONS_KEY = "extensions.extension";
    private static final String EXTENSION_NAME_KEY = "name";
    private static final String EXTENSION_ENABLED_KEY = "enabled";
    private Map<String, Boolean> extensionsState = Collections.emptyMap();

    @Override
    protected void parse() {
        try {
            List fields = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(ALL_EXTENSIONS_KEY);
            HashMap<String, Boolean> extensions = new HashMap<String, Boolean>();
            for (HierarchicalConfiguration sub : fields) {
                if (sub.getBoolean(EXTENSION_ENABLED_KEY, true)) continue;
                extensions.put(sub.getString(EXTENSION_NAME_KEY, ""), Boolean.FALSE);
            }
            this.extensionsState = Collections.unmodifiableMap(extensions);
        }
        catch (ConversionException e) {
            LOGGER.error((Object)("Error while loading extensions' state: " + e.getMessage()), (Throwable)e);
            this.extensionsState = Collections.emptyMap();
        }
    }

    public boolean isExtensionEnabled(String extensionName) {
        Boolean state = this.extensionsState.get(extensionName);
        if (state == null) {
            return true;
        }
        return state;
    }

    public Map<String, Boolean> getExtensionsState() {
        return new HashMap<String, Boolean>(this.extensionsState);
    }

    void setExtensionsState(Map<String, Boolean> extensionsState) {
        if (extensionsState == null) {
            throw new IllegalArgumentException("Parameter extensionsState must not be null.");
        }
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_EXTENSIONS_KEY);
        int enabledCount = 0;
        for (Map.Entry<String, Boolean> entry : extensionsState.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || entry.getValue().booleanValue()) continue;
            String elementBaseKey = "extensions.extension(" + enabledCount + ").";
            this.getConfig().setProperty(elementBaseKey + EXTENSION_NAME_KEY, (Object)entry.getKey());
            this.getConfig().setProperty(elementBaseKey + EXTENSION_ENABLED_KEY, (Object)Boolean.FALSE);
            ++enabledCount;
        }
        this.extensionsState = Collections.unmodifiableMap(extensionsState);
    }

    @Override
    public ExtensionParam clone() {
        return (ExtensionParam)super.clone();
    }
}

