/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.dynssl;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.security.CachedSslCertifificateServiceImpl;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.dynssl.DynSSLParam;
import org.zaproxy.zap.extension.dynssl.DynamicSSLPanel;
import org.zaproxy.zap.extension.dynssl.SslCertificateUtils;

public class ExtensionDynSSL
extends ExtensionAdaptor {
    public static final String EXTENSION_ID = "ExtensionDynSSL";
    private DynSSLParam params;
    private DynamicSSLPanel optionsPanel;
    private final Logger logger = Logger.getLogger(ExtensionDynSSL.class);

    public ExtensionDynSSL() {
        this.setName(EXTENSION_ID);
        this.setOrder(54);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("dynssl.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookView().addOptionPanel(this.getOptionsPanel());
        }
        extensionHook.addOptionsParamSet(this.getParams());
    }

    @Override
    public void start() {
        KeyStore rootca = this.getParams().getRootca();
        if (rootca == null) {
            try {
                this.createNewRootCa();
            }
            catch (Exception e) {
                this.logger.error((Object)"Failed to create new root CA certificate:", (Throwable)e);
            }
            return;
        }
        try {
            this.setRootCa(rootca);
        }
        catch (Exception e) {
            this.logger.error((Object)"Couldn't initialize Root CA", (Throwable)e);
        }
        if (this.isCertExpired(this.getRootCaCertificate())) {
            this.warnRooCaCertExpired();
        }
    }

    public void createNewRootCa() throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        this.logger.info((Object)"Creating new root CA certificate");
        KeyStore newrootca = SslCertificateUtils.createRootCA();
        this.setRootCa(newrootca);
        this.getParams().setRootca(newrootca);
        this.logger.info((Object)"New root CA certificate created");
    }

    private DynamicSSLPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new DynamicSSLPanel(this);
        }
        return this.optionsPanel;
    }

    public DynSSLParam getParams() {
        if (this.params == null) {
            this.params = new DynSSLParam();
        }
        return this.params;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("dynssl.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public void setRootCa(KeyStore rootca) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        CachedSslCertifificateServiceImpl.getService().initializeRootCA(rootca);
    }

    public Certificate getRootCA() throws KeyStoreException {
        if (this.getParams().getRootca() == null) {
            return null;
        }
        return this.getParams().getRootca().getCertificate("owasp_zap_root_ca");
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    @Override
    public boolean supportsLowMemory() {
        return true;
    }

    public X509Certificate getRootCaCertificate() {
        try {
            return (X509Certificate)this.getRootCA();
        }
        catch (KeyStoreException e) {
            this.logger.error((Object)"Couldn't get ZAP's Root CA Certificate", (Throwable)e);
            return null;
        }
    }

    private boolean isCertExpired(X509Certificate cert) {
        return cert != null && cert.getNotAfter().before(new Date());
    }

    private void warnRooCaCertExpired() {
        X509Certificate cert = this.getRootCaCertificate();
        if (cert == null) {
            return;
        }
        String warnMsg = Constant.messages.getString("dynssl.warn.cert.expired", cert.getNotAfter().toString(), new Date().toString());
        if (View.isInitialised()) {
            this.getView().showWarningDialog(warnMsg);
        }
        this.logger.warn((Object)warnMsg);
    }
}

