/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;

public class ApiResponseList
extends ApiResponse {
    private List<ApiResponse> list = null;

    public ApiResponseList(String name) {
        super(name);
        this.list = new ArrayList<ApiResponse>();
    }

    public ApiResponseList(String name, ApiResponse[] array) {
        super(name);
        this.list = new ArrayList<ApiResponse>();
        for (ApiResponse resp : array) {
            this.list.add(resp);
        }
    }

    public ApiResponseList(String name, List<ApiResponse> list) {
        super(name);
        this.list = list;
    }

    public void addItem(ApiResponse item) {
        this.list.add(item);
    }

    public List<ApiResponse> getItems() {
        return this.list;
    }

    public Class<? extends ApiResponse> getItemsClass() {
        if (this.list == null || this.list.size() == 0) {
            return null;
        }
        return this.list.get(0).getClass();
    }

    @Override
    public JSON toJSON() {
        if (this.list == null) {
            return null;
        }
        JSONObject jo = new JSONObject();
        JSONArray array = new JSONArray();
        for (ApiResponse resp : this.list) {
            if (resp instanceof ApiResponseElement) {
                array.add((Object)((ApiResponseElement)resp).getValue());
                continue;
            }
            array.add((Object)resp.toJSON());
        }
        jo.put((Object)this.getName(), (Object)array);
        return jo;
    }

    @Override
    public void toXML(Document doc, Element parent) {
        parent.setAttribute("type", "list");
        for (ApiResponse resp : this.list) {
            Element el = doc.createElement(resp.getName());
            resp.toXML(doc, el);
            parent.appendChild(el);
        }
    }

    @Override
    public void toHTML(StringBuilder sb) {
        sb.append("<h2>" + StringEscapeUtils.escapeHtml((String)this.getName()) + "</h2>\n");
        sb.append("<table border=\"1\">\n");
        for (ApiResponse resp : this.list) {
            sb.append("<tr><td>\n");
            resp.toHTML(sb);
            sb.append("</td></tr>\n");
        }
        sb.append("</table>\n");
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append("\t");
        }
        sb.append("ApiResponseList ");
        sb.append(this.getName());
        sb.append(" : [\n");
        for (ApiResponse resp : this.list) {
            sb.append(resp.toString(indent + 1));
        }
        for (int i = 0; i < indent; ++i) {
            sb.append("\t");
        }
        sb.append("]\n");
        return sb.toString();
    }
}

